/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.datacontainer;

import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class SlotDataContainer {
    private String myType = null;
    private String myLdn = null;
    private Integer mySmn = null;
    private Integer myApn = null;
    private ProductNumberAndRevision myOperProductNumberAndRevision = null;
    private ProductNumberAndRevision myPiuTypeProductNumberAndRevision = null;
    private boolean myContainsTrusedPIU;

    public SlotDataContainer(String string, String string2, Integer n, Integer n2, ProductNumberAndRevisionInterface productNumberAndRevisionInterface, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SlotDataContainer(String aType, String aLdn, Integer aSmn, Integer anApn, ProductNumberAndRevisionInterface anOperProductNumberAndRevision, boolean aConstainsTrustedPIU)", "aType: " + string + "\n\taLdn: " + string2 + "\n\taSmn: " + n + "\n\tanApn: " + n2 + "\n\tanOperProductNumberAndRevision: " + productNumberAndRevisionInterface + "\n\taContainsTrustedPIU: " + bl);
        }
        this.myType = string;
        this.myLdn = string2;
        this.mySmn = n;
        this.myApn = n2;
        this.myOperProductNumberAndRevision = this.optimize(productNumberAndRevisionInterface);
        this.myContainsTrusedPIU = bl;
    }

    public SlotDataContainer(String string, String string2, Integer n, Integer n2, ProductNumberAndRevisionInterface productNumberAndRevisionInterface, ProductNumberAndRevisionInterface productNumberAndRevisionInterface2, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SlotDataContainer(String aType, String aLdn, Integer aSmn, Integer anApn, ProductNumberAndRevisionInterface anOperProductNumberAndRevision, ProductNumberAndRevisionInterface aPiuTypeProductNumberAndRevision, boolean aContainsTrustedPIU)", "aType: " + string + "\n\taLdn: " + string2 + "\n\taSmn: " + n + "\n\tanApn: " + n2 + "\n\tanOperProductNumberAndRevision: " + productNumberAndRevisionInterface + "\n\taPiuTypeProductNumberAndRevision: " + productNumberAndRevisionInterface2 + "\n\taContainsTrustedPIU: " + bl);
        }
        this.myType = string;
        this.myLdn = string2;
        this.mySmn = n;
        this.myApn = n2;
        this.myOperProductNumberAndRevision = this.optimize(productNumberAndRevisionInterface);
        this.myPiuTypeProductNumberAndRevision = this.optimize(productNumberAndRevisionInterface2);
        this.myContainsTrusedPIU = bl;
    }

    public String getType() {
        return this.myType;
    }

    public String getLdn() {
        return this.myLdn;
    }

    public Integer getSmn() {
        return this.mySmn;
    }

    public Integer getApn() {
        return this.myApn;
    }

    public ProductNumberAndRevisionInterface getProductNumberAndRevisionInterface() {
        if (this.myPiuTypeProductNumberAndRevision != null) {
            return this.myPiuTypeProductNumberAndRevision;
        }
        if (this.myOperProductNumberAndRevision != null) {
            return this.myOperProductNumberAndRevision;
        }
        return null;
    }

    public boolean containsTrustedPIU() {
        return this.myContainsTrusedPIU;
    }

    public ProductNumberAndRevisionInterface getOperProductNumberAndRevision() {
        return this.myOperProductNumberAndRevision;
    }

    public ProductNumberAndRevisionInterface getPiuTypeProductNumberAndRevision() {
        return this.myPiuTypeProductNumberAndRevision;
    }

    public boolean containsSmnAndApn() {
        return this.mySmn != null && this.myApn != null;
    }

    public String toString() {
        String string = "\n\tmyLdn: " + this.myLdn + "\n\tmyType: " + this.myType + "\n\tmySmn: " + this.mySmn + "\n\tmyApn: " + this.myApn;
        string = this.myOperProductNumberAndRevision != null ? string + "\n\tmyOperProductNumberAndRevision: " + this.myOperProductNumberAndRevision.getProductNumber() + " " + this.myOperProductNumberAndRevision.getRevision() : string + "\n\tmyOperProductNumberAndRevision: " + this.myOperProductNumberAndRevision;
        string = this.myPiuTypeProductNumberAndRevision != null ? string + "\n\tmyPiuTypeProductNumberAndRevision: " + this.myPiuTypeProductNumberAndRevision.getProductNumber() + " " + this.myPiuTypeProductNumberAndRevision.getRevision() : string + "\n\tmyPiuTypeProductNumberAndRevision: " + this.myPiuTypeProductNumberAndRevision;
        string = string + "\n\tmyContainsTrusedPIU: " + this.myContainsTrusedPIU;
        return string;
    }

    private ProductNumberAndRevision optimize(ProductNumberAndRevisionInterface productNumberAndRevisionInterface) {
        ProductNumberAndRevision productNumberAndRevision = null;
        if (productNumberAndRevisionInterface != null) {
            String string = productNumberAndRevisionInterface.getProductNumber();
            string = StringHandler.removeWhiteSpaces(string);
            string = string.toUpperCase();
            String string2 = productNumberAndRevisionInterface.getRevision();
            string2 = StringHandler.removeWhiteSpaces(string2);
            string2 = string2.toUpperCase();
            productNumberAndRevision = new ProductNumberAndRevision(string, string2);
        }
        return productNumberAndRevision;
    }
}

