/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.datacontainer;

import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackProdTypeMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class SubrackDataContainer {
    private Integer myFanConfiguration = null;
    private Integer mySwitchModuleNumber = null;
    private Integer myIntegratedHardware = null;

    public SubrackDataContainer(SubrackMoSU_Access subrackMoSU_Access, Integer n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SubrackDataContainer(SubrackMoBackupRestoreAccess aSubrackMoBackupRestoreAccess) ", "aSubrackMoSU_Access: " + subrackMoSU_Access);
        }
        this.setSwitchModuleNumber(subrackMoSU_Access);
        this.setFanConfiguration(subrackMoSU_Access);
        this.setIntegratedHardware(n);
    }

    public SubrackDataContainer(String string, String string2, String string3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SubrackDataContainer(String aSmn, String aFanConfiguration, String anIntegratedHardware) ", "aSmn: " + string + "\n\taFanConfiguration: " + string2 + "\n\tanIntegratedHardware: " + string3);
        }
        this.mySwitchModuleNumber = new Integer(string);
        this.myFanConfiguration = new Integer(string2);
        this.myIntegratedHardware = new Integer(string3);
    }

    public Integer getFanConfiguration() {
        return this.myFanConfiguration;
    }

    public Integer getSwitchModuleNumber() {
        return this.mySwitchModuleNumber;
    }

    public Integer getIntegratedHardware() {
        return this.myIntegratedHardware;
    }

    public boolean isEqualFanConfiguration(Integer n) {
        if (this.isHPS_Fan(this.myFanConfiguration)) {
            return this.isHPS_Fan(n);
        }
        return !this.isHPS_Fan(n);
    }

    private boolean isHPS_Fan(Integer n) {
        return n != 0 && n != 1;
    }

    private void setSwitchModuleNumber(SubrackMoSU_Access subrackMoSU_Access) {
        try {
            int n = subrackMoSU_Access.getSwitchModuleNumber(null);
            this.mySwitchModuleNumber = new Integer(n);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setSwitchModuleNumber( SubrackMoBackupRestoreAccess aSubrackMoBackupRestoreAccess ) ", "mySwitchModuleNumber set to: " + this.mySwitchModuleNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.warning(this.getClass(), "setSwitchModuleNumber( SubrackMoBackupRestoreAccess aSubrackMoBackupRestoreAccess )", "Exception caught when trying to get SwitchModuleNumber.\n\texception: " + (Object)((Object)moAccessException));
        }
    }

    private void setFanConfiguration(SubrackMoSU_Access subrackMoSU_Access) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setFanConfiguration(SubrackMoSU_Access aSubrackMo )", "aSubrackMo: " + subrackMoSU_Access);
        }
        try {
            SubrackProdTypeMoSU_Access subrackProdTypeMoSU_Access = (SubrackProdTypeMoSU_Access)subrackMoSU_Access.getSubrackProdTypeRef(null);
            if (subrackProdTypeMoSU_Access != null) {
                this.myFanConfiguration = new Integer(subrackProdTypeMoSU_Access.getFanConfiguration(null));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setFanConfiguration(SubrackMoSU_Access aSubrackMo ) ", "Subrack connected to SubrackProdType MO. myFanConfiguration set to: " + this.myFanConfiguration);
                }
            } else if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", (Object)subrackMoSU_Access)) {
                this.myFanConfiguration = new Integer(subrackMoSU_Access.getFanConfigurationFromFro(null));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setFanConfiguration(SubrackMoBackupRestoreAccess aSubrackMoBackupRestoreAccess ) ", "Subrack not connected to SubrackProdType MO. myFanConfiguration set to: " + this.myFanConfiguration);
                }
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.warning(this.getClass(), "setFanConfiguration(SubrackProdTypeMo aSubrackProdTypeMo)", "Exception caught when trying to fetch fanConfiguration from SubrackProdType MO.\n\texception: " + (Object)((Object)moAccessException));
        }
    }

    private void setIntegratedHardware(Integer n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIntegratedHardware(Integer anIntegratedHardware )", "anIntegratedHardware: " + n);
        }
        this.myIntegratedHardware = n;
    }

    private int getIntegratedHardwareValueFromSlots(MoIterator moIterator) throws MoAccessException {
        MoIterator moIterator2 = moIterator;
        int n = 0;
        SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
        while (moIterator2.hasMoreElements()) {
            SlotMoSU_Access slotMoSU_Access;
            ManagedObject managedObject = moIterator2.nextMo();
            if (!(managedObject instanceof SlotMoSU_Access) || !slotMO_HandlerInterface.isSU_VersionSupported("SU_3", slotMoSU_Access = (SlotMoSU_Access)managedObject)) continue;
            n = slotMoSU_Access.getIntegratedHardware(null);
            if (slotMoSU_Access.getIntegratedHardware(null) != 1) continue;
            n = 1;
        }
        return n;
    }
}

