/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.eventhandler;

import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.NotifyingUpgradePackagePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;
import se.ericsson.cello.upgradepackage.main.event.UpgradePackageProperty;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.CalculationOfLMsToBeInstalled;
import se.ericsson.cello.upgradepackage.util.datacontainer.CurrentStepNumberInSequence;
import se.ericsson.cello.upgradepackage.util.datacontainer.InstallExecutedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.InstallFailedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.InstallRequestedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.PreUpgradeSU_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgressHeaderInformationInterface;
import se.ericsson.cello.upgradepackage.util.datacontainer.SoftJvmUpgradeInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TotalNumberOfStepsInSequence;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerInformation;
import se.ericsson.cello.upgradepackage.util.event.EventInformationInterface;
import se.ericsson.cello.upgradepackage.util.eventhandler.EventClientInterface;

public class InstallEventHandler
implements PropertyChangeListener,
TimerListener {
    private EventClientInterface myUpgradePackage = null;
    private int myMaxTimeBetweenInstallEvents = 0;
    private int myTotalSteps = 0;
    private int myCurrentStepCounter = 0;
    private UpgradePackageProperty myLastSentInstallProgressInformation = null;
    private Timer myTimer = null;

    public InstallEventHandler(EventClientInterface eventClientInterface, int n, int n2, int n3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "InstallEventHandler(EventClientInterface anUpgradePackage, boolean anIsEventsToBeSent, int aMaxTimeBetweenEvents, int aTotalSteps, int aCurrentStepCounter)", "anUpgradePackage: " + eventClientInterface + "\n\taMaxTimeBetweenEvents: " + n + "\n\taTotalSteps: " + n2 + "\n\taCurrentStepCounter: " + n3);
        }
        this.myUpgradePackage = eventClientInterface;
        this.myMaxTimeBetweenInstallEvents = n * 60 * 1000;
        this.myTotalSteps = n2;
        this.myCurrentStepCounter = n3;
        this.addAsListener();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof TotalNumberOfStepsInSequence) {
                this.handleInstallProgressPropertyChange((TotalNumberOfStepsInSequence)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof CurrentStepNumberInSequence) {
                this.handleInstallProgressPropertyChange((CurrentStepNumberInSequence)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof PreUpgradeSU_Information) {
                this.handleInstallProgressPropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof CalculationOfLMsToBeInstalled) {
                this.handleInstallProgressPropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof SoftJvmUpgradeInformation) {
                this.handleInstallProgressPropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof TriggerInformation) {
                this.handleInstallProgressPropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof InstallRequestedInformation) {
                this.handleInstallProgressPropertyChange((UpgradePackageProperty)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof InstallExecutedInformation) {
                this.handleInstallProgressPropertyChange((UpgradePackageProperty)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof InstallFailedInformation) {
                this.handleInstallProgressPropertyChange((UpgradePackageProperty)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof ProgressHeaderInformationInterface) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Received property type is ignored,\n\taPropertyChangeEvent: " + propertyChangeEvent + "\n\tNewValue: " + propertyChangeEvent.getNewValue());
                }
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unexpected property type received (ignored),\n\taPropertyChangeEvent: " + propertyChangeEvent + "\n\tNewValue: " + propertyChangeEvent.getNewValue());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught.\n\tThrowable data: " + throwable.toString(), throwable);
        }
    }

    public void stop() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stop( )");
        }
        this.removeAsListener();
        this.myUpgradePackage = null;
        this.myMaxTimeBetweenInstallEvents = 0;
        this.myTotalSteps = 0;
        this.myCurrentStepCounter = 0;
        this.myLastSentInstallProgressInformation = null;
        this.stopTimer();
        this.myTimer = null;
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "stop( )", "The InstallEventHandler has been deactivated.");
        }
    }

    public void timerAction(TimerEvent timerEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "timerAction(TimerEvent aTimerEvent)", "aTimerEvent: " + timerEvent);
        }
        try {
            if (this.myLastSentInstallProgressInformation != null) {
                this.invokeHandleInstallProgressPropertyChange(this.myLastSentInstallProgressInformation);
            } else {
                Trace.info(this.getClass(), "timerAction(TimerEvent aTimerEvent)", "Time out between events and latest sent event is null. Should never happen (ignored).\n\taTimerEvent: " + timerEvent);
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "timerAction(TimerEvent aTimerEvent)", "Throwable caught when receiving a time out indication at event handling (IGNORED).\n\tThrowable data: " + throwable.toString());
        }
    }

    private void addAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener( )");
        }
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.CurrentStepNumberInSequence, this);
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.InstallProgressInformation, this);
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressInformation, this);
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.TotalNumberofStepsInSequence, this);
    }

    private String getExecutingTaskNumber() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExecutingTaskNumber( )");
        }
        if (this.myTotalSteps != 0) {
            return "Executing task number " + this.myCurrentStepCounter + " of " + this.myTotalSteps;
        }
        return "Executing task number " + this.myCurrentStepCounter + " of x";
    }

    private void handleInstallProgressPropertyChange(CurrentStepNumberInSequence currentStepNumberInSequence) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallProgressPropertyChange(CurrentStepNumberInSequence aCurrentStepNumberInSequence)", "aCurrentStepNumberInSequence: " + currentStepNumberInSequence);
        }
        this.myCurrentStepCounter = currentStepNumberInSequence.getValue();
    }

    private void handleInstallProgressPropertyChange(TotalNumberOfStepsInSequence totalNumberOfStepsInSequence) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallProgressPropertyChange(TotalNumberOfStepsInSequence aTotalNumberOfStepsInSequence)", "aTotalNumberOfStepsInSequence: " + totalNumberOfStepsInSequence);
        }
        this.myTotalSteps = totalNumberOfStepsInSequence.getValue();
    }

    private void handleInstallProgressPropertyChange(ProgressHeaderInformationInterface progressHeaderInformationInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallProgressPropertyChange(ProgressHeaderInformationInterface aProgressHeaderInformationInterface)", "aProgressHeaderInformationInterface: " + progressHeaderInformationInterface);
        }
        this.sendEvent(((EventInformationInterface)((Object)progressHeaderInformationInterface)).getEventId(), this.getExecutingTaskNumber());
        this.myLastSentInstallProgressInformation = progressHeaderInformationInterface;
    }

    private void handleInstallProgressPropertyChange(UpgradePackageProperty upgradePackageProperty) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallProgressPropertyChange(UpgradePackageProperty anUpgradePackageProperty)", "anUpgradePackageProperty: " + upgradePackageProperty);
        }
        this.sendEvent(((EventInformationInterface)((Object)upgradePackageProperty)).getEventId(), "");
        this.myLastSentInstallProgressInformation = upgradePackageProperty;
    }

    private void invokeHandleInstallProgressPropertyChange(UpgradePackageProperty upgradePackageProperty) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandleInstallProgressPropertyChange(UpgradePackageProperty anUpgradePackageProperty)", "anUpgradePackageProperty: " + upgradePackageProperty);
        }
        if (upgradePackageProperty instanceof ProgressHeaderInformationInterface) {
            this.handleInstallProgressPropertyChange((ProgressHeaderInformationInterface)upgradePackageProperty);
        } else {
            this.handleInstallProgressPropertyChange(upgradePackageProperty);
        }
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener( )");
        }
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.CurrentStepNumberInSequence, this);
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.InstallProgressInformation, this);
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressInformation, this);
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.TotalNumberofStepsInSequence, this);
    }

    private void sendEvent(int n, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendEvent(int anEventId, String anAdditionalText)", "anEventId: " + n + "\n\tanAdditionalText: " + string);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{};
        try {
            AlarmManager.getReporter().reportEvent(n, (ManagedObject)this.myUpgradePackage, null, string, additionalInfoArray);
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "sendEvent(int anEventId, String anAdditionalText)", "Event has been sent, id=" + n + ", additional text=" + string);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendEvent(int anEventId, String anAdditionalText)", "Event has been sent.\n\tanEventId: " + n + "\n\tanAdditionalText: " + string);
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "sendEvent(int anEventId, String anAdditionalText)", "Failed to send an event due to Throwable was caught (IGNORED).\n\t\tFullDistinguishedName: " + ((ManagedObject)this.myUpgradePackage).getFullDistinguishedName() + "\n\tType eventId: " + ((ManagedObject)this.myUpgradePackage).getType() + " " + n + "\n\tanAdditionalText: " + string + "\n\tThrowable data: " + throwable.toString());
        }
        this.startTimer();
    }

    private void startTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startTimer( )");
        }
        this.stopTimer();
        this.myTimer = new Timer(this.myMaxTimeBetweenInstallEvents);
        this.myTimer.addListener(this);
        this.myTimer.startTimer();
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "startTimer( )", "Time supervision between events has been started (or re-started).");
        }
    }

    private void stopTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopTimer( )");
        }
        if (this.myTimer != null) {
            this.myTimer.removeListener(this);
            this.myTimer.stopTimer();
        }
    }
}

