/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.productinventory.UpSwData;
import se.ericsson.cello.productinventory.UpgradePackageProductData;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringUtils;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StructUtils;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.util.helpers.LoadModulesUtil;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.parser.UpgradePackageSAXdh;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationFailedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationFinishedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationInitiatedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingChecksumForLMsInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingFTC_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingInitConfPIUsInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingJVM_PIUsInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingLM_FilesInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingLM_TypesInSWA_ConnectionsInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingPIUsNotFaultyInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingPIUsSupportedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingPiuTypeConfigOverlappInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingPiuTypeLoadListsInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingPossibleToCreateRequiredNumberOfCVsInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingProgramConsistenciesInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingSlotsOfPIUsConnectedToSWA_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingSubracksSupportedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingUpgradeFromVersionInformation;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class SuLib {
    private static SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);

    public static AttrList clone(AttrList attrList) {
        if (attrList == null) {
            return null;
        }
        AttrListImpl attrListImpl = new AttrListImpl();
        String string = null;
        Object object = null;
        try {
            for (int i = 0; i < attrList.size(); ++i) {
                string = attrList.getName(i);
                object = attrList.getValue(i);
                attrListImpl.addElement(string, object);
            }
            return attrListImpl;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"clone(AttrList anAttrList)", (String)("Throwable caught when trying to clone the AttrList data to an other AttrList.\n\tanAttrList: " + attrList + "\n\ttheName:" + string + "\n\ttheValue:" + object + "\n\tThrowable data: " + throwable.toString()), (Throwable)throwable);
            return attrList;
        }
    }

    public static String convertByteArrayToString(byte[] byArray) {
        UpgradeTrace.debug((Class)SuLib.class, (int)70, (String)"convertByteArrayToString(byte[ ] aByteArray)", (String)("aByteArray: " + byArray));
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if ((char)byArray[i] != '\u0000') continue;
            n = i + 1;
            break;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return new String(cArray).trim();
    }

    public static boolean convertIntToBoolean(int n) {
        UpgradeTrace.debug((Class)SuLib.class, (int)70, (String)"convertIntToBoolean(int anInt)", (String)("anInt: " + n));
        return n != 0;
    }

    public static boolean convertLongToInvertedBoolean(long l) {
        UpgradeTrace.debug((Class)SuLib.class, (int)70, (String)"convertLongToInvertedBoolean(long aLong)", (String)("aLong: " + l));
        return l == 0L;
    }

    public static byte[] convertStringToByteArray(String string, int n) {
        UpgradeTrace.debug((Class)SuLib.class, (int)70, (String)"convertStringToByteArray(String aString, int aByteArrayLength)", (String)("aString: " + string + "\n\taByteArrayLength: " + n));
        byte[] byArray = new byte[n];
        char[] cArray = new char[n];
        int n2 = string.length() <= n ? string.length() : n;
        string.getChars(0, n2, cArray, 0);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static Collection toString(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(SuLib.toString((File)iterator.next()));
        }
        return hashSet;
    }

    public static String toString(File file) {
        return StringUtils.toString(file);
    }

    public static String toString(MoData moData) {
        return "\n\tMoData ldn: " + moData.getLocalDistinguishedName() + "\n\tRevision: " + moData.getRevision() + "\n\tAttributes: " + SuLib.getMoDataAttrsAsString(moData);
    }

    private static String getMoDataAttrsAsString(MoData moData) {
        String string = "";
        Attribute attribute = null;
        Enumeration enumeration = moData.getAllPersistentAttributes();
        while (enumeration.hasMoreElements()) {
            attribute = (Attribute)enumeration.nextElement();
            if (string != "") {
                string = string + ";";
            }
            string = string + "[" + attribute.getName() + ":" + SuLib.getAttrValueAsString(attribute) + "]";
        }
        return string;
    }

    public static String getActiveUP_Information() {
        try {
            UpgradePackageMoExtended upgradePackageMoExtended = ServiceFinder.getConfigurationVersionMO_HandlerInterface().getCurrentUpgradePackage(null);
            if (upgradePackageMoExtended != null) {
                return "\n\t- Document number: " + upgradePackageMoExtended.getDocumentNumber(null) + "\n\t- Document revision: " + upgradePackageMoExtended.getDocumentRevision(null) + "\n\t- Compatibility index: " + upgradePackageMoExtended.getUpCompatibilityIndex(null);
            }
            return "\n\tThere is no active UP on the node";
        }
        catch (Throwable throwable) {
            Trace.info(SuLib.class, "getActiveUP_Information()", "Failed to collect active UP information due to: " + throwable);
            return "\n\tFailed to collect active UP information due to: " + throwable;
        }
    }

    private static String getAttrValueAsString(Attribute attribute) {
        if (attribute instanceof BooleanAttribute) {
            return String.valueOf(((BooleanAttribute)attribute).getValue(null));
        }
        if (attribute instanceof FloatAttribute) {
            return String.valueOf(((FloatAttribute)attribute).getValue(null));
        }
        if (attribute instanceof IntegerAttribute) {
            return String.valueOf(((IntegerAttribute)attribute).getValue(null));
        }
        if (attribute instanceof LongAttribute) {
            return String.valueOf(((LongAttribute)attribute).getValue(null));
        }
        if (attribute instanceof ReferenceAttribute) {
            return ((ReferenceAttribute)attribute).getReferenceAsLDN();
        }
        if (attribute instanceof SequenceAttribute) {
            String string = "[";
            Attribute[] attributeArray = ((SequenceAttribute)attribute).getValue(null);
            for (int i = 0; i < attributeArray.length; ++i) {
                if (string != "[") {
                    string = string + ";";
                }
                string = string + SuLib.getAttrValueAsString(attributeArray[i]);
            }
            return string + "]";
        }
        if (attribute instanceof StringAttribute) {
            return ((StringAttribute)attribute).getValue(null);
        }
        if (attribute instanceof StructAttribute) {
            String string = "[";
            Attribute[] attributeArray = ((StructAttribute)attribute).getElements(null);
            for (int i = 0; i < attributeArray.length; ++i) {
                if (string != "[") {
                    string = string + ";";
                }
                string = string + attributeArray[i].getName() + "," + SuLib.getAttrValueAsString(attributeArray[i]);
            }
            return string + "]";
        }
        return attribute.toString();
    }

    public static String toString(ManagedObject[] managedObjectArray) {
        String string = "[ ";
        try {
            if (managedObjectArray != null) {
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    string = i < managedObjectArray.length - 1 ? string + managedObjectArray[i] + ", " : string + managedObjectArray[i] + " ]";
                }
                if (managedObjectArray.length == 0) {
                    string = string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Exception exception) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Exception caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + string + "\n\tException data: " + exception.toString()), (Throwable)exception);
            return string;
        }
        catch (Error error) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Error caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + string + "\n\tError data: " + error.toString()), (Throwable)error);
            return string;
        }
    }

    public static String toString(AdditionalInfo[] additionalInfoArray) {
        String string = "[";
        try {
            if (additionalInfoArray != null) {
                if (additionalInfoArray.length == 0) {
                    return "[]";
                }
                for (int i = 0; i < additionalInfoArray.length; ++i) {
                    string = i < additionalInfoArray.length - 1 ? string + SuLib.toString(additionalInfoArray[i]) + ",\n" : string + SuLib.toString(additionalInfoArray[i]) + "]";
                }
                return string;
            }
            return "[]";
        }
        catch (Exception exception) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Exception caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + string + "\n\tException data: " + exception.toString()), (Throwable)exception);
            return string;
        }
        catch (Error error) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Error caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + string + "\n\tError data: " + error.toString()), (Throwable)error);
            return string;
        }
    }

    public static String toString(ActionResultData[] actionResultDataArray) {
        String string = "[";
        try {
            if (actionResultDataArray != null) {
                if (actionResultDataArray.length == 0) {
                    return "[]";
                }
                for (int i = 0; i < actionResultDataArray.length; ++i) {
                    string = i < actionResultDataArray.length - 1 ? string + "\n\t" + actionResultDataArray[i].getInformation().getDescription() + "\n\t" + actionResultDataArray[i].getAdditionalInformation() + "\n" : string + "\n\t" + actionResultDataArray[i].getInformation().getDescription() + "\n\t" + actionResultDataArray[i].getAdditionalInformation() + "\n\t]";
                }
            } else {
                return "[]";
            }
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Throwable caught when trying to translate the array of managed objects to a string.\n\tanActionResultDatas: " + actionResultDataArray + "\n\tThrowable data: " + throwable.toString()), (Throwable)throwable);
            return string + "]";
        }
    }

    public static String toString(AdditionalInfo additionalInfo) {
        try {
            return "{ " + additionalInfo.getName() + ", " + additionalInfo.getValue() + " }";
        }
        catch (Exception exception) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Exception caught when trying to translate the AdditionalInfo data to a string.\n\tanAdditionalInfo: " + additionalInfo + "\n\tException data: " + exception.toString()), (Throwable)exception);
            return "{ " + additionalInfo + " }";
        }
        catch (Error error) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Exception caught when trying to translate the AdditionalInfo data to a string.\n\tanAdditionalInfo: " + additionalInfo + "\n\tException data: " + error.toString()), (Throwable)error);
            return "{ " + additionalInfo + " }";
        }
    }

    public static String toString(StringTokenizer stringTokenizer) {
        String string = "";
        try {
            while (stringTokenizer.hasMoreElements()) {
                string = string + stringTokenizer.nextToken();
            }
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(StringTokenizer aStringTokenizer)", (String)("Throwable caught when trying to translate the StringTokenizer to a string.\n\taStringTokenizer: " + stringTokenizer + "\n\ttheStringTokenizerString:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(int[] nArray) {
        String string = "[ ";
        try {
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    string = i < nArray.length - 1 ? string + nArray[i] + ", " : string + nArray[i] + " ]";
                }
                if (nArray.length == 0) {
                    return string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(int[] anIntArray)", (String)("Throwable caught when trying to translate an int Array to a String.\n\tanIntArray: " + nArray + "\n\ttheInts:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(Struct struct) {
        return StructUtils.toString(struct);
    }

    public static String toString(Struct[] structArray) {
        return StructUtils.toString(structArray);
    }

    public static String toString(Coordinator coordinator) {
        String string = "";
        if (coordinator != null) {
            try {
                int n = coordinator.getTransactionID();
                string = string + "\n\t\tTransaction ID: " + n;
                String string2 = "UNKNOWN";
                if (coordinator.getStatus() == Status.ACTIVE) {
                    string2 = "ACTIVE";
                } else if (coordinator.getStatus() == Status.MARKED_ROLLBACK) {
                    string2 = "MARKED_ROLLBACK";
                } else if (coordinator.getStatus() == Status.NO_TRANSACTION) {
                    string2 = "NO_TRANSACTION";
                }
                string = string + "\n\t\tTransaction status: " + string2;
            }
            catch (Exception exception) {
                UpgradeTrace.debug((Class)SuLib.class, (int)72, (String)"toString(Coordinator aCoordinator)", (String)("Exception caught: " + exception.toString()));
                string = string + exception.toString();
            }
            return string;
        }
        return "null";
    }

    public static String toString(AttrList attrList) {
        String string = "[ ";
        try {
            if (attrList == null) {
                return "null";
            }
            for (int i = 0; i < attrList.size(); ++i) {
                string = string + "\n\t" + attrList.getName(i) + ": ";
                string = string + attrList.getValue(i);
                if (i >= attrList.size() - 1) continue;
                string = string + ",";
            }
            string = string + "\n]";
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(AttrList anAttrList)", (String)("Throwable caught when trying to translate the AttrList data to a string.\n\tanAttrList: " + attrList + "\n\ttheString:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(SequenceAttribute sequenceAttribute) {
        String string = "";
        try {
            Enumeration enumeration = sequenceAttribute.elements();
            while (enumeration.hasMoreElements()) {
                StringAttribute stringAttribute = (StringAttribute)enumeration.nextElement();
                string = string + stringAttribute.getValue(null);
            }
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(SequenceAttribute aSeq)", (String)("Throwable caught when trying to translate the SequenceAttribute to a string.\n\taSeq: " + sequenceAttribute + "\n\ttheSeqAttrString:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(String[] stringArray) {
        return StringUtils.toString(stringArray);
    }

    public static String toString(URL[] uRLArray) {
        String string = "[ ";
        try {
            if (uRLArray != null) {
                for (int i = 0; i < uRLArray.length; ++i) {
                    string = i < uRLArray.length - 1 ? string + uRLArray[i] + ", " : string + uRLArray[i] + " ]";
                }
                if (uRLArray.length == 0) {
                    return string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(URL[] anURL_Array)", (String)("Throwable caught when trying to translate an URL Array to a String.\n\tanURL_Array: " + uRLArray + "\n\ttheStrings:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(UpSwData[] upSwDataArray) {
        String string = "[ ";
        try {
            if (upSwDataArray != null) {
                for (int i = 0; i < upSwDataArray.length; ++i) {
                    string = i < upSwDataArray.length - 1 ? string + upSwDataArray[i].productNumber + "\t" + upSwDataArray[i].revision + ", " : string + upSwDataArray[i].productNumber + "\t" + upSwDataArray[i].revision + " ]";
                }
                if (upSwDataArray.length == 0) {
                    return string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(UpSwData[] anUpSwList)", (String)("Throwable caught when trying to translate an UpSwData Array to a String.\n\tanUpSwList: " + upSwDataArray + "\n\ttheUpSwLists:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(UpgradePackageProductData.UpStatus upStatus) {
        String string = "UnknownStatus";
        try {
            if (upStatus != null) {
                if (upStatus.equals(UpgradePackageProductData.PARTIALLY_INSTALLED)) {
                    string = "PARTIALLY_INSTALLED";
                } else if (upStatus.equals(UpgradePackageProductData.INSTALLED)) {
                    string = "INSTALLED";
                } else if (upStatus.equals(UpgradePackageProductData.SYSTEMUSED)) {
                    string = "SYSTEMUSED";
                } else if (upStatus.equals(UpgradePackageProductData.EXECUTING)) {
                    string = "EXECUTING";
                } else if (upStatus.equals(UpgradePackageProductData.ONLYDELETABLE)) {
                    string = "ONLYDELETABLE";
                }
            }
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)SuLib.class, (String)"toString(UpStatus anUP_Status)", (String)("Throwable caught when trying to translate an UpState to a String.\n\tanUP_Status: " + upStatus + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static Vector translateToVector(Object[] objectArray) {
        UpgradeTrace.debug((Class)SuLib.class, (int)70, (String)"translateToVector(Object[] anObjects)", (String)("anObjects: " + objectArray));
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    public static synchronized LinkedList getSubStrings(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(string2, n);
            string3 = SuLib.getSubString(string, n, n2);
            linkedList.addLast(string3);
            n = n2 + 1;
        }
        return linkedList;
    }

    private static String getSubString(String string, int n, int n2) {
        if (n2 != -1) {
            return string.substring(n, n2);
        }
        return string.substring(n);
    }

    public static String toString(Object[] objectArray) {
        if (objectArray instanceof Struct[]) {
            return SuLib.toString((Struct[])objectArray);
        }
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append('[');
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(objectArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void copyUCF(File file, File file2) throws IOException {
        String string = "null";
        if (file != null) {
            string = file.getAbsolutePath();
        }
        String string2 = "null";
        if (file2 != null) {
            string2 = file2.getAbsolutePath();
        }
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "copyUCF(File anFromUCF, File anToUCF)", "anFromUCF: " + string + "\n\tanToUCF: " + string2);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static String createUpgradePackageDocumentId(String string, String string2) {
        String string3;
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "createUpgradePackageDocumentId(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        if ((string3 = string + "_" + string2).length() > 40) {
            string3 = string3.substring(0, 40);
        }
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "createUpgradePackageDocumentId(String aProductNumber, String aProductRevision)", "Returns theDocumentID: " + string3);
        }
        return string3;
    }

    public static String getOriginalUpgradeControlFileName(String string, String string2) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "getOriginalUpgradeControlFileName(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        return UpgradePackageSAXdh.removeSlash(UpgradePackageSAXdh.removeWhiteSpace(string + "_" + string2)) + ".xml" + "Original";
    }

    public static String getUpgradeControlFileName(String string, String string2) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "getUpgradeControlFileName(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        return UpgradePackageSAXdh.removeSlash(UpgradePackageSAXdh.removeWhiteSpace(string + "_" + string2)) + ".xml";
    }

    public static String intArray2String(int[] nArray) {
        int n;
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "intArray2String(int[] aIntArray)", "aIntArray: " + SuLib.toString(nArray));
        }
        char[] cArray = new char[nArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < nArray.length; ++n) {
            cArray[n] = '\u0000';
        }
        n = 0;
        try {
            while (n < nArray.length) {
                while (nArray[n] != 0) {
                    cArray[n] = (char)nArray[n];
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                if (nArray[n] != 0) continue;
                ++n;
                stringBuffer.append(";");
            }
        }
        catch (Exception exception) {
            Trace.error(SuLib.class, "intArray2String(int[] intArray)", "Exception caught when trying to convert an intArray to a readable string,\n\taIntArray: " + SuLib.toString(nArray), exception);
        }
        String string = stringBuffer.toString();
        if (string != null && string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean isSU_SIM() {
        return System.getProperty("SU_SIM") != null;
    }

    public static boolean isUpgradePackageDocumentID_Unique(String string) throws MoAccessException {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "isUpgradePackageDocumentID_Unique(String anUpgradePackageDocumentID)", "anUpgradePackageDocumentID: " + string);
        }
        boolean bl = true;
        try {
            UpgradePackageMoImpl upgradePackageMoImpl = null;
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    String string2;
                    upgradePackageMoImpl = (UpgradePackageMoImpl)moIterator.nextMo();
                    if (upgradePackageMoImpl == null || !string.equals(string2 = SuLib.createUpgradePackageDocumentId(upgradePackageMoImpl.getDocumentNumber(null), upgradePackageMoImpl.getDocumentRevision(null)))) continue;
                    Trace.error(SuLib.class, "isUpgradePackageDocumentID_Unique(String anUpgradePackageDocumentID)", "The Upgrade Package ID (i.e. its product number + '_' + product revision) is more than 40 characters long and \n\tthere exists at least an other upgrade package where the first 40 characters are identical to this one.\n\tThis is not allowed due to it will cause problem at deletion of upgrade packages later on\n\tThis Upgrade Package document ID: " + string + "\n\tConflicting Upgrade Package document ID: " + upgradePackageMoImpl.getUpgradePackageDocumentId(null));
                    bl = false;
                    break;
                }
            }
            return bl;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(SuLib.class, "isUpgradePackageDocumentID_Unique(String anUpgradePackageDocumentID)", "MoAccessException caught when trying to find out if the Upgrade Package Document ID is unique among all other existing Upgrade Package MOs.\n\tThis Upgrade Package document ID: " + string, moAccessException);
            throw moAccessException;
        }
    }

    public static String selectLoadModuleDestinationPath(String string, String string2, String string3) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "selectLoadModuleDestinationPath(String aDestinationPath, String aProductNumberRaw, String aRevisionRaw)", "aDestinationPath: " + string + "\n\taProductNumberRaw: " + string2 + "\n\taRevisionRaw: " + string3);
        }
        return SuLib.selectLoadModuleDestinationAbsolutePath("", string, string2, string3);
    }

    public static String optimize(String string) {
        if (string != null) {
            if (SuLib.containsWhiteSpace(string)) {
                string = SuLib.removeWhiteSpaces(string);
            }
            if (SuLib.containsLowerCase(string)) {
                string = string.toUpperCase();
            }
        }
        return string;
    }

    public static boolean containsWhiteSpace(String string) {
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ') continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsLowerCase(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isLowerCase(string.charAt(i))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String removeWhiteSpaces(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2;
    }

    public static String selectLoadModuleDestinationAbsolutePath(String string, String string2, String string3) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "selectLoadModuleDestinationAbsolutePath(String aDestinationPath, String aProductNumberRaw, String aRevisionRaw)", "aDestinationPath: " + string + "\n\taProductNumberRaw: " + string2 + "\n\taRevisionRaw: " + string3);
        }
        SystemUpgradeConstantsInterface systemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
        return SuLib.selectLoadModuleDestinationAbsolutePath(systemUpgradeConstantsInterface.getNodeDefaultRootPath(), string, string2, string3);
    }

    public static String selectLoadModuleDestinationAbsolutePath(String string, String string2, String string3, String string4) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "selectLoadModuleDestinationAbsolutePath(String aDiskRootPath, String aDestinationPath, String aProductNumberRaw, String aRevisionRaw)", "aDiskRootPath: " + string + "\n\taDestinationPath: " + string2 + "\n\taProductNumberRaw: " + string3 + "\n\taRevisionRaw: " + string4);
        }
        return LoadModulesUtil.selectLoadModuleDestinationAbsolutePath(string, string2, string3, string4);
    }

    public static String selectLoadModuleSourceAbsolutePath(String string, String string2, String string3, String string4, String string5, String string6) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "selectLoadModuleSourceAbsolutePath(String anUpgradeControlFileSourceAbsolutePath, String anInstallUpRootSourcePath, String aSourcePath, String anInstallUpDefaultSourceLmPath, String aProductNumberRaw, String aRevisionRaw)", "anUpgradeControlFileSourceAbsolutePath: " + string + "\n\tanInstallUpRootSourcePath: " + string2 + "\n\taSourcePath: " + string3 + "\n\tanInstallUpDefaultSourceLmPath: " + string4 + "\n\taProductNumberRaw: " + string5 + "\n\taRevisionRaw: " + string6);
        }
        return LoadModulesUtil.selectLoadModuleSourceAbsolutePath(string, string2, string3, string4, string5, string6);
    }

    public static String getReplicatedFilePath(String string) throws SU_ConditionalException {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "getReplicatedFilePath(String aLoadModuleFilePath)", "aLoadModuleFilePath: " + string);
        }
        if (string.startsWith(mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath())) {
            string = mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + string.substring(mySystemUpgradeConstantsInterface.getNodeDefaultRootPath().length());
        } else if (string.startsWith(mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) {
            string = mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + mySystemUpgradeConstantsInterface.getXbReplicatedFilePath() + string.substring(mySystemUpgradeConstantsInterface.getXbInstallLmRootPath().length());
        } else if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_2", (Object)mySystemUpgradeConstantsInterface) && string.startsWith(mySystemUpgradeConstantsInterface.getCertCrlInstallLmRootPath())) {
            string = mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + string.substring(mySystemUpgradeConstantsInterface.getNodeDefaultRootPath().length());
        }
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "getReplicatedFilePath(String aLoadModuleFilePath)", "RETURNS - aLoadModuleFilePath: " + string);
        }
        return string;
    }

    public static String toString(GenericProgramBase genericProgramBase) {
        String string = "";
        if (genericProgramBase != null) {
            try {
                LoadModuleMoSU_Access loadModuleMoSU_Access = (LoadModuleMoSU_Access)genericProgramBase.getLoadModule(null);
                Struct struct = loadModuleMoSU_Access.getProductData(null);
                string = string + "\n\tThe generic program: " + genericProgramBase + "\n\tThe programs Load Module: " + SuLib.toString(struct);
            }
            catch (Exception exception) {
                if (Trace.valid(SuLib.class, 20)) {
                    Trace.debug(SuLib.class, 20, "toString(GenericProgramBase aGenericProgram)", "Exception caught: " + exception.toString());
                }
                string = string + exception.toString();
            }
        }
        return string;
    }

    public static int translateActionIdForVerifyToProgressHeader(int n) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "translateActionIdForVerifyToProgressHeader(int anActionIdValue)", "anActionIdValue: " + n);
        }
        if (n == 884) {
            return 15;
        }
        if (n == 880) {
            return 19;
        }
        if (n == 882) {
            return 17;
        }
        if (n == 879) {
            return 20;
        }
        if (n == 881) {
            return 18;
        }
        if (n == 883) {
            return 16;
        }
        if (n == 867) {
            return 40;
        }
        if (n == 869) {
            return 38;
        }
        if (n == 868) {
            return 39;
        }
        if (n == 870) {
            return 41;
        }
        if (n == 865) {
            return 42;
        }
        if (n == 864) {
            return 44;
        }
        if (n == 863) {
            return 45;
        }
        if (n == 993) {
            return 22;
        }
        if (n == 878) {
            return 21;
        }
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "translateActionIdForVerifyToProgressHeader()", "Assuming AID value is equal to ProgressHeader value.");
        }
        return n;
    }

    public static VerificationInformation translateActionIdToVerificationInformation(int n, Object object) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "translateActionIdToVerificationInformation(int anActionIdValue, Object aSource)", "anActionIdValue: " + n + "\n\taSource: " + object);
        }
        if (n == 884) {
            return new VerificationInitiatedInformation(object);
        }
        if (n == 880) {
            return new VerifyingChecksumForLMsInformation(object);
        }
        if (n == 882) {
            return new VerifyingPossibleToCreateRequiredNumberOfCVsInformation(object);
        }
        if (n == 879) {
            return new VerifyingPIUsNotFaultyInformation(object);
        }
        if (n == 881) {
            return new VerifyingPIUsSupportedInformation(object);
        }
        if (n == 883) {
            return new VerifyingUpgradeFromVersionInformation(object);
        }
        if (n == 867) {
            return new VerifyingFTC_Information(object);
        }
        if (n == 869) {
            return new VerifyingInitConfPIUsInformation(object);
        }
        if (n == 868) {
            return new VerifyingJVM_PIUsInformation(object);
        }
        if (n == 870) {
            return new VerifyingLM_FilesInformation(object);
        }
        if (n == 865) {
            return new VerifyingSubracksSupportedInformation(object);
        }
        if (n == 864) {
            return new VerifyingSlotsOfPIUsConnectedToSWA_Information(object);
        }
        if (n == 863) {
            return new VerifyingLM_TypesInSWA_ConnectionsInformation(object);
        }
        if (n == 993) {
            return new VerificationFailedInformation(object);
        }
        if (n == 878) {
            return new VerificationFinishedInformation(object);
        }
        if (n == 46) {
            return new VerifyingPiuTypeLoadListsInformation(object);
        }
        if (n == 43) {
            return new VerifyingPiuTypeConfigOverlappInformation(object);
        }
        if (n == 47) {
            return new VerifyingProgramConsistenciesInformation(object);
        }
        return null;
    }

    public static String translateActionIdValueToString(int n) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "translateActionIdValueToString(int anActionIdValue)", "anActionIdValue: " + n);
        }
        try {
            if (n == 891) {
                return "Store JVM PIU";
            }
            if (n == 892) {
                return "Insufficient disk space";
            }
            if (n == 893) {
                return "Update progress header";
            }
            if (n == 894) {
                return "AUE returned failure";
            }
            if (n == 895) {
                return "IP address error";
            }
            if (n == 896) {
                return "FTP server error";
            }
            if (n == 897) {
                return "Get file error";
            }
            if (n == 898) {
                return "Upgrade package file error";
            }
            if (n == 990) {
                return "Upgrade finished";
            }
            if (n == 991) {
                return "Confirm timer set";
            }
            if (n == 992) {
                return "Install finished";
            }
            if (n == 993) {
                return "Exception";
            }
            if (n == 995) {
                return "Node restart requested";
            }
            if (n == 996) {
                return "Wait for confirmation during upgrade";
            }
            if (n == 997) {
                return "Increment progress counter";
            }
            if (n == 998) {
                return "Set total progress counter";
            }
            if (n == 999) {
                return "New step label";
            }
            if (n == 874) {
                return "Creation of Configuration Version failed";
            }
            if (n == 875) {
                return "Unspecified";
            }
            if (n == 877) {
                return "Saving Configuration Version, wait....";
            }
            if (n == 878) {
                return "Verification of upgrade package finished";
            }
            if (n == 879) {
                return "Verifying PIUs not faulty";
            }
            if (n == 880) {
                return "Verifying checksum of load modules";
            }
            if (n == 881) {
                return "Verifying PIUs supported";
            }
            if (n == 882) {
                return "Verifying possible to create required number of CVs";
            }
            if (n == 883) {
                return "Verifying upgrade from version allowed";
            }
            if (n == 884) {
                return "Verification of upgrade package initiated";
            }
            if (n == 863) {
                return "Verifying LM types in SWA connections";
            }
            if (n == 864) {
                return "Verifying Slots of PIUs connected to SWA";
            }
            if (n == 865) {
                return "Verifying subracks supported";
            }
            if (n == 867) {
                return "Verifying Fault Tolerant Core (FTC) states";
            }
            if (n == 868) {
                return "Verifying JVM MP(s) operational";
            }
            if (n == 869) {
                return "Verifying initial configured PIUs supported";
            }
            if (n == 870) {
                return "Verifying load module files installed";
            }
            if (n == 885) {
                return "Node restart warning";
            }
            if (n == 886) {
                return "Trigger FINISH is in execution";
            }
            if (n == 856) {
                return "Installation of LM files finished when merge of delta UCF failed";
            }
            if (n == 887) {
                return "An ongoing installation has been cancelled";
            }
            if (n == 888) {
                return "Cancel of an ongoing installation is executing";
            }
            if (n == 889) {
                return "Cancel of an ongoing installation failed";
            }
            if (n == 890) {
                return "Load list error";
            }
            if (n == 861) {
                return "Calculation of load modules to be installed";
            }
            if (n == 860) {
                return "Validation of UCF failed";
            }
            if (n == 859) {
                return "Initialization of attributes in the UP MO failed";
            }
            if (n == 852) {
                return "UCF checksum problems detected";
            }
            return "Unexpected Value = " + n;
        }
        catch (Exception exception) {
            Trace.error(SuLib.class, "translateActionIdValueToString(int anActionIdValue)", "Exception caught when trying to translate the action ID to a readable string,\n\tAction ID value: " + n, exception);
            return "Unexpected Value = " + n;
        }
    }

    public static String translateProgressHeaderValueToString(int n) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "translateProgressHeaderValueToString(int aProgressHeaderValue)", "aProgressHeaderValue: " + n);
        }
        try {
            if (n == 0) {
                return "Idle";
            }
            if (n == 1) {
                return "Downloading files";
            }
            if (n == 2) {
                return "Saving configuration version";
            }
            if (n == 3) {
                return "Reconfiguring MOs according to the Upgrade Control File (UCF)";
            }
            if (n == 4) {
                return "Executing trigger Initiate";
            }
            if (n == 5) {
                return "Executing trigger Preload";
            }
            if (n == 6) {
                return "Executing trigger Convert";
            }
            if (n == 7) {
                return "Executing an application unique trigger";
            }
            if (n == 8) {
                return "The node is to be restarted";
            }
            if (n == 9) {
                return "Executing trigger Execute";
            }
            if (n == 10) {
                return "Executing trigger Finish";
            }
            if (n == 11) {
                return "The execution mode is switched back to normal mode";
            }
            if (n == 12) {
                return "Execution failed";
            }
            if (n == 13) {
                return "Cancellation of an ongoing installation is ongoing";
            }
            if (n == 14) {
                return "Execution of a cancel install action failed";
            }
            if (n == 15) {
                return "The verification phase has been initiated";
            }
            if (n == 16) {
                return "Verifying that the upgrade window defined in the Upgrade Control File allows an upgrade";
            }
            if (n == 17) {
                return "Verifying that it is possible to create the required number of CV's during the upgrade phase";
            }
            if (n == 18) {
                return "Verifying that the used PIUs in the node are supported according to the Upgrade Control File";
            }
            if (n == 19) {
                return "Verifying the checksum for all load modules that has checksum value defined in the Upgrade Control File";
            }
            if (n == 20) {
                return "Verifying that Plug In Units (PIUs) on the node are not faulty before the upgrade is initiated";
            }
            if (n == 21) {
                return "The verification phase is finished";
            }
            if (n == 22) {
                return "The verification phase has failed";
            }
            if (n == 23) {
                return "Java Virtual Machine (JVM) restart requested";
            }
            if (n == 24) {
                return "The upgrade phase is initiated and the system state is set to upgrade mode";
            }
            if (n == 25) {
                return "Reboot PIU upgrade requested (one or several PIUs are to be upgraded)";
            }
            if (n == 26) {
                return "Soft PIU upgrade requested (a number of load mdoules are started, stopped or upgraded)";
            }
            if (n == 27) {
                return "One or several program are added and/ or removed";
            }
            if (n == 28) {
                return "Node upgrade requested";
            }
            if (n == 38) {
                return "Verifying that initial configured PIUs (with programs) are supported by the Upgrade Package (in UCF) and that all load modules referenced in programs are valid";
            }
            if (n == 39) {
                return "Verifying that the JVM MP(s) is operational";
            }
            if (n == 40) {
                return "Verifying the Fault Tolerant Core (FTC) states";
            }
            if (n == 41) {
                return "Verifying that all required load module files are installed for supported PIUs according to the Upgrade Control File";
            }
            if (n == 42) {
                return "Verifying that the subracks in the node are supported according to the Upgrade Control File";
            }
            if (n == 43) {
                return "Verifying that SwAllocations connected to the same slot do not define the same PiuType.";
            }
            if (n == 44) {
                return "Verifying that Slots of PIUs are connected to an SwAllocation";
            }
            if (n == 45) {
                return "Verifying that certain types of Managed Objects will be connected (via SwAllocations) to Repertoires referencing allowed types of Load Modules";
            }
            if (n == 46) {
                return "Verifying that all Repertoires in a SwAllocation support the same set of PiuTypes.";
            }
            if (n == 47) {
                return "Verifying that programs that will exist in TO state are specified in a consistent manner (by combining UCF data and node configuration data).";
            }
            if (n == 53) {
                return "Validating the Upgrade Control File (UCF)";
            }
            if (n == 54) {
                return "Updating attributes in UpgradePackage MO with definitions from Upgrade Control File (UCF)";
            }
            if (n == 55) {
                return "Calculation of the LM files to be installed is in progress.";
            }
            return "Unexpected value = " + n;
        }
        catch (Exception exception) {
            Trace.error(SuLib.class, "translateProgressHeaderValueToString(int aProgressHeaderValue)", "Exception caught when trying to translate a progress header to a readable string,\n\tProgress header value: " + n, exception);
            return "Unexpected Value = " + n;
        }
    }

    public static String translateStateValueToString(int n) {
        if (Trace.valid(SuLib.class, 20)) {
            Trace.debug(SuLib.class, 20, "translateStateValueToString(int aStateValue)", "aStateValue: " + n);
        }
        try {
            if (n == 0) {
                return "Not installed";
            }
            if (n == 1) {
                return "Install completed";
            }
            if (n == 2) {
                return "Upgrade executing";
            }
            if (n == 3) {
                return "Awaiting confirm";
            }
            if (n == 4) {
                return "Only deletable";
            }
            if (n == 5) {
                return "Install executing";
            }
            if (n == 6) {
                return "Install not completed";
            }
            if (n == 7) {
                return "Upgrade completed";
            }
            if (n == 8) {
                return "SU Downgrade executing";
            }
            if (n == 9) {
                return "Verify executing";
            }
            if (n == 10) {
                return "Waiting for resume";
            }
            return "Unexpected value = " + n;
        }
        catch (Exception exception) {
            Trace.error(SuLib.class, "translateStateValueToString(int aStateValue)", "Exception caught when trying to translate a state to a readable string,\n\tState value: " + n, exception);
            return "Unexpected Value = " + n;
        }
    }
}

