/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.loadmodule;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.LoaderName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevisionSSW;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_OseProgramLoadClassValue;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.loadmodule.InstallSMInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.InstallLM_Container;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access1;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleRefInfo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.piutypesupervisor.PiuTypeInstallStateSupervisor;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.updatelms.UpdateLM_DataException;
import se.ericsson.cello.upgradepackage.util.enumer.LoadModuleState;
import se.ericsson.cello.upgradepackage.util.handler.LoadModuleProgramInformation;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapter;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.CreateLoadModuleException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.ExtractIdentifiersOfNonExistingLoadModulesException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModulesStates;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.ReserveLoadModulesException;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleRefLDN_Information;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class LoadModuleMO_Handler
implements LoadModuleMO_HandlerInterface {
    private boolean myDoStateUpdateInAllPiuTypes = false;
    private boolean myIsLoadModuleMoMapToBeUsed = false;
    private HashMap myLoadModuleMoMap = null;
    private static final String EMPTY_STRING = "";
    private static final int NO_VALUE = -1;
    private static final String RUNNING_SW_FRONTSLASH = "runningSW/";
    private static final int LENGTH_OF_RUNNING_SW_FRONTSLASH = "runningSW/".length();

    public LoadModuleMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "LoadModuleMO_Handler (MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public boolean contains(LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray, LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray2) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "contains(LoadModuleMoSU_Access[] aMasterLMs, LoadModuleMoSU_Access[] anOtherLMs)", "aMasterLMs: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray) + "\n\tanOtherLMs: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray2));
        }
        try {
            if (loadModuleMoSU_AccessArray == null || loadModuleMoSU_AccessArray2 == null) {
                return false;
            }
            boolean bl = true;
            for (int i = 0; i < loadModuleMoSU_AccessArray2.length; ++i) {
                if (this.contains(loadModuleMoSU_AccessArray2[i], loadModuleMoSU_AccessArray)) continue;
                bl = false;
                break;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "contains(LoadModuleMoSU_Access[] aMasterLMs, LoadModuleMoSU_Access[] anOtherLMs)", "RETURNS - theIsContains: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "contains(LoadModuleMoSU_Access[] aMasterLMs, LoadModuleMoSU_Access[] anOtherLMs)", "Throwable caught.\n\taMasterLMs: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray) + "\n\tanOtherLMs: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray2), throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public boolean contains(LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray, Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "contains(LoadModuleMoSU_Access[] aMasterLMs, Collection aProductNumberAndRevisionsExists)", "aMasterLMs: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray) + "\n\taProductNumberAndRevisionsExists: " + collection);
        }
        try {
            if (loadModuleMoSU_AccessArray == null) {
                return false;
            }
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            for (int i = 0; i < loadModuleMoSU_AccessArray.length; ++i) {
                linkedList.add(loadModuleMoSU_AccessArray[i]);
            }
            Collection collection2 = this.getProductNumberAndRevisionsForLoadModules(linkedList);
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions(new Vector(collection2));
            Iterator iterator = collection.iterator();
            boolean bl = true;
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            while (iterator.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
                if (productNumbersAndRevisions.contains(productNumberAndRevisionInterface)) continue;
                bl = false;
                break;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "contains(LoadModuleMoSU_Access[] aMasterLMs, Collection aProductNumberAndRevisionsExists)", "RETURNS - theIsContains: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "contains(LoadModuleMoSU_Access[] aMasterLMs, Collection aProductNumberAndRevisionsExists)", "Throwable caught.\n\taMasterLMs: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray) + "\n\taProductNumberAndRevisionsExists: " + collection, throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public boolean contains(LoadModuleMoSU_Access loadModuleMoSU_Access, LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "contains(LoadModuleMoSU_Access aLM, LoadModuleMoSU_Access[] anMasterLMs)", "aLM: " + loadModuleMoSU_Access + "\n\tanMasterLMs: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray));
        }
        try {
            boolean bl = false;
            for (int i = 0; i < loadModuleMoSU_AccessArray.length; ++i) {
                if (!loadModuleMoSU_AccessArray[i].equals(loadModuleMoSU_Access)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "contains(LoadModuleMoSU_Access[] aMasterLMs, LoadModuleMoSU_Access[] anOtherLMs)", "Throwable caught.\n\taMasterLMs: " + loadModuleMoSU_Access + "\n\tanOtherLMs: " + SuLib.toString((ManagedObject[])loadModuleMoSU_AccessArray), throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public boolean contains(LoadModuleMoSU_Access loadModuleMoSU_Access, ManagedObject[] managedObjectArray) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "contains(LoadModuleMoSU_Access aLM, ManagedObject[] anMasterLMs)", "aLM: " + loadModuleMoSU_Access + "\n\tanMasterLMs: " + SuLib.toString(managedObjectArray));
        }
        try {
            boolean bl = false;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].equals(loadModuleMoSU_Access)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "contains(LoadModuleMoSU_Access[] aMasterLMs, ManagedObject[] anOtherLMs)", "Throwable caught.\n\taMasterLMs: " + loadModuleMoSU_Access + "\n\tanOtherLMs: " + SuLib.toString(managedObjectArray), throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public void createLoadModule(ProductNumberAndRevision productNumberAndRevision, DocumentObjectProxyInterface documentObjectProxyInterface, String string) throws CreateLoadModuleException {
        String string2 = "createLoadModule(ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxy, String anUpgradeControlFileAbsoluteSourceFilePath)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string2, "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanUpgradeControlFileAbsoluteSourceFilePath: " + string);
        }
        Control control = null;
        try {
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            LoadModuleMoSU_Access loadModuleMoSU_Access = this.createLoadModuleMO(productNumberAndRevision, documentObjectProxyInterface, string, coordinator);
            try {
                this.setFileState(loadModuleMoSU_Access, coordinator);
            }
            catch (IllegalAttributeValueException illegalAttributeValueException) {
                Trace.warning(this.getClass(), string2, "Failed to set the fileState to Installed due to the LM file didn't exist in the path defined in the LM MO's loadModuleFilePath attribute i.e. it is a missmatch between the LM MO configuration and the path specified in the UCF.Load Module MO: " + loadModuleMoSU_Access + "\n\tLoad module file path defined in LM MO: " + loadModuleMoSU_Access.getLoadModuleFilePath(coordinator) + "\n\tThe product number and revision of LM: " + productNumberAndRevision);
            }
            Transaction.commit(control);
        }
        catch (CreateLoadModuleException createLoadModuleException) {
            Transaction.rollback(control);
            throw createLoadModuleException;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            Transaction.rollback(control);
            throw new CreateLoadModuleException(loadModuleMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string2, "Throwable caught.\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanUpgradeControlFileAbsoluteSourceFilePath: " + string, throwable);
            Transaction.rollback(control);
            throw new CreateLoadModuleException("Class name: " + this.getClass().getName() + "\n\t" + string2 + "\n\tThrowable caught." + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanUpgradeControlFileAbsoluteSourceFilePath: " + string + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Vector extractIdentifiersOfNonExistingLoadModules(Vector vector) throws ExtractIdentifiersOfNonExistingLoadModulesException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "extractIdentifiersOfNonExistingLoadModules(Vector aLoadModuleIdentifiers)", "aLoadModuleIdentifiers: " + vector);
        }
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator != null) {
                if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null) continue;
                        vector = this.removeLoadModuleIdentifierFromList(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null), vector);
                    }
                } else {
                    Struct struct = null;
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null) continue;
                        struct = loadModuleMoSU_Access.getProductData(null);
                        vector = this.removeLoadModuleIdentifierFromList(StringHandler.optimize((String)struct.getValue("productNumber")), StringHandler.optimize((String)struct.getValue("productRevision")), vector);
                    }
                }
            }
            return vector;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "extractIdentifiersOfNonExistingLoadModules(Vector aLoadModuleIdentifiers)", "Exception caught when trying to extract the identifiers of non existing Load Modules from a list,\n\taLoadModuleIdentifiers: " + vector, exception);
            throw new ExtractIdentifiersOfNonExistingLoadModulesException("Exception caught when trying to extract the identifiers of non existing Load Modules from a list,\n\taLoadModuleIdentifiers: " + vector + "\n\tOriginal Exception: " + exception.toString());
        }
    }

    public Collection extractRefsToMatchingLoadModules(Collection collection, Collection collection2) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "extractRefsToMatchingLoadModules(Collection aProductNumberAndRevisionsInterfaces, Collection aLoadModuleMoSU_Accesses)", "aProductNumberAndRevisionsInterfaces: " + collection + "\n\taLoadModuleMoSU_Accesses: " + collection2);
        }
        try {
            LinkedList<ProductNumberAndRevisionInterface> linkedList = new LinkedList<ProductNumberAndRevisionInterface>();
            Collection collection3 = this.getProductNumberAndRevisionsForLoadModules(collection2);
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions(new Vector(collection3));
            Iterator iterator = collection.iterator();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            while (iterator.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
                if (!productNumbersAndRevisions.contains(productNumberAndRevisionInterface)) continue;
                linkedList.add(productNumberAndRevisionInterface);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "extractRefsToMatchingLoadModules(Collection aProductNumberAndRevisionsInterfaces, Collection aLoadModuleMoSU_Accesses)", "RETURNS - theExtractedRefsToMatchingLMs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "extractRefsToMatchingLoadModules(Collection aProductNumberAndRevisionsInterfaces, Collection aLoadModuleMoSU_Accesses)", "Throwable caught.\n\taProductNumberAndRevisionsInterfaces: " + collection + "\n\taLoadModuleMoSU_Accesses: " + collection2, throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public Collection getFilePathsForLoadModules(Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFilePathsForLoadModules(Collection aLoadModules)", "aLoadModules: " + collection);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                linkedList.add(loadModuleMoSU_Access.getLoadModuleFilePath(null));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getFilePathsForLoadModulesOfType(Collection aLoadModules)", "RETURNS - " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getFilePathsForLoadModulesOfType(Collection aLoadModules)", "Throwable caught when collecting file paths for load modules.\n\taLoadModules: " + collection, throwable);
            throw new LoadModuleMO_HandlerException("Throwable caught when collecting load modules.\n\taLoadModules: " + collection + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public Collection getFilePathsForLoadModulesOfType(ManagedObject[] managedObjectArray, int n) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFilePathsForLoadModulesOfType(ManagedObject[] aLoadModules, int aLoaderType)", "aLoadModules: " + SuLib.toString(managedObjectArray) + "\n\tLength of aLoadModules: " + managedObjectArray.length + "\n\taLoaderType: " + n);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            ManagedObject[] managedObjectArray2 = this.getLoadModulesOfType(managedObjectArray, n);
            for (int i = 0; i < managedObjectArray2.length; ++i) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)managedObjectArray2[i];
                linkedList.add(loadModuleMoSU_Access.getLoadModuleFilePath(null));
            }
            return linkedList;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            Trace.error(this.getClass(), "getFilePathsForLoadModulesOfType(ManagedObject[] aLoadModules, int aLoaderType)", "LoadModuleMO_HandlerException caught when collecting file paths for load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoaderType: " + n, (Throwable)((Object)loadModuleMO_HandlerException));
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getFilePathsForLoadModulesOfType(ManagedObject[] aLoadModules, int aLoaderType)", "Throwable caught when collecting file paths for load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoaderType: " + n, throwable);
            throw new LoadModuleMO_HandlerException("Throwable caught when collecting load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoaderType: " + n + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public Collection getFilePathsForLoadModulesOfType(ManagedObject[] managedObjectArray, int n, String string) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType, String anOtherLoaderName, String anOtherLoaderName)", "aLoadModules: " + SuLib.toString(managedObjectArray) + "\n\tLength of aLoadModules: " + managedObjectArray.length + "\n\taLoaderType: " + n + "\n\tanOtherLoaderName: " + string);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        String string2 = null;
        try {
            ManagedObject[] managedObjectArray2 = this.getLoadModulesOfType(managedObjectArray, n);
            for (int i = 0; i < managedObjectArray2.length; ++i) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)managedObjectArray2[i];
                string2 = loadModuleMoSU_Access.getOtherLoaderName(null);
                if (!string2.equals(string)) continue;
                linkedList.add(loadModuleMoSU_Access.getLoadModuleFilePath(null));
            }
            return linkedList;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            Trace.error(this.getClass(), "getFilePathsForLoadModulesOfType(ManagedObject[] aLoadModules, int aLoaderType, String anOtherLoaderName)", "LoadModuleMO_HandlerException caught when collecting file paths for load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoaderType: " + n + "\n\tanOtherLoaderName: " + string, (Throwable)((Object)loadModuleMO_HandlerException));
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getFilePathsForLoadModulesOfType(ManagedObject[] aLoadModules, int aLoaderType, String anOtherLoaderName)", "Throwable caught when collecting file paths for load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoaderType: " + n + "\n\tanOtherLoaderName: " + string, throwable);
            throw new LoadModuleMO_HandlerException("Throwable caught when collecting load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoaderType: " + n + "\n\tanOtherLoaderName: " + string + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public LoadModuleMoSU_Access getLoadModule(String string, String string2) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModule(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        if (this.myIsLoadModuleMoMapToBeUsed) {
            return this.getLoadModuleMoFromMap(string, string2);
        }
        try {
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access2 = null;
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator != null) {
                if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null || !loadModuleMoSU_Access.getProductNumberOpt(null).equals(string) || !loadModuleMoSU_Access.getProductRevisionOpt(null).equals(string2)) continue;
                        loadModuleMoSU_Access2 = loadModuleMoSU_Access;
                        break;
                    }
                } else {
                    String string3 = null;
                    String string4 = null;
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null || !(string3 = StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null))).equalsIgnoreCase(StringHandler.optimize(string)) || !(string4 = StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null))).equalsIgnoreCase(StringHandler.optimize(string2))) continue;
                        loadModuleMoSU_Access2 = loadModuleMoSU_Access;
                        break;
                    }
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModule(String aProductNumber, String aProductRevision)", "RETURNS - theRequestedLoadModuleMO: " + loadModuleMoSU_Access2);
            }
            return loadModuleMoSU_Access2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModule(String aProductNumber, String aProductRevision)", "Throwable caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getLoadModule(String aProductNumber, String aProductRevision)" + "\n\tThrowable caught." + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
    }

    public LoadModuleMoSU_Access getLoadModule(ProductNumberAndRevisionInterface productNumberAndRevisionInterface) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModule(ProductNumberAndRevisionInterface aProductNumberAndRevison)", "aProductNumberAndRevison: " + productNumberAndRevisionInterface);
        }
        if (this.myIsLoadModuleMoMapToBeUsed) {
            return this.getLoadModuleMoFromMap(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
        }
        try {
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access2 = null;
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator != null) {
                if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null || !loadModuleMoSU_Access.getProductNumberOpt(null).equals(productNumberAndRevisionInterface.getProductNumber()) || !loadModuleMoSU_Access.getProductRevisionOpt(null).equals(productNumberAndRevisionInterface.getRevision())) continue;
                        loadModuleMoSU_Access2 = loadModuleMoSU_Access;
                        break;
                    }
                } else {
                    String string = null;
                    String string2 = null;
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null || !(string = StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null))).equals(productNumberAndRevisionInterface.getProductNumber()) || !(string2 = StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null))).equals(productNumberAndRevisionInterface.getRevision())) continue;
                        loadModuleMoSU_Access2 = loadModuleMoSU_Access;
                        break;
                    }
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModule(ProductNumberAndRevisionInterface aProductNumberAndRevison)", "RETURNS - theRequestedLoadModuleMO: " + loadModuleMoSU_Access2);
            }
            return loadModuleMoSU_Access2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModule(ProductNumberAndRevisionInterface aProductNumberAndRevison)", "Throwable caught.\n\taProductNumberAndRevison: " + productNumberAndRevisionInterface, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getLoadModule(ProductNumberAndRevisionInterface aProductNumberAndRevison)" + "\n\tThrowable caught." + "\n\taProductNumberAndRevison: " + productNumberAndRevisionInterface);
        }
    }

    public LoadModuleMoSU_Access[] getLoadModuleMosArray(Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesArray(Collection aProductNumberAndRevisionInterfaces)", "aProductNumberAndRevisionInterfaces: " + collection);
        }
        try {
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = new LoadModuleMoSU_Access[collection.size()];
            Iterator iterator = collection.iterator();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            int n = 0;
            while (iterator.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
                loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
                if (loadModuleMoSU_Access != null) {
                    loadModuleMoSU_AccessArray[n] = loadModuleMoSU_Access;
                    ++n;
                    continue;
                }
                Trace.error(this.getClass(), "getLoadModulesArray(Collection aProductNumberAndRevisionInterfaces)", "aProductNumberAndRevisionInterfaces: " + collection + "\n\tThrowable caught.");
                throw new LoadModuleMO_HandlerException("Couldn't look up the LM MO that corresponds to the product data:" + productNumberAndRevisionInterface);
            }
            return loadModuleMoSU_AccessArray;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLoadModulesArray(Collection aProductNumberAndRevisionInterfaces)", "Throwable caught.\n\taProductNumberAndRevisionInterfaces: " + collection + "\n\tThrowable: " + throwable);
            }
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public Collection getLoadModules(Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModules (Collection aProductNumberAndRevisionsOfAllLMs)", "aProductNumberAndRevisionsOfAllLMs: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            while (iterator.hasNext()) {
                linkedList.add(this.getLoadModule((ProductNumberAndRevision)iterator.next()));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModules (Collection aProductNumberAndRevisionsOfAllLMs)", "RETURNS - " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLoadModules (Collection aProductNumberAndRevisionsOfAllLMs)", "Throwable caught.\n\taProductNumberAndRevisionsOfAllLMs: " + collection + "\n\tThrowable: " + throwable);
            }
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "Method: getLoadModules (Collection aProductNumberAndRevisionsOfAllLMs)" + "\n\tThrowable caught." + "\n\taaProductNumberAndRevisionsOfAllLMs: " + collection + "\n\tThrowable: " + throwable);
        }
    }

    public Collection getLoadModuleMos(Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMos (Collection aProductNumberAndRevisionInterfaces)", "aProductNumberAndRevisionInterfaces: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            while (iterator.hasNext()) {
                linkedList.add(this.getLoadModule((ProductNumberAndRevisionInterface)iterator.next()));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModuleMos (Collection aProductNumberAndRevisionsOfAllLMs)", "RETURNS - " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLoadModuleMos (Collection aProductNumberAndRevisionInterfaces)", "Throwable caught.\n\taProductNumberAndRevisionInterfaces: " + collection + "\n\tThrowable: " + throwable);
            }
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public Collection getLoadModules(HashMap hashMap) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModules(HashMap aLMsProdNoAndRevsMap)", "aLMsProdNoAndRevsMap: " + hashMap);
        }
        try {
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            if (!hashMap.isEmpty()) {
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                String string = null;
                HashSet hashSet = null;
                MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
                if (moIterator != null) {
                    if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                        while (moIterator.hasMoreElements()) {
                            loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                            if (loadModuleMoSU_Access == null || (hashSet = (HashSet)hashMap.get(loadModuleMoSU_Access.getProductNumberOpt(null))) == null || !hashSet.remove(loadModuleMoSU_Access.getProductRevisionOpt(null))) continue;
                            linkedList.add(loadModuleMoSU_Access);
                            if (!hashSet.isEmpty()) continue;
                            hashMap.remove(loadModuleMoSU_Access.getProductNumberOpt(null));
                            if (!hashMap.isEmpty()) continue;
                            break;
                        }
                    } else {
                        while (moIterator.hasMoreElements()) {
                            loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                            if (loadModuleMoSU_Access == null || (hashSet = (HashSet)hashMap.get(string = StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)))) == null || !hashSet.remove(StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)))) continue;
                            linkedList.add(loadModuleMoSU_Access);
                            if (!hashSet.isEmpty()) continue;
                            hashMap.remove(string);
                            if (!hashMap.isEmpty()) continue;
                        }
                    }
                }
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModules(HashMap aLMsProdNoAndRevsMap)", "Throwable caught when collecting load modules matching given map.\n\taLMsProdNoAndRevsMap: " + hashMap, throwable);
            throw new LoadModuleMO_HandlerException("Throwable caught when collecting load modules matching given keys.\n\taLMsProdNoAndRevsMap: " + hashMap + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getLoadModuleLDN_Value(String string, String string2, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, Map map) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleLDN_Value ( String aProductNumber, String aProductRevision, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface);
        }
        try {
            ManagedObject managedObject = (ManagedObject)map.get(string + "_" + string2);
            if (managedObject == null) {
                return null;
            }
            LoadModuleMoSU_Access loadModuleMoSU_Access = (LoadModuleMoSU_Access)managedObject;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLoadModuleLDN_Value ( String aProductNumber, String aProductRevision )", "The Load module DN value: " + loadModuleMoSU_Access.toString());
            }
            return loadModuleMoSU_Access.getLocalDistinguishedName();
        }
        catch (Exception exception) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLoadModuleLDN_Value ( String aProductNumber, String aProductRevision )", "Exception caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tException: " + exception.toString());
            }
            throw new LoadModuleMO_HandlerException("Exception caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tException: " + exception.toString());
        }
    }

    public ManagedObject[] getLoadModulesOfType(ManagedObject[] managedObjectArray, int n) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType)", "aLoadModules: " + SuLib.toString(managedObjectArray) + "\n\tLength of aLoadModules: " + managedObjectArray.length + "\n\taLoadModuleType: " + n);
        }
        try {
            Vector<ManagedObject> vector = new Vector<ManagedObject>(8);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (((LoadModuleMoSU_Access)managedObjectArray[i]).getLoaderType(null) != n) continue;
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType)", "The load module '" + managedObjectArray[i] + "' is of type '" + n + "'.");
                }
                vector.addElement(managedObjectArray[i]);
            }
            Object[] objectArray = new ManagedObject[vector.size()];
            vector.copyInto(objectArray);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType)", "RETURNS - " + SuLib.toString((ManagedObject[])objectArray));
            }
            return objectArray;
        }
        catch (MoRemovedException moRemovedException) {
            Trace.error(this.getClass(), "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType)", "An MoRemovedexception is caught due to one or more of the load module MO's associated to this upgrade package has been removed (for unknown reason).\n\tThis type of error shall not occure during an upgrade. A rollback (node restart) will be requested.\n\tMoRemovedException " + moRemovedException.toString());
            throw new LoadModuleMO_HandlerException("An exception is caught due to one or more of the load module MO's associated to this upgrade package has been removed (for unknown reason).\n\tThis type of error shall not occure during an upgrade. A rollback (node restart) will be requested.\n\tMoRemovedException " + moRemovedException.toString());
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType)", "MoAccessException caught when collecting load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoadModuleType: " + n, moAccessException);
            throw new LoadModuleMO_HandlerException("Exception caught when collecting load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoadModuleType: " + n + "\n\tException data: " + moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType)", "Throwable caught when collecting load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoadModuleType: " + n, throwable);
            throw new LoadModuleMO_HandlerException("Throwable caught when collecting load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoadModuleType: " + n + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public Collection getLoadModulesOfType(ManagedObject[] managedObjectArray, int n, String string) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType, String anOtherLoaderName)", "aLoadModules: " + SuLib.toString(managedObjectArray) + "\n\tLength of aLoadModules: " + managedObjectArray.length + "\n\taLoadModuleType: " + n + "\n\tanOtherLoaderName: " + string);
        }
        LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        String string2 = null;
        try {
            ManagedObject[] managedObjectArray2 = this.getLoadModulesOfType(managedObjectArray, n);
            for (int i = 0; i < managedObjectArray2.length; ++i) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)managedObjectArray2[i];
                string2 = loadModuleMoSU_Access.getOtherLoaderName(null);
                if (!string2.equals(string)) continue;
                linkedList.add(loadModuleMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType, String anOtherLoaderName)", "RETURNS - " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModulesOfType(ManagedObject[] aLoadModules, int aLoadModuleType, String anOtherLoaderName)", "Throwable caught when collecting load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoadModuleType: " + n + "\n\tanOtherLoaderName: " + string, throwable);
            throw new LoadModuleMO_HandlerException("Throwable caught when collecting load modules of a certain type.\n\taLoadModules: " + SuLib.toString(managedObjectArray) + "\n\taLoadModuleType: " + n + "\n\tanOtherLoaderName: " + string + "\n\tThrowable data: " + throwable.toString());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoadModuleMoSU_Access[] reserveLoadModules(Vector vector) throws ReserveLoadModulesException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "reserveLoadModules(Vector aLoadModuleIdentifiers)", "aLoadModuleIdentifiers: " + vector);
        }
        int n = 0;
        Control control = null;
        Coordinator coordinator = null;
        try {
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = new LoadModuleMoSU_Access[vector.size()];
            Enumeration enumeration = vector.elements();
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            while (true) {
                LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray2;
                if (!enumeration.hasMoreElements()) {
                    control.getTerminator().commit();
                    loadModuleMoSU_AccessArray2 = loadModuleMoSU_AccessArray;
                    this.rollbackIfNeeded(control);
                    return loadModuleMoSU_AccessArray2;
                }
                loadModuleMoSU_AccessArray2 = (LoadModuleMoSU_Access[])enumeration.nextElement();
                LoadModuleMoSU_Access loadModuleMoSU_Access = this.getLoadModule((ProductNumberAndRevision)loadModuleMoSU_AccessArray2);
                if (loadModuleMoSU_Access == null) {
                    Trace.error(this.getClass(), "reserveLoadModules(Vector aLoadModuleIdentifiers)", "Unexpected LoadModule Identifier received (i.e. the identifier does not match any of the existing LoadModule MO:s),\n\taUnexpected LoadModuleIdentifier: " + loadModuleMoSU_AccessArray2);
                    throw new ReserveLoadModulesException("Unexpected LoadModule Identifier received (i.e. the identifier does not match any of the existing LoadModule MO:s),\n\taUnexpected LoadModuleIdentifier: " + loadModuleMoSU_AccessArray2);
                }
                loadModuleMoSU_Access.reserve(coordinator);
                loadModuleMoSU_AccessArray[n] = loadModuleMoSU_Access;
                ++n;
            }
        }
        catch (ReserveLoadModulesException reserveLoadModulesException) {
            try {
                throw reserveLoadModulesException;
                catch (Exception exception) {
                    Trace.error(this.getClass(), "reserveLoadModules(Vector aLoadModuleIdentifiers)", "Exception caught when trying to retrieve the LoadModule MO:s matching the identifiers in the provided list,\n\taLoadModuleIdentifiers: " + vector + "\n\tCurrent Identifier: " + (ProductNumberAndRevision)vector.elementAt(n), exception);
                    throw new ReserveLoadModulesException("Exception caught when trying to retrieve the LoadModule MO:s matching the identifiers in the provided list,\n\taLoadModuleIdentifiers: " + vector + "\n\tCurrent Identifier: " + (ProductNumberAndRevision)vector.elementAt(n) + "\n\tOriginal Exception: " + exception.toString());
                }
            }
            catch (Throwable throwable) {
                this.rollbackIfNeeded(control);
                throw throwable;
            }
        }
    }

    public void setIsLoadModuleMoMapToBeUsed(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIsLoadModuleMoMapToBeUsed(boolean anIsLoadModuleMoMapToBeUsed)", "anIsLoadModuleMoMapToBeUsed: " + bl);
        }
        this.myIsLoadModuleMoMapToBeUsed = bl;
    }

    private void rollbackIfNeeded(Control control) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rollbackIfNeeded ( Control theUpgradeControl )", "theUpgradeControl: " + control);
        }
        try {
            if (control != null && control.getCoordinator().getStatus() == Status.ACTIVE) {
                control.getTerminator().rollback();
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "rollbackIfNeeded ( Control theUpgradeControl )", "Rollback failed even though the transaction was active.", exception);
        }
    }

    private AttrListImpl getInstallDataAndInsertInList(ProductNumberAndRevision productNumberAndRevision, DocumentObjectProxyInterface documentObjectProxyInterface, LoadModuleProxyInterface loadModuleProxyInterface, String string, AttrListImpl attrListImpl) {
        InstallLM_Container installLM_Container;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getInstallDataAndInsertInList(ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxy, LoadModuleProxyInterface aLoadModuleProxy, String anUpgradeControlFileAbsoluteSourceFilePath, AttributeList anAttributeList)", "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxy: " + documentObjectProxyInterface + "\n\taLoadModuleProxy: " + loadModuleProxyInterface + "\n\tanUpgradeControlFileAbsoluteSourceFilePath: " + string + "\n\tanAttributeList: " + attrListImpl);
        }
        if ((installLM_Container = (InstallLM_Container)loadModuleProxyInterface.getInstallDatas().firstElement()).getDirectory() != null) {
            boolean bl = false;
            if (installLM_Container.getDirectory().equalsIgnoreCase("yes")) {
                bl = true;
            }
            attrListImpl.addElement("isDirectory", (Object)new Boolean(bl));
        }
        String string2 = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
        attrListImpl.addElement("loadModuleFilePath", (Object)string2);
        return attrListImpl;
    }

    private AttrListImpl getInstallSMsAndInsertInList(LoadModuleProxyInterface loadModuleProxyInterface, AttrListImpl attrListImpl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getInstallSMsAndInsertInList(LoadModuleProxyInterface aLoadModuleProxy, AttrListImpl anAttributeList)", "aLoadModuleProxy: " + loadModuleProxyInterface + "\n\tanAttributeList: " + attrListImpl);
        }
        MoFactory moFactory = MoFactoryMgr.instance().lookup("LoadModule");
        if (SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)moFactory)) {
            Collection collection = loadModuleProxyInterface.getInstallSMs();
            boolean bl = false;
            InstallSMInterface installSMInterface = null;
            if (!collection.isEmpty()) {
                bl = true;
                installSMInterface = (InstallSMInterface)collection.iterator().next();
            }
            attrListImpl.addElement("isSignedSw", (Object)new Boolean(bl));
            if (installSMInterface != null) {
                attrListImpl.addElement("signatureFileNameExtension", (Object)installSMInterface.getExtension());
            }
        }
        return attrListImpl;
    }

    public LoadModuleMoSU_Access getLoadModule(ProductNumberAndRevision productNumberAndRevision) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModule(ProductNumberAndRevision aProductNumberAndRevision)", "aProductNumberAndRevision: " + productNumberAndRevision);
        }
        try {
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator != null) {
                if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null) continue;
                        if (!productNumberAndRevision.equals(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null))) {
                            loadModuleMoSU_Access = null;
                            continue;
                        }
                        break;
                    }
                } else {
                    Struct struct = null;
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null) continue;
                        struct = loadModuleMoSU_Access.getProductData(null);
                        if (!productNumberAndRevision.equals(StringHandler.optimize((String)struct.getValue("productNumber")), StringHandler.optimize((String)struct.getValue("productRevision")))) {
                            loadModuleMoSU_Access = null;
                            continue;
                        }
                        break;
                    }
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModule(ProductNumberAndRevision aProductNumberAndRevision)", "RETURNS - theLoadModuleMO: " + loadModuleMoSU_Access);
            }
            return loadModuleMoSU_Access;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModule(ProductNumberAndRevision aProductNumberAndRevision)", "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getLoadModule(ProductNumberAndRevision aProductNumberAndRevision)" + "\n\tThrowable caught." + "aProductNumberAndRevision: " + productNumberAndRevision);
        }
    }

    private AttrListImpl getMoDataAndInsertInList(ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, AttrListImpl attrListImpl, boolean bl) throws LoadModuleMO_HandlerException {
        String string;
        String string2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMoDataAndInsertInList(ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxy, AttributeList anAttributeList, boolean anIsSU_Version3_Supported)", "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxy: " + loadModuleProxyInterface + "\n\tanAttributeList: " + attrListImpl + "\n\tanIsSU_Version3_Supported: " + bl);
        }
        int n = this.getLoaderType(loadModuleProxyInterface.getLoaderName());
        attrListImpl.addElement("loaderType", (Object)new Integer(n));
        if (loadModuleProxyInterface.getOtherLoaderName() != null) {
            attrListImpl.addElement("otherLoaderName", (Object)loadModuleProxyInterface.getOtherLoaderName());
        }
        if ((string2 = loadModuleProxyInterface.getFileFormat()) != null) {
            if (string2.equalsIgnoreCase("Other")) {
                if (loadModuleProxyInterface.getOtherFileFormat() != null) {
                    attrListImpl.addElement("fileFormat", (Object)loadModuleProxyInterface.getOtherFileFormat());
                }
            } else {
                attrListImpl.addElement("fileFormat", (Object)string2);
            }
        }
        int n2 = this.getPreLoadIntValue(loadModuleProxyInterface.getPreload());
        attrListImpl.addElement("preLoad", (Object)new Integer(n2));
        int n3 = this.getOseProgramLoadClassIntValue(loadModuleProxyInterface.getOseProgramLoadClass(), bl);
        attrListImpl.addElement("oseProgramLoadClass", (Object)new Integer(n3));
        if (loadModuleProxyInterface.getProgramMemoryPoolSize() != null) {
            attrListImpl.addElement("oseProgramPoolSize", (Object)loadModuleProxyInterface.getProgramMemoryPoolSize());
        }
        if (loadModuleProxyInterface.getProgramMemoryHeapSize() != null) {
            attrListImpl.addElement("oseProgramHeapSize", (Object)loadModuleProxyInterface.getProgramMemoryHeapSize());
        }
        boolean bl2 = false;
        if (loadModuleProxyInterface.getMaxExecInstancesNode() != null) {
            if (loadModuleProxyInterface.getMaxExecInstancesNode().equalsIgnoreCase("one")) {
                bl2 = true;
            }
            attrListImpl.addElement("programMustBeSingleton", (Object)new Boolean(bl2));
        }
        if (loadModuleProxyInterface.getReliableProgramLabel() != null) {
            attrListImpl.addElement("reliableProgramLabel", (Object)loadModuleProxyInterface.getReliableProgramLabel());
        }
        if ((string = loadModuleProxyInterface.getDistributedFunctionalityIdentitiesWithSeparators()) != null && string.length() > 0) {
            attrListImpl.addElement("funcId", (Object)string);
        }
        if (this.isSU_VersionSupported("SU_8")) {
            attrListImpl.addElement("restartCounterLimit", (Object)loadModuleProxyInterface.getRestartCounterLimit());
            attrListImpl.addElement("restartTimer", (Object)loadModuleProxyInterface.getRestartTimer());
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMoDataAndInsertInList(ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxy, AttributeList anAttributeList)", "RETURNS - anAttributeList: " + SuLib.toString((AttrList)attrListImpl));
        }
        return attrListImpl;
    }

    public int getLoaderType(String string) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoaderType(String aLoaderName)", "aLoaderName: " + string);
        }
        int n = -1;
        if (string.equalsIgnoreCase(LoaderName.OSE_Loader.getValue())) {
            n = 0;
        } else if (string.equalsIgnoreCase(LoaderName.SPM_Loader.getValue())) {
            n = 1;
        } else if (string.equalsIgnoreCase(LoaderName.JVM.getValue())) {
            n = 2;
        } else if (string.equalsIgnoreCase(LoaderName.Webserver.getValue())) {
            n = 3;
        } else if (string.equalsIgnoreCase(LoaderName.SPM_FPGA_Loader.getValue())) {
            n = 4;
        } else if (string.equalsIgnoreCase(LoaderName.XP_Loader.getValue())) {
            n = 5;
        } else if (string.equalsIgnoreCase(LoaderName.DeviceLoader.getValue())) {
            n = 6;
        } else if (string.equalsIgnoreCase(LoaderName.Other.getValue())) {
            n = 99;
        }
        if (n != -1) {
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoaderType(String aLoaderName)", "RETURNS - theLoaderType: " + n);
            }
            return n;
        }
        throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getLoaderType(String aLoaderName)" + "\n\tConversion to loaderType (int value) for input string (aLoaderName) is not supported," + "\n\taLoaderName: " + string);
    }

    private int getPreLoadIntValue(String string) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPreLoadIntValue(String aPreLoadStringValue)", "aPreLoadStringValue: " + string);
        }
        int n = -1;
        if (string.equalsIgnoreCase("no")) {
            n = 0;
        } else if (string.equalsIgnoreCase("must")) {
            n = 1;
        } else if (string.equalsIgnoreCase("wish")) {
            n = 2;
        }
        if (n != -1) {
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getPreLoadIntValue(String aPreLoadStringValue)", "RETURNS - thePreloadIntValue: " + n);
            }
            return n;
        }
        throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getPreLoadIntValue(String aPreLoadStringValue)" + "\n\tConversion to int value for input string (aPreLoadStringValue) is not supported," + "\n\taPreLoadStringValue: " + string);
    }

    public int getOseProgramLoadClassIntValue(String string, boolean bl) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOseProgramLoadClassIntValue(String anOseProgramLoadClassStringValue, Object anSU_Access, boolean anIsLM_MoSupportingSU_AccessVersion3)", "anOseProgramLoadClassStringValue: " + string);
        }
        int n = -1;
        if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CrlCertificate)) {
            if (bl) {
                n = 5;
            }
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreOS)) {
            n = 10;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest0)) {
            n = 40;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest1)) {
            n = 41;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest2)) {
            n = 42;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest3)) {
            n = 43;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest4)) {
            n = 44;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDevice)) {
            n = 50;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest5)) {
            n = 65;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest6)) {
            n = 66;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest7)) {
            n = 67;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest8)) {
            n = 68;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreDeviceTest9)) {
            n = 69;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreLLP)) {
            n = 100;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreBoot)) {
            n = 150;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreEarly)) {
            n = 200;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.NchHwInit)) {
            n = 240;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.ApplicationHwInit)) {
            n = 250;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.UpgradeEarly)) {
            n = 260;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreMedium)) {
            n = 270;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CoreLate)) {
            n = 300;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.NCH)) {
            n = 400;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.NchLate)) {
            n = 430;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.Application)) {
            n = 500;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.ApplicationLate)) {
            n = 530;
        } else if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.Upgrade)) {
            n = 600;
        }
        if (n != -1) {
            return n;
        }
        throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getOseProgramLoadClassIntValue(String anOseProgramLoadClassStringValue, Object anSU_Access)" + "\n\tConversion to int value for input string (anOseProgramLoadClassStringValue) is not supported," + "\n\tanOseProgramLoadClassStringValue: " + string + "\n\tanIsLM_MoSupportingSU_AccessVersion3: " + bl);
    }

    public String getOseProgramLoadClassStringValue(int n) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOseProgramLoadClassStringValue(int anOseProgramLoadClassIntValue)", "anOseProgramLoadClassIntValue: " + n);
        }
        String string = EMPTY_STRING;
        if (n == 5) {
            string = MoDataLM_OseProgramLoadClassValue.CrlCertificate;
        } else if (n == 10) {
            string = MoDataLM_OseProgramLoadClassValue.CoreOS;
        } else if (n == 40) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest0;
        } else if (n == 41) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest1;
        } else if (n == 42) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest2;
        } else if (n == 43) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest3;
        } else if (n == 44) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest4;
        } else if (n == 50) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDevice;
        } else if (n == 65) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest5;
        } else if (n == 66) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest6;
        } else if (n == 67) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest7;
        } else if (n == 68) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest8;
        } else if (n == 69) {
            string = MoDataLM_OseProgramLoadClassValue.CoreDeviceTest9;
        } else if (n == 100) {
            string = MoDataLM_OseProgramLoadClassValue.CoreLLP;
        } else if (n == 150) {
            string = MoDataLM_OseProgramLoadClassValue.CoreBoot;
        } else if (n == 200) {
            string = MoDataLM_OseProgramLoadClassValue.CoreEarly;
        } else if (n == 240) {
            string = MoDataLM_OseProgramLoadClassValue.NchHwInit;
        } else if (n == 250) {
            string = MoDataLM_OseProgramLoadClassValue.ApplicationHwInit;
        } else if (n == 260) {
            string = MoDataLM_OseProgramLoadClassValue.UpgradeEarly;
        } else if (n == 270) {
            string = MoDataLM_OseProgramLoadClassValue.CoreMedium;
        } else if (n == 300) {
            string = MoDataLM_OseProgramLoadClassValue.CoreLate;
        } else if (n == 400) {
            string = MoDataLM_OseProgramLoadClassValue.NCH;
        } else if (n == 430) {
            string = MoDataLM_OseProgramLoadClassValue.NchLate;
        } else if (n == 500) {
            string = MoDataLM_OseProgramLoadClassValue.Application;
        } else if (n == 530) {
            string = MoDataLM_OseProgramLoadClassValue.ApplicationLate;
        } else if (n == 600) {
            string = MoDataLM_OseProgramLoadClassValue.Upgrade;
        }
        if (string != EMPTY_STRING) {
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getOseProgramLoadClassStringValue(int anOseProgramLoadClassIntValue)", "RETURNS - theOseProgramLoadClassStringValue: " + string);
            }
            return string;
        }
        throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getOseProgramLoadClassStringValue(int anOseProgramLoadClassIntValue)" + "\n\tConversion to String value for input int value (anOseProgramLoadClassintValue) is not supported," + "\n\tanOseProgramLoadClassIntValue: " + n);
    }

    private AttrListImpl getMoppletDataAndInsertInList(ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, AttrListImpl attrListImpl) {
        Vector vector;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMoppletDataAndInsertInList(ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxy, AttributeList anAttributeList)", "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxy: " + loadModuleProxyInterface + "\n\tanAttributeList: " + attrListImpl);
        }
        if ((vector = loadModuleProxyInterface.getMoppletNames()) != null && !vector.isEmpty()) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            attrListImpl.addElement("moppletEntries", (Object)objectArray);
        }
        return attrListImpl;
    }

    private AttrListImpl getDynamicClassDataAndInsertInList(ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, AttrListImpl attrListImpl) {
        String string;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDynamicClassDataAndInsertInList(ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxy, AttributeList anAttributeList)", "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxy: " + loadModuleProxyInterface + "\n\tanAttributeList: " + attrListImpl);
        }
        if ((string = loadModuleProxyInterface.getDynamicClassName()) != null) {
            attrListImpl.addElement("dynamicClass", (Object)string);
        }
        return attrListImpl;
    }

    public Collection getProductNumberAndRevisionsForLoadModules(Collection collection) throws LoadModuleMO_HandlerException {
        String string = "getProductNumberAndRevisionsForLoadModules (Collection aLoadModuleMoSU_Accesses)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aLoadModuleMoSU_Accesses: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                while (iterator.hasNext()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                    linkedList.add(new ProductNumberAndRevision(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null)));
                }
            } else {
                while (iterator.hasNext()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                    linkedList.add(new ProductNumberAndRevision(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null))));
                }
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    private AttrListImpl getProductDataAndInsertInList(ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, AttrListImpl attrListImpl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProductDataAndInsertInList(ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxy, AttributeList anAttributeList)", "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxy: " + loadModuleProxyInterface + "\n\tanAttributeList: " + attrListImpl);
        }
        Vector<String> vector = new Vector<String>(8);
        Vector<String> vector2 = new Vector<String>(8);
        vector.addElement("productNumber");
        vector2.addElement(loadModuleProxyInterface.getProductNumberRaw());
        vector.addElement("productRevision");
        vector2.addElement(loadModuleProxyInterface.getProductRevisionRaw());
        vector.addElement("productName");
        if (loadModuleProxyInterface.getProductName() != null) {
            vector2.addElement(loadModuleProxyInterface.getProductName());
        } else {
            vector2.addElement(EMPTY_STRING);
        }
        vector.addElement("productionDate");
        if (loadModuleProxyInterface.getProductDate() != null) {
            vector2.addElement(loadModuleProxyInterface.getProductDate());
        } else {
            vector2.addElement(EMPTY_STRING);
        }
        vector.addElement("productInfo");
        if (loadModuleProxyInterface.getProductInformation() != null) {
            vector2.addElement(loadModuleProxyInterface.getProductInformation());
        } else {
            vector2.addElement(EMPTY_STRING);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new Object[vector2.size()];
        vector2.copyInto(objectArray2);
        attrListImpl.addElement("productData", (Object)new StructImpl((String[])objectArray, objectArray2));
        if (loadModuleProxyInterface.getProductType() != null) {
            attrListImpl.addElement("isCpiType", (Object)loadModuleProxyInterface.getProductType());
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProductDataAndInsertInList(ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxy, AttributeList anAttributeList)", "ProductName: " + loadModuleProxyInterface.getProductName() + "\n\tProductNumber: " + loadModuleProxyInterface.getProductNumber() + "\n\tProductRevision: " + loadModuleProxyInterface.getProductRevision());
        }
        return attrListImpl;
    }

    public boolean isLoadModuleMatchingState(ProductNumberAndRevision productNumberAndRevision, LoadModuleState loadModuleState) throws LoadModuleMO_HandlerException {
        String string = "isLoadModuleMatchingState(ProductNumberAndRevision aProductNumberAndRevision, LoadModuleState aLoadModuleState)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleState: " + loadModuleState);
        }
        try {
            boolean bl = false;
            LoadModuleMoSU_Access loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevision);
            LoadModuleState loadModuleState2 = this.getLoadModuleState(loadModuleMoSU_Access, null);
            if (loadModuleState2.equals(loadModuleState)) {
                bl = true;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theIsMatchingState: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleState: " + loadModuleState, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleState: " + loadModuleState + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public boolean isSU_VersionSupported(String string) throws LoadModuleMO_HandlerException {
        MoFactory moFactory = MoFactoryMgr.instance().lookup("LoadModule");
        return SU_AccessVersionHandler.getInstance().isSupported(string, (Object)moFactory);
    }

    public boolean isSU_VersionSupported(String string, Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aLoadModuleMoSU_Accesses)", "aSU_AccessVersion: " + string + "\n\taLoadModuleMoSU_Accesses: " + collection);
        }
        try {
            boolean bl = false;
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                if (!SU_AccessVersionHandler.getInstance().isSupported(string, (Object)loadModuleMoSU_Access)) continue;
                bl = true;
                break;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aLoadModuleMoSU_Accesses)", "RETURNS - theIsSupported: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aLoadModuleMoSU_Accesses)", "aSU_AccessVersion: " + string + "aLoadModuleMoSU_Accesses: " + collection + "\n\tThrowable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public boolean isSU_VersionSupported(String string, LoadModuleMoSU_Access loadModuleMoSU_Access) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, LoadModuleMoSU_Access aLoadModuleMoSU_Access)", "aSU_AccessVersion: " + string + "\n\taLoadModuleMoSU_Access: " + loadModuleMoSU_Access);
        }
        try {
            boolean bl = false;
            if (SU_AccessVersionHandler.getInstance().isSupported(string, (Object)loadModuleMoSU_Access)) {
                bl = true;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aLoadModuleMoSU_Accesses)", "RETURNS - theIsSupported: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aLoadModuleMoSU_Accesses)", "aSU_AccessVersion: " + string + "aLoadModuleMoSU_Access: " + loadModuleMoSU_Access + "\n\tThrowable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public boolean isUpgradeEnabler(Collection collection) throws LoadModuleMO_HandlerException {
        try {
            boolean bl = false;
            if (this.isSU_VersionSupported("SU_3", collection)) {
                Iterator iterator = collection.iterator();
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                if (iterator.hasNext()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                    bl = loadModuleMoSU_Access.isUpgradeEnabler();
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isUpgradeEnabler(Collection aLoadModuleMoSU_Accesses)", "RETURNS - theIsUpgradeEnabler: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isUpgradeEnabler(Collection aLoadModuleMoSU_Accesses)", "aLoadModuleMoSU_Accesses: " + collection + "\n\tThrowable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public boolean isSignedSW(Collection collection) throws LoadModuleMO_HandlerException {
        try {
            boolean bl = false;
            if (this.isSU_VersionSupported("SU_3", collection)) {
                Iterator iterator = collection.iterator();
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                if (iterator.hasNext()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                    bl = loadModuleMoSU_Access.getIsSignedSw(null);
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isSignedSW(Collection aLoadModuleMoSU_Accesses)", "RETURNS - theIsSignedSW: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSignedSW(Collection aLoadModuleMoSU_Accesses)", "aLoadModuleMoSU_Accesses: " + collection + "\n\tThrowable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    private boolean loadModuleExists(ProductNumberAndRevision productNumberAndRevision) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadModuleExists(ProductNumberAndRevision aProductNumberAndRevision)", "aProductNumberAndRevision: " + productNumberAndRevision);
        }
        return this.getLoadModule(productNumberAndRevision) != null;
    }

    public Collection getNotInstalledLMs(Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNotInstalledLMs(Collection aProductNumberAndRevisionInterfaces)", "aProductNumberAndRevisionInterfaces: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
            while (iterator.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
                loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
                if (loadModuleMoSU_Access != null) {
                    if (loadModuleMoSU_Access.getFileState(null) == 1) continue;
                    linkedList.add(new ProductNumberAndRevision(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision()));
                    continue;
                }
                linkedList.add(new ProductNumberAndRevision(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision()));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getNotInstalledLMs(Collection aProductNumberAndRevisionInterfaces)", "RETURNS - theNotInstalledLMs: " + linkedList);
            }
            return linkedList;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNotInstalledLMs(Collection aProductNumberAndRevisionInterfaces)", "aProductNumberAndRevisionInterfaces: " + collection + "\n\tThrowable caught.", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createShadowLoadModules(ProductNumberAndRevision productNumberAndRevision, String string, Collection collection) throws LoadModuleMO_HandlerException {
        String string2 = "createShadowLoadModules(ProductNumberAndRevision anUP_ProductNumberAndRevision, String anUCF, Collection aProductNumberAndRevisionList)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string2, "anUP_ProductNumberAndRevision: " + productNumberAndRevision + "\n\tanUCF: " + string + "\n\taProductNumberAndRevisionList: " + collection);
        }
        Control control = null;
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            String[] stringArray = new String[]{"InstallUp", "LoadModule"};
            documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(productNumberAndRevision.productNumber, productNumberAndRevision.revision, string, stringArray);
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            Iterator iterator = collection.iterator();
            ProductNumberAndRevision productNumberAndRevision2 = null;
            while (iterator.hasNext()) {
                productNumberAndRevision2 = (ProductNumberAndRevision)iterator.next();
                this.createLoadModuleMO(productNumberAndRevision2, documentObjectProxyInterface, string, coordinator);
            }
            Transaction.commit(control);
        }
        catch (CreateLoadModuleException createLoadModuleException) {
            try {
                Transaction.rollback(control);
                throw new LoadModuleMO_HandlerException(createLoadModuleException.toString());
                catch (UpgradeControlFileParserException upgradeControlFileParserException) {
                    throw new LoadModuleMO_HandlerException(upgradeControlFileParserException.toString());
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), string2, "Throwable caught.\n\tanUP_ProductNumberAndRevision: " + productNumberAndRevision + "\n\tanUCF: " + string + "\n\taProductNumberAndRevisionList: " + collection, throwable);
                    Transaction.rollback(control);
                    throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string2 + "\n\tThrowable caught." + "\n\tanUP_ProductNumberAndRevision: " + productNumberAndRevision + "\n\tanUCF: " + string + "\n\taProductNumberAndRevisionList: " + collection + "\n\tOriginal Throwable: " + throwable);
                }
            }
            catch (Throwable throwable) {
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                throw throwable;
            }
        }
        UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
    }

    public void forcedDeleteLoadModules(Collection collection) throws LoadModuleMO_HandlerException {
        String string = "deleteLoadModules(Collection aLoadModulesProductNumberAndRevisions)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aLoadModulesProductNumberAndRevisions: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            HashSet<LoadModuleMoSU_Access> hashSet = new HashSet<LoadModuleMoSU_Access>();
            ProductNumberAndRevision productNumberAndRevision = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevision);
                if (loadModuleMoSU_Access == null) continue;
                hashSet.add(loadModuleMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, string, "theLM_MOs: " + hashSet);
            }
            this.forcedDeleteOfLoadModules(hashSet);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taLoadModulesProductNumberAndRevisions: " + collection, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taLoadModulesProductNumberAndRevisions: " + collection + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void forcedDeleteOfLoadModules(Collection collection) throws LoadModuleMO_HandlerException {
        String string = "forcedDeleteOfLoadModules(Collection aListOfLoadModuleMoSU_AccessInterfaces)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aListOfLoadModuleMoSU_AccessInterfaces: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                this.forcedDeleteOfLoadModule(loadModuleMoSU_Access);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aListOfLoadModuleMoSU_AccessInterfaces: " + collection, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "aListOfLoadModuleMoSU_AccessInterfaces: " + collection + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void forcedDeleteOfLoadModule(LoadModuleMoSU_Access loadModuleMoSU_Access) throws LoadModuleMO_HandlerException {
        String string = "forcedDeleteOfLoadModules(LoadModuleMoSU_Access aLoadModuleMoSU_Access)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aLoadModuleMoSU_Access: " + loadModuleMoSU_Access);
        }
        Control control = null;
        try {
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            loadModuleMoSU_Access.deleteMO(coordinator);
            Transaction.commit(control);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, string, "The load module MO has been deleted.\n\taLoadModuleMoSU_Access: " + loadModuleMoSU_Access);
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), string, "Throwable caught.aLoadModuleMoSU_Access: " + loadModuleMoSU_Access + "\n\tThrowable data: " + throwable);
            Transaction.rollback(control);
        }
    }

    public void deleteLoadModules(Collection collection, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        String string = "deleteLoadModules(Collection aListOfLoadModuleMoSU_AccessInterfaces, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aListOfLoadModuleMoSU_AccessInterfaces: " + collection + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                loadModuleMoSU_Access.delete(coordinator);
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, string, "The load module MO has been deleted.\n\ttheLoadModuleMoSU_Access: " + loadModuleMoSU_Access);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aListOfLoadModuleMoSU_AccessInterfaces: " + collection + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "aListOfLoadModuleMoSU_AccessInterfaces: " + collection + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public LoadModuleState getLoadModuleState(LoadModuleMoSU_Access loadModuleMoSU_Access, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        String string = "getLoadModuleState(LoadModuleMoSU_Access aLoadModuleMoSU_Access, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, string, "aLoadModuleMoSU_Access: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (loadModuleMoSU_Access == null) {
                return LoadModuleState.NotInstalled;
            }
            int n = loadModuleMoSU_Access.getFileState(coordinator);
            return LoadModuleState.getInstance(n);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aLoadModuleMoSU_Access: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "aLoadModuleMoSU_Access: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getAllLoadModuleMOs() throws LoadModuleMO_HandlerException {
        String string = "getAllLoadModuleMOs()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        try {
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                    linkedList.add(loadModuleMoSU_Access);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theLoadModuleMOs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getRP_LabelsForLM_MOs(Collection collection) throws LoadModuleMO_HandlerException {
        String string = "getRP_LabelsForLM_MOs (Collection aLoadModuleMOs)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aLoadModuleMOs: " + collection);
        }
        try {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                hashSet.add(loadModuleMoSU_Access.getReliableProgramLabel(null));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theRP_Labels: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "aLoadModuleMOs: " + collection + "\n\tThrowable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: " + string + "\n\taLoadModuleMOs: " + collection + "\n\tThrowable caught: " + throwable);
        }
    }

    public int getOseProgramHeapSize(LoadModuleMoSU_Access loadModuleMoSU_Access, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOseProgramHeapSize ( LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator )", "aLoadModuleMo: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return loadModuleMoSU_Access.getOseProgramHeapSize(coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getOseProgramHeapSize ( LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator )", "aLoadModuleMo: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public int getOseProgramPoolSize(LoadModuleMoSU_Access loadModuleMoSU_Access, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOseProgramPoolSize ( LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator )", "aLoadModuleMo: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return loadModuleMoSU_Access.getOseProgramPoolSize(coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getOseProgramPoolSize ( LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator )", "aLoadModuleMo: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public Vector getInstalledLoadModules(ProductNumbersAndRevisions productNumbersAndRevisions, Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getInstalledLoadModules(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions)", "aLoadModulesProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        try {
            Iterator iterator = productNumbersAndRevisions.getElements().iterator();
            ProductNumberAndRevisionSSW productNumberAndRevisionSSW = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            Vector<ProductNumberAndRevision> vector = new Vector<ProductNumberAndRevision>();
            while (iterator.hasNext()) {
                productNumberAndRevisionSSW = (ProductNumberAndRevisionSSW)iterator.next();
                loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevisionSSW.getProductNumberAndRevision());
                if (loadModuleMoSU_Access != null) {
                    if (loadModuleMoSU_Access.getFileState(null) == 1) {
                        if (productNumberAndRevisionSSW.isSigned()) {
                            if (!collection.contains(productNumberAndRevisionSSW.getProductNumberAndRevision())) continue;
                            vector.add(productNumberAndRevisionSSW.getProductNumberAndRevision());
                            continue;
                        }
                        vector.add(productNumberAndRevisionSSW.getProductNumberAndRevision());
                        continue;
                    }
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "getInstalledLoadModules(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions)", "Load module not installed and will not be part of the health checktheLoadModuleMo: " + loadModuleMoSU_Access);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getInstalledLoadModules(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions)", "No load module Mo found for given product number and revision.\n\ttheLoadModuleProdNoAndRev: " + productNumberAndRevisionSSW);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getInstalledLoadModules(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions)", "RETURNS - theInstalledLoadModules: " + vector);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getInstalledLoadModules(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions)", "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetInstalledLoadModules(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions)" + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getNotInstalledLoadModules() throws LoadModuleMO_HandlerException {
        String string = "getNotInstalledLoadModules()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        try {
            Collection collection = this.getAllLoadModuleMOs();
            return this.getNotInstalledLoadModules(collection);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getNotInstalledLoadModules(Collection collection) throws LoadModuleMO_HandlerException {
        String string = "getNotInstalledLoadModules(Collection aLoadModuleMOs)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aLoadModuleMOs: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                if (loadModuleMoSU_Access.getFileState(null) != LoadModuleState.NotInstalled.getValue()) continue;
                linkedList.add(loadModuleMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theNotInstalledLM_MOs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getInstalledLoadModules(Collection collection) throws LoadModuleMO_HandlerException {
        String string = "getNotInstalledLoadModules(Collection aLoadModuleMOs)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aLoadModuleMOs: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                if (loadModuleMoSU_Access.getFileState(null) != LoadModuleState.Installed.getValue()) continue;
                linkedList.add(loadModuleMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theInstalledLM_MOs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection extractIdentifiersOfLoadModulesWithState(Collection collection, LoadModuleState loadModuleState) throws LoadModuleMO_HandlerException {
        String string = "extractIdentifiersOfLoadModulesWithState(Collection aListOfProductNumberAndRevisions, LoadModuleState aLoadModuleState)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aListOfProductNumberAndRevisions: " + collection + "\n\taLoadModuleState: " + loadModuleState);
        }
        try {
            Collection collection2 = this.getAllLoadModuleMOs();
            LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
            Iterator iterator = collection2.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions(new Vector(collection));
            ProductNumberAndRevision productNumberAndRevision = null;
            if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                while (iterator.hasNext()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                    productNumberAndRevision = new ProductNumberAndRevision(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null));
                    if (!productNumbersAndRevisions.contains(productNumberAndRevision) || loadModuleMoSU_Access.getFileState(null) != loadModuleState.getValue()) continue;
                    linkedList.add(productNumberAndRevision);
                }
            } else {
                while (iterator.hasNext()) {
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                    productNumberAndRevision = new ProductNumberAndRevision(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)));
                    if (!productNumbersAndRevisions.contains(productNumberAndRevision) || loadModuleMoSU_Access.getFileState(null) != loadModuleState.getValue()) continue;
                    linkedList.add(productNumberAndRevision);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theLoadModulesMatchingState: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aListOfProductNumberAndRevisions: " + collection + "\n\taLoadModuleState: " + loadModuleState, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "aListOfProductNumberAndRevisions: " + collection + "\n\taLoadModuleState: " + loadModuleState + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public LoadModuleMoSU_Access getLoadModuleMo(String string) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMo(String aLoadModuleLDN)", "aLoadModuleLDN: " + string);
        }
        try {
            ManagedObject managedObject = MoRepository.instance().lookup(string);
            return (LoadModuleMoSU_Access)managedObject;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleMo(String aLoadModuleLDN)", "Throwable caught.\n\taLoadModuleLDN: " + string, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetLoadModuleMo(String aLoadModuleLDN)" + "\n\tThrowable caught." + "\n\taLoadModuleLDN: " + string + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public LoadModulesStates getLoadModulesStates() throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "LoadModulesStates()");
        }
        try {
            Collection collection = this.getAllLoadModuleMOs();
            Iterator iterator = collection.iterator();
            LoadModulesStates loadModulesStates = new LoadModulesStates();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                loadModulesStates.addLoadModuleState(loadModuleMoSU_Access.getLocalDistinguishedName(), LoadModuleState.getInstance(loadModuleMoSU_Access.getFileState(null)));
            }
            return loadModulesStates;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModulesStates()", "Throwable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public LoadModuleMoSU_Access getLoadModuleMo(LoadModuleInformation loadModuleInformation) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMo(LoadModuleInformation aLoadModuleInformation)", "aLoadModuleInformation: " + loadModuleInformation);
        }
        return this.getLoadModuleMo(loadModuleInformation.getLDN());
    }

    public LoadModuleMoSU_Access getLoadModuleMo(LoadModuleRefInfo loadModuleRefInfo) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMo(LoadModuleRefInfo aLoadModuleRefInfo)", "aLoadModuleRefInfo: " + loadModuleRefInfo);
        }
        try {
            ManagedObject managedObject = MoRepository.instance().lookup(loadModuleRefInfo.getLdn());
            return (LoadModuleMoSU_Access)managedObject;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleMo(LoadModuleRefInfo aLoadModuleRefInfo)", "Throwable caught.\n\taLoadModuleRefInfo: " + loadModuleRefInfo, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetLoadModuleMo(LoadModuleRefInfo aLoadModuleRefInfo)" + "\n\tThrowable caught." + "\n\taLoadModuleRefInfo: " + loadModuleRefInfo + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public LoadModuleMoSU_Access getLoadModuleMo(LoadModuleRefLDN_Information loadModuleRefLDN_Information) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMo(LoadModuleRefLDN_Information aLoadModuleRefBaseLDN_Information)", "aLoadModuleRefBaseLDN_Information: " + loadModuleRefLDN_Information);
        }
        return this.getLoadModuleMo(loadModuleRefLDN_Information.getLDN());
    }

    public int getLoaderType(LoadModuleMoSU_Access loadModuleMoSU_Access, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoaderType (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)", "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return loadModuleMoSU_Access.getLoaderType(coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoaderType (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)", "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetLoaderType (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)" + "\n\tThrowable caught." + "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public String getDeviceLoaderName(LoadModuleMoSU_Access loadModuleMoSU_Access, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDeviceLoaderName (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)", "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return loadModuleMoSU_Access.getDeviceLoaderName(coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDeviceLoaderName (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)", "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetDeviceLoaderName (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)" + "\n\tThrowable caught." + "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public String getDeviceLoaderInformation(LoadModuleMoSU_Access loadModuleMoSU_Access, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDeviceLoaderInformation (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)", "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return loadModuleMoSU_Access.getDeviceLoaderInformation(coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDeviceLoaderInformation (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)", "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetDeviceLoaderInformation (LoadModuleMoSU_Access aLM_MO, Coordinator aCoordinator)" + "\n\tThrowable caught." + "aLM_MO: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getLMsWhereFileStateNotIsCorrect(Collection collection, int n) throws LoadModuleMO_HandlerException {
        String string = "getLMsWhereFileStateNotIsCorrect ( Collection aListOfProductNumberAndRevisions, int aFileState)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aListOfProductNumberAndRevisions: " + collection + "\n\taFileState: " + n);
        }
        try {
            Collection collection2 = this.extractIdentifiersOfLoadModulesWithState(collection, LoadModuleState.getInstance(n));
            Iterator iterator = collection2.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            HashSet<ProductNumberAndRevision> hashSet = new HashSet<ProductNumberAndRevision>();
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevision);
                if (loadModuleMoSU_Access.isFileStateCorrect(n, null)) continue;
                hashSet.add(productNumberAndRevision);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theLMsThatNotIsCorrect: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aListOfProductNumberAndRevisions: " + collection + "\n\taFileState: " + n, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taFileState: " + n + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public boolean isLoadModulePresent(ProductNumberAndRevision productNumberAndRevision) throws LoadModuleMO_HandlerException {
        String string = "isLoadModulePresent(ProductNumberAndRevision aProductNumberAndRevision)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aProductNumberAndRevision: " + productNumberAndRevision);
        }
        try {
            return this.loadModuleExists(productNumberAndRevision);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aProductNumberAndRevision: " + productNumberAndRevision, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public boolean isPredefined_eNodeB_FilePath(String string) {
        String string2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPredefined_eNodeB_FilePath(String aFilePath)", "aFilePath: " + string);
        }
        boolean bl = false;
        if (string.startsWith(RUNNING_SW_FRONTSLASH)) {
            bl = true;
        } else if (string.length() >= LENGTH_OF_RUNNING_SW_FRONTSLASH && (string2 = string.substring(0, LENGTH_OF_RUNNING_SW_FRONTSLASH)).equalsIgnoreCase(RUNNING_SW_FRONTSLASH)) {
            bl = true;
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "isPredefined_eNodeB_FilePath(String aFilePath)", "RETURNS - theIsPredefined_eNodeB_FilePath: " + bl);
        }
        return bl;
    }

    public void updateFileStateInLM(Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateFileStateInLM (Collection aLM_MOs)", "aLM_MOs: " + collection);
        }
        Control control = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                loadModuleMoSU_Access.refreshFileState(coordinator);
            }
            Transaction.commit(control);
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateFileStateInLM (Collection aLM_MOs)", "Throwable caught.\n\taLM_MOs: " + collection, throwable);
            Transaction.rollback(control);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tupdateFileStateInLM (Collection aLM_MOs)" + "\n\tThrowable caught." + "\n\taLM_MOs: " + collection + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void updateFileStateInLM(ProductNumberAndRevision productNumberAndRevision) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateFileStateInLM (ProductNumberAndRevision aProductNumberAndRevision)", "aProductNumberAndRevision: " + productNumberAndRevision);
        }
        Control control = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevision);
            if (loadModuleMoSU_Access == null) {
                Trace.error(this.getClass(), "updateFileStateInLM (ProductNumberAndRevision aProductNumberAndRevision)", "\n\tNo load module MO was found for the given product number and revision (couldn't update the LM MO).\n\taProductNumberAndRevision: " + productNumberAndRevision);
                throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tupdateFileStateInLM (ProductNumberAndRevision aProductNumberAndRevision)" + "\n\tNo load module MO was found for the given product number and revision (couldn't update the LM MO)." + "\n\taProductNumberAndRevision: " + productNumberAndRevision);
            }
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            loadModuleMoSU_Access.refreshFileState(coordinator);
            Transaction.commit(control);
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateFileStateInLM (ProductNumberAndRevision aProductNumberAndRevision)", "Throwable caught.\n\taProductNumberAndRevision: " + productNumberAndRevision, throwable);
            Transaction.rollback(control);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tupdateFileStateInLM (ProductNumberAndRevision aProductNumberAndRevision)" + "\n\tThrowable caught." + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void updateLoadModuleMOsWithDataFromUCF(LoadModulesProxyInterface loadModulesProxyInterface, boolean bl) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateLoadModuleMOsWithDataFromUCF(LoadModulesProxyInterface aLoadModulesProxyInterface, boolean aDoRefreshFileState)", "aLoadModulesProxyInterface: " + loadModulesProxyInterface + "\n\taDoRefreshFileState: " + bl);
        }
        try {
            Map map = this.buildSetOfLM_MOsMap();
            Iterator iterator = loadModulesProxyInterface.getLoadModuleProxyInterfaces().iterator();
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            boolean bl2 = this.isSU_VersionSupported("SU_3");
            PiuTypeInstallStateSupervisor piuTypeInstallStateSupervisor = (PiuTypeInstallStateSupervisor)ServiceLocatorFacade.getRepository().getService(PiuTypeInstallStateSupervisor.class);
            if (bl) {
                piuTypeInstallStateSupervisor.deactivate();
            }
            while (iterator.hasNext()) {
                loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
                this.updateLM_DataInItsLoadModuleMo((LoadModuleMoSU_Access)map.get(loadModuleProxyInterface.getProductNumber() + "_" + loadModuleProxyInterface.getProductRevision()), loadModuleProxyInterface, bl2, bl);
            }
            if (bl) {
                piuTypeInstallStateSupervisor.activate();
                if (this.myDoStateUpdateInAllPiuTypes) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "updateLoadModuleMOsWithDataFromUCF(LoadModulesProxyInterface aLoadModulesProxyInterface, boolean aDoRefreshFileState)", "Updating the attribute lmFilesInstallState in all PiuType MOs.");
                    }
                    HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
                    hW_SensitiveAdapter.updateStateInAllPiuTypes();
                    this.myDoStateUpdateInAllPiuTypes = false;
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateLoadModuleMOsWithDataFromUCF(LoadModulesProxyInterface aLoadModulesProxyInterface, , boolean aDoRefreshFileState)", "Throwable caught", throwable);
            this.myDoStateUpdateInAllPiuTypes = false;
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    private void updateLM_DataInItsLoadModuleMo(LoadModuleMoSU_Access loadModuleMoSU_Access, LoadModuleProxyInterface loadModuleProxyInterface, boolean bl, boolean bl2) throws UpdateLM_DataException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateLM_DataInItsLoadModuleMo(LoadModuleMoSU_Access aLM_Mo, LoadModuleProxyInterface aLoadModuleProxyInterface, boolean anIsLM_MoSupportingSU_AccessVersion3, boolean aDoRefreshFileState)", "aLM_Mo: " + loadModuleMoSU_Access + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanIsLM_MoSupportingSU_AccessVersion3: " + bl + "\n\taDoRefreshFileState: " + bl2);
        }
        try {
            String string;
            String string2;
            String string3;
            if (loadModuleMoSU_Access == null) {
                return;
            }
            String string4 = loadModuleProxyInterface.getLoaderName();
            String string5 = loadModuleProxyInterface.getDeviceLoaderName();
            if (string5 == null) {
                string5 = EMPTY_STRING;
            }
            if ((string3 = loadModuleProxyInterface.getDeviceLoaderInformation()) == null) {
                string3 = EMPTY_STRING;
            }
            if ((string2 = loadModuleProxyInterface.getOtherLoaderName()) == null) {
                string2 = EMPTY_STRING;
            }
            if ("Other".equalsIgnoreCase(string = loadModuleProxyInterface.getFileFormat())) {
                string = loadModuleProxyInterface.getOtherFileFormat();
            }
            if (string == null) {
                string = EMPTY_STRING;
            }
            String string6 = loadModuleProxyInterface.getPreload();
            String string7 = loadModuleProxyInterface.getOseProgramLoadClass();
            Integer n = loadModuleProxyInterface.getProgramMemoryHeapSize();
            int n2 = 0;
            if (n != null) {
                n2 = n;
            }
            Integer n3 = loadModuleProxyInterface.getProgramMemoryPoolSize();
            int n4 = 0;
            if (n3 != null) {
                n4 = n3;
            }
            Collection collection = loadModuleProxyInterface.getInstallSMs();
            String string8 = EMPTY_STRING;
            if (!collection.isEmpty()) {
                InstallSMInterface installSMInterface = (InstallSMInterface)collection.iterator().next();
                string8 = installSMInterface.getExtension();
            }
            this.updateLoadModuleData(loadModuleMoSU_Access, string4, string5, string3, string2, string, string6, string7, n2, n4, loadModuleProxyInterface.isSigned(), string8, bl, bl2, loadModuleProxyInterface.getRestartCounterLimit(), loadModuleProxyInterface.getRestartTimer());
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new UpdateLM_DataException(loadModuleMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            throw new UpdateLM_DataException(throwable.toString());
        }
    }

    public void updateLoadModuleAtInstall(ProductNumberAndRevision productNumberAndRevision, DocumentObjectProxyInterface documentObjectProxyInterface) throws LoadModuleMO_HandlerException {
        String string = "updateLoadModuleAtInstall(ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxyInterface)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aProductNumberAndRevision: " + productNumberAndRevision + "aDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        Control control = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevision);
            if (loadModuleMoSU_Access == null) {
                Trace.error(this.getClass(), string, "\n\tNo load module MO was found for the given product number and revision (couldn't update the LM MO).\n\taProductNumberAndRevision: " + productNumberAndRevision);
                throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tNo load module MO was found for the given product number and revision (couldn't update the LM MO)." + "\n\taProductNumberAndRevision: " + productNumberAndRevision);
            }
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            this.updateIsDirectoryAndLoadModuleFilePath(productNumberAndRevision, loadModuleMoSU_Access, documentObjectProxyInterface, coordinator);
            this.setFileState(loadModuleMoSU_Access, coordinator);
            Transaction.commit(control);
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            Transaction.rollback(control);
            throw loadModuleMO_HandlerException;
        }
        catch (IllegalAttributeValueException illegalAttributeValueException) {
            Trace.warning(this.getClass(), string, "Failed to set the fileState to Installed due to the LM file didn't exist in the path defined in the LM MO's loadModuleFilePath attribute i.e. it is a missmatch between the LM MO configuration and the path specified in the UCF.\n\tLoad Module MO: " + loadModuleMoSU_Access + "\n\tThe product number and revision of LM: " + productNumberAndRevision + "\n\tIllegalAttributeValueException: " + (Object)((Object)illegalAttributeValueException));
            Transaction.rollback(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taProductNumberAndRevision: " + productNumberAndRevision, throwable);
            Transaction.rollback(control);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void updateLoadModuleAtInstallOfActiveUP(ProductNumberAndRevision productNumberAndRevision, DocumentObjectProxyInterface documentObjectProxyInterface) throws LoadModuleMO_HandlerException {
        String string = "updateLoadModuleAtInstallOfActiveUP(ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxyInterface)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aProductNumberAndRevision: " + productNumberAndRevision + "aDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        Control control = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            loadModuleMoSU_Access = this.getLoadModule(productNumberAndRevision);
            if (loadModuleMoSU_Access == null) {
                Trace.error(this.getClass(), string, "\n\tNo load module MO was found for the given product number and revision (couldn't update the LM MO).\n\taProductNumberAndRevision: " + productNumberAndRevision);
                throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tNo load module MO was found for the given product number and revision (couldn't update the LM MO)." + "\n\taProductNumberAndRevision: " + productNumberAndRevision);
            }
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            LoadModuleProxyInterface loadModuleProxyInterface = this.updateIsDirectoryAndLoadModuleFilePath(productNumberAndRevision, loadModuleMoSU_Access, documentObjectProxyInterface, coordinator);
            this.setFileState(loadModuleMoSU_Access, coordinator);
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)loadModuleMoSU_Access)) {
                if (loadModuleProxyInterface == null) {
                    loadModuleProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface().getLoadModuleProxyInterface(productNumberAndRevision);
                }
                Collection collection = loadModuleProxyInterface.getInstallSMs();
                String string2 = EMPTY_STRING;
                if (!collection.isEmpty()) {
                    InstallSMInterface installSMInterface = (InstallSMInterface)collection.iterator().next();
                    string2 = installSMInterface.getExtension();
                }
                if (loadModuleMoSU_Access.getIsSignedSw(null) != loadModuleProxyInterface.isSigned()) {
                    loadModuleMoSU_Access.setIsSignedSwForUpgrade(loadModuleProxyInterface.isSigned(), coordinator);
                }
                if (!loadModuleMoSU_Access.getSignatureFileNameExtension(null).equals(string2)) {
                    loadModuleMoSU_Access.setSignatureFileNameExtensionForUpgrade(string2, coordinator);
                }
            }
            Transaction.commit(control);
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            Transaction.rollback(control);
            throw loadModuleMO_HandlerException;
        }
        catch (IllegalAttributeValueException illegalAttributeValueException) {
            Trace.warning(this.getClass(), string, "Failed to set the fileState to Installed due to the LM file didn't exist in the path defined in the LM MO's loadModuleFilePath attribute i.e. it is a missmatch between the LM MO configuration and the path specified in the UCF.\n\tLoad Module MO: " + loadModuleMoSU_Access + "\n\tThe product number and revision of LM: " + productNumberAndRevision + "\n\tIllegalAttributeValueException: " + (Object)((Object)illegalAttributeValueException));
            Transaction.rollback(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taProductNumberAndRevision: " + productNumberAndRevision, throwable);
            Transaction.rollback(control);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private LoadModuleProxyInterface updateIsDirectoryAndLoadModuleFilePath(ProductNumberAndRevision productNumberAndRevision, LoadModuleMoSU_Access loadModuleMoSU_Access, DocumentObjectProxyInterface documentObjectProxyInterface, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        String string = "updateIsDirectoryAndLoadModuleFilePath(LoadModuleMoSU_Access anLM_MO, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anLM_MO: " + loadModuleMoSU_Access + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        try {
            String string2 = loadModuleMoSU_Access.getRealLoadModuleFilePath(null);
            if (this.isPredefined_eNodeB_FilePath(string2)) {
                loadModuleProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface().getLoadModuleProxyInterface(productNumberAndRevision);
                InstallLM_Container installLM_Container = (InstallLM_Container)loadModuleProxyInterface.getInstallDatas().firstElement();
                String string3 = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
                if (this.isSU_VersionSupported("SU_7")) {
                    Trace.log1(this.getClass(), string, "LM MO supports version 7 where a predefined eNodeB where LM path is configured to runningSW/\n\tLoadModule MO: " + productNumberAndRevision + "\n\tanLM_MO: " + loadModuleMoSU_Access);
                    boolean bl = false;
                    if (installLM_Container.getDirectory() != null && installLM_Container.getDirectory().equalsIgnoreCase("yes")) {
                        bl = true;
                    }
                    loadModuleMoSU_Access.setIsDirectoryForUpgrade(bl, coordinator);
                    loadModuleMoSU_Access.setLoadModuleFilePathForUpgrade(string3, coordinator);
                    Trace.log1(this.getClass(), string, "Attribute loadModuleFilePath in a LoadModule MO has been updated according to UCF data,\n\tLoadModule MO: " + productNumberAndRevision + "\n\told loadModuleFilePath: " + string2 + "\n\tnew loadModuleFilePath: " + string3);
                } else {
                    int n;
                    Trace.log1(this.getClass(), string, "LM MO do NOT support version 7 where a predefined eNodeB where LM path is configured to runningSW/\n\tanLM_MO: " + loadModuleMoSU_Access + "\n\tLoadModule prod no and rev: " + productNumberAndRevision);
                    Class<?> clazz = loadModuleMoSU_Access.getClass();
                    Method[] methodArray = clazz.getMethods();
                    Object[] objectArray = null;
                    boolean bl = false;
                    String string4 = "setLMFP";
                    for (n = 0; n < methodArray.length; ++n) {
                        if (!methodArray[n].getName().equalsIgnoreCase(string4)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        throw new NoSuchAttributeException(string4, loadModuleMoSU_Access.getType());
                    }
                    objectArray = new Object[]{string3, coordinator};
                    methodArray[n].invoke((Object)loadModuleMoSU_Access, objectArray);
                    Trace.log1(this.getClass(), string, "Attribute loadModuleFilePath in a LoadModule MO has been updated according to UCF data by using reflection mechanism.\n\tLoadModule MO: " + loadModuleMoSU_Access);
                }
            }
            return loadModuleProxyInterface;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void updateLoadModuleData(LoadModuleMoSU_Access loadModuleMoSU_Access, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, int n2, boolean bl, String string8, boolean bl2, boolean bl3, Integer n3, Integer n4) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateLoadModuleData(LoadModuleMoSU_Access aLM_Mo, String aLoaderName, String aDeviceLoaderName, String aDeviceLoaderInformation, String anOtherLoaderName, String aFileFormat, String aPreloadAsString, String anOseProgramLoadClassAsString, int aProgramMemoryHeapSize, int aProgramMemoryPoolSize, boolean anIsSigned, String anExtension, boolean anIsLM_MoSupportingSU_AccessVersion3, boolean aDoRefreshFileState, Integer aRestartCounterLimit, Integer aRestartTimer)", "aLM_Mo: " + loadModuleMoSU_Access + "\n\taLoaderName: " + string + "\n\taDeviceLoaderName: " + string2 + "\n\taDeviceLoaderInformation: " + string3 + "\n\tanOtherLoaderName: " + string4 + "\n\taFileFormat: " + string5 + "\n\taPreloadAsString: " + string6 + "\n\tanOseProgramLoadClassAsString: " + string7 + "\n\taProgramMemoryHeapSize: " + n + "\n\taProgramMemoryPoolSize: " + n2 + "\n\tanIsSigned: " + bl + "\n\tanExension: " + string8 + "\n\tanIsLM_MoSupportingSU_AccessVersion3: " + bl2 + "\n\taDoRefreshFileState: " + bl3 + "\n\taRestartCounterLimit:" + n3 + "\n\taRestartTimer:" + n4);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            loadModuleMoSU_Access.setLoaderTypeForUpgrade(this.getLoaderType(string), coordinator);
            if (string4 != null) {
                loadModuleMoSU_Access.setOtherLoaderNameForUpgrade(string4, coordinator);
            }
            int n5 = this.getPreLoadIntValue(string6);
            loadModuleMoSU_Access.setPreLoad(n5, coordinator);
            if (string5 != null) {
                loadModuleMoSU_Access.setFileFormat(string5, coordinator);
            }
            loadModuleMoSU_Access.setOseProgramLoadClassForUpgrade(this.getOseProgramLoadClassIntValue(string7, bl2), coordinator);
            if (n2 != -1) {
                loadModuleMoSU_Access.setOseProgramPoolSize(n2, coordinator);
            }
            if (n != -1) {
                loadModuleMoSU_Access.setOseProgramHeapSize(n, coordinator);
            }
            if (string2 != null) {
                loadModuleMoSU_Access.setDeviceLoaderNameForUpgrade(string2, coordinator);
            }
            if (string3 != null) {
                loadModuleMoSU_Access.setDeviceLoaderInformationForUpgrade(string3, coordinator);
            }
            if (bl2) {
                boolean bl4 = false;
                if (bl3) {
                    bl4 = loadModuleMoSU_Access.getIsSignedSw(coordinator);
                }
                loadModuleMoSU_Access.setIsSignedSwForUpgrade(bl, coordinator);
                loadModuleMoSU_Access.setSignatureFileNameExtensionForUpgrade(string8, coordinator);
                if (bl3 && bl && !bl4) {
                    loadModuleMoSU_Access.refreshFileState(coordinator);
                    if (!this.myDoStateUpdateInAllPiuTypes) {
                        this.myDoStateUpdateInAllPiuTypes = true;
                    }
                }
            }
            if (this.isSU_VersionSupported("SU_8")) {
                loadModuleMoSU_Access.setRestartCounterLimitSU(n3.intValue(), coordinator);
                loadModuleMoSU_Access.setRestartTimerSU(n4.intValue(), coordinator);
            }
            Transaction.commit(control);
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            this.myDoStateUpdateInAllPiuTypes = false;
            Transaction.rollback(control);
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateLoadModuleData(LoadModuleMoSU_Access aLM_Mo, String aLoaderName, String aDeviceLoaderName, String aDeviceLoaderInformation, String anOtherLoaderName, String aFileFormat, String aPreloadAsString, String anOseProgramLoadClassAsString, int aProgramMemoryHeapSize, int aProgramMemoryPoolSize, boolean anIsSigned, String anExtension, boolean anIsLM_MoSupportingSU_AccessVersion3, boolean aDoRefreshFileState)", "Throwable caught.\n\taLM_Mo: " + loadModuleMoSU_Access + "\n\taLoaderName: " + string + "\n\taDeviceLoaderName: " + string2 + "\n\taDeviceLoaderInformation: " + string3 + "\n\tanOtherLoaderName: " + string4 + "\n\taFileFormat: " + string5 + "\n\taPreloadAsString: " + string6 + "\n\tanOseProgramLoadClassAsString: " + string7 + "\n\taProgramMemoryHeapSize: " + n + "\n\taProgramMemoryPoolSize: " + n2 + "\n\tanIsLM_MoSupportingSU_AccessVersion3: " + bl2 + "\n\taDoRefreshFileState: " + bl3, throwable);
            this.myDoStateUpdateInAllPiuTypes = false;
            Transaction.rollback(control);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public LoadModuleMoSU_Access createLoadModuleMO(ProductNumberAndRevision productNumberAndRevision, DocumentObjectProxyInterface documentObjectProxyInterface, String string, Coordinator coordinator) throws CreateLoadModuleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createLoadModuleMO(ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxy, String anUpgradeControlFileAbsoluteSourceFilePath, Coordinator aCoordinator)", "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanUpgradeControlFileAbsoluteSourceFilePath: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            LoadModuleProxyInterface loadModuleProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface().getLoadModuleProxyInterface(productNumberAndRevision);
            MoFactory moFactory = MoFactoryMgr.instance().lookup("LoadModule");
            AttrListImpl attrListImpl = this.getProductDataAndInsertInList(productNumberAndRevision, loadModuleProxyInterface, new AttrListImpl(32));
            attrListImpl = this.getInstallDataAndInsertInList(productNumberAndRevision, documentObjectProxyInterface, loadModuleProxyInterface, string, attrListImpl);
            attrListImpl = this.getInstallSMsAndInsertInList(loadModuleProxyInterface, attrListImpl);
            attrListImpl = this.getMoDataAndInsertInList(productNumberAndRevision, loadModuleProxyInterface, attrListImpl, this.isSU_VersionSupported("SU_3"));
            attrListImpl = this.getMoppletDataAndInsertInList(productNumberAndRevision, loadModuleProxyInterface, attrListImpl);
            attrListImpl = this.getDynamicClassDataAndInsertInList(productNumberAndRevision, loadModuleProxyInterface, attrListImpl);
            String string2 = loadModuleProxyInterface.getProductNumberRaw() + "_" + loadModuleProxyInterface.getProductRevisionRaw();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createLoadModuleMO(ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxy, String anUpgradeControlFileAbsoluteSourceFilePath)", "Creating a transaction to be used at creation of the LoadModule MO.");
            }
            SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
            LoadModuleMoSU_Access loadModuleMoSU_Access = (LoadModuleMoSU_Access)moFactory.createMo(singletonMoFactory.getMo(), (AttrList)attrListImpl, string2, null, coordinator);
            this.setDeviceDataInMoData(loadModuleMoSU_Access, loadModuleProxyInterface, coordinator);
            return loadModuleMoSU_Access;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createLoadModuleMO(ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxy, String anUpgradeControlFileAbsoluteSourceFilePath)", "Throwable caught when trying to create a LoadModule MO,\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanUpgradeControlFileAbsoluteSourceFilePath: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new CreateLoadModuleException("Exception caught when trying to create a LoadModule MO,\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tanUpgradeControlFileAbsoluteSourceFilePath: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Exception: " + throwable.toString());
        }
    }

    private void createLoadModuleMoMap() throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createLoadModuleMoMap( )");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator != null) {
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                this.myLoadModuleMoMap = new HashMap();
                if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null) continue;
                        this.myLoadModuleMoMap.put(loadModuleMoSU_Access.getProductNumberOpt(null) + loadModuleMoSU_Access.getProductRevisionOpt(null), loadModuleMoSU_Access);
                    }
                } else {
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (loadModuleMoSU_Access == null) continue;
                        this.myLoadModuleMoMap.put(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)) + StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)), loadModuleMoSU_Access);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createLoadModuleMap( )", "Throwable caught.", throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: createLoadModuleMap( )" + "\n\tThrowable caught." + "Original Exception: " + throwable.toString());
        }
    }

    private LoadModuleMoSU_Access getLoadModuleMoFromMap(String string, String string2) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMoFromMap(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tmyLoadModuleMoMap: " + this.myLoadModuleMoMap);
        }
        if (this.myLoadModuleMoMap == null) {
            this.createLoadModuleMoMap();
        }
        LoadModuleMoSU_Access loadModuleMoSU_Access = (LoadModuleMoSU_Access)this.myLoadModuleMoMap.get(string + string2);
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getLoadModuleMoFromMap(String aProductNumber, String aProductRevision)", "RETURNS - theLoadModuleMO: " + loadModuleMoSU_Access);
        }
        return loadModuleMoSU_Access;
    }

    private void setDeviceDataInMoData(LoadModuleMoSU_Access loadModuleMoSU_Access, LoadModuleProxyInterface loadModuleProxyInterface, Coordinator coordinator) throws LoadModuleMO_HandlerException {
        String string = "setDeviceDataInMoData(LoadModuleMoSU_Access aLM_MO, LoadModuleProxyInterface aLoadModuleProxy, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aLM_MO: " + loadModuleMoSU_Access + "\n\taLoadModuleProxy: " + loadModuleProxyInterface + "\n\taCoordinator: " + coordinator);
        }
        try {
            if (loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(LoaderName.DeviceLoader.getValue())) {
                loadModuleMoSU_Access.setLoaderTypeForUpgrade(6, coordinator);
                if (loadModuleProxyInterface.getDeviceLoaderName() != null) {
                    loadModuleMoSU_Access.setDeviceLoaderNameForUpgrade(loadModuleProxyInterface.getDeviceLoaderName(), coordinator);
                }
                if (loadModuleProxyInterface.getDeviceLoaderInformation() != null) {
                    loadModuleMoSU_Access.setDeviceLoaderInformationForUpgrade(loadModuleProxyInterface.getDeviceLoaderInformation(), coordinator);
                }
            }
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taLM_MO: " + loadModuleMoSU_Access + "\n\taLoadModuleProxy: " + loadModuleProxyInterface + "\n\taCoordinator: " + coordinator, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taLM_MO: " + loadModuleMoSU_Access + "\n\taLoadModuleProxy: " + loadModuleProxyInterface + "\n\taCoordinator: " + coordinator + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private Vector removeLoadModuleIdentifierFromList(String string, String string2, Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeLoadModuleIdentifierFromList(String aProductNumber, String aProductRevision, Vector aLoadModuleIdentifiers)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taLoadModuleIdentifiers: " + vector);
        }
        Vector<ProductNumberAndRevision> vector2 = new Vector<ProductNumberAndRevision>(1);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ProductNumberAndRevision productNumberAndRevision = (ProductNumberAndRevision)enumeration.nextElement();
            if (productNumberAndRevision.equals(string, string2)) continue;
            vector2.addElement(productNumberAndRevision);
        }
        return vector2;
    }

    public Collection getLoadModuleProgramInformations(Collection collection) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleProgramInformations(Collection aLoadModuleMoSU_Accesses)", "aLoadModuleMoSU_Accesses: " + collection);
        }
        LinkedList<LoadModuleProgramInformation> linkedList = new LinkedList<LoadModuleProgramInformation>();
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        String string = null;
        String string2 = null;
        LoadModuleProgramInformation loadModuleProgramInformation = null;
        LinkedList<String> linkedList2 = null;
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                string = this.getOseProgramLoadClassStringValue(loadModuleMoSU_Access.getOseProgramLoadClass(null));
                string2 = this.getLoaderName(loadModuleMoSU_Access.getLoaderType(null));
                linkedList2 = new LinkedList<String>();
                linkedList2.add(loadModuleMoSU_Access.getRealLoadModuleFilePath(null));
                loadModuleProgramInformation = ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5") ? new LoadModuleProgramInformation(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null), string, string2, linkedList2) : new LoadModuleProgramInformation(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)), string, string2, linkedList2);
                linkedList.add(loadModuleProgramInformation);
            }
            return linkedList;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw loadModuleMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleProgramInformations(Collection aLoadModuleMoSU_Accesses)", "Throwable caught.\n\taLoadModuleMoSU_Accesses: " + collection, throwable);
            throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetLoadModuleProgramInformations(Collection aLoadModuleMoSU_Accesses)" + "\n\tThrowable caught." + "\n\taProductNumberAndRevisionInterfaces: " + collection + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private String getLoaderName(int n) throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoaderName(int aLoaderType)", "aLoaderType: " + n);
        }
        String string = EMPTY_STRING;
        if (n == 0) {
            string = LoaderName.OSE_Loader.getValue();
        } else if (n == 1) {
            string = LoaderName.SPM_Loader.getValue();
        } else if (n == 2) {
            string = LoaderName.JVM.getValue();
        } else if (n == 3) {
            string = LoaderName.Webserver.getValue();
        } else if (n == 4) {
            string = LoaderName.SPM_FPGA_Loader.getValue();
        } else if (n == 5) {
            string = LoaderName.XP_Loader.getValue();
        } else if (n == 6) {
            string = LoaderName.DeviceLoader.getValue();
        } else if (n == 99) {
            string = LoaderName.Other.getValue();
        }
        if (string != EMPTY_STRING) {
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoaderName(int aLoaderType)", "RETURNS - theLoaderName: " + string);
            }
            return string;
        }
        throw new LoadModuleMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getLoaderName(int aLoaderType)" + "\n\tConversion to loaderName (String value) for input int value (aLoaderType) is not supported," + "\n\taLoaderType: " + n);
    }

    private void setFileState(LoadModuleMoSU_Access loadModuleMoSU_Access, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setFileState(LoadModuleMoSU_Access theLoadModuleMoSU_Access,Coordinator theCoordinator)", "\n\tanLoadModuleMoSU_Access" + loadModuleMoSU_Access + "\n\tanCoordinator" + coordinator);
        }
        if (this.isSU_VersionSupported("SU_6")) {
            loadModuleMoSU_Access.setFileStateForSu(LoadModuleState.Installed.getValue(), coordinator);
        } else {
            ((LoadModuleMoSU_Access1)loadModuleMoSU_Access).setFileState(LoadModuleState.Installed.getValue(), coordinator);
        }
    }

    private Map buildSetOfLM_MOsMap() throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "buildSetOfLM_MOsMap()");
        }
        try {
            HashMap<String, LoadModuleMoSU_Access> hashMap = new HashMap<String, LoadModuleMoSU_Access>();
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator == null) {
                return hashMap;
            }
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            String string = null;
            while (moIterator.hasMoreElements()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                string = this.isSU_VersionSupported("SU_5") ? loadModuleMoSU_Access.getProductNumberOpt(null) + "_" + loadModuleMoSU_Access.getProductRevisionOpt(null) : StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)) + "_" + StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null));
                if (hashMap.get(string) == null) {
                    hashMap.put(string, loadModuleMoSU_Access);
                    continue;
                }
                Trace.error(this.getClass(), "buildSetOfLM_MOsMap()", "More than one LM MO has been configured with the same product number and revision. This may result in an inconsistent configuration of the node\n\ttheProdNoRevKey: " + string + "\n\tWill use the LM MO instance: " + hashMap.get(string) + "\n\tIgnoring the LM MO instance: " + loadModuleMoSU_Access);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "buildSetOfLM_MOsMap()", "Throwable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }
}

