/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.piutype;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.xml.sax.AttributeList;
import se.ericsson.cello.configurationversion.main.exception.ProductNumberAndRevisionNotAllowedException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extif.sudom.proxy.piutype.MoConfigurationInterface;
import se.ericsson.cello.sudom.extif.sudom.proxy.piutype.PiuTypeDataInterface;
import se.ericsson.cello.sudom.extif.sudom.proxy.piutype.ProgramConfigurationInterface;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.InvalidProductRevisionFormatException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuTypeDataAttributeName;
import se.ericsson.cello.sudom.proxy.piutype.DefaultPiuRoleValue;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypeProxyInterface;
import se.ericsson.cello.sudom.proxy.transform.TransformProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoFactorySU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access1;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformations;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.enumer.LoadModuleInstalledState;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.base.MO_HandlerBase;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeInformations;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class PiuTypeMO_Handler
extends MO_HandlerBase
implements PiuTypeMO_HandlerInterface {
    public PiuTypeMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "PiuTypeMO_Handler (MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public void createPiuTypeMO(AttributeList attributeList, AttributeList attributeList2, Vector vector, Vector vector2, Vector vector3) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "prodDataPiuType: " + attributeList + "\n\tpiuTypeData: " + attributeList2 + "\n\tprogramConfig: " + vector + "\n\tmaoConfig: " + vector2 + "\n\taPiuTypeMosData: " + vector3);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            String string;
            String string2 = attributeList.getValue("name");
            String string3 = attributeList.getValue("number");
            String string4 = attributeList.getValue("revision");
            String string5 = attributeList.getValue("type");
            String string6 = attributeList.getValue("date");
            if (string6 == null) {
                string6 = "";
            }
            if ((string = attributeList.getValue("information")) == null) {
                string = "";
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "PiuType Product data: \n\tProductNumber: " + string3 + "\n\tProductRevision: " + string4 + "\n\tName: " + string2 + "\n\tType: " + string5 + "\n\tDate: " + string6 + "\n\tpInfo: " + string);
            }
            int n = Integer.parseInt(attributeList2.getValue("boardWidth"));
            String string7 = attributeList2.getValue("defaultPiuRole");
            int n2 = 3;
            if (string7 != null) {
                if (string7.equalsIgnoreCase("bp")) {
                    n2 = 2;
                } else if (string7.equalsIgnoreCase("mp")) {
                    n2 = 1;
                }
            }
            Float f = new Float(250.0f);
            Float f2 = new Float(400.0f);
            Float f3 = new Float(250.0f);
            Float f4 = new Float(400.0f);
            String string8 = attributeList2.getValue("normalLowTempAirFlow");
            if (string8 != null) {
                f = Float.valueOf(string8);
            }
            if ((string8 = attributeList2.getValue("normalHighTempAirFlow")) != null) {
                f2 = Float.valueOf(string8);
            }
            if ((string8 = attributeList2.getValue("noiseReducedLowTempAirFlow")) != null) {
                f3 = Float.valueOf(string8);
            }
            if ((string8 = attributeList2.getValue("noiseReducedHighTempAirFlow")) != null) {
                f4 = Float.valueOf(string8);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "PiuType PiuTypeData: \n\tBoard width: " + n + "\n\tdefault Piu Role: " + n2 + "\n\tnormalLowTempAirFlow: " + f + "\n\tnormalHighTempAirFlow: " + f2 + "\n\tnoiseReducedLowTempAirFlow: " + f3 + "\n\tnoiseReducedHighTempAirFlow: " + f4);
            }
            String[] stringArray = new String[]{"productName", "productNumber", "productRevision", "productionDate", "productInfo"};
            Object[] objectArray = new Object[]{string2, string3, string4, string6, string};
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            String[] stringArray2 = new String[]{"normalLowTempAirFlow", "normalHighTempAirFlow", "noiseReducedLowTempAirFlow", "noiseReducedHighTempAirFlow"};
            Object[] objectArray2 = new Object[]{f, f2, f3, f4};
            StructImpl structImpl2 = new StructImpl(stringArray2, objectArray2);
            String string9 = attributeList2.getValue(PiuTypeDataAttributeName.DefAllowedSeqRestarts.getValue());
            int n3 = this.getDefAllowedSeqRestartsAsInt(string9);
            AttrListImpl attrListImpl = new AttrListImpl(5);
            attrListImpl.addElement("productData", (Object)structImpl);
            attrListImpl.addElement("role", (Object)new Integer(n2));
            attrListImpl.addElement("boardWidth", (Object)new Integer(n));
            attrListImpl.addElement("isInstalled", (Object)new Boolean(false));
            attrListImpl.addElement("airFlowData", (Object)structImpl2);
            attrListImpl.addElement("defAllowedSeqRestarts", (Object)new Integer(n3));
            String string10 = this.calculateLDN_Value(string3, string4, string2, vector3);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "Creating a PIU Type MO with LDN value '" + string10 + "'.");
            }
            SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            PiuTypeMoFactorySU_Access piuTypeMoFactorySU_Access = (PiuTypeMoFactorySU_Access)MoFactoryMgr.instance().lookup("PiuType");
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)piuTypeMoFactorySU_Access.createMoAtUpgrade(singletonMoFactory.getMo(), (AttrList)attrListImpl, string10, coordinator);
            this.setPiuRole(piuTypeMoSU_Access, string7, coordinator);
            String[] stringArray3 = new String[]{"tag", "loadableProcessorName", "subParentLDN", "programMoTypeName"};
            Object[] objectArray3 = new Object[4];
            for (int i = 0; i < vector.size(); ++i) {
                objectArray3[0] = ((AttributeList)vector.elementAt(i)).getValue("tag");
                objectArray3[1] = ((AttributeList)vector.elementAt(i)).getValue("execUnitNameInfo");
                objectArray3[2] = "";
                if (((AttributeList)vector.elementAt(i)).getValue("subParentLdn") != null) {
                    objectArray3[2] = ((AttributeList)vector.elementAt(i)).getValue("subParentLdn");
                }
                objectArray3[3] = ((AttributeList)vector.elementAt(i)).getValue("moTypeName");
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "\n\tPiuType adding program configuration.\n\tTag: " + objectArray3[0] + "\n\tExecUnitName: " + objectArray3[1] + "\n\tParent LDN: " + objectArray3[2] + "\n\tMO Type name: " + objectArray3[3]);
                }
                piuTypeMoSU_Access.addProgramConfiguration((Struct)new StructImpl(stringArray3, objectArray3), coordinator);
            }
            String[] stringArray4 = new String[]{"spSubParentLDN", "moTypeNamea", "identity"};
            Object[] objectArray4 = new Object[3];
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "PIU type set MO config.");
            }
            for (int i = 0; i < vector2.size(); ++i) {
                objectArray4[0] = ((AttributeList)vector2.elementAt(i)).getValue("subParentLdn") == null ? "" : ((AttributeList)vector2.elementAt(i)).getValue("subParentLdn");
                objectArray4[1] = ((AttributeList)vector2.elementAt(i)).getValue("moTypeName");
                objectArray4[2] = ((AttributeList)vector2.elementAt(i)).getValue("identity");
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "PIU Type adding Mo Configuration.\n\tSub parent LDN: " + objectArray4[0] + "\n\tMO type name: " + objectArray4[1] + "\n\tIdentity: " + objectArray4[2]);
                }
                piuTypeMoSU_Access.addMoConfiguration((Struct)new StructImpl(stringArray4, objectArray4), coordinator);
            }
            control.getTerminator().commit();
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "MoAccessException caught at creation of a PiuType MO's.\n\tprodDataPiuType: " + attributeList + "\n\tpiuTypeData: " + attributeList2 + "\n\tprogramConfig: " + vector + "\n\tmaoConfig: " + vector2 + "\n\ttMoAccessException: " + moAccessException.toString(), moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("MoAccessException caught at creation of a PiuType MO's.\n\tprodDataPiuType: " + attributeList + "\n\tpiuTypeData: " + attributeList2 + "\n\tprogramConfig: " + vector + "\n\tmaoConfig: " + vector2 + "\n\tMoAccessException: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)", "Exception caught at creation of a PiuType MO's.\n\tprodDataPiuType: " + attributeList + "\n\tpiuTypeData: " + attributeList2 + "\n\tprogramConfig: " + vector + "\n\tmaoConfig: " + vector2 + "\n\tExeption: " + exception.toString(), exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("createPiuTypeMO (AttributeList prodDataPiuType, AttributeList piuTypeData, Vector programConfig, Vector maoConfig, Vector aPiuTypeMosData)Exception caught at creation of a PiuType MO's.\n\tprodDataPiuType: " + attributeList + "\n\tpiuTypeData: " + attributeList2 + "\n\tprogramConfig: " + vector + "\n\tmaoConfig: " + vector2 + "\n\tExeption: " + exception.toString());
        }
    }

    public PiuTypeMoSU_Access createPiuTypeMO(PiuTypeProxyInterface piuTypeProxyInterface, TransformProxyInterface transformProxyInterface, Vector vector) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createPiuTypeMO(PiuTypeProxyInterface aPiuTypeProxyInterface, TransformProxyInterface aTransformProxyInterface, Vector aPiuTypeMosData)", "aPiuTypeProxyInterface: " + piuTypeProxyInterface + "\n\taTransformProxyInterface: " + transformProxyInterface + "\n\taPiuTypeMosData: " + vector);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            String string;
            String string2 = piuTypeProxyInterface.getProductNumberRaw();
            String string3 = piuTypeProxyInterface.getProductRevisionRaw();
            String string4 = piuTypeProxyInterface.getProductName();
            String string5 = piuTypeProxyInterface.getProductDate();
            if (string5 == null) {
                string5 = "";
            }
            if ((string = piuTypeProxyInterface.getProductInformation()) == null) {
                string = "";
            }
            String[] stringArray = new String[]{"productName", "productNumber", "productRevision", "productionDate", "productInfo"};
            Object[] objectArray = new Object[]{string4, string2, string3, string5, string};
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            PiuTypeDataInterface piuTypeDataInterface = piuTypeProxyInterface.getPiuTypeDataInterface();
            Integer n = piuTypeDataInterface.getBoardWidth();
            DefaultPiuRoleValue defaultPiuRoleValue = piuTypeProxyInterface.getDefaultPiuRoleValue();
            if (defaultPiuRoleValue.getValue() == DefaultPiuRoleValue.GP.getValue() && !this.isSU_VersionSupported("SU_2")) {
                defaultPiuRoleValue = piuTypeProxyInterface.getTransformedDefaultPiuRole(transformProxyInterface);
            }
            Float f = new Float(250.0f);
            if (piuTypeDataInterface.getNormalLowTempAirFlow() != null) {
                f = piuTypeDataInterface.getNormalLowTempAirFlow();
            }
            Float f2 = new Float(400.0f);
            if (piuTypeDataInterface.getNormalHighTempAirFlow() != null) {
                f2 = piuTypeDataInterface.getNormalHighTempAirFlow();
            }
            Float f3 = new Float(250.0f);
            if (piuTypeDataInterface.getNoiseReducedLowTempAirFlow() != null) {
                f3 = piuTypeDataInterface.getNoiseReducedLowTempAirFlow();
            }
            Float f4 = new Float(400.0f);
            if (piuTypeDataInterface.getNoiseReducedHighTempAirFlow() != null) {
                f4 = piuTypeDataInterface.getNoiseReducedHighTempAirFlow();
            }
            String string6 = piuTypeDataInterface.getDefAllowedSeqRestarts();
            int n2 = this.getDefAllowedSeqRestartsAsInt(string6);
            String[] stringArray2 = new String[]{"normalLowTempAirFlow", "normalHighTempAirFlow", "noiseReducedLowTempAirFlow", "noiseReducedHighTempAirFlow"};
            Object[] objectArray2 = new Object[]{f, f2, f3, f4};
            StructImpl structImpl2 = new StructImpl(stringArray2, objectArray2);
            AttrListImpl attrListImpl = new AttrListImpl(5);
            attrListImpl.addElement("productData", (Object)structImpl);
            attrListImpl.addElement("role", (Object)new Integer(defaultPiuRoleValue.getValue()));
            attrListImpl.addElement("boardWidth", (Object)n);
            attrListImpl.addElement("isInstalled", (Object)new Boolean(false));
            attrListImpl.addElement("airFlowData", (Object)structImpl2);
            attrListImpl.addElement("defAllowedSeqRestarts", (Object)new Integer(n2));
            String string7 = this.calculateLDN_Value(string2, string3, string4, vector);
            SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            PiuTypeMoFactorySU_Access piuTypeMoFactorySU_Access = (PiuTypeMoFactorySU_Access)MoFactoryMgr.instance().lookup("PiuType");
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)piuTypeMoFactorySU_Access.createMoAtUpgrade(singletonMoFactory.getMo(), (AttrList)attrListImpl, string7, coordinator);
            String[] stringArray3 = new String[]{"tag", "loadableProcessorName", "subParentLDN", "programMoTypeName"};
            Iterator iterator = piuTypeProxyInterface.getProgramConfigurationInterfaces().iterator();
            ProgramConfigurationInterface programConfigurationInterface = null;
            Object[] objectArray3 = new Object[4];
            while (iterator.hasNext()) {
                programConfigurationInterface = (ProgramConfigurationInterface)iterator.next();
                objectArray3[0] = programConfigurationInterface.getTag().toString();
                objectArray3[1] = programConfigurationInterface.getExecUnitNameInfo();
                objectArray3[2] = programConfigurationInterface.getSubParentLdn() != null ? programConfigurationInterface.getSubParentLdn() : "";
                objectArray3[3] = programConfigurationInterface.getMoTypeName();
                piuTypeMoSU_Access.addProgramConfiguration((Struct)new StructImpl(stringArray3, objectArray3), coordinator);
            }
            String[] stringArray4 = new String[]{"spSubParentLDN", "moTypeNamea", "identity"};
            Object[] objectArray4 = new Object[3];
            Iterator iterator2 = piuTypeProxyInterface.getMoConfigurationInterfaces().iterator();
            MoConfigurationInterface moConfigurationInterface = null;
            while (iterator2.hasNext()) {
                moConfigurationInterface = (MoConfigurationInterface)iterator2.next();
                objectArray4[0] = moConfigurationInterface.getSubParentLdn() != null ? moConfigurationInterface.getSubParentLdn() : "";
                objectArray4[1] = moConfigurationInterface.getMoTypeName();
                objectArray4[2] = moConfigurationInterface.getIdentity();
                piuTypeMoSU_Access.addMoConfiguration((Struct)new StructImpl(stringArray4, objectArray4), coordinator);
            }
            Transaction.commit(control);
            return piuTypeMoSU_Access;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createPiuTypeMO(PiuTypeProxyInterface aPiuTypeProxyInterface, Vector aPiuTypeMosData)", "aPiuTypeProxyInterface: " + piuTypeProxyInterface + "\n\taPiuTypeMosData: " + vector, throwable);
            Transaction.rollback(control);
            throw new PiuTypeMO_HandlerException(throwable.toString());
        }
    }

    public PiuTypeMoSU_Access createPiuTypeMo(PiuTypeProxyInterface piuTypeProxyInterface, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createPiuTypeMo(PiuTypeProxyInterface aPiuTypeProxyInterface, Coordinator aCoordinator)", "aPiuTypeProxyInterface: " + piuTypeProxyInterface);
        }
        try {
            SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
            ManagedObject managedObject = singletonMoFactory.getMo();
            String string = this.calculateRDN_Value(piuTypeProxyInterface.getProductNumberRaw(), piuTypeProxyInterface.getProductRevisionRaw(), "PiuType", managedObject.getLocalDistinguishedName());
            PiuTypeMoFactorySU_Access piuTypeMoFactorySU_Access = (PiuTypeMoFactorySU_Access)MoFactoryMgr.instance().lookup("PiuType");
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)piuTypeMoFactorySU_Access)) {
                PiuTypeMoSU_Access piuTypeMoSU_Access = piuTypeMoFactorySU_Access.createMoAtUpgrade2(managedObject, string, piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision(), "Created by System Upgrade function", coordinator);
                return piuTypeMoSU_Access;
            }
            throw new PiuTypeMO_HandlerException("The PiuTypeMoFactory is not supporting required version 2 i.e. the current supported versions are: " + SuLib.toString(piuTypeMoFactorySU_Access.getSupportedVersions()));
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            throw piuTypeMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createSubrackProdTypeMo(SubrackProdTypeProxyInterface aSubrackProdTypeProxyInterface, Coordinator aCoordinator)", "aPiuTypeProxyInterface: " + piuTypeProxyInterface + "\n\tThrowable caught.", throwable);
            throw new PiuTypeMO_HandlerException(throwable.toString());
        }
    }

    public void deleteAllMatchingPiuTypeMos(boolean bl) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteAllMatchingPiuTypeMos(boolean anIsInstalled)", "anIsInstalled: " + bl);
        }
        try {
            Vector vector = this.getMatchingPiuTypeMos(bl);
            this.deletePiuTypeMos(vector);
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            Trace.error(this.getClass(), "deleteAllMatchingPiuTypeMos(boolean anIsInstalled)", "PiuTypeMO_HandlerException caught at deletion of all matching PiuType MO's, anIsInstalled: " + bl, (Throwable)((Object)piuTypeMO_HandlerException));
            throw piuTypeMO_HandlerException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteAllMatchingPiuTypeMos(boolean anIsInstalled)", "Exception caught at deletion of all matching PiuType MO's, anIsInstalled: " + bl, exception);
            throw new PiuTypeMO_HandlerException("deleteAllMatchingPiuTypeMos(boolean anIsInstalled)\n\tanIsInstalled: " + bl + "\n\tException caught at deletion of all matching PiuType MO's: " + exception.toString());
        }
    }

    public void deleteAllNotMatchingPiuTypeMos(ProductNumbersAndRevisions productNumbersAndRevisions) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteAllNotMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "aProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        try {
            Vector vector = this.getNotMatchingPiuTypeMos(productNumbersAndRevisions);
            this.deletePiuTypeMos(vector);
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            Trace.error(this.getClass(), "deleteAllNotMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "PiuTypeMO_HandlerException caught at deletion of all NOT matching PiuType MO's, \n\taProductNumbersAndRevisions: " + productNumbersAndRevisions, (Throwable)((Object)piuTypeMO_HandlerException));
            throw piuTypeMO_HandlerException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteAllNotMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "Exception caught at deletion of all NOT matching PiuType MO's, \n\taProductNumbersAndRevisions: " + productNumbersAndRevisions, exception);
            throw new PiuTypeMO_HandlerException("deleteAllNotMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tException caught at deletion of all NOT matching PiuType MO's: " + exception.toString());
        }
    }

    public void deletePiuTypeMo(PiuTypeMoSU_Access piuTypeMoSU_Access, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deletePiuTypeMo(PiuTypeMoSU_Access aPiuTypeMo, Coordinator aCoordinator)", "aPiuTypeMo: " + piuTypeMoSU_Access);
        }
        try {
            piuTypeMoSU_Access.delete(coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deletePiuTypeMo(PiuTypeMoSU_Access aPiuTypeMo, Coordinator aCoordinator)", "Throwable caught.\n\taPiuTypeMo: " + piuTypeMoSU_Access, throwable);
            throw new PiuTypeMO_HandlerException(throwable.toString());
        }
    }

    public void deleteAllPiuTypeMos() throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteAllPiuTypeMos ()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
            if (moIterator != null) {
                PiuTypeMoSU_Access piuTypeMoSU_Access = null;
                while (moIterator.hasMoreElements()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "deleteAllPiuTypeMos ()", "PiuType MO '" + piuTypeMoSU_Access + "' to be deleted.");
                    }
                    piuTypeMoSU_Access.delete(coordinator);
                }
            }
            control.getTerminator().commit();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Trace.error(this.getClass(), "deleteAllPiuTypeMos ()", "TransactionRolledBackException caught at deletion of all existing PiuType MO's.", transactionRolledBackException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("deleteAllPiuTypeMos ()\n\tTransactionRolledBackException caught at deletion of all existing PiuType MO's: " + transactionRolledBackException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteAllPiuTypeMos ()", "Exception caught at deletion of all existing PiuType MO's.", exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("deleteAllPiuTypeMos ()\n\tException caught at deletion of all existing PiuType MO's: " + exception.toString());
        }
    }

    public ProductNumbersAndRevisions extractNotReplacedPiuTypes(Vector vector, ProductNumbersAndRevisions productNumbersAndRevisions) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "extractNotReplacedPiuTypes(Vector aPiuTypeMoDatas, ProductNumbersAndRevisions aProductNumbersAndRevisions)", "aPiuTypeMoDatas: " + vector + "\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        ProductNumbersAndRevisions productNumbersAndRevisions2 = new ProductNumbersAndRevisions();
        PiuTypeMoData piuTypeMoData = null;
        Object var5_5 = null;
        String string = null;
        UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
        try {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                if (productNumbersAndRevisions.containsWithAnyRevisionRuleForIn(piuTypeMoData.productNumber, piuTypeMoData.productRevision) || (string = upgradeablePIU_HandlerInterface.getOriginRevision(piuTypeMoData.plugInUnit)) != null && !string.equals("") && productNumbersAndRevisions.containsWithAnyRevisionRuleForIn(piuTypeMoData.productNumber, string)) continue;
                productNumbersAndRevisions2.addElement(piuTypeMoData.productNumber, piuTypeMoData.productRevision, null);
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "extractNotReplacedPiuTypes(Vector aPiuTypeMoDatas, ProductNumbersAndRevisions aProductNumbersAndRevisions)", "Not replaced PiuType found and added to result Vector,\n\tproductNumber: " + piuTypeMoData.productNumber + ", productRevision: " + piuTypeMoData.productRevision);
            }
            return productNumbersAndRevisions2;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "extractNotReplacedPiuTypes(Vector aPiuTypeMoDatas, ProductNumbersAndRevisions aProductNumbersAndRevisions)", "Exception caught when trying to extract not replaced PiuTypes,\n\taPiuTypeMoDatas: " + vector + "\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tcurrent ProductNumberAndRevision: " + var5_5, exception);
            throw new PiuTypeMO_HandlerException("extractNotReplacedPiuTypes(Vector aPiuTypeMoDatas, ProductNumbersAndRevisions aProductNumbersAndRevisions)\n\tException caught when trying to extract not replaced PiuTypes,\n\taPiuTypeMoDatas: " + vector + "\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tcurrent ProductNumberAndRevision: " + var5_5 + "\n\tException: " + exception.toString());
        }
    }

    public Vector getAllCurrentPiuTypeMoDatas() throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllCurrentPiuTypeMoDatas ()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
            Vector<PiuTypeMoData> vector = new Vector<PiuTypeMoData>();
            if (moIterator != null) {
                PiuTypeMoSU_Access piuTypeMoSU_Access = null;
                if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                    while (moIterator.hasMoreElements()) {
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                        PiuTypeMoData piuTypeMoData = new PiuTypeMoData(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null), piuTypeMoSU_Access.getNamingAttributeValue());
                        vector.add(piuTypeMoData);
                    }
                } else {
                    Struct struct = null;
                    while (moIterator.hasMoreElements()) {
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                        struct = piuTypeMoSU_Access.getProductData(null);
                        PiuTypeMoData piuTypeMoData = new PiuTypeMoData(StringHandler.optimize((String)struct.getValue("productNumber")), StringHandler.optimize((String)struct.getValue("productRevision")), piuTypeMoSU_Access.getNamingAttributeValue());
                        vector.add(piuTypeMoData);
                    }
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getAllCurrentPiuTypeMoDatas()", "RETURNS - theCurrentPiuTypeMoDatas: " + vector);
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getAllCurrentPiuTypeMoDatas ()", "Mo access exception caught when collection PiuType MO's data.", moAccessException);
            throw new PiuTypeMO_HandlerException("getAllCurrentPiuTypeMoDatas ()\n\tMo access exception caught when collection PiuType MO's data." + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getAllCurrentPiuTypeMoDatas ()", "Exception caught when collection PiuType MO's data.", exception);
            throw new PiuTypeMO_HandlerException("getAllCurrentPiuTypeMoDatas ()\n\tException caught when collection PiuType MO's data." + exception.toString());
        }
    }

    public PiuTypeMoData getPiuTypeData(PiuTypeMoSU_Access piuTypeMoSU_Access) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypeData ()");
        }
        try {
            if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                return new PiuTypeMoData(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null), piuTypeMoSU_Access.getLocalDistinguishedName());
            }
            return new PiuTypeMoData(StringHandler.optimize((String)piuTypeMoSU_Access.getProductData(null).getValue("productNumber")), StringHandler.optimize((String)piuTypeMoSU_Access.getProductData(null).getValue("productRevision")), piuTypeMoSU_Access.getLocalDistinguishedName());
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getPiuTypeData ()", "MoAccessException caught at retreival of PiuType data for PiuTypeMo " + piuTypeMoSU_Access, moAccessException);
            throw new PiuTypeMO_HandlerException("getPiuTypeData ()\n\tMoAccessException caught at retreival of PiuType data for PiuTypeMo " + piuTypeMoSU_Access + "\n\tMoAccessException: " + moAccessException.toString());
        }
    }

    public PiuTypeMoSU_Access getPiuTypeMo(String string, String string2) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypeMo ( String aProductNumber, String aProductRevision )", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        return this.getPiuTypeMo(string, string2, true, null);
    }

    public PiuTypeMoSU_Access getPiuTypeMo(String string, String string2, boolean bl, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanIsInstalled: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            String string3 = this.getShortProductRevision(string2);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)", "theShortProductRevision: " + string3);
            }
            if (string3 != null) {
                MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
                PiuTypeMoSU_Access piuTypeMoSU_Access = null;
                if (moIterator != null) {
                    while (moIterator.hasMoreElements()) {
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "---getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)", "thePiuTypeMo: " + piuTypeMoSU_Access + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tisInstalled: " + piuTypeMoSU_Access.getIsInstalled(coordinator));
                        }
                        if (piuTypeMoSU_Access.getIsInstalled(coordinator) != bl || !piuTypeMoSU_Access.matchPiuTypeMo(string, string2, coordinator)) continue;
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)", "RETURNS - thePiuTypeMo: " + piuTypeMoSU_Access);
                        }
                        return piuTypeMoSU_Access;
                    }
                    if (!string3.equals(string2)) {
                        moIterator.reset();
                        while (moIterator.hasMoreElements()) {
                            piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                            if (piuTypeMoSU_Access.getIsInstalled(coordinator) != bl || !piuTypeMoSU_Access.matchPiuTypeMo(string, string3, coordinator)) continue;
                            return piuTypeMoSU_Access;
                        }
                    }
                    moIterator.reset();
                    while (moIterator.hasMoreElements()) {
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                        if (piuTypeMoSU_Access.getIsInstalled(coordinator) != bl || !piuTypeMoSU_Access.matchPiuTypeMo(string, "*", coordinator)) continue;
                        return piuTypeMoSU_Access;
                    }
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)", "RETURNS - null");
            }
            return null;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanIsInstalled: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tMoAccessException caught." + "\n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            throw new PiuTypeMO_HandlerException("getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanIsInstalled: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tMoAccessException caught." + "\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanIsInstalled: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException caught." + "\n\tException data: " + exception.toString(), exception);
            throw new PiuTypeMO_HandlerException("getPiuTypeMo(String aProductNumber, String aProductRevision, boolean anIsInstalled, Coordinator aCoordinator)\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanIsInstalled: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException caught." + "\n\tException data: " + exception.toString());
        }
    }

    public PiuTypeInformations getPiuTypeInformations() throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypeInformations()");
        }
        try {
            Iterator iterator = this.getAllPiuTypeMOs().iterator();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            PiuTypeInformations piuTypeInformations = new PiuTypeInformations();
            if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                while (iterator.hasNext()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                    piuTypeInformations.put(piuTypeMoSU_Access, piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null));
                }
            } else {
                while (iterator.hasNext()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                    piuTypeInformations.put(piuTypeMoSU_Access, StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null)));
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getPiuTypeInformations()", "RETURNS - thePiuTypeInformations: " + piuTypeInformations);
            }
            return piuTypeInformations;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getProductNumberAndRevisions()", "Throwable caught", throwable);
            throw new PiuTypeMO_HandlerException(throwable.toString());
        }
    }

    public void setIsInstalledInAllNotMatchingPiuTypeMOs(ProductNumbersAndRevisions productNumbersAndRevisions, boolean bl) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIsInstalledInAllNotMatchingPiuTypeMOs(ProductNumbersAndRevisions aProductNumbersAndRevisions, boolean anIsInstalled)", "aProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tanIsInstalled: " + bl);
        }
        try {
            Vector vector = this.getNotMatchingPiuTypeMos(productNumbersAndRevisions);
            this.setIsInstalledInPiuTypeMos(vector, bl);
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            Trace.error(this.getClass(), "setIsInstalledInAllNotMatchingPiuTypeMOs(ProductNumbersAndRevisions aProductNumbersAndRevisions, boolean anIsInstalled)", "PiuTypeMO_HandlerException caught at setting of isInstalled in all NOT matching PiuType MO's, \n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tanIsInstalled: " + bl, (Throwable)((Object)piuTypeMO_HandlerException));
            throw piuTypeMO_HandlerException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setIsInstalledInAllNotMatchingPiuTypeMOs(ProductNumbersAndRevisions aProductNumbersAndRevisions, boolean anIsInstalled)", "Exception caught at setting of isInstalled in all NOT matching PiuType MO's, \n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tanIsInstalled: " + bl, exception);
            throw new PiuTypeMO_HandlerException("setIsInstalledInAllNotMatchingPiuTypeMOs(ProductNumbersAndRevisions aProductNumbersAndRevisions, boolean anIsInstalled)\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tanIsInstalled: " + bl + "\n\tException caught at setting of isInstalled in all NOT matching PiuType MO's: " + exception.toString());
        }
    }

    public void setIsInstalledInAllPiuTypeMOs() throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIsInstalledInAllPiuTypeMOs ()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
            if (moIterator != null) {
                PiuTypeMoSU_Access piuTypeMoSU_Access = null;
                while (moIterator.hasMoreElements()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "setIsInstalledInAllPiuTypeMOs ()", "Setting attribute 'isInstalled' to true in PiuType MO '" + piuTypeMoSU_Access + "'.");
                    }
                    piuTypeMoSU_Access.setIsInstalled(true, coordinator);
                }
            }
            control.getTerminator().commit();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Trace.error(this.getClass(), "setIsInstalledInAllPiuTypeMOs ()", "TransactionRolledBackException caught at deletion of all existing PiuType MO's.", transactionRolledBackException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("setIsInstalledInAllPiuTypeMOs ()\n\tTransactionRolledBackException caught at deletion of all existing PiuType MO's.\n\tTransactionRolledBackException: " + transactionRolledBackException.toString());
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            Trace.error(this.getClass(), "setIsInstalledInAllPiuTypeMOs ()", "InactiveTransactionException caught at deletion of all existing PiuType MO's.", inactiveTransactionException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("setIsInstalledInAllPiuTypeMOs ()\n\tInactiveTransactionException caught at deletion of all existing PiuType MO's.\n\tInactiveTransactionException: " + inactiveTransactionException.toString());
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "setIsInstalledInAllPiuTypeMOs ()", "MoAccessException caught at deletion of all existing PiuType MO's.", moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("setIsInstalledInAllPiuTypeMOs ()\n\tMoAccessException caught at deletion of all existing PiuType MO's.\n\tMoAccessException: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setIsInstalledInAllPiuTypeMOs ()", "Exception caught at deletion of all existing PiuType MO's.", exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("setIsInstalledInAllPiuTypeMOs ()\n\tException caught at deletion of all existing PiuType MO's.\n\tException: " + exception.toString());
        }
    }

    public void setIsInstalledInPiuTypes(ProductNumbersAndRevisions productNumbersAndRevisions, boolean bl) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIsInstalledInPiuTypes(ProductNumbersAndRevisions aProductNumbersAndRevisions, boolean anIsInstalled)", "aProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tanIsInstalled: " + bl);
        }
        Vector vector = null;
        try {
            vector = this.getMatchingPiuTypeMos(productNumbersAndRevisions);
            this.setIsInstalledInPiuTypeMos(vector, bl);
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setIsInstalledInPiuTypes(ProductNumbersAndRevisions aProductNumbersAndRevisions, boolean anIsInstalled)", "Exception caught.\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tanIsInstalled: " + bl + "\n\ttheMatchingPiuTypeMOs: " + vector + "Exception: " + exception.toString(), exception);
            throw new PiuTypeMO_HandlerException("setIsInstalledInPiuTypes(ProductNumbersAndRevisions aProductNumbersAndRevisions, boolean anIsInstalled)\n\tException caught.\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tanIsInstalled: " + bl + "\n\ttheMatchingPiuTypeMOs: " + vector + "Exception: " + exception.toString());
        }
    }

    public void updateAttributesInPiuType(ProductNumberAndRevision productNumberAndRevision, String string, String string2) throws PiuTypeMO_HandlerException {
        String string3 = "updateAttributesInPiuType(ProductNumberAndRevision aProductNumberAndRevision, String aPiuRole, String aDefAllowedSeqRestarts)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string3, "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taPiuRole: " + string + "\n\taDefAllowedSeqRestarts: " + string2);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            PiuTypeMoSU_Access piuTypeMoSU_Access = this.getPiuTypeMo(productNumberAndRevision.productNumber, productNumberAndRevision.revision);
            int n = piuTypeMoSU_Access.getRole(coordinator);
            int n2 = this.getPiuRoleAsInt(string);
            if (n2 != n && n2 == 4) {
                control = Transaction.create();
                coordinator = Transaction.getCoordinator(control);
                piuTypeMoSU_Access.setRoleForUpgrade(4, coordinator);
            }
            if (control == null) {
                control = Transaction.create();
                coordinator = Transaction.getCoordinator(control);
            }
            int n3 = this.getDefAllowedSeqRestartsAsInt(string2);
            piuTypeMoSU_Access.setDefAllowedSeqRestartsForUpgrade(n3, coordinator);
            Transaction.commit(control);
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            Transaction.rollback(control);
            throw piuTypeMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string3, "Throwable caught.\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taPiuRole: " + string + "\n\taDefAllowedSeqRestarts: " + string2, throwable);
            Transaction.rollback(control);
            throw new PiuTypeMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string3 + "\n\tThrowable caught." + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taPiuRole: " + string + "\n\taDefAllowedSeqRestarts: " + string2 + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void updateAttributesInPiuType(ProductNumberAndRevision productNumberAndRevision, PiuTypeProxyInterface piuTypeProxyInterface, TransformProxyInterface transformProxyInterface, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateAttributesInPiuType(ProductNumberAndRevision aProductNumberAndRevision, PiuTypeProxyInterface aPiuTypeProxyInterface, TransformProxyInterface aTransformProxyInterface, Coordinator aCoordinator)", "aProductNumberAndRevision: " + productNumberAndRevision + "\n\taPiuTypeProxyInterface: " + piuTypeProxyInterface + "\n\taTransformProxyInterface: " + transformProxyInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            DefaultPiuRoleValue defaultPiuRoleValue = piuTypeProxyInterface.getDefaultPiuRoleValue();
            PiuTypeMoSU_Access piuTypeMoSU_Access = this.getPiuTypeMo(productNumberAndRevision.productNumber, productNumberAndRevision.revision);
            if (piuTypeMoSU_Access.getRole(coordinator) != defaultPiuRoleValue.getValue()) {
                if (defaultPiuRoleValue.getValue() == DefaultPiuRoleValue.GP.getValue() && !this.isSU_VersionSupported("SU_2")) {
                    defaultPiuRoleValue = piuTypeProxyInterface.getTransformedDefaultPiuRole(transformProxyInterface);
                }
                piuTypeMoSU_Access.setRoleForUpgrade(defaultPiuRoleValue.getValue(), coordinator);
            }
            int n = this.getDefAllowedSeqRestartsAsInt(piuTypeProxyInterface.getDefAllowedSeqRestarts());
            piuTypeMoSU_Access.setDefAllowedSeqRestartsForUpgrade(n, coordinator);
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            throw piuTypeMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateAttributesInPiuType(ProductNumberAndRevision aProductNumberAndRevision, PiuTypeProxyInterface aPiuTypeProxyInterface, TransformProxyInterface aTransformProxyInterface, Coordinator aCoordinator)", "Throwable caught.aProductNumberAndRevision: " + productNumberAndRevision + "\n\taPiuTypeProxyInterface: " + piuTypeProxyInterface + "\n\taTransformProxyInterface: " + transformProxyInterface + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new PiuTypeMO_HandlerException(throwable.toString());
        }
    }

    public void verifyThatProductNumberAndRevisionIsAllowed(String string, String string2) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
            if (moIterator != null) {
                String string3 = StringHandler.removeWhiteSpaces(string);
                String string4 = StringHandler.removeWhiteSpaces(string2);
                PiuTypeMoSU_Access piuTypeMoSU_Access = null;
                String string5 = null;
                String string6 = null;
                while (moIterator.hasMoreElements()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                    if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                        string5 = piuTypeMoSU_Access.getProductNumberOpt(null);
                        string6 = piuTypeMoSU_Access.getProductRevisionOpt(null);
                    } else {
                        string5 = StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null));
                        string6 = StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null));
                    }
                    if (!string5.equalsIgnoreCase(string3)) continue;
                    if (string6.equalsIgnoreCase(string4)) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", "PiuType MO containing the requested product number and revision already exists,\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                        }
                        throw new ProductNumberAndRevisionNotAllowedException("PiuType", "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)\n\tPiuType MO containing the requested product number and revision already exists,\n\trequested product number: " + string + "\n\trequested product revision: " + string2 + "\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                    }
                    if (string2.equals("*")) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", "PiuType MO containing the requested product number and a specific revision already exists,\n\tcreation of PiuType MO containing wildcard revision is not allowed in this case.\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                        }
                        throw new ProductNumberAndRevisionNotAllowedException("PiuType", "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)\n\tPiuType MO containing the requested product number and a specific revision already exists.\n\tcreation of PiuType MO containing wildcard revision is not allowed in this case.\n\trequested product number: " + string + "\n\trequested product revision: " + string2 + "\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                    }
                    if (!string6.equals("*")) continue;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", "PiuType MO containing the requested product number and wildcard revision already exists,\n\tcreation of PiuType MO containing specific revision is not allowed in this case.\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                    }
                    throw new ProductNumberAndRevisionNotAllowedException("PiuType", "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)\n\tPiuType MO containing the requested product number and wildcard revision already exists.\n\tcreation of PiuType MO containing specific revision is not allowed in this case.\n\trequested product number: " + string + "\n\trequested product revision: " + string2 + "\n\texisting product number: " + string5 + "\n\texisting product revision: " + string6);
                }
            }
        }
        catch (ProductNumberAndRevisionNotAllowedException productNumberAndRevisionNotAllowedException) {
            throw productNumberAndRevisionNotAllowedException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)", "Exception caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "Exception: " + exception.toString(), exception);
            throw new PiuTypeMO_HandlerException("verifyThatProductNumberAndRevisionIsAllowed(String aProductNumber, String aProductRevision)Exception caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "Exception: " + exception.toString());
        }
    }

    private String calculateLDN_Value(String string, String string2, String string3, Vector vector) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateLDN_Value ( String aProductNumber, String aProductRevision, String aProductName, vector aPiuTypeMosData )", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taProductName: " + string3 + "\n\taPiuTypeMosData: " + vector);
        }
        try {
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                PiuTypeMoData piuTypeMoData = null;
                String string4 = null;
                while (enumeration.hasMoreElements()) {
                    piuTypeMoData = (PiuTypeMoData)enumeration.nextElement();
                    string4 = piuTypeMoData.productNumber + piuTypeMoData.productRevision;
                    if (!StringHandler.removeWhiteSpaces(string + string2).equalsIgnoreCase(StringHandler.removeWhiteSpaces(string4))) continue;
                    return piuTypeMoData.ldnValue;
                }
                String string5 = StringHandler.removeWhiteSpaces(string + "_" + string2);
                return string5;
            }
            String string6 = StringHandler.removeWhiteSpaces(string + "_" + string2);
            return string6;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "calculateLDN_Value ( String aProductNumber, String aProductRevision, String aProductName, vector aPiuTypeMosData )", "Exception caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taProductName: " + string3 + "\n\taPiuTypeMosData: " + vector + "Exception: " + exception.toString(), exception);
            throw new PiuTypeMO_HandlerException("calculateLDN_Value ( String aProductNumber, String aProductRevision, String aProductName, vector aPiuTypeMosData )Exception caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taProductName: " + string3 + "\n\taPiuTypeMosData: " + vector + "Exception: " + exception.toString());
        }
    }

    private void deletePiuTypeMos(Vector vector) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deletePiuTypeMos(Vector aPiuTypeMos)", "\n\taPiuTypeMos: " + vector);
        }
        Control control = null;
        Coordinator coordinator = null;
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        try {
            if (!vector.isEmpty()) {
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                coordinator = control.getCoordinator();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "deletePiuTypeMos(Vector aPiuTypeMos)", "PiuType MO to be deleted: " + piuTypeMoSU_Access);
                    }
                    piuTypeMoSU_Access.delete(coordinator);
                }
                control.getTerminator().commit();
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deletePiuTypeMos(Vector aPiuTypeMos)", "Exception caught at deletion of PiuType MO's, \n\taPiuTypeMos: " + vector + "\n\tacurrent PiuTypeMO: " + piuTypeMoSU_Access, exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("deletePiuTypeMos(Vector aPiuTypeMos)\n\taPiuTypeMos: " + vector + "\n\tacurrent PiuTypeMO: " + piuTypeMoSU_Access + "\n\tException caught at deletion of PiuType MO's: " + exception.toString());
        }
    }

    private int getDefAllowedSeqRestartsAsInt(String string) {
        int n = 3;
        if (string == null) {
            Trace.info(this.getClass(), "!!!WARNING!!! getDefAllowedSeqRestartsAsInt ()", "defaultAllowedSeqRestarts is null. Attribute defaultAllowedSeqRestarts may not have been defined in UCF. Default value will be used.");
        } else if (string.equalsIgnoreCase("enterAtWarm")) {
            n = 3;
        } else if (string.equalsIgnoreCase("enterAtCold")) {
            n = 2;
        } else if (string.equalsIgnoreCase("enterAtColdWithTest")) {
            n = 1;
        } else if (string.equalsIgnoreCase("enterAtFaultMark")) {
            n = 0;
        } else if (string.equalsIgnoreCase("noLimits")) {
            n = -1;
        } else {
            Trace.info(this.getClass(), "!!!WARNING!!! getDefAllowedSeqRestartsAsInt ()", "Unexpected value of defAllowedSeqRestarts:  " + string + " Default value will be used.");
        }
        return n;
    }

    private Vector getMatchingPiuTypeMos(boolean bl) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMatchingPiuTypeMos(boolean anIsInstalled)", "\n\tanIsInstalled: " + bl);
        }
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        Vector<PiuTypeMoSU_Access> vector = new Vector<PiuTypeMoSU_Access>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                    if (piuTypeMoSU_Access.getIsInstalled(null) != bl) continue;
                    vector.addElement(piuTypeMoSU_Access);
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getMatchingPiuTypeMos(boolean anIsInstalled)", "RETURNS - theMatchingPiuTypeMos: " + vector);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getMatchingPiuTypeMos(boolean anIsInstalled)", "Throwable caught at retrieval of all matching PiuType MO's, anIsInstalled: " + bl, throwable);
            throw new PiuTypeMO_HandlerException("getMatchingPiuTypeMos(boolean anIsInstalled)\n\tanIsInstalled: " + bl + "\n\tcurrent PiuTypeMO: " + piuTypeMoSU_Access + "\n\tThrowable caught at retrieval of all matching PiuType MO's: " + throwable.toString());
        }
    }

    private Vector getMatchingPiuTypeMos(ProductNumbersAndRevisions productNumbersAndRevisions) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "aProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        Vector<PiuTypeMoSU_Access> vector = new Vector<PiuTypeMoSU_Access>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
            if (moIterator != null) {
                if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                    while (moIterator.hasMoreElements()) {
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                        if (!productNumbersAndRevisions.contains(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null))) continue;
                        vector.addElement(piuTypeMoSU_Access);
                    }
                } else {
                    Struct struct = null;
                    while (moIterator.hasMoreElements()) {
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                        struct = piuTypeMoSU_Access.getProductData(null);
                        if (!productNumbersAndRevisions.contains(StringHandler.optimize((String)struct.getValue("productNumber")), StringHandler.optimize((String)struct.getValue("productRevision")))) continue;
                        vector.addElement(piuTypeMoSU_Access);
                    }
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "RETURNS - theMatchingPiuTypeMos: " + vector);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "Throwable caught when trying to get matching PiuType MOs,\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tcurrent PiuTypeMO: " + piuTypeMoSU_Access, throwable);
            throw new PiuTypeMO_HandlerException("getMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)\n\tThrowable caught when trying to get matching PiuType MOs,\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tcurrent PiuTypeMO: " + piuTypeMoSU_Access + "\n\tThrowable: " + throwable.toString());
        }
    }

    private Vector getNotMatchingPiuTypeMos(ProductNumbersAndRevisions productNumbersAndRevisions) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNotMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "aProductNumbersAndRevisions: " + productNumbersAndRevisions);
        }
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        Vector<PiuTypeMoSU_Access> vector = new Vector<PiuTypeMoSU_Access>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
            if (moIterator != null) {
                if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                    while (moIterator.hasMoreElements()) {
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                        if (productNumbersAndRevisions.contains(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null))) continue;
                        vector.addElement(piuTypeMoSU_Access);
                    }
                } else {
                    Struct struct = null;
                    while (moIterator.hasMoreElements()) {
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)moIterator.nextMo();
                        struct = piuTypeMoSU_Access.getProductData(null);
                        if (productNumbersAndRevisions.contains(StringHandler.optimize((String)struct.getValue("productNumber")), StringHandler.optimize((String)struct.getValue("productRevision")))) continue;
                        vector.addElement(piuTypeMoSU_Access);
                    }
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getNotMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "RETURNS - theNotMatchingPiuTypeMos: " + vector);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNotMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)", "Throwable caught when trying to get not matching PiuType MOs,\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tcurrent PiuTypeMO: " + piuTypeMoSU_Access, throwable);
            throw new PiuTypeMO_HandlerException("getNotMatchingPiuTypeMos(ProductNumbersAndRevisions aProductNumbersAndRevisions)\n\tThrowable caught when trying to extract not replaced PiuTypes,\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\tcurrent PiuTypeMO: " + piuTypeMoSU_Access + "\n\tThrowable: " + throwable.toString());
        }
    }

    private int getPiuRoleAsInt(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuRoleAsInt(String aPiuRole)", "aPiuRole: " + string);
        }
        if (string != null) {
            if (string.equalsIgnoreCase("mp")) {
                return 1;
            }
            if (string.equalsIgnoreCase("bp")) {
                return 2;
            }
            if (string.equalsIgnoreCase("cmxb")) {
                return 4;
            }
        }
        return 3;
    }

    public ProgramConfigurationInformations getProgramConfigurations(PiuTypeMoSU_Access piuTypeMoSU_Access, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProgramConfigurations (PiuTypeMoSU_Access aPiuTypeMoSU_Access, Coordinator aCoordinator)", "aPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            ProgramConfigurationInformations programConfigurationInformations = null;
            programConfigurationInformations = piuTypeMoSU_Access.getProgramConfigurationInformation(coordinator);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getProgramConfigurations (PiuTypeMoSU_Access aPiuTypeMoSU_Access, Coordinator aCoordinator)", "RETURNS - theProgramConfigurations: " + programConfigurationInformations);
            }
            return programConfigurationInformations;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getProgramConfigurations (PiuTypeMoSU_Access aPiuTypeMoSU_Access)", "Throwable caught when trying to get not matching PiuType MOs,\n\taPiuTypeMoSU_Access: " + piuTypeMoSU_Access, throwable);
            throw new PiuTypeMO_HandlerException("getProgramConfigurations (PiuTypeMoSU_Access aPiuTypeMoSU_Access)\n\tThrowable caught when trying to extract not replaced PiuTypes,\n\taPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\tThrowable: " + throwable);
        }
    }

    private String getShortProductRevision(String string) throws InvalidProductRevisionFormatException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getShortProductRevision(String aFullRevision)", "aFullRevision: " + string);
        }
        if (string == null || string.equals("")) {
            Trace.warning(this.getClass(), "getShortProductRevision()", "Illegal product revision, the revision is empty");
            return null;
        }
        if (string.endsWith("/")) {
            Trace.warning(this.getClass(), "getShortProductRevision()", "Illegal product revision, the revision ends with '/', revision: " + string);
            return null;
        }
        return ProductNumberAndRevision.getShortProductRevision(string);
    }

    public boolean isSU_VersionSupported(String string) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(String aSU_AccessVersion)", "aSU_AccessVersion: " + string);
        }
        PiuTypeMoFactorySU_Access piuTypeMoFactorySU_Access = (PiuTypeMoFactorySU_Access)MoFactoryMgr.instance().lookup("PiuType");
        boolean bl = false;
        if (SU_AccessVersionHandler.getInstance().isSupported(string, (Object)piuTypeMoFactorySU_Access)) {
            bl = true;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(String aSU_AccessVersion)", "RETURNS - theIsSupported: " + bl);
        }
        return bl;
    }

    public boolean isPiuTypeMOsDependentOnSU_DOM() throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPiuTypeMOsDependentOnSU_DOM()");
        }
        try {
            boolean bl = false;
            if (this.isSU_VersionSupported("SU_3")) {
                Iterator iterator = this.getAllPiuTypeMOs().iterator();
                PiuTypeMoSU_Access piuTypeMoSU_Access = null;
                while (iterator.hasNext()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                    if (!piuTypeMoSU_Access.getSU_DOM_Required(null)) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isPiuTypeMOsDependentOnSU_DOM()", "Throwable caught", throwable);
            throw new PiuTypeMO_HandlerException(throwable.toString());
        }
    }

    private void setIsInstalledInPiuTypeMos(Vector vector, boolean bl) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIsInstalledInPiuTypeMos(Vector aPiuTypeMos, boolean anIsInstalled)", "aPiuTypeMos: " + vector + "\n\tanIsInstalled: " + bl);
        }
        Control control = null;
        Coordinator coordinator = null;
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        try {
            if (!vector.isEmpty()) {
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                coordinator = control.getCoordinator();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                    piuTypeMoSU_Access.setIsInstalled(bl, coordinator);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "setIsInstalledInPiuTypeMos(Vector aPiuTypeMos, boolean anIsInstalled)", "Attribute isInstalled has been set in the current PiuType MO,\n\tcurrent PiuTypeMO: " + piuTypeMoSU_Access + "\n\tisInstalled value: " + bl);
                }
                control.getTerminator().commit();
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setIsInstalledInPiuTypeMos(Vector aPiuTypeMos, boolean anIsInstalled)", "Exception caught when trying to set attribute isInstalled in PiuType MO's, \n\taPiuTypeMos: " + vector + "\n\tanIsInstalled: " + bl + "\n\tcurrent PiuTypeMO: " + piuTypeMoSU_Access, exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PiuTypeMO_HandlerException("setIsInstalledInPiuTypeMos(Vector aPiuTypeMos, boolean anIsInstalled)\n\taPiuTypeMos: " + vector + "\n\tanIsInstalled: " + bl + "\n\tcurrent PiuTypeMO: " + piuTypeMoSU_Access + "\n\tException caught when trying to set attribute isInstalled in PiuType MO's: " + exception.toString());
        }
    }

    private void setPiuRole(PiuTypeMoSU_Access piuTypeMoSU_Access, String string, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        String string2 = "setPiuRole(PiuTypeMoSU_Access aPiuTypeMO, String aPiuRole, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string2, "aPiuTypeMO: " + piuTypeMoSU_Access + "\n\taCoordinator: " + coordinator);
        }
        try {
            if (string != null && string.equalsIgnoreCase("cmxb")) {
                piuTypeMoSU_Access.setRoleForUpgrade(4, coordinator);
            }
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            throw piuTypeMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string2, "Throwable caught.\n\taPiuTypeMO: " + piuTypeMoSU_Access + "\n\taCoordinator: " + coordinator, throwable);
            throw new PiuTypeMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string2 + "\n\tThrowable caught." + "\n\taPiuTypeMO: " + piuTypeMoSU_Access + "\n\taCoordinator: " + coordinator + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getAllPiuTypeMOs() throws PiuTypeMO_HandlerException {
        String string = "getAllPiuTypeMOs()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("PiuType");
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    linkedList.add(moIterator.nextMo());
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - thePiuTypeMos: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new PiuTypeMO_HandlerException(throwable.toString());
        }
    }

    public LoadModuleInstalledState getLoadModuleInstalledState(PiuTypeMoSU_Access piuTypeMoSU_Access, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        String string = "getLoadModuleInstalledState(PiuTypeMoSU_Access aPiuTypeMoSU_Access, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            int n = piuTypeMoSU_Access.getLmFilesInstallState(coordinator);
            return LoadModuleInstalledState.getInstance(n);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new PiuTypeMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void setLoadModuleInstalledState(PiuTypeMoSU_Access piuTypeMoSU_Access, LoadModuleInstalledState loadModuleInstalledState, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        String string = "setLoadModuleInstalledState(PiuTypeMoSU_Access aPiuTypeMoSU_Access, LoadModuleInstalledState aLoadModuleInstalledState, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            this.setLmFilesInstallState(this.isSU_VersionSupported("SU_4"), piuTypeMoSU_Access, loadModuleInstalledState, coordinator);
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            throw piuTypeMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new PiuTypeMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public void setLoadModuleInstalledState(Collection collection, LoadModuleInstalledState loadModuleInstalledState, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        String string = "setLoadModuleInstalledState(Collection aPiuTypeMoSU_Accesses, LoadModuleInstalledState aLoadModuleInstalledState, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aPiuTypeMoSU_Accesses: " + collection + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            boolean bl = this.isSU_VersionSupported("SU_4");
            Iterator iterator = collection.iterator();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            while (iterator.hasNext()) {
                piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                if (piuTypeMoSU_Access == null) continue;
                this.setLmFilesInstallState(bl, piuTypeMoSU_Access, loadModuleInstalledState, coordinator);
            }
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            throw piuTypeMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taPiuTypeMoSU_Accesses: " + collection + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new PiuTypeMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taPiuTypeMoSU_Access: " + collection + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private void setLmFilesInstallState(boolean bl, PiuTypeMoSU_Access piuTypeMoSU_Access, LoadModuleInstalledState loadModuleInstalledState, Coordinator coordinator) throws PiuTypeMO_HandlerException {
        String string = "setLmFilesInstallState(boolean anIsSU_4_Supported, PiuTypeMoSU_Access aPiuTypeMoSU_Access, LoadModuleInstalledState aLoadModuleInstalledState, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anIsSU_4_Supported: " + bl + "\n\taPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (bl) {
                piuTypeMoSU_Access.setLmFilesInstallStateForUpgrade(loadModuleInstalledState.getValue(), coordinator);
            } else {
                ((PiuTypeMoSU_Access1)piuTypeMoSU_Access).setLmFilesInstallState(loadModuleInstalledState.getValue(), coordinator);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\tanIsSU_4_Supported: " + bl + "\n\taPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new PiuTypeMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tanIsSU_4_Supported: " + bl + "\n\taPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\taLoadModuleInstalledState: " + loadModuleInstalledState + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public ProductNumberAndRevisionInterface getProductNumberAndRevision(PiuTypeMoSU_Access piuTypeMoSU_Access) throws PiuTypeMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProductNumberAndRevision(PiuTypeMoSU_Access aPiuTypeMo)", "aPiuTypeMo: " + piuTypeMoSU_Access);
        }
        try {
            String string = null;
            String string2 = null;
            if (this.isSU_VersionSupported("SU_3")) {
                string = piuTypeMoSU_Access.getProductNumberOpt(null);
                string2 = piuTypeMoSU_Access.getProductRevisionOpt(null);
            } else {
                string = SuLib.optimize(piuTypeMoSU_Access.getProductNumber(null));
                string2 = SuLib.optimize(piuTypeMoSU_Access.getProductRevision(null));
            }
            return new ProductNumberAndRevision(string, string2);
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            throw piuTypeMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getProductNumberAndRevision(PiuTypeMoSU_Access aPiuTypeMo)", "aPiuTypeMo: " + piuTypeMoSU_Access, throwable);
            throw new PiuTypeMO_HandlerException(throwable.toString());
        }
    }

    public Collection getProductNumbersAndRevisonsForPiuTypes(Collection collection) throws PiuTypeMO_HandlerException {
        String string = "getProductNumbersAndRevisonsForPiuTypes(Collection aPiuTypeMoSU_Accesses)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aPiuTypeMoSU_Accesses: " + collection);
        }
        try {
            LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
            Iterator iterator = collection.iterator();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                while (iterator.hasNext()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                    ProductNumberAndRevision productNumberAndRevision = new ProductNumberAndRevision(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null));
                    linkedList.add(productNumberAndRevision);
                }
            } else {
                while (iterator.hasNext()) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                    ProductNumberAndRevision productNumberAndRevision = new ProductNumberAndRevision(StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null)));
                    linkedList.add(productNumberAndRevision);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - thePiuTypeMOsProductNoAndRev: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aPiuTypeMoSU_Accesses: " + collection, throwable);
            throw new PiuTypeMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tPiuTypeMoSU_Accesses: " + collection + "\n\tOriginal Throwable: " + throwable);
        }
    }
}

