/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.slot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;

public class SlotMO_Handler
implements SlotMO_HandlerInterface {
    public SlotMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SlotMO_Handler (MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public SlotMoSU_Access getSlotMo(PlugInUnitMoSU_Access plugInUnitMoSU_Access) throws SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSlotMos(PlugInUnitMoSU_Access aPIU_Mo)", "aPIU_Mo: " + plugInUnitMoSU_Access);
        }
        return (SlotMoSU_Access)plugInUnitMoSU_Access.getParent();
    }

    public SlotMoSU_Access[] getSlotMos(PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray) throws SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSlotMos(PlugInUnitMoSU_Access[] aPIU_Mos)", "aPIU_Mos: " + plugInUnitMoSU_AccessArray);
        }
        SlotMoSU_Access[] slotMoSU_AccessArray = new SlotMoSU_Access[plugInUnitMoSU_AccessArray.length];
        for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
            slotMoSU_AccessArray[i] = (SlotMoSU_Access)plugInUnitMoSU_AccessArray[i].getParent();
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 21, "getSlotMos(PlugInUnitMoSU_Access[] aPIU_Mos)", "RETURNS - theSlotMos: " + SuLib.toString((ManagedObject[])plugInUnitMoSU_AccessArray));
        }
        return slotMoSU_AccessArray;
    }

    public Vector getSlotsWithUpgradeGroupTypeNames(Vector vector) throws SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSlotsWithUpgradeGroupTypeNames(Vector anUpgradeGroupTypeNames)", "anUpgradeGroupTypeNames: " + vector);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("Slot");
            Vector<SlotMoSU_Access> vector2 = new Vector<SlotMoSU_Access>(1);
            SlotMoSU_Access slotMoSU_Access = null;
            while (moIterator.hasMoreElements()) {
                slotMoSU_Access = (SlotMoSU_Access)moIterator.nextMo();
                if (!vector.contains(slotMoSU_Access.getUpgradeGroupTypeName(null))) continue;
                vector2.addElement(slotMoSU_Access);
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "getSlotsWithUpgradeGroupTypeNames(Vector anUpgradeGroupTypeNames)", "The slot '" + slotMoSU_Access + "' matches one of the given upgrade group type names.");
            }
            return vector2;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getSlotsWithUpgradeGroupTypeNames(Vector anUpgradeGroupTypeNames)", "Mo access exception caught while collection slots with specific upgrade group type names.anUpgradeGroupTypeNames: " + vector, moAccessException);
            throw new SlotMO_HandlerException("Mo access exception caught while collection slots with specific upgrade group type names.\n\tanUpgradeGroupTypeNames: " + vector + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getSlotsWithUpgradeGroupTypeNames(Vector anUpgradeGroupTypeNames)", "Exception caught while collection slots with specific upgrade group type names.anUpgradeGroupTypeNames: " + vector, exception);
            throw new SlotMO_HandlerException("Exception caught while collection slots with specific upgrade group type names.\n\tanUpgradeGroupTypeNames: " + vector + exception.toString());
        }
    }

    public Collection getAllEmptySlotsWithMultipleSwAllocations() throws MoAccessException {
        HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
        MoIterator moIterator = MoRepository.instance().lookupType("Slot");
        boolean bl = false;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!bl) {
                bl = true;
            }
            if (!this.isEmpty(managedObject) || !SlotMO_Handler.configuredWithMultipleSWA(managedObject)) continue;
            hashSet.add(managedObject);
            if (!Trace.valid(this.getClass(), 20)) continue;
            Trace.debug(this.getClass(), 20, "getAllEmptySlotsWithMultipleSwAllocations()", "Adding an empty slot configured with multiple SWA's, slot: " + managedObject.getLocalDistinguishedName());
        }
        return hashSet;
    }

    public Collection getAllEmptySlots() {
        HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
        MoIterator moIterator = MoRepository.instance().lookupType("Slot");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!this.isEmpty(managedObject)) continue;
            hashSet.add(managedObject);
            if (!Trace.valid(this.getClass(), 20)) continue;
            Trace.debug(this.getClass(), 20, "getAllEmptySlots()", "Adding an empty slot: " + managedObject.getLocalDistinguishedName());
        }
        return hashSet;
    }

    private static boolean configuredWithMultipleSWA(ManagedObject managedObject) throws MoAccessException {
        return ((SlotMoSU_Access)managedObject).getSwAllocations(null).length > 1;
    }

    private boolean isEmpty(ManagedObject managedObject) {
        return managedObject.getChildren().size() == 0;
    }

    public HashMap getSWA_MOsConnectedToFreeSlotsMap() throws SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSWA_MOsConnectedToFreeSlotsMap( )");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("Slot");
            SlotMoSU_Access slotMoSU_Access = null;
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            HashSet<SlotMoSU_Access> hashSet = null;
            HashMap<SwAllocationMoSU_Access, HashSet<SlotMoSU_Access>> hashMap = new HashMap<SwAllocationMoSU_Access, HashSet<SlotMoSU_Access>>();
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    slotMoSU_Access = (SlotMoSU_Access)moIterator.nextMo();
                    ManagedObject[] managedObjectArray = this.getSwAllocationsConnected(slotMoSU_Access);
                    for (int i = 0; i < managedObjectArray.length; ++i) {
                        swAllocationMoSU_Access = (SwAllocationMoSU_Access)managedObjectArray[i];
                        if (swAllocationMoSU_Access == null || !this.isEmpty((ManagedObject)slotMoSU_Access)) continue;
                        hashSet = (HashSet<SlotMoSU_Access>)hashMap.get(swAllocationMoSU_Access);
                        if (hashSet == null) {
                            hashSet = new HashSet<SlotMoSU_Access>();
                        }
                        hashSet.add(slotMoSU_Access);
                        hashMap.put(swAllocationMoSU_Access, hashSet);
                    }
                }
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSWA_MOsConnectedToFreeSlotsMap( )", "Throwable caught.", throwable);
            throw new SlotMO_HandlerException("getSWA_MOsConnectedToFreeSlotsMap( )\n\tThrowable caught.\n\tThrowable data: " + throwable.toString());
        }
    }

    public SwAllocationMoSU_Access[] getConnectedSwAllocations(SlotMoSU_Access slotMoSU_Access) throws SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedSwAllocations(SlotMoSU_Access aSlot)", "\n\taSlot: " + slotMoSU_Access);
        }
        try {
            ManagedObject[] managedObjectArray = slotMoSU_Access.getSwAllocations(null);
            SwAllocationMoSU_Access[] swAllocationMoSU_AccessArray = new SwAllocationMoSU_Access[managedObjectArray.length];
            for (int i = 0; i < managedObjectArray.length; ++i) {
                swAllocationMoSU_AccessArray[i] = (SwAllocationMoSU_Access)managedObjectArray[i];
            }
            return swAllocationMoSU_AccessArray;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getConnectedSwAllocations(SlotMoSU_Access aSlot)", "Throwable caught.", throwable);
            throw new SlotMO_HandlerException(throwable.toString());
        }
    }

    public String getSlotProductNumber(SlotMoSU_Access slotMoSU_Access) throws SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSlotProductNumber(SlotMoSU_Access aSlotMo)", "aSlotMo: " + slotMoSU_Access);
        }
        String string = null;
        try {
            string = this.isSU_VersionSupported("SU_2", slotMoSU_Access) ? slotMoSU_Access.getProductNumberOpt(null) : slotMoSU_Access.getProductNumber(null);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSlotProductNumber(SlotMoSU_Access aSlotMo)", "Throwable caught.", throwable);
            throw new SlotMO_HandlerException(throwable.toString());
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getSlotProductNumber(SlotMoSU_Access aSlotMo)", "RETURNING - theSlotProductNumber" + string);
        }
        return string;
    }

    public String getSlotRState(SlotMoSU_Access slotMoSU_Access) throws SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSlotRState(SlotMoSU_Access aSlotMo)", "aSlotMo: " + slotMoSU_Access);
        }
        String string = null;
        try {
            string = this.isSU_VersionSupported("SU_2", slotMoSU_Access) ? slotMoSU_Access.getRStateOpt(null) : slotMoSU_Access.getRState(null);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSlotRState(SlotMoSU_Access aSlotMo)", "Throwable caught.", throwable);
            throw new SlotMO_HandlerException(throwable.toString());
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getSlotRState(SlotMoSU_Access aSlotMo)", "RETURNING - theSlotProductNumber" + string);
        }
        return string;
    }

    public boolean isSU_VersionSupported(String string, SlotMoSU_Access slotMoSU_Access) throws SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(String aSU_AccessVersion, SlotMoSU_Access aSlotMoSU_Access)", "aSU_AccessVersion: " + string + "\n\taSlotMoSU_Access: " + slotMoSU_Access);
        }
        return SU_AccessVersionHandler.getInstance().isSupported(string, (Object)slotMoSU_Access);
    }

    private ManagedObject[] getSwAllocationsConnected(SlotMoSU_Access slotMoSU_Access) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationsConnected(SlotMoSU_Access aSlot)", "\n\taSlot: " + slotMoSU_Access);
        }
        return slotMoSU_Access.getSwAllocations(null);
    }
}

