/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.swallocation;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringUtils;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.proxy.explicitreplacement.NewRepInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.OldRepInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RepertoireReplacementInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RepertoireReplacementInterface;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.parser.UpgradePackageSAXdh;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeReplacement;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class SwAllocationMO_Handler
implements SwAllocationMO_HandlerInterface {
    public SwAllocationMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SwAllocationMO_Handler (MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public void addRepertoires(SwAllocationMoSU_Access swAllocationMoSU_Access, Collection collection, Coordinator coordinator) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addRepertoires ( SwAllocationMoSU_Access aSwAllocationMo, Collection aRepertoireMOs, Coordinator aCoordinator )", "aSwAllocationMo: " + swAllocationMoSU_Access + "\n\taRepertoireMOs: " + collection + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Iterator iterator = collection.iterator();
            ManagedObject managedObject = null;
            while (iterator.hasNext()) {
                managedObject = (ManagedObject)iterator.next();
                swAllocationMoSU_Access.actionAddRepertoire(managedObject, coordinator);
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "addRepertoires ( SwAllocationMoSU_Access aSwAllocationMo, Collection aRepertoireMOs, Coordinator aCoordinator )", "Exception caught: \n\tException data: " + exception.toString(), exception);
            throw new SwAllocationMO_HandlerException("addRepertoires ( SwAllocationMoSU_Access aSwAllocationMo, Collection aRepertoireMOs, Coordinator aCoordinator )\n\tException caught: \n\tException data: " + exception.toString());
        }
    }

    public void clearAllRepertoiresReferencedBySwAllocations() throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "clearAllRepertoiresReferencedBySwAllocations ()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "clearAllRepertoiresReferencedBySwAllocations()", "No SwAllocationMO's found.");
                }
                return;
            }
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            while (moIterator.hasMoreElements()) {
                swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextMo();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "clearAllRepertoiresReferencedBySwAllocations()", "The SwAllocation MOs '" + swAllocationMoSU_Access.getRole(null) + "' reference to its repertoires is set to 'null'.");
                }
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                coordinator = control.getCoordinator();
                swAllocationMoSU_Access.actionDeleteAllRepertoires(coordinator);
                control.getTerminator().commit();
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "clearAllRepertoiresReferencedBySwAllocations()", "MoAccessException caught: \n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            if (control != null) {
                try {
                    control.getTerminator().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new SwAllocationMO_HandlerException("clearAllRepertoiresReferencedBySwAllocations()\n\tMoAccessException caught: \n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "clearAllRepertoiresReferencedBySwAllocations()", "Exception caught: \n\tException data: " + exception.toString(), exception);
            if (control != null) {
                try {
                    control.getTerminator().rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new SwAllocationMO_HandlerException("clearAllRepertoiresReferencedBySwAllocations()\n\tException caught: \n\tException data: " + exception.toString());
        }
    }

    public void connectSwAllocationMOsToRepertoireMOs(Hashtable hashtable, UpgradeReplacement[] upgradeReplacementArray, Vector vector) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "connectSwAllocationMOsToRepertoireMOs ( Hashtable aRepertoiresReferencedBySwAllocationMOs, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas)", "aRepertoiresReferencedBySwAllocationMOs: " + hashtable + "\n\taRepertoireExplicitReplacementInformation data: " + upgradeReplacementArray + "\n\tanAllCurrentRepertoireMoDatas: " + vector);
        }
        Object var4_4 = null;
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "connectSwAllocationMOsToRepertoireMOs ( )", "No MO of type SwAllocation found.");
                }
                return;
            }
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            Vector vector2 = null;
            while (moIterator.hasMoreElements()) {
                swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextElement();
                vector2 = (Vector)hashtable.get(swAllocationMoSU_Access);
                if (vector2 != null) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "connectSwAllocationMOsToRepertoireMOs ( Hashtable aRepertoiresReferencedBySwAllocationMOs )", "The SwAllocation MO '" + swAllocationMoSU_Access.getRole(null) + "' with DN" + "\n\t'" + swAllocationMoSU_Access + "' is to be" + "\n\tconnected to the certain repertoires." + "\n\tIts old repertoire data: " + vector2);
                    }
                    Vector vector3 = this.getValidRepertoireNames(vector2, upgradeReplacementArray, vector);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "connectSwAllocationMOsToRepertoireMOs ( Hashtable aRepertoiresReferencedBySwAllocationMOs )", "The SwAllocation MO '" + swAllocationMoSU_Access.getRole(null) + "' is to be" + "\n\tconnected to the repertoires with the names " + vector3);
                    }
                    this.connectSwAllocationMO(swAllocationMoSU_Access, vector3);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "connectSwAllocationMOsToRepertoireMOs ( Hashtable aRepertoiresReferencedBySwAllocationMOs )", "The SwAllocation MO '" + swAllocationMoSU_Access.getRole(null) + "' with DN" + "\n\t'" + swAllocationMoSU_Access + "' is not connected to any repertoire due to" + "\n\tit was not connected before the upgrade was started.");
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "connectSwAllocationMOsToRepertoireMOs ( Hashtable aRepertoiresReferencedBySwAllocationMOs, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas)", "aRepertoiresReferencedBySwAllocationMOs: " + hashtable + "\n\taRepertoireExplicitReplacementInformation data: " + upgradeReplacementArray + "\n\tanAllCurrentRepertoireMoDatas: " + vector + "MoAccessException caught.", moAccessException);
            try {
                if (var4_4 != null) {
                    var4_4.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SwAllocationMO_HandlerException("connectSwAllocationMOsToRepertoireMOs ( Hashtable aRepertoiresReferencedBySwAllocationMOs, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas)\n\taRepertoiresReferencedBySwAllocationMOs: " + hashtable + "\n\taRepertoireExplicitReplacementInformation: " + upgradeReplacementArray + "\n\tanAllCurrentRepertoireMoDatas: " + vector + "\n\tMoAccessException caught." + "\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "connectSwAllocationMOsToRepertoireMOs ( Hashtable aRepertoiresReferencedBySwAllocationMOs, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas)", "aRepertoiresReferencedBySwAllocationMOs: " + hashtable + "\n\taRepertoireExplicitReplacementInformation: " + upgradeReplacementArray + "\n\tanAllCurrentRepertoireMoDatas: " + vector + "\n\tException caught.", exception);
            try {
                if (var4_4 != null) {
                    var4_4.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new SwAllocationMO_HandlerException("connectSwAllocationMOsToRepertoireMOs ( Hashtable aRepertoiresReferencedBySwAllocationMOs, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas)\n\taRepertoiresReferencedBySwAllocationMOs: " + hashtable + "\n\taRepertoireExplicitReplacementInformation: " + upgradeReplacementArray + "\n\tanAllCurrentRepertoireMoDatas: " + vector + "\n\tException caught." + "\n\tException data: " + exception.toString());
        }
    }

    public SwAllocationMoSU_Access createSwAllocation(String string, String string2, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSwAllocation(String anIdentity, String aRole, Coordinator aCoordinator)", "anIdentity:" + string + "\n\taRole: " + string2 + "\n\taCoordinator: " + coordinator);
        }
        AttrListImpl attrListImpl = new AttrListImpl(2);
        attrListImpl.addElement("role", (Object)string2);
        SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
        MoFactory moFactory = MoFactoryMgr.instance().lookup("SwAllocation");
        return (SwAllocationMoSU_Access)moFactory.createMo(singletonMoFactory.getMo(), (AttrList)attrListImpl, string, singletonMoFactory.getMo(), coordinator);
    }

    public Collection getRepertoiresMosConnectedToSwAllocation(SwAllocationMoSU_Access swAllocationMoSU_Access) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoiresMosConnectedToSwAllocation(SwAllocationMoSU_Access aSwAllocationMo)");
        }
        try {
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            ManagedObject[] managedObjectArray = swAllocationMoSU_Access.getRepertoireList(null);
            if (managedObjectArray != null) {
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    linkedList.add(managedObjectArray[i]);
                }
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoiresMosConnectedToSwAllocation( SwAllocationMoSU_Access aSwAllocationMo)", "Throwable caught: \n\tThrowable data: " + throwable, throwable);
            throw new SwAllocationMO_HandlerException(throwable.toString());
        }
    }

    public Collection getRepertoiresReferencedBySwAllocation(SwAllocationMoSU_Access swAllocationMoSU_Access) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoiresReferencedBySwAllocation( SwAllocationMoSU_Access aSwAllocationMo)");
        }
        try {
            LinkedList<RepertoireMoData> linkedList = new LinkedList<RepertoireMoData>();
            ManagedObject[] managedObjectArray = null;
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            managedObjectArray = swAllocationMoSU_Access.getRepertoireList(null);
            if (managedObjectArray != null) {
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    repertoireMoSU_Access = (RepertoireMoSU_Access)managedObjectArray[i];
                    linkedList.add(new RepertoireMoData(repertoireMoSU_Access, repertoireMoSU_Access.getName(null), repertoireMoSU_Access.getNamingAttributeValue()));
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAllRepertoiresReferencedBySwAllocations()", "Adding repertoires that are referenced by the SwAllocation '" + swAllocationMoSU_Access.getRole(null) + "'." + "\n\tThe referenced repertoires are '" + linkedList + "'.");
                }
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoiresReferencedBySwAllocation( SwAllocationMoSU_Access aSwAllocationMo)", "Throwable caught: \n\tThrowable data: " + throwable, throwable);
            throw new SwAllocationMO_HandlerException("Class name: " + this.getClass().getName() + "Method: getRepertoiresReferencedBySwAllocation( SwAllocationMoSU_Access aSwAllocationMo)" + "\n\tThrowable caught: " + "\n\tThrowable data: " + throwable);
        }
    }

    public Hashtable getAllRepertoiresReferencedBySwAllocations() throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllRepertoiresReferencedBySwAllocations ()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAllRepertoiresReferencedBySwAllocations()", "No SwAllocationMO's found.");
                }
                return new Hashtable();
            }
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            ManagedObject[] managedObjectArray = null;
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            Hashtable hashtable = new Hashtable();
            while (moIterator.hasMoreElements()) {
                swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextMo();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAllRepertoiresReferencedBySwAllocations()", "Collecting referenced repertoires for SwAllocation Mo '" + swAllocationMoSU_Access.getRole(null) + "' with the distinguised name '" + swAllocationMoSU_Access + "'.");
                }
                if ((managedObjectArray = swAllocationMoSU_Access.getRepertoireList(null)) != null) {
                    Vector<RepertoireMoData> vector = new Vector<RepertoireMoData>();
                    for (int i = 0; i < managedObjectArray.length; ++i) {
                        repertoireMoSU_Access = (RepertoireMoSU_Access)managedObjectArray[i];
                        vector.add(new RepertoireMoData(repertoireMoSU_Access, repertoireMoSU_Access.getName(null), repertoireMoSU_Access.getNamingAttributeValue()));
                    }
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getAllRepertoiresReferencedBySwAllocations()", "Adding repertoires that are referenced by the SwAllocation '" + swAllocationMoSU_Access.getRole(null) + "'." + "\n\tThe referenced repertoires are '" + vector + "'.");
                    }
                    hashtable.put(swAllocationMoSU_Access, vector);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getAllRepertoiresReferencedBySwAllocations()", "The SwAllocation MO '" + swAllocationMoSU_Access.getRole(null) + "' with the\n\tdistinguished name '" + swAllocationMoSU_Access + "' is not connected to any repertoire.");
            }
            return hashtable;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getAllRepertoiresReferencedBySwAllocations ()", "Mo access exception caught: \n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            throw new SwAllocationMO_HandlerException("getAllRepertoiresReferencedBySwAllocations ()\n\tMo access exception caught: \n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getAllRepertoiresReferencedBySwAllocations ()", "Exception caught: \n\tException data: " + exception.toString(), exception);
            throw new SwAllocationMO_HandlerException("getAllRepertoiresReferencedBySwAllocations ()\n\tException caught: \n\tException data: " + exception.toString());
        }
    }

    public Collection getConnectedRepertoireNames(Coordinator coordinator) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedRepertoireNames(Coordinator aCoordinator)", "\taCoordinator: " + coordinator);
        }
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Iterator iterator = this.getConnectedRepertoires(coordinator).iterator();
            while (iterator.hasNext()) {
                hashSet.add(((RepertoireMoSU_Access)iterator.next()).getName(coordinator));
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getConnectedRepertoireNames(Coordinator aCoordinator)", "RETURNS - theConnectedRepertoireNames: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getConnectedRepertoireNames(Coordinator aCoordinator)", "Failed to collect connected SWA's.\n\tThrowable reason: " + throwable.getMessage(), throwable);
            throw new SwAllocationMO_HandlerException(throwable.toString());
        }
    }

    public Collection getConnectedRepertoires(Coordinator coordinator) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedRepertoires(Coordinator aCoordinator)", "\taCoordinator: " + coordinator);
        }
        HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
        try {
            Collection collection = this.getSwAllocationMos();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)iterator.next();
                ManagedObject[] managedObjectArray = swAllocationMoSU_Access.getRepertoireList(coordinator);
                ManagedObject[] managedObjectArray2 = swAllocationMoSU_Access.getSlotList(coordinator);
                if (managedObjectArray != null && managedObjectArray.length > 0 && managedObjectArray2 != null && managedObjectArray2.length > 0) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getConnectedRepertoires(Coordinator aCoordinator)", "The SWA " + swAllocationMoSU_Access.getRole(coordinator) + " is connected i.e. have repertoires and slots assigned to it.");
                    }
                    for (int i = 0; i < managedObjectArray.length; ++i) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getConnectedRepertoires(Coordinator aCoordinator)", "Adding repertoire " + managedObjectArray[i] + " to the repertoire list.");
                        }
                        hashSet.add(managedObjectArray[i]);
                    }
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getConnectedRepertoires(Coordinator aCoordinator)", "The SWA " + swAllocationMoSU_Access + " is not connected.");
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getConnectedRepertoires(Coordinator aCoordinator)", "RETURN - " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getConnectedRepertoires(Coordinator aCoordinator)", "Failed to collect connected SWA's.\n\tThrowable reason: " + throwable.getMessage(), throwable);
            throw new SwAllocationMO_HandlerException("Failed to collect connected SWA's.\n\tThrowable reason: " + throwable.toString());
        }
    }

    public Vector getConnectedSlots(Coordinator coordinator) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedSlots(Coordinator aCoordinator)", "\taCoordinator: " + coordinator);
        }
        Vector<ManagedObject> vector = new Vector<ManagedObject>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getConnectedSlots(Coordinator aCoordinator)", "No SwAllocation found.");
                }
                return vector;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getConnectedSlots(Coordinator aCoordinator)", "Number of found SwAllocations: " + moIterator.size());
            }
            ManagedObject managedObject = null;
            while (moIterator.hasMoreElements()) {
                SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextMo();
                ManagedObject[] managedObjectArray = swAllocationMoSU_Access.getRepertoireList(coordinator);
                ManagedObject[] managedObjectArray2 = swAllocationMoSU_Access.getSlotList(coordinator);
                if (managedObjectArray != null && managedObjectArray.length > 0 && managedObjectArray2 != null && managedObjectArray2.length > 0) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getConnectedSlots(Coordinator aCoordinator)", "The SWA " + swAllocationMoSU_Access.getRole(coordinator) + " is connected i.e. have repertoires and slots assigned to it.");
                    }
                    for (int i = 0; i < managedObjectArray2.length; ++i) {
                        managedObject = managedObjectArray2[i];
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getConnectedSlots(Coordinator aCoordinator)", "Adding slot " + managedObject + " to the slot list.");
                        }
                        vector.addElement(managedObject);
                    }
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getConnectedSlots(Coordinator aCoordinator)", "The SWA " + swAllocationMoSU_Access + " is not connected.");
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getConnectedSlots(Coordinator aCoordinator)", "Failed to collect connected SWA's.\n\tMoAccessException reason: " + moAccessException.getMessage(), moAccessException);
            throw new SwAllocationMO_HandlerException("Failed to collect connected SWA's.\n\tMoAccessException reason: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getConnectedSlots(Coordinator aCoordinator)", "Failed to collect connected SWA's.\n\tException reason: " + exception.getMessage(), exception);
            throw new SwAllocationMO_HandlerException("Failed to collect connected SWA's.\n\tException reason: " + exception.toString());
        }
    }

    public Vector getConnectedSlots(Vector vector, Coordinator coordinator) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedSlots(Vector aRepertoireNames, Coordinator aCoordinator)", "aRepertoireNames: " + vector + "\n\taCoordinator:" + coordinator);
        }
        Vector<ManagedObject> vector2 = new Vector<ManagedObject>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getConnectedSlots(Vector aRepertoireNames, Coordinator aCoordinator)", "No SwAllocation found.");
                }
                return vector2;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getConnectedSlots(Vector aRepertoireNames, Coordinator aCoordinator)", "Number of found SwAllocations: " + moIterator.size());
            }
            ManagedObject managedObject = null;
            while (moIterator.hasMoreElements()) {
                SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextMo();
                ManagedObject[] managedObjectArray = swAllocationMoSU_Access.getRepertoireList(coordinator);
                ManagedObject[] managedObjectArray2 = swAllocationMoSU_Access.getSlotList(coordinator);
                if (managedObjectArray != null && managedObjectArray.length > 0 && managedObjectArray2 != null && managedObjectArray2.length > 0) {
                    boolean bl;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getConnectedSlots(Vector aRepertoireNames, Coordinator aCoordinator)", "The SWA " + swAllocationMoSU_Access.getRole(coordinator) + " is connected i.e. have repertoires and slots assigned to it.");
                    }
                    if (!(bl = this.matchesTheRepertoireNames(managedObjectArray, vector))) continue;
                    for (int i = 0; i < managedObjectArray2.length; ++i) {
                        managedObject = managedObjectArray2[i];
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getConnectedSlots(Coordinator aCoordinator)", "Adding slot " + managedObject + " to the slot list.");
                        }
                        vector2.addElement(managedObject);
                    }
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getConnectedSlots(Coordinator aCoordinator)", "The SWA " + swAllocationMoSU_Access + " is not connected.");
            }
            return vector2;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getConnectedSlots(Coordinator aCoordinator)", "Failed to collect connected SWA's.\n\tMoAccessException reason: " + moAccessException.toString(), moAccessException);
            throw new SwAllocationMO_HandlerException("Failed to collect connected SWA's.\n\tMoAccessException reason: " + moAccessException.toString() + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getConnectedSlots(Coordinator aCoordinator)", "Failed to collect connected SWA's.\n\tException reason: " + exception.toString(), exception);
            throw new SwAllocationMO_HandlerException("Failed to collect connected SWA's.\n\tException reason: " + exception.toString() + exception.toString());
        }
    }

    public Collection getContentsOfAllSlotLists() throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getContentsOfAllSlotLists( )");
        }
        HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getContentsOfAllSlotLists( )", "No SwAllocation found.");
                }
            } else {
                ManagedObject[] managedObjectArray = null;
                while (moIterator.hasMoreElements()) {
                    SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextMo();
                    managedObjectArray = swAllocationMoSU_Access.getSlotList(null);
                    if (managedObjectArray == null || managedObjectArray.length <= 0) continue;
                    for (int i = 0; i < managedObjectArray.length; ++i) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getContentsOfAllSlotLists( )", "Adding MO " + managedObjectArray[i] + " to the total list.");
                        }
                        hashSet.add(managedObjectArray[i]);
                    }
                }
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getContentsOfAllSlotLists( )", "Throwable caught when trying to get contents of all slot lists.\n\tThrowable: " + throwable.toString(), throwable);
            throw new SwAllocationMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getContentsOfAllSlotLists( )" + "\n\tThrowable caught when trying to get contents of all slot lists." + "\n\tThrowable: " + throwable.toString());
        }
    }

    public Collection getRepertoiresToBeConnected(Collection collection, Collection collection2) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoiresToBeConnected(SwAllocationMoSU_Access anSwAllocationMo, Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF)", "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoireNamesInUCF: " + collection2);
        }
        Collection collection3 = this.getSwAllocationMos();
        Iterator iterator = collection3.iterator();
        SwAllocationMoSU_Access swAllocationMoSU_Access = null;
        Collection collection4 = null;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            swAllocationMoSU_Access = (SwAllocationMoSU_Access)iterator.next();
            collection4 = this.getRepertoiresToBeConnected(swAllocationMoSU_Access, collection, collection2);
            hashSet.addAll(collection4);
        }
        return hashSet;
    }

    public Collection getRepertoiresToBeConnected(SwAllocationMoSU_Access swAllocationMoSU_Access, Collection collection, Collection collection2) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoiresToBeConnected(SwAllocationMoSU_Access anSwAllocationMo, Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF)", "anSwAllocationMo: " + swAllocationMoSU_Access + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoireNamesInUCF: " + collection2);
        }
        Collection collection3 = new LinkedList();
        String string = null;
        boolean bl = false;
        Iterator iterator = null;
        RepertoireReplacementInformation repertoireReplacementInformation = null;
        Iterator iterator2 = null;
        try {
            ManagedObject[] managedObjectArray = swAllocationMoSU_Access.getRepertoireList(null);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                string = ((RepertoireMoSU_Access)managedObjectArray[i]).getName(null);
                bl = false;
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    repertoireReplacementInformation = (RepertoireReplacementInformation)iterator.next();
                    if (!StringHandler.isContainingStringIgnoringCase(repertoireReplacementInformation.oldReps, string)) continue;
                    bl = true;
                    iterator2 = repertoireReplacementInformation.newReps.iterator();
                    while (iterator2.hasNext()) {
                        collection3 = this.addRepertoireNameIfValid((String)iterator2.next(), collection3, collection2);
                    }
                }
                if (bl) continue;
                collection3 = this.addRepertoireNameIfValid(string, collection3, collection2);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getRepertoiresToBeConnected(SwAllocationMoSU_Access anSwAllocationMo, Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF)", "Currently connected Repertoires: " + SuLib.toString(managedObjectArray) + "\n\treturning theRepertoiresToBeConnected: " + collection3);
            }
            return collection3;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoiresToBeConnected(SwAllocationMoSU_Access anSwAllocationMo, Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF)", "Throwable caught when trying to get future connection information for an SwAllocation.\n\tThrowable: " + throwable.toString(), throwable);
            throw new SwAllocationMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getRepertoiresToBeConnected(SwAllocationMoSU_Access anSwAllocationMo, Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF)" + "\n\tThrowable caught when trying to get future connection information for an SwAllocation." + "\n\tThrowable: " + throwable.toString());
        }
    }

    public SwAllocationMoSU_Access getSwAllocationMo(String string) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationMo ( String aSwAllocationRole )", "aSwAllocationRole: " + string);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getSwAllocationMo ( String aSwAllocationRole )", "No SwAllocationMO's found.");
                }
                return null;
            }
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            while (moIterator.hasMoreElements()) {
                swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextMo();
                if (swAllocationMoSU_Access.getRole(null) == null || !swAllocationMoSU_Access.getRole(null).equals(string)) continue;
                return swAllocationMoSU_Access;
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSwAllocationMo ( String aSwAllocationRole )", "Failed to get the handle to input Sw Allocation name.\n\tThrowable reason: " + throwable.toString(), throwable);
            throw new SwAllocationMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getSwAllocationMo ( String aSwAllocationRole )" + "Failed to get the handle to input Sw Allocation name." + "\n\tThrowable reason: " + throwable.toString());
        }
    }

    public SwAllocationMoSU_Access[] getAllSwAllocationMos() throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllSwAllocationMos ()");
        }
        try {
            SwAllocationMoSU_Access[] swAllocationMoSU_AccessArray = new SwAllocationMoSU_Access[]{};
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator != null) {
                swAllocationMoSU_AccessArray = new SwAllocationMoSU_Access[moIterator.size()];
                int n = 0;
                while (moIterator.hasMoreElements()) {
                    swAllocationMoSU_AccessArray[n++] = (SwAllocationMoSU_Access)moIterator.nextMo();
                }
            }
            return swAllocationMoSU_AccessArray;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAllSwAllocationMos ()", "Throwable caught.", throwable);
            throw new SwAllocationMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetAllSwAllocationMos ()" + "\n\tThrowable caught: " + throwable);
        }
    }

    public Collection getSwAllocationMos() throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationMos ()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    hashSet.add(moIterator.nextMo());
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getSwAllocationMos ()", "RETURNS - " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSwAllocationMos ()", "Throwable caught.", throwable);
            throw new SwAllocationMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetSwAllocationMos ()" + "\n\tThrowable caught: " + throwable);
        }
    }

    public SwAllocationMoSU_Access[] getSwAllocationMos(RepertoireMoSU_Access repertoireMoSU_Access, Coordinator coordinator) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationMos (RepertoireMoSU_Access aRepertoire, Coordinator aCoordinator)", "aRepertoire: " + repertoireMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Object[] objectArray;
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            Vector<Object[]> vector = new Vector<Object[]>();
            while (moIterator.hasMoreElements()) {
                objectArray = (Object[])moIterator.nextMo();
                if (!objectArray.containsRepertoire(repertoireMoSU_Access, coordinator)) continue;
                vector.addElement(objectArray);
            }
            objectArray = new SwAllocationMoSU_Access[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSwAllocationMos (RepertoireMoSU_Access aRepertoire, Coordinator aCoordinator)", "aRepertoire: " + repertoireMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught.", throwable);
            throw new SwAllocationMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetSwAllocationMos (RepertoireMoSU_Access aRepertoire, Coordinator aCoordinator)" + "\n\taRepertoire: " + repertoireMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught: " + throwable);
        }
    }

    private Collection addRepertoireNameIfValid(String string, Collection collection, Collection collection2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addRepertoireNameIfValid(String aRepertoireName, Collection aRepertoireNames, Collection aRepertoireNamesInUCF)", "aRepertoireName: " + string + "\n\taRepertoireNames: " + collection + "\n\taRepertoireNamesInUCF: " + collection2);
        }
        if (collection2.contains(string) && !StringHandler.isContainingStringIgnoringCase(collection, string)) {
            collection.add(string);
        }
        return collection;
    }

    private void connectSwAllocationMO(SwAllocationMoSU_Access swAllocationMoSU_Access, Vector vector) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "connectSwAllocationMO ( SwAllocationMoSU_Access aSwAllocationMo, Vector theSwAllocationMoValidRepertoireNames )", "aSwAllocationMo: " + swAllocationMoSU_Access + "\n\ttheSwAllocationMoValidRepertoireNames: " + vector);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            Enumeration enumeration = vector.elements();
            RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                RepertoireMoSU_Access repertoireMoSU_Access = repertoireMO_HandlerInterface.getRepertoireMo(string, false, null);
                if (repertoireMoSU_Access != null) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "connectSwAllocationMO ( SwAllocationMoSU_Access aSwAllocationMo, Vector theSwAllocationMoValidRepertoireNames )", "The SwAllocation MO with DN '" + swAllocationMoSU_Access + "' is to be connected to the Repertoire MO with name '" + string + "'.");
                    }
                    control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                    coordinator = control.getCoordinator();
                    swAllocationMoSU_Access.actionAddRepertoire((ManagedObject)repertoireMoSU_Access, coordinator);
                    control.getTerminator().commit();
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "connectSwAllocationMO ( SwAllocationMoSU_Access aSwAllocationMo, Vector theSwAllocationMoValidRepertoireNames )", "The SwAllocation MO with DN '" + swAllocationMoSU_Access + "' could not be connected" + "\n\tto a Repertoire MO with the name '" + string + "' due to no Repertoire with that name" + "\n\twas found i.e. it does not exist in the Upgrade Control File (UCF).");
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "connectSwAllocationMO ( SwAllocationMoSU_Access aSwAllocationMo, Vector theSwAllocationMoValidRepertoireNames )", "aSwAllocationMo: " + swAllocationMoSU_Access + "\n\ttheSwAllocationMoValidRepertoireNames: " + vector + "\n\tMoAccessException caught.", moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SwAllocationMO_HandlerException("connectSwAllocationMO ( SwAllocationMoSU_Access aSwAllocationMo, Vector theSwAllocationMoValidRepertoireNames )\n\taSwAllocationMo: " + swAllocationMoSU_Access + "\n\ttheSwAllocationMoValidRepertoireNames: " + vector + "\n\tMoAccessException caught." + "\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "connectSwAllocationMO ( SwAllocationMoSU_Access aSwAllocationMo, Vector theSwAllocationMoValidRepertoireNames )", "aSwAllocationMo: " + swAllocationMoSU_Access + "\n\ttheSwAllocationMoValidRepertoireNames: " + vector + "\n\tException caught.", exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new SwAllocationMO_HandlerException("connectSwAllocationMO ( SwAllocationMoSU_Access aSwAllocationMo, Vector theSwAllocationMoValidRepertoireNames )\n\taSwAllocationMo: " + swAllocationMoSU_Access + "\n\ttheSwAllocationMoValidRepertoireNames: " + vector + "\n\tMoAccessException caught." + "\n\tMoAccessException data: " + exception.toString());
        }
    }

    private Vector getValidRepertoireNames(Vector vector, UpgradeReplacement[] upgradeReplacementArray, Vector vector2) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )", "theRepertoireMoDatas: " + vector + "\n\taRepertoireExplicitReplacementInformation: " + upgradeReplacementArray + "\n\tanAllCurrentRepertoireMoDatas: " + vector2);
        }
        Vector<String> vector3 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        RepertoireMoData repertoireMoData = null;
        String string = null;
        boolean bl = false;
        String[] stringArray = null;
        String string2 = null;
        try {
            while (enumeration.hasMoreElements()) {
                repertoireMoData = (RepertoireMoData)enumeration.nextElement();
                string = repertoireMoData.repertoireName;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )", "The old repertoire name: " + string);
                }
                bl = false;
                for (int i = 0; i < upgradeReplacementArray.length; ++i) {
                    stringArray = (String[])upgradeReplacementArray[i].oldOnes;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )", "Check if the old repertoire name '" + string + "' is among the ones defined" + "\n\tin explicit replacement as old repertoires i.e. shall be replaced by new one(s)." + "\n\tOldRep values: " + StringUtils.toString(stringArray));
                    }
                    if (!UpgradePackageSAXdh.findInList(string, stringArray)) continue;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )", "Old repertoire name is found.");
                    }
                    bl = true;
                    for (int j = 0; j < upgradeReplacementArray[i].newOnes.length; ++j) {
                        string2 = (String)upgradeReplacementArray[i].newOnes[j];
                        if (UpgradePackageSAXdh.findInList(string2, vector3)) continue;
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )", "Adding the new repertoire name '" + string2 + "' to the list containing new repertoire names." + "\n\tTheNewRepertoireNames: " + vector3);
                        }
                        vector3.addElement(string2);
                    }
                }
                if (bl) continue;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )", "The old repertoire '" + string + "' was NOT defined in the explicit replacement of Repertoires in the oldRep element.");
                }
                if (UpgradePackageSAXdh.findInList(string, vector3)) continue;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )", "Adding the old repertoire name '" + string + "' to the list containing new repertoire names." + "\n\tTheNewRepertoireNames (before): " + vector3);
                }
                vector3.addElement(string);
            }
            return vector3;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )", "Exception caught.theRepertoireMoDatas: " + vector + "\n\taRepertoireExplicitReplacementInformation: " + upgradeReplacementArray + "\n\tanAllCurrentRepertoireMoDatas: " + vector2 + "\n\tTheNewRepertoireNames: " + vector3 + "\n\ttheRepertoireMoData: " + repertoireMoData + "\n\ttheOldRepertoireName: " + string + "\n\ttheOldRepertoireNameIsFound: " + bl + "\n\ttheOldRepertoireNames: " + StringUtils.toString(stringArray) + "\n\ttheNewRepertoireName: " + string2 + "\n\tException data: " + exception.toString(), exception);
            throw new SwAllocationMO_HandlerException("getValidRepertoireNames ( Vector theRepertoireMoDatas, UpgradeReplacement[] aRepertoireExplicitReplacementInformation, Vector anAllCurrentRepertoireMoDatas )\n\tException caught.\n\ttheRepertoireMoDatas: " + vector + "\n\taRepertoireExplicitReplacementInformation: " + upgradeReplacementArray + "\n\tanAllCurrentRepertoireMoDatas: " + vector2 + "\n\tTheNewRepertoireNames: " + vector3 + "\n\ttheRepertoireMoData: " + repertoireMoData + "\n\ttheOldRepertoireName: " + string + "\n\ttheOldRepertoireNameIsFound: " + bl + "\n\ttheOldRepertoireNames: " + StringUtils.toString(stringArray) + "\n\ttheNewRepertoireName: " + string2 + "\n\tException data: " + exception.toString());
        }
    }

    private boolean matchesTheRepertoireNames(ManagedObject[] managedObjectArray, Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "matchesTheRepertoireNames(ManagedObject[] aRepertoireMOs, Vector aRepertoireNames)", "aRepertoireMOs: " + SuLib.toString(managedObjectArray) + "\n\taRepertoireNames: " + vector);
        }
        RepertoireMoSU_Access repertoireMoSU_Access = null;
        try {
            if (vector.size() > 0) {
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    repertoireMoSU_Access = (RepertoireMoSU_Access)managedObjectArray[i];
                    if (!vector.contains(repertoireMoSU_Access.getName(null))) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "matchesTheRepertoireNames(ManagedObject[] aRepertoireMOs, Vector aRepertoireNames)", "Exception caught at retreival of the repertoire name of a specific repertoire MO.\n\taRepertoireMOs: " + SuLib.toString(managedObjectArray) + "\n\taRepertoireNames: " + vector + "\n\ttheRepertoireMO: " + repertoireMoSU_Access, exception);
        }
        return false;
    }

    public void performRepertoireReplacements(Map map, Collection collection, Map map2, Map map3) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "performRepertoireReplacements(Map aConfiguredRepertoireSwAllocationsConnectionsMap, Collection aRepertoireReplacementInterfaces, Map aCurrentConfiguredRepertoireMosInformation, Map aCreatedRepertoireMos)", "aConfiguredRepertoireSwAllocationsConnectionsMap: " + map + "\n\taRepertoireReplacementInterfaces: " + collection + "\n\taCurrentConfiguredRepertoireMosInformation: " + map2 + "\n\taCreatedRepertoireMos: " + map3);
        }
        Control control = null;
        try {
            if (collection.isEmpty()) {
                return;
            }
            HashMap hashMap = new HashMap(map2);
            hashMap.putAll(map3);
            control = Transaction.create();
            Coordinator coordinator = control.getCoordinator();
            Iterator iterator = collection.iterator();
            RepertoireReplacementInterface repertoireReplacementInterface = null;
            while (iterator.hasNext()) {
                repertoireReplacementInterface = (RepertoireReplacementInterface)iterator.next();
                this.performRepertoireReplacement(repertoireReplacementInterface, map, hashMap, coordinator);
            }
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "performRepertoireReplacements(Map aConfiguredRepertoireSwAllocationsConnectionsMap, Collection aRepertoireReplacementInterfaces, Map aCurrentConfiguredRepertoireMosInformation, Map aCreatedRepertoireMos)", "Throwable caught at retreival of the repertoire name of a specific repertoire MO.aConfiguredRepertoireSwAllocationsConnectionsMap: " + map + "\n\taRepertoireReplacementInterfaces: " + collection + "\n\taCurrentConfiguredRepertoireMosInformation: " + map2, throwable);
            Transaction.rollback(control);
        }
    }

    public void performRepertoireReplacement(RepertoireReplacementInterface repertoireReplacementInterface, Map map, Map map2, Coordinator coordinator) throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "performRepertoireReplacement(RepertoireReplacementInterface aRepertoireReplacementInterface, Map aConfiguredRepertoireSwAllocationsConnectionsMap, Collection aRepertoireReplacementInterfaces, Map aCurrentConfiguredRepertoireMosInformation, Coordinator aCoordinator)", "aRepertoireReplacementInterface: " + repertoireReplacementInterface + "\n\taConfiguredRepertoireSwAllocationsConnectionsMap: " + map + "\n\tanAllConfiguredRepertoireMosInformation: " + map2 + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Iterator iterator = null;
            Iterator iterator2 = null;
            String string = null;
            String string2 = null;
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            RepertoireMoSU_Access repertoireMoSU_Access2 = null;
            ManagedObject[] managedObjectArray = null;
            iterator = repertoireReplacementInterface.getOldReps().iterator();
            while (iterator.hasNext()) {
                string = ((OldRepInterface)iterator.next()).getName();
                repertoireMoSU_Access = (RepertoireMoSU_Access)map2.get(string);
                if (repertoireMoSU_Access == null || (managedObjectArray = (ManagedObject[])map.get(repertoireMoSU_Access)) == null) continue;
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    ((SwAllocationMoSU_Access)managedObjectArray[i]).actionDeleteRepertoire((ManagedObject)repertoireMoSU_Access, coordinator);
                    iterator2 = repertoireReplacementInterface.getNewReps().iterator();
                    while (iterator2.hasNext()) {
                        string2 = ((NewRepInterface)iterator2.next()).getName();
                        repertoireMoSU_Access2 = (RepertoireMoSU_Access)map2.get(string2);
                        ((SwAllocationMoSU_Access)managedObjectArray[i]).actionAddRepertoire((ManagedObject)repertoireMoSU_Access2, coordinator);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "performRepertoireReplacement(RepertoireReplacementInterface aRepertoireReplacementInterface, Map aConfiguredRepertoireSwAllocationsConnectionsMap, Collection aRepertoireReplacementInterfaces, Map aCurrentConfiguredRepertoireMosInformation, Coordinator aCoordinator)", "aRepertoireReplacementInterface: " + repertoireReplacementInterface + "\n\taConfiguredRepertoireSwAllocationsConnectionsMap: " + map + "\n\tanAllConfiguredRepertoireMosInformation: " + map2, throwable);
        }
    }

    public Collection getAllRepertoireNamesReferencedBySwAllocations() throws SwAllocationMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllRepertoireNamesReferencedBySwAllocations ()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAllRepertoireNamesReferencedBySwAllocations()", "No SwAllocationMO's found.");
                }
                return new Vector();
            }
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            ManagedObject[] managedObjectArray = null;
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            Vector<String> vector = new Vector<String>();
            while (moIterator.hasMoreElements()) {
                swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextMo();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAllRepertoireNamesReferencedBySwAllocations()", "Collecting referenced repertoires for SwAllocation Mo '" + swAllocationMoSU_Access.getRole(null) + "' with the distinguised name '" + swAllocationMoSU_Access + "'.");
                }
                if ((managedObjectArray = swAllocationMoSU_Access.getRepertoireList(null)) != null) {
                    for (int i = 0; i < managedObjectArray.length; ++i) {
                        repertoireMoSU_Access = (RepertoireMoSU_Access)managedObjectArray[i];
                        vector.add(repertoireMoSU_Access.getName(null));
                    }
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getAllRepertoireNamesReferencedBySwAllocations()", "The SwAllocation MO '" + swAllocationMoSU_Access.getRole(null) + "' with the\n\tdistinguished name '" + swAllocationMoSU_Access + "' is not connected to any repertoire.");
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getAllRepertoireNamesReferencedBySwAllocations ()", "Mo access exception caught: \n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            throw new SwAllocationMO_HandlerException("getAllRepertoireNamesReferencedBySwAllocations ()\n\tMo access exception caught: \n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getAllRepertoireNamesReferencedBySwAllocations ()", "Exception caught: \n\tException data: " + exception.toString(), exception);
            throw new SwAllocationMO_HandlerException("getAllRepertoireNamesReferencedBySwAllocations ()\n\tException caught: \n\tException data: " + exception.toString());
        }
    }

    public boolean isSU_VersionSupported(String string) throws SwAllocationMO_HandlerException {
        MoFactory moFactory = MoFactoryMgr.instance().lookup("SwAllocation");
        return SU_AccessVersionHandler.getInstance().isSupported(string, (Object)moFactory);
    }
}

