/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.upgradeable;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.SSW_UpgradeablePlugInUnit;
import se.ericsson.cello.equipment.UpgradeablePlugInUnit3;
import se.ericsson.cello.equipment.suaccess.FanMoSU_Access;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringUtils;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.parser.ParserFactoryException;
import se.ericsson.cello.sudom.parser.UpgradeControlFileNotFoundException;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypeProxyInterface;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypesProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.control.UpgradeRegistry;
import se.ericsson.cello.upgradepackage.control.UpgradeRegistryHandlerInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.LockPIUsInformation;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.fan.FanMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.fan.FanMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class UpgradeablePIU_Handler
implements UpgradeablePIU_HandlerInterface {
    private boolean myAllPIUEnabled = false;

    public UpgradeablePIU_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradeablePIU_Handler(MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public Vector collectNonOperationalPIUs() throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectNonOperationalPIUs()");
        }
        String[] stringArray = null;
        Vector<PiuTypeMoData> vector = new Vector<PiuTypeMoData>(1);
        Control control = null;
        Coordinator coordinator = null;
        try {
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collectNonOperationalPIUs()", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the Upgrade Package function.");
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectNonOperationalPIUs(", "Registered plug in unit MO type names: " + SuLib.toString(stringArray));
            }
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            for (int i = 0; i < stringArray.length; ++i) {
                MoIterator moIterator = MoRepository.instance().lookupType(stringArray[i]);
                if (moIterator == null) continue;
                while (moIterator.hasMoreElements()) {
                    int n;
                    GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "collectNonOperationalPIUs()", "Retreiving the operational state of PlugInUnit '" + genericUpgradeablePlugInUnit + ".");
                    }
                    if ((n = genericUpgradeablePlugInUnit.getOperationalState(coordinator)) != 0) continue;
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                    PiuTypeMoData piuTypeMoData = null;
                    piuTypeMoData = piuTypeMoSU_Access != null ? piuTypeMO_HandlerInterface.getPiuTypeData(piuTypeMoSU_Access) : new PiuTypeMoData(null, null, null);
                    piuTypeMoData.setPlugInUnit(genericUpgradeablePlugInUnit);
                    vector.addElement(piuTypeMoData);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collectNonOperationalPIUs()", "The PlugInUnit '" + genericUpgradeablePlugInUnit + "' is faulty i.e. the operational state is 'disabled'." + "\n\tPiuType data for this plugInUnit: " + piuTypeMoData);
                }
            }
            control.getTerminator().commit();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectNonOperationalPIUs()", "The non operational PIUs are: " + vector);
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "collectNonOperationalPIUs()", "Mo access exception caught: \n\tThe types of GenericUpgradeablePlugInUnit: " + SuLib.toString(stringArray) + "\n\ttheNonOperationalPIUs: " + vector + "\n\tException: " + moAccessException.toString(), moAccessException);
            try {
                if (control != null && control.getCoordinator().getStatus() == Status.ACTIVE) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "collectNonOperationalPIUs()", "Rollback failed even though the transaction was active.", exception);
            }
            throw new UpgradeablePIU_HandlerException("collectNonOperationalPIUs()\n\tMo access exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonOperationalPIUs: " + vector + "\n\tException: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "collectNonOperationalPIUs()", "Exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonOperationalPIUs: " + vector + "\n\tException: " + exception.toString(), exception);
            try {
                if (control != null && control.getCoordinator().getStatus() == Status.ACTIVE) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                Trace.error(this.getClass(), "collectNonOperationalPIUs()", "Rollback failed even though the transaction was active.", exception2);
            }
            throw new UpgradeablePIU_HandlerException("collectNonOperationalPIUs()\n\tException caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonOperationalPIUs: " + vector + "\n\tException: " + exception.toString());
        }
    }

    public Vector collectNonSupportedPIUs(String string, String string2, String string3) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "anUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3);
        }
        String[] stringArray = null;
        Vector<PiuTypeMoData> vector = new Vector<PiuTypeMoData>(1);
        try {
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(string2, string3, string, "PiuType");
            PiuTypesProxyInterface piuTypesProxyInterface = documentObjectProxyInterface.getPiuTypesProxyInterface();
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the Upgrade Package function.");
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "Registered plug in unit MO type names: " + SuLib.toString(stringArray));
            }
            PiuTypeProxyInterface piuTypeProxyInterface = null;
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            for (int i = 0; i < stringArray.length; ++i) {
                MoIterator moIterator = MoRepository.instance().lookupType(stringArray[i]);
                if (moIterator == null) continue;
                while (moIterator.hasMoreElements()) {
                    PiuTypeMoData piuTypeMoData;
                    GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                    if (piuTypeMoSU_Access != null) {
                        piuTypeMoData = piuTypeMO_HandlerInterface.getPiuTypeData(piuTypeMoSU_Access);
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "Product data of referenced PiuType.\n\ttheReferencedPiuTypeMoData: " + piuTypeMoData);
                        }
                        if ((piuTypeProxyInterface = piuTypesProxyInterface.getPiuTypeProxyInterface(new ProductNumberAndRevision(piuTypeMoData.productNumber, piuTypeMoData.productRevision, null), true)) != null) continue;
                        if (piuTypeMoData.productRevision.equals("*")) {
                            String string4 = this.getOriginRevision(genericUpgradeablePlugInUnit);
                            if (string4 != null) {
                                piuTypeProxyInterface = piuTypesProxyInterface.getPiuTypeProxyInterface(new ProductNumberAndRevision(piuTypeMoData.productNumber, string4, null), true);
                            }
                            if (piuTypeProxyInterface != null) continue;
                            piuTypeMoData.setPlugInUnit(genericUpgradeablePlugInUnit);
                            vector.addElement(piuTypeMoData);
                            if (!Trace.valid(this.getClass(), 22)) continue;
                            Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The PlugInUnit '" + genericUpgradeablePlugInUnit + "' is not supported by this upgrade package." + "\n\tPiuType data for this plugInUnit: " + piuTypeMoData + "\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\nttheOriginRevision: " + string4);
                            continue;
                        }
                        piuTypeMoData.setPlugInUnit(genericUpgradeablePlugInUnit);
                        vector.addElement(piuTypeMoData);
                        if (!Trace.valid(this.getClass(), 22)) continue;
                        Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The PlugInUnit '" + genericUpgradeablePlugInUnit + "' is not supported by this upgrade package." + "\n\tPiuType data for this plugInUnit: " + piuTypeMoData + "\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3);
                        continue;
                    }
                    if (!stringArray[i].equals("PlugInUnit") && !stringArray[i].equals("Fan")) continue;
                    Trace.info(this.getClass(), "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The upgradeable PlugInUnit '" + genericUpgradeablePlugInUnit + "' is not connected to a PiuTypeMO." + "\n\tNot possible to verify this PlugInUnit due to no product data available.");
                    piuTypeMoData = new PiuTypeMoData(null, null, null);
                    piuTypeMoData.setPlugInUnit(genericUpgradeablePlugInUnit);
                    vector.addElement(piuTypeMoData);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The PlugInUnit '" + genericUpgradeablePlugInUnit + "' is not connected to any PiuType MO." + "\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3);
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The Non supported PIUs are: " + vector);
            }
            return vector;
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The UCF was not found while attempting to parse the parse the Piu Types.\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\ttheTypesOfUpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonSupportedPIUs: " + vector + "\n\tUpgradeControlFileNotFoundException reason: " + upgradeControlFileNotFoundException.toString());
            }
            throw new UpgradeablePIU_HandlerException("The UCF was not found while attempting to parse the parse the Piu Types.\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\ttheTypesOfUpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonSupportedPIUs: " + vector + "\n\tUpgradeControlFileNotFoundException reason: " + upgradeControlFileNotFoundException.toString());
        }
        catch (ParserFactoryException parserFactoryException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "A ParserFactoryException was caught while parsing the Piu Types in the UCF.\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\ttheTypesOfUpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonSupportedPIUs: " + vector + "\n\tParserFactoryException reason: " + parserFactoryException.toString());
            }
            throw new UpgradeablePIU_HandlerException("A ParserFactoryException was caught while parsing the Piu Types in the UCF.\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\ttheTypesOfUpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonSupportedPIUs: " + vector + "\n\tParserFactoryException reason: " + parserFactoryException.toString());
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "Mo access exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonSupportedPIUs: " + vector + "\n\tException: " + moAccessException.toString(), moAccessException);
            throw new UpgradeablePIU_HandlerException("collectNonSupportedPIUs ()\n\tMo access exception caught: \n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonSupportedPIUs: " + vector + "\n\tException: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "collectNonSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "Exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonSupportedPIUs: " + vector + "\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\tException: " + exception.toString(), exception);
            throw new UpgradeablePIU_HandlerException("collectNonSupportedPIUs ()\n\tException caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheNonSupportedPIUs: " + vector + "\n\tanUCF_Path: " + string + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\tException: " + exception.toString());
        }
    }

    public String getOriginRevision(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOriginRevision ( GenericUpgradeablePlugInUnit aPlugInUnit )", "aPlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        try {
            if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
                PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
                return pIU_MO_HandlerInterface.getOriginRevision((PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit);
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getOriginRevision ( GenericUpgradeablePlugInUnit aPlugInUnit )", "Throwable caught: \n\taPlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tException: " + throwable.toString(), throwable);
            throw new UpgradeablePIU_HandlerException("getOriginRevision ( GenericUpgradeablePlugInUnit aPlugInUnit )\n\tThrowable caught: \n\taPlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tThrowable: " + throwable.toString());
        }
    }

    public Vector collectOperationalPIUs() throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectOperationalPIUs()");
        }
        String[] stringArray = null;
        Vector<PiuTypeMoData> vector = new Vector<PiuTypeMoData>(1);
        Control control = null;
        Coordinator coordinator = null;
        try {
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collectOperationalPIUs()", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the Upgrade Package function.");
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectOperationalPIUs(", "Registered plug in unit MO type names: " + SuLib.toString(stringArray));
            }
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            for (int i = 0; i < stringArray.length; ++i) {
                MoIterator moIterator = MoRepository.instance().lookupType(stringArray[i]);
                if (moIterator == null) continue;
                while (moIterator.hasMoreElements()) {
                    int n;
                    GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "collectOperationalPIUs()", "Retreiving the operational state of PlugInUnit '" + genericUpgradeablePlugInUnit + ".");
                    }
                    if ((n = genericUpgradeablePlugInUnit.getOperationalState(coordinator)) != 1) continue;
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                    PiuTypeMoData piuTypeMoData = null;
                    piuTypeMoData = piuTypeMoSU_Access != null ? piuTypeMO_HandlerInterface.getPiuTypeData(piuTypeMoSU_Access) : new PiuTypeMoData(null, null, null);
                    piuTypeMoData.setPlugInUnit(genericUpgradeablePlugInUnit);
                    vector.addElement(piuTypeMoData);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collectOperationalPIUs()", "The PlugInUnit '" + genericUpgradeablePlugInUnit + "' is operational i.e. the operational state is 'enabled'." + "\n\tPiuType data for this plugInUnit: " + piuTypeMoData);
                }
            }
            control.getTerminator().commit();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectOperationalPIUs()", "The operational PIUs are: " + vector);
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "collectOperationalPIUs()", "Mo access exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheOperationalPIUs: " + vector + "\n\tException: " + moAccessException.toString(), moAccessException);
            try {
                if (control != null && control.getCoordinator().getStatus() == Status.ACTIVE) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "collectOperationalPIUs()", "Rollback failed even though the transaction was active.", exception);
            }
            throw new UpgradeablePIU_HandlerException("collectOperationalPIUs()\n\tMo access exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheOperationalPIUs: " + vector + "\n\tException: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "collectOperationalPIUs()", "Exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheOperationalPIUs: " + vector + "\n\tException: " + exception.toString(), exception);
            try {
                if (control != null && control.getCoordinator().getStatus() == Status.ACTIVE) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                Trace.error(this.getClass(), "collectOperationalPIUs()", "Rollback failed even though the transaction was active.", exception2);
            }
            throw new UpgradeablePIU_HandlerException("collectOperationalPIUs()\n\tException caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheOperationalPIUs: " + vector + "\n\tException: " + exception.toString());
        }
    }

    public Vector collectSupportedPIUs(String string, String string2, String string3) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectSupportedPIUs(String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3);
        }
        String[] stringArray = null;
        Vector<PiuTypeMoData> vector = new Vector<PiuTypeMoData>(1);
        try {
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(string2, string3, string, "PiuType");
            PiuTypesProxyInterface piuTypesProxyInterface = documentObjectProxyInterface.getPiuTypesProxyInterface();
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the Upgrade Package function.");
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "Registered plug in unit MO type names: " + SuLib.toString(stringArray));
            }
            PiuTypeProxyInterface piuTypeProxyInterface = null;
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            for (int i = 0; i < stringArray.length; ++i) {
                MoIterator moIterator = MoRepository.instance().lookupType(stringArray[i]);
                if (moIterator == null) continue;
                while (moIterator.hasMoreElements()) {
                    GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                    if (piuTypeMoSU_Access == null) continue;
                    PiuTypeMoData piuTypeMoData = piuTypeMO_HandlerInterface.getPiuTypeData(piuTypeMoSU_Access);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "Product data of referenced PiuType.\n\ttheReferencedPiuTypeMoData: " + piuTypeMoData);
                    }
                    if ((piuTypeProxyInterface = piuTypesProxyInterface.getPiuTypeProxyInterface(new ProductNumberAndRevision(piuTypeMoData.productNumber, piuTypeMoData.productRevision, null), true)) == null) continue;
                    piuTypeMoData.setPlugInUnit(genericUpgradeablePlugInUnit);
                    vector.addElement(piuTypeMoData);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The PlugInUnit '" + genericUpgradeablePlugInUnit + "' is supported by this upgrade package." + "\n\tPiuType data for this plugInUnit: " + piuTypeMoData + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3);
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The supported PIUs are: " + vector);
            }
            return vector;
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "The UCF was not found while attempting to parse the parse the Piu Types.\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\ttheTypesOfUpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheSupportedPIUs: " + vector + "\n\tUpgradeControlFileNotFoundException reason: " + upgradeControlFileNotFoundException.toString());
            }
            throw new UpgradeablePIU_HandlerException("The UCF was not found while attempting to parse the parse the Piu Types.\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\ttheTypesOfUpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheSupportedPIUs: " + vector + "\n\tUpgradeControlFileNotFoundException reason: " + upgradeControlFileNotFoundException.toString());
        }
        catch (ParserFactoryException parserFactoryException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "A ParserFactoryException was caught while parsing the Piu Types in the UCF.\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\ttheTypesOfUpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheSupportedPIUs: " + vector + "\n\tParserFactoryException reason: " + parserFactoryException.toString());
            }
            throw new UpgradeablePIU_HandlerException("A ParserFactoryException was caught while parsing the Piu Types in the UCF.\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\ttheTypesOfUpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheSupportedPIUs: " + vector + "\n\tParserFactoryException reason: " + parserFactoryException.toString());
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "Mo access exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheSupportedPIUs: " + vector + "\n\tException: " + moAccessException.toString(), moAccessException);
            throw new UpgradeablePIU_HandlerException("collectSupportedPIUs ()\n\tMo access exception caught: \n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheSupportedPIUs: " + vector + "\n\tException: " + moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectSupportedPIUs(String anUCF_Path, String aDocumentNumberOfUP, String aDocumentRevisionOfUP)", "Throwable caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheSupportedPIUs: " + vector + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\tException: " + throwable.toString(), throwable);
            throw new UpgradeablePIU_HandlerException("collectSupportedPIUs ()\n\tThrowable caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\ttheSupportedPIUs: " + vector + "\n\taDocumentNumberOfUP: " + string2 + "\n\taDocumentRevisionOfUP: " + string3 + "\n\tException: " + throwable.toString());
        }
    }

    public LockPIUsInformation getPIUsLockInformation(Vector vector) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPIUsLockInformation(Vector aPIUsLockInformation)", "aPIUsLockInformation: " + vector);
        }
        Vector<GenericUpgradeablePlugInUnit> vector2 = new Vector<GenericUpgradeablePlugInUnit>(1);
        Vector<GenericUpgradeablePlugInUnit> vector3 = new Vector<GenericUpgradeablePlugInUnit>(1);
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
        PiuTypeMoData piuTypeMoData = null;
        try {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                genericUpgradeablePlugInUnit = piuTypeMoData.plugInUnit;
                if (genericUpgradeablePlugInUnit.getAdministrativeState(null) != 0) {
                    vector2.addElement(genericUpgradeablePlugInUnit);
                    continue;
                }
                vector3.addElement(genericUpgradeablePlugInUnit);
            }
            return new LockPIUsInformation(vector3, vector2);
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getPIUsLockInformation(Vector aPIUsLockInformation)", "UpgradeablePIU_HandlerException caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsNotLocked: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsLockInformation: " + vector + "\n\tUpgradeablePIU_HandlerException: " + upgradeablePIU_HandlerException.toString());
            }
            throw upgradeablePIU_HandlerException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getPIUsLockInformation(Vector aPIUsLockInformation)", "Mo access exception caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsNotLocked: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsLockInformation: " + vector + "\n\tMoAccessException: " + moAccessException.toString(), moAccessException);
            throw new UpgradeablePIU_HandlerException("Mo access exception caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsNotLocked: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsLockInformation: " + vector + "\n\ttMoAccessException: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getPIUsLockInformation(Vector aPIUsLockInformation)", "Exception caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsNotLocked: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsLockInformation: " + vector + "\n\tException: " + exception.toString(), exception);
            throw new UpgradeablePIU_HandlerException("Exception caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsNotLocked: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsLockInformation: " + vector + "\n\tException: " + exception.toString());
        }
    }

    public HashMap getSWA_MOsConnectedToUpgradeablePIUsMap() throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSWA_MOsConnectedToUpgradeablePIUsMap( )");
        }
        try {
            String[] stringArray = null;
            HashMap<SwAllocationMoSU_Access, HashSet<GenericUpgradeablePlugInUnit>> hashMap = new HashMap<SwAllocationMoSU_Access, HashSet<GenericUpgradeablePlugInUnit>>();
            HashSet<GenericUpgradeablePlugInUnit> hashSet = null;
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getSWA_MOsConnectedToUpgradeablePIUsMap( )", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the System Upgrade function.");
                }
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getSWA_MOsConnectedToUpgradeablePIUsMap( )", "Registered plug in unit MO type names: " + StringUtils.toString(stringArray));
                }
                MoIterator moIterator = null;
                GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
                SwAllocationMoSU_Access swAllocationMoSU_Access = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    moIterator = MoRepository.instance().lookupType(stringArray[i]);
                    if (moIterator == null) continue;
                    while (moIterator.hasMoreElements()) {
                        try {
                            genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                            ManagedObject[] managedObjectArray = this.getSwAllocationsConnectedToPIU(genericUpgradeablePlugInUnit);
                            for (int j = 0; j < managedObjectArray.length; ++j) {
                                swAllocationMoSU_Access = (SwAllocationMoSU_Access)managedObjectArray[j];
                                if (swAllocationMoSU_Access == null) continue;
                                hashSet = (HashSet<GenericUpgradeablePlugInUnit>)hashMap.get(swAllocationMoSU_Access);
                                if (hashSet == null) {
                                    hashSet = new HashSet<GenericUpgradeablePlugInUnit>();
                                }
                                hashSet.add(genericUpgradeablePlugInUnit);
                                hashMap.put(swAllocationMoSU_Access, hashSet);
                                if (!Trace.valid(this.getClass(), 22)) continue;
                                Trace.debug(this.getClass(), 22, "getSWA_MOsConnectedToUpgradeablePIUsMap( )", "SwAllocation: " + swAllocationMoSU_Access + " theUpgradeablePIUsConnectedToTheSWA: " + hashSet.toString());
                            }
                        }
                        catch (Throwable throwable) {
                            Trace.error(this.getClass(), "getSWA_MOsConnectedToUpgradeablePIUsMap( )", "Throwable caught when calling method 'getSwAllocation(..)' in upgradeable PlugInUnit,\n\tupgradeable PlugInUnit type name: " + stringArray[i], throwable);
                            throw new UpgradeablePIU_HandlerException("getSWA_MOsConnectedToUpgradeablePIUsMap( )\n\tThrowable caught when calling method 'getSwAllocation(..)' in upgradeable PlugInUnit,\n\tupgradeable PlugInUnit type name: " + stringArray[i] + "\n\tThrowable data: " + throwable.toString());
                        }
                    }
                }
            }
            return hashMap;
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            throw upgradeablePIU_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSWA_MOsConnectedToUpgradeablePIUsMap( )", "Throwable caught.", throwable);
            throw new UpgradeablePIU_HandlerException("getSWA_MOsConnectedToUpgradeablePIUsMap( )\n\tThrowable caught.\n\tThrowable data: " + throwable.toString());
        }
    }

    private ManagedObject[] getSwAllocationsConnectedToPIU(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MoAccessException {
        try {
            if (genericUpgradeablePlugInUnit instanceof UpgradeablePlugInUnit3) {
                return ((UpgradeablePlugInUnit3)genericUpgradeablePlugInUnit).getSwAllocations(null);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Trace.warning(this.getClass(), "getSwAllocationsConnectedToPIU(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "Throwable caught.\n\tAssuming that only one SwAllocation are defined \n\tThrowable data: " + noClassDefFoundError);
        }
        ManagedObject managedObject = genericUpgradeablePlugInUnit.getSwAllocation(null);
        if (managedObject == null) {
            return new ManagedObject[0];
        }
        ManagedObject[] managedObjectArray = new ManagedObject[]{managedObject};
        return managedObjectArray;
    }

    public Collection getUpgradeablePlugInUnits() throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradeablePlugInUnits()");
        }
        try {
            String[] stringArray = null;
            HashSet<PiuTypeMoData> hashSet = new HashSet<PiuTypeMoData>();
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getUpgradeablePlugInUnits()", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the System Upgrade function.");
                }
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getUpgradeablePlugInUnits()", "Registered plug in unit MO type names: " + StringUtils.toString(stringArray));
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    MoIterator moIterator = MoRepository.instance().lookupType(stringArray[i]);
                    if (moIterator == null) continue;
                    PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
                    while (moIterator.hasMoreElements()) {
                        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                        PiuTypeMoData piuTypeMoData = null;
                        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
                        piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                        piuTypeMoData = piuTypeMoSU_Access != null ? piuTypeMO_HandlerInterface.getPiuTypeData(piuTypeMoSU_Access) : new PiuTypeMoData(null, null, null);
                        piuTypeMoData.setPlugInUnit(genericUpgradeablePlugInUnit);
                        hashSet.add(piuTypeMoData);
                    }
                }
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getUpgradeablePlugInUnits()", "Throwable caught when collecting registered upgradeable plug in units.\n\tThrowable data: " + throwable, throwable);
            throw new UpgradeablePIU_HandlerException("getUpgradeablePlugInUnits()\n\tThrowable caught when .\n\tThrowable data: " + throwable);
        }
    }

    public boolean isInstanceOfSSW_UpgradeablePlugInUnit(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isInstanceOfSSW_UpgradeablePlugInUnit(GenericUpgradeablePlugInUnit aPlugInUnit)", "aPlugInUnit : " + genericUpgradeablePlugInUnit);
        }
        try {
            return genericUpgradeablePlugInUnit instanceof SSW_UpgradeablePlugInUnit;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isInstanceOfSSW_UpgradeablePlugInUnit(GenericUpgradeablePlugInUnit aPlugInUnit)", "it is not supported SSW_UpgradeablePlugInUnit");
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "isInstanceOfSSW_UpgradeablePlugInUnit(GenericUpgradeablePlugInUnit aPlugInUnit)", "it is not supported SSW_UpgradeablePlugInUnit");
            return false;
        }
    }

    public Collection getSignedUpgradeablePlugInUnits() throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSignedUpgradeablePlugInUnits()");
        }
        try {
            String[] stringArray = null;
            HashSet<GenericUpgradeablePlugInUnit> hashSet = new HashSet<GenericUpgradeablePlugInUnit>();
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getSignedUpgradeablePlugInUnits()", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the System Upgrade function.");
                }
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getSignedUpgradeablePlugInUnits()", "Registered plug in unit MO type names: " + SuLib.toString(stringArray));
                }
                this.myAllPIUEnabled = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    MoIterator moIterator = MoRepository.instance().lookupType(stringArray[i]);
                    if (moIterator == null) continue;
                    while (moIterator.hasMoreElements()) {
                        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                        if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
                            if (!SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)genericUpgradeablePlugInUnit)) continue;
                            if (((PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit).getSignatureValidationService(null) == 1) {
                                hashSet.add(genericUpgradeablePlugInUnit);
                                continue;
                            }
                            this.myAllPIUEnabled = false;
                            continue;
                        }
                        if (!this.isInstanceOfSSW_UpgradeablePlugInUnit(genericUpgradeablePlugInUnit)) continue;
                        if (((SSW_UpgradeablePlugInUnit)genericUpgradeablePlugInUnit).getSignatureValidationService(null) == 1) {
                            hashSet.add(genericUpgradeablePlugInUnit);
                            continue;
                        }
                        this.myAllPIUEnabled = false;
                    }
                }
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSignedUpgradeablePlugInUnits()", "Throwable caught when collecting registered upgradeable plug in units.\n\tThrowable data: " + throwable, throwable);
            throw new UpgradeablePIU_HandlerException("getUpgradeablePlugInUnits()\n\tThrowable caught when .\n\tThrowable data: " + throwable);
        }
    }

    public boolean isAllPIUEnabled() throws UpgradeablePIU_HandlerException {
        this.getSignedUpgradeablePlugInUnits();
        return this.myAllPIUEnabled;
    }

    public GenericUpgradeablePlugInUnit[] getAllExistingConfiguredPius() throws UpgradeablePIU_HandlerException {
        UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface;
        String[] stringArray;
        String string = "getAllExistingConfiguredPius()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, " ");
        }
        if ((stringArray = (upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class)).getPlugInUnitMoTypeNames()) == null) {
            stringArray = new String[]{};
        }
        Vector<GenericUpgradeablePlugInUnit> vector = new Vector<GenericUpgradeablePlugInUnit>();
        for (int i = 0; i < stringArray.length; ++i) {
            MoIterator moIterator;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "PlugInUnit type name: " + stringArray[i]);
            }
            if ((moIterator = MoRepository.instance().lookupType(stringArray[i])) == null) continue;
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                if (managedObject instanceof GenericUpgradeablePlugInUnit) {
                    vector.addElement((GenericUpgradeablePlugInUnit)managedObject);
                    continue;
                }
                Trace.error(this.getClass(), string, "a piu is configure as " + managedObject.getClass().getName());
            }
        }
        GenericUpgradeablePlugInUnit[] genericUpgradeablePlugInUnitArray = new GenericUpgradeablePlugInUnit[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            genericUpgradeablePlugInUnitArray[i] = (GenericUpgradeablePlugInUnit)vector.elementAt(i);
        }
        return genericUpgradeablePlugInUnitArray;
    }

    public SwAllocationMoSU_Access getActiveSwAllocationMo(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, Coordinator coordinator) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getActiveSwAllocationMo(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, Coordinator aCoordinator)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return (SwAllocationMoSU_Access)genericUpgradeablePlugInUnit.getSwAllocation(coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getActiveSwAllocationMo(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, Coordinator aCoordinator)", "Throwable caught.\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new UpgradeablePIU_HandlerException(throwable.toString());
        }
    }

    public GenericUpgradeablePlugInUnit[] getAllConfiguredCelloPius() throws UpgradeablePIU_HandlerException {
        String string = "getAllConfiguredCelloPius()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, " ");
        }
        GenericUpgradeablePlugInUnit[] genericUpgradeablePlugInUnitArray = this.getAllExistingConfiguredPius();
        Vector<GenericUpgradeablePlugInUnit> vector = new Vector<GenericUpgradeablePlugInUnit>();
        for (int i = 0; i < genericUpgradeablePlugInUnitArray.length; ++i) {
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = genericUpgradeablePlugInUnitArray[i];
            if (!(genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) && !(genericUpgradeablePlugInUnit instanceof FanMoSU_Access)) continue;
            vector.addElement(genericUpgradeablePlugInUnit);
        }
        GenericUpgradeablePlugInUnit[] genericUpgradeablePlugInUnitArray2 = new GenericUpgradeablePlugInUnit[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            genericUpgradeablePlugInUnitArray2[i] = (GenericUpgradeablePlugInUnit)vector.elementAt(i);
        }
        return genericUpgradeablePlugInUnitArray2;
    }

    public LockPIUsInformation lockPIUs(Vector vector) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "lockPIUs(Vector aPIUsToBeLocked)", "aPIUsToBeLocked: " + vector);
        }
        Vector<GenericUpgradeablePlugInUnit> vector2 = new Vector<GenericUpgradeablePlugInUnit>(1);
        Vector<GenericUpgradeablePlugInUnit> vector3 = new Vector<GenericUpgradeablePlugInUnit>(1);
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
        PiuTypeMoData piuTypeMoData = null;
        try {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                genericUpgradeablePlugInUnit = piuTypeMoData.plugInUnit;
                if (genericUpgradeablePlugInUnit.getAdministrativeState(null) != 0) {
                    this.setAdministrativeState(genericUpgradeablePlugInUnit, 0);
                    vector2.addElement(genericUpgradeablePlugInUnit);
                    continue;
                }
                vector3.addElement(genericUpgradeablePlugInUnit);
            }
            this.waitForPIUsToBeLocked(vector2);
            return new LockPIUsInformation(vector3, vector2);
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "lockPIUs(Vector aPIUsToBeLocked)", "UpgradeablePIU_HandlerException caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsLockedByUpgrade: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsToBeLocked: " + vector + "\n\tUpgradeablePIU_HandlerException: " + upgradeablePIU_HandlerException.toString());
            }
            throw upgradeablePIU_HandlerException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "lockPIUs(Vector aPIUsToBeLocked)", "Mo access exception caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsLockedByUpgrade: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsToBeLocked: " + vector + "\n\tMoAccessException: " + moAccessException.toString(), moAccessException);
            throw new UpgradeablePIU_HandlerException("Mo access exception caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsLockedByUpgrade: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsToBeLocked: " + vector + "\n\ttMoAccessException: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "lockPIUs(Vector aPIUsToBeLocked)", "Exception caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsLockedByUpgrade: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsToBeLocked: " + vector + "\n\tException: " + exception.toString(), exception);
            throw new UpgradeablePIU_HandlerException("Exception caught when attempting to lock faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthePIUsLockedByUpgrade: " + vector2 + "\n\tthePIUsLockedBeforeUpgrade: " + vector3 + "\n\taPIUsToBeLocked: " + vector + "\n\tException: " + exception.toString());
        }
    }

    public void unlockPIUs(Vector vector) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "unlockPIUs(Vector aPIUsToBeUnlocked)", "aPIUsToBeUnlocked: " + vector);
        }
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
        try {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                this.setAdministrativeState(genericUpgradeablePlugInUnit, 1);
            }
            this.waitForPIUsToBeUnlocked(vector);
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "unlockPIUs(Vector aPIUsToBeUnlocked)", "UpgradeablePIU_HandlerException caught when attempting to unlock earlier locked faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taPIUsToBeUnlocked: " + vector + "\n\tUpgradeablePIU_HandlerException: " + upgradeablePIU_HandlerException.toString());
            }
            throw upgradeablePIU_HandlerException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "unlockPIUs(Vector aPIUsToBeUnlocked)", "Exception caught when attempting to unlock earlier locked faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taPIUsToBeUnlocked: " + vector + "\n\tException: " + exception.toString(), exception);
            throw new UpgradeablePIU_HandlerException("Exception caught when attempting to unlock earlier locked faulty and/ or non supported PIUs: \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taPIUsToBeUnlocked: " + vector + "\n\tException: " + exception.toString());
        }
    }

    public boolean updateUpgradeablePIUSWithProductData() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateUpgradeablePIUSWithProductData ()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            Collection collection = this.getUpgradeablePlugInUnits();
            Iterator iterator = collection.iterator();
            PiuTypeMoData piuTypeMoData = null;
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            FanMO_HandlerInterface fanMO_HandlerInterface = ServiceFinder.getFanMO_HandlerInterface();
            while (iterator.hasNext()) {
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                if (piuTypeMoData.plugInUnit instanceof FanMoSU_Access) {
                    if (piuTypeMoData.productRevision == null) continue;
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "updateUpgradeablePIUSWithProductData()", "Updating the FAN resourcetheUpgradeablePlugInUnitPiuTypeMoData: " + piuTypeMoData);
                    }
                    fanMO_HandlerInterface.updateFanMO_Resource2((PiuTypeMoSU_Access)piuTypeMoData.plugInUnit.getPiuType(null), (FanMoSU_Access)piuTypeMoData.plugInUnit, coordinator);
                    continue;
                }
                if (piuTypeMoData.plugInUnit instanceof PlugInUnitMoSU_Access) {
                    if (piuTypeMoData.productRevision == null) continue;
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "updateUpgradeablePIUSWithProductData()", "Updating the PlugInUnit resourcetheUpgradeablePlugInUnitPiuTypeMoData: " + piuTypeMoData);
                    }
                    pIU_MO_HandlerInterface.updatePIU_MO_Resource((PiuTypeMoSU_Access)piuTypeMoData.plugInUnit.getPiuType(null), (PlugInUnitMoSU_Access)piuTypeMoData.plugInUnit, true, coordinator);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "updateUpgradeablePIUSWithProductData()", "Ignoring the update of the upgradeable PIU resource due to the wildcard revision is not handled by this U-PIU.\n\ttheCoordinator: " + SuLib.toString(coordinator) + "\n\ttheUpgradeablePlugInUnitPiuTypeMoData: " + piuTypeMoData);
            }
            Transaction.commit(control);
            return true;
        }
        catch (FanMO_HandlerException fanMO_HandlerException) {
            Transaction.rollback(control);
            return false;
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            Transaction.rollback(control);
            return false;
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            Transaction.rollback(control);
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateUpgradeablePIUSWithProductData()", "Throwable caught when trying to update upgradeable resource with PiuType product data.\n\tThrowable data: " + throwable, throwable);
            Transaction.rollback(control);
            return false;
        }
    }

    public void updateUpgradeablePIUsWhereProductNumberIsWildcard() throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateUpgradeablePIUsWhereProductNumberIsWildcard ()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            Collection collection = this.getUpgradeablePlugInUnits();
            Iterator iterator = collection.iterator();
            PiuTypeMoData piuTypeMoData = null;
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            ProductNumberAndRevision productNumberAndRevision = null;
            while (iterator.hasNext()) {
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                if (piuTypeMoData.plugInUnit instanceof PlugInUnitMoSU_Access) {
                    productNumberAndRevision = pIU_MO_HandlerInterface.getPIU_ProductNumberAndRevision((PlugInUnitMoSU_Access)piuTypeMoData.plugInUnit);
                    if (productNumberAndRevision.productNumber == null || !productNumberAndRevision.productNumber.equals("*")) continue;
                    if (pIU_MO_HandlerInterface.isJVM_PIU((PlugInUnitMoSU_Access)piuTypeMoData.plugInUnit) && !pIU_MO_HandlerInterface.isCoreMP((PlugInUnitMoSU_Access)piuTypeMoData.plugInUnit)) {
                        if (!Trace.valid(this.getClass(), 20)) continue;
                        Trace.debug(this.getClass(), 20, "updateUpgradeablePIUsWhereProductNumberIsWildcard ()", "The PIU is a JVM PIU on a non Core MP i.e. the product number shall be a wildcard.");
                        continue;
                    }
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "updateUpgradeablePIUsWhereProductNumberIsWildcard()", "Updating the PlugInUnit resourcetheUpgradeablePlugInUnitPiuTypeMoData: " + piuTypeMoData);
                    }
                    pIU_MO_HandlerInterface.updatePIU_MO_Resource((PiuTypeMoSU_Access)piuTypeMoData.plugInUnit.getPiuType(null), (PlugInUnitMoSU_Access)piuTypeMoData.plugInUnit, false, coordinator);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "updateUpgradeablePIUsWhereProductNumberIsWildcard()", "Ignoring the update of the upgradeable PIU resource due to the wildcard number is not handled by this U-PIU.\n\ttheCoordinator: " + SuLib.toString(coordinator) + "\n\ttheUpgradeablePlugInUnitPiuTypeMoData: " + piuTypeMoData);
            }
            Transaction.commit(control);
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            Transaction.rollback(control);
            throw new UpgradeablePIU_HandlerException(pIU_MO_HandlerException.toString());
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            Transaction.rollback(control);
            throw upgradeablePIU_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateUpgradeablePIUsWhereProductNumberIsWildcard ()", "Throwable caught when trying to update upgradeable resource where product numberis a wildcard and it should not have been that.\n\tThrowable data: " + throwable, throwable);
            Transaction.rollback(control);
            throw new UpgradeablePIU_HandlerException(throwable.toString());
        }
    }

    private void setAdministrativeState(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdministrativeState)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdministrativeState: " + n);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            Trace.flushToTraceFile();
            genericUpgradeablePlugInUnit.setAdministrativeState(n, coordinator);
            control.getTerminator().commit();
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "setAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdministrativeState)", "MoAccessException caught when trying to set the adminsitrative state for an UpgradeablePlugInUnit.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdministrativeState: " + n + "\n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            Transaction.rollback(control);
            throw new UpgradeablePIU_HandlerException("MoAccessException caught when trying to set the adminsitrative state for an UpgradeablePlugInUnit.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdministrativeState: " + n + "\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdministrativeState)", "Exception caught when trying to set the adminsitrative state for an UpgradeablePlugInUnit.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdministrativeState: " + n + "\n\tException data: " + exception.toString(), exception);
            Transaction.rollback(control);
            throw new UpgradeablePIU_HandlerException("Exception caught when trying to set the adminsitrative state for an UpgradeablePlugInUnit.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdministrativeState: " + n + "\n\tException data: " + exception.toString());
        }
    }

    private void waitForPIUsToBeLocked(Vector vector) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForPIUsToBeLocked(Vector aWaitingForPIUsToBeLocked)", "aWaitingForPIUsToBeLocked: " + vector);
        }
        try {
            boolean bl = false;
            int n = 1;
            Vector<GenericUpgradeablePlugInUnit> vector2 = new Vector<GenericUpgradeablePlugInUnit>(vector.size());
            while (!bl) {
                TimeHandler.sleep(1000L);
                Iterator iterator = vector.iterator();
                GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
                while (iterator.hasNext()) {
                    genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                    if (genericUpgradeablePlugInUnit.getAdministrativeState(null) == 0) continue;
                    vector2.addElement(genericUpgradeablePlugInUnit);
                }
                if (!vector2.isEmpty()) {
                    vector.clear();
                    vector = (Vector)vector2.clone();
                    vector2.clear();
                    if (n >= 10) {
                        Trace.info(this.getClass(), "waitForPIUsToBeLocked(Vector aWaitingForPIUsToBeLocked)", "The upgrade logic waits for all faulty-/ non supported- PIUs to be locked before it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector);
                        n = 1;
                        continue;
                    }
                    ++n;
                    continue;
                }
                bl = true;
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "waitForPIUsToBeLocked(Vector aWaitingForPIUsToBeLocked)", "MoAccessException caught when the upgrade logic waits for all faulty-/ non supported- PIUs to be locked\n\tbefore it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector + "\n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            throw new UpgradeablePIU_HandlerException("MoAccessException caught when the upgrade logic waits for all faulty-/ non supported- PIUs to be locked\n\tbefore it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector + "\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "waitForPIUsToBeLocked(Vector aWaitingForPIUsToBeLocked)", "Exception caught when the upgrade logic waits for all faulty-/ non supported- PIUs to be locked\n\tbefore it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector + "\n\tException data: " + exception.toString(), exception);
            throw new UpgradeablePIU_HandlerException("Exception caught when the upgrade logic waits for all faulty-/ non supported- PIUs to be locked\n\tbefore it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector + "\n\tException data: " + exception.toString());
        }
    }

    private void waitForPIUsToBeUnlocked(Vector vector) throws UpgradeablePIU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForPIUsToBeUnlocked(Vector aWaitingForPIUsToBeUnlocked)", "aWaitingForPIUsToBeUnlocked: " + vector);
        }
        try {
            boolean bl = false;
            int n = 1;
            Vector<GenericUpgradeablePlugInUnit> vector2 = new Vector<GenericUpgradeablePlugInUnit>(vector.size());
            while (!bl) {
                TimeHandler.sleep(1000L);
                Iterator iterator = vector.iterator();
                GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
                while (iterator.hasNext()) {
                    genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                    if (genericUpgradeablePlugInUnit.getAdministrativeState(null) == 1) continue;
                    vector2.addElement(genericUpgradeablePlugInUnit);
                }
                if (!vector2.isEmpty()) {
                    vector.clear();
                    vector = (Vector)vector2.clone();
                    vector2.clear();
                    if (n >= 10) {
                        Trace.info(this.getClass(), "waitForPIUsToBeUnlocked(Vector aWaitingForPIUsToBeUnlocked)", "The upgrade logic waits for PIUs to be unlocked (the PIUs that were locked by the upgrade\n\tlogic due to they where faulty or not supported by the upgrade package.\n\tThe PIUs to be unlocked are: " + vector);
                        n = 1;
                        continue;
                    }
                    ++n;
                    continue;
                }
                bl = true;
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "waitForPIUsToBeUnlocked(Vector aWaitingForPIUsToBeUnlocked)", "MoAccessException caught when the upgrade logic waits for all faulty-/ non supported- PIUs to be locked\n\tbefore it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector + "\n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            throw new UpgradeablePIU_HandlerException("MoAccessException caught when the upgrade logic waits for all faulty-/ non supported- PIUs to be locked\n\tbefore it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector + "\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "waitForPIUsToBeUnlocked(Vector aWaitingForPIUsToBeUnlocked)", "Exception caught when the upgrade logic waits for all faulty-/ non supported- PIUs to be locked\n\tbefore it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector + "\n\tException data: " + exception.toString(), exception);
            throw new UpgradeablePIU_HandlerException("Exception caught when the upgrade logic waits for all faulty-/ non supported- PIUs to be locked\n\tbefore it can proceed with the execution of the upgrade.\n\tThe PIUs to be locked are: " + vector + "\n\tException data: " + exception.toString());
        }
    }

    public boolean checkIfPgm(ManagedObject managedObject) {
        if (managedObject instanceof GenericProgramBase) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "checkIfPgm(ManagedObject aChild)  ", "Returning true.");
            }
            return true;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkIfPgm(ManagedObject aChild)  ", "Returning false.");
        }
        return false;
    }

    public boolean checkForPgmUnderUpgradeablePIU(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        MoIterator moIterator;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkForPgmUnderUpgradeablePIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit) ");
        }
        if ((moIterator = genericUpgradeablePlugInUnit.getChildren()) != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                if (this.checkIfPgm(managedObject)) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "checkForPgmUnderUpgradeablePIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit) ", "Program under PIU found.");
                    }
                    return true;
                }
                MoIterator moIterator2 = managedObject.getChildren();
                if (moIterator2 == null) continue;
                while (moIterator2.hasMoreElements()) {
                    ManagedObject managedObject2 = moIterator2.nextMo();
                    if (this.checkIfPgm(managedObject2)) {
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "checkForPgmUnderUpgradeablePIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit) ", "PIU's grandchild is a program.");
                        }
                        return true;
                    }
                    MoIterator moIterator3 = managedObject2.getChildren();
                    if (moIterator3 == null) continue;
                    while (moIterator3.hasMoreElements()) {
                        ManagedObject managedObject3 = moIterator3.nextMo();
                        if (!this.checkIfPgm(managedObject3)) continue;
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "checkForPgmUnderUpgradeablePIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit) ", "PIU's great grandchild is a program.");
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Collection getPiuTypesForAllExistingConfiguredUpgradeablePIUs() throws UpgradeablePIU_HandlerException {
        String string = "getPiuTypesForAllExistingConfiguredUpgradeablePIUs()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        try {
            Collection collection = this.getAllConfiguredUpgradeablePIUs();
            Iterator iterator = collection.iterator();
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            while (iterator.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                if (piuTypeMoSU_Access != null) {
                    linkedList.add(genericUpgradeablePlugInUnit.getPiuType(null));
                    continue;
                }
                Trace.info(this.getClass(), string, "The Upgradeable PIU didn't have any connected PiuType and is therefor ignored.\n\ttheGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - thePiuTypesForAllExistingConfiguredUpgradeablePIUs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new UpgradeablePIU_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public Collection getAllConfiguredUpgradeablePIUs() throws UpgradeablePIU_HandlerException {
        String string = "getAllConfiguredUpgradeablePIUs()";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        try {
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            String[] stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            for (int i = 0; i < stringArray.length; ++i) {
                MoIterator moIterator;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "The upgradeable PIU type name: " + stringArray[i]);
                }
                if ((moIterator = MoRepository.instance().lookupType(stringArray[i])) == null) continue;
                while (moIterator.hasMoreElements()) {
                    ManagedObject managedObject = moIterator.nextMo();
                    if (managedObject instanceof GenericUpgradeablePlugInUnit) {
                        linkedList.add(managedObject);
                        continue;
                    }
                    Trace.info(this.getClass(), string, "The supposed upgradeable PIU was not of type GenericUpgradeablePlugInUnit and is therefor ignored.\n\ttheSupposedUpgradeablePIU: " + managedObject);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theUpgradeablePIUs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new UpgradeablePIU_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }
}

