/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.programhandler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstances;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformation;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformations;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.NotAbleToReadJVM_RPU_DataException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformationData;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformationsContainer;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.TagAndLoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.programhandler.FTC_OaM_PiuTypeLoadModuleRefInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.LoadModuleRefInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.PiuTypeInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.PiuTypeInformations;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramConfigurationException;
import se.ericsson.cello.upgradepackage.util.programhandler.ReconfigureProgramsException;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ProgramCollector {
    private static final String EMPTY_STRING = "";

    public Collection getFtcPiuMos() throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFtcPiuMos()");
        }
        try {
            ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = managedElementMO_HandlerInterface.getFtcMos();
            LinkedList<PlugInUnitMoSU_Access> linkedList = new LinkedList<PlugInUnitMoSU_Access>();
            for (int i = 0; plugInUnitMoSU_AccessArray != null && i < plugInUnitMoSU_AccessArray.length; ++i) {
                linkedList.add(plugInUnitMoSU_AccessArray[i]);
            }
            return linkedList;
        }
        catch (ManagedElementMO_HandlerException managedElementMO_HandlerException) {
            throw new ProgramConfigurationException(managedElementMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getFtcPiuMos()", "Throwable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    public Collection getOaM_PiuMos() throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOaM_PiuMos()");
        }
        try {
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = this.getPiuMosOaM();
            LinkedList<PlugInUnitMoSU_Access> linkedList = new LinkedList<PlugInUnitMoSU_Access>();
            for (int i = 0; plugInUnitMoSU_AccessArray != null && i < plugInUnitMoSU_AccessArray.length; ++i) {
                linkedList.add(plugInUnitMoSU_AccessArray[i]);
            }
            return linkedList;
        }
        catch (SlotMO_HandlerException slotMO_HandlerException) {
            throw new ProgramConfigurationException(slotMO_HandlerException.toString());
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            throw new ProgramConfigurationException(jvmMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getOaM_PiuMos()", "Throwable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    public LinkedList collectFTC_OaM_PiuTypeLoadModuleRefInformatios() throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectFTC_OaM_PiuTypeLoadModuleRefInformatios()");
        }
        try {
            ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = managedElementMO_HandlerInterface.getFtcMos();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray2 = this.getPiuMosOaM();
            return this.collectFTC_OaM_PiuTypeLoadModuleRefInformatios(plugInUnitMoSU_AccessArray, plugInUnitMoSU_AccessArray2);
        }
        catch (ManagedElementMO_HandlerException managedElementMO_HandlerException) {
            throw new ProgramConfigurationException(managedElementMO_HandlerException.toString());
        }
        catch (SlotMO_HandlerException slotMO_HandlerException) {
            throw new ProgramConfigurationException(slotMO_HandlerException.toString());
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            throw new ProgramConfigurationException(jvmMO_HandlerException.toString());
        }
        catch (ProgramConfigurationException programConfigurationException) {
            throw new ProgramConfigurationException(programConfigurationException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectFTC_OaM_PiuTypeLoadModuleRefInformatios()", "Throwable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    public LinkedList collectFTC_OaM_PiuTypeLoadModuleRefInformatios(PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray, PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray2) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectFTC_OaM_PiuTypeLoadModuleRefInformatios()");
        }
        try {
            int n;
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            SlotMoSU_Access[] slotMoSU_AccessArray = slotMO_HandlerInterface.getSlotMos(plugInUnitMoSU_AccessArray);
            SlotMoSU_Access[] slotMoSU_AccessArray2 = slotMO_HandlerInterface.getSlotMos(plugInUnitMoSU_AccessArray2);
            LinkedList linkedList = new LinkedList();
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            for (n = 0; n < slotMoSU_AccessArray.length; ++n) {
                piuTypeMoSU_Access = (PiuTypeMoSU_Access)plugInUnitMoSU_AccessArray[n].getPiuType(null);
                linkedList = this.collectFTC_OaM_PiuTypeLoadModuleRefInformation(slotMoSU_AccessArray[n], piuTypeMoSU_Access, 0, linkedList);
            }
            for (n = 0; n < slotMoSU_AccessArray2.length; ++n) {
                piuTypeMoSU_Access = (PiuTypeMoSU_Access)plugInUnitMoSU_AccessArray2[n].getPiuType(null);
                linkedList = this.collectFTC_OaM_PiuTypeLoadModuleRefInformation(slotMoSU_AccessArray2[n], piuTypeMoSU_Access, 1, linkedList);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "collectFTC_OaM_PiuTypeLoadModuleRefInformatios()", "RETURNS - theFTC_OaM_PiuTypeLoadModuleRefInformations: " + linkedList);
            }
            return linkedList;
        }
        catch (ManagedElementMO_HandlerException managedElementMO_HandlerException) {
            throw new ProgramConfigurationException(managedElementMO_HandlerException.toString());
        }
        catch (SlotMO_HandlerException slotMO_HandlerException) {
            throw new ProgramConfigurationException(slotMO_HandlerException.toString());
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            throw new ProgramConfigurationException(jvmMO_HandlerException.toString());
        }
        catch (ProgramConfigurationException programConfigurationException) {
            throw new ProgramConfigurationException(programConfigurationException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectFTC_OaM_PiuTypeLoadModuleRefInformatios()", "Throwable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private PlugInUnitMoSU_Access[] getPiuMosOaM() throws JvmMO_HandlerException, SlotMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuMosOaM()");
        }
        try {
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = jvmMO_HandlerInterface.getJVM_PIUs();
            return plugInUnitMoSU_AccessArray;
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
            Trace.warning(this.getClass(), "getPiuMosOaM()", "Not able to find out where the OaM (Jvm) MP(s) are located due to no JVM RPU is configured i.e.\n\tno load list information for these MP(s) will be stored together with the CV");
            return new PlugInUnitMoSU_Access[0];
        }
    }

    public LinkedList filterLMsWithHigherLoadClassThan(Collection collection, long l) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterLMsWithHigherLoadClassThan(LinkedList aFTC_OaM_PiuTypeLoadModuleRefInformations, long aLoadClass)", "aFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection + "\n\taLoadClass: " + l);
        }
        try {
            Iterator iterator = collection.iterator();
            FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation = null;
            HashMap hashMap = new HashMap();
            Set set = null;
            Iterator iterator2 = null;
            PiuTypeInformation piuTypeInformation = null;
            LinkedList<FTC_OaM_PiuTypeLoadModuleRefInformation> linkedList = new LinkedList<FTC_OaM_PiuTypeLoadModuleRefInformation>();
            Collection collection2 = null;
            while (iterator.hasNext()) {
                HashMap<PiuTypeInformation, Collection> hashMap2 = new HashMap<PiuTypeInformation, Collection>();
                fTC_OaM_PiuTypeLoadModuleRefInformation = (FTC_OaM_PiuTypeLoadModuleRefInformation)iterator.next();
                hashMap = fTC_OaM_PiuTypeLoadModuleRefInformation.getPiuTypesAndLmRefs();
                set = hashMap.keySet();
                iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    piuTypeInformation = (PiuTypeInformation)iterator2.next();
                    collection2 = this.filterLMsInLoadList((Collection)hashMap.get(piuTypeInformation), l);
                    if (collection2.isEmpty()) continue;
                    hashMap2.put(piuTypeInformation, collection2);
                }
                fTC_OaM_PiuTypeLoadModuleRefInformation.setPiuTypesAndLmrefs(hashMap2);
                linkedList.add(fTC_OaM_PiuTypeLoadModuleRefInformation);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "filterLMsWithHigherLoadClassThan(Collection aFTC_OaM_PiuTypeLoadModuleRefInformations, int aLoadClass)", "aFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection + "\n\taLoadClass: " + l + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    public LinkedList sortLoadLists(Collection collection) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sortLoadLists(Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "aFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation = null;
            HashMap hashMap = new HashMap();
            Set set = null;
            Iterator iterator2 = null;
            PiuTypeInformation piuTypeInformation = null;
            LinkedList<FTC_OaM_PiuTypeLoadModuleRefInformation> linkedList = new LinkedList<FTC_OaM_PiuTypeLoadModuleRefInformation>();
            while (iterator.hasNext()) {
                HashMap hashMap2 = new HashMap();
                fTC_OaM_PiuTypeLoadModuleRefInformation = (FTC_OaM_PiuTypeLoadModuleRefInformation)iterator.next();
                hashMap = fTC_OaM_PiuTypeLoadModuleRefInformation.getPiuTypesAndLmRefs();
                set = hashMap.keySet();
                iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    piuTypeInformation = (PiuTypeInformation)iterator2.next();
                    hashMap2 = this.addPiuTypeLM_RefsToSortedMap(hashMap2, piuTypeInformation, (Collection)hashMap.get(piuTypeInformation));
                }
                fTC_OaM_PiuTypeLoadModuleRefInformation.setPiuTypesAndLmrefs(hashMap2);
                linkedList.add(fTC_OaM_PiuTypeLoadModuleRefInformation);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sortLoadLists(Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "aFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private Collection filterLMsInLoadList(Collection collection, long l) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterLMsInLoadList(Collection aLoadModuleRefInformations, long aLoadClass)", "aLoadModuleRefInformations: " + collection + "\n\taLoadClass: " + l);
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleRefInformation loadModuleRefInformation = null;
            LinkedList<LoadModuleRefInformation> linkedList = new LinkedList<LoadModuleRefInformation>();
            while (iterator.hasNext()) {
                loadModuleRefInformation = (LoadModuleRefInformation)iterator.next();
                if ((long)loadModuleRefInformation.getLoadClass() > l) continue;
                linkedList.add(loadModuleRefInformation);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "filterLMsInLoadList(Collection aLoadModuleRefInformations, long aLoadClass)", "RETURNS - theLoadModuleRefInformations: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "filterLMsInLoadList(Collection aLoadModuleRefInformations, long aLoadClass)", "aLoadModuleRefInformations: " + collection + "\n\taLoadClass: " + l + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private HashMap addPiuTypeLM_RefsToSortedMap(HashMap hashMap, PiuTypeInformation piuTypeInformation, Collection collection) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addPiuTypeLM_RefsToSortedMap(HashMap aSortedPiuTypesAndLmRefs, PiuTypeInformation aNewPiuTypeInformation, Collection aNewLmRefs)", "aSortedPiuTypesAndLmRefs: " + hashMap + "\n\taNewPiuTypeInformation: " + piuTypeInformation + "\n\taNewLmRefs: " + collection);
        }
        try {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            Collection collection2 = null;
            PiuTypeInformations piuTypeInformations = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                piuTypeInformations = (PiuTypeInformations)iterator.next();
                collection2 = (Collection)hashMap.get(piuTypeInformations);
                if (!this.isLmRefsEquals(collection2, collection)) continue;
                if (!piuTypeInformation.isPiuTypeInUse()) {
                    piuTypeInformations.add(piuTypeInformation);
                }
                bl = true;
                break;
            }
            if (!bl && !piuTypeInformation.isPiuTypeInUse()) {
                PiuTypeInformations piuTypeInformations2 = new PiuTypeInformations();
                piuTypeInformations2.add(piuTypeInformation);
                hashMap.put(piuTypeInformations2, collection);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 20, "addPiuTypeLM_RefsToSortedMap(HashMap aSortedPiuTypesAndLmRefs, PiuTypeInformation aNewPiuTypeInformation, Collection aNewLmRefs)", "RETURNS - aSortedPiuTypesAndLmRefs: " + hashMap);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addPiuTypeLM_RefsToSortedMap(HashMap aSortedPiuTypesAndLmRefs, PiuTypeInformation aPiuTypeInformation, Collection aPiuTypesAndLmRefs)", "aSortedPiuTypesAndLmRefs: " + hashMap + "\n\taNewPiuTypeInformation: " + piuTypeInformation + "\n\taNewLmRefs: " + collection + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private boolean isLmRefsEquals(Collection collection, Collection collection2) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isLmRefsEquals (Collection theExistingLmRefs, Collection aNewLmRefs)", "anExistingLmRefs: " + collection + "\n\taNewLmRefs: " + collection2);
        }
        try {
            if (collection == null || collection.size() != collection2.size()) {
                return false;
            }
            Iterator iterator = collection2.iterator();
            LoadModuleRefInformation loadModuleRefInformation = null;
            boolean bl = true;
            while (iterator.hasNext()) {
                loadModuleRefInformation = (LoadModuleRefInformation)iterator.next();
                if (this.contains(loadModuleRefInformation, collection)) continue;
                bl = false;
                break;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 20, "RETURNS - theIsEqual: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isLmRefsEquals (Collection theExistingLmRefs, Collection aNewLmRefs)", "anExistingLmRefs: " + collection + "\n\taNewLmRefs: " + collection2 + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private boolean contains(LoadModuleRefInformation loadModuleRefInformation, Collection collection) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "contains(LoadModuleRefInformation aNewLoadModuleRefInformation, Collection anExistingLmRefs)", "aNewLoadModuleRefInformation: " + loadModuleRefInformation + "\n\tanExistingLmRefs: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleRefInformation loadModuleRefInformation2 = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                loadModuleRefInformation2 = (LoadModuleRefInformation)iterator.next();
                if (!loadModuleRefInformation2.toStringRawExceptProgInst().equals(loadModuleRefInformation.toStringRawExceptProgInst()) || !loadModuleRefInformation2.getProgramInstances().equals(loadModuleRefInformation.getProgramInstances())) continue;
                bl = true;
                break;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "contains(LoadModuleRefInformation aNewLoadModuleRefInformation, Collection anExistingLmRefs)", "RETURNS - theIsContains: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "contains(LoadModuleRefInformation aNewLoadModuleRefInformation, Collection anExistingLmRefs", "aNewLoadModuleRefInformation: " + loadModuleRefInformation + "\n\tanExistingLmRefs: " + collection + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private LinkedList collectFTC_OaM_PiuTypeLoadModuleRefInformation(SlotMoSU_Access slotMoSU_Access, PiuTypeMoSU_Access piuTypeMoSU_Access, int n, LinkedList linkedList) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectFTC_OaM_PiuTypeLoadModuleRefInformation(SlotMoSU_Access aSlotMo, PiuTypeMoSU_Access anUsedPiuTypeMo, int aFTC_OaM_Role, LinkedList aFTC_OaM_PiuTypeLoadModuleRefInformations)", "aSlotMo: " + slotMoSU_Access + "\n\tanUsedPiuTypeMo: " + piuTypeMoSU_Access + "\n\taFTC_OaM_Role: " + n + "\n\taFTC_OaM_PiuTypeLoadModuleRefInformations: " + linkedList);
        }
        try {
            Collection collection = new HashSet();
            SubrackMO_HandlerInterface subrackMO_HandlerInterface = ServiceFinder.getSubrackMO_HandlerInterface();
            Collection collection2 = null;
            FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation = null;
            collection = this.getRepertoireMosConnectedTo(slotMoSU_Access);
            int n2 = subrackMO_HandlerInterface.getSMN(slotMoSU_Access);
            int n3 = slotMoSU_Access.getAsciPortNumber(null);
            if (this.isSmnSlotUnique(n2, n3, linkedList)) {
                FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation2 = this.getMatchingFTC_OaM_PiuTypeLoadModuleRefInformation(collection, linkedList);
                if (fTC_OaM_PiuTypeLoadModuleRefInformation2 == null) {
                    fTC_OaM_PiuTypeLoadModuleRefInformation = new FTC_OaM_PiuTypeLoadModuleRefInformation(n, n2, n3, collection);
                    RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
                    collection2 = repertoireMO_HandlerInterface.getPiuTypeMosMP(collection);
                    Iterator iterator = collection2.iterator();
                    PiuTypeMoSU_Access piuTypeMoSU_Access2 = null;
                    Collection collection3 = null;
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        piuTypeMoSU_Access2 = (PiuTypeMoSU_Access)iterator.next();
                        collection3 = this.getLoadModuleRefs(piuTypeMoSU_Access2, collection);
                        bl = piuTypeMoSU_Access == piuTypeMoSU_Access2;
                        if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                            fTC_OaM_PiuTypeLoadModuleRefInformation.addPiuTypeAndItsLmRefs(new PiuTypeInformation(piuTypeMoSU_Access2, piuTypeMoSU_Access2.getProductNumberOpt(null), piuTypeMoSU_Access2.getProductRevisionOpt(null), piuTypeMoSU_Access2.getRole(null), bl), collection3);
                            continue;
                        }
                        fTC_OaM_PiuTypeLoadModuleRefInformation.addPiuTypeAndItsLmRefs(new PiuTypeInformation(piuTypeMoSU_Access2, StringHandler.optimize(piuTypeMoSU_Access2.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access2.getProductRevision(null)), piuTypeMoSU_Access2.getRole(null), bl), collection3);
                    }
                    linkedList.add(fTC_OaM_PiuTypeLoadModuleRefInformation);
                } else {
                    fTC_OaM_PiuTypeLoadModuleRefInformation = new FTC_OaM_PiuTypeLoadModuleRefInformation(n, n2, n3, collection);
                    fTC_OaM_PiuTypeLoadModuleRefInformation.setPiuTypesAndLmrefs(fTC_OaM_PiuTypeLoadModuleRefInformation2.getPiuTypesAndLmRefs(), piuTypeMoSU_Access);
                    linkedList.add(fTC_OaM_PiuTypeLoadModuleRefInformation);
                }
            }
            return linkedList;
        }
        catch (ManagedElementMO_HandlerException managedElementMO_HandlerException) {
            throw new ProgramConfigurationException(managedElementMO_HandlerException.toString());
        }
        catch (SlotMO_HandlerException slotMO_HandlerException) {
            throw new ProgramConfigurationException(slotMO_HandlerException.toString());
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            throw new ProgramConfigurationException(jvmMO_HandlerException.toString());
        }
        catch (ProgramConfigurationException programConfigurationException) {
            throw new ProgramConfigurationException(programConfigurationException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectFTC_OaM_PiuTypeLoadModuleRefInformation(SlotMoSU_Access aSlotMo, PiuTypeMoSU_Access anUsedPiuTypeMo, int aFTC_OaM_Role, Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "aSlotMo: " + slotMoSU_Access + "\n\tanUsedPiuTypeMo: " + piuTypeMoSU_Access + "\n\taFTC_OaM_Role: " + n + "\n\taFTC_OaM_PiuTypeLoadModuleRefInformations: " + linkedList + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private boolean isSmnSlotUnique(int n, int n2, Collection collection) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSmnSlotUnique(int aSmn, int anApn, Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "aSmn: " + n + "\n\tanApn: " + n2 + "\n\taFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation = null;
            boolean bl = true;
            while (iterator.hasNext()) {
                fTC_OaM_PiuTypeLoadModuleRefInformation = (FTC_OaM_PiuTypeLoadModuleRefInformation)iterator.next();
                if (fTC_OaM_PiuTypeLoadModuleRefInformation.getSmn() != n || fTC_OaM_PiuTypeLoadModuleRefInformation.getApn() != n2) continue;
                bl = false;
                break;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSmnSlotUnique(int aSmn, int anApn, Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "aSmn: " + n + "\n\tanApn: " + n2 + "\n\taFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private FTC_OaM_PiuTypeLoadModuleRefInformation getMatchingFTC_OaM_PiuTypeLoadModuleRefInformation(Collection collection, Collection collection2) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMatchingFTC_OaM_PiuTypeLoadModuleRefInformation(Collection aRepertoireMos, aFTC_OaM_PiuTypeLoadModuleRefInformations)", "Collection aRepertoireMos: " + collection + "\n\taFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection2);
        }
        try {
            Iterator iterator = collection2.iterator();
            FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation = null;
            while (iterator.hasNext() && !(fTC_OaM_PiuTypeLoadModuleRefInformation = (FTC_OaM_PiuTypeLoadModuleRefInformation)iterator.next()).equalsRepertoireMos(collection)) {
                fTC_OaM_PiuTypeLoadModuleRefInformation = null;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getMatchingFTC_OaM_PiuTypeLoadModuleRefInformation(Collection aRepertoireMos, aFTC_OaM_PiuTypeLoadModuleRefInformations)", "RETURNS - theFTC_OaM_PiuTypeLoadModuleRefInformation: " + fTC_OaM_PiuTypeLoadModuleRefInformation);
            }
            return fTC_OaM_PiuTypeLoadModuleRefInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getMatchingFTC_OaM_PiuTypeLoadModuleRefInformation(Collection aRepertoireMos, aFTC_OaM_PiuTypeLoadModuleRefInformations)", "Collection aRepertoireMos: " + collection + "\n\taFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection2 + "\n\tThrowable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private Collection filterLM_Refs(TagAndLoadModuleInformation tagAndLoadModuleInformation, ProgramConfigurationInformations programConfigurationInformations) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterLM_Refs(TagAndLoadModuleInformation aPiuTypeTagAndLoadModuleInformation, ProgramConfigurationInformations aPiuTypeProgramConfigurations)", "aPiuTypeTagAndLoadModuleInformation: " + tagAndLoadModuleInformation + "\n\taPiuTypeProgramConfigurations: " + programConfigurationInformations);
        }
        try {
            int n = this.getTagWhereSubparentLdnIsEmptyString(programConfigurationInformations);
            HashSet<LoadModuleRefInformation> hashSet = new HashSet<LoadModuleRefInformation>();
            if (tagAndLoadModuleInformation.getTags().hasNext()) {
                LoadModuleInformationData loadModuleInformationData = tagAndLoadModuleInformation.getLoadModuleInformationData(new Integer(n));
                if (loadModuleInformationData == null) {
                    return hashSet;
                }
                Collection collection = loadModuleInformationData.getLoadModuleInformationsContainers();
                Collection collection2 = this.convertToLoadModuleInformations(collection);
                Iterator iterator = collection2.iterator();
                LoadModuleInformation loadModuleInformation = null;
                LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                int n2 = -1;
                int n3 = -1;
                String string = EMPTY_STRING;
                String string2 = EMPTY_STRING;
                int n4 = -1;
                int n5 = -1;
                ProgramInstances programInstances = null;
                while (iterator.hasNext()) {
                    loadModuleInformation = (LoadModuleInformation)iterator.next();
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "filterLM_Refs(TagAndLoadModuleInformation aPiuTypeTagAndLoadModuleInformation, ProgramConfigurationInformations aPiuTypeProgramConfigurations)", "theLoadModuleInformation: " + loadModuleInformation);
                    }
                    loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModuleMo(loadModuleInformation.getLDN());
                    if (loadModuleInformation.getLoaderType().equals(EMPTY_STRING)) {
                        n3 = loadModuleMoSU_Access.getLoaderType(null);
                        string = loadModuleMoSU_Access.getDeviceLoaderName(null);
                        string2 = loadModuleMoSU_Access.getDeviceLoaderInformation(null);
                    } else {
                        n3 = loadModuleInformation.getLoaderTypeAsInt();
                        string = loadModuleInformation.getDeviceLoaderName();
                        string2 = loadModuleInformation.getDeviceLoaderInformation();
                    }
                    if (n3 != 0 && n3 != 6) continue;
                    n2 = loadModuleMoSU_Access.getOseProgramLoadClass(null);
                    n4 = loadModuleInformation.getHeapSize() == null || loadModuleInformation.getHeapSize().equals(EMPTY_STRING) ? loadModuleMoSU_Access.getOseProgramHeapSize(null) : loadModuleInformation.getHeapSizeAsInt();
                    n5 = loadModuleInformation.getPoolSize() == null || loadModuleInformation.getPoolSize().equals(EMPTY_STRING) ? loadModuleMoSU_Access.getOseProgramPoolSize(null) : loadModuleInformation.getPoolSizeAsInt();
                    programInstances = loadModuleInformation.getProgramInstances() == null ? new ProgramInstances(EMPTY_STRING) : new ProgramInstances(loadModuleInformation.getProgramInstances());
                    String string3 = null;
                    String string4 = null;
                    if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                        string3 = loadModuleMoSU_Access.getProductNumberOpt(null);
                        string4 = loadModuleMoSU_Access.getProductRevisionOpt(null);
                    } else {
                        string3 = StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null));
                        string4 = StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null));
                    }
                    hashSet.add(new LoadModuleRefInformation(string3, string4, loadModuleMoSU_Access.getProductName(null), loadModuleMoSU_Access.getProductionDate(null), n3, string, string2, loadModuleMoSU_Access.getLoadModuleFilePath(null), n2, n4, n5, programInstances));
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "filterLM_Refs(TagAndLoadModuleInformation aPiuTypeTagAndLoadModuleInformation)", "RETURNS - theValidLoadModuleInformations: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "filterLM_Refs(TagAndLoadModuleInformation aPiuTypeTagAndLoadModuleInformation, ProgramConfigurationInformations aPiuTypeProgramConfigurations)\n\taPiuTypeTagAndLoadModuleInformation: " + tagAndLoadModuleInformation + "\n\taPiuTypeProgramConfigurations: " + programConfigurationInformations, "Throwable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    public int getTagWhereSubparentLdnIsEmptyString(ProgramConfigurationInformations programConfigurationInformations) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getTagWhereSubparentLdnIsEmptyString(ProgramConfigurationInformations aProgramConfigurationInformations)", "aProgramConfigurationInformations: " + programConfigurationInformations);
        }
        Iterator iterator = programConfigurationInformations.iterator();
        ProgramConfigurationInformation programConfigurationInformation = null;
        int n = -1;
        while (iterator.hasNext()) {
            programConfigurationInformation = (ProgramConfigurationInformation)iterator.next();
            if (programConfigurationInformation.getSubparentLDN() != null && !programConfigurationInformation.getSubparentLDN().equals(EMPTY_STRING)) continue;
            n = programConfigurationInformation.getTag();
            break;
        }
        return n;
    }

    private Collection convertToLoadModuleInformations(Collection collection) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "convertToLoadModuleInformations(Collection aLoadModuleInformationContainers)", "aLoadModuleInformationContainers: " + collection);
        }
        try {
            HashSet<LoadModuleInformation> hashSet = new HashSet<LoadModuleInformation>();
            LoadModuleInformationsContainer loadModuleInformationsContainer = null;
            Iterator iterator = collection.iterator();
            Iterator iterator2 = null;
            while (iterator.hasNext()) {
                loadModuleInformationsContainer = (LoadModuleInformationsContainer)iterator.next();
                if (loadModuleInformationsContainer.containsOnlyOneLoadModuleInformation()) {
                    hashSet.add(loadModuleInformationsContainer.getFirstLoadModuleInformation());
                    continue;
                }
                iterator2 = loadModuleInformationsContainer.getAllLoadModuleInformationIter();
                while (iterator2.hasNext()) {
                    hashSet.add((LoadModuleInformation)iterator2.next());
                }
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "convertToLoadModuleInformations(Collection aLoadModuleInformationContainers)\n\taLoadModuleInformationContainers: " + collection, "Throwable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private Collection getRepertoireMosConnectedTo(SlotMoSU_Access slotMoSU_Access) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireMosConnectedTo(SlotMoSU_Access aSlotMo)", "aSlotMo: " + slotMoSU_Access);
        }
        try {
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            SwAllocationMoSU_Access[] swAllocationMoSU_AccessArray = slotMO_HandlerInterface.getConnectedSwAllocations(slotMoSU_Access);
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
            HashSet hashSet = new HashSet();
            for (int i = 0; i < swAllocationMoSU_AccessArray.length; ++i) {
                hashSet.addAll(swAllocationMO_HandlerInterface.getRepertoiresMosConnectedToSwAllocation(swAllocationMoSU_AccessArray[i]));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getRepertoireMosConnectedTo(SlotMoSU_Access aSlotMo)", "RETURNS - theRepertoireMos: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoireMosConnectedTo(SlotMoSU_Access aSlotMo)\n\taSlotMo: " + slotMoSU_Access, "Throwable caught", throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private Collection getLoadModuleRefs(PiuTypeMoSU_Access piuTypeMoSU_Access, Collection collection) throws ReconfigureProgramsException {
        String string = "getLoadModuleRefs(PiuTypeMoSU_Access aPiuTypeMo, Collection aRepertoireMOs)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aPiuTypeMo: " + piuTypeMoSU_Access + "\n\taRepertoireMOs: " + collection);
        }
        try {
            ProgramConfigurationInformations programConfigurationInformations = ServiceFinder.getPiuTypeMO_HandlerInterface().getProgramConfigurations(piuTypeMoSU_Access, null);
            if (programConfigurationInformations.isEmpty()) {
                return new HashSet();
            }
            RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
            TagAndLoadModuleInformation tagAndLoadModuleInformation = repertoireMO_HandlerInterface.getLoadModuleInformations(collection, piuTypeMoSU_Access, programConfigurationInformations.getTagsAsStrings());
            Collection collection2 = this.filterLM_Refs(tagAndLoadModuleInformation, programConfigurationInformations);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theLoadModuleInformations: " + collection2);
            }
            return collection2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taRepertoireMOs: " + collection + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tOrigin Exception:" + throwable, throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }
}

