/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.programhandler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.ProgramHeapAndPoolSizeInterfaceBase;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.ProgramMoFactorySU_Access;
import se.ericsson.cello.equipment.suaccess.ProgramMoSU_Access;
import se.ericsson.cello.equipment.suaccess.ProgramMoSU_Access1;
import se.ericsson.cello.equipment.suaccess.StartOpState;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.IdGenerator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInformationForConfiguredUpgradeablePIU;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstanceException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstances;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.util.datacontainer.LoadModuleHeapAndPoolSizeContainer;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformation;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformations;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.TagGenericMoFactory;
import se.ericsson.cello.upgradepackage.main.interfaces.TagGenericProgram;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.enumer.LoadModuleInstalledState;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformationData;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformationsContainer;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.TagAndLoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.UnexpectedLoaderTypeValueException;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.programhandler.CreateProgramException;
import se.ericsson.cello.upgradepackage.util.programhandler.EnableExistingProgramException;
import se.ericsson.cello.upgradepackage.util.programhandler.ExistingProgram;
import se.ericsson.cello.upgradepackage.util.programhandler.ExistingPrograms;
import se.ericsson.cello.upgradepackage.util.programhandler.ExistingProgramsInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.HeapPoolSettingsException;
import se.ericsson.cello.upgradepackage.util.programhandler.LoaderTypeInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramConfigurationException;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramHandlerInterface;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.programhandler.ReconfigureProgramsException;
import se.ericsson.cello.upgradepackage.util.programhandler.RestartCounterLimitAndRestartTimerContainer;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class ProgramHandler
implements ProgramHandlerInterface {
    private static final int RETRY_TWICE = 2;
    private GenericUpgradeablePlugInUnit myUpgradeablePlugInUnit = null;

    public ProgramHandler(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ProgramMO_Handler (GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        this.myUpgradeablePlugInUnit = genericUpgradeablePlugInUnit;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconfigurePrograms(Coordinator var1_1) throws MO_HandlerException {
        block26: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            if (Trace.valid(this.getClass(), 20)) {
                                Trace.debug(this.getClass(), 20, "reconfigurePrograms(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(var1_1));
                            }
                            var2_2 = null;
                            var3_3 = var1_1;
                            try {
                                try {
                                    var4_4 = new ProgramInformationForConfiguredUpgradeablePIU(this, (ManagedObject)this.myUpgradeablePlugInUnit);
                                    var5_7 = (PiuTypeMoSU_Access)this.myUpgradeablePlugInUnit.getPiuType(var3_3);
                                    if (var5_7 == null) {
                                        Trace.warning(this.getClass(), "reconfigurePrograms(Coordinator aCoordinator)", "Reconfiguration of programs aborted since no PiuType MO was found.\n\tmyUpgradeablePlugInUnit: " + this.myUpgradeablePlugInUnit);
                                        var4_4.updateFinished();
                                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PiuUpgradeInformation, var4_4);
                                        var12_8 = null;
                                        if (var2_2 == null) return;
                                        break block22;
                                    }
                                    var6_20 = ServiceFinder.getPiuTypeMO_HandlerInterface().getProgramConfigurations(var5_7, var3_3);
                                    if (var6_20.isEmpty()) {
                                        if (Trace.valid(this.getClass(), 22)) {
                                            Trace.debug(this.getClass(), 22, "reconfigurePrograms(Coordinator aCoordinator)", "No program configurations definition found in the PiuType referenced by the U-PIU.\n\tmyUpgradeablePlugInUnit: " + this.myUpgradeablePlugInUnit + "\n\tthePiuType: " + var5_7 + "\n\tthePiuTypeProgramConfigurations: " + var6_20);
                                        }
                                        break block23;
                                    }
                                    if (var3_3 == null) {
                                        var2_2 = Transaction.create();
                                        var3_3 = Transaction.getCoordinator(var2_2);
                                    }
                                    var7_21 = this.getExistingPrograms(var6_20, var4_4, var3_3);
                                    var4_4 = var7_21.getProgramInformationForConfiguredUpgradeablePIU();
                                    if (!var5_7.getIsInstalled(var3_3)) {
                                        Trace.info(this.getClass(), "reconfigurePrograms(Coordinator aCoordinator)", "Programs for PIU '" + this.myUpgradeablePlugInUnit + "'\n\thas been disabled. No re-configuration of programs is executed since this U-PIU is not supported by the Upgrade Package.");
                                        this.disableRemainingPrograms(var7_21, var4_4, var3_3);
                                        var4_4.updateFinished();
                                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PiuUpgradeInformation, var4_4);
                                        break block24;
                                    }
                                    var8_22 = ServiceFinder.getPiuTypeMO_HandlerInterface();
                                    if (var8_22.getLoadModuleInstalledState(var5_7, var1_1) != LoadModuleInstalledState.Installed && Trace.valid(this.getClass(), 22)) {
                                        Trace.debug(this.getClass(), 22, "reconfigurePrograms(Coordinator aCoordinator)", "Assuming that PiuType MO (" + var5_7 + ")" + "\n\tassociated to PIU MO (" + this.myUpgradeablePlugInUnit + ") is completely installed.");
                                    }
                                    if ((var8_22 = this.getConnectedSwAllocation(this.myUpgradeablePlugInUnit, var3_3)) == null) {
                                        this.disableRemainingPrograms(var7_21, var4_4, var3_3);
                                        Trace.info(this.getClass(), "reconfigurePrograms(Coordinator aCoordinator)", "During reconfiguration of programs, no active SwAllocation found for PlugInUnit: " + this.myUpgradeablePlugInUnit + "\n\tProgram configuration and PiuType information:" + "\n\tProgram configuration in PiuType: " + var6_20 + "\n\tthePiuType: " + var5_7);
                                        var4_4.updateFinished();
                                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PiuUpgradeInformation, var4_4);
                                        break block25;
                                    }
                                    var9_23 = null;
                                    var9_23 = this.getConnectedRepertoires((SwAllocationMoSU_Access)var8_22, var3_3);
                                    var10_24 = this.getLoadModulesDefinedInRepertoires(var9_23, var5_7, var6_20, var3_3);
                                    var4_4 = this.createOrEnableRequiredPrograms(var10_24, var6_20, var7_21, var4_4, var3_3);
                                    this.disableRemainingPrograms(var7_21, var4_4, var3_3);
                                    var4_4.updateFinished();
                                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PiuUpgradeInformation, var4_4);
                                    if (Trace.valid(this.getClass(), 40)) {
                                        this.logReconfigurationProperties(var4_4);
                                    }
                                    break block26;
                                }
                                catch (ProgramMO_HandlerException var4_5) {
                                    if (var2_2 == null) throw var4_5;
                                    Transaction.rollback(var2_2);
                                    var2_2 = null;
                                    throw var4_5;
                                }
                                catch (Throwable var4_6) {
                                    Trace.error(this.getClass(), "reconfigurePrograms(Coordinator aCoordinator)", "Throwable caught.\n\tmyUpgradeablePlugInUnit: " + this.myUpgradeablePlugInUnit + "\n\taCoordinator: " + SuLib.toString(var1_1) + "\n\tused Coordinator: " + SuLib.toString(var3_3) + "\n\tOrigin Throwable:" + var4_6, var4_6);
                                    if (var2_2 == null) throw new ReconfigureProgramsException(var4_6.toString());
                                    Transaction.rollback(var2_2);
                                    var2_2 = null;
                                    throw new ReconfigureProgramsException(var4_6.toString());
                                }
                            }
                            catch (Throwable var11_25) {
                                var12_13 = null;
                                if (var2_2 == null) throw var11_25;
                                try {
                                    Transaction.commit(var2_2);
                                    throw var11_25;
                                }
                                catch (Throwable var13_19) {
                                    // empty catch block
                                }
                                throw var11_25;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [16 : 731->738)] { 
lbl78:
                        // 1 sources

                        Transaction.commit(var2_2);
                        return;
lbl80:
                        // 1 sources

                        catch (Throwable var13_14) {
                            // empty catch block
                        }
                        return;
                    }
                    var12_9 = null;
                    if (var2_2 == null) return;
                    ** try [egrp 2[TRYBLOCK] [16 : 731->738)] { 
lbl87:
                    // 1 sources

                    Transaction.commit(var2_2);
                    return;
lbl89:
                    // 1 sources

                    catch (Throwable var13_15) {
                        // empty catch block
                    }
                    return;
                }
                var12_10 = null;
                if (var2_2 == null) return;
                ** try [egrp 2[TRYBLOCK] [16 : 731->738)] { 
lbl96:
                // 1 sources

                Transaction.commit(var2_2);
                return;
lbl98:
                // 1 sources

                catch (Throwable var13_16) {
                    // empty catch block
                }
                return;
            }
            var12_11 = null;
            if (var2_2 == null) return;
            ** try [egrp 2[TRYBLOCK] [16 : 731->738)] { 
lbl105:
            // 1 sources

            Transaction.commit(var2_2);
            return;
lbl107:
            // 1 sources

            catch (Throwable var13_17) {
                // empty catch block
            }
            return;
        }
        var12_12 = null;
        if (var2_2 == null) return;
        try {}
        catch (Throwable var13_18) {}
        Transaction.commit(var2_2);
        return;
    }

    private void disableRemainingPrograms(ExistingPrograms existingPrograms, ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "disableRemainingPrograms(ExistingPrograms anExistingPrograms, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "anExistingPrograms: " + existingPrograms + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Iterator iterator = existingPrograms.getAllExistingProgramsIterator();
            ProgramInformation programInformation = null;
            while (iterator.hasNext()) {
                programInformation = (ProgramInformation)iterator.next();
                if (programInformation.getStartState() == 0) continue;
                if (!programInformation.isUpgradePersistent()) {
                    this.setStartState(programInformation.getProgram(), 0, coordinator, 2);
                    programInformationForConfiguredUpgradeablePIU.incrementSetStartStateToDisabledCounter();
                    continue;
                }
                programInformationForConfiguredUpgradeablePIU.incrementUpgradePersistentCounter();
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "disableRemainingPrograms(ExistingPrograms anExistingPrograms, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "anExistingPrograms: " + existingPrograms + "\n\tThrowable caught", throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    private void logReconfigurationProperties(ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU) {
        Trace.log1(this.getClass(), "logReconfigurationProperties(ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU)", "U-PIU: " + programInformationForConfiguredUpgradeablePIU.getUpgradeablePIU() + ", Deleted: " + programInformationForConfiguredUpgradeablePIU.getDeletedProgramsCounter() + ", Created: " + programInformationForConfiguredUpgradeablePIU.getCreatedProgramsCounter() + ", Reused: " + programInformationForConfiguredUpgradeablePIU.getReusedProgramsCounter() + ", Disabled: " + programInformationForConfiguredUpgradeablePIU.getSetStartStateToDisabledCounter() + ", Enabled: " + programInformationForConfiguredUpgradeablePIU.getSetStartStateToEnabledCounter() + ", UpgradePersistent: " + programInformationForConfiguredUpgradeablePIU.getUpgradePersistentCounter() + ", anyProgramPresent: " + programInformationForConfiguredUpgradeablePIU.isAnyProgramPresentInToVersion() + ", restartExecuted: " + programInformationForConfiguredUpgradeablePIU.isRestartExecuted() + ", restartRequired: " + programInformationForConfiguredUpgradeablePIU.isRestartRequired());
    }

    private Collection getConnectedRepertoires(SwAllocationMoSU_Access swAllocationMoSU_Access, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedRepertoires(SwAllocationMoSU_Access anSwAllocationMoSU_Access, Coordinator aCoordinator)", "anSwAllocationMoSU_Access: " + swAllocationMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
            return swAllocationMO_HandlerInterface.getRepertoiresReferencedBySwAllocation(swAllocationMoSU_Access);
        }
        catch (SwAllocationMO_HandlerException swAllocationMO_HandlerException) {
            throw new ProgramMO_HandlerException(swAllocationMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getConnectedRepertoires(SwAllocationMoSU_Access anSwAllocationMoSU_Access, Coordinator aCoordinator)", "Throwable caught\n\tanSwAllocationMoSU_Access: " + swAllocationMoSU_Access, throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    private SwAllocationMoSU_Access getConnectedSwAllocation(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedSwAllocation(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            SwAllocationMoSU_Access swAllocationMoSU_Access = upgradeablePIU_HandlerInterface.getActiveSwAllocationMo(genericUpgradeablePlugInUnit, coordinator);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getConnectedSwAllocation(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator)", "RETURNS - theSwAllocationMo: " + swAllocationMoSU_Access);
            }
            return swAllocationMoSU_Access;
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            throw new ProgramMO_HandlerException(upgradeablePIU_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getConnectedSwAllocation(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator)", "Throwable caught", throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    public void removeDisabledPrograms(Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeDisabledPrograms(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Struct[] structArray;
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)this.myUpgradeablePlugInUnit.getPiuType(coordinator);
            if (piuTypeMoSU_Access == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "removeDisabledPrograms(Coordinator aCoordinator)", "No PiuType for piu " + this.myUpgradeablePlugInUnit);
                }
                return;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "removeDisabledPrograms(Coordinator aCoordinator)", "The PIU's Piutype: " + piuTypeMoSU_Access);
            }
            if ((structArray = piuTypeMoSU_Access.getProgramConfiguration(coordinator)) == null) {
                Trace.warning(this.getClass(), "removeDisabledPrograms(Coordinator aCoordinator)", "For PlugInUnit: " + this.myUpgradeablePlugInUnit + ", No Program Configuration for piuType: " + piuTypeMoSU_Access + ".");
                return;
            }
            UpgradePackageMoExtended upgradePackageMoExtended = this.getExecutingUpgradePackageMO();
            HashSet<GenericProgramBase> hashSet = new HashSet<GenericProgramBase>();
            GenericProgramBase genericProgramBase = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            for (int i = 0; i < structArray.length; ++i) {
                string = (String)structArray[i].getValue("tag");
                string2 = (String)structArray[i].getValue("programMoTypeName");
                string3 = (String)structArray[i].getValue("subParentLDN");
                string4 = "".equalsIgnoreCase(string3) ? this.myUpgradeablePlugInUnit.getLocalDistinguishedName() : this.myUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string3;
                ManagedObject managedObject = MoRepository.instance().lookup(string4);
                if (managedObject != null) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "removeDisabledPrograms(Coordinator aCoordinator)", "Removing Disabled Programs for:\n\ttheTag: " + string + "\n\tthe Parent Mo: " + managedObject + "\n\tThe MO Type: " + string2);
                    }
                    MoIterator moIterator = MoRepository.instance().select(managedObject, 1, (MoFilter)new MoTypeFilter(string2));
                    int n = 0;
                    if (moIterator == null) continue;
                    StartOpState startOpState = null;
                    while (moIterator.hasMoreElements()) {
                        genericProgramBase = (GenericProgramBase)moIterator.nextMo();
                        try {
                            if (hashSet.add(genericProgramBase)) {
                                if (genericProgramBase instanceof ProgramMoSU_Access && SU_AccessVersionHandler.getInstance().isSupported("SU_2", (Object)genericProgramBase)) {
                                    startOpState = this.getStartOpStateWithDelay((ProgramMoSU_Access)genericProgramBase, coordinator);
                                    this.checkProgramRunsAsConfigured(startOpState.getOperationalState(), startOpState.getStartState(), (ProgramMoSU_Access)genericProgramBase);
                                    if (startOpState.getStartState() != 0) continue;
                                    this.deleteProgram(genericProgramBase, upgradePackageMoExtended, coordinator);
                                    continue;
                                }
                                n = this.getStartStateWithDelay(genericProgramBase, coordinator);
                                this.checkProgramRunsAsConfigured(genericProgramBase, n, coordinator);
                                if (n != 0) continue;
                                this.deleteProgram(genericProgramBase, upgradePackageMoExtended, coordinator);
                                continue;
                            }
                            if (!Trace.valid(this.getClass(), 22)) continue;
                            Trace.debug(this.getClass(), 22, "removeDisabledPrograms(Coordinator aCoordinator)", "The program has already been checked whether it is going to be deleted or not.\n\ttheExistingProgram: " + genericProgramBase);
                        }
                        catch (Throwable throwable) {
                            Trace.error(this.getClass(), "removeDisabledPrograms(Coordinator aCoordinator)", "Throwable - Program delete failed: " + genericProgramBase + "\n\t" + this.getGenericProgramLoadModuleData(genericProgramBase), throwable);
                            throw new ProgramMO_HandlerException(throwable.toString());
                        }
                    }
                    continue;
                }
                Trace.warning(this.getClass(), "removeDisabledPrograms(Coordinator aCoordinator)", "Program Parent defined in PiuType is not found under U-PIU\n\tThe U-PIU: " + this.myUpgradeablePlugInUnit + "\n\tThe parent MO: " + managedObject + "\n\tThe parent LDN: " + string4);
            }
        }
        catch (ProgramMO_HandlerException programMO_HandlerException) {
            throw programMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "removeDisabledPrograms(Coordinator aCoordinator)", "\n\tFailed to delete any disabled programs on PlugInUnit " + this.myUpgradeablePlugInUnit + "\n\ttThrowable caught", throwable);
            throw new ProgramMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: removeDisabledPrograms(Coordinator aCoordinator)" + "\n\tFailed to delete any disabled programs on PlugInUnit " + this.myUpgradeablePlugInUnit + "\n\tThrowable data: " + throwable);
        }
    }

    private void deleteProgram(GenericProgramBase genericProgramBase, UpgradePackageMoExtended upgradePackageMoExtended, Coordinator coordinator) {
        if (!this.deleteProgram(genericProgramBase, coordinator) && upgradePackageMoExtended != null) {
            upgradePackageMoExtended.addNewTroubleProgram((ManagedObject)genericProgramBase);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "removeDisabledPrograms(Coordinator aCoordinator)", "Failed to delete a program (ignored - handled later on).\n\tTrouble program: " + genericProgramBase + "\n\t" + this.getGenericProgramLoadModuleData(genericProgramBase));
            }
        }
    }

    private void checkProgramRunsAsConfigured(GenericProgramBase genericProgramBase, int n, Coordinator coordinator) throws MoAccessException {
        int n2 = this.getOperStateWithDelay(genericProgramBase, coordinator);
        if (genericProgramBase != null) {
            if (n == 1 && n2 == 0) {
                Trace.warning(this.getClass(), "removeDisabledPrograms(Coordinator aCoordinator)", "The GenericProgram has StartState=Enable, OperationState=Disable for generic program " + genericProgramBase + "\n\tLDN for its LoadModule " + genericProgramBase.getLoadModule(coordinator) + "\n\t" + this.getGenericProgramLoadModuleData(genericProgramBase));
            } else if (n == 0 && n2 == 1) {
                Trace.warning(this.getClass(), "removeDisabledPrograms(Coordinator aCoordinator)", "The GenericProgram has StartState=Disable, OperationState=Enable for generic program " + genericProgramBase + "LDN for GenericProgram" + genericProgramBase + "\n\tLDN for LoadModule " + genericProgramBase.getLoadModule(coordinator) + "\n\t" + this.getGenericProgramLoadModuleData(genericProgramBase));
            }
        }
    }

    private void checkProgramRunsAsConfigured(int n, int n2, ProgramMoSU_Access programMoSU_Access) throws MoAccessException {
        if (n2 == 1 && n == 0) {
            Trace.warning(this.getClass(), "checkProgramRunsAsConfigured(int anOpState, int aStartStateWithDelay)", "The GenericProgram has StartState=Enable, OperationState=Disable for generic program " + programMoSU_Access + "\n\tLDN for LoadModule " + programMoSU_Access.getLoadModule(null) + "\n\t" + this.getGenericProgramLoadModuleData((GenericProgramBase)programMoSU_Access));
        } else if (n2 == 0 && n == 1) {
            Trace.warning(this.getClass(), "checkProgramRunsAsConfigured(int anOpState, int aStartStateWithDelay)", "The GenericProgram has StartState=Disable, OperationState=Enable for generic program " + programMoSU_Access + "\n\tLDN for LoadModule " + programMoSU_Access.getLoadModule(null) + "\n\t" + this.getGenericProgramLoadModuleData((GenericProgramBase)programMoSU_Access));
        }
    }

    public String toString() {
        return "\n\tUpgradeable Plug In Unit: " + this.myUpgradeablePlugInUnit;
    }

    private GenericProgramBase createProgram(MoFactory moFactory, ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, LoadModuleMoSU_Access loadModuleMoSU_Access, Coordinator coordinator, int n) throws CreateProgramException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "aProgramMO_Factory: " + moFactory + "\n\taParent: " + managedObject + "\n\tanAttributeList: " + SuLib.toString(attrList) + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n + "\n\tanAttributeList size: " + attrList.size());
        }
        AttrListImpl attrListImpl = new AttrListImpl();
        try {
            int n2 = attrList.size();
            for (int i = 0; i < n2; ++i) {
                attrListImpl.addElement(attrList.getName(i), attrList.getValue(i));
            }
            --n;
            return (GenericProgramBase)moFactory.createMo(managedObject, attrList, string, managedObject2, coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "createProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to create a program.\n\tTrying one more time due to the FRO might have been switched after request signal has been sent but before a reply was returned.\n\taProgramMO_Factory: " + moFactory + "\n\taParent: " + managedObject + "\n\tanAttributeList: " + SuLib.toString((AttrList)attrListImpl) + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tanAttributeList size: " + attrList.size() + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.createProgram(moFactory, managedObject, (AttrList)attrListImpl, string, managedObject2, loadModuleMoSU_Access, coordinator, n);
            }
            Struct struct = null;
            int n3 = -1;
            String string2 = "N/A";
            int n4 = -1;
            int n5 = -1;
            String string3 = "--";
            int n6 = -1;
            int n7 = -1;
            boolean bl = false;
            if (loadModuleMoSU_Access != null) {
                try {
                    struct = loadModuleMoSU_Access.getProductData(coordinator);
                    n3 = loadModuleMoSU_Access.getLoaderType(coordinator);
                    string2 = loadModuleMoSU_Access.getOtherLoaderName(coordinator);
                    n4 = loadModuleMoSU_Access.getPreLoad(coordinator);
                    n5 = loadModuleMoSU_Access.getOseProgramLoadClass(coordinator);
                    string3 = loadModuleMoSU_Access.getReliableProgramLabel(coordinator);
                    n6 = loadModuleMoSU_Access.getOseProgramPoolSize(coordinator);
                    n7 = loadModuleMoSU_Access.getOseProgramHeapSize(coordinator);
                    bl = loadModuleMoSU_Access.getProgramMustBeSingleton(coordinator);
                }
                catch (Exception exception) {
                    Trace.error(this.getClass(), "createProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when tryich to collect data from the programs LoadModule MO", exception);
                }
                Trace.error(this.getClass(), "createProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to create a program for a LoadModule.\n\taProgramMO_Factory: " + moFactory + "\n\taParent: " + managedObject + "\n\tanAttributeList: " + attrList + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheLM_ProductData: " + struct + "\n\ttheLoaderType: " + n3 + "\n\ttheOtherLoaderName: " + string2 + "\n\tthePreLoad: " + n4 + "\n\ttheOseProgramLoadClass: " + n5 + "\n\ttheReliableProgramLabel: " + string3 + "\n\ttheOseProgramPoolSize: " + n6 + "\n\ttheOseProgramHeapSize: " + n7 + "\n\ttheProgramMustBeSingleton: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            } else {
                Trace.error(this.getClass(), "createProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to create a program.\n\taProgramMO_Factory: " + moFactory + "\n\taParent: " + managedObject + "\n\tanAttributeList: " + attrList + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            }
            throw new CreateProgramException("Exception caught when trying to create a program.\n\tcreateProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts) \n\taProgramMO_Factory: " + moFactory + "\n\taParent: " + managedObject + "\n\tanAttributeList: " + attrList + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheLM_ProductData: " + struct + "\n\ttheLoaderType: " + n3 + "\n\ttheOtherLoaderName: " + string2 + "\n\tthePreLoad: " + n4 + "\n\ttheOseProgramLoadClass: " + n5 + "\n\ttheReliableProgramLabel: " + string3 + "\n\ttheOseProgramPoolSize: " + n6 + "\n\ttheOseProgramHeapSize: " + n7 + "\n\ttheProgramMustBeSingleton: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Struct struct = null;
            int n8 = -1;
            String string4 = "N/A";
            int n9 = -1;
            int n10 = -1;
            String string5 = "--";
            int n11 = -1;
            int n12 = -1;
            boolean bl = false;
            if (loadModuleMoSU_Access != null) {
                try {
                    struct = loadModuleMoSU_Access.getProductData(coordinator);
                    n8 = loadModuleMoSU_Access.getLoaderType(coordinator);
                    string4 = loadModuleMoSU_Access.getOtherLoaderName(coordinator);
                    n9 = loadModuleMoSU_Access.getPreLoad(coordinator);
                    n10 = loadModuleMoSU_Access.getOseProgramLoadClass(coordinator);
                    string5 = loadModuleMoSU_Access.getReliableProgramLabel(coordinator);
                    n11 = loadModuleMoSU_Access.getOseProgramPoolSize(coordinator);
                    n12 = loadModuleMoSU_Access.getOseProgramHeapSize(coordinator);
                    bl = loadModuleMoSU_Access.getProgramMustBeSingleton(coordinator);
                }
                catch (Exception exception2) {
                    Trace.error(this.getClass(), "createProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when tryich to collect data from the programs LoadModule MO", exception2);
                }
                Trace.error(this.getClass(), "createProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to create a program.\n\taProgramMO_Factory: " + moFactory + "\n\taParent: " + managedObject + "\n\tanAttributeList: " + SuLib.toString(attrList) + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheLM_ProductData: " + struct + "\n\ttheLoaderType: " + n8 + "\n\ttheOtherLoaderName: " + string4 + "\n\tthePreLoad: " + n9 + "\n\ttheOseProgramLoadClass: " + n10 + "\n\ttheReliableProgramLabel: " + string5 + "\n\ttheOseProgramPoolSize: " + n11 + "\n\ttheOseProgramHeapSize: " + n12 + "\n\ttheProgramMustBeSingleton: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            } else {
                Trace.error(this.getClass(), "createProgram(MoFactory aProgramMO_Factory, ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to create a program.\n\taProgramMO_Factory: " + moFactory + "\n\taParent: " + managedObject + "\n\tanAttributeList: " + SuLib.toString(attrList) + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            }
            throw new CreateProgramException("Exception caught when trying to create a program.\n\tcreateProgram(ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, LoadModuleMoSU_Access aLoadModuleMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts) \n\taProgramMO_Factory: " + moFactory + "\n\taParent: " + managedObject + "\n\tanAttributeList: " + attrList + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheLM_ProductData: " + struct + "\n\ttheLoaderType: " + n8 + "\n\ttheOtherLoaderName: " + string4 + "\n\tthePreLoad: " + n9 + "\n\ttheOseProgramLoadClass: " + n10 + "\n\ttheReliableProgramLabel: " + string5 + "\n\ttheOseProgramPoolSize: " + n11 + "\n\ttheOseProgramHeapSize: " + n12 + "\n\ttheProgramMustBeSingleton: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + exception.toString());
        }
    }

    private ExistingPrograms getExistingPrograms(ProgramConfigurationInformations programConfigurationInformations, ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExistingPrograms (ProgramConfigurationInformations aPiuTypeProgramConfigurations, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "aPiuTypeProgramConfigurations: " + programConfigurationInformations + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Iterator iterator = programConfigurationInformations.iterator();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            ProgramConfigurationInformation programConfigurationInformation = null;
            ManagedObject managedObject = null;
            ExistingProgramsInformation existingProgramsInformation = null;
            ExistingPrograms existingPrograms = new ExistingPrograms();
            while (iterator.hasNext()) {
                programConfigurationInformation = (ProgramConfigurationInformation)iterator.next();
                String string = programConfigurationInformation.getSubparentLDN() + "_" + programConfigurationInformation.getProgramMoTypeName();
                if (!hashMap.containsKey(string)) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "getExistingPrograms (ProgramConfigurationInformations aPiuTypeProgramConfigurations, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "Unique Tag and subParentLDN.\n\tTag value: " + programConfigurationInformation.getTag() + "\n\ttheSubParentLdnAndMoTypeName: " + string);
                    }
                    hashMap.put(string, new Integer(programConfigurationInformation.getTag()));
                    managedObject = this.getProgramParentMO(programConfigurationInformation.getSubparentLDN(), this.myUpgradeablePlugInUnit, "existing programs are collected.");
                    if (managedObject == null) continue;
                    existingProgramsInformation = this.getExistingPrograms(managedObject, programConfigurationInformation.getProgramMoTypeName(), programInformationForConfiguredUpgradeablePIU, coordinator);
                    programInformationForConfiguredUpgradeablePIU = existingProgramsInformation.getProgramInformationForConfiguredUpgradeablePIU();
                    existingPrograms.setTagAndExistingPrograms(programConfigurationInformation.getTag(), new ExistingProgram(managedObject, programConfigurationInformation.getProgramMoTypeName(), existingProgramsInformation.getExistingProgramInformations()));
                    continue;
                }
                Integer n = (Integer)hashMap.get(string);
                if (n.intValue() != programConfigurationInformation.getTag()) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "getExistingPrograms (ProgramConfigurationInformations aPiuTypeProgramConfigurations, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "A Tag value points out same subParentLDN as a previous Tag (used by MGW).\n\tTag value: " + programConfigurationInformation.getTag() + "\n\tEarlier Tag: " + n + "\n\ttheSubParentLdnAndMoTypeName: " + string);
                    }
                    existingPrograms.setTagAndExistingPrograms(programConfigurationInformation.getTag(), existingPrograms.getExistingProgram(n));
                    continue;
                }
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "getExistingPrograms (ProgramConfigurationInformations aPiuTypeProgramConfigurations, Coordinator aCoordinator)", "Same tag has been specified for same Mo parent which not is a valid case and hence ignored\n\ttheTag: " + n + "\n\tPiuTypeProgramConfiguration: " + programConfigurationInformation.getTag());
            }
            existingPrograms.setProgramInformationForConfiguredUpgradeablePIU(programInformationForConfiguredUpgradeablePIU);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getExistingPrograms (ProgramConfigurationInformations aPiuTypeProgramConfigurations, Coordinator aCoordinator)", "RETURNS - theExistingPrograms: " + existingPrograms);
            }
            return existingPrograms;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getExistingPrograms (ProgramConfigurationInformations aPiuTypeProgramConfigurations, Coordinator aCoordinator)", "Throwable caught.\n\taPiuTypeProgramConfigurations: " + programConfigurationInformations + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    private boolean deleteProgram(GenericProgramBase genericProgramBase, Coordinator coordinator) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "deleteProgram(GenericProgramBase aProgram, Coordinator aCoordinator)", "Deleting program: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Control control = null;
        try {
            if (coordinator == null) {
                control = Transaction.create();
                ((ManagedObject)genericProgramBase).delete(Transaction.getCoordinator(control));
                Transaction.commit(control);
                return true;
            }
            ((ManagedObject)genericProgramBase).delete(coordinator);
            return true;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "deleteProgram(GenericProgramBase aProgram, Coordinator aCoordinator)", "Throwable caught (ignored) when trying to delete program " + genericProgramBase + "." + "\n\tThrowable info: " + throwable);
            if (control != null) {
                Transaction.rollback(control);
            }
            return false;
        }
    }

    private ExistingProgramsInformation getExistingPrograms(ManagedObject managedObject, String string, ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExistingPrograms (ManagedObject theProgramParentMO, String aProgramMoTypeName, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "theProgramParentMO: " + managedObject + "\n\ttheProgramParentMO: " + managedObject + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            MoIterator moIterator = MoRepository.instance().select(managedObject, 1, (MoFilter)new MoTypeFilter(string));
            LinkedList<ProgramInformation> linkedList = new LinkedList<ProgramInformation>();
            GenericProgramBase genericProgramBase = null;
            int n = -1;
            boolean bl = false;
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    genericProgramBase = (GenericProgramBase)moIterator.nextMo();
                    n = this.getStartState(genericProgramBase, coordinator, 2, false);
                    if (n == 1) {
                        if (genericProgramBase instanceof ProgramMoSU_Access && ((ProgramMoSU_Access)genericProgramBase).getParent() instanceof PlugInUnitMoSU_Access) {
                            linkedList.add(new ProgramInformation(genericProgramBase, this.getIsUpgradePersistent(genericProgramBase, coordinator, 2), n));
                            continue;
                        }
                        bl = this.getIsUpgradePersistent(genericProgramBase, coordinator, 2);
                        this.disableProgram(genericProgramBase, programInformationForConfiguredUpgradeablePIU, bl, coordinator);
                        linkedList.add(new ProgramInformation(genericProgramBase, bl, 0));
                        if (!Trace.valid(this.getClass(), 40)) continue;
                        Trace.debug(this.getClass(), 40, "getExistingPrograms (ManagedObject theProgramParentMO, String aProgramMoTypeName, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "Startstate has been set to DISABLED for existing program: " + genericProgramBase);
                        continue;
                    }
                    if (!this.deleteProgram(genericProgramBase, coordinator)) {
                        linkedList.add(new ProgramInformation(genericProgramBase, this.getIsUpgradePersistent(genericProgramBase, coordinator, 2), n));
                        continue;
                    }
                    programInformationForConfiguredUpgradeablePIU.incrementDeletedProgramsCounter();
                }
            }
            return new ExistingProgramsInformation(linkedList, programInformationForConfiguredUpgradeablePIU);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getExistingPrograms (ManagedObject theProgramParentMO, Coordinator aCoordinator)", "Throwable caught.\n\ttheProgramParentMO: " + managedObject + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    private void disableProgram(GenericProgramBase genericProgramBase, ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU, boolean bl, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "disableProgram(GenericProgramBase anExistingProgram, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, boolean anIsUpgradePersistent, Coordinator aCoordinator)", "anExistingProgram: " + genericProgramBase + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\tanIsUpgradePersistent: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (!bl) {
                this.setStartState(genericProgramBase, 0, coordinator, 2);
                programInformationForConfiguredUpgradeablePIU.incrementSetStartStateToDisabledCounter();
            } else {
                programInformationForConfiguredUpgradeablePIU.incrementUpgradePersistentCounter();
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "disableRemainingPrograms(ExistingPrograms anExistingPrograms, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "anExistingPrograms: " + genericProgramBase + "\n\tThrowable caught", throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    public TagAndLoadModuleInformation getLoadModulesDefinedInRepertoires(Collection collection, PiuTypeMoSU_Access piuTypeMoSU_Access, ProgramConfigurationInformations programConfigurationInformations, Coordinator coordinator) throws ReconfigureProgramsException {
        String string = "getLoadModulesDefinedInRepertoires(Collection aRepertoireMOs, PiuTypeMoSU_Access aPiuTypeMo, Collection thePiuTypeProgramConfigurations, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aRepertoireMOs: " + collection + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\taPiuTypeProgramConfigurations: " + programConfigurationInformations + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
            TagAndLoadModuleInformation tagAndLoadModuleInformation = repertoireMO_HandlerInterface.getLoadModuleInformations(collection, piuTypeMoSU_Access, programConfigurationInformations.getTagsAsStrings());
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, string, "RETURNS - theTagAndLoadModuleInformation: " + tagAndLoadModuleInformation);
            }
            return tagAndLoadModuleInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taRepertoireMOs: " + collection + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\taPiuTypeProgramConfigurations: " + programConfigurationInformations + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tOrigin Exception:" + throwable, throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    public GenericProgramBase getExistingProgramForLoadModuleAndTag(Integer n, LoadModuleMoSU_Access loadModuleMoSU_Access, ExistingPrograms existingPrograms, int n2, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExistingProgramForLoadModuleAndTag (Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ExistingPrograms anExistingPrograms, int aLoaderTypeAsInt, Coordinator aCoordinator)", "aTag: " + n + "\n\ttheLoadModuleMo: " + loadModuleMoSU_Access + "\n\tanExistingPrograms: " + existingPrograms + "\n\taLoaderTypeAsInt,: " + n2 + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            LinkedList<ProgramInformation> linkedList = new LinkedList<ProgramInformation>();
            int n3 = n;
            Collection collection = existingPrograms.getExistingProgramInformations(n3);
            Iterator iterator = collection.iterator();
            ProgramInformation programInformation = null;
            while (iterator.hasNext()) {
                programInformation = (ProgramInformation)iterator.next();
                if (!programInformation.getProgram().getLoadModule(coordinator).equals(loadModuleMoSU_Access) || !this.isExistingProgramEqualToTagsInResourceLayer(programInformation.getProgram(), n3, coordinator)) continue;
                linkedList.add(programInformation);
            }
            if (linkedList.isEmpty()) {
                return null;
            }
            if (linkedList.size() == 1) {
                return ((ProgramInformation)linkedList.getFirst()).getProgram();
            }
            GenericProgramBase genericProgramBase = null;
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                programInformation = (ProgramInformation)iterator2.next();
                if (programInformation.getProgram() instanceof ProgramMoSU_Access1) {
                    if (((ProgramMoSU_Access1)programInformation.getProgram()).getLoaderType(coordinator) != n2) continue;
                    genericProgramBase = programInformation.getProgram();
                    break;
                }
                genericProgramBase = programInformation.getProgram();
                break;
            }
            if (genericProgramBase == null) {
                genericProgramBase = ((ProgramInformation)linkedList.getFirst()).getProgram();
            }
            return genericProgramBase;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getExistingProgramForLoadModuleAndTag (Integer aTag, LoadModuleMoSU_Access theLoadModuleMo, ExistingPrograms anExistingPrograms, Coordinator aCoordinator)", "Throwable caught.\n\taTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\tanExistingPrograms: " + existingPrograms + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    public ProgramInformation getAndExcludeExistingProgramForLoadModuleAndTag(Integer n, LoadModuleMoSU_Access loadModuleMoSU_Access, ExistingPrograms existingPrograms, int n2, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAndExcludeExistingProgramForLoadModuleAndTag (Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ExistingPrograms anExistingPrograms, int aLoaderTypeAsInt, Coordinator aCoordinator)", "aTag: " + n + "\n\ttheLoadModuleMo: " + loadModuleMoSU_Access + "\n\tanExistingPrograms: " + existingPrograms + "\n\taLoaderTypeAsInt,: " + n2 + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        ProgramInformation programInformation = null;
        try {
            LinkedList<ProgramInformation> linkedList = new LinkedList<ProgramInformation>();
            int n3 = n;
            Collection collection = existingPrograms.getExistingProgramInformations(n3);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                programInformation = (ProgramInformation)iterator.next();
                if (!programInformation.getProgram().getLoadModule(coordinator).equals(loadModuleMoSU_Access) || !this.isExistingProgramEqualToTagsInResourceLayer(programInformation.getProgram(), n3, coordinator)) continue;
                linkedList.add(programInformation);
            }
            ProgramInformation programInformation2 = null;
            if (linkedList.isEmpty()) {
                return null;
            }
            if (linkedList.size() == 1) {
                programInformation2 = (ProgramInformation)linkedList.getFirst();
                collection.remove(programInformation2);
                return programInformation2;
            }
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                programInformation = (ProgramInformation)iterator2.next();
                if (programInformation.getProgram() instanceof ProgramMoSU_Access1) {
                    if (((ProgramMoSU_Access1)programInformation.getProgram()).getLoaderType(coordinator) != n2) continue;
                    collection.remove(programInformation);
                    programInformation2 = programInformation;
                    break;
                }
                collection.remove(programInformation);
                programInformation2 = programInformation;
                break;
            }
            if (programInformation2 == null) {
                programInformation2 = (ProgramInformation)linkedList.getFirst();
                collection.remove(programInformation2);
            }
            return programInformation2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAndExcludeExistingProgramForLoadModuleAndTag(Integer aTag, LoadModuleMoSU_Access theLoadModuleMo, ExistingPrograms anExistingPrograms, Coordinator aCoordinator)", "Throwable caught.\n\taTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\tanExistingPrograms: " + existingPrograms + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    private boolean isExistingProgramEqualToTagsInResourceLayer(GenericProgramBase genericProgramBase, int n, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isExistingProgramEqualToTagsInResourceLayer (GenericProgramBase anExistingProgram, int aTag, Coordinator aCoordinator)", "anExistingProgram: " + genericProgramBase + "\n\taTag: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (genericProgramBase instanceof TagGenericProgram) {
                TagGenericProgram tagGenericProgram = (TagGenericProgram)genericProgramBase;
                int n2 = tagGenericProgram.getRepertoireTag(coordinator);
                if (n2 == -1) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "isExistingProgramEqualToTagsInResourceLayer (GenericProgramBase anExistingProgram, int aTag, Coordinator aCoordinator)", "theProgramsTag (== -1): " + n2 + "\n\tRETURNS - true");
                    }
                    return true;
                }
                if (n2 == n) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "isExistingProgramEqualToTagsInResourceLayer (GenericProgramBase anExistingProgram, int aTag, Coordinator aCoordinator)", "theProgramsTag (== aTag): " + n2 + "\n\tRETURNS - true");
                    }
                    return true;
                }
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isExistingProgramEqualToTagsInResourceLayer (GenericProgramBase anExistingProgram, int aTag, Coordinator aCoordinator)", "theProgramsTag (!= aTag): " + n2 + "\n\tRETURNS - false");
                }
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isExistingProgramEqualToTagsInResourceLayer (GenericProgramBase anExistingProgram, int aTag, Coordinator aCoordinator)", "Throwable caught.anExistingProgram: " + genericProgramBase + "\n\taTag: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    public ProgramInformationForConfiguredUpgradeablePIU createOrEnableRequiredPrograms(TagAndLoadModuleInformation tagAndLoadModuleInformation, ProgramConfigurationInformations programConfigurationInformations, ExistingPrograms existingPrograms, ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU, Coordinator coordinator) throws ReconfigureProgramsException {
        String string = "createOrEnableRequiredPrograms (TagAndLoadModuleInformation aTagAndLoadModuleInformationsForAllRepertoires, ProgramConfigurationInformations aPiuTypeProgramConfigurationsInPiuType, ExistingPrograms anExistingPrograms, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aTagAndLoadModuleInformationsForAllRepertoires: " + tagAndLoadModuleInformation.toNiceString() + "\n\taPiuTypeProgramConfigurationsInPiuType: " + programConfigurationInformations + "\n\tanExistingPrograms: " + existingPrograms + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Iterator iterator = tagAndLoadModuleInformation.getTags();
            Integer n = null;
            LoadModuleInformationData loadModuleInformationData = null;
            Collection collection = null;
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                loadModuleInformationData = tagAndLoadModuleInformation.getLoadModuleInformationData(n);
                collection = loadModuleInformationData.getLoadModuleInformationsContainers();
                programInformationForConfiguredUpgradeablePIU = this.createOrEnableRequiredProgramsForTag(collection, n, existingPrograms, programConfigurationInformations, programInformationForConfiguredUpgradeablePIU, coordinator);
            }
            return programInformationForConfiguredUpgradeablePIU;
        }
        catch (ReconfigureProgramsException reconfigureProgramsException) {
            throw reconfigureProgramsException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aTagAndLoadModuleInformationsForAllRepertoires: " + tagAndLoadModuleInformation + "\n\taPiuTypeProgramConfigurationsInPiuType: " + programConfigurationInformations + "\n\tanExistingPrograms: " + existingPrograms + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new EnableExistingProgramException(throwable.toString());
        }
    }

    public ProgramInformationForConfiguredUpgradeablePIU createOrEnableRequiredProgramsForTag(Collection collection, Integer n, ExistingPrograms existingPrograms, ProgramConfigurationInformations programConfigurationInformations, ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU, Coordinator coordinator) throws ReconfigureProgramsException {
        String string = "createOrEnableRequiredProgramsForTag (Collection aLoadModuleInformationsContainersTag, Integer aTag, ExistingPrograms anExistingPrograms, ProgramConfigurationInformations aPiuTypeProgramConfigurationsInPiuType, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aLoadModuleInformationsContainersTag: " + collection + "\n\taTag: " + n + "\n\tanExistingPrograms: " + existingPrograms + "\n\taPiuTypeProgramConfigurationsInPiuType: " + programConfigurationInformations + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Iterator iterator = null;
            LoadModuleInformation loadModuleInformation = null;
            LoadModuleInformationsContainer loadModuleInformationsContainer = null;
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            ProgramInformation programInformation = null;
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                loadModuleInformationsContainer = (LoadModuleInformationsContainer)iterator.next();
                loadModuleInformation = loadModuleInformationsContainer.getFirstLoadModuleInformation();
                loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModuleMo(loadModuleInformation);
                if (loadModuleMoSU_Access == null) {
                    Trace.error(this.getClass(), string, "The LoadModule Mo for LoadModule to be program couldn't be found i.e. the upgrade is aborted\n\tThe Load module info for the program that should have been created: " + loadModuleInformation);
                    throw new ReconfigureProgramsException("The LoadModule Mo for LoadModule to be program couldn't be found i.e. the upgrade is aborted\n\tThe Load module info for the program that should have been created: " + loadModuleInformation);
                }
                loadModuleInformationsContainer.filterEqualLoadModuleInformation(loadModuleMoSU_Access);
                if (loadModuleInformationsContainer.containsOnlyOneLoadModuleInformation()) {
                    int n2 = loadModuleInformation.getLoaderType().length() == 0 ? loadModuleMO_HandlerInterface.getLoaderType(loadModuleMoSU_Access, null) : loadModuleInformation.getLoaderTypeAsInt();
                    programInformation = this.getAndExcludeExistingProgramForLoadModuleAndTag(n, loadModuleMoSU_Access, existingPrograms, n2, coordinator);
                    programInformationForConfiguredUpgradeablePIU = this.createOrEnableRequiredProgram(programInformation, loadModuleMoSU_Access, loadModuleInformationsContainer.getFirstLoadModuleInformation(), n, programConfigurationInformations.getProgramConfigurationInformation(n), loadModuleMO_HandlerInterface, programInformationForConfiguredUpgradeablePIU, coordinator);
                    continue;
                }
                programInformationForConfiguredUpgradeablePIU = this.createOrEnableRequiredProgram(existingPrograms, loadModuleMoSU_Access, loadModuleInformationsContainer.getAllLoadModuleInformationIter(), n, programConfigurationInformations.getProgramConfigurationInformation(n), loadModuleMO_HandlerInterface, programInformationForConfiguredUpgradeablePIU, coordinator);
            }
            return programInformationForConfiguredUpgradeablePIU;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new ReconfigureProgramsException(loadModuleMO_HandlerException.toString());
        }
        catch (ReconfigureProgramsException reconfigureProgramsException) {
            throw reconfigureProgramsException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.aLoadModuleInformationsContainersTag: " + collection + "\n\taTag: " + n + "\n\tanExistingPrograms: " + existingPrograms + "\n\taPiuTypeProgramConfigurationsInPiuType: " + programConfigurationInformations + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new EnableExistingProgramException(throwable.toString());
        }
    }

    public ProgramInformationForConfiguredUpgradeablePIU createOrEnableRequiredProgram(ExistingPrograms existingPrograms, LoadModuleMoSU_Access loadModuleMoSU_Access, Iterator iterator, Integer n, ProgramConfigurationInformation programConfigurationInformation, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU, Coordinator coordinator) throws ProgramMO_HandlerException, LoadModuleMO_HandlerException, UnexpectedLoaderTypeValueException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createOrEnableRequiredProgram (ExistingPrograms anExistingPrograms, , LoadModuleMoSU_Access aLoadModuleMo, Iterator aLoadModuleInformationsIter, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "\n\tanExistingPrograms: " + existingPrograms + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleInformationsIter: " + iterator + "\n\taTag: " + n + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        ProgramInformation programInformation = null;
        LoadModuleInformation loadModuleInformation = null;
        while (iterator.hasNext()) {
            loadModuleInformation = (LoadModuleInformation)iterator.next();
            int n2 = loadModuleInformation.getLoaderType().length() == 0 ? loadModuleMO_HandlerInterface.getLoaderType(loadModuleMoSU_Access, null) : loadModuleInformation.getLoaderTypeAsInt();
            programInformation = this.getAndExcludeExistingProgramForLoadModuleAndTag(n, loadModuleMoSU_Access, existingPrograms, n2, coordinator);
            programInformationForConfiguredUpgradeablePIU = this.createOrEnableRequiredProgram(programInformation, loadModuleMoSU_Access, loadModuleInformation, n, programConfigurationInformation, loadModuleMO_HandlerInterface, programInformationForConfiguredUpgradeablePIU, coordinator);
        }
        return programInformationForConfiguredUpgradeablePIU;
    }

    public ProgramInformationForConfiguredUpgradeablePIU createOrEnableRequiredProgram(ProgramInformation programInformation, LoadModuleMoSU_Access loadModuleMoSU_Access, LoadModuleInformation loadModuleInformation, Integer n, ProgramConfigurationInformation programConfigurationInformation, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createOrEnableRequiredProgram (ProgramInformation theProgramInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleInformation aLoadModuleInformation, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "theProgramInformation: " + programInformation + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleInformation: " + loadModuleInformation + "\n\taTag: " + n + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            LoadModuleHeapAndPoolSizeContainer loadModuleHeapAndPoolSizeContainer = this.getHeapAndPoolSizeForLoadModuleToBeProgram(loadModuleInformation, loadModuleMoSU_Access, loadModuleMO_HandlerInterface, coordinator);
            ProgramInstances programInstances = new ProgramInstances(loadModuleInformation.getProgramInstances());
            LoaderTypeInformation loaderTypeInformation = this.getLoaderTypeInformation(loadModuleInformation, loadModuleMoSU_Access, loadModuleMO_HandlerInterface, coordinator);
            RestartCounterLimitAndRestartTimerContainer restartCounterLimitAndRestartTimerContainer = this.getRestartCounterLimitAndRestartTimerForLoadModuleToBeProgram(loadModuleInformation, loadModuleMoSU_Access, loadModuleMO_HandlerInterface, coordinator);
            GenericProgramBase genericProgramBase = null;
            if (programInformation == null) {
                genericProgramBase = this.createProgram(n, loadModuleMoSU_Access, programConfigurationInformation, loadModuleHeapAndPoolSizeContainer, programInstances, loaderTypeInformation, restartCounterLimitAndRestartTimerContainer, coordinator);
                if (genericProgramBase != null) {
                    programInformationForConfiguredUpgradeablePIU.incrementCreatedProgramsCounter();
                    this.setStartState(genericProgramBase, 1, coordinator, 2);
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "createOrEnableRequiredProgram(ProgramInformation theProgramInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleInformation aLoadModuleInformation, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "Program Mo has been created and startstate set to ENABLED for: " + genericProgramBase + "\n\tWith data: " + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\ttheProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\ttheLoaderTypeInformationForLoadModuleToBeProgram: " + "\n\taTag: " + n + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\ttheRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer);
                    }
                }
            } else if (this.isExistingProgramReusable(programInformation.getProgram(), loadModuleHeapAndPoolSizeContainer, programInstances, loaderTypeInformation, restartCounterLimitAndRestartTimerContainer, coordinator)) {
                if (programInformation.getStartState() != 1) {
                    this.setStartState(programInformation.getProgram(), 1, coordinator, 2);
                    programInformationForConfiguredUpgradeablePIU.incrementSetStartStateToEnabledCounter();
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "createOrEnableRequiredProgram(ProgramInformation theProgramInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleInformation aLoadModuleInformation, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "Existing program RE-USED and startstate has been set to ENABLED for: " + programInformation.getProgram() + "\n\tCurrent data:" + "\n\ttheHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\ttheProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\ttheLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\ttheRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer);
                    }
                } else {
                    programInformationForConfiguredUpgradeablePIU.incrementReusedProgramsCounter();
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "createOrEnableRequiredProgram(ProgramInformation theProgramInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleInformation aLoadModuleInformation, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "Existing program RE-USED where startstate already was set to ENABLED for: " + programInformation.getProgram() + "\n\tCurrent data:" + "\n\ttheHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\ttheProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\ttheLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\ttheRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer);
                    }
                }
                this.updateTagInProgram(programInformation.getProgram(), n, coordinator);
            } else {
                if (programInformation.getStartState() != 0) {
                    if (!programInformation.isUpgradePersistent()) {
                        this.setStartState(programInformation.getProgram(), 0, coordinator, 2);
                        programInformationForConfiguredUpgradeablePIU.incrementSetStartStateToDisabledCounter();
                    } else {
                        programInformationForConfiguredUpgradeablePIU.incrementUpgradePersistentCounter();
                    }
                }
                if ((genericProgramBase = this.createProgram(n, loadModuleMoSU_Access, programConfigurationInformation, loadModuleHeapAndPoolSizeContainer, programInstances, loaderTypeInformation, restartCounterLimitAndRestartTimerContainer, coordinator)) != null) {
                    programInformationForConfiguredUpgradeablePIU.incrementCreatedProgramsCounter();
                    this.setStartState(genericProgramBase, 1, coordinator, 2);
                }
            }
            return programInformationForConfiguredUpgradeablePIU;
        }
        catch (ProgramMO_HandlerException programMO_HandlerException) {
            throw programMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createOrEnableRequiredProgram (ProgramInformation theProgramInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleInformation aLoadModuleInformation, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU, Coordinator aCoordinator)", "theProgramInformation: " + programInformation + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleInformation: " + loadModuleInformation + "\n\taTag: " + n + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    private void updateTagInProgram(GenericProgramBase genericProgramBase, Integer n, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateTagInProgram(GenericProgramBase aProgram, Integer aTag, Coordinator aCoordinator)", "aProgram: " + genericProgramBase + "\n\taTag: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            TagGenericProgram tagGenericProgram;
            int n2;
            if (genericProgramBase instanceof TagGenericProgram && (n2 = (tagGenericProgram = (TagGenericProgram)genericProgramBase).getRepertoireTag(coordinator)) == -1) {
                tagGenericProgram.setRepertoireTag(n, coordinator);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "updateTagInProgram(GenericProgramBase aProgram, Integer aTag, Coordinator aCoordinator)", "Tag in TagGenericProgram MO has been set to ' " + n + "'." + "\n\tTagGenericProgram MO: " + tagGenericProgram);
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateTagInProgram(GenericProgramBase aProgram, Integer aTag, Coordinator aCoordinator)", "aProgram: " + genericProgramBase + "\n\taTag: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    private boolean isExistingProgramReusable(GenericProgramBase genericProgramBase, LoadModuleHeapAndPoolSizeContainer loadModuleHeapAndPoolSizeContainer, ProgramInstances programInstances, LoaderTypeInformation loaderTypeInformation, RestartCounterLimitAndRestartTimerContainer restartCounterLimitAndRestartTimerContainer, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isExistingProgramReusable (GenericProgramBase anExistingProgram, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation  aLoaderTypeInformationInRepertoire, RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, Coordinator aCoordinator)", "anExistingProgram: " + genericProgramBase + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationInRepertoire: " + loaderTypeInformation + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (this.isHeapAndOrPoolSettingsChanged(genericProgramBase, loadModuleHeapAndPoolSizeContainer, coordinator)) {
                return false;
            }
            if (!this.isProgramInstancesMatching(genericProgramBase, programInstances)) {
                return false;
            }
            if (this.isLoaderTypeChanged(genericProgramBase, loaderTypeInformation)) {
                return false;
            }
            return !this.isRestartCounterLimitAndOrRestartTimerSettingsChanged(genericProgramBase, restartCounterLimitAndRestartTimerContainer, coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isExistingProgramReusable (GenericProgramBase anExistingProgram, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation  aLoaderTypeInformationInRepertoire, Coordinator aCoordinator)", "anExistingProgram: " + genericProgramBase + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationInRepertoire: " + loaderTypeInformation + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    public GenericProgramBase createProgram(Integer n, LoadModuleMoSU_Access loadModuleMoSU_Access, ProgramConfigurationInformation programConfigurationInformation, LoadModuleInformation loadModuleInformation, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createProgram(Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleInformation aLoadModuleInformationForLoadModuleToBeProgram, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "aTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taLoadModuleInformationForLoadModuleToBeProgram: " + loadModuleInformation + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return this.createProgram(n, loadModuleMoSU_Access, programConfigurationInformation, this.getHeapAndPoolSizeForLoadModuleToBeProgram(loadModuleInformation, loadModuleMoSU_Access, loadModuleMO_HandlerInterface, coordinator), new ProgramInstances(loadModuleInformation.getProgramInstances()), this.getLoaderTypeInformation(loadModuleInformation, loadModuleMoSU_Access, loadModuleMO_HandlerInterface, coordinator), this.getRestartCounterLimitAndRestartTimerForLoadModuleToBeProgram(loadModuleInformation, loadModuleMoSU_Access, loadModuleMO_HandlerInterface, coordinator), coordinator);
        }
        catch (ReconfigureProgramsException reconfigureProgramsException) {
            throw new ProgramMO_HandlerException(reconfigureProgramsException.toString());
        }
        catch (ProgramInstanceException programInstanceException) {
            throw new ProgramMO_HandlerException(programInstanceException.toString());
        }
        catch (ProgramMO_HandlerException programMO_HandlerException) {
            throw programMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createProgram(Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleInformation aLoadModuleInformationForLoadModuleToBeProgram, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "aTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taLoadModuleInformationForLoadModuleToBeProgram: " + loadModuleInformation + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taCoordinator: " + SuLib.toString(coordinator) + " Throwable caught when creating program.", throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    public GenericProgramBase createProgram(Integer n, LoadModuleMoSU_Access loadModuleMoSU_Access, ProgramConfigurationInformation programConfigurationInformation, LoadModuleHeapAndPoolSizeContainer loadModuleHeapAndPoolSizeContainer, ProgramInstances programInstances, LoaderTypeInformation loaderTypeInformation, RestartCounterLimitAndRestartTimerContainer restartCounterLimitAndRestartTimerContainer, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createProgram(Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation aLoaderTypeInformationForLoadModuleToBeProgram, RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, Coordinator aCoordinator)", "aTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        AttrListImpl attrListImpl = new AttrListImpl(1);
        attrListImpl.addElement("loadModule", (Object)loadModuleMoSU_Access);
        return this.createProgram(n, loadModuleMoSU_Access, programConfigurationInformation, loadModuleHeapAndPoolSizeContainer, programInstances, loaderTypeInformation, restartCounterLimitAndRestartTimerContainer, attrListImpl, coordinator);
    }

    private GenericProgramBase createProgram(Integer n, LoadModuleMoSU_Access loadModuleMoSU_Access, ProgramConfigurationInformation programConfigurationInformation, LoadModuleHeapAndPoolSizeContainer loadModuleHeapAndPoolSizeContainer, ProgramInstances programInstances, LoaderTypeInformation loaderTypeInformation, RestartCounterLimitAndRestartTimerContainer restartCounterLimitAndRestartTimerContainer, AttrListImpl attrListImpl, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createProgram(Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation aLoaderTypeInformationForLoadModuleToBeProgram, RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, AttrListImpl aProgramAttributeList, Coordinator aCoordinator)", "aTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taProgramAttributeList" + attrListImpl + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        if (programConfigurationInformation == null) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createProgram(Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation aLoaderTypeInformationForLoadModuleToBeProgram, RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, AttrListImpl aProgramAttributeList, Coordinator aCoordinator)", "The tag specified in the repertoire doesn't exist in the PiuType (ignored i.e. no program will be created)\n\taTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taProgramAttributeList" + attrListImpl + "\n\taCoordinator: " + SuLib.toString(coordinator));
            }
            return null;
        }
        String string = null;
        ManagedObject managedObject = null;
        String string2 = null;
        MoFactory moFactory = null;
        try {
            string = programConfigurationInformation.getSubparentLDN();
            managedObject = this.getProgramParentMO(string, this.myUpgradeablePlugInUnit, "a program needs to be created.");
            if (managedObject == null) {
                Trace.warning(this.getClass(), "createProgram(Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation aLoaderTypeInformationForLoadModuleToBeProgram, RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, AttrListImpl aProgramAttributeList, Coordinator aCoordinator)", "No parent MO found for the program to be created. The program type is '" + programConfigurationInformation.getProgramMoTypeName() + "'. No program will be created (ignored)." + "\n\taTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taProgramAttributeList" + attrListImpl + "\n\taCoordinator: " + SuLib.toString(coordinator));
                return null;
            }
            string2 = programConfigurationInformation.getProgramMoTypeName();
            moFactory = MoFactoryMgr.instance().lookup(string2);
            if (moFactory == null) {
                Trace.warning(this.getClass(), "createProgram(Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation aLoaderTypeInformationForLoadModuleToBeProgram, RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, AttrListImpl aProgramAttributeList, Coordinator aCoordinator)", "No program MO factory found for program MO of type '" + string2 + "'." + "\n\taTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taProgramAttributeList" + attrListImpl + "\n\taCoordinator: " + SuLib.toString(coordinator));
                return null;
            }
            MoFactory moFactory2 = MoFactoryMgr.instance().lookup("Program");
            String string3 = this.getAvailableRDN_ValueForProgram(string, this.myUpgradeablePlugInUnit, loadModuleMoSU_Access, string2, coordinator);
            if (moFactory.equals(moFactory2)) {
                return this.createProgramMo(moFactory2, managedObject, loadModuleMoSU_Access, attrListImpl, string3, loadModuleHeapAndPoolSizeContainer, programInstances, loaderTypeInformation, restartCounterLimitAndRestartTimerContainer, coordinator);
            }
            if (moFactory instanceof TagGenericMoFactory) {
                return this.createTagGenericProgram(moFactory, managedObject, n, loadModuleMoSU_Access, attrListImpl, string3, coordinator);
            }
            return this.createProgram(moFactory, managedObject, (AttrList)attrListImpl, string3, null, loadModuleMoSU_Access, coordinator, 2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createProgram(Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, ProgramConfigurationInformation aProgramConfigurationInformationInPiuType, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation aLoaderTypeInformationForLoadModuleToBeProgram, RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, AttrListImpl aProgramAttributeList, Coordinator aCoordinator)", "\n\taTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramConfigurationInformationInPiuType: " + programConfigurationInformation + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taProgramAttributeList" + attrListImpl + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    private GenericProgramBase createProgramMo(MoFactory moFactory, ManagedObject managedObject, LoadModuleMoSU_Access loadModuleMoSU_Access, AttrListImpl attrListImpl, String string, LoadModuleHeapAndPoolSizeContainer loadModuleHeapAndPoolSizeContainer, ProgramInstances programInstances, LoaderTypeInformation loaderTypeInformation, RestartCounterLimitAndRestartTimerContainer restartCounterLimitAndRestartTimerContainer, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createProgramMo(MoFactory aProgramMoFactory, ManagedObject aProgramParentMO, LoadModuleMoSU_Access aLoadModuleMo,  AttrListImpl aProgramAttributeList, String aRDN_ValueForTheLoadModuleToBeProgram, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation aLoaderTypeInformationForLoadModuleToBeProgram, RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, Coordinator aCoordinator)", "aProgramMoFactory: " + moFactory + "\n\taProgramParentMO: " + managedObject + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramAttributeList: " + SuLib.toString((AttrList)attrListImpl) + "\n\taRDN_ValueForTheLoadModuleToBeProgram: " + string + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            attrListImpl.addElement("heapSize", (Object)loadModuleHeapAndPoolSizeContainer.heapSize);
            attrListImpl.addElement("poolSize", (Object)loadModuleHeapAndPoolSizeContainer.poolSize);
            if (programInstances.size() > 0) {
                attrListImpl.addElement("programInstances", (Object)programInstances.getProgramInstancesAsStructArray());
            }
            ProgramMoFactorySU_Access programMoFactorySU_Access = (ProgramMoFactorySU_Access)moFactory;
            MoFactory moFactory2 = programMoFactorySU_Access.getTrueMoFactoryForProgram(managedObject.getType());
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_1", (Object)moFactory2)) {
                attrListImpl.addElement("loaderType", (Object)new Integer(loaderTypeInformation.loaderType));
                attrListImpl.addElement("deviceLoaderName", (Object)loaderTypeInformation.deviceLoaderName);
                attrListImpl.addElement("deviceLoaderInformation", (Object)loaderTypeInformation.deviceLoaderInformation);
            }
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)moFactory2)) {
                attrListImpl.addElement("restartCounterLimit", (Object)restartCounterLimitAndRestartTimerContainer.restartCounterLimit);
                attrListImpl.addElement("restartTimer", (Object)restartCounterLimitAndRestartTimerContainer.restartTimer);
            }
            return this.createProgram(moFactory, managedObject, (AttrList)attrListImpl, string, null, loadModuleMoSU_Access, coordinator, 2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createProgramMo (MoFactory aProgramMoFactory, ManagedObject aProgramParentMO, LoadModuleMoSU_Access aLoadModuleMo, AttrListImpl aProgramAttributeList, String aRDN_ValueForTheLoadModuleToBeProgram, LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram, Coordinator aCoordinator)", "aProgramMoFactory: " + moFactory + "\n\taProgramParentMO: " + managedObject + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramAttributeList: " + SuLib.toString((AttrList)attrListImpl) + "\n\taRDN_ValueForTheLoadModuleToBeProgram: " + string + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    private GenericProgramBase createTagGenericProgram(MoFactory moFactory, ManagedObject managedObject, Integer n, LoadModuleMoSU_Access loadModuleMoSU_Access, AttrListImpl attrListImpl, String string, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createTagGenericProgram (MoFactory aTagGenericProgramMoFactory, ManagedObject aProgramParentMO, Integer aTag, LoadModuleMoSU_Access aLoadModuleMo, AttrListImpl aProgramAttributeList, String aRDN_ValueForTheLoadModuleToBeProgram, Coordinator aCoordinator)", "aTagGenericProgramMoFactory: " + moFactory + "\n\taProgramParentMO: " + managedObject + "\n\taTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramAttributeList: " + SuLib.toString((AttrList)attrListImpl) + "\n\taRDN_ValueForTheLoadModuleToBeProgram: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            attrListImpl.addElement("repertoireTag", (Object)n);
            return this.createProgram(moFactory, managedObject, (AttrList)attrListImpl, string, null, loadModuleMoSU_Access, coordinator, 2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createTagGenericProgram (MoFactory aTagGenericProgramMoFactory, ManagedObject aProgramParentMO, Integer aTag, LoadModuleMoSystemUpgradeAccess aLoadModuleMo, AttrListImpl aProgramAttributeList, String aRDN_ValueForTheLoadModuleToBeProgram, Coordinator aCoordinator)", "aTagGenericProgramMoFactory: " + moFactory + "\n\taProgramParentMO: " + managedObject + "\n\taTag: " + n + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramAttributeList: " + SuLib.toString((AttrList)attrListImpl) + "\n\taRDN_ValueForTheLoadModuleToBeProgram: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    public String getAvailableRDN_ValueForProgram(String string, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, LoadModuleMoSU_Access loadModuleMoSU_Access, String string2, Coordinator coordinator) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAvailableRDN_ValueForProgram(String aProgramParentSubLDN, UpgradeablePlugInUnit anUpgradeablePlugInUnit, LoadModuleMoSU_Access aLoadModuleMo, String aProgramMO_TypeName, Coordinator aCoordinator)", "aProgramParentSubLDN: " + string + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramMO_TypeName: " + string2 + "\n\taCoordinator: " + coordinator);
        }
        try {
            String string3;
            String string4 = null;
            string4 = "".equalsIgnoreCase(string) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string;
            String string5 = loadModuleMoSU_Access.getProductNumber(coordinator);
            String string6 = loadModuleMoSU_Access.getProductRevision(coordinator);
            ManagedObject managedObject = null;
            String string7 = string3 = string5 + "_" + string6;
            String string8 = string4 + "," + string2 + "=" + string7;
            managedObject = MoRepository.instance().lookup(string8);
            if (managedObject != null) {
                int n = 2;
                do {
                    string7 = string3 + "-" + n;
                    string8 = string4 + "," + string2 + "=" + string7;
                    managedObject = MoRepository.instance().lookup(string8);
                    ++n;
                } while (managedObject != null);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getAvailableRDN_ValueForProgram(String aProgramParentSubLDN, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, LoadModuleMoSU_Access aLoadModuleMo, String aProgramMO_TypeName, Coordinator aCoordinator)", "The next available RDN value for the program to be created is: " + string7 + "\n\ttheProductNumber: " + string5 + "\n\ttheProductRevision: " + string6);
            }
            return string7;
        }
        catch (MoAccessException moAccessException) {
            Trace.warning(this.getClass(), "getAvailableRDN_ValueForProgram(String aProgramParentSubLDN, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, LoadModuleMoSU_Access aLoadModuleMo, String aProgramMO_TypeName, Coordinator aCoordinator)", "MoAccessException caught.aProgramParentSubLDN: " + string + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramMO_TypeName: " + string2 + "\n\taCoordinator: " + coordinator + "\n\tOrigin MoAccessException:" + moAccessException.toString());
            return IdGenerator.getNext();
        }
        catch (Exception exception) {
            Trace.warning(this.getClass(), "getAvailableRDN_ValueForProgram(String aProgramParentSubLDN, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, LoadModuleMoSU_Access aLoadModuleMo, String aProgramMO_TypeName, Coordinator aCoordinator)", "Exception caught.aProgramParentSubLDN: " + string + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taProgramMO_TypeName: " + string2 + "\n\taCoordinator: " + coordinator + "\n\tOrigin Exception:" + exception.toString());
            return IdGenerator.getNext();
        }
    }

    private boolean isProgramInstancesMatching(GenericProgramBase genericProgramBase, ProgramInstances programInstances) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "isProgramInstancesMatching (GenericProgramBase anExistingProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram)", "anExistingProgram: " + genericProgramBase + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances);
        }
        try {
            Struct[] structArray;
            ProgramInstances programInstances2;
            boolean bl = true;
            if (genericProgramBase instanceof ProgramMoSU_Access && !(programInstances2 = new ProgramInstances(structArray = ((ProgramMoSU_Access)genericProgramBase).getProgramInstances(null))).equals(programInstances)) {
                bl = false;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isProgramInstancesMatching (GenericProgramBase anExistingProgram, ProgramInstances aProgramInstancesForLoadModuleToBeProgram)", "\n\tanExistingProgram: " + genericProgramBase + "\n\taProgramInstancesForLoadModuleToBeProgram: " + programInstances, throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    private boolean isLoaderTypeChanged(GenericProgramBase genericProgramBase, LoaderTypeInformation loaderTypeInformation) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "anExistingProgram: " + genericProgramBase + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation);
        }
        try {
            boolean bl = false;
            if (genericProgramBase instanceof ProgramMoSU_Access) {
                ProgramMoSU_Access programMoSU_Access = (ProgramMoSU_Access)genericProgramBase;
                int n = programMoSU_Access.getLoaderType(null);
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "theProgramLoaderType: " + n + "\n\ttheProgramMo.getDeviceLoaderName(null): " + programMoSU_Access.getDeviceLoaderName(null) + "\n\ttheProgramMo.getDeviceLoaderInformation(null): " + programMoSU_Access.getDeviceLoaderInformation(null) + "\n\ttheLoadModuleToBeProgramLoaderType: " + loaderTypeInformation.loaderType + "\n\ttheLoadModuleToBeProgramDeviceLoaderName: " + loaderTypeInformation.deviceLoaderName + "\n\ttheLoadModuleToBeProgramDeviceLoaderInformation: " + loaderTypeInformation.deviceLoaderInformation);
                }
                if (!(loaderTypeInformation.loaderType != 0 && loaderTypeInformation.loaderType != 6 || n != 0 && n != 6)) {
                    if (n != loaderTypeInformation.loaderType) {
                        if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "The loaderType attribute value is not the same in an existing program as in its load module Mo.");
                        }
                        bl = true;
                    } else if (n == 6 && loaderTypeInformation.loaderType == 6 && programMoSU_Access.getDeviceLoaderName(null) != null && programMoSU_Access.getDeviceLoaderInformation(null) != null) {
                        if (!programMoSU_Access.getDeviceLoaderName(null).equals(loaderTypeInformation.deviceLoaderName) || !programMoSU_Access.getDeviceLoaderInformation(null).equals(loaderTypeInformation.deviceLoaderInformation)) {
                            bl = true;
                            if (Trace.valid(this.getClass(), 40)) {
                                Trace.debug(this.getClass(), 40, "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "The loaderType attribute value is set to deviceLoader and any of attribute deviceLoaderName and deviceLoaderInformation differs between program Mo and load module Mo.");
                            }
                        } else if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "The loaderType attribute value is set to deviceLoader and the attributes deviceLoaderName and deviceLoaderInformation are the same between program Mo and load module Mo.");
                        }
                    }
                } else if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "The loaderType attribute value is neither oseLoader nor deviceLoader in the load module Mo or/and program Mo.");
                }
            } else if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "The program Mo do not support program mo su access version 4 (i.e. retreival of deviceloadername/information).");
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "RETURNS - theIsLoaderTypeChanged: " + bl + " for the programs' LM '" + genericProgramBase.getLoadModule(null) + "'");
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isLoaderTypeChanged (GenericProgramBase anExistingProgram, LoaderTypeInformation  aLoaderTypeInformationForLoadModuleToBeProgram)", "Throwable caught.\n\tanExistingProgram: " + genericProgramBase + "\n\taLoaderTypeInformationForLoadModuleToBeProgram: " + loaderTypeInformation, throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    private String getGenericProgramLoadModuleData(GenericProgramBase genericProgramBase) {
        String string = "";
        Struct struct = null;
        int n = -1;
        String string2 = "N/A";
        int n2 = -1;
        int n3 = -1;
        String string3 = "--";
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            if (genericProgramBase == null) {
                return "aGenericProgram = null";
            }
            loadModuleMoSU_Access = (LoadModuleMoSU_Access)genericProgramBase.getLoadModule(null);
            if (loadModuleMoSU_Access != null) {
                struct = loadModuleMoSU_Access.getProductData(null);
                n = loadModuleMoSU_Access.getLoaderType(null);
                string2 = loadModuleMoSU_Access.getOtherLoaderName(null);
                n2 = loadModuleMoSU_Access.getPreLoad(null);
                n3 = loadModuleMoSU_Access.getOseProgramLoadClass(null);
                string3 = loadModuleMoSU_Access.getReliableProgramLabel(null);
                n4 = loadModuleMoSU_Access.getOseProgramPoolSize(null);
                n5 = loadModuleMoSU_Access.getOseProgramHeapSize(null);
                bl = loadModuleMoSU_Access.getProgramMustBeSingleton(null);
            } else {
                string = "The load module MO referenced from the generic program has the value 'null'.";
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getGenericProgramLoadModuleData (GenericProgramBase aGenericProgram)", "Exception caught when trying to collect LM data.\n\ttheLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheLM_ProductData: " + SuLib.toString(struct) + "\n\ttheLoaderType: " + n + "\n\ttheOtherLoaderName: " + string2 + "\n\tthePreLoad: " + n2 + "\n\ttheOseProgramLoadClass: " + n3 + "\n\ttheReliableProgramLabel: " + string3 + "\n\ttheOseProgramPoolSize: " + n4 + "\n\ttheOseProgramHeapSize: " + n5 + "\n\ttheProgramMustBeSingleton: " + bl + "\n\tException data: " + throwable.toString(), throwable);
        }
        return string + "\n\ttheLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheLM_ProductData: " + SuLib.toString(struct) + "\n\ttheLoaderType: " + n + "\n\ttheOtherLoaderName: " + string2 + "\n\tthePreLoad: " + n2 + "\n\ttheOseProgramLoadClass: " + n3 + "\n\ttheReliableProgramLabel: " + string3 + "\n\ttheOseProgramPoolSize: " + n4 + "\n\ttheOseProgramHeapSize: " + n5 + "\n\ttheProgramMustBeSingleton: " + bl;
    }

    private boolean getIsUpgradePersistent(GenericProgramBase genericProgramBase, Coordinator coordinator, int n) throws CreateProgramException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIsUpgradePersistant(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "aGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n);
        }
        try {
            --n;
            return genericProgramBase.getIsUpgradePersistent(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "getIsUpgradePersistant(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to get IsUpgradePersistent.\n\tTrying one more time due to the FRO might have been switched after request signal has been sent but before a reply was returned.\n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.getIsUpgradePersistent(genericProgramBase, coordinator, n);
            }
            Trace.error(this.getClass(), "getIsUpgradePersistant(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to get IsUpgradePersistent.\n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new CreateProgramException("Exception caught when trying to set StartState.\n\tgetIsUpgradePersistant(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts) \n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getIsUpgradePersistant(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to get IsUpgradePersistent.\n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            throw new CreateProgramException("Exception caught when trying to get IsUpgradePersistent.\n\tgetIsUpgradePersistant(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts) \n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + exception.toString());
        }
    }

    private ManagedObject getProgramParentMO(String string, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProgramParentMO(String aProgramParentSubLDN, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, String anFunctionalTaskDescription)", "aProgramParentSubLDN: " + string + "\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanFunctionalTaskDescription: " + string2);
        }
        String string3 = null;
        string3 = "".equalsIgnoreCase(string) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string;
        ManagedObject managedObject = MoRepository.instance().lookup(string3);
        if (managedObject == null) {
            Trace.warning(this.getClass(), "getProgramParentMO(String aProgramParentSubLDN, GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, String anFunctionalTaskDescription)", "Program Parent defined in PiuType MO not found under PIU, theProgramParentAbsoluteLDN: " + string3 + "\n\tDetected when " + string2 + "\n\taProgramParentSubLDN: " + string + "\n\ttheProgramParentAbsoluteLDN: " + string3 + "\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tmyUpgradeablePlugInUnit: " + this.myUpgradeablePlugInUnit);
        }
        return managedObject;
    }

    private int getOperState(GenericProgramBase genericProgramBase, Coordinator coordinator, int n, boolean bl) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOperState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "aGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n);
        }
        try {
            --n;
            return genericProgramBase.getOperationalState(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getOperState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "FroNotAccessibleException caught when trying to get OperState.\n\tTrying one more time due to the FRO might have been switched after request signal has been sent but before a reply was returned.\n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
                }
                if (bl) {
                    TimeHandler.sleep(10000L);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getOperState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "Waiting 10 seconds before re-trying...");
                    }
                }
                return this.getOperState(genericProgramBase, coordinator, n, bl);
            }
            throw new ReconfigureProgramsException(froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getOperState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "Throwable caught.\n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException("Throwable caught when trying to set OperState.\n\tgetOperState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay) \n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable data: " + throwable);
        }
    }

    private int getStartState(GenericProgramBase genericProgramBase, Coordinator coordinator, int n, boolean bl) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStartState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "aGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n);
        }
        try {
            --n;
            return genericProgramBase.getStartState(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getStartState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "FroNotAccessibleException caught when trying to get StartState.\n\tTrying one more time due to the FRO might have been switched after request signal has been sent but before a reply was returned.\n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
                }
                if (bl) {
                    TimeHandler.sleep(10000L);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getStartState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "Waiting 10 seconds before re-trying...");
                    }
                }
                return this.getStartState(genericProgramBase, coordinator, n, bl);
            }
            throw new ReconfigureProgramsException(froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getStartState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "Throwable caught.\n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException("Throwable caught when trying to set StartState.\n\tsetStartState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay) \n\taGenericProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable data: " + throwable);
        }
    }

    private StartOpState getStartOpState(ProgramMoSU_Access programMoSU_Access, Coordinator coordinator, int n, boolean bl) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "getStartOpState(ProgramMoSU_Access aProgramMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "aGenericProgram: " + programMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n);
        }
        try {
            --n;
            return programMoSU_Access.getStartOpState(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getStartOpState(ProgramMoSU_Access aProgramMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "FroNotAccessibleException caught when trying to get StartState.\n\tTrying one more time due to the FRO might have been switched after request signal has been sent but before a reply was returned.\n\taGenericProgram: " + programMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
                }
                if (bl) {
                    TimeHandler.sleep(10000L);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getStartOpState(ProgramMoSU_Access aProgramMo, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "Waiting 10 seconds before re-trying...");
                    }
                }
                return this.getStartOpState(programMoSU_Access, coordinator, n, bl);
            }
            throw new ReconfigureProgramsException(froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getStartState(GenericProgramBase aGenericProgram, Coordinator aCoordinator, int aNumberOfRemainingAttempts, boolean aDelay)", "Throwable caught.\n\taGenericProgram: " + programMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    private boolean isHeapAndOrPoolSettingsChanged(GenericProgramBase genericProgramBase, LoadModuleHeapAndPoolSizeContainer loadModuleHeapAndPoolSizeContainer, Coordinator coordinator) throws HeapPoolSettingsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isHeapAndOrPoolSettingsChanged(GenericProgramBase aProgram,LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, Coordinator aCoordinator)", "aProgram: " + genericProgramBase + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            boolean bl = false;
            if (genericProgramBase instanceof ProgramHeapAndPoolSizeInterfaceBase) {
                int n = ((ProgramHeapAndPoolSizeInterfaceBase)genericProgramBase).getPoolSize(coordinator);
                int n2 = ((ProgramHeapAndPoolSizeInterfaceBase)genericProgramBase).getHeapSize(coordinator);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "isHeapAndOrPoolSettingsChanged(GenericProgramBase aProgram,LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, Coordinator aCoordinator)", "The program is of type ProgramHeapAndPoolSizeInterface and the retreived heap and pool data are:\n\taProgram: " + genericProgramBase + "\n\tthePoolSizeOfExistingProgram: " + n + "\n\ttheHeapSizeOfExistingProgram: " + n2 + "\n\taCoordinator: " + SuLib.toString(coordinator));
                }
                if (n != loadModuleHeapAndPoolSizeContainer.poolSize || n2 != loadModuleHeapAndPoolSizeContainer.heapSize) {
                    bl = true;
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isHeapAndOrPoolSettingsChanged(GenericProgramBase aProgram,LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, Coordinator aCoordinator)", "RETURNS - theIsHeapAndOrPoolChanged: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isHeapAndOrPoolSettingsChanged(GenericProgramBase aProgram,LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, Coordinator aCoordinator)", "aProgram: " + genericProgramBase + "\n\taHeapPoolSizeForLoadModuleToBeProgram: " + loadModuleHeapAndPoolSizeContainer + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new HeapPoolSettingsException(throwable.toString());
        }
    }

    private boolean isRestartCounterLimitAndOrRestartTimerSettingsChanged(GenericProgramBase genericProgramBase, RestartCounterLimitAndRestartTimerContainer restartCounterLimitAndRestartTimerContainer, Coordinator coordinator) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isRestartCounterLimitAndOrRestartTimerSettingsChanged(GenericProgramBase aProgram,RestartCounterLimitAndRestartTimerContainer aRestartCounterLimitAndRestartTimerContainer, Coordinator aCoordinator)", "aProgram: " + genericProgramBase + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (!SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)genericProgramBase)) {
                return false;
            }
            boolean bl = false;
            int n = ((ProgramMoSU_Access)genericProgramBase).getRestartCounterLimit(coordinator);
            int n2 = ((ProgramMoSU_Access)genericProgramBase).getRestartTimer(coordinator);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "isRestartCounterLimitAndOrRestartTimerSettingsChanged(GenericProgramBase aProgram,LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, Coordinator aCoordinator)", "The program is of type ProgramMoSU_Access and the retreived restart counter limit and restart timer data are:\n\taProgram: " + genericProgramBase + "\n\ttheRestartCounterLimitOfExistingProgram: " + n + "\n\ttheRestartTimerOfExistingProgram: " + n2 + "\n\taCoordinator: " + SuLib.toString(coordinator));
            }
            if (n != restartCounterLimitAndRestartTimerContainer.restartCounterLimit || n2 != restartCounterLimitAndRestartTimerContainer.restartTimer) {
                bl = true;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isRestartCounterLimitAndOrRestartTimerSettingsChanged(GenericProgramBase aProgram,LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, Coordinator aCoordinator)", "RETURNS - theIsRestartCounterLimitAndOrRestartTimerChanged: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isRestartCounterLimitAndOrRestartTimerSettingsChanged(GenericProgramBase aProgram,LoadModuleHeapAndPoolSizeContainer aHeapPoolSizeForLoadModuleToBeProgram, Coordinator aCoordinator)", "aProgram: " + genericProgramBase + "\n\taRestartCounterLimitAndRestartTimerContainer: " + restartCounterLimitAndRestartTimerContainer + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    private void setStartState(GenericProgramBase genericProgramBase, int n, Coordinator coordinator, int n2) throws CreateProgramException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "aGenericProgram: " + genericProgramBase + "\n\taStartState: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2);
        }
        try {
            --n2;
            genericProgramBase.setStartState(n, coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n2 > 0) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to set StartState.\n\tTrying one more time due to the FRO might have been switched after request signal has been sent but before a reply was returned.\n\taGenericProgram: " + genericProgramBase + "\n\taStartState: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
                }
                this.setStartState(genericProgramBase, n, coordinator, n2);
            }
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            try {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)genericProgramBase.getLoadModule(coordinator);
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to retreive the program's relation to the LoadModule MO", exception);
            }
            Struct struct = null;
            int n3 = -1;
            String string = "N/A";
            int n4 = -1;
            int n5 = -1;
            String string2 = "--";
            int n6 = -1;
            int n7 = -1;
            boolean bl = false;
            if (loadModuleMoSU_Access != null) {
                try {
                    struct = loadModuleMoSU_Access.getProductData(coordinator);
                    n3 = loadModuleMoSU_Access.getLoaderType(coordinator);
                    string = loadModuleMoSU_Access.getOtherLoaderName(coordinator);
                    n4 = loadModuleMoSU_Access.getPreLoad(coordinator);
                    n5 = loadModuleMoSU_Access.getOseProgramLoadClass(coordinator);
                    string2 = loadModuleMoSU_Access.getReliableProgramLabel(coordinator);
                    n6 = loadModuleMoSU_Access.getOseProgramPoolSize(coordinator);
                    n7 = loadModuleMoSU_Access.getOseProgramHeapSize(coordinator);
                    bl = loadModuleMoSU_Access.getProgramMustBeSingleton(coordinator);
                }
                catch (Exception exception) {
                    Trace.error(this.getClass(), "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when tryich to collect data from the programs LoadModule MO", exception);
                }
                Trace.error(this.getClass(), "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "No response from the programs FRO when attempting to set the startstate (FroNotAccessibleException caught).\n\taGenericProgram: " + genericProgramBase + "\n\taStartState: " + n + "\n\ttheLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheLM_ProductData: " + struct + "\n\ttheLoaderType: " + n3 + "\n\ttheOtherLoaderName: " + string + "\n\tthePreLoad: " + n4 + "\n\ttheOseProgramLoadClass: " + n5 + "\n\ttheReliableProgramLabel: " + string2 + "\n\ttheOseProgramPoolSize: " + n6 + "\n\ttheOseProgramHeapSize: " + n7 + "\n\ttheProgramMustBeSingleton: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            } else {
                Trace.error(this.getClass(), "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "No response from the programs FRO when attempting to set the startstate (FroNotAccessibleException caught).\n\taGenericProgram: " + genericProgramBase + "\n\taStartState: " + n + "\n\ttheLoadModuleMo: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            }
            throw new CreateProgramException("Exception caught when trying to set StartState.\n\tsetStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts) \n\taGenericProgram: " + genericProgramBase + "\n\taStartState: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            try {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)genericProgramBase.getLoadModule(coordinator);
            }
            catch (Exception exception2) {
                Trace.error(this.getClass(), "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to retreive the program's relation to the LoadModule MO", exception2);
            }
            Struct struct = null;
            int n8 = -1;
            String string = "N/A";
            int n9 = -1;
            int n10 = -1;
            String string3 = "--";
            int n11 = -1;
            int n12 = -1;
            boolean bl = false;
            if (loadModuleMoSU_Access != null) {
                try {
                    struct = loadModuleMoSU_Access.getProductData(coordinator);
                    n8 = loadModuleMoSU_Access.getLoaderType(coordinator);
                    string = loadModuleMoSU_Access.getOtherLoaderName(coordinator);
                    n9 = loadModuleMoSU_Access.getPreLoad(coordinator);
                    n10 = loadModuleMoSU_Access.getOseProgramLoadClass(coordinator);
                    string3 = loadModuleMoSU_Access.getReliableProgramLabel(coordinator);
                    n11 = loadModuleMoSU_Access.getOseProgramPoolSize(coordinator);
                    n12 = loadModuleMoSU_Access.getOseProgramHeapSize(coordinator);
                    bl = loadModuleMoSU_Access.getProgramMustBeSingleton(coordinator);
                }
                catch (Exception exception3) {
                    Trace.error(this.getClass(), "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "\n\tException caught when tryich to collect data from the programs LoadModule MO", exception3);
                }
                Trace.error(this.getClass(), "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to set StartState.\n\taGenericProgram: " + genericProgramBase + "\n\taStartState: " + n + "\n\ttheLoadModuleMo: " + loadModuleMoSU_Access + "\n\ttheLM_ProductData: " + struct + "\n\ttheLoaderType: " + n8 + "\n\ttheOtherLoaderName: " + string + "\n\tthePreLoad: " + n9 + "\n\ttheOseProgramLoadClass: " + n10 + "\n\ttheReliableProgramLabel: " + string3 + "\n\ttheOseProgramPoolSize: " + n11 + "\n\ttheOseProgramHeapSize: " + n12 + "\n\ttheProgramMustBeSingleton: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            } else {
                Trace.error(this.getClass(), "setStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to set StartState.\n\taGenericProgram: " + genericProgramBase + "\n\taStartState: " + n + "\n\ttheLoadModuleMo: " + loadModuleMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            }
            throw new CreateProgramException("Exception caught when trying to set StartState.\n\tsetStartState(GenericProgramBase aGenericProgram, int aStartState, Coordinator aCoordinator, int aNumberOfRemainingAttempts) \n\taGenericProgram: " + genericProgramBase + "\n\taStartState: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tException data: " + exception.toString());
        }
    }

    private LoadModuleHeapAndPoolSizeContainer getHeapAndPoolSizeForLoadModuleToBeProgram(LoadModuleInformation loadModuleInformation, LoadModuleMoSU_Access loadModuleMoSU_Access, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getHeapAndPoolSizeForLoadModuleToBeProgram(LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "LoadModuleInformation: " + loadModuleInformation + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Integer n = null;
            Integer n2 = null;
            n = loadModuleInformation.getHeapSize().length() > 0 ? new Integer(loadModuleInformation.getHeapSize()) : new Integer(loadModuleMoSU_Access.getOseProgramHeapSize(coordinator));
            n2 = loadModuleInformation.getPoolSize().length() > 0 ? new Integer(loadModuleInformation.getPoolSize()) : new Integer(loadModuleMoSU_Access.getOseProgramPoolSize(coordinator));
            return new LoadModuleHeapAndPoolSizeContainer(n, n2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getHeapAndPoolSizeForLoadModuleToBeProgram(LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "LoadModuleInformation: " + loadModuleInformation + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    private RestartCounterLimitAndRestartTimerContainer getRestartCounterLimitAndRestartTimerForLoadModuleToBeProgram(LoadModuleInformation loadModuleInformation, LoadModuleMoSU_Access loadModuleMoSU_Access, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, Coordinator coordinator) throws ReconfigureProgramsException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRestartCounterLimitAndRestartTimerForLoadModuleToBeProgram(LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "LoadModuleInformation: " + loadModuleInformation + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            Integer n = null;
            if (loadModuleInformation.getRestartCounterLimit().length() > 0) {
                if (!loadModuleInformation.isLmRefAlsoDefinedWithoutRestartCounterLimit()) {
                    n = new Integer(loadModuleInformation.getRestartCounterLimit());
                } else {
                    int n2 = -1;
                    n2 = SU_AccessVersionHandler.getInstance().isSupported("SU_8", (Object)loadModuleMoSU_Access) ? loadModuleMoSU_Access.getRestartCounterLimit(null) : 3;
                    n = loadModuleInformation.getRestartCounterLimitAsInt() <= n2 ? new Integer(loadModuleInformation.getRestartCounterLimit()) : new Integer(n2);
                }
            } else {
                n = SU_AccessVersionHandler.getInstance().isSupported("SU_8", (Object)loadModuleMoSU_Access) ? new Integer(loadModuleMoSU_Access.getRestartCounterLimit(null)) : new Integer(3);
            }
            Integer n3 = null;
            if (loadModuleInformation.getRestartTimer().length() > 0) {
                if (!loadModuleInformation.isLmRefAlsoDefinedWithoutRestartTimer()) {
                    n3 = new Integer(loadModuleInformation.getRestartTimer());
                } else {
                    int n4 = -1;
                    n4 = SU_AccessVersionHandler.getInstance().isSupported("SU_8", (Object)loadModuleMoSU_Access) ? loadModuleMoSU_Access.getRestartTimer(null) : 60;
                    n3 = loadModuleInformation.getRestartTimerAsInt() <= n4 ? new Integer(loadModuleInformation.getRestartTimer()) : new Integer(n4);
                }
            } else {
                n3 = SU_AccessVersionHandler.getInstance().isSupported("SU_8", (Object)loadModuleMoSU_Access) ? new Integer(loadModuleMoSU_Access.getRestartTimer(null)) : new Integer(60);
            }
            return new RestartCounterLimitAndRestartTimerContainer(n, n3);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRestartCounterLimitAndRestartTimerForLoadModuleToBeProgram(LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "LoadModuleInformation: " + loadModuleInformation + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
            throw new ReconfigureProgramsException(throwable.toString());
        }
    }

    private LoaderTypeInformation getLoaderTypeInformation(LoadModuleInformation loadModuleInformation, LoadModuleMoSU_Access loadModuleMoSU_Access, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, Coordinator coordinator) throws ProgramMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoaderTypeInformation (LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "aLoadModuleInformation: " + loadModuleInformation + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            int n = -1;
            String string = null;
            String string2 = null;
            LoaderTypeInformation loaderTypeInformation = null;
            if (loadModuleInformation.getLoaderType().length() > 0) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "getLoaderTypeInformation (LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "LoaderType data specified in repertoire.");
                }
                n = loadModuleInformation.getLoaderTypeAsInt();
                string = loadModuleInformation.getDeviceLoaderName();
                string2 = loadModuleInformation.getDeviceLoaderInformation();
                loaderTypeInformation = new LoaderTypeInformation(n, string, string2);
            } else {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "getLoaderTypeInformation (LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "LoaderType data NOT specified in repertoire (SU TEST).");
                }
                n = loadModuleMO_HandlerInterface.getLoaderType(loadModuleMoSU_Access, null);
                string = loadModuleMO_HandlerInterface.getDeviceLoaderName(loadModuleMoSU_Access, null);
                string2 = loadModuleMO_HandlerInterface.getDeviceLoaderInformation(loadModuleMoSU_Access, null);
                loaderTypeInformation = new LoaderTypeInformation(n, string, string2);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoaderTypeInformation (LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "RETURNS - theLoaderTypeInformation: " + loaderTypeInformation);
            }
            return loaderTypeInformation;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new ProgramMO_HandlerException(loadModuleMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoaderTypeInformation (LoadModuleInformation aLoadModuleInformation, LoadModuleMoSU_Access aLoadModuleMo, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Coordinator aCoordinator)", "aLoadModuleInformation: " + loadModuleInformation + "\n\taLoadModuleMo: " + loadModuleMoSU_Access + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taCoordinator: " + SuLib.toString(coordinator), throwable);
            throw new ProgramMO_HandlerException(throwable.toString());
        }
    }

    private UpgradePackageMoExtended getExecutingUpgradePackageMO() throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExecutingUpgradePackageMO ()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    int n;
                    UpgradePackageMoExtended upgradePackageMoExtended = (UpgradePackageMoExtended)moIterator.nextMo();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getExecutingUpgradePackageMO()", "theUpgradePackageMo " + upgradePackageMoExtended);
                    }
                    if ((n = upgradePackageMoExtended.getState(null)) != 2) continue;
                    return upgradePackageMoExtended;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getExecutingUpgradePackageMO()", "No Upgrade PAckage MO was found.");
                }
                return null;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getExecutingUpgradePackageMO()", "No Upgrade Package MO was found.\n\ttheUpgradePackageMoIterator: " + moIterator);
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getExecutingUpgradePackageMO ()", "Throwable caught when trying to find out if upgrade is in execution.\n\tThrowable data: " + throwable.toString());
            throw new ProgramMO_HandlerException("Class name: " + this.getClass().getName() + "getExecutingUpgradePackageMO ()" + "Throwable caught when trying to find out if upgrade is in execution." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private int getOperStateWithDelay(GenericProgramBase genericProgramBase, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOperStateWithDelay(GenericProgramBase aProgram, Coordinator aCoordinator)", "aProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return this.getOperState(genericProgramBase, coordinator, 2, true);
        }
        catch (ReconfigureProgramsException reconfigureProgramsException) {
            return 0;
        }
    }

    private int getStartStateWithDelay(GenericProgramBase genericProgramBase, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStartStateWithDelay(GenericProgramBase aProgram, Coordinator aCoordinator)", "aProgram: " + genericProgramBase + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return this.getStartState(genericProgramBase, coordinator, 2, true);
        }
        catch (ReconfigureProgramsException reconfigureProgramsException) {
            return 0;
        }
    }

    private StartOpState getStartOpStateWithDelay(ProgramMoSU_Access programMoSU_Access, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStartOpStateWithDelay(ProgramMoSU_Access aProgram, Coordinator aCoordinator)", "aProgram: " + programMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            return this.getStartOpState(programMoSU_Access, coordinator, 2, true);
        }
        catch (ReconfigureProgramsException reconfigureProgramsException) {
            return new StartOpState(0, 0);
        }
    }
}

