/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.UpgradeablePlugInUnit3;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisionsOpt;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SupportedSequenceInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.ProgramInstanceValidateException;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.verify.TagAndLoadModuleRefInformation;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelper;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.ProgramConsistencyInformation;
import se.ericsson.cello.upgradepackage.verify.ProgramInconsistencyInformations;
import se.ericsson.cello.upgradepackage.verify.ProgramInstancesInconsistencyInformation;
import se.ericsson.cello.upgradepackage.verify.UPIUsConnectionInformation;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.event.VerifyRequestEvent;

public class ProgramConsistencyVerifier {
    public ProgramInconsistencyInformations verifyProgramConsistency(VerifyRequestEvent verifyRequestEvent, ValidSequencesInformation validSequencesInformation) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyProgramInstanceConsistency(VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation aValidSequencesInformation)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taValidSequencesInformation: " + validSequencesInformation);
        }
        try {
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                return this.verifyProgramConsistency(verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                return this.verifyProgramConsistency(verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Update)) {
                return this.verifyProgramConsistency(verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Update).getFirstSequenceInformation().currentCase);
            }
            Trace.info(this.getClass(), "verifyLM_TypesInSWA_Connections(VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor no check is done to verify that the SWA connections are allowed at the execution of an upgrade.\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taValidSequencesInformation: " + validSequencesInformation);
            return new ProgramInconsistencyInformations();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyProgramInstanceConsistency(VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation aValidSequencesInformation)", "Throwable caught (the program consistency check could not be performed (ignored)).aVerifyRequestEvent: " + verifyRequestEvent, throwable);
            return new ProgramInconsistencyInformations();
        }
    }

    public ProgramInconsistencyInformations verifyProgramConsistency(VerifyRequestEvent verifyRequestEvent, SupportedSequenceInformation supportedSequenceInformation) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyProgramConsistency(VerifyRequestEvent aVerifyRequestEvent, SupportedSequenceInformation aValidSequencesInformation)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taValidSequencesInformation: " + supportedSequenceInformation);
        }
        try {
            if (supportedSequenceInformation.isSupported()) {
                return this.verifyProgramConsistency(verifyRequestEvent, supportedSequenceInformation.getFirstSequenceInformation().currentCase);
            }
            Trace.info(this.getClass(), "verifyProgramConsistency(VerifyRequestEvent aVerifyRequestEvent, SupportedSequenceInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor no check is done to verify that the SWA connections are allowed at the execution of an upgrade.\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taValidSequencesInformation: " + supportedSequenceInformation);
            return new ProgramInconsistencyInformations();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyProgramConsistency(VerifyRequestEvent aVerifyRequestEvent, SupportedSequenceInformation aValidSequencesInformation)", "Throwable caught (the program consistency check could not be performed (ignored)).\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taValidSequencesInformation: " + supportedSequenceInformation, throwable);
            return new ProgramInconsistencyInformations();
        }
    }

    public ProgramInconsistencyInformations verifyProgramConsistency(VerifyRequestEvent verifyRequestEvent, String string) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyProgramConsistency(VerifyRequestEvent aVerifyRequestEvent, String aCase)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string);
        }
        try {
            String[] stringArray = new String[]{"Repertoire", "ExplicitReplacement", "LoadModule", "PiuType"};
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElementsOptimizedInterface(verifyRequestEvent.upgradePackageDocumentNumber, verifyRequestEvent.upgradePackageDocumentRevision, verifyRequestEvent.upgradePackageUCF_Path, stringArray, false);
            PiuTypeMoData piuTypeMoData = null;
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            Collection collection = upgradeablePIU_HandlerInterface.getUpgradeablePlugInUnits();
            Iterator iterator = collection.iterator();
            UPIUsConnectionInformation uPIUsConnectionInformation = null;
            HashSet hashSet = new HashSet();
            ProgramInconsistencyInformations programInconsistencyInformations = new ProgramInconsistencyInformations();
            ProgramInconsistencyInformations programInconsistencyInformations2 = new ProgramInconsistencyInformations();
            while (iterator.hasNext()) {
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "verifyProgramConsistency(VerifyRequestEvent aVerifyRequestEvent, String aCase)", "Verification of program instances for U-PIU: " + piuTypeMoData.plugInUnit);
                }
                if (piuTypeMoData.plugInUnit == null) continue;
                uPIUsConnectionInformation = this.collectConnectedRepertoireNames(piuTypeMoData.plugInUnit, verifyRequestEvent, string, optimizedDocumentObjectProxyInterface, hashSet);
                programInconsistencyInformations2 = this.verifyProgramConsistencyForAllPiuTypes(piuTypeMoData.plugInUnit, null, uPIUsConnectionInformation.getConnectedRepertoireNamesTobeUsed(), optimizedDocumentObjectProxyInterface);
                if (!programInconsistencyInformations2.isProgramInstancesConsistent()) {
                    programInconsistencyInformations.addProgramInstancesInconsistencyInformation(programInconsistencyInformations2.getProgramInstancesInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isHeapSizeConsistent()) {
                    programInconsistencyInformations.addHeapSizeInconsistencyInformations(programInconsistencyInformations2.getHeapSizeInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isPoolSizeConsistent()) {
                    programInconsistencyInformations.addPoolSizeInconsistencyInformations(programInconsistencyInformations2.getPoolSizeInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isMandatoryLoaderDataConsistent()) {
                    programInconsistencyInformations.addMandatoryLoaderDataInconsistencyInformations(programInconsistencyInformations2.getMandatoryLoaderDataInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isDeviceLoaderInformationDataConsistent()) {
                    programInconsistencyInformations.addDeviceLoaderInformationDataInconsistencyInformations(programInconsistencyInformations2.getDeviceLoaderInformationDataInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isLoaderNamesAllowedForProgramParents()) {
                    programInconsistencyInformations.addLoaderNameNotAllowedForProgramParentInformations(programInconsistencyInformations2.getLoaderNameNotAllowedForProgramParentInformations());
                }
                if (!programInconsistencyInformations2.isRestartCounterLimitConsistent()) {
                    programInconsistencyInformations.addRestartCounterLimitInconsistencyInformations(programInconsistencyInformations2.getRestartCounterLimitInconsistencyInformations());
                }
                if (programInconsistencyInformations2.isRestartTimerConsistent()) continue;
                programInconsistencyInformations.addRestartTimerInconsistencyInformations(programInconsistencyInformations2.getRestartTimerInconsistencyInformations());
            }
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            Collection collection2 = slotMO_HandlerInterface.getAllEmptySlots();
            Iterator iterator2 = collection2.iterator();
            SlotMoSU_Access slotMoSU_Access = null;
            while (iterator2.hasNext()) {
                slotMoSU_Access = (SlotMoSU_Access)iterator2.next();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "verifyProgramConsistency(VerifyRequestEvent aVerifyRequestEvent, String aCase)", "Verification of program instances for empty (free) slot: " + slotMoSU_Access);
                }
                if (!(programInconsistencyInformations2 = this.verifyProgramConsistencyForAllPiuTypes(null, slotMoSU_Access, (uPIUsConnectionInformation = this.collectConnectedRepertoireNames(slotMoSU_Access, verifyRequestEvent, string, (DocumentObjectProxyInterface)optimizedDocumentObjectProxyInterface, hashSet)).getConnectedRepertoireNamesTobeUsed(), optimizedDocumentObjectProxyInterface)).isProgramInstancesConsistent()) {
                    programInconsistencyInformations.addProgramInstancesInconsistencyInformation(programInconsistencyInformations2.getProgramInstancesInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isHeapSizeConsistent()) {
                    programInconsistencyInformations.addHeapSizeInconsistencyInformations(programInconsistencyInformations2.getHeapSizeInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isPoolSizeConsistent()) {
                    programInconsistencyInformations.addPoolSizeInconsistencyInformations(programInconsistencyInformations2.getPoolSizeInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isMandatoryLoaderDataConsistent()) {
                    programInconsistencyInformations.addMandatoryLoaderDataInconsistencyInformations(programInconsistencyInformations2.getMandatoryLoaderDataInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isDeviceLoaderInformationDataConsistent()) {
                    programInconsistencyInformations.addDeviceLoaderInformationDataInconsistencyInformations(programInconsistencyInformations2.getDeviceLoaderInformationDataInconsistencyInformations());
                }
                if (!programInconsistencyInformations2.isLoaderNamesAllowedForProgramParents()) {
                    programInconsistencyInformations.addLoaderNameNotAllowedForProgramParentInformations(programInconsistencyInformations2.getLoaderNameNotAllowedForProgramParentInformations());
                }
                if (!programInconsistencyInformations2.isRestartCounterLimitConsistent()) {
                    programInconsistencyInformations.addRestartCounterLimitInconsistencyInformations(programInconsistencyInformations2.getRestartCounterLimitInconsistencyInformations());
                }
                if (programInconsistencyInformations2.isRestartTimerConsistent()) continue;
                programInconsistencyInformations.addRestartTimerInconsistencyInformations(programInconsistencyInformations2.getRestartTimerInconsistencyInformations());
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "verifyProgramConsistency(VerifyRequestEvent aVerifyRequestEvent, String aCase)", "RETURNS - theProgramConsistencyInformationsTotal: " + programInconsistencyInformations);
            }
            return programInconsistencyInformations;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw new VerifyRequestException(upgradeControlFileParserException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyProgramConsistency(VerifyRequestEvent aVerifyRequestEvent, String aCase)", "Throwable caught (the program consistency check could not be performed (ignored)).aCase: " + string, throwable);
            return new ProgramInconsistencyInformations();
        }
    }

    public ProgramInconsistencyInformations verifyProgramConsistencyForAllPiuTypes(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, SlotMoSU_Access slotMoSU_Access, Collection collection, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyProgramConsistencyForAllPiuTypes(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, SlotMoSU_Access aSlotMo, Collection aConnectedRepertoireNames, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taSlotMo: " + slotMoSU_Access + "aConnectedRepertoireNames: " + collection + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface);
        }
        try {
            RepertoiresProxyInterface repertoiresProxyInterface = optimizedDocumentObjectProxyInterface.getRepertoiresProxyInterface();
            ProductNumbersAndRevisionsOpt productNumbersAndRevisionsOpt = null;
            Iterator iterator = null;
            ProductNumberAndRevision productNumberAndRevision = null;
            productNumbersAndRevisionsOpt = repertoiresProxyInterface.getProductNumbersAndRevisionsOfPiuTypeRefsOpt(collection);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "verifyProgramConsistencyForAllPiuTypes(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, SlotMoSU_Access aSlotMo, Collection aConnectedRepertoireNames, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "The PiuType refs in connected repertoires: " + productNumbersAndRevisionsOpt);
            }
            iterator = productNumbersAndRevisionsOpt.getProductNumberAndRevisionsIterator();
            TagAndLoadModuleRefInformation tagAndLoadModuleRefInformation = new TagAndLoadModuleRefInformation();
            ProgramInconsistencyInformations programInconsistencyInformations = new ProgramInconsistencyInformations();
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "verifyProgramConsistencyForAllPiuTypes(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, SlotMoSU_Access aSlotMo, Collection aConnectedRepertoireNames, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "thePiuTypeProductNumberAndRevision: " + productNumberAndRevision);
                }
                tagAndLoadModuleRefInformation = repertoiresProxyInterface.getLoadModuleRefsConnectedToPiuTypeOpt(productNumberAndRevision.productNumber, productNumberAndRevision.revision, collection);
                tagAndLoadModuleRefInformation.handleLoadModuleRefInfosWithoutLoaderName(optimizedDocumentObjectProxyInterface);
                tagAndLoadModuleRefInformation.setGenericUpgradeablePlugInUnit(genericUpgradeablePlugInUnit);
                tagAndLoadModuleRefInformation.setSlotMo(slotMoSU_Access);
                ProgramConsistencyInformation programConsistencyInformation = this.checkConsistencyForLMsThatMayBeUsedInFuture(tagAndLoadModuleRefInformation, optimizedDocumentObjectProxyInterface);
                if (!programConsistencyInformation.isProgramInstancesConsistent()) {
                    programInconsistencyInformations.addProgramInstancesInconsistencyInformation(programConsistencyInformation.getProgramInstancesInconsistencyInformation());
                }
                if (!programConsistencyInformation.isHeapSizeConsistent()) {
                    programInconsistencyInformations.addHeapSizeInconsistencyInformations(programConsistencyInformation.getHeapSizeInconsistencyInformations());
                }
                if (!programConsistencyInformation.isPoolSizeConsistent()) {
                    programInconsistencyInformations.addPoolSizeInconsistencyInformations(programConsistencyInformation.getPoolSizeInconsistencyInformations());
                }
                if (!programConsistencyInformation.isMandatoryLoaderDataConsistent()) {
                    programInconsistencyInformations.addMandatoryLoaderDataInconsistencyInformations(programConsistencyInformation.getMandatoryLoaderDataInconsistencyInformations());
                }
                if (!programConsistencyInformation.isDeviceLoaderInformationDataConsistent()) {
                    programInconsistencyInformations.addDeviceLoaderInformationDataInconsistencyInformations(programConsistencyInformation.getDeviceLoaderInformationInconsistencyInformations());
                }
                if (!programConsistencyInformation.isLoaderNamesAllowedForProgramParents()) {
                    programInconsistencyInformations.addLoaderNameNotAllowedForProgramParentInformations(programConsistencyInformation.getLoaderNameNotAllowedForProgramParentInformations());
                }
                if (!programConsistencyInformation.isRestartCounterLimitConsistent()) {
                    programInconsistencyInformations.addRestartCounterLimitInconsistencyInformations(programConsistencyInformation.getRestartCounterLimitInconsistencyInformations());
                }
                if (programConsistencyInformation.isRestartTimerConsistent()) continue;
                programInconsistencyInformations.addRestartTimerInconsistencyInformations(programConsistencyInformation.getRestartTimerInconsistencyInformations());
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "verifyProgramConsistencyForAllPiuTypes(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, SlotMoSU_Access aSlotMo, Collection aConnectedRepertoireNames, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "RETURNS - theProgramConsistencyInformations: " + programInconsistencyInformations);
            }
            return programInconsistencyInformations;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyProgramConsistencyForAllPiuTypes(GenericUpgradeablePlugInUnit theGenericUpgradeablePlugInUnitData, SlotMoSU_Access aSlotMo, Collection aConnectedRepertoireNames, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "Throwable caught.\n\ttheGenericUpgradeablePlugInUnitData: " + genericUpgradeablePlugInUnit + "\n\taSlotMo: " + slotMoSU_Access + "\n\taConnectedRepertoireNames: " + collection + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private ProgramConsistencyInformation checkConsistencyForLMsThatMayBeUsedInFuture(TagAndLoadModuleRefInformation tagAndLoadModuleRefInformation, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkConsistencyForLMsThatMayBeUsedInFuture (TagAndLoadModuleRefInformation aTagAndLoadModuleRefInformationForConnectedRepertoires, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "aTagAndLoadModuleRefInformationForConnectedRepertoires: " + tagAndLoadModuleRefInformation + "\n\taDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface);
        }
        try {
            ProgramInstancesInconsistencyInformation programInstancesInconsistencyInformation = this.validateProgramInstances(tagAndLoadModuleRefInformation);
            Collection collection = tagAndLoadModuleRefInformation.checkHeapSize(optimizedDocumentObjectProxyInterface);
            Collection collection2 = tagAndLoadModuleRefInformation.checkPoolSize(optimizedDocumentObjectProxyInterface);
            Collection collection3 = tagAndLoadModuleRefInformation.checkLoaderDataInformation(optimizedDocumentObjectProxyInterface);
            Collection collection4 = tagAndLoadModuleRefInformation.checkLoaderNameAllowedForProgramParent(optimizedDocumentObjectProxyInterface);
            Collection collection5 = tagAndLoadModuleRefInformation.checkRestartCounterLimit(optimizedDocumentObjectProxyInterface);
            Collection collection6 = tagAndLoadModuleRefInformation.checkRestartTimer(optimizedDocumentObjectProxyInterface);
            return new ProgramConsistencyInformation(programInstancesInconsistencyInformation, collection, collection2, collection3, collection4, collection5, collection6);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkConsistencyForLMsThatMayBeUsedInFuture (TagAndLoadModuleRefInformation aTagAndLoadModuleRefInformationForConnectedRepertoires, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "Throwable caught.aTagAndLoadModuleRefInformationForConnectedRepertoires: " + tagAndLoadModuleRefInformation + "\n\taConnectedRepertoireNames: " + tagAndLoadModuleRefInformation.getConnectedRepertoires(), throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private ProgramInstancesInconsistencyInformation validateProgramInstances(TagAndLoadModuleRefInformation tagAndLoadModuleRefInformation) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateProgramInstances (TagAndLoadModuleRefInformation aTagAndLoadModuleRefInformationForConnectedRepertoires)", "aTagAndLoadModuleRefInformationForConnectedRepertoires: " + tagAndLoadModuleRefInformation);
        }
        try {
            tagAndLoadModuleRefInformation.validateProgramInstances();
            return new ProgramInstancesInconsistencyInformation();
        }
        catch (ProgramInstanceValidateException programInstanceValidateException) {
            ProgramInstancesInconsistencyInformation programInstancesInconsistencyInformation = new ProgramInstancesInconsistencyInformation(programInstanceValidateException.getUpgradeablePlugInUnit(), programInstanceValidateException.getSlotMo(), programInstanceValidateException.getRepertoireNames(), programInstanceValidateException.getPiuTypeProductNumber(), programInstanceValidateException.getPiuTypeProductRevision(), programInstanceValidateException.getConnectedLM_Refs(), programInstanceValidateException.getElementName(), programInstanceValidateException.getAttributeName(), programInstanceValidateException.getAttributeValue(), programInstanceValidateException.getValidationFailureMessage(), programInstanceValidateException.getLoadModuleRefInformation());
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "validateProgramInstances (TagAndLoadModuleRefInformation aTagAndLoadModuleRefInformationForConnectedRepertoires)", "RETURNS - theProgramInstancesConsistencyInformation: " + programInstancesInconsistencyInformation);
            }
            return programInstancesInconsistencyInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkConsistencyForLMsThatMayBeUsedInFuture (Collection aConnectedLoadModuleRefInformations, Collection aPiuTypeProgramConfigurationTags))", "Throwable caught.aTagAndLoadModuleRefInformationForConnectedRepertoires: " + tagAndLoadModuleRefInformation + "\n\taConnectedRepertoireNames: " + tagAndLoadModuleRefInformation.getConnectedRepertoires(), throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public UPIUsConnectionInformation collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, VerifyRequestEvent verifyRequestEvent, String string, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnitData, VerifyRequestEvent aVerifyRequestEvent, String aCase, OptimizedDocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection anUsedSwAllocationMos)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\tanUsedSwAllocationMos: " + collection);
        }
        try {
            Object object;
            SwAllocationHelper swAllocationHelper = new SwAllocationHelper();
            Collection collection2 = null;
            UpgradeablePlugInUnit3 upgradeablePlugInUnit3 = null;
            AbstractCollection abstractCollection = new HashSet();
            if (this.isMultipleSwA_Supported(genericUpgradeablePlugInUnit)) {
                upgradeablePlugInUnit3 = (UpgradeablePlugInUnit3)genericUpgradeablePlugInUnit;
                object = upgradeablePlugInUnit3.getSwAllocations(null);
                object = this.filterUsedSwAllocationMos((ManagedObject[])object, collection);
                collection = this.addSwAllocationMos((ManagedObject[])object, collection);
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnitData, VerifyRequestEvent aVerifyRequestEvent, String aCase, OptimizedDocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection anUsedSwAllocationMos)", "theSwAs: " + SuLib.toString((ManagedObject[])object));
                }
                Vector vector = null;
                for (int i = 0; i < ((SwAllocationMoSU_Access)object).length; ++i) {
                    vector = swAllocationHelper.getConnectedRepertoirNames(object[i]);
                    abstractCollection.addAll(vector);
                }
            } else {
                object = (SwAllocationMoSU_Access)genericUpgradeablePlugInUnit.getSwAllocation(null);
                if (object != null) {
                    object = this.filterUsedSwAllocationMo((SwAllocationMoSU_Access)object, collection);
                    collection = this.addSwAllocationMo((SwAllocationMoSU_Access)object, collection);
                    abstractCollection = swAllocationHelper.getConnectedRepertoirNames((SwAllocationMoSU_Access)object);
                }
            }
            collection2 = optimizedDocumentObjectProxyInterface.getRepertoireNamesToBeUsed(abstractCollection, string);
            object = new UPIUsConnectionInformation(collection, collection2);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnitData, VerifyRequestEvent aVerifyRequestEvent, String aCase, OptimizedDocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection anUsedSwAllocationMos)", "RETURNS - theUPIUsConnectionInformation: " + object);
            }
            return object;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, VerifyRequestEvent aVerifyRequestEvent, String aCase, OptimizedDocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection anUsedSwAllocationMos)", "Throwable caught.\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private SwAllocationMoSU_Access filterUsedSwAllocationMo(SwAllocationMoSU_Access swAllocationMoSU_Access, Collection collection) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterUsedSwAllocationMo(SwAllocationMoSU_Access aSwAllocationMo, Collection anUsedSwAllocationMos)", "aSwAllocationMo: " + swAllocationMoSU_Access + "\n\tanUsedSwAllocationMos: " + collection);
        }
        if (collection.contains(swAllocationMoSU_Access.getRole(null))) {
            swAllocationMoSU_Access = null;
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "filterUsedSwAllocationMo(SwAllocationMoSU_Access aSwAllocationMo, Collection anUsedSwAllocationMos)", "RETURNS - aSwAllocationMo: " + swAllocationMoSU_Access);
        }
        return swAllocationMoSU_Access;
    }

    private ManagedObject[] filterUsedSwAllocationMos(ManagedObject[] managedObjectArray, Collection collection) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterUsedSwAllocationMos(ManagedObject[] aSwAllocationMos, Collection anUsedSwAllocationMos)", "aSwAllocationMos: " + SuLib.toString(managedObjectArray) + "\n\tanUsedSwAllocationMos: " + collection);
        }
        SwAllocationMoSU_Access swAllocationMoSU_Access = null;
        HashSet<SwAllocationMoSU_Access> hashSet = new HashSet<SwAllocationMoSU_Access>();
        for (int i = 0; i < managedObjectArray.length; ++i) {
            swAllocationMoSU_Access = (SwAllocationMoSU_Access)managedObjectArray[i];
            if (collection.contains(swAllocationMoSU_Access.getRole(null))) continue;
            hashSet.add(swAllocationMoSU_Access);
        }
        ManagedObject[] managedObjectArray2 = new ManagedObject[hashSet.size()];
        managedObjectArray2 = hashSet.toArray(managedObjectArray2);
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "filterUsedSwAllocationMos(ManagedObject[] aSwAllocationMos, Collection anUsedSwAllocationMos)", "RETURNS - theNotHandledSwAllocationMos: " + SuLib.toString(managedObjectArray2));
        }
        return managedObjectArray2;
    }

    private Collection addSwAllocationMo(SwAllocationMoSU_Access swAllocationMoSU_Access, Collection collection) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addSwAllocationMo(SwAllocationMoSU_Access aSwAllocationMo, Collection anUsedSwAllocationMos)", "aSwAllocationMos: " + swAllocationMoSU_Access + "\n\tanUsedSwAllocationMos: " + collection);
        }
        if (swAllocationMoSU_Access != null) {
            collection.add(swAllocationMoSU_Access.getRole(null));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "addSwAllocationMo(SwAllocationMoSU_Access aSwAllocationMos, Collection anUsedSwAllocationMos)", "RETURNS - anUsedSwAllocationMos: " + collection);
        }
        return collection;
    }

    private Collection addSwAllocationMos(ManagedObject[] managedObjectArray, Collection collection) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addSwAllocationMos(ManagedObject[] aSwAllocationMos, Collection anUsedSwAllocationMos)", "aSwAllocationMos: " + SuLib.toString(managedObjectArray) + "\n\tanUsedSwAllocationMos: " + collection);
        }
        for (int i = 0; i < managedObjectArray.length; ++i) {
            collection.add(((SwAllocationMoSU_Access)managedObjectArray[i]).getRole(null));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "addSwAllocationMos(ManagedObject[] aSwAllocationMos, Collection anUsedSwAllocationMos)", "RETURNS - anUsedSwAllocationMos: " + collection);
        }
        return collection;
    }

    private UPIUsConnectionInformation collectConnectedRepertoireNames(SlotMoSU_Access slotMoSU_Access, VerifyRequestEvent verifyRequestEvent, String string, DocumentObjectProxyInterface documentObjectProxyInterface, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectConnectedRepertoireNames(SlotMoSU_Access aSlotMoSystemUpgradeAccess, VerifyRequestEvent aVerifyRequestEvent, String aCase, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection anUsedSwAllocationMos)", "aSlotMoSystemUpgradeAccess: " + slotMoSU_Access + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUsedSwAllocationMos: " + collection);
        }
        try {
            SwAllocationHelper swAllocationHelper = new SwAllocationHelper();
            Collection collection2 = null;
            SlotMoSU_Access slotMoSU_Access2 = null;
            HashSet hashSet = new HashSet();
            slotMoSU_Access2 = slotMoSU_Access;
            ManagedObject[] managedObjectArray = slotMoSU_Access2.getSwAllocations(null);
            managedObjectArray = this.filterUsedSwAllocationMos(managedObjectArray, collection);
            collection = this.addSwAllocationMos(managedObjectArray, collection);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "collectConnectedRepertoireNames(SlotMoSU_Access aSlotMoSystemUpgradeAccess, VerifyRequestEvent aVerifyRequestEvent, String aCase, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection anUsedSwAllocationMos)", "theSwAs: " + SuLib.toString(managedObjectArray));
            }
            Vector vector = null;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                vector = swAllocationHelper.getConnectedRepertoirNames((SwAllocationMoSU_Access)managedObjectArray[i]);
                hashSet.addAll(vector);
            }
            collection2 = documentObjectProxyInterface.getRepertoireNamesToBeUsed(hashSet, string);
            UPIUsConnectionInformation uPIUsConnectionInformation = new UPIUsConnectionInformation(collection, collection2);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "collectConnectedRepertoireNames(SlotMoSU_Access aSlotMoSystemUpgradeAccess, VerifyRequestEvent aVerifyRequestEvent, String aCase, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection anUsedSwAllocationMos)", "RETURNS - theUPIUsConnectionInformation: " + uPIUsConnectionInformation);
            }
            return uPIUsConnectionInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectConnectedRepertoireNames(SlotMoSU_Access aSlotMoSystemUpgradeAccess, VerifyRequestEvent aVerifyRequestEvent, String aCase, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection anUsedSwAllocationMos)", "Throwable caught.\n\taSlotMoSystemUpgradeAccess: " + slotMoSU_Access + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private boolean isMultipleSwA_Supported(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isMultipleSwA_Supported(GenericUpgradeablePlugInUnit anUpgradeablePIU)", "anUpgradeablePIU: " + genericUpgradeablePlugInUnit);
        }
        boolean bl = false;
        try {
            if (genericUpgradeablePlugInUnit instanceof UpgradeablePlugInUnit3) {
                bl = true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Trace.error(this.getClass(), "isMultipleSwA_Supported(GenericUpgradeablePlugInUnit anUpgradeablePIU)", "anUpgradeablePIU: " + genericUpgradeablePlugInUnit + "\n\tNoClassDefFoundError caught." + "\n\tAssuming the upgradeablePlugInUnit only support one SwAllocation.", noClassDefFoundError);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "isMultipleSwA_Supported(GenericUpgradeablePlugInUnit anUpgradeablePIU)", "RETURNS - theIsSupported: " + bl);
        }
        return bl;
    }
}

