/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.JvmMoSU_Access;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.ActualTypeOfUP;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.LoaderName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.SequenceInformationException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SequenceInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SupportedSequenceInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RepertoireReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesWithLoaderNamesInformation;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.proxy.subrackprodtype.SubrackProdTypesProxyInterface;
import se.ericsson.cello.sudom.proxy.updatesequence.UpdateSequenceProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequenceProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequencesProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformation;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.control.UpgradeController;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgramsContainer;
import se.ericsson.cello.upgradepackage.util.enumer.LoadModuleState;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapter;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapterException;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.activeotherlms.ActiveOtherLMsMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.VerifyCVsToBeCreatedResult;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeData;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.webserver.WebServerMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.C_AUE_InconsistencyInformations;
import se.ericsson.cello.upgradepackage.verify.C_AUE_InconsistencyInformationsContainer;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandler;
import se.ericsson.cello.upgradepackage.verify.CoreMPsFTC_StatusHandler;
import se.ericsson.cello.upgradepackage.verify.CoreMPsFTC_StatusInformation;
import se.ericsson.cello.upgradepackage.verify.FailedLoadModulesChecksumErrorInformation;
import se.ericsson.cello.upgradepackage.verify.FailedUCFChecksumErrorInformation;
import se.ericsson.cello.upgradepackage.verify.MainPIU_Information;
import se.ericsson.cello.upgradepackage.verify.MultipleSwaVerifier;
import se.ericsson.cello.upgradepackage.verify.NotAllowedLM_TypesInSWA_ConnectionsInformation;
import se.ericsson.cello.upgradepackage.verify.ProgramAndLoadModuleInconsistencyInfoContainer;
import se.ericsson.cello.upgradepackage.verify.ProgramInconsistencyInformations;
import se.ericsson.cello.upgradepackage.verify.SubrackNotSupportedInformation;
import se.ericsson.cello.upgradepackage.verify.UcfDataContainer;
import se.ericsson.cello.upgradepackage.verify.VerifyChecksumException;
import se.ericsson.cello.upgradepackage.verify.VerifyCoreMPsException;
import se.ericsson.cello.upgradepackage.verify.VerifyCreationOfCVsException;
import se.ericsson.cello.upgradepackage.verify.VerifyMainMPsException;
import se.ericsson.cello.upgradepackage.verify.VerifyOperationalPIUsException;
import se.ericsson.cello.upgradepackage.verify.VerifyProgramHandler;
import se.ericsson.cello.upgradepackage.verify.VerifySupportedPIUsException;
import se.ericsson.cello.upgradepackage.verify.VerifyUpgradeException;
import se.ericsson.cello.upgradepackage.verify.VerifyUpgradeWindowException;
import se.ericsson.cello.upgradepackage.verify.event.BlockingVerifyRequestEvent;
import se.ericsson.cello.upgradepackage.verify.event.VerifyRequestEvent;
import se.ericsson.cello.upgradepackage.verify.ssw.SSW_ValidationInformation;

public class VerifyHelper {
    public static Collection verifySubracksSupported(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifySubracksSupported(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        try {
            LinkedList<SubrackNotSupportedInformation> linkedList = new LinkedList<SubrackNotSupportedInformation>();
            SubrackProdTypesProxyInterface subrackProdTypesProxyInterface = documentObjectProxyInterface.getSubrackProdTypesProxyInterface();
            ProductNumbersAndRevisions productNumbersAndRevisions = subrackProdTypesProxyInterface.getProductNumberAndRevisionOfSubrackProdTypes();
            boolean bl = true;
            if (productNumbersAndRevisions.isEmpty()) {
                bl = false;
            }
            SubrackMO_HandlerInterface subrackMO_HandlerInterface = ServiceFinder.getSubrackMO_HandlerInterface();
            Collection collection = subrackMO_HandlerInterface.getSubrackMoDataForAllSubrackMos();
            boolean bl2 = true;
            if (collection.isEmpty()) {
                bl2 = false;
            }
            SubrackNotSupportedInformation subrackNotSupportedInformation = null;
            if (bl && bl2) {
                Iterator iterator = subrackMO_HandlerInterface.getSubrackMoDataForAllSubrackMos().iterator();
                SubrackMoData subrackMoData = null;
                SubrackProdTypeData subrackProdTypeData = null;
                SubrackProdTypeMO_HandlerInterface subrackProdTypeMO_HandlerInterface = ServiceFinder.getSubrackProdTypeMO_HandlerInterface();
                while (iterator.hasNext()) {
                    subrackMoData = (SubrackMoData)iterator.next();
                    subrackProdTypeData = null;
                    String string = null;
                    String string2 = null;
                    if (subrackMoData.isMRBS) {
                        string = subrackMoData.administrativeProductNumber;
                        string2 = subrackMoData.administrativeProductRevision;
                        if (Trace.valid(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 20)) {
                            Trace.debug(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 20, "verifySubracksSupported(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Follow MRBS check in Subrack!!!");
                        }
                    } else {
                        string = subrackMoData.operationalProductNumber;
                        string2 = subrackMoData.operationalProductRevision;
                        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                            Trace.info(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, "verifySubracksSupported(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "No operational product number and/or revision is available in resource layer (OSA) i.e. the\n\tadministrative product number and revision for the subrack will be used.\n\tThe Subrack MO data: " + subrackMoData);
                            string = subrackMoData.administrativeProductNumber;
                            string2 = subrackMoData.administrativeProductRevision;
                        }
                        if (Trace.valid(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 20)) {
                            Trace.debug(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 20, "verifySubracksSupported(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Follow regular check in Subrack (NOT MRBS)!!!");
                        }
                    }
                    if (productNumbersAndRevisions.containsWithAnyRevisionRuleForIn(string, string2)) continue;
                    if (subrackMoData.subrackProdTypeMO != null) {
                        subrackProdTypeData = subrackProdTypeMO_HandlerInterface.getSubrackProdTypeMoData(subrackMoData.subrackProdTypeMO);
                    }
                    subrackNotSupportedInformation = new SubrackNotSupportedInformation(subrackMoData, subrackProdTypeData);
                    linkedList.add(subrackNotSupportedInformation);
                }
            } else if (!bl && !bl2) {
                if (Trace.valid(VerifyHelper.class, 22)) {
                    Trace.debug(VerifyHelper.class, 22, "verifySubracksSupported(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "The implemented version of interface SubrackMoSU_Access is old but compatible with the used Upgrade Control File,\n\tno re-configuration of Subrack data will be done during upgrade.");
                }
            } else {
                subrackNotSupportedInformation = new SubrackNotSupportedInformation(bl2, bl);
                linkedList.add(subrackNotSupportedInformation);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifySubracksSupported(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Throwable caught.\n\taVerifyRequestEvent: " + verifyRequestEvent, throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tverifySubracksSupported(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)" + "\n\tThrowable caught." + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public static Vector checkForPgmAndInitialConfiguration(Vector vector) {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "checkForPgmAndInitialConfiguration(Vector aNonSupportedPIUs)");
        }
        PiuTypeMoData piuTypeMoData = null;
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
        boolean bl = false;
        UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
        Vector<PiuTypeMoData> vector2 = new Vector<PiuTypeMoData>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            piuTypeMoData = (PiuTypeMoData)iterator.next();
            genericUpgradeablePlugInUnit = piuTypeMoData.plugInUnit;
            bl = upgradeablePIU_HandlerInterface.checkForPgmUnderUpgradeablePIU(genericUpgradeablePlugInUnit);
            if (!bl) continue;
            if (Trace.valid(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22)) {
                Trace.debug(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22, "checkForPgmAndInitialConfiguration(Vector aNonSupportedPIUs)", "A non-supported PIU with Program found. \n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
            }
            if (!VerifyHelper.checkIfInitialConfiguration(genericUpgradeablePlugInUnit)) continue;
            vector2.addElement(piuTypeMoData);
            if (!Trace.valid(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22)) continue;
            Trace.debug(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22, "checkForPgmAndInitialConfiguration(Vector aNonSupportedPIUs)  ", "A non-supported PIU with Program and initial configuration found.\n\tthePiuTypeMoData: " + piuTypeMoData.toString());
        }
        return vector2;
    }

    private static boolean checkIfInitialConfiguration(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        try {
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
            Struct[] structArray = piuTypeMoSU_Access.getProgramConfiguration(null);
            if (structArray.length == 0) {
                if (Trace.valid(VerifyHelper.class, 22)) {
                    Trace.debug(VerifyHelper.class, 22, "checkIfInitialConfiguration(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)  ", "Returning true. Initial configuration.");
                }
                return true;
            }
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "checkIfInitialConfiguration(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)  ", "Returning false. Not initial configuration");
            }
            return false;
        }
        catch (Throwable throwable) {
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "checkIfInitialConfiguration(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)  ", "Throwable caught. " + throwable.toString());
            }
            return false;
        }
    }

    public static SupportedSequenceInformation verifyUpgradeWindow(DocumentObjectProxyInterface documentObjectProxyInterface, BlockingVerifyRequestEvent blockingVerifyRequestEvent) throws VerifyUpgradeWindowException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, BlockingVerifyRequestEvent aBlockingVerifyRequestEvent)", "aBlockingVerifyRequestEvent: " + blockingVerifyRequestEvent);
        }
        try {
            Object object;
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
            String string = "";
            String string2 = "";
            String string3 = "NotDefined";
            if (upgradePackageMoExtended != null) {
                if (upgradePackageMoExtended instanceof UpgradePackageMoImpl) {
                    if (blockingVerifyRequestEvent.installedTypeOfUP.isDelta()) {
                        string = upgradePackageMoExtended.getDocumentNumber(null);
                        string2 = upgradePackageMoExtended.getDocumentRevision(null);
                        string3 = upgradePackageMoExtended.getUP_CompatibilityIndex(null);
                    } else {
                        if (VerifyHelper.isDowngrade(blockingVerifyRequestEvent, upgradePackageMoExtended)) {
                            Trace.info(VerifyHelper.class, "verifyUpgradeWindow(VerifyRequestEvent aVerifyRequestEvent)", "Not allowed to execute an upgrade from an active delta UP to its root (base) UP");
                            return new SupportedSequenceInformation(new HashSet());
                        }
                        string = upgradePackageMoExtended.getBaseUP_ProductNumber(null);
                        string2 = upgradePackageMoExtended.getBaseUP_ProductRevision(null);
                        object = ServiceFinder.getUpgradePackageMO_HandlerInterface();
                        UpgradePackageMoExtended upgradePackageMoExtended2 = object.getUpgradePackageMo(string, string2);
                        if (upgradePackageMoExtended2 != null) {
                            string3 = upgradePackageMoExtended2.getUP_CompatibilityIndex(null);
                        } else {
                            Trace.warning(VerifyHelper.class, "adaptFileToCurrentConfiguration(DocumentObjectUpgradePackage aDocumentObjectUpgradePackage, RequestedTypeOfUP aRequestedTypeOfUP, Coordinator aCoordinator)", "Couldn't look up the master (root) UP for the current active delta UP i.e. no Up Compatbility index can be used.\n\tinstalledTypeOfUP: " + blockingVerifyRequestEvent.installedTypeOfUP + "\n\ttheCurrentBaseUpgradePackageProductNumber: " + string + "\n\ttheCurrentBaseUpgradePackageProductRevision: " + string2);
                        }
                    }
                }
            } else {
                string = blockingVerifyRequestEvent.upgradePackageDocumentNumber;
                string2 = blockingVerifyRequestEvent.upgradePackageDocumentRevision;
                string3 = blockingVerifyRequestEvent.upCompatibilityIndex;
            }
            object = documentObjectProxyInterface.getValidSequences(blockingVerifyRequestEvent.typeOfUpgrade, string, string2, string3);
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, BlockingVerifyRequestEvent aBlockingVerifyRequestEvent)", "The selected sequences is:" + object);
            }
            return object;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(VerifyHelper.class, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, BlockingVerifyRequestEvent aBlockingVerifyRequestEvent)", "MoAccessException caught.aBlockingVerifyRequestEvent: " + blockingVerifyRequestEvent + "\n\tOrigin MoAccessException:" + moAccessException.toString(), moAccessException);
            throw new VerifyUpgradeWindowException(moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, BlockingVerifyRequestEvent aBlockingVerifyRequestEvent)", "Throwable caught.aBlockingVerifyRequestEvent: " + blockingVerifyRequestEvent + "\n\tOrigin Exception:" + throwable.toString(), throwable);
            throw new VerifyUpgradeWindowException(throwable.toString());
        }
    }

    private static boolean isDowngrade(VerifyRequestEvent verifyRequestEvent, UpgradePackageMoExtended upgradePackageMoExtended) throws VerifyUpgradeWindowException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "isDowngrade (VerifyRequestEvent aVerifyRequestEvent, UpgradePackageMoExtended aCurrentUP)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taCurrentUP: " + upgradePackageMoExtended);
        }
        try {
            ActualTypeOfUP actualTypeOfUP;
            if (upgradePackageMoExtended != null && (actualTypeOfUP = ActualTypeOfUP.getInstance(upgradePackageMoExtended.getActualTypeOfUP(null))).isDelta() && !verifyRequestEvent.installedTypeOfUP.isDelta()) {
                Collection collection = upgradePackageMoExtended.getBasedOnUpgradePackagesAsProductDatas(null);
                if (Trace.valid(VerifyHelper.class, 20)) {
                    Trace.debug(VerifyHelper.class, 20, "isDowngrade (VerifyRequestEvent aVerifyRequestEvent, UpgradePackageMoExtended aCurrentUP)", "theBasedOnsProdDatas: " + collection);
                }
                Iterator iterator = collection.iterator();
                ProductDataContainer productDataContainer = null;
                while (iterator.hasNext()) {
                    productDataContainer = (ProductDataContainer)iterator.next();
                    if (!productDataContainer.getNumber().equals(verifyRequestEvent.upgradePackageDocumentNumber) || !productDataContainer.getRevision().equals(verifyRequestEvent.upgradePackageDocumentRevision)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyNotDowngrade (VerifyRequestEvent aVerifyRequestEvent, UpgradePackageMoExtended aCurrentUP)", "Throwable caught.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taCurrentUP: " + upgradePackageMoExtended + "\n\tOrigin Exception:" + throwable, throwable);
            throw new VerifyUpgradeWindowException(throwable.toString());
        }
    }

    private static boolean isDowngrade(String string, String string2, boolean bl, UpgradePackageMoExtended upgradePackageMoExtended) throws VerifyUpgradeWindowException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "isDowngrade (String anUpgradePackageDocumentNumber, String anUpgradePackageDocumentRevision, boolean anInstalledTypeOfUP_IsDelta, UpgradePackageMoExtended aCurrentUP)", "anUpgradePackageDocumentNumber: " + string + "\n\tanUpgradePackageDocumentRevision: " + string2 + "\n\tanInstalledTypeOfUP_IsDelta: " + bl + "\n\taCurrentUP: " + upgradePackageMoExtended);
        }
        try {
            ActualTypeOfUP actualTypeOfUP;
            if (upgradePackageMoExtended != null && (actualTypeOfUP = ActualTypeOfUP.getInstance(upgradePackageMoExtended.getActualTypeOfUP(null))).isDelta() && !bl) {
                Collection collection = upgradePackageMoExtended.getBasedOnUpgradePackagesAsProductDatas(null);
                if (Trace.valid(VerifyHelper.class, 20)) {
                    Trace.debug(VerifyHelper.class, 20, "isDowngrade (VerifyRequestEvent aVerifyRequestEvent, UpgradePackageMoExtended aCurrentUP)", "theBasedOnsProdDatas: " + collection);
                }
                Iterator iterator = collection.iterator();
                ProductDataContainer productDataContainer = null;
                while (iterator.hasNext()) {
                    productDataContainer = (ProductDataContainer)iterator.next();
                    if (!productDataContainer.getNumber().equals(string) || !productDataContainer.getRevision().equals(string2)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyNotDowngrade (VerifyRequestEvent aVerifyRequestEvent, UpgradePackageMoExtended aCurrentUP)", "Throwable caught.aVerifyRequestEvent: \n\taCurrentUP: " + upgradePackageMoExtended + "\n\tOrigin Exception:" + throwable, throwable);
            throw new VerifyUpgradeWindowException(throwable.toString());
        }
    }

    public static ValidSequencesInformation verifyUpgradeWindow(String string, String string2, String string3, boolean bl, String string4) throws VerifyUpgradeWindowException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyUpgradeWindow(String anUpgradePackageDocumentNumber, String anUpgradePackageDocumentRevision, String anUpCompatibilityIndex, InstalledTypeOfUP anInstalledTypeOfUP, String anUCF_Path)", "anUpgradePackageDocumentNumber: " + string + "\n\tanUpgradePackageDocumentRevision: " + string2 + "\n\tanUpCompatibilityIndex: " + string3 + "\n\tanInstalledTypeOfUP_IsDelta: " + bl + "\n\tanUCF_Path: " + string4);
        }
        try {
            Object object;
            Object object2;
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
            String string5 = "";
            String string6 = "";
            String string7 = "NotDefined";
            if (upgradePackageMoExtended != null) {
                if (upgradePackageMoExtended instanceof UpgradePackageMoImpl) {
                    if (bl) {
                        string5 = upgradePackageMoExtended.getDocumentNumber(null);
                        string6 = upgradePackageMoExtended.getDocumentRevision(null);
                        string7 = upgradePackageMoExtended.getUP_CompatibilityIndex(null);
                    } else {
                        if (VerifyHelper.isDowngrade(string, string2, bl, upgradePackageMoExtended)) {
                            Trace.info(VerifyHelper.class, "verifyUpgradeWindow(VerifyRequestEvent aVerifyRequestEvent)", "Not allowed to execute an upgrade from an active delta UP to its root (base) UP");
                            return new ValidSequencesInformation(new SupportedSequenceInformation(new LinkedList()), new SupportedSequenceInformation(new LinkedList()), new SupportedSequenceInformation(new LinkedList()));
                        }
                        string5 = upgradePackageMoExtended.getBaseUP_ProductNumber(null);
                        string6 = upgradePackageMoExtended.getBaseUP_ProductRevision(null);
                        object2 = ServiceFinder.getUpgradePackageMO_HandlerInterface();
                        object = object2.getUpgradePackageMo(string5, string6);
                        if (object != null) {
                            string7 = object.getUP_CompatibilityIndex(null);
                        } else {
                            Trace.warning(VerifyHelper.class, "verifyUpgradeWindow(VerifyRequestEvent aVerifyRequestEvent)", "Couldn't look up the master (root) UP for the current active delta UP i.e. no Up Compatbility index can be used.\n\tanInstalledTypeOfUP_IsDelta: " + bl + "\n\ttheCurrentBaseUpgradePackageProductNumber: " + string5 + "\n\ttheCurrentBaseUpgradePackageProductRevision: " + string6);
                        }
                    }
                }
            } else {
                string5 = string;
                string6 = string2;
                string7 = string3;
            }
            object2 = new String[]{"UpgradeWindow", "UpgradeSequence", "UpdateSequence"};
            object = UCF_ParserFacade.parseMainElements(string, string2, string4, object2);
            ValidSequencesInformation validSequencesInformation = object.getValidSequences(string5, string6, string7);
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "verifyUpgradeWindow(VerifyRequestEvent aVerifyRequestEvent)", "The selected sequences are:" + validSequencesInformation + "\n\ttheValidSequencesInformation: " + validSequencesInformation);
            }
            return validSequencesInformation;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(VerifyHelper.class, "verifyUpgradeWindow(VerifyRequestEvent aVerifyRequestEvent)", "MoAccessException caught.aVerifyRequestEvent: \n\tOrigin MoAccessException:" + moAccessException.toString(), moAccessException);
            throw new VerifyUpgradeWindowException(moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyUpgradeWindow(VerifyRequestEvent aVerifyRequestEvent)", "Throwable caught.aVerifyRequestEvent: \n\tOrigin Exception:" + throwable.toString(), throwable);
            throw new VerifyUpgradeWindowException(throwable.toString());
        }
    }

    public static ValidSequencesInformation verifyUpgradeWindow(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent) throws VerifyUpgradeWindowException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        try {
            Object object;
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
            String string = "";
            String string2 = "";
            String string3 = "NotDefined";
            if (upgradePackageMoExtended != null) {
                if (upgradePackageMoExtended instanceof UpgradePackageMoImpl) {
                    if (verifyRequestEvent.installedTypeOfUP.isDelta()) {
                        string = upgradePackageMoExtended.getDocumentNumber(null);
                        string2 = upgradePackageMoExtended.getDocumentRevision(null);
                        string3 = upgradePackageMoExtended.getUP_CompatibilityIndex(null);
                    } else {
                        if (VerifyHelper.isDowngrade(verifyRequestEvent, upgradePackageMoExtended)) {
                            Trace.info(VerifyHelper.class, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Not allowed to execute an upgrade from an active delta UP to its root (base) UP");
                            return new ValidSequencesInformation(new SupportedSequenceInformation(new LinkedList()), new SupportedSequenceInformation(new LinkedList()), new SupportedSequenceInformation(new LinkedList()));
                        }
                        string = upgradePackageMoExtended.getBaseUP_ProductNumber(null);
                        string2 = upgradePackageMoExtended.getBaseUP_ProductRevision(null);
                        object = ServiceFinder.getUpgradePackageMO_HandlerInterface();
                        UpgradePackageMoExtended upgradePackageMoExtended2 = object.getUpgradePackageMo(string, string2);
                        if (upgradePackageMoExtended2 != null) {
                            string3 = upgradePackageMoExtended2.getUP_CompatibilityIndex(null);
                        } else {
                            Trace.warning(VerifyHelper.class, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Couldn't look up the master (root) UP for the current active delta UP i.e. no Up Compatbility index can be used.\n\tinstalledTypeOfUP: " + verifyRequestEvent.installedTypeOfUP + "\n\ttheCurrentBaseUpgradePackageProductNumber: " + string + "\n\ttheCurrentBaseUpgradePackageProductRevision: " + string2);
                        }
                    }
                }
            } else {
                string = verifyRequestEvent.upgradePackageDocumentNumber;
                string2 = verifyRequestEvent.upgradePackageDocumentRevision;
                string3 = verifyRequestEvent.upCompatibilityIndex;
            }
            object = documentObjectProxyInterface.getValidSequences(string, string2, string3);
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "The selected sequences are:" + object + "\n\ttheValidSequencesInformation: " + object);
            }
            return object;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(VerifyHelper.class, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "MoAccessException caught.aVerifyRequestEvent: " + verifyRequestEvent + "\n\tOrigin MoAccessException:" + moAccessException.toString(), moAccessException);
            throw new VerifyUpgradeWindowException(moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyUpgradeWindow(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Throwable caught.aVerifyRequestEvent: " + verifyRequestEvent + "\n\tOrigin Exception:" + throwable.toString(), throwable);
            throw new VerifyUpgradeWindowException(throwable.toString());
        }
    }

    public static Vector verifySupportedPIUs(VerifyRequestEvent verifyRequestEvent) throws VerifySupportedPIUsException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifySupportedPIUs(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        try {
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            return upgradeablePIU_HandlerInterface.collectNonSupportedPIUs(verifyRequestEvent.upgradePackageUCF_Path, verifyRequestEvent.upgradePackageDocumentNumber, verifyRequestEvent.upgradePackageDocumentRevision);
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            Trace.error(VerifyHelper.class, "verifySupportedPIUs(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent + "UpgradeablePIU_HandlerException exception caught: " + "\n\tException: " + upgradeablePIU_HandlerException.toString(), (Throwable)((Object)upgradeablePIU_HandlerException));
            throw new VerifySupportedPIUsException("verifySupportedPIUs(VerifyRequestEvent aVerifyRequestEvent)aVerifyRequestEvent: " + verifyRequestEvent + "\n\tUpgradeablePIU_HandlerException exception caught: " + "\n\tException: " + upgradeablePIU_HandlerException.toString());
        }
        catch (Exception exception) {
            Trace.error(VerifyHelper.class, "verifySupportedPIUs(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent + "Exception caught: " + "\n\tException: " + exception.toString(), exception);
            throw new VerifySupportedPIUsException("verifyOperationalPIUs(VerifyRequestEvent aVerifyRequestEvent)aVerifyRequestEvent: " + verifyRequestEvent + "\n\tException caught: " + "\n\tException: " + exception.toString());
        }
    }

    public static Vector verifyLoadModulesChecksum(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, Collection collection) throws VerifyChecksumException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyLoadModulesChecksum(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLoadModulesBeExculded: " + collection);
        }
        try {
            Object object;
            ProductNumbersAndRevisions productNumbersAndRevisions = documentObjectProxyInterface.getLoadModulesProxyInterface().getProductNumberAndRevisionOfLoadModules();
            Vector vector = new Vector();
            if (verifyRequestEvent.installedTypeOfUP.isHW_Sensitive()) {
                object = new HW_SensitiveAdapter();
                vector.addAll(((HW_SensitiveAdapter)object).getRequiredLoadModules(new File(verifyRequestEvent.upgradePackageUCF_Path), verifyRequestEvent.upgradePackageDocumentNumber, verifyRequestEvent.upgradePackageDocumentRevision, verifyRequestEvent.installedTypeOfUP.isDelta()));
                if (Trace.valid(VerifyHelper.class, 22)) {
                    Trace.debug(VerifyHelper.class, 22, "verifyLoadModulesChecksum(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "HW Sensitive installation.\n\tThe number of LMs to be installed: " + vector.size() + "\n\tThe LMs to be installed: " + vector + "\n\tThe LMs defined in the UCF: " + productNumbersAndRevisions + "\n\tThe number of LMs defined in the UCF: " + productNumbersAndRevisions.getElements().size());
                }
            } else {
                vector = productNumbersAndRevisions.getElements();
                if (Trace.valid(VerifyHelper.class, 22)) {
                    Trace.debug(VerifyHelper.class, 22, "verifyLoadModulesChecksum(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Not HW Sensitive installation.\n\tThe LMs defined in the UCF: " + productNumbersAndRevisions + "\n\tThe number of LMs defined in the UCF: " + productNumbersAndRevisions.getElements().size());
                }
            }
            object = new ChecksumHandler();
            return ((ChecksumHandler)object).checksumLoadModules(documentObjectProxyInterface, vector, collection, verifyRequestEvent);
        }
        catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "verifyLoadModulesChecksum(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "A HW_SensitiveAdapterException was caught while parsing the load modules in the UCF.aVerifyRequestEvent: " + verifyRequestEvent + "\n\tHW_SensitiveAdapterException: " + hW_SensitiveAdapterException.toString());
            }
            throw new VerifyChecksumException("A HW_SensitiveAdapterException was caught while parsing the load modules in the UCF.aVerifyRequestEvent: " + verifyRequestEvent + "\n\tHW_SensitiveAdapterException: " + hW_SensitiveAdapterException.toString());
        }
        catch (MoAccessException moAccessException) {
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "verifyLoadModulesChecksum(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "A MoAccessException was caught while parsing the load modules in the UCF.aVerifyRequestEvent: " + verifyRequestEvent + "\n\tMoAccessException reason: " + moAccessException.toString());
            }
            throw new VerifyChecksumException("A MoAccessException was caught while parsing the load modules in the UCF.aVerifyRequestEvent: " + verifyRequestEvent + "\n\ttMoAccessException reason: " + moAccessException.toString());
        }
        catch (Exception exception) {
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "verifyLoadModulesChecksum(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "An Exception was caught while parsing the load modules in the UCF.aVerifyRequestEvent: " + verifyRequestEvent + "\n\tException reason: " + exception.toString());
            }
            throw new VerifyChecksumException("An Exception was caught while parsing the load modules in the UCF.aVerifyRequestEvent: " + verifyRequestEvent + "\n\ttMoAccessException reason: " + exception.toString());
        }
    }

    public static VerifyCVsToBeCreatedResult verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, ValidSequencesInformation validSequencesInformation) throws VerifyCreationOfCVsException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation anValidSequencesInformation)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\tanValidSequencesInformation: " + validSequencesInformation);
        }
        try {
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                return VerifyHelper.verifyCreationOfUpgradeCVs(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().label);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                return VerifyHelper.verifyCreationOfUpgradeCVs(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().label);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Update)) {
                return VerifyHelper.verifyCreationOfUpdateCVs(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Update).getFirstSequenceInformation().label);
            }
            Trace.info(VerifyHelper.class, "verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation anValidSequencesInformation)", "No variant of upgrade is supported and therefor no check is done to verify that the required number of CVs is possible to create at an execution of an upgrade.\n\tanValidSequencesInformation: " + validSequencesInformation + "\n\taVerifyRequestEvent: " + verifyRequestEvent);
            return null;
        }
        catch (SequenceInformationException sequenceInformationException) {
            throw new VerifyCreationOfCVsException("verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation anValidSequencesInformation) An exception was caught at verification of upgrade CVs.\n\tException data: " + sequenceInformationException.toString());
        }
    }

    public static VerifyCVsToBeCreatedResult verifyCreationOfUpdateCVs(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String string) throws VerifyCreationOfCVsException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyCreationOfUpdateCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aLabelOfUpdateSequence)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpdateSequence: " + string);
        }
        try {
            int n = 2;
            UpdateSequenceProxyInterface updateSequenceProxyInterface = documentObjectProxyInterface.getUpdateSequenceProxyInterface();
            String string2 = updateSequenceProxyInterface.getLabel();
            if (string2 == null || !string2.equals(string)) {
                Trace.error(VerifyHelper.class, "verifyCreationOfUpdateCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aLabelOfUpdateSequence)", "Not able to find the lab\u00e9l for an update sequence as pointed out by upgrade window.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpdateSequence: " + string);
                throw new VerifyCreationOfCVsException("Not able to find an UpgradeSequenceProxyInterface for the given update sequence label argument.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpdateSequence: " + string);
            }
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            return configurationVersionMO_HandlerInterface.verifyNumberOfCVsToBeCreated(n);
        }
        catch (MoAccessException moAccessException) {
            Trace.error(VerifyHelper.class, "verifyCreationOfUpdateCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "MoAccessException caught.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpdateSequence: " + string + "\n\tOrigin MoAccessException:" + moAccessException.toString(), moAccessException);
            throw new VerifyCreationOfCVsException(moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(VerifyHelper.class, "verifyCreationOfUpdateCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Exception caught.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpdateSequence: " + string + "\n\tOrigin Exception:" + exception.toString(), exception);
            throw new VerifyCreationOfCVsException(exception.toString());
        }
    }

    public static VerifyCVsToBeCreatedResult verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String string) throws VerifyCreationOfCVsException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aLabelOfUpgradeSequence)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpgradeSequence: " + string);
        }
        try {
            int n = 3;
            UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
            UpgradeSequenceProxyInterface upgradeSequenceProxyInterface = upgradeSequencesProxyInterface.getUpgradeSequenceProxyInterface(string);
            if (upgradeSequenceProxyInterface == null) {
                Trace.error(VerifyHelper.class, "verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aLabelOfUpgradeSequence)", "Not able to find an UpgradeSequenceProxyInterface for the given upgrade sequence label argument.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpgradeSequence: " + string);
                throw new VerifyCreationOfCVsException("Not able to find an UpgradeSequenceProxyInterface for the given upgrade sequence label argument.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpgradeSequence: " + string);
            }
            int n2 = upgradeSequenceProxyInterface.getNumberOfRebootNodeUpgradeOps();
            int n3 = upgradeSequenceProxyInterface.getNumberOfRebootPiuUpgradeOps();
            if (n3 > 0) {
                n = 3;
            } else if (n2 == 1) {
                n = 3;
            } else if (n2 >= 2) {
                n = 4;
            }
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aLabelOfUpgradeSequence)", "The number of CVs to be created during the upgrade are: " + n + "\n\tThe number of RebootNodeOp's are: " + n2 + "\n\tThe number of RebootPiuOp's are: " + n3);
            }
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            return configurationVersionMO_HandlerInterface.verifyNumberOfCVsToBeCreated(n);
        }
        catch (MoAccessException moAccessException) {
            Trace.error(VerifyHelper.class, "verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "MoAccessException caught.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpgradeSequence: " + string + "\n\tOrigin MoAccessException:" + moAccessException.toString(), moAccessException);
            throw new VerifyCreationOfCVsException(moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(VerifyHelper.class, "verifyCreationOfUpgradeCVs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "Exception caught.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpgradeSequence: " + string + "\n\tOrigin Exception:" + exception.toString(), exception);
            throw new VerifyCreationOfCVsException(exception.toString());
        }
    }

    public static Vector verifyOperationalPIUs(VerifyRequestEvent verifyRequestEvent) throws VerifyOperationalPIUsException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyOperationalPIUs(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        try {
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            return upgradeablePIU_HandlerInterface.collectNonOperationalPIUs();
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            Trace.error(VerifyHelper.class, "verifyOperationalPIUs(VerifyRequestEvent aVerifyRequestEvent)", "UpgradeablePIU_HandlerException exception caught: \n\tException: " + upgradeablePIU_HandlerException.toString(), (Throwable)((Object)upgradeablePIU_HandlerException));
            throw new VerifyOperationalPIUsException("verifyOperationalPIUs(VerifyRequestEvent aVerifyRequestEvent)\n\tUpgradeablePIU_HandlerException exception caught: \n\tException: " + upgradeablePIU_HandlerException.toString());
        }
        catch (Exception exception) {
            Trace.error(VerifyHelper.class, "verifyOperationalPIUs(VerifyRequestEvent aVerifyRequestEvent)", "Exception caught: \n\tException: " + exception.toString(), exception);
            throw new VerifyOperationalPIUsException("verifyOperationalPIUs(VerifyRequestEvent aVerifyRequestEvent)\n\tException caught: \n\tException: " + exception.toString());
        }
    }

    public static ProgramsContainer verifyPgms() throws VerifyUpgradeException {
        String string = "verifyPgms ( )";
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, string, "Start Verify programs ");
        }
        try {
            int[] nArray = new int[]{0};
            VerifyProgramHandler verifyProgramHandler = new VerifyProgramHandler();
            ProgramsContainer programsContainer = verifyProgramHandler.getReportingPgms(nArray);
            return programsContainer;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, string, "A Throwable was caught at verification of startState disabled Programs.\n\tThrowable data: " + throwable, throwable);
            throw new VerifyUpgradeException(string + " An Throwable was caught at verification of startState disabled Programs." + "\n\tThrowable data: " + throwable);
        }
    }

    public static Vector verifyMainMPs(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, ValidSequencesInformation validSequencesInformation) throws VerifyMainMPsException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation anValidSequencesInformation)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\tanValidSequencesInformation: " + validSequencesInformation);
        }
        try {
            Vector vector = new Vector();
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade) && (vector = VerifyHelper.verifyMainMPs(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().label)).size() > 0) {
                Trace.warning(VerifyHelper.class, "verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation anValidSequencesInformation)", "Reboot PIU upgrade operations has been specified in a Reboot Node Upgrade sequence i.e. \n\tReboot PIU upgrade operations shall only be specified in a soft upgrade sequence.\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\tanValidSequencesInformation: " + validSequencesInformation);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade) && vector.size() == 0) {
                vector = VerifyHelper.verifyMainMPs(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().label);
            }
            return vector;
        }
        catch (SequenceInformationException sequenceInformationException) {
            throw new VerifyMainMPsException("verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation anValidSequencesInformation) An exception was caught at verification of main MPs.\n\tException data: " + sequenceInformationException.toString());
        }
    }

    public static Vector verifyMainMPs(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String string) throws VerifyMainMPsException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpgradeSequence: " + string);
        }
        try {
            if (TypeOfUpgrade.Update.getValue().equals(verifyRequestEvent.typeOfUpgrade.getValue())) {
                return new Vector();
            }
            UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
            UpgradeSequenceProxyInterface upgradeSequenceProxyInterface = upgradeSequencesProxyInterface.getUpgradeSequenceProxyInterface(string);
            if (upgradeSequenceProxyInterface == null) {
                Trace.error(VerifyHelper.class, "verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, File anUpgradeControlFile, String anLabelOfUpgradeSequence)", "Not able to find an UpgradeSequenceProxyInterface for the given upgrade sequence label argument.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpgradeSequence: " + string);
                throw new VerifyMainMPsException("Not able to find an UpgradeSequenceProxyInterface for the given upgrade sequence label argument.aVerifyRequestEvent: " + verifyRequestEvent + "\n\taLabelOfUpgradeSequence: " + string);
            }
            if (upgradeSequenceProxyInterface.getNumberOfRebootPiuUpgradeOps() > 0) {
                MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
                JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
                ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)jvmMoSU_Access.getReliableProgramUniter(null);
                int n = reliableProgramUniterMoSU_Access.getOperationalMode(null);
                Vector<MainPIU_Information> vector = new Vector<MainPIU_Information>();
                if (n != 3) {
                    SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmActiveSlot(null);
                    SlotMoSU_Access slotMoSU_Access2 = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
                    GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = VerifyHelper.getPIU(slotMoSU_Access);
                    GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit2 = VerifyHelper.getPIU(slotMoSU_Access2);
                    if (genericUpgradeablePlugInUnit != null && genericUpgradeablePlugInUnit2 != null) {
                        int n2 = genericUpgradeablePlugInUnit.getOperationalState(null);
                        int n3 = genericUpgradeablePlugInUnit.getAdministrativeState(null);
                        if (n2 != 1 || n3 != 1) {
                            vector.addElement(new MainPIU_Information(genericUpgradeablePlugInUnit, n2, n3));
                        }
                        int n4 = genericUpgradeablePlugInUnit2.getOperationalState(null);
                        int n5 = genericUpgradeablePlugInUnit2.getAdministrativeState(null);
                        if (n4 != 1 || n5 != 1) {
                            vector.addElement(new MainPIU_Information(genericUpgradeablePlugInUnit2, n4, n5));
                        }
                        if (Trace.valid(VerifyHelper.class, 20)) {
                            Trace.debug(VerifyHelper.class, 20, "verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "theOperationalStateActivePIU: " + n2 + "\n\ttheAdmStateActivePIU: " + n3 + "\n\ttheOperationalStatePassivePIU: " + n4 + "\n\ttheAdmStatePassivePIU: " + n5 + "\n\tThe JVM main MPs that have illegal state: " + vector);
                        }
                        return vector;
                    }
                    vector.addElement(new MainPIU_Information(reliableProgramUniterMoSU_Access, slotMoSU_Access, slotMoSU_Access2));
                    Trace.warning(VerifyHelper.class, "verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "The JVM is not configured as redundant i.e. PIU upgrade is not allowed to be executed.\n\ttheJVM_RPU: " + reliableProgramUniterMoSU_Access + "\n\ttheJVM_AdmActivePIU: " + genericUpgradeablePlugInUnit + "\n\ttheJVM_AdmPassivePIU: " + genericUpgradeablePlugInUnit2);
                    return vector;
                }
                vector.addElement(new MainPIU_Information(true));
                Trace.warning(VerifyHelper.class, "verifyMainMPs(VerifyRequestEvent aVerifyRequestEvent)", "The JVM RPU operational mode is unavailable i.e. PIU upgrade is not allowed to be executed.");
                return vector;
            }
            if (Trace.valid(VerifyHelper.class, 20)) {
                Trace.debug(VerifyHelper.class, 20, "verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "This is a node upgrade. Not need for verification of the status of JVM Main MP's.");
            }
            return new Vector();
        }
        catch (Exception exception) {
            Trace.error(VerifyHelper.class, "verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)", "An exception was caught at verification of main MPs.\n\tException data: " + exception.toString(), exception);
            throw new VerifyMainMPsException("verifyMainMPs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)An exception was caught at verification of main MPs.\n\tException data: " + exception.toString());
        }
    }

    private static GenericUpgradeablePlugInUnit getPIU(SlotMoSU_Access slotMoSU_Access) {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "getPIU(SlotMoSU_Access aSlotMo)", "aSlotMo: " + slotMoSU_Access);
        }
        try {
            if (slotMoSU_Access != null) {
                MoIterator moIterator = slotMoSU_Access.getChildren();
                ManagedObject managedObject = null;
                if (moIterator != null) {
                    while (moIterator.hasMoreElements()) {
                        managedObject = moIterator.nextMo();
                    }
                } else {
                    Trace.warning(VerifyHelper.class, "getPIU(SlotMoSU_Access aSlotMo)", "No PIUs assigned to this slot. Not possible to verify the preconditions.");
                    return null;
                }
                if (managedObject != null && managedObject instanceof GenericUpgradeablePlugInUnit) {
                    return (GenericUpgradeablePlugInUnit)managedObject;
                }
                Trace.info(VerifyHelper.class, "getPIU(SlotMoSU_Access aSlotMo)", "The PIU related to the given slot is not of type 'GenericUpgradeablePlugInUnit'.aSlotMo: " + slotMoSU_Access);
                return null;
            }
            Trace.info(VerifyHelper.class, "getPIU(SlotMoSU_Access aSlotMo)", "The argument aSlotMo was set to null. Not possible to find a PIU...aSlotMo: " + slotMoSU_Access);
            return null;
        }
        catch (Exception exception) {
            Trace.error(VerifyHelper.class, "getPIU(SlotMoSU_Access aSlotMo)", "Exception caught.\n\taSlotMo: " + slotMoSU_Access + "\n\tOrigin Exception:" + exception.toString(), exception);
            return null;
        }
    }

    public static CoreMPsFTC_StatusInformation verifyCoreMPs(VerifyRequestEvent verifyRequestEvent, Collection collection) throws VerifyCoreMPsException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyCoreMPs(VerifyRequestEvent aVerifyRequestEvent, Collection aSequenceInformations)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taSequenceInformations: " + collection);
        }
        CoreMPsFTC_StatusHandler coreMPsFTC_StatusHandler = new CoreMPsFTC_StatusHandler();
        return coreMPsFTC_StatusHandler.verifyFTC_State(verifyRequestEvent, collection);
    }

    public static Collection verifyRequiredLMsAreInstalled(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent) throws VerifyUpgradeException {
        String string = "verifyRequiredLMsAreInstalled(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent)";
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, string, "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        try {
            Object object;
            Collection collection = null;
            if (verifyRequestEvent.installedTypeOfUP.isHW_Sensitive()) {
                object = new HW_SensitiveAdapter();
                collection = ((HW_SensitiveAdapter)object).getRequiredLoadModules(new File(verifyRequestEvent.upgradePackageUCF_Path), verifyRequestEvent.upgradePackageDocumentNumber, verifyRequestEvent.upgradePackageDocumentRevision, verifyRequestEvent.installedTypeOfUP.isDelta());
            } else {
                collection = documentObjectProxyInterface.getLoadModulesProxyInterface().getProductNumberAndRevisionOfLoadModules().getElements();
            }
            object = collection.iterator();
            HashSet<ProductNumberAndRevision> hashSet = new HashSet<ProductNumberAndRevision>();
            ProductNumberAndRevision productNumberAndRevision = null;
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            while (object.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)object.next();
                if (loadModuleMO_HandlerInterface.isLoadModuleMatchingState(productNumberAndRevision, LoadModuleState.Installed)) continue;
                hashSet.add(productNumberAndRevision);
            }
            return hashSet;
        }
        catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\t" + string + "\n\tHW_SensitiveAdapterException caught." + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\tHW_SensitiveAdapterException: " + (Object)((Object)hW_SensitiveAdapterException));
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, string, "Throwable caught.\n\taVerifyRequestEvent: " + verifyRequestEvent, throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public static Vector verifySlotsOfPIUsConnectedToSWA(VerifyRequestEvent verifyRequestEvent) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifySlotsOfPIUsConnectedToSWA(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        Vector<PiuTypeMoData> vector = new Vector<PiuTypeMoData>(1);
        try {
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            Collection collection = pIU_MO_HandlerInterface.getAllPIU_MOs();
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
            Collection collection2 = swAllocationMO_HandlerInterface.getContentsOfAllSlotLists();
            Iterator iterator = collection.iterator();
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            PiuTypeMoData piuTypeMoData = null;
            while (iterator.hasNext()) {
                plugInUnitMoSU_Access = (PlugInUnitMoSU_Access)iterator.next();
                if (collection2.contains(pIU_MO_HandlerInterface.getSlotMO(plugInUnitMoSU_Access))) continue;
                piuTypeMoSU_Access = pIU_MO_HandlerInterface.getPiuTypeMO((GenericUpgradeablePlugInUnit)plugInUnitMoSU_Access);
                piuTypeMoData = piuTypeMoSU_Access != null ? piuTypeMO_HandlerInterface.getPiuTypeData(piuTypeMoSU_Access) : new PiuTypeMoData(null, null, null);
                piuTypeMoData.setPlugInUnit((GenericUpgradeablePlugInUnit)plugInUnitMoSU_Access);
                vector.add(piuTypeMoData);
                if (!Trace.valid(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22)) continue;
                Trace.debug(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22, "verifySlotsOfPIUsConnectedToSWA(VerifyRequestEvent aVerifyRequestEvent)", "The Slot MO related to PlugInUnit MO'" + plugInUnitMoSU_Access + "' is not connected to an SwAllocation MO." + "\n\tPiuType data for this plugInUnit: " + piuTypeMoData);
            }
            if (Trace.valid(VerifyHelper.class, 21)) {
                Trace.debug(VerifyHelper.class, 21, "verifySlotsOfPIUsConnectedToSWA(VerifyRequestEvent aVerifyRequestEvent)", "RETURNS - " + vector);
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(VerifyHelper.class, "verifySlotsOfPIUsConnectedToSWA(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent + "MoAccessException caught: " + "\n\tMoAccessException: " + moAccessException.toString(), moAccessException);
            throw new VerifyUpgradeException("verifySlotsOfPIUsConnectedToSWA(VerifyRequestEvent aVerifyRequestEvent)aVerifyRequestEvent: " + verifyRequestEvent + "\n\tMoAccessException caught: " + "\n\tMoAccessException: " + moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifySlotsOfPIUsConnectedToSWA(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent + "Throwable caught: " + "\n\tThrowable: " + throwable.toString(), throwable);
            throw new VerifyUpgradeException("verifySlotsOfPIUsConnectedToSWA(VerifyRequestEvent aVerifyRequestEvent)aVerifyRequestEvent: " + verifyRequestEvent + "\n\tThrowable caught: " + "\n\tThrowable: " + throwable.toString());
        }
    }

    public static Collection verifyLM_TypesInSWA_Connections(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String string) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyLM_TypesInSWA_Connections(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aCase)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string);
        }
        try {
            LinkedList linkedList = new LinkedList();
            RepertoireReplacementsProxyInterface repertoireReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface().getRepertoireReplacementsProxyInterface(string);
            Collection collection = repertoireReplacementsProxyInterface.getRepertoireReplacementsData();
            RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
            HashSet hashSet = new HashSet(repertoiresProxyInterface.getRepertoireNames());
            LoadModulesWithLoaderNamesInformation loadModulesWithLoaderNamesInformation = VerifyHelper.getLMsOfTypesJVM_WebServerAndOther(documentObjectProxyInterface);
            Collection collection2 = VerifyHelper.verifyLM_TypesInSWA_ConnectionsForJVM_AndWebServerAndActiveOtherLMsMOs(collection, repertoiresProxyInterface, hashSet, loadModulesWithLoaderNamesInformation);
            linkedList.addAll(collection2);
            Collection collection3 = repertoiresProxyInterface.getNamesOfRepertoiresReferencingLMs(loadModulesWithLoaderNamesInformation.getLoadModules());
            Collection collection4 = VerifyHelper.verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(collection, hashSet, collection3);
            linkedList.addAll(collection4);
            return linkedList;
        }
        catch (VerifyUpgradeException verifyUpgradeException) {
            throw verifyUpgradeException;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyLM_TypesInSWA_Connections(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aCase)", "Throwable caught.\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string, throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tverifyLM_TypesInSWA_Connections(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aCase)" + "\n\tThrowable caught." + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private static LoadModulesWithLoaderNamesInformation getLMsOfTypesJVM_WebServerAndOther(DocumentObjectProxyInterface documentObjectProxyInterface) {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "getLMsOfTypesJVM_WebServerAndOther(DocumentObjectProxyInterface aDocumentObjectProxy)", "aDocumentObjectProxy: " + documentObjectProxyInterface);
        }
        HashSet<LoaderName> hashSet = new HashSet<LoaderName>();
        hashSet.add(LoaderName.JVM);
        hashSet.add(LoaderName.Webserver);
        hashSet.add(LoaderName.Other);
        LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
        return loadModulesProxyInterface.getLoadModulesWithLoaderNamesInformation(hashSet, true);
    }

    private static Collection verifyLM_TypesInSWA_ConnectionsForJVM_AndWebServerAndActiveOtherLMsMOs(Collection collection, RepertoiresProxyInterface repertoiresProxyInterface, Collection collection2, LoadModulesWithLoaderNamesInformation loadModulesWithLoaderNamesInformation) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyLM_TypesInSWA_ConnectionsForJVM_AndWebServerAndActiveOtherLMsMOs(Collection aRepertoireReplacementData, RepertoiresProxyInterface aRepertoiresProxy, Collection aRepertoiresInTheUCF, LoadModulesWithLoaderNamesInformation anLMsOfTypesJVM_WebServerAndOther)", "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresProxy: " + repertoiresProxyInterface + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\tanLMsOfTypesJVM_WebServerAndOther: " + loadModulesWithLoaderNamesInformation);
        }
        try {
            ActiveOtherLMsMO_HandlerInterface activeOtherLMsMO_HandlerInterface;
            WebServerMO_HandlerInterface webServerMO_HandlerInterface;
            LinkedList<NotAllowedLM_TypesInSWA_ConnectionsInformation> linkedList = new LinkedList<NotAllowedLM_TypesInSWA_ConnectionsInformation>();
            JvmMoSU_Access jvmMoSU_Access = null;
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            SwAllocationMoSU_Access swAllocationMoSU_Access = jvmMO_HandlerInterface.getReferencedSwAllocationMo();
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
            ProductNumbersAndRevisions productNumbersAndRevisions = null;
            NotAllowedLM_TypesInSWA_ConnectionsInformation notAllowedLM_TypesInSWA_ConnectionsInformation = null;
            if (swAllocationMoSU_Access != null && (notAllowedLM_TypesInSWA_ConnectionsInformation = VerifyHelper.verifyLM_TypesInSWA_ConnectionsForJVM_OrWebServerOrActiveOtherLMsMOs((ManagedObject)(jvmMoSU_Access = jvmMO_HandlerInterface.getJvmMO()), swAllocationMoSU_Access, swAllocationMO_HandlerInterface, collection, repertoiresProxyInterface, collection2, productNumbersAndRevisions = loadModulesWithLoaderNamesInformation.getLoadModules(LoaderName.JVM))) != null) {
                linkedList.add(notAllowedLM_TypesInSWA_ConnectionsInformation);
            }
            if ((swAllocationMoSU_Access = (webServerMO_HandlerInterface = ServiceFinder.getWebServerMO_HandlerInterface()).getReferencedSwAllocationMo()) != null && (notAllowedLM_TypesInSWA_ConnectionsInformation = VerifyHelper.verifyLM_TypesInSWA_ConnectionsForJVM_OrWebServerOrActiveOtherLMsMOs((ManagedObject)(jvmMoSU_Access = webServerMO_HandlerInterface.getWebserverMO()), swAllocationMoSU_Access, swAllocationMO_HandlerInterface, collection, repertoiresProxyInterface, collection2, productNumbersAndRevisions = loadModulesWithLoaderNamesInformation.getLoadModulesAndViewFileLoadModules(LoaderName.Webserver))) != null) {
                linkedList.add(notAllowedLM_TypesInSWA_ConnectionsInformation);
            }
            if ((swAllocationMoSU_Access = (activeOtherLMsMO_HandlerInterface = ServiceFinder.getActiveOtherLMsMO_HandlerInterface()).getReferencedSwAllocationMo()) != null && (notAllowedLM_TypesInSWA_ConnectionsInformation = VerifyHelper.verifyLM_TypesInSWA_ConnectionsForJVM_OrWebServerOrActiveOtherLMsMOs((ManagedObject)(jvmMoSU_Access = (ManagedObject)activeOtherLMsMO_HandlerInterface.getActiveOtherLMsMO()), swAllocationMoSU_Access, swAllocationMO_HandlerInterface, collection, repertoiresProxyInterface, collection2, productNumbersAndRevisions = loadModulesWithLoaderNamesInformation.getLoadModules(LoaderName.Other))) != null) {
                linkedList.add(notAllowedLM_TypesInSWA_ConnectionsInformation);
            }
            return linkedList;
        }
        catch (VerifyUpgradeException verifyUpgradeException) {
            throw verifyUpgradeException;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyLM_TypesInSWA_ConnectionsForJVM_AndWebServerAndActiveOtherLMsMOs(Collection aRepertoireReplacementData, RepertoiresProxyInterface aRepertoiresProxy, Collection aRepertoiresInTheUCF, LoadModulesWithLoaderNamesInformation anLMsOfTypesJVM_WebServerAndOther)", "Throwable caught.\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresProxy: " + repertoiresProxyInterface + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\tanLMsOfTypesJVM_WebServerAndOther: " + loadModulesWithLoaderNamesInformation, throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tverifyLM_TypesInSWA_ConnectionsForJVM_AndWebServerAndActiveOtherLMsMOs(Collection aRepertoireReplacementData, RepertoiresProxyInterface aRepertoiresProxy, Collection aRepertoiresInTheUCF, LoadModulesWithLoaderNamesInformation anLMsOfTypesJVM_WebServerAndOther)" + "\n\tThrowable caught." + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresProxy: " + repertoiresProxyInterface + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\tanLMsOfTypesJVM_WebServerAndOther: " + loadModulesWithLoaderNamesInformation + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private static NotAllowedLM_TypesInSWA_ConnectionsInformation verifyLM_TypesInSWA_ConnectionsForJVM_OrWebServerOrActiveOtherLMsMOs(ManagedObject managedObject, SwAllocationMoSU_Access swAllocationMoSU_Access, SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface, Collection collection, RepertoiresProxyInterface repertoiresProxyInterface, Collection collection2, ProductNumbersAndRevisions productNumbersAndRevisions) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyLM_TypesInSWA_ConnectionsForJVM_OrWebServerOrActiveOtherLMsMOs(ManagedObject aConnectedMO, SwAllocationMoSU_Access anSwAllocationMo, SwAllocationMO_HandlerInterface anSwAllocationMO_Handler, Collection aRepertoireReplacementData, RepertoiresProxyInterface aRepertoiresProxy, Collection aRepertoiresInTheUCF, ProductNumbersAndRevisions aProductNumbersAndRevisionsOfAllowedLMs)", "aConnectedMO: " + managedObject + "\n\tanSwAllocationMo: " + swAllocationMoSU_Access + "\n\tanSwAllocationMO_Handler: " + swAllocationMO_HandlerInterface + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresProxy: " + repertoiresProxyInterface + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taProductNumbersAndRevisionsOfAllowedLMs: " + productNumbersAndRevisions);
        }
        try {
            Collection collection3 = swAllocationMO_HandlerInterface.getRepertoiresToBeConnected(swAllocationMoSU_Access, collection, collection2);
            Collection collection4 = repertoiresProxyInterface.extractRepertoiresReferencingNotExpectedLMs(collection3, productNumbersAndRevisions);
            if (collection4.isEmpty()) {
                return null;
            }
            HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
            hashSet.add(managedObject);
            return new NotAllowedLM_TypesInSWA_ConnectionsInformation(swAllocationMoSU_Access, hashSet, collection4);
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyLM_TypesInSWA_ConnectionsForJVM_OrWebServerOrActiveOtherLMsMOs(ManagedObject aConnectedMO, SwAllocationMoSU_Access anSwAllocationMo, SwAllocationMO_HandlerInterface anSwAllocationMO_Handler, Collection aRepertoireReplacementData, RepertoiresProxyInterface aRepertoiresProxy, Collection aRepertoiresInTheUCF, ProductNumbersAndRevisions aProductNumbersAndRevisionsOfAllowedLMs)", "Throwable caught.\n\taConnectedMO: " + managedObject + "\n\tanSwAllocationMo: " + swAllocationMoSU_Access + "\n\tanSwAllocationMO_Handler: " + swAllocationMO_HandlerInterface + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresProxy: " + repertoiresProxyInterface + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taProductNumbersAndRevisionsOfAllowedLMs: " + productNumbersAndRevisions, throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tverifyLM_TypesInSWA_ConnectionsForJVM_OrWebServerOrActiveOtherLMsMOs(ManagedObject aConnectedMO, SwAllocationMoSU_Access anSwAllocationMo, SwAllocationMO_HandlerInterface anSwAllocationMO_Handler, Collection aRepertoireReplacementData, RepertoiresProxyInterface aRepertoiresProxy, Collection aRepertoiresInTheUCF, ProductNumbersAndRevisions aProductNumbersAndRevisionsOfAllowedLMs)" + "\n\tThrowable caught." + "\n\taConnectedMO: " + managedObject + "\n\tanSwAllocationMo: " + swAllocationMoSU_Access + "\n\tanSwAllocationMO_Handler: " + swAllocationMO_HandlerInterface + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresProxy: " + repertoiresProxyInterface + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taProductNumbersAndRevisionsOfAllowedLMs: " + productNumbersAndRevisions + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private static Collection verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(Collection collection, Collection collection2, Collection collection3) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF, Collection aRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther)", "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther: " + collection3);
        }
        try {
            LinkedList<NotAllowedLM_TypesInSWA_ConnectionsInformation> linkedList = new LinkedList<NotAllowedLM_TypesInSWA_ConnectionsInformation>();
            HashMap hashMap = VerifyHelper.getSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap();
            if (Trace.valid(VerifyHelper.class, 20)) {
                Trace.debug(VerifyHelper.class, 20, "verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF, Collection aRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther)", "theSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap: " + hashMap);
            }
            Iterator iterator = hashMap.keySet().iterator();
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
            NotAllowedLM_TypesInSWA_ConnectionsInformation notAllowedLM_TypesInSWA_ConnectionsInformation = null;
            while (iterator.hasNext()) {
                swAllocationMoSU_Access = (SwAllocationMoSU_Access)iterator.next();
                notAllowedLM_TypesInSWA_ConnectionsInformation = VerifyHelper.verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(swAllocationMoSU_Access, swAllocationMO_HandlerInterface, collection, collection2, collection3, hashMap);
                if (notAllowedLM_TypesInSWA_ConnectionsInformation == null) continue;
                linkedList.add(notAllowedLM_TypesInSWA_ConnectionsInformation);
            }
            if (Trace.valid(VerifyHelper.class, 21)) {
                Trace.debug(VerifyHelper.class, 21, "verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF, Collection aRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther)", "RETURNS - " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(Collection aRepertoireReplacementData, Collection aRepertoiresInTheUCF, Collection aRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther)", "Throwable caught.\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther: " + collection3, throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tverifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF, Collection aRepertoiresReferencingLMsOfNotAllowedTypes)" + "\n\tThrowable caught." + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther: " + collection3 + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private static HashMap getSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap() throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "getSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap( )");
        }
        try {
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            HashMap hashMap = upgradeablePIU_HandlerInterface.getSWA_MOsConnectedToUpgradeablePIUsMap();
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            HashMap hashMap2 = slotMO_HandlerInterface.getSWA_MOsConnectedToFreeSlotsMap();
            Iterator iterator = hashMap2.keySet().iterator();
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            HashSet hashSet = null;
            HashSet hashSet2 = null;
            while (iterator.hasNext()) {
                swAllocationMoSU_Access = (SwAllocationMoSU_Access)iterator.next();
                hashSet2 = (HashSet)hashMap2.get(swAllocationMoSU_Access);
                hashSet = (HashSet)hashMap.get(swAllocationMoSU_Access);
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.addAll(hashSet2);
                hashMap.put(swAllocationMoSU_Access, hashSet);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "getSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap( )", "Throwable caught.", throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tgetSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap( )" + "\n\tThrowable caught." + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private static NotAllowedLM_TypesInSWA_ConnectionsInformation verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(SwAllocationMoSU_Access swAllocationMoSU_Access, SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface, Collection collection, Collection collection2, Collection collection3, HashMap hashMap) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(SwAllocationMoSU_Access anSwAllocationMo, SwAllocationMO_HandlerInterface anSwAllocationMO_Handler, Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF, Collection aRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther, HashMap anSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap)", "anSwAllocationMo: " + swAllocationMoSU_Access + "\n\tanSwAllocationMO_Handler: " + swAllocationMO_HandlerInterface + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther: " + collection3 + "\n\tanSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap: " + hashMap);
        }
        try {
            Collection collection4 = swAllocationMO_HandlerInterface.getRepertoiresToBeConnected(swAllocationMoSU_Access, collection, collection2);
            Iterator iterator = collection4.iterator();
            String string = null;
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (!collection3.contains(string)) continue;
                hashSet.add(string);
            }
            if (hashSet.isEmpty()) {
                return null;
            }
            Iterator iterator2 = ((Collection)hashMap.get(swAllocationMoSU_Access)).iterator();
            HashSet<ManagedObject> hashSet2 = new HashSet<ManagedObject>();
            Object e = null;
            ManagedObject managedObject = null;
            while (iterator2.hasNext()) {
                e = iterator2.next();
                if (!(e instanceof SlotMoSU_Access)) {
                    if (e instanceof ManagedObject) {
                        managedObject = ((ManagedObject)e).getParent();
                        if (managedObject != null && managedObject instanceof SlotMoSU_Access) {
                            hashSet2.add(managedObject);
                            continue;
                        }
                        hashSet2.add((ManagedObject)e);
                        continue;
                    }
                    hashSet2.add((ManagedObject)e);
                    continue;
                }
                hashSet2.add((ManagedObject)e);
            }
            return new NotAllowedLM_TypesInSWA_ConnectionsInformation(swAllocationMoSU_Access, hashSet2, hashSet);
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "verifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(SwAllocationMoSU_Access anSwAllocationMo, SwAllocationMO_HandlerInterface anSwAllocationMO_Handler, Collection aRepertoireReplacementData, Collection aRepertoiresInTheUCF, Collection aRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther, HashMap anSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap)", "Throwable caught.\n\tanSwAllocationMo: " + swAllocationMoSU_Access + "\n\tanSwAllocationMO_Handler: " + swAllocationMO_HandlerInterface + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther: " + collection3 + "\n\tanSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap: " + hashMap, throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tverifyLM_TypesInSWA_ConnectionsForUpgradeablePIUsAndFreeSlots(SwAllocationMoSU_Access anSwAllocationMo, SwAllocationMO_HandlerInterface anSwAllocationMO_Handler, Collection aRepertoireReplacementData, Collection aRepertoireNamesInUCF, Collection aRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther, HashMap anSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap)" + "\n\tThrowable caught." + "\n\tanSwAllocationMo: " + swAllocationMoSU_Access + "\n\tanSwAllocationMO_Handler: " + swAllocationMO_HandlerInterface + "\n\taRepertoireReplacementData: " + collection + "\n\taRepertoiresInTheUCF: " + collection2 + "\n\taRepertoiresReferencingLMsOfTypesJVM_WebServerOrOther: " + collection3 + "\n\tanSWA_MOsConnectedToUpgradeablePIUsOrFreeSlotsMap: " + hashMap + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public static Collection verifyLM_TypesInSWA_Connections(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, ValidSequencesInformation validSequencesInformation) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyLM_TypesInSWA_Connections(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation aValidSequencesInformation)", "aVerifyRequestEvent: " + verifyRequestEvent + "\n\taValidSequencesInformation: " + validSequencesInformation);
        }
        try {
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                return VerifyHelper.verifyLM_TypesInSWA_Connections(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                return VerifyHelper.verifyLM_TypesInSWA_Connections(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Update)) {
                return VerifyHelper.verifyLM_TypesInSWA_Connections(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Update).getFirstSequenceInformation().currentCase);
            }
            Trace.info(VerifyHelper.class, "verifyLM_TypesInSWA_Connections(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor no check is done to verify that the SWA connections are allowed at the execution of an upgrade.\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taValidSequencesInformation: " + validSequencesInformation);
            return new HashSet();
        }
        catch (SequenceInformationException sequenceInformationException) {
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tverifyLM_TypesInSWA_Connections(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent aVerifyRequestEvent, String aCase)" + "\n\tThrowable caught." + "\n\taVerifyRequestEvent: " + verifyRequestEvent + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\tOriginal Throwable: " + (Object)((Object)sequenceInformationException));
        }
        catch (VerifyUpgradeException verifyUpgradeException) {
            throw verifyUpgradeException;
        }
    }

    public static UcfDataContainer initMultipleSwaConfigValidation(DocumentObjectProxyInterface documentObjectProxyInterface, String string) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "initMultipleSwaConfigValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aCase)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taCase: " + string);
        }
        return VerifyHelper.initMultipleSwaConfigValidation(documentObjectProxyInterface, null, string);
    }

    public static UcfDataContainer initMultipleSwaConfigValidation(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String string) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "initMultipleSwaConfigValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String aCase)", "verifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string);
        }
        try {
            MultipleSwaVerifier multipleSwaVerifier = new MultipleSwaVerifier();
            UcfDataContainer ucfDataContainer = multipleSwaVerifier.initiateValidation(VerifyHelper.getRepertoireReplacementData(documentObjectProxyInterface, string), VerifyHelper.getRepertoireNamesInUCF(documentObjectProxyInterface), documentObjectProxyInterface.getRepertoiresProxyInterface());
            if (Trace.valid(VerifyHelper.class, 21)) {
                Trace.debug(VerifyHelper.class, 21, "initMultipleSwaConfigValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String aCase)", "RETURNS - " + ucfDataContainer);
            }
            return ucfDataContainer;
        }
        catch (VerifyUpgradeException verifyUpgradeException) {
            if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "initMultipleSwaConfigValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String aCase)", "VerifyUpgradeException caught: " + (Object)((Object)verifyUpgradeException));
            }
            throw verifyUpgradeException;
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "initMultipleSwaConfigValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String aCase)", "Throwable caught.\n\tverifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string, throwable);
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tinitMultipleSwaConfigValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, String aCase)" + "\n\tThrowable caught." + "\n\tVerifyRequestEvent: " + verifyRequestEvent + "\n\taCase: " + string + "\n\tOriginal Throwable: " + throwable);
        }
    }

    public static UcfDataContainer initMultipleSwaConfigValidation(DocumentObjectProxyInterface documentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, ValidSequencesInformation validSequencesInformation) throws VerifyUpgradeException, SequenceInformationException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "initMultipleSwaValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, ValidSequencesInformation validSequencesInformation)", "verifyRequestEvent: " + verifyRequestEvent + "\n\tvalidSequencesInformation: " + validSequencesInformation);
        }
        try {
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                return VerifyHelper.initMultipleSwaConfigValidation(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                return VerifyHelper.initMultipleSwaConfigValidation(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Update)) {
                return VerifyHelper.initMultipleSwaConfigValidation(documentObjectProxyInterface, verifyRequestEvent, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Update).getFirstSequenceInformation().currentCase);
            }
            Trace.info(VerifyHelper.class, "initMultipleSwaConfigValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, ValidSequencesInformation validSequencesInformation)", "No variant of upgrade is supported, consequently no check is done to verify that the Repertoires PiuTypeList are consistent at the execution of an upgrade.\n\tVerifyRequestEvent: " + verifyRequestEvent + "\n\tValidSequencesInformation: " + validSequencesInformation);
            return null;
        }
        catch (VerifyUpgradeException verifyUpgradeException) {
            throw new VerifyUpgradeException("Class name: " + VerifyHelper.class.getName() + "\n\tinitMultipleSwaConfigValidation(DocumentObjectProxyInterface aDocumentObjectProxyInterface, VerifyRequestEvent verifyRequestEvent, ValidSequencesInformation validSequencesInformation)" + "\n\tThrowable caught." + "\n\tVerifyRequestEvent: " + verifyRequestEvent + "\n\tValidSequencesInformation: " + validSequencesInformation + "\n\tOriginal Throwable: " + (Object)((Object)verifyUpgradeException));
        }
    }

    public static Collection verifyPiuTypeLoadLists(UcfDataContainer ucfDataContainer) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyPiuTypeLoadLists(UcfDataContainer ucfDataContainer)");
        }
        return VerifyHelper.verifyPiuTypeLoadLists(null, ucfDataContainer);
    }

    public static Collection verifyPiuTypeLoadLists(VerifyRequestEvent verifyRequestEvent, UcfDataContainer ucfDataContainer) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyPiuTypeLoadLists(VerifyRequestEvent aVerifyRequestEvent, UcfDataContainer ucfDataContainer)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        Collection collection = new LinkedList();
        if (ucfDataContainer != null) {
            MultipleSwaVerifier multipleSwaVerifier = new MultipleSwaVerifier();
            collection = multipleSwaVerifier.getInconsistentPiuTypeLoadLists(verifyRequestEvent, ucfDataContainer);
        }
        return collection;
    }

    public static Collection verifyPiuTypeOverlapp(UcfDataContainer ucfDataContainer) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyPiuTypeOverlapp(UcfDataContainer ucfDataContainer)");
        }
        return VerifyHelper.verifyPiuTypeOverlapp(null, ucfDataContainer);
    }

    public static Collection verifyPiuTypeOverlapp(VerifyRequestEvent verifyRequestEvent, UcfDataContainer ucfDataContainer) throws VerifyUpgradeException {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "verifyPiuTypeOverlapp(VerifyRequestEvent aVerifyRequestEvent, UcfDataContainer ucfDataContainer)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        Collection collection = new LinkedList();
        if (ucfDataContainer != null) {
            MultipleSwaVerifier multipleSwaVerifier = new MultipleSwaVerifier();
            collection = multipleSwaVerifier.getOverlappingPiuTypeDefinitions(verifyRequestEvent, ucfDataContainer);
        }
        return collection;
    }

    public static boolean checkIfPossibleToExecuteAnUpgrade(ValidSequencesInformation validSequencesInformation, VerifyCVsToBeCreatedResult verifyCVsToBeCreatedResult, FailedLoadModulesChecksumErrorInformation failedLoadModulesChecksumErrorInformation, FailedUCFChecksumErrorInformation failedUCFChecksumErrorInformation, FailedUCFChecksumErrorInformation failedUCFChecksumErrorInformation2, Vector vector, CoreMPsFTC_StatusInformation coreMPsFTC_StatusInformation, Vector vector2, ProgramsContainer programsContainer, Collection collection, Collection collection2, Collection collection3, Collection collection4, ProgramInconsistencyInformations programInconsistencyInformations, C_AUE_InconsistencyInformationsContainer c_AUE_InconsistencyInformationsContainer, SSW_ValidationInformation sSW_ValidationInformation, Collection collection5, Collection collection6, Collection collection7) {
        Vector vector3;
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "checkIfPossibleToExecuteAnUpgrade(ValidSequencesInformation anValidSequencesInformation, VerifyCVsToBeCreatedResult aVerifyCVsToBeCreatedResult, FailedLoadModulesChecksumErrorInformation aFailedLoadModulesChecksumErrorInformation, Vector aFaultyMainMPs, CoreMPsFTC_StatusInformation aCoreMPsFTC_StatusInformation,ProgramsContainer aReportedPgms, Collection aSubracksNotSupportedInformation, Collection aPiuTypeLoadListInformation, Collection aPiuTypeOverlappInformation, ProgramConsistencyInformations aProgramConsistencyInformations, Collection aMAO_LayerNotSupportingUCF_Datas, Collection aConnectedC_AUE_Repertoires, Collection aProgramsWithRefToMissingLMInfos)", "anValidSequencesInformation: " + validSequencesInformation + "\n\taVerifyCVsToBeCreatedResult: " + verifyCVsToBeCreatedResult + "\n\taFailedLoadModulesChecksumErrorInformation: " + failedLoadModulesChecksumErrorInformation + "\n\tanOrigFailedUCFChecksumErrorInformation: " + failedUCFChecksumErrorInformation + "\n\taCurrentFailedUCFChecksumErrorInformation: " + failedUCFChecksumErrorInformation2 + "\n\taFaultyMainMPs: " + vector + "\n\taCoreMPsFTC_StatusInformation,: " + coreMPsFTC_StatusInformation + "\n\taNonSupportedPIUsWithPgmAndInitialConfig: " + vector2 + "\n\taReportedPgms: " + programsContainer + "\n\taSubracksNotSupportedInformation: " + collection + "\n\taNotAllowedLM_TypesInSWA_Connections: " + collection2 + "\n\taPiuTypeLoadListInformation: " + collection3 + "\n\taPiuTypeOverlappInformation: " + collection4 + "\n\taProgramConsistencyInformations: " + programInconsistencyInformations + "\n\taC_AUE_InconsistencyInformationsContainer: " + c_AUE_InconsistencyInformationsContainer + "\n\taSSW_ValidationInformation: " + sSW_ValidationInformation + "\n\taMAO_LayerNotSupportingUCF_Datas: " + collection5 + "\n\taConnectedC_AUE_Repertoires: " + collection6 + "\n\taProgramsWithRefToMissingLMInfos: " + collection7);
        }
        if (!validSequencesInformation.isAnyUpgradeVariantSupported()) {
            return false;
        }
        if (!failedUCFChecksumErrorInformation.isChecksumMatched()) {
            return false;
        }
        if (!failedUCFChecksumErrorInformation2.isChecksumMatched()) {
            return false;
        }
        if (failedLoadModulesChecksumErrorInformation.isUpInstalled() && !failedLoadModulesChecksumErrorInformation.getChecksumErrorsLoadModules().isEmpty()) {
            return false;
        }
        if (verifyCVsToBeCreatedResult == null || !verifyCVsToBeCreatedResult.getValue().equals(VerifyCVsToBeCreatedResult.Confirmed.getValue())) {
            return false;
        }
        if (!(vector.isEmpty() || validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade) || validSequencesInformation.isSupported(TypeOfUpgrade.Update))) {
            return false;
        }
        if (!vector2.isEmpty()) {
            return false;
        }
        if (coreMPsFTC_StatusInformation.possibleUpgradeScenario == 2) {
            return false;
        }
        if (programsContainer != null && (vector3 = programsContainer.getPrograms("MoRemovedException")).size() > 0) {
            return false;
        }
        if (!collection.isEmpty()) {
            return false;
        }
        if (!collection2.isEmpty()) {
            return false;
        }
        if (collection3 == null || !collection3.isEmpty()) {
            return false;
        }
        if (collection4 == null || !collection4.isEmpty()) {
            return false;
        }
        if (!programInconsistencyInformations.isProgramInstancesConsistent()) {
            return false;
        }
        if (!programInconsistencyInformations.isMandatoryLoaderDataConsistent()) {
            return false;
        }
        if (!programInconsistencyInformations.isLoaderNamesAllowedForProgramParents()) {
            return false;
        }
        if (!validSequencesInformation.isSupported(TypeOfUpgrade.Update) && VerifyHelper.isC_AUEsInconsistencyStoppingAnyUpgrade(c_AUE_InconsistencyInformationsContainer)) {
            return false;
        }
        if (!collection5.isEmpty()) {
            return false;
        }
        if (sSW_ValidationInformation.getResult() == 1 || sSW_ValidationInformation.isAnySswIndicationIndicatingErrorsForUpgrade()) {
            return false;
        }
        if (!collection6.isEmpty()) {
            return false;
        }
        return collection7.isEmpty();
    }

    public static boolean checkIfPossibleToExecuteAnUpgrade(SequenceInformation sequenceInformation, VerifyCVsToBeCreatedResult verifyCVsToBeCreatedResult, FailedLoadModulesChecksumErrorInformation failedLoadModulesChecksumErrorInformation, FailedUCFChecksumErrorInformation failedUCFChecksumErrorInformation, FailedUCFChecksumErrorInformation failedUCFChecksumErrorInformation2, Vector vector, CoreMPsFTC_StatusInformation coreMPsFTC_StatusInformation, TypeOfUpgrade typeOfUpgrade, Vector vector2, ProgramsContainer programsContainer, Collection collection, Collection collection2, Collection collection3, Collection collection4, ProgramInconsistencyInformations programInconsistencyInformations, C_AUE_InconsistencyInformationsContainer c_AUE_InconsistencyInformationsContainer, SSW_ValidationInformation sSW_ValidationInformation, Collection collection5, Collection collection6, Collection collection7) {
        Vector vector3;
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "checkIfPossibleToExecuteAnUpgrade(SequenceInformation aSequenceInformation, VerifyCVsToBeCreatedResult aVerifyCVsToBeCreatedResult, FailedLoadModulesChecksumErrorInformation aFailedLoadModulesChecksumErrorInformation, Vector aFaultyMainMPs, CoreMPsFTC_StatusInformation aCoreMPsFTC_StatusInformation, TypeOfUpgrade aTypeOfUpgrade,ProgramsContainer aReportedPgms, Collection aSubracksNotSupportedInformation, Collection aPiuTypeLoadListInformation, Collection aPiuTypeOverlappInformation, ProgramConsistencyInformations aProgramConsistencyInformations, C_AUE_InconsistencyInformationsContainer aC_AUE_InconsistencyInformationsContainer, SSW_ValidationInformation aSSW_ValidationInformation, Collection aMAO_LayerNotSupportingUCF_Datas, Collection aConnectedC_AUE_Repertoires, Collection aProgramsWithRefToMissingLMInfos)", "aSequenceInformation: " + sequenceInformation + "\n\taVerifyCVsToBeCreatedResult: " + verifyCVsToBeCreatedResult + "\n\taFailedLoadModulesChecksumErrorInformation: " + failedLoadModulesChecksumErrorInformation + "\n\tanOrigFailedUCFChecksumErrorInformation: " + failedUCFChecksumErrorInformation + "\n\taCurrentFailedUCFChecksumErrorInformation: " + failedUCFChecksumErrorInformation2 + "\n\taFaultyMainMPs: " + vector + "\n\taCoreMPsFTC_StatusInformation,: " + coreMPsFTC_StatusInformation + "\n\taTypeOfUpgrade: " + typeOfUpgrade + "\n\taNonSupportedPIUsWithPgmAndInitialConfig: " + vector2 + "\n\taReportedPgms: " + programsContainer + "\n\taSubracksNotSupportedInformation: " + collection + "\n\taNotAllowedLM_TypesInSWA_Connections: " + collection2 + "\n\taPiuTypeLoadListInformation: " + collection3 + "\n\taPiuTypeOverlappInformation: " + collection4 + "\n\taProgramConsistencyInformations: " + programInconsistencyInformations + "\n\taC_AUE_InconsistencyInformationsContainer: " + c_AUE_InconsistencyInformationsContainer + "\n\taSSW_ValidationInformation: " + sSW_ValidationInformation + "\n\taMAO_LayerNotSupportingUCF_Datas: " + collection5 + "\n\taConnectedC_AUE_Repertoires: " + collection6 + "\n\taProgramsWithRefToMissingLMInfos: " + collection7);
        }
        if (sequenceInformation == null || sequenceInformation.label == null || sequenceInformation.label.equals("")) {
            return false;
        }
        if (!failedUCFChecksumErrorInformation.isChecksumMatched()) {
            return false;
        }
        if (!failedUCFChecksumErrorInformation2.isChecksumMatched()) {
            return false;
        }
        if (failedLoadModulesChecksumErrorInformation.isUpInstalled() && !failedLoadModulesChecksumErrorInformation.getChecksumErrorsLoadModules().isEmpty()) {
            return false;
        }
        if (verifyCVsToBeCreatedResult == null || !verifyCVsToBeCreatedResult.getValue().equals(VerifyCVsToBeCreatedResult.Confirmed.getValue())) {
            return false;
        }
        if (!vector.isEmpty()) {
            return false;
        }
        if (!vector2.isEmpty()) {
            return false;
        }
        if (coreMPsFTC_StatusInformation.possibleUpgradeScenario == 2) {
            return false;
        }
        if (programsContainer != null && (vector3 = programsContainer.getPrograms("MoRemovedException")).size() > 0) {
            return false;
        }
        if (!collection.isEmpty()) {
            return false;
        }
        if (!collection2.isEmpty()) {
            return false;
        }
        if (collection3 == null || !collection3.isEmpty()) {
            return false;
        }
        if (collection4 == null || !collection4.isEmpty()) {
            return false;
        }
        if (!programInconsistencyInformations.isProgramInstancesConsistent()) {
            return false;
        }
        if (!programInconsistencyInformations.isMandatoryLoaderDataConsistent()) {
            return false;
        }
        if (!programInconsistencyInformations.isLoaderNamesAllowedForProgramParents()) {
            return false;
        }
        if (VerifyHelper.isC_AUEsInconsistencyStoppingUpgrade(c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformations(typeOfUpgrade))) {
            return false;
        }
        if (!collection5.isEmpty()) {
            return false;
        }
        if (sSW_ValidationInformation.getResult() == 1 || sSW_ValidationInformation.isAnySswIndicationIndicatingErrorsForUpgrade()) {
            return false;
        }
        if (!collection6.isEmpty()) {
            return false;
        }
        if (!collection7.isEmpty()) {
            return false;
        }
        if (Trace.valid(VerifyHelper.class, 21)) {
            Trace.debug(VerifyHelper.class, 21, "checkIfPossibleToExecuteAnUpgrade(SequenceInformation aSequenceInformation, VerifyCVsToBeCreatedResult aVerifyCVsToBeCreatedResult, Vector AChecksumErrorsLoadModules, Vector aFaultyMainMPs, CoreMPsFTC_StatusInformation aCoreMPsFTC_StatusInformation, TypeOfUpgrade aTypeOfUpgrade,ProgramsContainer aReportedPgms, Collection aSubracksNotSupportedInformation, Collection aPiuTypeLoadListInformation, Collection aPiuTypeOverlappInformation, ProgramConsistencyInformations aProgramConsistencyInformations)", "Returning - true.");
        }
        return true;
    }

    public static boolean isCheckToBeDone(int n, VerifyRequestEvent verifyRequestEvent) {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "isCheckToBeDone(int aProgressHeaderValue, VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        boolean bl = true;
        for (int i = 0; i < verifyRequestEvent.omittVerifyUpgradeChecks.length; ++i) {
            if (verifyRequestEvent.omittVerifyUpgradeChecks[i] != n) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static Collection getProgramsWithRefToMissingLM() {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "getProgramsWithRefToMissingLM()");
        }
        Vector vector = new Vector();
        String[] stringArray = UpgradeController.upgradeRegistry().getPlugInUnitMoTypeNames();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (Trace.valid(VerifyHelper.class, 22)) {
            Trace.debug(VerifyHelper.class, 22, "getProgramsWithRefToMissingLM()", "piuMoTypeNames: " + SuLib.toString(stringArray));
        }
        MoIterator moIterator = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (Trace.valid(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22)) {
                Trace.debug(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22, "getProgramsWithRefToMissingLM()", "PlugInUnit type name: " + stringArray[i]);
            }
            if ((moIterator = MoRepository.instance().lookupType(stringArray[i])) == null) continue;
            while (moIterator.hasMoreElements()) {
                vector.addAll(VerifyHelper.getProgramsWithRefToMissingLM((GenericUpgradeablePlugInUnit)moIterator.nextMo()));
            }
        }
        return vector;
    }

    private static Collection getProgramsWithRefToMissingLM(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "getProgramsWithRefToMissingLM(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        Vector vector = new Vector();
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        Collection collection = null;
        try {
            piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
            if (piuTypeMoSU_Access == null) {
                Trace.log1(VerifyHelper.class, "getProgramsWithRefToMissingLM(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "Could not read program configuration for PlugInUnit due to no PiuType found (ignored).\n\tThe check if one ore more Program MOs refer to a LoadModule MO that has been removed has not been performed for PIU.\n\tPlugInUnit MO: " + genericUpgradeablePlugInUnit.getLocalDistinguishedName());
                return vector;
            }
            collection = piuTypeMoSU_Access.getProgramConfigurationInformation(null).getProgramConfigurationInformations();
        }
        catch (Throwable throwable) {
            Trace.error(VerifyHelper.class, "getProgramsWithRefToMissingLM(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "Could not read program configuration for PlugInUnit due to Throwable caught.\n\tThe check if one ore more Program MOs refer to a LoadModule MO that has been removed has not been performed for PIU.\n\tPlugInUnit MO: " + genericUpgradeablePlugInUnit.getLocalDistinguishedName(), throwable);
            return vector;
        }
        ProgramConfigurationInformation programConfigurationInformation = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            programConfigurationInformation = (ProgramConfigurationInformation)iterator.next();
            vector.addAll(VerifyHelper.getProgramsWithRefToMissingLM(piuTypeMoSU_Access, genericUpgradeablePlugInUnit.getLocalDistinguishedName(), programConfigurationInformation));
        }
        return vector;
    }

    private static Collection getProgramsWithRefToMissingLM(PiuTypeMoSU_Access piuTypeMoSU_Access, String string, ProgramConfigurationInformation programConfigurationInformation) {
        ManagedObject managedObject;
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "getProgramsWithRefToMissingLM(PiuTypeMoSU_Access aPiuTypeMo, String aPiuLdn, ProgramConfigurationInformation aProgramConfigurationInformation)", "aPiuTypeMo: " + piuTypeMoSU_Access + "\n\taPiuLdn: " + string + "\n\taProgramConfigurationInformation: " + programConfigurationInformation);
        }
        Vector<ProgramAndLoadModuleInconsistencyInfoContainer> vector = new Vector<ProgramAndLoadModuleInconsistencyInfoContainer>();
        String string2 = string;
        if (!programConfigurationInformation.getSubparentLDN().equals("")) {
            string2 = string2 + "," + programConfigurationInformation.getSubparentLDN();
        }
        if ((managedObject = MoRepository.instance().lookup(string2)) != null) {
            ManagedObject managedObject2 = null;
            MoIterator moIterator = managedObject.getChildren();
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    managedObject2 = moIterator.nextMo();
                    if (!managedObject2.getType().equals(programConfigurationInformation.getProgramMoTypeName())) continue;
                    try {
                        ((GenericProgramBase)managedObject2).getLoadModule(null);
                        if (!Trace.valid(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 23)) continue;
                        Trace.debug(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 23, "getProgramsWithRefToMissingLM(PiuTypeMoSU_Access aPiuTypeMo, String aPiuLdn, ProgramConfigurationInformation aProgramConfigurationInformation)", "LM ref for program MO: " + managedObject2.getLocalDistinguishedName() + " exists.");
                    }
                    catch (MoRemovedException moRemovedException) {
                        if (Trace.valid(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22)) {
                            Trace.debug(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, 22, "getProgramsWithRefToMissingLM(PiuTypeMoSU_Access aPiuTypeMo, String aPiuLdn, ProgramConfigurationInformation aProgramConfigurationInformation)", "MoRemovedExecption caught for LM ref for program MO: " + managedObject2.getLocalDistinguishedName());
                        }
                        ProductNumberAndRevision productNumberAndRevision = VerifyHelper.getPiuProductData(piuTypeMoSU_Access);
                        vector.add(new ProgramAndLoadModuleInconsistencyInfoContainer(productNumberAndRevision, managedObject2.getLocalDistinguishedName(), moRemovedException.getVariablesAsString()));
                    }
                    catch (Throwable throwable) {
                        Trace.error(class$se$ericsson$cello$upgradepackage$verify$VerifyHelper == null ? VerifyHelper.class$("se.ericsson.cello.upgradepackage.verify.VerifyHelper") : class$se$ericsson$cello$upgradepackage$verify$VerifyHelper, "getProgramsWithRefToMissingLM(PiuTypeMoSU_Access aPiuTypeMo, String aPiuLdn, ProgramConfigurationInformation aProgramConfigurationInformation)", "Failed to check if Program refers to a LoadModule MO that has been removed, throwable caught (ignored)\n\tProgram MO: " + managedObject2.getLocalDistinguishedName(), throwable);
                    }
                }
            } else if (Trace.valid(VerifyHelper.class, 22)) {
                Trace.debug(VerifyHelper.class, 22, "getProgramsWithRefToMissingLM(PiuTypeMoSU_Access aPiuTypeMo, String aPiuLdn, ProgramConfigurationInformation aProgramConfigurationInformation)", "Could not find any child MOs for theSubParentMo: " + managedObject.getLocalDistinguishedName());
            }
        } else if (Trace.valid(VerifyHelper.class, 22)) {
            Trace.debug(VerifyHelper.class, 22, "getProgramsWithRefToMissingLM(PiuTypeMoSU_Access aPiuTypeMo, String aPiuLdn, ProgramConfigurationInformation aProgramConfigurationInformation)", "Failed to find MO with subParentLdn: " + string2);
        }
        return vector;
    }

    private static ProductNumberAndRevision getPiuProductData(PiuTypeMoSU_Access piuTypeMoSU_Access) {
        try {
            if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                return new ProductNumberAndRevision(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null));
            }
            return new ProductNumberAndRevision(StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null)));
        }
        catch (MoAccessException moAccessException) {
            Trace.error(VerifyHelper.class, "getPiuProductRevision(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "Failed to get the product data from piuType, exception caught\n\taPiuTypeMo: " + piuTypeMoSU_Access, moAccessException);
            return new ProductNumberAndRevision("Unknown", "Unknown");
        }
    }

    private static Collection getRepertoireReplacementData(DocumentObjectProxyInterface documentObjectProxyInterface, String string) {
        RepertoireReplacementsProxyInterface repertoireReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface().getRepertoireReplacementsProxyInterface(string);
        return repertoireReplacementsProxyInterface.getRepertoireReplacementsData();
    }

    private static HashSet getRepertoireNamesInUCF(DocumentObjectProxyInterface documentObjectProxyInterface) {
        RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
        HashSet hashSet = new HashSet(repertoiresProxyInterface.getRepertoireNames());
        return hashSet;
    }

    private static boolean isC_AUEsInconsistencyStoppingAnyUpgrade(C_AUE_InconsistencyInformationsContainer c_AUE_InconsistencyInformationsContainer) {
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "isC_AUEsInconsistencyStoppingAnyUpgrade(C_AUE_InconsistencyInformationsContainer aC_AUE_InconsistencyInformationsContainer)", "aC_AUE_InconsistencyInformationsContainer: " + c_AUE_InconsistencyInformationsContainer);
        }
        boolean bl = false;
        if (c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformationsForRebootNodeUpgrade() != null && c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformationsForUpgrade() != null) {
            if (VerifyHelper.isC_AUEsInconsistencyStoppingUpgrade(c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformationsForRebootNodeUpgrade()) && VerifyHelper.isC_AUEsInconsistencyStoppingUpgrade(c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformationsForUpgrade())) {
                bl = true;
            }
        } else if (c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformationsForRebootNodeUpgrade() != null) {
            bl = VerifyHelper.isC_AUEsInconsistencyStoppingUpgrade(c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformationsForRebootNodeUpgrade());
        } else if (c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformationsForUpgrade() != null) {
            bl = VerifyHelper.isC_AUEsInconsistencyStoppingUpgrade(c_AUE_InconsistencyInformationsContainer.getC_AUE_InconsistencyInformationsForUpgrade());
        }
        if (Trace.valid(VerifyHelper.class, 20)) {
            Trace.debug(VerifyHelper.class, 20, "isC_AUEsInconsistencyStoppingAnyUpgrade(C_AUE_InconsistencyInformationsContainer aC_AUE_InconsistencyInformationsContainer)", "Returning - anIsC_AUEsInconsistencyStoppingAnyUpgrade: " + bl);
        }
        return bl;
    }

    private static boolean isC_AUEsInconsistencyStoppingUpgrade(C_AUE_InconsistencyInformations c_AUE_InconsistencyInformations) {
        boolean bl = false;
        if (c_AUE_InconsistencyInformations != null) {
            if (!c_AUE_InconsistencyInformations.isProgramInstancesConsistent()) {
                bl = true;
            } else if (!c_AUE_InconsistencyInformations.isMandatoryLoaderDataConsistent()) {
                bl = true;
            } else if (!c_AUE_InconsistencyInformations.isLoaderNamesAllowedForProgramParents()) {
                bl = true;
            }
        }
        return bl;
    }
}

