/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify.ssw;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleProgramInterface;
import se.ericsson.cello.sudom.util.datacontainer.InstallLM_Container;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.handler.HandlerException;
import se.ericsson.cello.upgradepackage.util.handler.LoadModuleProgramInformation;
import se.ericsson.cello.upgradepackage.util.handler.SignedSoftwareInformationForPIUs;
import se.ericsson.cello.upgradepackage.util.handler.WebServerHandler;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.ssw.SignedSoftwareInformationForPIU_Interface;

public class CalculateWebServerLMsForToState {
    private static final String SEPARATOR = "; ";

    public Collection collect(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ValidSequencesInformation validSequencesInformation, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collect(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\taSSW_PIUs: " + collection);
        }
        try {
            ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = managedElementMO_HandlerInterface.getFtcMos();
            boolean bl = false;
            for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
                if (!collection.contains(plugInUnitMoSU_AccessArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) {
                WebServerHandler webServerHandler = new WebServerHandler();
                Collection collection2 = webServerHandler.getWebServerLMsForTO_State((DocumentObjectProxyInterface)optimizedDocumentObjectProxyInterface, validSequencesInformation);
                return this.collectLoadModuleProgramInformations(optimizedDocumentObjectProxyInterface, collection2, plugInUnitMoSU_AccessArray, collection);
            }
            return new LinkedList();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collect(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "Throwable caught when collecting WebServer LMs that is signed.\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\taSSW_PIUs: " + collection, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public Collection collect(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, String aCase, Collection aSSW_PIUs)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCase: " + string + "\n\taSSW_PIUs: " + collection);
        }
        try {
            ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = managedElementMO_HandlerInterface.getFtcMos();
            boolean bl = false;
            for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
                if (!collection.contains(plugInUnitMoSU_AccessArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) {
                WebServerHandler webServerHandler = new WebServerHandler();
                Collection collection2 = webServerHandler.getWebServerLMsForTO_State((DocumentObjectProxyInterface)optimizedDocumentObjectProxyInterface, string);
                return this.collectLoadModuleProgramInformations(optimizedDocumentObjectProxyInterface, collection2, plugInUnitMoSU_AccessArray, collection);
            }
            return new LinkedList();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collect(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, String aCase, Collection aSSW_PIUs)", "Throwable caught when collecting WebServer LMs that is signed.\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCase: " + string + "\n\taSSW_PIUs: " + collection, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private Collection collectLoadModuleProgramInformations(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, Collection collection, PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray, Collection collection2) throws HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, Collection aWebServerLMsProductNumberAndRevisions, PlugInUnitMoSU_Access[] aCoreMP_PIUs, Collection aSSW_PIUs", "anOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taWebServerLMsProductNumberAndRevisions: " + collection + "\n\taCoreMP_PIUs: " + plugInUnitMoSU_AccessArray + "\n\taSSW_PIUs: " + collection2);
        }
        try {
            LoadModulesProxyInterface loadModulesProxyInterface = optimizedDocumentObjectProxyInterface.getLoadModulesProxyInterface();
            Integer n = new Integer(0);
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            LinkedList<LoadModuleProgramInformation> linkedList = new LinkedList<LoadModuleProgramInformation>();
            ProductNumberAndRevision productNumberAndRevision = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision);
                if (loadModuleProxyInterface != null) {
                    linkedList.add(new LoadModuleProgramInformation(loadModuleProxyInterface.getDeviceLoaderInformation(), loadModuleProxyInterface.getDeviceLoaderName(), loadModuleProxyInterface.getLoaderName(), productNumberAndRevision.productNumber, productNumberAndRevision.revision, n, loadModuleProxyInterface.getOseProgramLoadClass(), this.getDestinationFilePaths(optimizedDocumentObjectProxyInterface, loadModuleProxyInterface, productNumberAndRevision.productNumber, productNumberAndRevision.revision)));
                    continue;
                }
                Trace.info(this.getClass(), "collectLoadModuleProgramInformations(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aWebServerLMsProductNumberAndRevisions)", "Couldn't find the WebServer LM that shall be present in the UCF???, ignoring\n\ttheProductNumberAndRevision: " + productNumberAndRevision);
            }
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            SlotMoSU_Access slotMoSU_Access = null;
            LinkedList<SignedSoftwareInformationForPIUs> linkedList2 = new LinkedList<SignedSoftwareInformationForPIUs>();
            for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
                if (!collection2.contains(plugInUnitMoSU_AccessArray[i])) continue;
                slotMoSU_Access = slotMO_HandlerInterface.getSlotMo(plugInUnitMoSU_AccessArray[i]);
                slotMoSU_Access.getSubrackMo(null).getSwitchModuleNumber(null);
                linkedList2.add(new SignedSoftwareInformationForPIUs(slotMoSU_Access.getSubrackMo(null).getSwitchModuleNumber(null), slotMoSU_Access.getAsciPortNumber(null), linkedList));
            }
            if (Trace.valid(this.getClass(), 40)) {
                this.logCollectedWebServerLMs(optimizedDocumentObjectProxyInterface, linkedList2);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "collectLoadModuleProgramInformations(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aWebServerLMsProductNumberAndRevisions)", "RETURNS - theSignedSoftwareInformationForPIUs: " + linkedList2);
            }
            return linkedList2;
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            throw new HandlerException((Throwable)((Object)jvmMO_HandlerException));
        }
        catch (SlotMO_HandlerException slotMO_HandlerException) {
            throw new HandlerException((Throwable)((Object)slotMO_HandlerException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLoadModuleProgramInformations(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aWebServerLMsProductNumberAndRevisions)", "anOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taWebServerLMsProductNumberAndRevisions: " + collection + "\n\tTrowable caught", throwable);
            throw new HandlerException(throwable);
        }
    }

    private Collection getDestinationFilePaths(DocumentObjectProxyInterface documentObjectProxyInterface, LoadModuleProxyInterface loadModuleProxyInterface, String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDestinationFilePaths(DocumentObjectProxyInterface aDocumentObjectProxyInterface, LoadModuleProxyInterface aLoadModuleProxyInterface, String aProductNumber, String aRevision)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\taProductNumber: " + string + "\n\taRevision: " + string2);
        }
        Vector vector = loadModuleProxyInterface.getInstallDatas();
        InstallLM_Container installLM_Container = null;
        Iterator iterator = vector.iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            installLM_Container = (InstallLM_Container)iterator.next();
            if (installLM_Container.isDirectory()) continue;
            String string3 = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
            linkedList.add(string3);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDestinationFilePaths()", "RETURNS - theDestFilePaths: " + linkedList);
        }
        return linkedList;
    }

    private void logCollectedWebServerLMs(DocumentObjectProxyInterface documentObjectProxyInterface, Collection collection) {
        String string = "UP Product number: " + documentObjectProxyInterface.getProductDataProxyInterface().getNumberRaw() + SEPARATOR + documentObjectProxyInterface.getProductDataProxyInterface().getRevisionRaw();
        String string2 = null;
        LoadModuleProgramInterface loadModuleProgramInterface = null;
        SignedSoftwareInformationForPIU_Interface signedSoftwareInformationForPIU_Interface = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            signedSoftwareInformationForPIU_Interface = (SignedSoftwareInformationForPIU_Interface)iterator.next();
            string2 = "SMN: " + signedSoftwareInformationForPIU_Interface.getSMN() + SEPARATOR + "APN: " + signedSoftwareInformationForPIU_Interface.getAPN();
            Iterator iterator2 = signedSoftwareInformationForPIU_Interface.getSignedProgramInformationsForPIU().iterator();
            while (iterator2.hasNext()) {
                loadModuleProgramInterface = (LoadModuleProgramInterface)iterator2.next();
                Trace.debug(this.getClass(), 40, "logCollectedWebServerLMs(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aSignedSoftwareInformationForPIU_Interfaces)", string + SEPARATOR + "thePIU_LMs: " + string2 + SEPARATOR + "Number of LMs: " + signedSoftwareInformationForPIU_Interface.getSignedProgramInformationsForPIU().size() + SEPARATOR + "LM ProdNo: " + loadModuleProgramInterface.getProductNumber() + " LM revision: " + loadModuleProgramInterface.getRevision() + " Number of DestFilePaths: " + loadModuleProgramInterface.getDestinationFilePaths().size());
            }
        }
    }
}

