/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify.ssw;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerInterface;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfCfmInformation;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfErrorIndInformation;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfRejInformation;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfRspInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_LoaderNameValue;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_OseProgramLoadClassValue;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleProgramInterface;
import se.ericsson.cello.sudom.util.datacontainer.InstallLM_Container;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.SSW_Exception;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.ssw.SSW_ValidationInformation;
import se.ericsson.cello.upgradepackage.verify.ssw.SignedSoftwareInformationForPIU_Interface;

public class SSW_Validator {
    private LoadModuleMoSU_Access myLM_Mo = null;
    private static final String SEPARATOR = "; ";
    private static final String EMPTY_STRING = "";
    private String mySSW_FILE_NAME = "";
    private SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);

    public SSW_Validator() {
        this.mySSW_FILE_NAME = "ssw.xml";
    }

    public SSW_Validator(String string) {
        this.mySSW_FILE_NAME = string;
    }

    public SSW_ValidationInformation validate(String string, String string2, String string3, Collection collection) throws SSW_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, Collection aSignedSoftwareInformationForPIU_Interfaces)", "mySSW_FILE_NAME : " + this.mySSW_FILE_NAME + "\n\tanUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection);
        }
        if (this.generateSSW_File(string, string2, string3, collection)) {
            return this.requestForSSW_Validation(collection);
        }
        return new SSW_ValidationInformation();
    }

    /*
     * Loose catch block
     */
    private boolean generateSSW_File(String string, String string2, String string3, Collection collection) throws SSW_Exception {
        boolean bl;
        OutputStreamWriter outputStreamWriter;
        block14: {
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface;
            block12: {
                boolean bl2;
                block13: {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "generateSSW_File(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, Collection aSignedSoftwareInformationForPIU_Interfaces)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection);
                    }
                    outputStreamWriter = null;
                    optimizedDocumentObjectProxyInterface = this.getDocumentObjectProxyInterface(string, string2);
                    if (optimizedDocumentObjectProxyInterface != null) break block12;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "generateSSW_File(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, Collection aSignedSoftwareInformationForPIU_Interfaces)", "Not possible to execute the SSW validation of LMs for UP with product number " + string + " and revision " + string2 + ".");
                    }
                    bl2 = false;
                    Object var12_10 = null;
                    if (outputStreamWriter == null) break block13;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "e2", "Exception caught when trying to close the handle to load list file.anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection, throwable);
                    }
                }
                return bl2;
            }
            LoadModulesProxyInterface loadModulesProxyInterface = optimizedDocumentObjectProxyInterface.getLoadModulesProxyInterface();
            File file = null;
            SystemUpgradeConstantsInterface systemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
            file = new File(systemUpgradeConstantsInterface.getNodeTmpRootPath());
            if (!file.exists()) {
                file.mkdirs();
            }
            outputStreamWriter = new FileWriter(systemUpgradeConstantsInterface.getNodeTmpRootPath() + this.mySSW_FILE_NAME);
            this.writeSSW_InitialInformation((FileWriter)outputStreamWriter, string, string2, string3);
            this.writeSSW_LoadModulesInformation((FileWriter)outputStreamWriter, collection, optimizedDocumentObjectProxyInterface, loadModulesProxyInterface);
            this.writeSSW_EndInformation((FileWriter)outputStreamWriter);
            bl = true;
            Object var12_11 = null;
            if (outputStreamWriter == null) break block14;
            try {
                outputStreamWriter.close();
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "e2", "Exception caught when trying to close the handle to load list file.anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection, throwable);
            }
        }
        return bl;
        catch (Throwable throwable) {
            try {
                Trace.error(this.getClass(), "generateSSW_File(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, Collection aSignedSoftwareInformationForPIU_Interfaces)", "aSignedSoftwareInformationForPIU_Interfaces: " + collection, throwable);
                throw new SSW_Exception(throwable.toString());
            }
            catch (Throwable throwable2) {
                block15: {
                    Object var12_12 = null;
                    if (outputStreamWriter == null) break block15;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (Throwable throwable3) {
                        Trace.error(this.getClass(), "e2", "Exception caught when trying to close the handle to load list file.anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection, throwable3);
                    }
                }
                throw throwable2;
            }
        }
    }

    private SSW_ValidationInformation requestForSSW_Validation(Collection collection) throws SSW_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "requestForSSW_Validation(Collection aSignedSoftwareInformationForPIU_Interfaces)\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess)) {
                SystemUpgradeConstantsInterface systemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
                String string = systemUpgradeConstantsInterface.getNodeTmpRootPath() + this.mySSW_FILE_NAME;
                osaSwInstallProxyAccess.sendOsaVerifySSW_ConfReq(string);
                SSW_ValidationInformation sSW_ValidationInformation = this.waitForOsaVerifySswConfRsp(osaSwInstallProxyAccess);
                sSW_ValidationInformation.setSignedSoftwareInformation(collection);
                return sSW_ValidationInformation;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "requestForSSW_Validation()", "Not possible to execute the ssw validation due to OSA is not supporting the SVMI service (version 3)");
            }
            return new SSW_ValidationInformation(0);
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            throw new SSW_Exception(sU_ConditionalException.toString());
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "requestForSSW_Validation()", "FroNotAccessibleException caught", froNotAccessibleException);
            throw new SSW_Exception(froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "requestForSSW_Validation()", "Throwable caught", throwable);
            throw new SSW_Exception(throwable.toString());
        }
    }

    private OptimizedDocumentObjectProxyInterface getDocumentObjectProxyInterface(String string, String string2) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDocumentObjectProxyInterface(String anUP_ProductNumber, String anUP_ProductRevision, String anUCF_Path)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2);
        }
        try {
            UpgradePackageMO_HandlerInterface upgradePackageMO_HandlerInterface = ServiceFinder.getUpgradePackageMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpgradePackageMo(string, string2);
            if (upgradePackageMoExtended != null) {
                String string3 = upgradePackageMoExtended.getUpgradeControlFilePath(null);
                String[] stringArray = new String[]{"LoadModule"};
                OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElementsOptimizedInterface(string, string2, string3, stringArray, false);
                return optimizedDocumentObjectProxyInterface;
            }
            return null;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw new VerifyRequestException(upgradeControlFileParserException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDocumentObjectProxyInterface(String anUP_ProductNumber, String anUP_ProductRevision)", "Throwable caught.anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private SSW_ValidationInformation waitForOsaVerifySswConfRsp(OsaSwInstallProxyAccess osaSwInstallProxyAccess) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForOsaVerifySswConfRsp(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess)");
        }
        try {
            SSW_ValidationInformation sSW_ValidationInformation = new SSW_ValidationInformation();
            boolean bl = false;
            while (!bl) {
                OsaVerifySswConfRspInformation osaVerifySswConfRspInformation = osaSwInstallProxyAccess.receiveOsaVerifySswConfRsp();
                if (osaVerifySswConfRspInformation instanceof OsaVerifySswConfErrorIndInformation) {
                    sSW_ValidationInformation.addOsaVerifySswConfErrorIndInformation((OsaVerifySswConfErrorIndInformation)osaVerifySswConfRspInformation);
                    continue;
                }
                if (osaVerifySswConfRspInformation instanceof OsaVerifySswConfCfmInformation) {
                    sSW_ValidationInformation.setResult(0);
                    bl = true;
                    continue;
                }
                if (!(osaVerifySswConfRspInformation instanceof OsaVerifySswConfRejInformation)) continue;
                sSW_ValidationInformation.setResult(1);
                sSW_ValidationInformation.setErrorInfo(((OsaVerifySswConfRejInformation)osaVerifySswConfRspInformation).getErrorinfo());
                bl = true;
            }
            sSW_ValidationInformation.setIsInstalled();
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 20, "waitForOsaVerifySswConfRsp(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess)", "RETURNS - theSSW_ValidationInformation: " + sSW_ValidationInformation);
            }
            return sSW_ValidationInformation;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "waitForOsaVerifySswConfRsp(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess)", "FroNotAccessibleException caught", froNotAccessibleException);
            throw new VerifyRequestException(froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "waitForOsaVerifySswConfRsp(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess)", "Throwable caught", throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private int translateLoaderName(String string, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "translateLoaderName(String aLoaderName, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)", "aLoaderName: " + string + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface);
        }
        try {
            return loadModuleMO_HandlerInterface.getLoaderType(string);
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new VerifyRequestException(loadModuleMO_HandlerException.toString());
        }
    }

    private int translateLoadClass(String string, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "translateLoaderName(String aLoadClass, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)", "aLoadClass: " + string + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface);
        }
        try {
            Collection collection;
            if (this.myLM_Mo == null && !(collection = loadModuleMO_HandlerInterface.getAllLoadModuleMOs()).isEmpty()) {
                this.myLM_Mo = (LoadModuleMoSU_Access)collection.iterator().next();
            }
            return loadModuleMO_HandlerInterface.getOseProgramLoadClassIntValue(string, loadModuleMO_HandlerInterface.isSU_VersionSupported("SU_3"));
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new VerifyRequestException(loadModuleMO_HandlerException.toString());
        }
    }

    private void writeSSW_InitialInformation(FileWriter fileWriter, String string, String string2, String string3) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeSSW_InitialInformation(FileWriter aSSW_FileWriter, String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date)", "aSSW_FileWriter: " + fileWriter + "\n\tanUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3);
        }
        try {
            fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fileWriter.write("<!DOCTYPE Node>\n\n");
            fileWriter.write("<Node formatVersion=\"1\">\n\n");
            fileWriter.write("  <UpgradePackage number=\"" + string + "\" revision=\"" + string2 + "\"/>\n");
            fileWriter.write("  <Date date = \"" + string3 + "\"/>\n");
            fileWriter.write("  <Configuration>\n");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeSSW_InitialInformation(FileWriter aSSW_FileWriter, String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date)", "Throwable caught when writing to the ssw file.\n\taSSW_FileWriter: " + fileWriter + "\n\tanUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private void writeSSW_LoadModulesInformation(FileWriter fileWriter, Collection collection, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, LoadModulesProxyInterface loadModulesProxyInterface) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeSSW_LoadModulesInformation(FileWriter aSSW_FileWriter, Collection aSignedSoftwareInformationForPIU_Interfaces, OptimizedDocumentObjectProxyInterface theDocumentObjectProxyInterface, LoadModulesProxyInterface anOptLoadModulesProxyInterface)", "aSSW_FileWriter: " + fileWriter + "\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection + "\n\ttheDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\tanOptLoadModulesProxyInterface: " + loadModulesProxyInterface);
        }
        try {
            SignedSoftwareInformationForPIU_Interface signedSoftwareInformationForPIU_Interface = null;
            Iterator iterator = collection.iterator();
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            while (iterator.hasNext()) {
                signedSoftwareInformationForPIU_Interface = (SignedSoftwareInformationForPIU_Interface)iterator.next();
                fileWriter.write("\n    <Piu smn=\"" + signedSoftwareInformationForPIU_Interface.getSMN() + "\" apn=\"" + signedSoftwareInformationForPIU_Interface.getAPN() + "\">\n");
                Collection collection2 = this.sortSignedProgramInformationsForPIU(signedSoftwareInformationForPIU_Interface.getSignedProgramInformationsForPIU());
                Iterator iterator2 = collection2.iterator();
                LoadModuleProgramInterface loadModuleProgramInterface = null;
                while (iterator2.hasNext()) {
                    loadModuleProgramInterface = (LoadModuleProgramInterface)iterator2.next();
                    this.writeSSW_LoadModuleInformation(fileWriter, loadModuleProgramInterface, loadModuleMO_HandlerInterface, optimizedDocumentObjectProxyInterface, loadModulesProxyInterface);
                }
                fileWriter.write("    </Piu>\n");
                if (!Trace.valid(this.getClass(), 40)) continue;
                this.logLoadClasses(signedSoftwareInformationForPIU_Interface.getSMN(), signedSoftwareInformationForPIU_Interface.getAPN(), collection2);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeSSW_LoadModulesInformation(FileWriter aSSW_FileWriter, Collection aSignedSoftwareInformationForPIU_Interfaces, OptimizedLoadModulesProxyInterface anOptLoadModulesProxyInterface)", "Throwable caught when writing to the ssw file.\n\taSSW_FileWriter: " + fileWriter + "\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private boolean isFileToBeChecked(String string, String string2, String string3, String string4, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, LoadModulesProxyInterface loadModulesProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isFileToBeChecked(String aLM_ProdNo, String aLM_ProdRev, String aLoaderName,  String aDestFilePath, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, LoadModulesProxyInterface anOptLoadModulesProxyInterface)", "aLM_ProdNo: " + string + "\n\taLM_ProdRev: " + string2 + "\n\taLoaderName: " + string3 + "\n\taDestFilePath:" + string4 + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\tanOptLoadModulesProxyInterface: " + loadModulesProxyInterface);
        }
        boolean bl = true;
        if (string3.equalsIgnoreCase(LoadModuleProxyInterface.LOADER_NAME_OTHER_VALUE) || string3.equalsIgnoreCase(LoadModuleProxyInterface.LOADER_NAME_WEBSERVER_VALUE)) {
            LoadModuleProxyInterface loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(string, string2);
            if (loadModuleProxyInterface != null) {
                Vector vector = loadModuleProxyInterface.getInstallDatas();
                Iterator iterator = vector.iterator();
                InstallLM_Container installLM_Container = null;
                String string5 = null;
                while (iterator.hasNext()) {
                    installLM_Container = (InstallLM_Container)iterator.next();
                    string5 = optimizedDocumentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "isFileToBeChecked(String aLM_ProdNo, String aLM_ProdRev, String aLoaderName,  String aDestFilePath, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, OptimizedLoadModulesProxyInterface anOptLoadModulesProxyInterface)", "theLoadModuleDestinationAbsolutePath: " + string5 + "\n\ttheInstallLM_Container: " + installLM_Container);
                    }
                    if (!string5.equals(string4) || installLM_Container.isDirectory() || installLM_Container.getFileSize() != 0 || installLM_Container.getChecksum() == null || installLM_Container.getChecksum() != InstallLM_Container.CHECKSUM_DEFAULT_VALUE) continue;
                    bl = false;
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "isFileToBeChecked(String aLM_ProdNo, String aLM_ProdRev, String aLoaderName,  String aDestFilePath, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, OptimizedLoadModulesProxyInterface anOptLoadModulesProxyInterface)", "No SSW validation to be performed on LM: " + string + " " + string2 + " " + string4);
                    }
                    break;
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 20, "isFileToBeChecked(String aLM_ProdNo, String aLM_ProdRev, String aLoaderName,  String aDestFilePath, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, OptimizedLoadModulesProxyInterface anOptLoadModulesProxyInterface)", "The LM is not found in the UCF i.e. assuming anyhow that it shall be ssw validated\n\tLm Prod no: " + string + "\n\tLM Prod rev: " + string2 + "\n\tDestination file path: " + string4);
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isFileToBeChecked(String aLM_ProdNo, String aLM_ProdRev, String aLoaderName,  String aDestFilePath, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, OptimizedLoadModulesProxyInterface anOptLoadModulesProxyInterface)", "RETURNS - theIsLmToBeChecked: " + bl);
        }
        return bl;
    }

    private void writeSSW_LoadModuleInformation(FileWriter fileWriter, LoadModuleProgramInterface loadModuleProgramInterface, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, LoadModulesProxyInterface loadModulesProxyInterface) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeSSW_LoadModuleInformation(FileWriter aSSW_FileWriter, LoadModuleProgramInterface aLoadModuleProgramInterface, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, OptimizedDocumentObjectProxyInterface aDocumentObjectProxyInterface, LoadModulesProxyInterface anOptLoadModulesProxyInterface)", "aSSW_FileWriter: " + fileWriter + "\n\taLoadModuleProgramInterface: " + loadModuleProgramInterface + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taLoadModuleProgramInterface: " + loadModuleProgramInterface.getDestinationFilePaths() + "\n\taDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\tanOptLoadModulesProxyInterface: " + loadModulesProxyInterface);
        }
        try {
            Iterator iterator = loadModuleProgramInterface.getDestinationFilePaths().iterator();
            String string = null;
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (!this.isFileToBeChecked(loadModuleProgramInterface.getProductNumber(), loadModuleProgramInterface.getRevision(), loadModuleProgramInterface.getLoaderNameSum(), string, optimizedDocumentObjectProxyInterface, loadModulesProxyInterface)) continue;
                fileWriter.write("      <LoadModule\n");
                fileWriter.write("        number=\"" + loadModuleProgramInterface.getProductNumber() + "\"\n");
                fileWriter.write("        revision=\"" + loadModuleProgramInterface.getRevision() + "\"\n");
                if (loadModuleProgramInterface.getLoadClass() != null && !loadModuleProgramInterface.getLoadClass().equals(EMPTY_STRING)) {
                    fileWriter.write("        loadClass=\"" + this.translateLoadClass(loadModuleProgramInterface.getLoadClass(), loadModuleMO_HandlerInterface) + "\"\n");
                }
                fileWriter.write("        loaderType=\"" + this.translateLoaderName(loadModuleProgramInterface.getLoaderNameSum(), loadModuleMO_HandlerInterface) + "\"\n");
                if ((loadModuleProgramInterface.getLoaderNameSum().equalsIgnoreCase(MoDataLM_LoaderNameValue.JVM) || loadModuleProgramInterface.getLoaderNameSum().equalsIgnoreCase(MoDataLM_LoaderNameValue.Other)) && string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath())) {
                    string = jvmMO_HandlerInterface.selectDestinationAbsolutePathForJVMLoadModule(string);
                }
                fileWriter.write("        filePath=\"" + SuLib.getReplicatedFilePath(string) + "\"/>\n");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeSSW_LoadModuleInformation(FileWriter aSSW_FileWriter, LoadModuleProgramInterface aLoadModuleProgramInterface, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, OptimizedLoadModulesProxyInterface anOptLoadModulesProxyInterface)", "aSSW_FileWriter: " + fileWriter + "\n\taLoadModuleProgramInterface: " + loadModuleProgramInterface, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private void writeSSW_EndInformation(FileWriter fileWriter) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeSSW_EndInformation(FileWriter aSSW_FileWriter)", "aSSW_FileWriter: " + fileWriter);
        }
        try {
            fileWriter.write("  </Configuration>\n");
            fileWriter.write("</Node>\n\n");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeSSW_EndInformation(FileWriter aSSW_FileWriter)", "Throwable caught when writing to the ssw file.\n\taSSW_FileWriter: " + fileWriter, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private Collection sortSignedProgramInformationsForPIU(Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sortSignedProgramInformationsForPIU(Collection aSignedProgramInformationsForPIU)", "aSignedProgramInformationsForPIU: " + collection);
        }
        try {
            LinkedList<LoadModuleProgramInterface> linkedList = new LinkedList<LoadModuleProgramInterface>();
            Iterator iterator = collection.iterator();
            LoadModuleProgramInterface loadModuleProgramInterface = null;
            String string = null;
            while (iterator.hasNext()) {
                loadModuleProgramInterface = (LoadModuleProgramInterface)iterator.next();
                string = loadModuleProgramInterface.getLoadClass();
                if (string != null && !string.equals(EMPTY_STRING)) {
                    if (string.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CrlCertificate)) {
                        linkedList.addFirst(loadModuleProgramInterface);
                        continue;
                    }
                    linkedList.add(loadModuleProgramInterface);
                    continue;
                }
                linkedList.add(loadModuleProgramInterface);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sortSignedProgramInformationsForPIU(Collection aSignedProgramInformationsForPIU)", "aSignedProgramInformationsForPIU: " + collection, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private void logLoadClasses(int n, int n2, Collection collection) {
        Iterator iterator = collection.iterator();
        LoadModuleProgramInterface loadModuleProgramInterface = null;
        String string = EMPTY_STRING;
        while (iterator.hasNext()) {
            loadModuleProgramInterface = (LoadModuleProgramInterface)iterator.next();
            if (loadModuleProgramInterface.getLoadClass() == null || loadModuleProgramInterface.getLoadClass().equals(EMPTY_STRING)) continue;
            if (string.length() == 0) {
                string = loadModuleProgramInterface.getLoadClass();
                continue;
            }
            string = string + ", " + loadModuleProgramInterface.getLoadClass();
        }
        String string2 = "SMN: " + n + SEPARATOR + "APN: " + n2;
        Trace.debug("logLoadClasses(Collection aSignedSoftwareInformationForPIU_Interfaces)", string2 + SEPARATOR + "thePIU_LM_LoadClasses: " + string);
    }
}

