/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.framework;

import se.ericsson.cello.maofro.framework.AggregateParameter;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.ParameterVisitor;
import se.ericsson.cello.maofro.framework.StringParameter;

public class ArrayParameter
extends AggregateParameter {
    private Class arrayType = null;
    private String elementName = null;
    private int stringLength = -1;

    public ArrayParameter(String string) {
        super(string);
    }

    public void add(Parameter parameter) throws IllegalParameterValueException {
        this.validateType(parameter);
        this.validateName(parameter);
        if (this.arrayType == StringParameter.class) {
            this.validateLength((StringParameter)parameter);
        }
        super.add(parameter);
    }

    private void validateType(Parameter parameter) throws IllegalParameterValueException {
        if (this.arrayType == null) {
            this.arrayType = parameter.getClass();
        } else if (!this.arrayType.equals(parameter.getClass())) {
            throw new IllegalParameterValueException("Mixed types in array");
        }
    }

    private void validateName(Parameter parameter) throws IllegalParameterValueException {
        if (this.elementName == null) {
            this.elementName = parameter.getName();
        } else if (!this.elementName.equals(parameter.getName())) {
            throw new IllegalParameterValueException("Mixed element names in array");
        }
    }

    private void validateLength(StringParameter stringParameter) throws IllegalParameterValueException {
        if (this.stringLength < 0) {
            this.stringLength = stringParameter.length();
        }
    }

    public String getValueAsString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.get(i).getValueAsString());
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public void accept(ParameterVisitor parameterVisitor) throws Exception {
        parameterVisitor.visitArrayParameter(this);
    }
}

