/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.framework;

import java.util.HashSet;
import java.util.Set;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;

public class MaoFroStructWrapper {
    private String name;
    private String[] orderedMembers = null;
    private StructParameter parameter = null;
    private Struct struct = null;
    private Set booleans = null;

    public MaoFroStructWrapper(Struct struct, String string, String[] stringArray) throws MoAccessException {
        this.struct = struct;
        this.name = string;
        this.orderedMembers = stringArray;
        if (this.struct.size() != this.orderedMembers.length) {
            throw new ValueOutOfRangeException("Mismatch in struct " + string, "MaoFroStructWrapper");
        }
        this.createParameter();
    }

    public MaoFroStructWrapper(StructParameter structParameter) throws MoAccessException {
        this(structParameter, null);
    }

    public MaoFroStructWrapper(StructParameter structParameter, String[] stringArray) throws MoAccessException {
        this.parameter = structParameter;
        this.name = structParameter.getName();
        if (stringArray != null) {
            this.booleans = new HashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                this.booleans.add(stringArray[i]);
            }
        }
        this.createStruct();
    }

    private void createParameter() throws MoAccessException {
        this.parameter = new StructParameter(this.name);
        Parameter parameter = null;
        String string = null;
        Object object = null;
        for (int i = 0; i < this.struct.size(); ++i) {
            string = this.orderedMembers[i];
            object = this.struct.getValue(string);
            if (object instanceof Integer) {
                parameter = new SignedIntParameter(string, (Integer)object);
            } else if (object instanceof Boolean) {
                parameter = new SignedIntParameter(string, (Boolean)object);
            } else if (object instanceof String) {
                parameter = new StringParameter(string, (String)object);
            } else {
                throw new ValueOutOfRangeException("Unsupported type for field '" + string + "' : was " + object.getClass().getName(), "MaoFroStructWrapper");
            }
            this.parameter.add(parameter);
        }
    }

    private void createStruct() throws MoAccessException {
        int n = this.parameter.size();
        String[] stringArray = new String[n];
        Object[] objectArray = new Object[n];
        Parameter parameter = null;
        for (int i = 0; i < n; ++i) {
            parameter = this.parameter.get(i);
            stringArray[i] = parameter.getName();
            if (parameter instanceof SignedIntParameter || parameter instanceof StringParameter) {
                if (this.isBooleanField(stringArray[i])) {
                    objectArray[i] = new Boolean(((SignedIntParameter)parameter).getBoolean());
                    continue;
                }
                if (parameter instanceof StringParameter) {
                    objectArray[i] = new String(((StringParameter)parameter).getValue());
                    continue;
                }
                objectArray[i] = new Integer(((SignedIntParameter)parameter).getValue());
                continue;
            }
            throw new ValueOutOfRangeException("Unsupported parameter type for field '" + stringArray[i] + "' : was " + parameter.getClass().getName(), "MaoFroStructWrapper");
        }
        this.struct = new StructImpl(stringArray, objectArray);
    }

    private boolean isBooleanField(String string) {
        if (this.booleans != null) {
            return this.booleans.contains(string);
        }
        return false;
    }

    public int size() {
        return this.struct.size();
    }

    public StructParameter toParameter() {
        return this.parameter;
    }

    public Struct toStruct() {
        return this.struct;
    }
}

