/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import enea.ose.io.SignalInputStream;
import java.io.IOException;
import se.ericsson.cello.maofro.framework.AggregateParameter;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntArrayParameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;

public class MaoFroGenericSignalReader {
    private TagNameDictionary dictionary;

    public MaoFroGenericSignalReader(TagNameDictionary tagNameDictionary) {
        this.dictionary = tagNameDictionary;
    }

    public Parameter readParameter(SignalInputStream signalInputStream) throws IOException, IllegalParameterValueException, TagNameDictionaryException {
        int n = (int)signalInputStream.readU32();
        int n2 = signalInputStream.readU16();
        int n3 = signalInputStream.readU16();
        long l = signalInputStream.readU32();
        String string = this.dictionary.lookupName(n);
        Parameter parameter = null;
        switch (n2) {
            case 2: {
                parameter = new UnsignedIntParameter(string, l);
                break;
            }
            case 3: {
                parameter = new SignedIntParameter(string, (int)l);
                break;
            }
            case 1: {
                int[] nArray = signalInputStream.readU8Array((int)l);
                String string2 = MaoFroGenericSignalReader.decode(nArray);
                parameter = new StringParameter(string, string2);
                break;
            }
            case 8: {
                int[] nArray = signalInputStream.readS32Array((int)l);
                parameter = new SignedIntArrayParameter(string, nArray);
                break;
            }
            case 6: {
                ArrayParameter arrayParameter = new ArrayParameter(string);
                this.readParameters(signalInputStream, (int)l, arrayParameter);
                parameter = arrayParameter;
                break;
            }
            case 4: {
                StructParameter structParameter = new StructParameter(string);
                this.readParameters(signalInputStream, (int)l, structParameter);
                parameter = structParameter;
                break;
            }
            case 7: {
                throw new IllegalParameterValueException("Unexpected end of array!");
            }
            case 5: {
                throw new IllegalParameterValueException("Unexpected end of struct!");
            }
            default: {
                throw new IllegalParameterValueException("Unknown attribute type: " + n2);
            }
        }
        return parameter;
    }

    private void readParameters(SignalInputStream signalInputStream, int n, AggregateParameter aggregateParameter) throws IOException, IllegalParameterValueException, TagNameDictionaryException {
        for (int i = 0; i < n; ++i) {
            aggregateParameter.add(this.readParameter(signalInputStream));
        }
        MaoFroGenericSignalReader.skipEndTag(signalInputStream);
    }

    public static String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length && nArray[i] != 0; ++i) {
            stringBuffer.append((char)nArray[i]);
        }
        return stringBuffer.toString().trim();
    }

    public static void skipEndTag(SignalInputStream signalInputStream) throws IOException {
        signalInputStream.readU32();
        signalInputStream.readU16();
        signalInputStream.readU16();
        signalInputStream.readU32();
    }
}

