/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.session;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.ArrayList;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.session.MaoFroAttributeHelper;
import se.ericsson.cello.session.MaoFroAttributeStruct;
import se.ericsson.cello.session.MaoFroInitiateServiceCfm;
import se.ericsson.cello.session.MaoFroInitiateServiceReq;
import se.ericsson.cello.session.MaoFroNotifySubscribeReq2;
import se.ericsson.cello.session.NameServerWrapper;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;

public class PVSession
implements ServiceSubscriber {
    private static final int RETRYCOUNTER = 6;
    private static final int RETRYTIMER = 10000;
    private static final int TRACEGROUP = 5;
    private static final int SIGREV_1 = 1;
    private static final int SIGREV_2 = 2;
    private static final int SESSION_REJ = 3;
    private static final int NO_SESSION = 0;
    private static final int SESSION_CFM = 1;
    private static final int SESSION_SUS = 2;
    private static final int RECEIVE_TIMEOUT = 5000;
    private int froType;
    private int sessionState;
    private String serviceName = "";
    private String moType = "";
    private String[] supportedPvs = null;
    private PVSessionObject pvSessionObject;
    private NameServerWrapper nameServerWrapper = null;

    public PVSession(String string, String string2, String string3, String string4, String string5, int n) {
        this(string, new String[]{string2, string3, string4}, string5, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PVSession(String string, String[] stringArray, String string2, int n) {
        this.supportedPvs = this.padVersions(stringArray);
        this.serviceName = string;
        this.moType = string2;
        this.froType = n;
        this.sessionState = 0;
        this.pvSessionObject = new PVSessionObject();
        PVSession pVSession = this;
        synchronized (pVSession) {
            this.nameServerWrapper = new NameServerWrapper(string, this);
        }
    }

    private String[] padVersions(String[] stringArray) {
        if (stringArray.length < 3) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>(3);
            for (n = 0; n < stringArray.length; ++n) {
                arrayList.add(stringArray[n]);
            }
            while (n < 3) {
                arrayList.add("");
                ++n;
            }
            return arrayList.toArray(new String[3]);
        }
        return stringArray;
    }

    public synchronized void serviceAdded() {
        try {
            MessageLog.trace((int)5, this.getClass(), (String)("serviceAdded(), sessionState = " + this.sessionState + ", this.serviceName = " + this.serviceName));
            OseProcess oseProcess = this.nameServerWrapper.lookup();
            MessageLog.trace((int)5, this.getClass(), (String)("serviceAdded(): currentFroProcess=" + oseProcess));
            if (oseProcess == null) {
                this.sessionState = 0;
                return;
            }
            if (this.sessionState == 0) {
                MessageLog.trace((int)5, this.getClass(), (String)"serviceAdded(): this.sessionState == NO_SESSION");
                this.pvSessionObject.setFroProcess(oseProcess);
                this.pvNegotiate();
            } else if (this.sessionState == 3) {
                MessageLog.trace((int)5, this.getClass(), (String)"serviceAdded(): this.sessionState == SESSION_REJ");
                this.pvSessionObject.setFroProcess(oseProcess);
                this.sessionState = 0;
                this.pvNegotiate();
            } else if (!oseProcess.equals((Object)this.pvSessionObject.getFroProcess()) && !oseProcess.equals((Object)this.pvSessionObject.getFroProcess())) {
                this.sessionState = 0;
                this.pvSessionObject.setFroProcess(oseProcess);
                this.pvNegotiate();
            }
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"serviceAdded() caught runtime exception!", (Throwable)runtimeException);
        }
    }

    public synchronized void serviceRemoved() {
        try {
            OseProcess oseProcess = this.nameServerWrapper.lookup();
            if (oseProcess == null) {
                MessageLog.trace((int)5, this.getClass(), (String)("serviceRemoved = " + this.serviceName + " currentOseProcessForFRO == null"));
                this.sessionState = 0;
                this.pvSessionObject.setFroProcess(null);
            } else if (!oseProcess.equals((Object)this.pvSessionObject.getFroProcess())) {
                MessageLog.trace((int)5, this.getClass(), (String)("serviceRemoved = " + this.serviceName + " currentOseProcessForFRO != this.pvSessionObject.getFroProcess()"));
                this.sessionState = 0;
                this.pvSessionObject.setFroProcess(null);
            }
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"serviceRemoved() caught runtime exception!", (Throwable)runtimeException);
        }
    }

    public PVSessionObject obtainSession() throws FroNotAccessibleException {
        MessageLog.trace((int)5, this.getClass(), (String)("obtainSession() sessionState = " + this.sessionState + ", serviceName = " + this.serviceName + ", supported PVs = " + this.printSupportedPvs() + ", froType = " + this.froType));
        if (this.sessionState == 1) {
            MessageLog.trace((int)5, this.getClass(), (String)("obtainSession() session available, serviceName = " + this.serviceName));
            return this.pvSessionObject;
        }
        if (this.sessionState == 3 || this.sessionState == 2) {
            throw new FroNotAccessibleException(this.moType, "Session rejected or suspended by FRO, " + this.serviceName);
        }
        if (this.sessionState == 0 && this.reTryPvNegotiation()) {
            MessageLog.trace((int)5, this.getClass(), (String)"obtainSession() session available ");
            return this.pvSessionObject;
        }
        throw new FroNotAccessibleException(this.moType, "Session is not available, " + this.serviceName);
    }

    private boolean reTryPvNegotiation() {
        for (int i = 0; this.sessionState == 0 && i < 6; ++i) {
            try {
                this.pvNegotiate();
                if (this.sessionState != 0) continue;
                MessageLog.trace((int)5, this.getClass(), (String)(this.serviceName + " PV negotiation failed, waiting " + 10 + "Seconds in reTryPvNegotiation()"));
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.sessionState == 1;
    }

    private synchronized void pvNegotiate() {
        MessageLog.trace((int)5, this.getClass(), (String)("pvNegotiate() starts for serviceName: " + this.serviceName));
        if (this.sessionState == 0) {
            OseProcess oseProcess = this.nameServerWrapper.lookup();
            if (oseProcess == null) {
                MessageLog.trace((int)5, this.getClass(), (String)("pvNegotiate(), serviceName: " + this.serviceName + ", currentFroProcess is null!"));
                return;
            }
            MessageLog.trace((int)5, this.getClass(), (String)("serviceName = " + this.serviceName + ", pvNegotiate() setting fro process"));
            this.pvSessionObject.setFroProcess(oseProcess);
            MessageLog.trace((int)5, this.getClass(), (String)("serviceName = " + this.serviceName + ", pvNegotiate(): About to send FroInitiateServiceReq:"));
            MaoFroInitiateServiceCfm maoFroInitiateServiceCfm = this.sendMaoFroInitiateServiceReq(this.supportedPvs[0], this.supportedPvs[1], this.supportedPvs[2]);
            if (maoFroInitiateServiceCfm == null) {
                MessageLog.trace((int)5, this.getClass(), (String)("No cfm signal sent back, the receiving process have terminated, or signal MaoFroInitiateServiceCfm timed out.Fro serviceName " + this.serviceName));
            } else if (maoFroInitiateServiceCfm.getSignalRevision() < 2) {
                MessageLog.trace((int)5, this.getClass(), (String)("Unknown signal revision received in CFM from FRO \n signalRevision = " + maoFroInitiateServiceCfm.getSignalRevision() + "Fro serviceName " + this.serviceName));
                this.sessionState = 3;
            } else if (maoFroInitiateServiceCfm.getResult() == 1) {
                String string = MaoFroAttributeHelper.getStringAttrValue(maoFroInitiateServiceCfm.getAttributes(), 14);
                if (this.isSupportedPv(string)) {
                    MessageLog.trace((int)5, this.getClass(), (String)"pvNegotiate(): rspSig.getResult() == SessionConstants.MAOFRO_INIT_SERVICE_CFM");
                    this.setClientId(maoFroInitiateServiceCfm);
                    MessageLog.trace((int)5, this.getClass(), (String)"pvNegotiate(): sendMaoFroNotifySubscribeReq2");
                    this.sendMaoFroNotifySubscribeReq2();
                    this.sessionState = 1;
                    this.pvSessionObject.setProtocolVersion(string);
                } else {
                    MessageLog.trace((int)5, this.getClass(), (String)("Result is CFM but prefered PV is not supported.\n Preferred Version = " + string + "\n Supported: " + this.printSupportedPvs() + "\n Fro serviceName " + this.serviceName));
                    this.sessionState = 3;
                }
            } else if (maoFroInitiateServiceCfm.getResult() == 2) {
                String string = MaoFroAttributeHelper.getStringAttrValue(maoFroInitiateServiceCfm.getAttributes(), 14);
                int n = this.indexOfPv(string);
                if (n > 2) {
                    this.pushPvToFront(n);
                    this.pvNegotiate();
                } else {
                    MessageLog.trace((int)5, this.getClass(), (String)("Suspended  service name = " + this.serviceName + "\n Server PV = " + string + "\n Supported = " + this.printSupportedPvs()));
                    this.setClientId(maoFroInitiateServiceCfm);
                    this.sendMaoFroNotifySubscribeReq2();
                    this.sessionState = 2;
                }
            } else if (maoFroInitiateServiceCfm.getResult() == 3) {
                MessageLog.trace((int)5, this.getClass(), (String)("Rejected, service name = " + this.serviceName));
                this.sessionState = 3;
            } else {
                MessageLog.traceError(this.getClass(), (String)(" The result is neither of CFM, SUS or REJ.  service name = " + this.serviceName));
                this.sessionState = 3;
            }
        }
    }

    private boolean isSupportedPv(String string) {
        return this.indexOfPv(string) >= 0;
    }

    private int indexOfPv(String string) {
        for (int i = 0; i < this.supportedPvs.length; ++i) {
            if (!string.equals(this.supportedPvs[i])) continue;
            return i;
        }
        return -1;
    }

    private void pushPvToFront(int n) {
        String string = this.supportedPvs[n];
        for (int i = n; i > 0; --i) {
            this.supportedPvs[i] = this.supportedPvs[i - 1];
        }
        this.supportedPvs[0] = string;
    }

    private String printSupportedPvs() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.supportedPvs.length; ++i) {
            stringBuffer.append(this.supportedPvs[i]);
            if (i >= this.supportedPvs.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private MaoFroInitiateServiceCfm sendMaoFroInitiateServiceReq(String string, String string2, String string3) {
        MaoFroAttributeStruct[] maoFroAttributeStructArray = new MaoFroAttributeStruct[]{MaoFroAttributeHelper.makeStringAttr(10, string), MaoFroAttributeHelper.makeStringAttr(11, string2), MaoFroAttributeHelper.makeStringAttr(18, string3)};
        MaoFroInitiateServiceReq maoFroInitiateServiceReq = new MaoFroInitiateServiceReq(2, this.froType, 2, maoFroAttributeStructArray);
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)this.pvSessionObject.getFroProcess(), (Signal)maoFroInitiateServiceReq, (Class)MaoFroInitiateServiceCfm.class, (int)5000);
        if (signal == null) {
            MessageLog.trace((int)5, this.getClass(), (String)("serviceName " + this.serviceName + ", sendMaoFroInitiateServiceReq() rspSig == null, " + "received time-out"));
            return null;
        }
        if (signal instanceof MaoFroInitiateServiceCfm) {
            return (MaoFroInitiateServiceCfm)signal;
        }
        MessageLog.trace((int)5, this.getClass(), (String)("serviceName " + this.serviceName + ", sendMaoFroInitiateServiceReq(), received rspSig = " + signal.getClass()));
        return null;
    }

    private void sendMaoFroNotifySubscribeReq2() {
        MessageLog.trace((int)5, this.getClass(), (String)("serviceName " + this.serviceName + ", sendMaoFroNotifySubscribeReq2"));
        MaoFroNotifySubscribeReq2 maoFroNotifySubscribeReq2 = new MaoFroNotifySubscribeReq2(1, this.pvSessionObject.getClientId(), this.froType);
        OseProcess oseProcess = PortManager.instance().getOseProcess();
        SignalHelper.sendWithSender((OseProcess)this.pvSessionObject.getFroProcess(), (OseProcess)oseProcess, (Signal)maoFroNotifySubscribeReq2);
    }

    private void setClientId(MaoFroInitiateServiceCfm maoFroInitiateServiceCfm) {
        this.pvSessionObject.setClientId(MaoFroAttributeHelper.getIntAttrValue(maoFroInitiateServiceCfm.getAttributes(), 16));
    }

    public static class PVSessionObject {
        private int clientId;
        private OseProcess froProcess;
        private String protocolVersion;

        private PVSessionObject() {
        }

        private void setFroProcess(OseProcess oseProcess) {
            this.froProcess = oseProcess;
        }

        private void setClientId(int n) {
            this.clientId = n;
        }

        public int getClientId() {
            return this.clientId;
        }

        public OseProcess getFroProcess() {
            return this.froProcess;
        }

        private void setProtocolVersion(String string) {
            this.protocolVersion = string;
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }
    }
}

