/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import se.ericsson.cello.managedelement.StartTime;
import se.ericsson.cello.managedelement.fropxy.FroHealthCheckResultObserver;
import se.ericsson.cello.managedelement.fropxy.FroHealthCheckResultProvider;
import se.ericsson.cello.managedelement.suaccess.DiskHealthCheckResultFileSystemInformation;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.property.PropertyChangeHandler;

public class SU_ME_HealthCheckCoordinator
implements FroHealthCheckResultObserver {
    private long myRequestId;
    private int myMeFroResultCode = -1;
    private String myMessage = null;

    public SU_ME_HealthCheckCoordinator() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"SU_ME_HealthCheckCoordinator()");
        StartTime startTime = StartTime.now();
        this.myRequestId = startTime.toLong() & 0xFFFFFFFFL;
    }

    public void execute(FroHealthCheckResultProvider froHealthCheckResultProvider) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"execute(FroHealthCheckResultProvider anOsaMeMgmntProxy)", (String)("anOsaMeMgmntProxy: " + froHealthCheckResultProvider));
        try {
            froHealthCheckResultProvider.addFroHealthCheckResultObserver(this);
            this.myMeFroResultCode = froHealthCheckResultProvider.sendOsaMeFsHealthCheckReq(this.myRequestId);
            if (this.myMeFroResultCode != 0) {
                froHealthCheckResultProvider.removeFroHealthCheckResultObserver(this);
                DiskHealthCheckResultFileSystemInformation diskHealthCheckResultFileSystemInformation = new DiskHealthCheckResultFileSystemInformation(this.myMeFroResultCode, "File System Disk Healt Check not possible to start due to given result code");
                PropertyChangeHandler.instance().firePropertyChange("FileSystemHealthCheckProperty", (Object)"NoOldValue", (Object)diskHealthCheckResultFileSystemInformation);
            }
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"execute(OsaMeMgmntProxy anOsaMeMgmntProxy)", (String)("anOsaMeMgmntProxy: " + froHealthCheckResultProvider), (Throwable)throwable);
            froHealthCheckResultProvider.removeFroHealthCheckResultObserver(this);
            DiskHealthCheckResultFileSystemInformation diskHealthCheckResultFileSystemInformation = new DiskHealthCheckResultFileSystemInformation(DiskHealthCheckResultFileSystemInformation.FS_HEALTHCHECK_REJECTED, "File System Disk Healt Check not performed due to ,\n\tThrowable: " + throwable);
            PropertyChangeHandler.instance().firePropertyChange("FileSystemHealthCheckProperty", (Object)"NoOldValue2", (Object)diskHealthCheckResultFileSystemInformation);
        }
    }

    public void froHealthCheckResultUpdated(long l, int n, String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"froHealthCheckResultUpdated(long aRequestId, int aResultCode, String aMessage)", (String)("aRequestId: " + l + "\n\taResultCode: " + n + "\n\taMessage: " + string));
        this.myMeFroResultCode = n;
        this.myMessage = string;
        if (this.myMessage == null) {
            this.myMessage = "";
        }
        PropertyChangeHandler.instance().firePropertyChange("FileSystemHealthCheckProperty", (Object)"NoOldValue2", (Object)new DiskHealthCheckResultFileSystemInformation(this.myMeFroResultCode, this.myMessage));
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"froHealthCheckResultUpdated(long aRequestId, int aResultCode, String aMessage)", (String)"After firePropertyChange(....)");
    }
}

