/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.managedelement.SystemFunctionsMoImpl;
import se.ericsson.cello.managedelement.TimeSettingMo;
import se.ericsson.cello.managedelement.osa_timesetting_mi;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.mao.StringChecksUtils;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class TimeSettingMoImpl
extends CelloMao
implements ManagedObject,
TimeSettingMo {
    private static TimeSettingMoImpl instance;
    private static final int TIMESETTING_FRO_ID = 1;
    private static final String TIMESETTING_ID_VALUE = "1";
    private static final String USERLABEL = "";
    private static String[] ATTRIBUTES_TO_REQUEST_FROM_FRO;
    protected FroProxy froProxy = null;
    protected MoData data;
    private static final TagNameDictionary DICTIONARY;
    protected MaoFroIndicationHandler indHandler;
    protected static final int MO_DATA_REVISION_LATEST = 9000;
    private static final int NODE_UTCT_TIME_MIN = 0;

    public static synchronized TimeSettingMoImpl instance() {
        if (instance == null) {
            try {
                instance = new TimeSettingMoImpl();
            }
            catch (MoAccessException moAccessException) {
                UpgradeTrace.error((Class)TimeSettingMoImpl.class, (String)"instance()", (String)"Exception caught when trying to create a singleton instance of Mo WebServerMoImpl.", (Throwable)moAccessException);
            }
        }
        return instance;
    }

    protected synchronized void registerData(FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) {
        if (this.data == null) {
            this.froProxy = froProxy;
            this.indHandler = maoFroIndicationHandler;
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"registerData()", (String)("aCoordinator: " + Lib.toString(coordinator)));
                this.data = new MoData(this.getLocalDistinguishedName(), "TimeSetting", true, coordinator);
                this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, USERLABEL));
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.data.setRevision(9000);
                maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, 1);
                control.getTerminator().commit();
            }
            catch (Throwable throwable) {
                UpgradeTrace.warning(this.getClass(), (String)"registerData()", (String)("Start of WebServer failed, throwable caught.\n\tThrowable: " + throwable));
            }
        }
    }

    protected void recover(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        this.froProxy = froProxy;
        this.data = moData;
        this.indHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
    }

    private TimeSettingMoImpl() throws MoNameAlreadyTakenException {
        super((ManagedObject)SystemFunctionsMoImpl.instance(), "TimeSetting", TIMESETTING_ID_VALUE, null);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"TimeSettingMoImpl()");
        ServiceLocatorFacade.getRepository().addService((Object)this, TimeSettingMo.class, null);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setTimeOffset(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("timeOffset", string, coordinator);
    }

    public String getTimeOffset(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("timeOffset", coordinator);
    }

    public boolean getDaylightSavingTimeOn(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("daylightSavingTimeOn", coordinator);
    }

    public void setDaylightSavingTimeOffset(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("daylightSavingTimeOffset", string, coordinator);
    }

    public String getDaylightSavingTimeOffset(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("daylightSavingTimeOffset", coordinator);
    }

    public void setDaylightSavingTimeEndDate(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("daylightSavingTimeEndDate", string, coordinator);
    }

    public String getDaylightSavingTimeEndDate(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("daylightSavingTimeEndDate", coordinator);
    }

    public void setDaylightSavingTimeStartDate(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("daylightSavingTimeStartDate", string, coordinator);
    }

    public String getDaylightSavingTimeStartDate(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("daylightSavingTimeStartDate", coordinator);
    }

    public void setDaylightSavingTimeOffDate(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("daylightSavingTimeEndDate", string, coordinator);
    }

    public String getDaylightSavingTimeOffDate(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("daylightSavingTimeEndDate", coordinator);
    }

    public void setDaylightSavingTimeOnDate(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("daylightSavingTimeStartDate", string, coordinator);
    }

    public String getDaylightSavingTimeOnDate(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("daylightSavingTimeStartDate", coordinator);
    }

    public void setGpsToUtcLeapSeconds(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("gpsToUtcLeapSeconds", new Integer(n), coordinator);
    }

    public int getGpsToUtcLeapSeconds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("gpsToUtcLeapSeconds", coordinator);
    }

    public void setGpsToUtcLeapSecondsChangeDate(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("gpsToUtcLeapSecondsChangeDate", string, coordinator);
    }

    public String getGpsToUtcLeapSecondsChangeDate(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("gpsToUtcLeapSecondsChangeDate", coordinator);
    }

    public long getNodeUTCTime(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("nodeUTCTime", coordinator);
    }

    public void actionSetNodeUTCTime(long l, Coordinator coordinator) throws MoAccessException {
        Object object;
        if (l < 0L) {
            throw new ValueOutOfRangeException("TimeSetting", "NodeUTCTime can not be set to a time before January 1,1970, 00:00:00 GMT.");
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        MoIterator moIterator = MoRepository.instance().lookupType("NtpServer");
        while (moIterator != null && moIterator.hasMoreElements()) {
            object = (NtpServerMo)moIterator.nextElement();
            if (!object.getServiceActive(coordinator)) continue;
            throw new ActionNotAllowedException("TimeSetting", "serviceActive must be false on all NtpServer. " + object.getLocalDistinguishedName() + " is active");
        }
        object = new ArrayList();
        ((ArrayList)object).add(new UnsignedIntParameter("nodeUTCTime", l /= 1000L));
        this.froProxy.actionWithCfm(coordinator, 1, 1, (Collection)object);
    }

    public String getType() {
        return "TimeSetting";
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("daylightSavingTimeOffDate")) {
                n2 = i;
                stringArray[i] = "daylightSavingTimeEndDate";
            }
            if (!stringArray[i].equalsIgnoreCase("daylightSavingTimeOnDate")) continue;
            n = i;
            stringArray[i] = "daylightSavingTimeStartDate";
        }
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, 1, ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            StringParameter stringParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("timeOffset")) {
                stringParameter = (StringParameter)getRequestContextImpl.getParameter("timeOffset");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: timeOffset", "getAttributes", -1);
                }
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("daylightSavingTimeOn")) {
                stringParameter = (SignedIntParameter)getRequestContextImpl.getParameter("daylightSavingTimeOn");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: daylightSavingTimeOn", "getAttributes", -1);
                }
                objectArray[i] = new Boolean(stringParameter.getBoolean());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("daylightSavingTimeOffset")) {
                stringParameter = (StringParameter)getRequestContextImpl.getParameter("daylightSavingTimeOffset");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: daylightSavingTimeOffset", "getAttributes", -1);
                }
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("daylightSavingTimeEndDate")) {
                stringParameter = (StringParameter)getRequestContextImpl.getParameter("daylightSavingTimeEndDate");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: daylightSavingTimeEndDate", "getAttributes", -1);
                }
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("daylightSavingTimeStartDate")) {
                stringParameter = (StringParameter)getRequestContextImpl.getParameter("daylightSavingTimeStartDate");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: daylightSavingTimeStartDate", "getAttributes", -1);
                }
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("gpsToUtcLeapSeconds")) {
                stringParameter = (SignedIntParameter)getRequestContextImpl.getParameter("gpsToUtcLeapSeconds");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: gpsToUtcLeapSeconds", "getAttributes", -1);
                }
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("gpsToUtcLeapSecondsChangeDate")) {
                stringParameter = (StringParameter)getRequestContextImpl.getParameter("gpsToUtcLeapSecondsChangeDate");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: gpsToUtcLeapSecondsChangeDate", "getAttributes", -1);
                }
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nodeUTCTime")) {
                stringParameter = (UnsignedIntParameter)getRequestContextImpl.getParameter("nodeUTCTime");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("TimeSetting", "Missing parameter from FRO: nodeUTCTime", "getAttributes", -1);
                }
                objectArray[i] = new Long(stringParameter.getValue() * 1000L);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "TimeSetting");
        }
        if (n > -1) {
            stringArray[n] = "daylightSavingTimeOnDate";
        }
        if (n2 > -1) {
            stringArray[n2] = "daylightSavingTimeOffDate";
        }
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("TimeSetting");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "TimeSetting");
            }
            if (string.equalsIgnoreCase("timeOffset")) {
                if (object instanceof String) {
                    String string3 = (String)object;
                    this.validateTimeOffset(string3, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("timeOffset", string3));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("timeOffset", "TimeSetting");
            }
            if (string.equalsIgnoreCase("daylightSavingTimeOffset")) {
                if (object instanceof String) {
                    String string4 = (String)object;
                    this.validateDaylightSavingTimeOffset(string4, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("daylightSavingTimeOffset", string4));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("daylightSavingTimeOffset", "TimeSetting");
            }
            if (string.equalsIgnoreCase("daylightSavingTimeEndDate") || string.equalsIgnoreCase("daylightSavingTimeOffDate")) {
                if (object instanceof String) {
                    String string5 = (String)object;
                    this.validatedaylightSavingTimeEndDate(string5, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("daylightSavingTimeEndDate", string5));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("daylightSavingTimeEndDate", "TimeSetting");
            }
            if (string.equalsIgnoreCase("daylightSavingTimeStartDate") || string.equalsIgnoreCase("daylightSavingTimeOnDate")) {
                if (object instanceof String) {
                    String string6 = (String)object;
                    this.validatedaylightSavingTimeStartDate(string6, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("daylightSavingTimeStartDate", string6));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("daylightSavingTimeStartDate", "TimeSetting");
            }
            if (string.equalsIgnoreCase("gpsToUtcLeapSeconds")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateGpsToUtcLeapSeconds(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("gpsToUtcLeapSeconds", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("gpsToUtcLeapSeconds", "TimeSetting");
            }
            if (string.equalsIgnoreCase("gpsToUtcLeapSecondsChangeDate")) {
                if (object instanceof String) {
                    String string7 = (String)object;
                    this.validateGpsToUtcLeapSecondsChangeDate(string7, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("gpsToUtcLeapSecondsChangeDate", string7));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("gpsToUtcLeapSecondsChangeDate", "TimeSetting");
            }
            throw new NoSuchAttributeException(string, "TimeSetting");
        }
        setRequestContextImpl.sendSetRequest(this.froProxy, 1);
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Iterator iterator = map.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                SignedIntParameter signedIntParameter;
                string = (String)iterator.next();
                if (string.equals("daylightSavingTimeOn")) {
                    signedIntParameter = (SignedIntParameter)map.get("daylightSavingTimeOn");
                    setRequestContextImpl.addAvcNotification("daylightSavingTimeOn", (Object)new Boolean(signedIntParameter.getBoolean()));
                    continue;
                }
                if (string.equals("gpsToUtcLeapSeconds")) {
                    signedIntParameter = (SignedIntParameter)map.get("gpsToUtcLeapSeconds");
                    setRequestContextImpl.addAvcNotification("gpsToUtcLeapSeconds", (Object)new Integer(signedIntParameter.getValue()));
                    continue;
                }
                MessageLog.info(this.getClass(), (String)("Unknown attribute in parameterChanged() " + string));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not found ");
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"TimeSetting");
    }

    protected void validateTimeOffset(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"timeOffset", (int)6, (int)0, (String)"TimeSetting");
        this.validateFormat(string, USERLABEL, "[-]dd:dd", "Should be in the form [-]hh:mm");
    }

    protected void validateDaylightSavingTimeOffset(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"daylightSavingTimeOffset", (int)5, (int)0, (String)"TimeSetting");
        this.validateSimpleFormat(string, USERLABEL, "dd:dd", " Should be in the form yyyy-mm-dd hh:mm");
    }

    protected void validatedaylightSavingTimeEndDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"daylightSavingTimeEndDate", (int)16, (int)0, (String)"TimeSetting");
        this.validateSimpleFormat(string, USERLABEL, "dddd-dd-dd dd:dd", " Should be in the form yyyy-mm-dd hh:mm");
    }

    protected void validatedaylightSavingTimeStartDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"daylightSavingTimeStartDate", (int)16, (int)0, (String)"TimeSetting");
        this.validateSimpleFormat(string, USERLABEL, "dddd-dd-dd dd:dd", " Should be in the form yyyy-mm-dd hh:mm");
    }

    private void validateSimpleFormat(String string, String string2, String string3, String string4) throws IllegalAttributeValueException {
        boolean bl = true;
        if (!string.equals(string2)) {
            bl = StringChecksUtils.validateFormat((String)string, (String)string3);
        }
        if (!bl) {
            throw new IllegalAttributeValueException("Wrong attribute format. " + string4, "TimeSetting");
        }
    }

    protected void validateGpsToUtcLeapSeconds(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"gpsToUtcLeapSeconds", (int)n, (int)-1000, (int)1000, (String)"TimeSetting");
    }

    protected void validateGpsToUtcLeapSecondsChangeDate(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"gpsToUtcLeapSecondsChangeDate", (int)11, (int)0, (String)"TimeSetting");
        this.validateFormat(string, USERLABEL, "[-]dddd-dd-dd", "Should be in the form [-]yyyy-mm-dd)");
    }

    private void validateFormat(String string, String string2, String string3, String string4) throws IllegalAttributeValueException {
        boolean bl = true;
        if (!string.equals(string2)) {
            bl = StringChecksUtils.validateFormatWithOptionalChars((String)string, (String)string3);
        }
        if (!bl) {
            throw new IllegalAttributeValueException("Wrong attribute format." + string4, "TimeSetting");
        }
    }

    static {
        ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"timeOffset", "daylightSavingTimeOn", "daylightSavingTimeOffset", "daylightSavingTimeEndDate", "daylightSavingTimeStartDate", "gpsToUtcLeapSeconds", "gpsToUtcLeapSecondsChangeDate", "nodeUTCTime"};
        DICTIONARY = TagNameDictionaries.create((ResourceBundle)new osa_timesetting_mi());
    }
}

