/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.util.library;

import java.io.File;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.productinventory.UpSwData;
import se.ericsson.cello.productinventory.UpgradePackageProductData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;

public class Lib {
    public static final String EMPTY_STRING = "";
    public static final String WHITE_SPACE = " ";
    private static final char WHITE_SPACE_CHAR = ' ';

    public static AttrList clone(AttrList attrList) {
        if (attrList == null) {
            return null;
        }
        AttrListImpl attrListImpl = new AttrListImpl();
        String string = null;
        Object object = null;
        try {
            for (int i = 0; i < attrList.size(); ++i) {
                string = attrList.getName(i);
                object = attrList.getValue(i);
                attrListImpl.addElement(string, object);
            }
            return attrListImpl;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)Lib.class, (String)"clone(AttrList anAttrList)", (String)("Throwable caught when trying to clone the AttrList data to an other AttrList.\n\tanAttrList: " + attrList + "\n\ttheName:" + string + "\n\ttheValue:" + object + "\n\tThrowable data: " + throwable.toString()), (Throwable)throwable);
            return attrList;
        }
    }

    public static String convertByteArrayToString(byte[] byArray) {
        UpgradeTrace.debug((Class)Lib.class, (int)70, (String)"convertByteArrayToString(byte[ ] aByteArray)", (String)("aByteArray: " + byArray));
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if ((char)byArray[i] != '\u0000') continue;
            n = i + 1;
            break;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return new String(cArray).trim();
    }

    public static boolean convertIntToBoolean(int n) {
        UpgradeTrace.debug((Class)Lib.class, (int)70, (String)"convertIntToBoolean(int anInt)", (String)("anInt: " + n));
        return n != 0;
    }

    public static boolean convertLongToInvertedBoolean(long l) {
        UpgradeTrace.debug((Class)Lib.class, (int)70, (String)"convertLongToInvertedBoolean(long aLong)", (String)("aLong: " + l));
        return l == 0L;
    }

    public static byte[] convertStringToByteArray(String string, int n) {
        UpgradeTrace.debug((Class)Lib.class, (int)70, (String)"convertStringToByteArray(String aString, int aByteArrayLength)", (String)("aString: " + string + "\n\taByteArrayLength: " + n));
        byte[] byArray = new byte[n];
        char[] cArray = new char[n];
        int n2 = string.length() <= n ? string.length() : n;
        string.getChars(0, n2, cArray, 0);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static String toString(File file) {
        String string = "NULL";
        if (file != null) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static String toString(ManagedObject[] managedObjectArray) {
        String string = "[ ";
        try {
            if (managedObjectArray != null) {
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    string = i < managedObjectArray.length - 1 ? string + managedObjectArray[i] + ", " : string + managedObjectArray[i] + " ]";
                }
                if (managedObjectArray.length == 0) {
                    string = string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Exception exception) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Exception caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + string + "\n\tException data: " + exception.toString()), (Throwable)exception);
            return string;
        }
        catch (Error error) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Error caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + string + "\n\tError data: " + error.toString()), (Throwable)error);
            return string;
        }
    }

    public static String toString(AdditionalInfo[] additionalInfoArray) {
        String string = "[";
        try {
            if (additionalInfoArray != null) {
                if (additionalInfoArray.length == 0) {
                    return "[]";
                }
                for (int i = 0; i < additionalInfoArray.length; ++i) {
                    string = i < additionalInfoArray.length - 1 ? string + Lib.toString(additionalInfoArray[i]) + ",\n" : string + Lib.toString(additionalInfoArray[i]) + "]";
                }
                return string;
            }
            return "[]";
        }
        catch (Exception exception) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Exception caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + string + "\n\tException data: " + exception.toString()), (Throwable)exception);
            return string;
        }
        catch (Error error) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Error caught when trying to translate the array of managed objects to a string.\n\ttheManagedObjectsString: " + string + "\n\tError data: " + error.toString()), (Throwable)error);
            return string;
        }
    }

    public static boolean isContainingWhiteSpaceOrLowerCase(String string) {
        if (string != null) {
            if (Lib.containsWhiteSpace(string)) {
                return true;
            }
            if (Lib.containsLowerCase(string)) {
                return true;
            }
        }
        return false;
    }

    public static String optimize(String string) {
        if (string != null) {
            if (Lib.containsWhiteSpace(string)) {
                string = Lib.removeWhiteSpaces(string);
            }
            if (Lib.containsLowerCase(string)) {
                string = string.toUpperCase();
            }
        }
        return string;
    }

    public static boolean containsWhiteSpace(String string) {
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ') continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsLowerCase(String string) {
        boolean bl = false;
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLowerCase(string.charAt(i))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String removeWhiteSpaces(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = EMPTY_STRING;
        StringTokenizer stringTokenizer = new StringTokenizer(string, WHITE_SPACE);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2;
    }

    public static String toString(AdditionalInfo additionalInfo) {
        try {
            return "{ " + additionalInfo.getName() + ", " + additionalInfo.getValue() + " }";
        }
        catch (Exception exception) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Exception caught when trying to translate the AdditionalInfo data to a string.\n\tanAdditionalInfo: " + additionalInfo + "\n\tException data: " + exception.toString()), (Throwable)exception);
            return "{ " + additionalInfo + " }";
        }
        catch (Error error) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(ManagedObject[] aManagedObjects)", (String)("Exception caught when trying to translate the AdditionalInfo data to a string.\n\tanAdditionalInfo: " + additionalInfo + "\n\tException data: " + error.toString()), (Throwable)error);
            return "{ " + additionalInfo + " }";
        }
    }

    public static String toString(StringTokenizer stringTokenizer) {
        String string = EMPTY_STRING;
        try {
            while (stringTokenizer.hasMoreElements()) {
                string = string + stringTokenizer.nextToken();
            }
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(StringTokenizer aStringTokenizer)", (String)("Throwable caught when trying to translate the StringTokenizer to a string.\n\taStringTokenizer: " + stringTokenizer + "\n\ttheStringTokenizerString:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(int[] nArray) {
        String string = "[ ";
        try {
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    string = i < nArray.length - 1 ? string + nArray[i] + ", " : string + nArray[i] + " ]";
                }
                if (nArray.length == 0) {
                    return string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(int[] anIntArray)", (String)("Throwable caught when trying to translate an int Array to a String.\n\tanIntArray: " + nArray + "\n\ttheInts:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(Struct struct) {
        String string = "NULL";
        if (struct != null) {
            string = EMPTY_STRING;
            try {
                String[] stringArray = struct.getNames();
                Object[] objectArray = struct.getValues();
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + "\n\t" + stringArray[i] + ": " + objectArray[i];
                }
            }
            catch (Exception exception) {
                UpgradeTrace.debug((Class)Lib.class, (int)72, (String)"toString(Struct aStruct)", (String)("Exception caught: " + exception.toString()));
                string = string + exception.toString();
            }
        }
        return string;
    }

    public static String toString(Struct[] structArray) {
        String string = "NULL";
        if (structArray != null) {
            string = EMPTY_STRING;
            for (int i = 0; i < structArray.length; ++i) {
                string = string + "\n\tarray index: " + i + Lib.toString(structArray[i]);
            }
        }
        return string;
    }

    public static String toString(Coordinator coordinator) {
        String string = EMPTY_STRING;
        if (coordinator != null) {
            try {
                int n = coordinator.getTransactionID();
                string = string + "\n\t\tTransaction ID: " + n;
                String string2 = "UNKNOWN";
                if (coordinator.getStatus() == Status.ACTIVE) {
                    string2 = "ACTIVE";
                } else if (coordinator.getStatus() == Status.MARKED_ROLLBACK) {
                    string2 = "MARKED_ROLLBACK";
                } else if (coordinator.getStatus() == Status.NO_TRANSACTION) {
                    string2 = "NO_TRANSACTION";
                }
                string = string + "\n\t\tTransaction status: " + string2;
            }
            catch (Exception exception) {
                UpgradeTrace.debug((Class)Lib.class, (int)72, (String)"toString(Coordinator aCoordinator)", (String)("Exception caught: " + exception.toString()));
                string = string + exception.toString();
            }
            return string;
        }
        return "null";
    }

    public static String toString(AttrList attrList) {
        String string = "[ ";
        try {
            if (attrList == null) {
                return "null";
            }
            for (int i = 0; i < attrList.size(); ++i) {
                string = string + "\n\t" + attrList.getName(i) + ": ";
                string = string + attrList.getValue(i);
                if (i >= attrList.size() - 1) continue;
                string = string + ",";
            }
            string = string + "\n]";
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(AttrList anAttrList)", (String)("Throwable caught when trying to translate the AttrList data to a string.\n\tanAttrList: " + attrList + "\n\ttheString:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(SequenceAttribute sequenceAttribute) {
        String string = EMPTY_STRING;
        try {
            Enumeration enumeration = sequenceAttribute.elements();
            while (enumeration.hasMoreElements()) {
                StringAttribute stringAttribute = (StringAttribute)enumeration.nextElement();
                string = string + stringAttribute.getValue(null);
            }
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(SequenceAttribute aSeq)", (String)("Throwable caught when trying to translate the SequenceAttribute to a string.\n\taSeq: " + sequenceAttribute + "\n\ttheSeqAttrString:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(String[] stringArray) {
        String string = "[ ";
        try {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = i < stringArray.length - 1 ? string + stringArray[i] + ", " : string + stringArray[i] + " ]";
                }
                if (stringArray.length == 0) {
                    return string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(String[] aStringArray)", (String)("Throwable caught when trying to translate a String Array to a String.\n\taStringArray: " + stringArray + "\n\ttheStrings:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(UpSwData[] upSwDataArray) {
        String string = "[ ";
        try {
            if (upSwDataArray != null) {
                for (int i = 0; i < upSwDataArray.length; ++i) {
                    string = i < upSwDataArray.length - 1 ? string + upSwDataArray[i].productNumber + "\t" + upSwDataArray[i].revision + ", " : string + upSwDataArray[i].productNumber + "\t" + upSwDataArray[i].revision + " ]";
                }
                if (upSwDataArray.length == 0) {
                    return string + "]";
                }
                return string;
            }
            return "null";
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(UpSwData[] anUpSwList)", (String)("Throwable caught when trying to translate an UpSwData Array to a String.\n\tanUpSwList: " + upSwDataArray + "\n\ttheUpSwLists:" + string + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static String toString(UpgradePackageProductData.UpStatus upStatus) {
        String string = "UnknownStatus";
        try {
            if (upStatus != null) {
                if (upStatus.equals(UpgradePackageProductData.PARTIALLY_INSTALLED)) {
                    string = "PARTIALLY_INSTALLED";
                } else if (upStatus.equals(UpgradePackageProductData.INSTALLED)) {
                    string = "INSTALLED";
                } else if (upStatus.equals(UpgradePackageProductData.SYSTEMUSED)) {
                    string = "SYSTEMUSED";
                } else if (upStatus.equals(UpgradePackageProductData.EXECUTING)) {
                    string = "EXECUTING";
                } else if (upStatus.equals(UpgradePackageProductData.ONLYDELETABLE)) {
                    string = "ONLYDELETABLE";
                }
            }
            return string;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error((Class)Lib.class, (String)"toString(UpStatus anUP_Status)", (String)("Throwable caught when trying to translate an UpState to a String.\n\tanUP_Status: " + upStatus + "\n\tException data: " + throwable.toString()), (Throwable)throwable);
            return string + " (Note: The string is not complete due to Throwable caught.)";
        }
    }

    public static Vector translateToVector(Object[] objectArray) {
        UpgradeTrace.debug((Class)Lib.class, (int)70, (String)"translateToVector(Object[] anObjects)", (String)("anObjects: " + objectArray));
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    public static synchronized LinkedList getSubStrings(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(string2, n);
            string3 = Lib.getSubString(string, n, n2);
            linkedList.addLast(string3);
            n = n2 + 1;
        }
        return linkedList;
    }

    private static String getSubString(String string, int n, int n2) {
        if (n2 != -1) {
            return string.substring(n, n2);
        }
        return string.substring(n);
    }

    public static String toString(Object[] objectArray) {
        if (objectArray instanceof Struct[]) {
            return Lib.toString((Struct[])objectArray);
        }
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append('[');
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(objectArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

