/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import java.io.File;
import se.ericsson.cello.equipment.LoadModuleBuildIF;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ConvertWeekOfYearToDate;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.productinventory.CustomerProductInfoData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.productinventory.SoftwareProductData;
import se.ericsson.cello.property.PropertyChangeHandler;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.LoadModuleMoInternal;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.swmaccess.LoadModuleFileStateChangeInformation;
import se.ericsson.cello.swmanagement.swmaccess.ReplicatedLoadModuleFileRemoverAccess;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class LoadModuleMoImpl
extends ManagedObjectBase
implements LoadModuleMoInternal,
LoadModuleMoSU_Access,
LoadModuleBuildIF,
SoftwareProductData,
CustomerProductInfoData,
Resource {
    private MoData data;
    private IntegerAttribute loadClass;
    private StringAttribute userLabel;
    private StringAttribute productInfo;
    private StringAttribute productionDate;
    private StringAttribute productName;
    private StringAttribute productNumber;
    private StringAttribute productRevision;
    private StringAttribute loadModuleFilePath;
    private StringAttribute otherLoaderName;
    private StringAttribute fileFormat;
    private StringAttribute reliableProgramLabel;
    private IntegerAttribute loaderType;
    private IntegerAttribute preLoad;
    private IntegerAttribute oseProgramPoolSize;
    private IntegerAttribute oseProgramHeapSize;
    private BooleanAttribute programMustBeSingleton;
    private BooleanAttribute isDirectory;
    private BooleanAttribute reservedByUpgradePackage;
    private SequenceAttribute moppletEntries;
    private BooleanAttribute isCpiType;
    private StringAttribute funcId;
    private StringAttribute deviceLoaderName;
    private StringAttribute deviceLoaderInformation;
    private IntegerAttribute fileState;
    private StringAttribute dynamicClassName;
    private BooleanAttribute isSignedSw;
    private StringAttribute signatureFileNameExtension;
    private IntegerAttribute restartCounterLimit;
    private IntegerAttribute restartTimer;
    private int transactionReTryCounter;
    private boolean keepTrying;
    private int operationType;
    private Coordinator myCoordinator;
    private static final int CREATE_OPERATION = 1;
    private static final int DELETE_OPERATION = 2;
    private static final int SET_FILE_STATE_OPERATION = 3;
    private static final int UNDEF_OPERATION = -1;
    private static final int RETRY_INTERVAL = 2000;
    private static final int MAX_NO_OF_RETRIES = 10;
    private static final int PRODUCT_INFO_MAX_LENGTH = 1024;
    private static final boolean DEFAULT_IS_DIRECTORY = false;
    private static final String DEFAULT_FILE_FORMAT = "";
    private static final String DEFAULT_RELIABLE_PROGRAM_LABEL = "";
    private String lmFilePath;
    private boolean isDir;
    private boolean isSSW;
    private String signatureFileNameExt;
    private int newFileState = -1;
    String myProductNumberOpt = null;
    String myProductRevisionOpt = null;
    private static final String[] adminProductDataNames = new String[]{"productNumber", "productRevision", "productName", "productInfo", "productionDate"};
    protected static final String[] SUPPORTED_VERSIONS = new String[]{"SU_2", "SU_3", "SU_4", "SU_5", "SU_6", "SU_7", "SU_8"};
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_6_1 = 6100;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MO_DATA_REVISION_13_1 = 13100;
    private static final int MO_DATA_REVISION_15_1 = 15100;
    private static final int MO_DATA_REVISION_LATEST = 15100;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context)", (String)("parent: " + managedObject + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"LoadModule", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"SwManagement");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"LoadModule", (int)128, (int)0);
        MoAttributeValidator.checkIdentity((String)"LoadModule", (String)string);
        Struct struct = LoadModuleMoImpl.checkAndGetProductData(attrList);
        String string3 = LoadModuleMoImpl.checkAndGetLoadModuleFilePath(attrList);
        int n = LoadModuleMoImpl.checkAndGetLoaderType(attrList);
        String string4 = LoadModuleMoImpl.checkAndGetOtherLoaderName(attrList);
        int n2 = LoadModuleMoImpl.checkAndGetPreLoad(attrList);
        String string5 = LoadModuleMoImpl.checkAndGetFileFormat(attrList);
        int n3 = LoadModuleMoImpl.checkAndGetOseProgramLoadClass(attrList);
        String string6 = LoadModuleMoImpl.checkAndGetReliableProgramLabel(attrList);
        boolean bl = LoadModuleMoImpl.checkAndGetIsDirectory(attrList, string3);
        int n4 = LoadModuleMoImpl.checkAndGetOseProgramPoolSize(attrList);
        int n5 = LoadModuleMoImpl.checkAndGetOseProgramHeapSize(attrList);
        boolean bl2 = LoadModuleMoImpl.checkAndGetProgramMustBeSingleton(attrList);
        String[] stringArray = LoadModuleMoImpl.checkAndGetMoppletEntries(attrList);
        boolean bl3 = LoadModuleMoImpl.checkAndGetCpiType(attrList);
        int n6 = LoadModuleMoImpl.checkAndGetRestartCounterLimit(attrList);
        int n7 = LoadModuleMoImpl.checkAndGetRestartTimer(attrList);
        String string7 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"funcId", (AttrList)attrList, (boolean)false, (String)"", (String)"LoadModule", (int)40, (int)0);
        String string8 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"deviceLoaderName", (AttrList)attrList, (boolean)false, (String)"", (String)"LoadModule", (int)80, (int)0);
        String string9 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"deviceLoaderInformation", (AttrList)attrList, (boolean)false, (String)"", (String)"LoadModule", (int)255, (int)0);
        String string10 = LoadModuleMoImpl.checkAndGetDynamicClassName(attrList);
        boolean bl4 = LoadModuleMoImpl.checkAndGetIsSignedSw(attrList);
        String string11 = LoadModuleMoImpl.checkAndGetSignatureFileNameExtension(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"LoadModule");
        return new LoadModuleMoImpl(managedObject, string, string2, struct, string3, n, string4, n2, string5, n3, string6, bl, n4, n5, bl2, stringArray, bl3, string7, string8, string9, string10, bl4, string11, n6, n7, coordinator);
    }

    private LoadModuleMoImpl(ManagedObject managedObject, String string, String string2, Struct struct, String string3, int n, String string4, int n2, String string5, int n3, String string6, boolean bl, int n4, int n5, boolean bl2, String[] stringArray, boolean bl3, String string7, String string8, String string9, String string10, boolean bl4, String string11, int n6, int n7, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "LoadModule", string, coordinator);
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"LoadModuleMoImpl(ManagedObject parent, String identity, String userLabel, Struct productData, String aLoadModuleFilePath, int loaderType, String otherLoaderName, int preLoad, String fileFormat, int loadClass, String reliableProgramLabel, boolean anIsDirectory, int oseProgramPoolSize, int oseProgramHeapSize, boolean programMustBeSingleton, String[] moppletEntries, boolean isCpiType, String funcId, String deviceLoaderName, String deviceLoaderInformation, String aDynamicClassName, boolean anIsSignedSw, String aSignatureFileNameExtension, int aRestartCounterLimit, int aRestartTimer, Coordinator context)", (String)("parent: " + managedObject + "\n\tidentity: " + string + "\n\tuserLabel: " + string2 + "\n\tproductData: " + Lib.toString((Struct)struct) + "\n\taLoadModuleFilePath: " + string3 + "\n\tloaderType: " + n + "\n\totherLoaderName: " + string4 + "\n\tpreLoad: " + n2 + "\n\tfileFormat: " + string5 + "\n\tloadClass: " + n3 + "\n\treliableProgramLabel: " + string6 + "\n\tanIsDirectory: " + bl + "\n\toseProgramPoolSize: " + n4 + "\n\toseProgramHeapSize: " + n5 + "\n\tprogramMustBeSingleton: " + bl2 + "\n\tmoppletEntries: " + Lib.toString((String[])stringArray) + "\n\tisCpiType: " + bl3 + "\n\funcId:  " + string7 + "\n\tdeviceLoaderName:  " + string8 + "\n\tdeviceLoaderInformation:  " + string9 + "\n\taDynamicClassName: " + string10 + "\n\tanIsSignedSw: " + bl4 + "\n\taSignatureFileNameExtension: " + string11 + "\n\taRestartCounterLimit:" + n6 + "\n\taRestartTimer:" + n7 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.productInfo = new StringAttribute("productInfo", false, (String)struct.getValue("productInfo"));
        this.data.registerPersistentAttr((Attribute)this.productInfo);
        this.productNumber = new StringAttribute("productNumber", false, (String)struct.getValue("productNumber"));
        this.data.registerPersistentAttr((Attribute)this.productNumber);
        this.myProductNumberOpt = Lib.optimize((String)this.productNumber.getValue(null));
        this.productRevision = new StringAttribute("productRevision", false, (String)struct.getValue("productRevision"));
        this.data.registerPersistentAttr((Attribute)this.productRevision);
        this.myProductRevisionOpt = Lib.optimize((String)this.productRevision.getValue(null));
        this.productName = new StringAttribute("productName", false, (String)struct.getValue("productName"));
        this.data.registerPersistentAttr((Attribute)this.productName);
        this.productionDate = new StringAttribute("productionDate", false, (String)struct.getValue("productionDate"));
        this.data.registerPersistentAttr((Attribute)this.productionDate);
        this.loadModuleFilePath = new StringAttribute("loadModuleFilePath", false, string3);
        this.data.registerPersistentAttr((Attribute)this.loadModuleFilePath);
        this.otherLoaderName = new StringAttribute("otherLoaderName", false, string4);
        this.data.registerPersistentAttr((Attribute)this.otherLoaderName);
        this.deviceLoaderName = new StringAttribute("deviceLoaderName", false, string8);
        this.data.registerPersistentAttr((Attribute)this.deviceLoaderName);
        this.deviceLoaderInformation = new StringAttribute("deviceLoaderInformation", false, string9);
        this.data.registerPersistentAttr((Attribute)this.deviceLoaderInformation);
        this.fileFormat = new StringAttribute("fileFormat", true, string5);
        this.data.registerPersistentAttr((Attribute)this.fileFormat);
        this.reliableProgramLabel = new StringAttribute("reliableProgramLabel", false, string6);
        this.data.registerPersistentAttr((Attribute)this.reliableProgramLabel);
        this.loaderType = new IntegerAttribute("loaderType", false, n);
        this.data.registerPersistentAttr((Attribute)this.loaderType);
        this.loadClass = new IntegerAttribute("loadClass", false, n3);
        this.data.registerPersistentAttr((Attribute)this.loadClass);
        this.preLoad = new IntegerAttribute("preLoad", true, n2);
        this.data.registerPersistentAttr((Attribute)this.preLoad);
        this.oseProgramPoolSize = new IntegerAttribute("oseProgramPoolSize", true, n4);
        this.data.registerPersistentAttr((Attribute)this.oseProgramPoolSize);
        this.oseProgramHeapSize = new IntegerAttribute("oseProgramHeapSize", true, n5);
        this.data.registerPersistentAttr((Attribute)this.oseProgramHeapSize);
        this.restartCounterLimit = new IntegerAttribute("restartCounterLimit", false, n6);
        this.data.registerPersistentAttr((Attribute)this.restartCounterLimit);
        this.restartTimer = new IntegerAttribute("restartTimer", false, n7);
        this.data.registerPersistentAttr((Attribute)this.restartTimer);
        this.programMustBeSingleton = new BooleanAttribute("programMustBeSingleton", false, bl2);
        this.data.registerPersistentAttr((Attribute)this.programMustBeSingleton);
        this.isDirectory = new BooleanAttribute("isDirectory", false, bl);
        this.data.registerPersistentAttr((Attribute)this.isDirectory);
        this.reservedByUpgradePackage = new BooleanAttribute("reservedByUpgradePackage", true, false);
        this.data.registerPersistentAttr((Attribute)this.reservedByUpgradePackage);
        this.moppletEntries = new SequenceAttribute("moppletEntries", false);
        for (int i = 0; i < stringArray.length; ++i) {
            StringAttribute stringAttribute = new StringAttribute("", false, stringArray[i]);
            this.moppletEntries.addElement((Attribute)stringAttribute);
        }
        this.data.registerPersistentAttr((Attribute)this.moppletEntries);
        this.isCpiType = new BooleanAttribute("isCpiType", false, bl3);
        this.data.registerPersistentAttr((Attribute)this.isCpiType);
        this.funcId = new StringAttribute("funcId", false, string7);
        this.data.registerPersistentAttr((Attribute)this.funcId);
        this.dynamicClassName = new StringAttribute("dynamicClass", true, string10);
        this.data.registerPersistentAttr((Attribute)this.dynamicClassName);
        this.isSignedSw = new BooleanAttribute("isSignedSw", false, bl4);
        this.data.registerPersistentAttr((Attribute)this.isSignedSw);
        this.signatureFileNameExtension = new StringAttribute("signatureFileNameExtension", false, string11);
        this.data.registerPersistentAttr((Attribute)this.signatureFileNameExtension);
        this.fileState = new IntegerAttribute("fileState", true);
        this.data.registerPersistentAttr((Attribute)this.fileState);
        this.createFileStateAttribute(string3, bl, bl4, string11, coordinator);
        this.data.setRevision(15100);
        if (bl3) {
            ProductRepository.instance().registerCpi((CustomerProductInfoData)this, coordinator);
        } else {
            ProductRepository.instance().registerSw((SoftwareProductData)this, coordinator);
        }
        this.operationType = 1;
        this.registerResource(coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.lmFilePath = string3;
    }

    public LoadModuleMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"LoadModuleMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(15100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("productInfo");
        moDataRecoveryHelper.assertAttribute("productNumber");
        moDataRecoveryHelper.assertAttribute("productRevision");
        moDataRecoveryHelper.assertAttribute("productionDate");
        moDataRecoveryHelper.assertAttribute("productName");
        moDataRecoveryHelper.assertAttribute("loadModuleFilePath");
        moDataRecoveryHelper.assertAttribute("otherLoaderName");
        moDataRecoveryHelper.assertAttribute("fileFormat");
        moDataRecoveryHelper.assertAttribute("reliableProgramLabel");
        moDataRecoveryHelper.assertAttribute("loadClass");
        moDataRecoveryHelper.assertAttribute("loaderType");
        moDataRecoveryHelper.assertAttribute("preLoad");
        moDataRecoveryHelper.assertAttribute("oseProgramPoolSize");
        moDataRecoveryHelper.assertAttribute("oseProgramHeapSize");
        moDataRecoveryHelper.assertAttribute("programMustBeSingleton");
        moDataRecoveryHelper.assertAttribute("isDirectory");
        moDataRecoveryHelper.assertAttribute("reservedByUpgradePackage");
        moDataRecoveryHelper.assertAttribute("moppletEntries");
        moDataRecoveryHelper.assertAttribute("isCpiType");
        moDataRecoveryHelper.assertAttribute("funcId");
        moDataRecoveryHelper.assertAttribute("deviceLoaderName");
        moDataRecoveryHelper.assertAttribute("deviceLoaderInformation");
        moDataRecoveryHelper.assertAttribute("fileState");
        moDataRecoveryHelper.assertAttribute("dynamicClass");
        moDataRecoveryHelper.assertAttribute("isSignedSw");
        moDataRecoveryHelper.assertAttribute("signatureFileNameExtension");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.productInfo = (StringAttribute)moData.getAttribute("productInfo");
        this.productNumber = (StringAttribute)moData.getAttribute("productNumber");
        this.myProductNumberOpt = Lib.optimize((String)this.productNumber.getValue(null));
        this.productRevision = (StringAttribute)moData.getAttribute("productRevision");
        this.myProductRevisionOpt = Lib.optimize((String)this.productRevision.getValue(null));
        this.productionDate = (StringAttribute)moData.getAttribute("productionDate");
        this.productName = (StringAttribute)moData.getAttribute("productName");
        this.loadModuleFilePath = (StringAttribute)moData.getAttribute("loadModuleFilePath");
        this.otherLoaderName = (StringAttribute)moData.getAttribute("otherLoaderName");
        this.fileFormat = (StringAttribute)moData.getAttribute("fileFormat");
        this.reliableProgramLabel = (StringAttribute)moData.getAttribute("reliableProgramLabel");
        this.loadClass = (IntegerAttribute)moData.getAttribute("loadClass");
        this.loaderType = (IntegerAttribute)moData.getAttribute("loaderType");
        this.preLoad = (IntegerAttribute)moData.getAttribute("preLoad");
        this.oseProgramPoolSize = (IntegerAttribute)moData.getAttribute("oseProgramPoolSize");
        this.oseProgramHeapSize = (IntegerAttribute)moData.getAttribute("oseProgramHeapSize");
        this.restartCounterLimit = (IntegerAttribute)moData.getAttribute("restartCounterLimit");
        this.restartTimer = (IntegerAttribute)moData.getAttribute("restartTimer");
        this.programMustBeSingleton = (BooleanAttribute)moData.getAttribute("programMustBeSingleton");
        this.isDirectory = (BooleanAttribute)moData.getAttribute("isDirectory");
        this.reservedByUpgradePackage = (BooleanAttribute)moData.getAttribute("reservedByUpgradePackage");
        this.moppletEntries = (SequenceAttribute)moData.getAttribute("moppletEntries");
        this.isCpiType = (BooleanAttribute)moData.getAttribute("isCpiType");
        this.funcId = (StringAttribute)moData.getAttribute("funcId");
        this.deviceLoaderName = (StringAttribute)moData.getAttribute("deviceLoaderName");
        this.deviceLoaderInformation = (StringAttribute)moData.getAttribute("deviceLoaderInformation");
        if (this.isCpiType.getValue(null)) {
            ProductRepository.instance().registerCpi((CustomerProductInfoData)this);
        } else {
            ProductRepository.instance().registerSw((SoftwareProductData)this);
        }
        this.operationType = -1;
        this.myCoordinator = null;
        this.fileState = (IntegerAttribute)moData.getAttribute("fileState");
        this.dynamicClassName = (StringAttribute)moData.getAttribute("dynamicClass");
        this.isSignedSw = (BooleanAttribute)moData.getAttribute("isSignedSw");
        this.signatureFileNameExtension = (StringAttribute)moData.getAttribute("signatureFileNameExtension");
        this.createFileStateAttribute(this.loadModuleFilePath.getValue(null), this.isDirectory.getValue(null), this.isSignedSw.getValue(null), this.signatureFileNameExtension.getValue(null), null);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedByUpgradePackage.getValue(coordinator)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.operationType = 2;
        this.registerResource(coordinator);
        this.lmFilePath = this.loadModuleFilePath.getValue(coordinator);
        this.isDir = this.isDirectory.getValue(coordinator);
        this.isSSW = this.isSignedSw.getValue(coordinator);
        this.signatureFileNameExt = this.signatureFileNameExtension.getValue(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
        if (this.isCpiType.getValue(null)) {
            ProductRepository.instance().deregisterCpi((CustomerProductInfoData)this, coordinator);
        } else {
            ProductRepository.instance().deregisterSw((SoftwareProductData)this, coordinator);
        }
    }

    public void deleteMO(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"deleteMO(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        super.delete(coordinator);
        this.data.delete(coordinator);
        if (this.isCpiType.getValue(null)) {
            ProductRepository.instance().deregisterCpi((CustomerProductInfoData)this);
        } else {
            ProductRepository.instance().deregisterSw((SoftwareProductData)this);
        }
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"LoadModule", (int)128, (int)0);
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public Struct getProductData(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductData(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[5];
        Object[] objectArray = new Object[5];
        stringArray[0] = "productNumber";
        objectArray[0] = this.productNumber.getValue(coordinator);
        stringArray[1] = "productRevision";
        objectArray[1] = this.productRevision.getValue(coordinator);
        stringArray[2] = "productName";
        objectArray[2] = this.productName.getValue(coordinator);
        stringArray[3] = "productInfo";
        objectArray[3] = this.productInfo.getValue(coordinator);
        stringArray[4] = "productionDate";
        String string = this.productionDate.getValue(coordinator);
        if (LoadModuleMoImpl.checkDateFormat(string)) {
            string = "00000000";
        }
        objectArray[4] = string;
        return new StructImpl(stringArray, objectArray);
    }

    public String getLoadModuleFilePath(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleFilePath(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getFileState(coordinator) == 0) {
            return "";
        }
        return this.loadModuleFilePath.getValue(coordinator);
    }

    public String getLoadModuleFilePathSU(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleFilePathSU(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.getFileState(coordinator) == 1) {
            return this.loadModuleFilePath.getValue(coordinator);
        }
        File file = new File(this.getRealLoadModuleFilePath(coordinator));
        if (file.exists()) {
            return this.loadModuleFilePath.getValue(coordinator);
        }
        return "";
    }

    public void setLoadModuleFilePathForUpgrade(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setLoadModuleFilePathForUpgrade(String aLoadModuleFilePath, Coordinator aCoordinator)", (String)("aLoadModuleFilePath: " + string + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.loadModuleFilePath.setValue(string);
    }

    public int getLoaderType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoaderType(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.loaderType.getValue(coordinator);
    }

    public boolean isFileStateCorrect(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"isFileStateCorrect(int aFileState, Coordinator aCoordinator)", (String)("aFileState: " + n + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return this.getActualFileState(coordinator) == n;
    }

    public boolean isUpgradeEnabler() {
        return false;
    }

    public void setLMFP(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setLMFP (String aLMFP, Coordinator c)", (String)("aLMFP: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.loadModuleFilePath.setValue(string);
    }

    public void setLoaderTypeForUpgrade(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setLoaderType(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.loaderType.setValue(n);
    }

    public String getOtherLoaderName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOtherLoaderName(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.otherLoaderName.getValue(coordinator);
    }

    public void setOtherLoaderNameForUpgrade(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setOtherLoaderName(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.otherLoaderName.setValue(string);
    }

    public int getPreLoad(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPreLoad(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.preLoad.getValue(coordinator);
    }

    public void setPreLoad(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPreLoad(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 0 && n != 2 && n != 1) {
            throw new ValueOutOfRangeException("preLoad", "LoadModule");
        }
        this.preLoad.setValue(n);
    }

    public String getFileFormat(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFileFormat(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.fileFormat.getValue(coordinator);
    }

    public void setFileFormat(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setFileFormat(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.fileFormat.setValue(string);
    }

    public int getOseProgramLoadClass(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOseProgramLoadClass(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.loadClass.getValue(coordinator);
    }

    public int getRestartCounterLimit(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRestartCounterLimit(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.restartCounterLimit.getValue(coordinator);
    }

    public int getRestartTimer(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRestartTimer(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.restartTimer.getValue(coordinator);
    }

    public void setOseProgramLoadClassForUpgrade(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setOseProgramLoadClass(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.loadClass.setValue(n);
    }

    public void setRestartCounterLimitSU(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setRestartCounterLimitSU(int aRestartCounterLimit, Coordinator c)", (String)("aRestartCounterLimit: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.restartCounterLimit.setValue(n);
    }

    public void setRestartTimerSU(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setRestartTimerSU(int aRestartTimer, Coordinator c)", (String)("aRestartTimer: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.restartTimer.setValue(n);
    }

    public String getReliableProgramLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReliableProgramLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reliableProgramLabel.getValue(coordinator);
    }

    public boolean getIsDirectory(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getIsDirectory(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.isDirectory.getValue(coordinator);
    }

    public void setIsDirectoryForUpgrade(boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setIsDirectoryForUpgrade(boolean anIsDirectory, Coordinator aCoordinator)", (String)("anIsDirectory: " + bl + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.isDirectory.setValue(bl);
    }

    public int getOseProgramPoolSize(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOseProgramPoolSize(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.oseProgramPoolSize.getValue(coordinator);
    }

    public void setOseProgramPoolSize(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setOseProgramPoolSize(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.oseProgramPoolSize.setValue(n);
    }

    public int getOseProgramHeapSize(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOseProgramHeapSize(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.oseProgramHeapSize.getValue(coordinator);
    }

    public void setOseProgramHeapSize(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setOseProgramHeapSize(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.oseProgramHeapSize.setValue(n);
    }

    public boolean getProgramMustBeSingleton(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProgramMustBeSingleton(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.programMustBeSingleton.getValue(coordinator);
    }

    public String getRealLoadModuleFilePath(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRealLoadModuleFilePath(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.loadModuleFilePath.getValue(coordinator);
    }

    public boolean getReservedByUpgradePackage(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedByUpgradePackage(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByUpgradePackage.getValue(coordinator);
    }

    public String getLoadModuleId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return this.getNamingAttributeValue();
    }

    public String[] getMoppletEntries(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getMoppletEntries(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.moppletEntries.getValue(coordinator);
        String[] stringArray = new String[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            stringArray[i] = ((StringAttribute)attributeArray[i]).getValue(coordinator);
        }
        return stringArray;
    }

    public String getFuncId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getfuncId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.funcId.getValue(coordinator);
    }

    public void setFuncId(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setFuncId(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkStringWithLength((String)string, (String)"funcId", (String)"LoadModule", (int)40, (int)0);
        this.funcId.setValue(string);
    }

    public int getFileState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductionDate(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.fileState.getValue(coordinator);
    }

    public void setFileStateForSu(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setFileState(int aFileState, Coordinator c)", (String)("aFileState: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"fileState", (int)n, (int)0, (int)1, (String)"LoadModule");
        if (n == 1 && this.getActualFileState(coordinator) != n) {
            throw new IllegalAttributeValueException("Not allowed to set attribute FileState to value Installed due to the load module file do not exist in path below.loadModuleFilePath: " + this.getRealLoadModuleFilePath(coordinator), "LoadModule");
        }
        this.setActualFileState(n, coordinator);
    }

    private void sendFileStateChangeEvent(int n) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendFileStateChangeEvent(int aFileState)", (String)("aFileState: " + n));
        PropertyChangeHandler.instance().firePropertyChange("LoadModuleFileStateChange", null, (Object)new LoadModuleFileStateChangeInformation(this, this.getLocalDistinguishedName(), n));
    }

    public String getType() {
        return "LoadModule";
    }

    public String getDeviceLoaderName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getdeviceLoaderName(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.deviceLoaderName.getValue(coordinator);
    }

    public void setDeviceLoaderNameForUpgrade(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setDeviceLoaderNameForUpgrade(String aDeviceLoaderName, Coordinator c)", (String)("aDeviceLoaderName: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.deviceLoaderName.setValue(string);
    }

    public String getDeviceLoaderInformation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getDeviceLoaderInformation(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.deviceLoaderInformation.getValue(coordinator);
    }

    public String getDynamicClassName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getDynamicClassName(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.dynamicClassName.getValue(coordinator);
    }

    public boolean getIsSignedSw(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getIsSignedSw(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.isSignedSw.getValue(coordinator);
    }

    public String getSignatureFileNameExtension(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSignatureFileNameExtension(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.signatureFileNameExtension.getValue(coordinator);
    }

    public void setDynamicClassName(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setDynamicClassName(String aDynamicClassName, Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        this.dynamicClassName.setValue(string);
    }

    public void setDeviceLoaderInformationForUpgrade(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setDeviceLoaderInformationForUpgrade(String aDeviceLoaderInformation, Coordinator c)", (String)("aDeviceLoaderInformation: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.deviceLoaderInformation.setValue(string);
    }

    public void setIsSignedSwForUpgrade(boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setIsSignedSwForUpgrade(boolean anIsSignedSw, Coordinator c)", (String)("anIsSignedSw: " + bl + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.isSignedSw.setValue(bl);
    }

    public void setSignatureFileNameExtensionForUpgrade(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setSignatureFileNameExtensionForUpgrade(String aSignatureFileNameExtension, Coordinator c)", (String)("aSignatureFileNameExtension: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.signatureFileNameExtension.setValue(string);
    }

    public String getProductionDate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductionDate(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string = this.productionDate.getValue(coordinator);
        if (LoadModuleMoImpl.checkDateFormat(string)) {
            string = "00000000";
        } else if (string.length() == 5) {
            return ConvertWeekOfYearToDate.WeekOfYearToDate((String)string);
        }
        return string;
    }

    public String getFilePath(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFilePath(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getLoadModuleFilePath(coordinator);
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductName(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.productName.getValue(coordinator);
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductNumber(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.productNumber.getValue(coordinator);
    }

    public String getProductNumberOpt(Coordinator coordinator) throws MoAccessException {
        return this.myProductNumberOpt;
    }

    public String getProductRevision(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductRevision(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.productRevision.getValue(coordinator);
    }

    public String getProductRevisionOpt(Coordinator coordinator) throws MoAccessException {
        return this.myProductRevisionOpt;
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.productRevision.getValue(coordinator);
    }

    public void refreshFileState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"refreshFileState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = this.getActualFileState(coordinator);
        if (this.getFileState(coordinator) != n) {
            this.setActualFileState(n, coordinator);
        }
    }

    public void reserve(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.reservedByUpgradePackage.setValue(true);
    }

    private static Struct checkAndGetProductData(AttrList attrList) throws MoAccessException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetProductData(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        Struct struct = null;
        int n = attrList.indexOf("productData");
        if (n == -1) {
            throw new AttrMissingAtCreateException("LoadModule", "productData");
        }
        if (!(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException("productData", "LoadModule");
        }
        struct = (Struct)attrList.getValue(n);
        if (struct.size() > 5) {
            throw new NoSuchFieldException("Unknown field in struct");
        }
        try {
            string5 = (String)struct.getValue("productRevision");
            string4 = (String)struct.getValue("productNumber");
            string3 = (String)struct.getValue("productName");
            string2 = (String)struct.getValue("productionDate");
            if (string5 == null || string4 == null || string3 == null || string2 == null) {
                throw new AttrMissingAtCreateException("productData", "LoadModule");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AttrMissingAtCreateException("productData", "LoadModule");
        }
        try {
            string = (String)struct.getValue("productInfo");
            if (string == null) {
                string = "";
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string = "";
        }
        LoadModuleMoImpl.validateAdministrativeProductData(struct);
        Object[] objectArray = new String[]{string4, string5, string3, string, string2};
        struct = new StructImpl(adminProductDataNames, objectArray);
        attrList.removeElementAt(n);
        return struct;
    }

    private static String checkAndGetLoadModuleFilePath(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetLoadModuleFilePath(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        String string = null;
        int n = attrList.indexOf("loadModuleFilePath");
        if (n == -1) {
            throw new AttrMissingAtCreateException("LoadModule", "loadModuleFilePath");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("loadModuleFilePath", "LoadModule");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static int checkAndGetLoaderType(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetLoaderType(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf("loaderType");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("loaderType", "LoadModule");
        }
        n = (Integer)attrList.getValue(n2);
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 99 && n != 6) {
            throw new ValueOutOfRangeException("loaderType", "LoadModule");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static String checkAndGetOtherLoaderName(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetOtherLoaderName(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        String string = "";
        int n = attrList.indexOf("otherLoaderName");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("otherLoaderName", "LoadModule");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static int checkAndGetPreLoad(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetPreLoad(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf("preLoad");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("preLoad", "LoadModule");
        }
        n = (Integer)attrList.getValue(n2);
        if (n != 0 && n != 2 && n != 1) {
            throw new ValueOutOfRangeException("preLoad", "LoadModule");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static String checkAndGetFileFormat(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetFileFormat(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        String string = "";
        int n = attrList.indexOf("fileFormat");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("fileFormat", "LoadModule");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static int checkAndGetOseProgramLoadClass(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetOseProgramLoadClass(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 500;
        int n2 = attrList.indexOf("oseProgramLoadClass");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("oseProgramLoadClass", "LoadModule");
        }
        n = (Integer)attrList.getValue(n2);
        if (n != 5) {
            MoAttributeValidator.checkEnumAttribute((String)"oseProgramLoadClass", (int)n, (int[])LOAD_CLASS_RANGE, (String)"LoadModule");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static String checkAndGetReliableProgramLabel(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetReliableProgramLabel(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        String string = "";
        int n = attrList.indexOf("reliableProgramLabel");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("reliableProgramLabel", "LoadModule");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static boolean checkAndGetIsDirectory(AttrList attrList, String string) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetIsDirectory(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        boolean bl = false;
        int n = attrList.indexOf("isDirectory");
        if (n == -1) {
            return bl;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("isDirectory", "LoadModule");
        }
        bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static int checkAndGetOseProgramPoolSize(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetOseProgramPoolSize(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf("oseProgramPoolSize");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("oseProgramPoolSize", "LoadModule");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0) {
            throw new ValueOutOfRangeException("oseProgramPoolSize", "LoadModule");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetRestartCounterLimit(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetRestartCounterLimit(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 3;
        int n2 = attrList.indexOf("restartCounterLimit");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("restartCounterLimit", "LoadModule");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < -1) {
            throw new ValueOutOfRangeException("restartCounterLimit", "LoadModule");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetRestartTimer(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetRestartTimer(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 60;
        int n2 = attrList.indexOf("restartTimer");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("restartTimer", "LoadModule");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < -1) {
            throw new ValueOutOfRangeException("restartTimer", "LoadModule");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetOseProgramHeapSize(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetOseProgramHeapSize(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf("oseProgramHeapSize");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("oseProgramHeapSize", "LoadModule");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0) {
            throw new ValueOutOfRangeException("oseProgramHeapSize", "LoadModule");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static boolean checkAndGetProgramMustBeSingleton(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetProgramMustBeSingleton(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        boolean bl = false;
        int n = attrList.indexOf("programMustBeSingleton");
        if (n == -1) {
            return bl;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("programMustBeSingleton", "LoadModule");
        }
        bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static String[] checkAndGetMoppletEntries(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetMoppletEntries(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = attrList.indexOf("moppletEntries");
        if (n == -1) {
            return new String[0];
        }
        if (!(attrList.getValue(n) instanceof String[])) {
            throw new WrongAttributeTypeException("moppletEntries", "LoadModule");
        }
        String[] stringArray = (String[])attrList.getValue(n);
        attrList.removeElementAt(n);
        return stringArray;
    }

    private static String checkAndGetDynamicClassName(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetDynamicClassName(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        String string = "";
        int n = attrList.indexOf("dynamicClass");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("dynamicClass", "LoadModule");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static boolean checkAndGetCpiType(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetCpiType(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = attrList.indexOf("isCpiType");
        if (n == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("isCpiType", "LoadModule");
        }
        String string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string.equalsIgnoreCase("cpi");
    }

    private static boolean checkAndGetIsSignedSw(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetIsSignedSw(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        boolean bl = false;
        int n = attrList.indexOf("isSignedSw");
        if (n == -1) {
            return bl;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("isSignedSw", "LoadModule");
        }
        bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static String checkAndGetSignatureFileNameExtension(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"checkAndGetSignatureFileNameExtension(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        String string = "";
        int n = attrList.indexOf("signatureFileNameExtension");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("signatureFileNameExtension", "LoadModule");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    static boolean checkDateFormat(String string) throws ValueOutOfRangeException {
        boolean bl = false;
        if (string == null) {
            bl = true;
        } else if (string.length() != 5 && string.length() != 8) {
            bl = true;
        } else if (string.length() == 8) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) continue;
                bl = true;
            }
        } else {
            char c = string.charAt(2);
            if (c != 'w' && c != 'W') {
                bl = true;
            } else {
                for (int i = 0; i < string.length(); ++i) {
                    char c2 = string.charAt(i);
                    if (Character.isDigit(c2) || i == 2) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private synchronized void registerResource(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"registerResource(Coordinator key)", (String)("key: " + Lib.toString((Coordinator)coordinator)));
        if (this.myCoordinator != null) {
            throw new TransactionRequiredException();
        }
        this.myCoordinator = coordinator;
        try {
            this.myCoordinator.registerResource((Resource)this);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            UpgradeTrace.error(this.getClass(), (String)"registerResource(Coordinator key)", (String)("InactiveTransactionException caught when trying to register a resource in a transaction.\n\tkey: " + Lib.toString((Coordinator)coordinator)), (Throwable)inactiveTransactionException);
            throw new TransactionRequiredException();
        }
    }

    public boolean prepare() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"prepare( )");
        return true;
    }

    public void commit() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"commit( )");
        if (this.operationType == 1) {
            if (this.fileState.getValue(null) == 1) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"createFileStateAttribute(String aLoadModuleFilePath, Coordinator context)", (String)"New LoadModule MO has been created with an installed lmfile, notifying SW ProductInventory.");
                PropertyChangeHandler.instance().firePropertyChange("LoadModuleFileStateChange", null, (Object)new LoadModuleFileStateChangeInformation(this, this.getLocalDistinguishedName(), 1));
            } else {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"createFileStateAttribute(String aLoadModuleFilePath, Coordinator context)", (String)"New LoadModule MO has been created with an uninstalled lmfile, no notification to SW ProductInventory.");
            }
        } else if (this.operationType == 2) {
            Object object;
            int n = this.getActualFileState(this.lmFilePath, this.isDir, this.isSSW, this.signatureFileNameExt);
            boolean bl = false;
            try {
                bl = this.getIsSignedSw(null);
            }
            catch (MoAccessException moAccessException) {
                UpgradeTrace.error(this.getClass(), (String)"commit()", (String)"MoAccessException caught when checking if delete of signature file is needed (ignored).");
            }
            File file = new File(this.lmFilePath);
            file.delete();
            String string = null;
            if (bl) {
                string = this.lmFilePath + ".sm";
                if (this.signatureFileNameExt.length() > 0) {
                    string = this.lmFilePath + "." + this.signatureFileNameExt;
                }
                object = new File(string);
                ((File)object).delete();
            }
            if (System.getProperty("SIM") == null || System.getProperty("SU_SIM") != null) {
                object = (ReplicatedLoadModuleFileRemoverAccess)ServiceLocatorFacade.getRepository().getService(ReplicatedLoadModuleFileRemoverAccess.class);
                object.deleteReplicatedLoadModuleFile(this.lmFilePath);
                if (bl) {
                    object.deleteReplicatedLoadModuleFile(string);
                }
            }
            if (n == 1) {
                this.sendFileStateChangeEvent(this.newFileState);
            }
        } else if (this.operationType == 3) {
            this.sendFileStateChangeEvent(this.newFileState);
            this.newFileState = -1;
        }
        this.operationType = -1;
        this.myCoordinator = null;
    }

    public void rollback() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"rollback( )");
        this.newFileState = -1;
        this.operationType = -1;
        this.myCoordinator = null;
    }

    private static void validateAdministrativeProductData(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        String string = "";
        UpgradeTrace.debug((Class)LoadModuleMoImpl.class, (int)70, (String)"validateAdministrativeProductData(Struct adminProductData))", (String)("names: " + Lib.toString((String[])stringArray)));
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("productInfo")) {
                    if (!struct.getValue("productInfo").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productInfo", "LoadModule");
                    }
                    string = (String)struct.getValue("productInfo");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productInfo", (String)"LoadModule", (int)1024, (int)0);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productionDate")) {
                    if (!struct.getValue("productionDate").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productionDate", "LoadModule");
                    }
                    string = (String)struct.getValue("productionDate");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productionDate", (String)"LoadModule", (int)8, (int)0);
                    if (!LoadModuleMoImpl.checkDateFormat(string)) continue;
                    throw new ValueOutOfRangeException("productionDate", "LoadModule");
                }
                if (stringArray[i].equalsIgnoreCase("productName")) {
                    if (!struct.getValue("productName").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productName", "LoadModule");
                    }
                    string = (String)struct.getValue("productName");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productName", (String)"LoadModule", (int)12, (int)1);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productNumber")) {
                    if (!struct.getValue("productNumber").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productNumber", "LoadModule");
                    }
                    string = (String)struct.getValue("productNumber");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productNumber", (String)"LoadModule", (int)24, (int)1);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productRevision")) {
                    if (!struct.getValue("productRevision").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productRevision", "LoadModule");
                    }
                    string = (String)struct.getValue("productRevision");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productRevision", (String)"LoadModule", (int)7, (int)1);
                    continue;
                }
                throw new NoSuchFieldException("LoadModuleType Mo, Unknown field in administrativeProductData " + stringArray[i]);
            }
        }
    }

    private void createFileStateAttribute(String string, boolean bl, boolean bl2, String string2, Coordinator coordinator) {
        this.transactionReTryCounter = 0;
        this.keepTrying = true;
        int n = this.getActualFileState(string, bl, bl2, string2);
        if (coordinator == null) {
            while (this.keepTrying) {
                ++this.transactionReTryCounter;
                try {
                    TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                    Control control = transactionFactory.create(2000);
                    coordinator = control.getCoordinator();
                    MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 2000 sec"));
                    this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                    this.fileState.setValue(n);
                    control.getTerminator().commit();
                    this.keepTrying = false;
                }
                catch (Exception exception) {
                    if (!this.maxTriesReached(this.transactionReTryCounter, exception)) {
                        this.waitForTransaction();
                        continue;
                    }
                    this.keepTrying = false;
                    UpgradeTrace.error(this.getClass(), (String)"createFileStateAttribute(String aLoadModuleFilePath, Coordinator context)", (String)"Could not set the value of fileState.", (Throwable)exception);
                }
            }
        } else {
            this.fileState.setValue(n);
        }
    }

    private int getActualFileState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getActualFileState(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return this.getActualFileState(this.getRealLoadModuleFilePath(coordinator), this.getIsDirectory(coordinator), this.getIsSignedSw(coordinator), this.getSignatureFileNameExtension(coordinator));
    }

    private int getActualFileState(String string, boolean bl, boolean bl2, String string2) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getActualFileState(String aLoadModuleFilePath, boolean anIsDirectory, boolean anIsSignedSw, String aSignatureFileNameExtension)", (String)("aLoadModuleFilePath: " + string + "\n\tanIsDirectory: " + bl + "\n\tanIsSignedSw: " + bl2 + "\n\taSignatureFileNameExtension: " + string2));
        int n = 0;
        File file = new File(string);
        if (file.exists()) {
            if (bl) {
                n = 1;
            } else if (!bl2) {
                n = 1;
            } else {
                File file2 = null;
                file2 = string2.length() > 0 ? new File(string + "." + string2) : new File(string + ".sm");
                if (file2.exists()) {
                    n = 1;
                } else {
                    int n2 = string.lastIndexOf(47);
                    String string3 = string.substring(0, n2 + 1) + "install/" + string.substring(n2 + 1);
                    file2 = string2.length() > 0 ? new File(string3 + "." + string2) : new File(string3 + ".sm");
                    if (file2.exists()) {
                        n = 1;
                    }
                }
            }
        }
        return n;
    }

    private boolean maxTriesReached(int n, Exception exception) {
        return n >= 10;
    }

    private void waitForTransaction() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            MessageLog.traceError(this.getClass(), (String)"Thread interupted", (Throwable)interruptedException);
        }
    }

    private void setActualFileState(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setActualFileState(int aFileState, Coordinator c)", (String)("aFileState: " + n + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        if (n != this.getFileState(coordinator)) {
            this.fileState.setValue(n);
            this.operationType = 3;
            this.registerResource(coordinator);
        }
    }
}

