/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMoImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class ReliableThread
implements Resource,
Runnable {
    private Coordinator key;
    private ReliableProgramUniterMoImpl rpuRef;
    private String name;
    private static final String CMA_SINGLE_RPU_SWITCH_THREAD_BASE = "Cma_ActionSwitch_Thread";
    private static final String CMA_RPU_NORMALISE_THREAD = "Cma_NormaliseAllRPUs_Thread";
    private static final int SLEEP_INTERVAL = 200;

    public synchronized void registerResource(Coordinator coordinator) {
        if (this.rpuRef.getRpuCurrentContext() == null || !this.rpuRef.getRpuCurrentContext().isSameTransaction(coordinator)) {
            this.rpuRef.setRpuCurrentContext(coordinator);
            try {
                coordinator.registerResource((Resource)this);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"registerResource failed due to an exception:", (Throwable)inactiveTransactionException);
                throw new RuntimeException("Failed in ReliableThread while registering resource", inactiveTransactionException);
            }
        }
    }

    public ReliableThread(Coordinator coordinator, String string, ManagedObject managedObject) {
        this.name = string;
        this.key = coordinator;
        this.rpuRef = (ReliableProgramUniterMoImpl)managedObject;
    }

    public void commit() {
        Thread thread = new Thread((Runnable)this, this.name);
        thread.start();
        if (this.rpuRef != null) {
            this.rpuRef.setRpuCurrentContext(null);
        }
    }

    public boolean prepare() {
        return true;
    }

    public void rollback() {
        if (this.rpuRef != null) {
            this.rpuRef.setRpuCurrentContext(null);
        }
    }

    public void run() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            MessageLog.traceError(this.getClass(), (String)"Thread interrupted", (Throwable)interruptedException);
        }
        try {
            if (this.name.indexOf(CMA_SINGLE_RPU_SWITCH_THREAD_BASE) != -1) {
                this.rpuRef.doActionSwitch();
            } else if (this.name.equals(CMA_RPU_NORMALISE_THREAD)) {
                ReliableProgramUniterMoImpl.doNormaliseAll(null);
            }
        }
        catch (MoAccessException moAccessException) {
            String string = this.name.equals(CMA_RPU_NORMALISE_THREAD) ? "normalizeRPU()" : "switch()";
            MessageLog.info((Class)ReliableThread.class, (String)("MO Action " + string + " not completed due to exception\n" + (Object)((Object)moAccessException)));
        }
    }
}

