/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import java.text.SimpleDateFormat;
import java.util.Date;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMoImpl;
import se.ericsson.cello.swmanagement.SwManagementMo;
import se.ericsson.cello.swmanagement.suaccess.SwManagementMOM_SU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwManagementMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class SwManagementMoImpl
extends ManagedObjectBase
implements SwManagementMo,
SwManagementMoSU_Access,
SwManagementMOM_SU_Access {
    private static int LOCAL_TIMEOUT = 10000;
    private static int MAX_NO_OF_RETRIES = 5;
    private static int RETRY_INTERVAL = 2000;
    private MoData data;
    private StringAttribute userLabel;
    private StringAttribute straLastUpPiChangeTimestamp = null;
    private static SwManagementMoImpl instance = null;
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "MOM_1", "MOM_2", "MOM_3", "MOM_4", "MOM_5", "MOM_6", "MOM_7", "MOM_8", "MOM_9", "MOM_10", "MOM_11", "MOM_12", "MOM_13", "MOM_14"};
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;

    void recover(MoData moData) {
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("lastUpPiChange");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.straLastUpPiChangeTimestamp = (StringAttribute)moData.getAttribute("lastUpPiChange");
    }

    synchronized void registerData() {
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.data = new MoData(this.getLocalDistinguishedName(), "SwManagement", true, coordinator);
                this.userLabel = new StringAttribute("userLabel", true, "");
                this.straLastUpPiChangeTimestamp = new StringAttribute("lastUpPiChange", true, this.getCurrentTimeStamp());
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.data.registerPersistentAttr((Attribute)this.straLastUpPiChangeTimestamp);
                this.data.setRevision(8000);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of SwManagement failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of SwManagement failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of SwManagement failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of SwManagement failed", (Throwable)moAccessException);
            }
        }
    }

    private static Control createTransactionWithTraniWait(int n) {
        Control control = null;
        int n2 = 0;
        while (true) {
            try {
                control = TransactionServiceImpl.instance().getTransactionFactory().create(n);
            }
            catch (Exception exception) {
                block7: {
                    block6: {
                        try {
                            if (n2 >= MAX_NO_OF_RETRIES) break block6;
                            if (n2 % 2 == 0) {
                                MessageLog.info((Class)(class$se$ericsson$cello$swmanagement$SwManagementMoImpl == null ? SwManagementMoImpl.class$("se.ericsson.cello.swmanagement.SwManagementMoImpl") : class$se$ericsson$cello$swmanagement$SwManagementMoImpl), (String)"Could not create transaction due to TransactionServer unavailable; retrying in 2 secs");
                            }
                            Thread.sleep(RETRY_INTERVAL);
                            break block7;
                        }
                        catch (InterruptedException interruptedException) {
                            MessageLog.traceError((Class)SwManagementMoImpl.class, (String)"Thread Interrupted while retrying", (Throwable)interruptedException);
                        }
                    }
                    MessageLog.traceError((Class)SwManagementMoImpl.class, (String)"Unable to create Transaction due to Exception", (Throwable)exception);
                    break;
                }
                ++n2;
                continue;
            }
            break;
        }
        return control;
    }

    private String getCurrentTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd-HHmmss");
        return simpleDateFormat.format(new Date());
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"SwManagement", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getLastUpPiChange(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.straLastUpPiChangeTimestamp != null) {
            return this.straLastUpPiChangeTimestamp.getValue(coordinator);
        }
        return "NOT DEFINED";
    }

    public void actionLastUpPiChange(Coordinator coordinator) throws MoAccessException {
        Coordinator coordinator2 = null;
        Control control = null;
        try {
            if (coordinator == null) {
                control = SwManagementMoImpl.createTransactionWithTraniWait(LOCAL_TIMEOUT);
                coordinator2 = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA_Transaction created with txId = " + coordinator2.getTransactionID() + ", timeout = " + LOCAL_TIMEOUT + " sec"));
            } else {
                coordinator2 = coordinator;
            }
            this.data.handleTransaction(coordinator2, MoData.WRITE_ACCESS);
            this.straLastUpPiChangeTimestamp.setValue(this.getCurrentTimeStamp());
            if (control != null) {
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA Trying Commit for txId = " + coordinator2.getTransactionID()));
                control.getTerminator().commit();
            }
        }
        catch (Exception exception) {
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            MessageLog.traceError(this.getClass(), (String)"Unable to send Sw Inventory change notification due to exception", (Throwable)exception);
        }
    }

    public void actionNormalizeRPU(Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ReliableProgramUniterMoImpl.normaliseAllRPUs(coordinator);
    }

    public String getType() {
        return "SwManagement";
    }

    public static synchronized SwManagementMoImpl instance() {
        try {
            if (instance == null) {
                instance = new SwManagementMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)SwManagementMoImpl.class, (String)"Create instance of SwManagement mo failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    private SwManagementMoImpl() throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElement")).getMo(), "SwManagement", "1", null);
    }
}

