/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement.handler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.swmanagement.suaccess.BaseRefInfo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeLoadListInfo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeRefInfo;

public class PiuTypeLoadListHandler {
    private Collection myPiuTypeLoadListInfos = null;
    private StringAttribute[] myPiuTypeRefStringAttributesArray = null;
    private StringAttribute[] myLoadModuleRefStringAttributesArray = null;

    public PiuTypeLoadListHandler(Collection collection) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PiuTypeLoadList_Handler(Collection aPiuTypeLoadListInfo)", (String)("aPiuTypeLoadListInfo: " + collection));
        this.myPiuTypeLoadListInfos = collection;
        this.createPiuTypeRefAndLoadModuleRefStringAttributeArrays();
    }

    public PiuTypeLoadListHandler(SequenceAttribute sequenceAttribute, SequenceAttribute sequenceAttribute2) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PiuTypeLoadList_Handler(SequenceAttribute aPiuTypeRefs, SequenceAttribute aLoadModuleRefs)", (String)("aPiuTypeRefs: " + sequenceAttribute + "\n\taLoadModuleRefs: " + sequenceAttribute2));
        this.myPiuTypeRefStringAttributesArray = this.convertToStringAttributeArray(sequenceAttribute.getValue(null));
        this.myLoadModuleRefStringAttributesArray = this.convertToStringAttributeArray(sequenceAttribute2.getValue(null));
        this.createPiuTypeLoadListInfos();
    }

    public Collection getPiuTypeMos() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeMos()");
        HashSet<PiuTypeMoSU_Access> hashSet = new HashSet<PiuTypeMoSU_Access>(1);
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        PiuTypeRefInfo piuTypeRefInfo = null;
        Iterator iterator = this.getPiuTypeRefInfos().iterator();
        while (iterator.hasNext()) {
            piuTypeRefInfo = (PiuTypeRefInfo)iterator.next();
            piuTypeMoSU_Access = (PiuTypeMoSU_Access)MoRepository.instance().lookup(piuTypeRefInfo.getLdn());
            if (piuTypeMoSU_Access != null) {
                hashSet.add(piuTypeMoSU_Access);
                continue;
            }
            UpgradeTrace.error(this.getClass(), (String)"getPiuTypeMos()", (String)("Could not find a PiuType MO that matches the PiuTypeRefInfo. This PiuType will be ignored (not included in the list).\n\tthePiuTypeRefInfo: " + piuTypeRefInfo));
        }
        return hashSet;
    }

    public Collection getPiuTypeRefInfos() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeRefInfos()");
        HashSet hashSet = new HashSet(1);
        PiuTypeLoadListInfo piuTypeLoadListInfo = null;
        Iterator iterator = this.myPiuTypeLoadListInfos.iterator();
        while (iterator.hasNext()) {
            piuTypeLoadListInfo = (PiuTypeLoadListInfo)iterator.next();
            hashSet.addAll(piuTypeLoadListInfo.getPiuTypeRefInfos());
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getPiuTypeRefInfos()", (String)("Returning - thePiuTypeRefInfos: " + hashSet));
        return hashSet;
    }

    public Collection getPiuTypeLoadListInfos() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeLoadListInfos()", (String)("Returning - myPiuTypeLoadListInfos: " + this.myPiuTypeLoadListInfos));
        return this.myPiuTypeLoadListInfos;
    }

    public StringAttribute[] getPiuTypeRefsAsStringAttributeArray() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeRefsAsSequenceAttribute()", (String)("Returning - myPiuTypeRefStringAttributesArray: " + this.myPiuTypeRefStringAttributesArray));
        return this.myPiuTypeRefStringAttributesArray;
    }

    public StringAttribute[] getLoadModuleRefsAsStringAttributeArray() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleRefsAsSequenceAttribute()", (String)("Returning - myLoadModuleRefStringAttributes: " + this.myLoadModuleRefStringAttributesArray));
        return this.myLoadModuleRefStringAttributesArray;
    }

    public Collection getLoadModuleRefInfos(PiuTypeRefInfo piuTypeRefInfo) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo)");
        Collection collection = this.getMatchingLoadModuleRefInfos(piuTypeRefInfo, null);
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo)", (String)("Returning - theAllLoadModuleRefInfos: " + collection));
        return collection;
    }

    public Collection getLoadModuleRefInfos(PiuTypeRefInfo piuTypeRefInfo, Collection collection) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo, Collection aTags)");
        Collection collection2 = this.getMatchingLoadModuleRefInfos(piuTypeRefInfo, collection);
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo, Collection aTags)", (String)("Returning - theAllLoadModuleRefInfos: " + collection2));
        return collection2;
    }

    public Collection getLoadModuleRefInfosConnectedToAnyPiuTypeRef() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleRefInfosConnectedToAnyPiuTypeRef()");
        Collection collection = this.getMatchingLoadModuleRefInfos(null, null);
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfosConnectedToAnyPiuTypeRef()", (String)("Returning - theLoadModuleRefInfos: " + collection));
        return collection;
    }

    public boolean samePiuTypeRefInfos(Collection collection) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"samePiuTypeRefInfos(Collection aNotherPiuTypeRefInfos)", (String)("\n\taNotherPiuTypeRefInfos: " + collection));
        boolean bl = true;
        Collection collection2 = this.getPiuTypeRefInfos();
        if (collection2.size() != collection.size()) {
            bl = false;
        } else {
            PiuTypeRefInfo piuTypeRefInfo = null;
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                piuTypeRefInfo = (PiuTypeRefInfo)iterator.next();
                if (this.containsPiuTypeRefInfo(collection, piuTypeRefInfo)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean containsPiuTypeRefInfo(Collection collection, PiuTypeRefInfo piuTypeRefInfo) {
        boolean bl = false;
        PiuTypeRefInfo piuTypeRefInfo2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            piuTypeRefInfo2 = (PiuTypeRefInfo)iterator.next();
            if (!piuTypeRefInfo2.isEqual(piuTypeRefInfo)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Collection getMatchingLoadModuleRefInfos(PiuTypeRefInfo piuTypeRefInfo, Collection collection) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo, Collection aTags)");
        HashSet hashSet = new HashSet(1);
        PiuTypeLoadListInfo piuTypeLoadListInfo = null;
        Iterator iterator = this.myPiuTypeLoadListInfos.iterator();
        while (iterator.hasNext()) {
            piuTypeLoadListInfo = (PiuTypeLoadListInfo)iterator.next();
            if (!piuTypeLoadListInfo.containsPiuTypeRefInfo(piuTypeRefInfo)) continue;
            hashSet.addAll(piuTypeLoadListInfo.getLoadModuleRefInfos(collection));
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo, Collection aTags)", (String)("Returning - theAllLoadModuleRefInfos: " + hashSet));
        return hashSet;
    }

    public String toString() {
        return this.myPiuTypeLoadListInfos.toString();
    }

    private void createPiuTypeLoadListInfos() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createPiuTypeLoadListInfos()");
        HashSet hashSet = this.convertToCollectionOfStrings(this.myPiuTypeRefStringAttributesArray);
        HashSet hashSet2 = this.convertToCollectionOfStrings(this.myLoadModuleRefStringAttributesArray);
        this.myPiuTypeLoadListInfos = this.createPiuTypeLoadListInfos(hashSet, hashSet2);
    }

    private void createPiuTypeRefAndLoadModuleRefStringAttributeArrays() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createPiuTypeRefAndLoadModuleRefStringAttributeArrays()");
        Collection collection = new HashSet(1);
        Collection collection2 = new HashSet(1);
        int n = 0;
        PiuTypeLoadListInfo piuTypeLoadListInfo = null;
        Iterator iterator = this.myPiuTypeLoadListInfos.iterator();
        while (iterator.hasNext()) {
            piuTypeLoadListInfo = (PiuTypeLoadListInfo)iterator.next();
            collection = this.getBaseRefInfosAsStringAttribute(collection, piuTypeLoadListInfo.getPiuTypeRefInfos(), n);
            collection2 = this.getBaseRefInfosAsStringAttribute(collection2, piuTypeLoadListInfo.getLoadModuleRefInfos(), n);
            ++n;
        }
        this.myPiuTypeRefStringAttributesArray = this.convertToStringAttributeArray(collection);
        this.myLoadModuleRefStringAttributesArray = this.convertToStringAttributeArray(collection2);
    }

    private Collection getBaseRefInfosAsStringAttribute(Collection collection, Collection collection2, int n) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getBaseRefInfosAsStringAttribute(Collection aBaseRefInfoStringAttributes, Collection aBaseRefInfos, int aCounter)", (String)("aBaseRefInfoStringAttributes: " + collection + "\n\taBaseRefInfos: " + collection2 + "\n\taCounter: " + n));
        if (!collection2.isEmpty()) {
            String string = "" + n;
            BaseRefInfo baseRefInfo = null;
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                string = string + "#";
                baseRefInfo = (BaseRefInfo)iterator.next();
                string = string + baseRefInfo.getPersistentString();
            }
            collection.add(string);
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getBaseRefInfosAsStringAttribute(Collection aBaseRefInfoStringAttributes, Collection aBaseRefInfos, int aCounter)", (String)("Returning - BaseRefInfoStringAttributes: " + collection));
        return collection;
    }

    private Collection createPiuTypeLoadListInfos(HashSet hashSet, HashSet hashSet2) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createPiuTypeLoadListInfos(HashSet aPiuTypeRefInfoStrings, HashSet aLoadModuleRefInfoStrings)", (String)("aPiuTypeRefInfoStrings: " + hashSet + "\n\taLoadModuleRefInfoStrings: " + hashSet2));
        HashSet<PiuTypeLoadListInfo> hashSet3 = new HashSet<PiuTypeLoadListInfo>(1);
        HashSet hashSet4 = (HashSet)hashSet.clone();
        HashSet hashSet5 = (HashSet)hashSet2.clone();
        String string = null;
        Integer n = null;
        String string2 = null;
        Iterator iterator = hashSet4.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            n = this.getPiuTypeLoadListNumber(string);
            string2 = this.getMatchingLoadModuleRefInfoString(n, hashSet5);
            if (string2 == null) continue;
            hashSet.remove(string);
            hashSet2.remove(string2);
            hashSet3.add(new PiuTypeLoadListInfo(string, string2));
        }
        String string3 = null;
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            string3 = (String)iterator2.next();
            hashSet3.add(new PiuTypeLoadListInfo(string3, null));
        }
        Iterator iterator3 = hashSet2.iterator();
        while (iterator3.hasNext()) {
            string3 = (String)iterator3.next();
            hashSet3.add(new PiuTypeLoadListInfo(null, string3));
        }
        return hashSet3;
    }

    private String getMatchingLoadModuleRefInfoString(Integer n, Collection collection) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getMatchingLoadModuleRefInfoString(Integer aPiuTypeLoadListNumber, Collection aLoadModuleRefInfoStrings)", (String)("aPiuTypeLoadListNumber: " + n + "\n\taLoadModuleRefInfoStrings: " + collection));
        String string = null;
        Integer n2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && !n.equals(n2 = this.getPiuTypeLoadListNumber(string = (String)iterator.next()))) {
            string = null;
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getMatchingLoadModuleRefInfoString(Integer aPiuTypeLoadListNumber, Collection aLoadModuleRefInfoStrings)", (String)("Returning - theMatchingLoadModuleRefInfoString: " + string));
        return string;
    }

    private StringAttribute[] convertToStringAttributeArray(Collection collection) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"convertToStringAttributeArray(Collection aCollectionOfStrings)", (String)("aCollectionOfStrings: " + collection));
        Object[] objectArray = collection.toArray();
        StringAttribute[] stringAttributeArray = new StringAttribute[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringAttributeArray[i] = new StringAttribute("", false, (String)objectArray[i]);
        }
        return stringAttributeArray;
    }

    private HashSet convertToCollectionOfStrings(StringAttribute[] stringAttributeArray) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"convertToCollectionOfStrings(StringAttribute[] aStringAttributeArray)", (String)("aStringAttributeArray: " + stringAttributeArray + "\n\tLength of StringAttributeArray: " + stringAttributeArray.length));
        HashSet<String> hashSet = new HashSet<String>(1);
        String string = null;
        for (int i = 0; i < stringAttributeArray.length; ++i) {
            string = stringAttributeArray[i].getValue(null);
            hashSet.add(string);
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"convertToCollectionOfStrings(StringAttribute[] aStringAttributeArray)", (String)("Returning - theCollectionOfStrings: " + hashSet));
        return hashSet;
    }

    private StringAttribute[] convertToStringAttributeArray(Attribute[] attributeArray) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"convertToStringAttributeArray(Attribute[] anAttributeArray)", (String)("anAttributeArray: " + attributeArray));
        StringAttribute[] stringAttributeArray = new StringAttribute[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            stringAttributeArray[i] = (StringAttribute)attributeArray[i];
        }
        return stringAttributeArray;
    }

    private Integer getPiuTypeLoadListNumber(String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeLoadListNumber(String aString)", (String)("aString: " + string));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        return new Integer(stringTokenizer.nextToken());
    }
}

