/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement.plugandplay;

import se.ericsson.cello.equipment.AutoCreateFanMoAccess;
import se.ericsson.cello.equipment.FanMo;
import se.ericsson.cello.equipment.FanMoInternal;
import se.ericsson.cello.equipment.PfmUnitMo;
import se.ericsson.cello.equipment.PlugNPlayListener;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.intma.PlugNPlayHelperAccess;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.suaccess.ManagedElementDataMoSU_Access;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoFactorySU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class AutoCreateFanMo
implements AutoCreateFanMoAccess {
    private static AutoCreateFanMo instance = null;
    private AdditionalInfo[] theAddInfo = null;

    public void create(String string, String string2, String string3, FanMoInternal fanMoInternal) throws Exception {
        this.debugTrace(70, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "OsaXpNotifyInd signal received from Fan: " + fanMoInternal + " with product number: " + string + " product revision: " + string2 + " serial number: " + string3 + " and autoConfigAllowed is set to: " + this.getAutoConfigAllowed());
        ManagedObject[] managedObjectArray = this.getSwAllocations(fanMoInternal);
        if (managedObjectArray.length == 0) {
            this.debugTrace(72, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "OsaXpNotifyInd indication received but no SwAllocation is reserving this Fan");
            AutoCreateFanMo.sendFanDetectedEvent(fanMoInternal, false);
            return;
        }
        PiuTypeAccess piuTypeAccess = this.findPiuType(string, string2);
        if (piuTypeAccess == null) {
            if (this.getAutoConfigAllowed()) {
                this.debugTrace(72, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "Fan detected: " + fanMoInternal + ", but no matching PiuType for productNumber: " + string + " and productRevision: " + string2 + " could be found in the node");
                this.theAddInfo = new AdditionalInfo[3];
                this.theAddInfo[0] = new AdditionalInfo("Alarm Cause", "Matching PiuType missing in configuration.");
                this.theAddInfo[1] = new AdditionalInfo("PiuType product number:", string);
                this.theAddInfo[2] = new AdditionalInfo("PiuType product revision:", string2);
                fanMoInternal.raiseAutoConfigurationAlarm(this.theAddInfo);
            }
            return;
        }
        if (fanMoInternal.getPiuType(null) == null && fanMoInternal instanceof FanMo) {
            if (!this.getAutoConfigAllowed()) {
                this.debugTrace(72, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "PiuType for the configured Fan Mo is null, Fan:" + fanMoInternal);
                return;
            }
            this.debugTrace(72, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "ERROR, PiuType for the configured Fan Mo is null, Fan:" + fanMoInternal);
            throw new ValueOutOfRangeException("The PiuType for configured FAN is null", "Fan");
        }
        if (!this.getAutoConfigAllowed()) {
            boolean bl = false;
            if (fanMoInternal.getPiuType(null) == null) {
                bl = true;
            } else if (!fanMoInternal.getPiuType(null).getFullDistinguishedName().equals(piuTypeAccess.getFullDistinguishedName())) {
                bl = true;
            }
            if (bl) {
                this.debugTrace(72, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "The Fan detected doesn't match the configuration. AutoConfiguration is set to off");
                this.theAddInfo = new AdditionalInfo[3];
                this.theAddInfo[0] = new AdditionalInfo("Alarm Cause", "Auto-configuration disabled, the configuration doesn't match the inserted fan.");
                this.theAddInfo[1] = new AdditionalInfo("PiuType product number:", string);
                this.theAddInfo[2] = new AdditionalInfo("PiuType product revision:", string2);
                fanMoInternal.raiseAutoConfigurationAlarm(this.theAddInfo);
            }
            return;
        }
        if (this.isConfigurationActivitiesNeeded(piuTypeAccess, fanMoInternal)) {
            if (this.findSwAllocationWithPiuType((ManagedObject)piuTypeAccess, managedObjectArray, null) == null) {
                this.debugTrace(72, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "The PiuType could not be found in the repertoire list of SWA ");
                if (this.getAutoConfigAllowed()) {
                    this.theAddInfo = new AdditionalInfo[3];
                    this.theAddInfo[0] = new AdditionalInfo("Alarm Cause", "Matching PiuType missing in SwAllocation RepertoireList.");
                    this.theAddInfo[1] = new AdditionalInfo("PiuType product number:", piuTypeAccess.getProductNumber(null));
                    this.theAddInfo[2] = new AdditionalInfo("PiuType product revision:", piuTypeAccess.getProductRevision(null));
                    fanMoInternal.raiseAutoConfigurationAlarm(this.theAddInfo);
                }
                return;
            }
            if (piuTypeAccess.getLmFilesInstallState(null) != 2) {
                this.debugTrace(72, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "\n\tPiuTypeMo: " + piuTypeAccess + "\n\tfanMo: " + fanMoInternal + "\n\tLmFilesInstallState: " + piuTypeAccess.getLmFilesInstallState(null));
                PlugNPlayHelperAccess plugNPlayHelperAccess = (PlugNPlayHelperAccess)ServiceLocatorFacade.getRepository().getService(PlugNPlayHelperAccess.class);
                plugNPlayHelperAccess.supervisePiuType(piuTypeAccess, (PlugNPlayListener)fanMoInternal);
                return;
            }
            this.updateFan(fanMoInternal, piuTypeAccess);
        } else {
            this.fanMatchesConfiguration(fanMoInternal, string3);
        }
        this.debugTrace(71, "create(String aProductNumber, String aProductRevision, String aSerialNumber, FanMoInternal fanMo)", "return");
    }

    public ManagedObject findSwAllocationWithPiuType(ManagedObject managedObject, ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        ManagedObject managedObject2 = null;
        try {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                bl = this.checkPiuTypeInSWA(managedObject, (SwAllocationMo)managedObjectArray[i], coordinator);
                if (!bl) continue;
                managedObject2 = managedObjectArray[i];
                this.debugTrace(72, "findSwAllocationWithPiuType(ManagedObject piuTypeMo, ManagedObject[] swAllocations, Coordinator c)", "SwAllocation found: " + managedObjectArray[i] + " includes piuType " + managedObject);
                break;
            }
            if (!bl) {
                this.debugTrace(72, "findSwAllocationWithPiuType(ManagedObject piuTypeMo, ManagedObject[] swAllocations, Coordinator c)", "No SwAllocation with matching piuType was found");
            }
        }
        catch (ClassCastException classCastException) {
            MessageLog.traceError(this.getClass(), (String)"findSwAllocationWithPiuType(ManagedObject piuTypeMo, ManagedObject[] swAllocations, Coordinator c), faulty input type", (Throwable)classCastException);
        }
        return managedObject2;
    }

    private void updateFan(FanMoInternal fanMoInternal, PiuTypeAccess piuTypeAccess) throws Exception {
        this.setFanPiuType(fanMoInternal, piuTypeAccess);
        this.reconfigureFanProgram(fanMoInternal);
        this.restartFan(fanMoInternal);
        this.removeDisabledFanProgram(fanMoInternal);
        AutoCreateFanMo.sendFanDetectedEvent(fanMoInternal, true);
        this.clearIssuedFanAlarm(fanMoInternal);
    }

    private void setFanPiuType(FanMoInternal fanMoInternal, PiuTypeAccess piuTypeAccess) throws Exception {
        this.debugTrace(70, "setFanPiuType(FanMoInternal fanMo, PiuTypeMoInternal piuTypeMo)", "set new PiuType for Fan");
        Control control = null;
        try {
            control = this.createTransaction();
            fanMoInternal.setPiuType((ManagedObject)piuTypeAccess, control.getCoordinator());
            control.getTerminator().commit();
            this.debugTrace(72, "setFanPiuType(FanMoInternal fanMo, PiuTypeMoInternal piuTypeMo)", "commit()");
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"setFanPiuType(FanMoInternal fanMo, PiuTypeMoInternal piuTypeMo)", (String)"Update Fan with new PiuType failed.", (Throwable)exception);
            if (control != null) {
                control.getTerminator().rollback();
            }
            throw exception;
        }
    }

    private void reconfigureFanProgram(FanMoInternal fanMoInternal) throws Exception {
        this.debugTrace(70, "reconfigureFanProgram(FanMoInternal fanMo)", "Reconfigure Fan Programs");
        Control control = null;
        try {
            control = this.createTransaction();
            fanMoInternal.actionReconfigureProgramPrepare(control.getCoordinator());
            control.getTerminator().commit();
            this.debugTrace(72, "reconfigureFanProgram(FanMoInternal fanMo)", "commit()");
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"reconfigureFanProgram(FanMoInternal fanMo)", (String)"Reconfiguration of Fan program failed.", (Throwable)exception);
            if (control != null) {
                control.getTerminator().rollback();
            }
            throw exception;
        }
    }

    private static void sendFanDetectedEvent(FanMoInternal fanMoInternal, boolean bl) {
        int n = bl ? 83 : 84;
        AlarmManager.getReporter().reportEvent(n, (ManagedObject)fanMoInternal, null, null, null);
    }

    private void restartFan(FanMoInternal fanMoInternal) throws Exception {
        this.debugTrace(70, "restartFan(FanMoInternal fanMo)", "Restart the Fan");
        Control control = null;
        try {
            control = this.createTransaction();
            fanMoInternal.actionRestartFan(2, control.getCoordinator());
            control.getTerminator().commit();
            this.debugTrace(72, "restartFan(FanMoInternal fanMo)", "Fan is restarted.");
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"restartFan()", (String)"Restart of Fan failed", (Throwable)exception);
            if (control != null) {
                control.getTerminator().rollback();
            }
            throw exception;
        }
    }

    private void removeDisabledFanProgram(FanMoInternal fanMoInternal) throws Exception {
        this.debugTrace(70, "removeDisabledFanProgram(FanMoInternal fanMo)", "Remove disabled Fan program");
        Control control = null;
        try {
            control = this.createTransaction();
            fanMoInternal.actionRemoveDisabledPrograms(control.getCoordinator());
            control.getTerminator().commit();
            this.debugTrace(72, "removeDisabledFanProgram(FanMoInternal fanMo)", "commit()");
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"removeDisabledFanProgram(FanMoInternal fanMo)", (String)"Remove disabled Fan Program failed.", (Throwable)exception);
            if (control != null) {
                control.getTerminator().rollback();
            }
            throw exception;
        }
    }

    private void fanMatchesConfiguration(FanMoInternal fanMoInternal, String string) throws Exception {
        this.debugTrace(70, "fanMatchesConfiguration(FanMoInternal fanMo, String serialNo)", "The Fan detected: " + fanMoInternal + " matches the configuration, previous SerialNo: " + fanMoInternal.getPreviousSerialNo() + " serialNo: " + string);
        if (!string.equals(fanMoInternal.getPreviousSerialNo())) {
            AutoCreateFanMo.sendFanDetectedEvent(fanMoInternal, true);
        }
        this.clearIssuedFanAlarm(fanMoInternal);
    }

    private PiuTypeAccess findPiuType(String string, String string2) throws MoAccessException {
        this.debugTrace(70, "FindPiuType(String prodNo, String prodRev)", "productNumber: " + string + ", and productRevision: " + string2);
        PiuTypeAccess piuTypeAccess = null;
        MoFactory moFactory = MoFactoryMgr.instance().lookup("PiuType");
        piuTypeAccess = ((PiuTypeMoFactorySU_Access)moFactory).lookupPiuType(null, true, string, string2);
        if (piuTypeAccess == null) {
            piuTypeAccess = ((PiuTypeMoFactorySU_Access)moFactory).lookupPiuType(null, false, string, string2);
        }
        return piuTypeAccess;
    }

    private boolean checkPiuTypeInSWA(ManagedObject managedObject, SwAllocationMo swAllocationMo, Coordinator coordinator) throws MoAccessException {
        this.debugTrace(70, "checkPiuTypeInSWA(ManagedObject piuType, SwAllocationMo swa, Coordinator c)", " piuType: " + managedObject + " swa: " + swAllocationMo);
        ManagedObject[] managedObjectArray = swAllocationMo.getRepertoireList(coordinator);
        if (managedObjectArray != null && managedObjectArray.length > 0) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                this.debugTrace(72, "checkPiuTypeInSWA(ManagedObject piuType, SwAllocationMo swa, Coordinator c)", "Repertoire: " + (RepertoireMo)managedObjectArray[i]);
                ManagedObject[] managedObjectArray2 = ((RepertoireMo)managedObjectArray[i]).getPiuTypeList(coordinator);
                if (managedObjectArray2 == null || managedObjectArray2.length <= 0) continue;
                for (int j = 0; j < managedObjectArray2.length; ++j) {
                    this.debugTrace(72, "checkPiuTypeInSWA(ManagedObject piuType, SwAllocationMo swa, Coordinator c)", "PiuType: " + (PiuTypeMo)managedObjectArray2[j]);
                    if (!managedObjectArray2[j].equals(managedObject)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Control createTransaction() throws Exception {
        Control control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
        this.debugTrace(72, "createTransaction()", "txId: " + control.getCoordinator().getTransactionID());
        return control;
    }

    private ManagedObject[] getSwAllocations(FanMoInternal fanMoInternal) throws Exception {
        ManagedObject[] managedObjectArray;
        this.debugTrace(70, "getSwAllocations(FanMoInternal fanMo)", "Fetch the SWAs from Fan");
        try {
            managedObjectArray = fanMoInternal.getSwAllocations(null);
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"getSwAllocations(FanMoInternal fanMo)", (String)"Fetch SwAllocations from Fan failed.", (Throwable)exception);
            throw exception;
        }
        return managedObjectArray;
    }

    private boolean getAutoConfigAllowed() throws MoAccessException {
        ManagedObject managedObject = ((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElementData")).getMo();
        return ((ManagedElementDataMoSU_Access)managedObject).getAutoConfigurationAllowedForSU(null);
    }

    private void debugTrace(int n, String string, String string2) {
        UpgradeTrace.debug(this.getClass(), (int)n, (String)string, (String)string2);
    }

    private boolean isConfigurationActivitiesNeeded(PiuTypeAccess piuTypeAccess, FanMoInternal fanMoInternal) throws MoAccessException {
        if (fanMoInternal instanceof PfmUnitMo) {
            return true;
        }
        return !fanMoInternal.getPiuType(null).getFullDistinguishedName().equals(piuTypeAccess.getFullDistinguishedName());
    }

    private void clearIssuedFanAlarm(FanMoInternal fanMoInternal) throws MoAccessException {
        this.debugTrace(70, "clearIssuedSlotAlarm(FanMoInternal fanMo)", "Fan/PfmUnit successfully created/updated, any previous issued alarm will be cleared for unit: " + fanMoInternal);
        fanMoInternal.clearAutoConfigurationAlarm();
    }

    public static synchronized AutoCreateFanMo instance() {
        if (instance == null) {
            instance = new AutoCreateFanMo();
        }
        return instance;
    }

    private AutoCreateFanMo() {
    }
}

