/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement.plugandplay;

import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.JvmMo;
import se.ericsson.cello.equipment.MoNotInPiuTypeException;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.equipment.PlugNPlayListener;
import se.ericsson.cello.equipment.SlotMoInternal;
import se.ericsson.cello.equipment.eqaccess.MO_HandlerFactoryAccess;
import se.ericsson.cello.equipment.eqaccess.PIU_OperStateListenerAccessInterface;
import se.ericsson.cello.equipment.intma.AutoCreateMosAccess;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.intma.PlugNPlayHelperAccess;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.managedelement.meaccess.ConfigurationVersionMO_HandlerAccess;
import se.ericsson.cello.managedelement.suaccess.ManagedElementDataMoSU_Access;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.RestartRejectedException;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.debug.Util;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.swmanagement.plugandplay.DisabledGenericProgramBaseFilter;
import se.ericsson.cello.swmanagement.plugandplay.GenericProgramBaseFilter;
import se.ericsson.cello.swmanagement.plugandplay.JavaHeapPnpHelper;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoFactorySU_Access;
import se.ericsson.cello.swmanagement.swmaccess.ServiceDeciderAccess;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class AutoCreateMos
implements AutoCreateMosAccess,
PIU_OperStateListenerAccessInterface {
    private boolean waitForOperState = true;
    private JavaHeapPnpHelper theJavaHeapHandler = new JavaHeapPnpHelper();
    private AdditionalInfo[] theAddInfo = null;
    private boolean nodeRestartRequested = false;
    private static AutoCreateMos instance = null;
    private static final int SLEEP_INTERVAL = 200;
    private static final int SLEEP_INTERVAL_MAX = 2000;

    public synchronized void create(String string, String string2, String string3, SlotMoInternal slotMoInternal) throws Exception {
        this.debugTrace(70, "create(String productNumber, String productRevision, String serialNumber, SlotMoInternal slot)", "Product data received for slot: " + slotMoInternal + " with productNumber: " + string + ", productRevision: " + string2 + ", serialNumber: " + string3 + " and autoConfigAllowed is set to: " + this.getAutoConfigAllowed());
        if (this.nodeRestartRequested) {
            this.debugTrace(72, "create()", "Node restart have been requested, configuration requests will be ignored until node is restarted. slot: " + slotMoInternal + ", productNumber: " + string + ", productRevision: " + string2 + ", serialNumber: " + string3);
            return;
        }
        PiuTypeAccess piuTypeAccess = this.findPiuType(string, string2, slotMoInternal);
        if (piuTypeAccess == null) {
            this.debugTrace(72, "create(String productNumber, String productRevision, String serialNumber, SlotMoInternal slot)", "PIU detected in slot: " + slotMoInternal + ", but no matching PiuType could be found in the node. " + "The function will return, and if autoConfigurationAllowed " + "is true an alarm will be raised.");
            return;
        }
        if (this.isRunningOnAStandAloneCV()) {
            this.prepareStandAloneConfiguration(slotMoInternal);
        }
        if (slotMoInternal.getSwAllocations(null).length == 0) {
            this.sendPiuDetecteEvent(slotMoInternal, false);
            this.debugTrace(72, "create()", "Returning, no SwAllocation is reserving this slot: " + slotMoInternal);
            return;
        }
        if (this.getPlugInUnit(slotMoInternal) != null) {
            this.reconfigurePiu(slotMoInternal, piuTypeAccess, this.getPlugInUnit(slotMoInternal), string3);
        } else {
            this.createPiu(slotMoInternal, piuTypeAccess);
        }
        this.debugTrace(72, "create(String productNumber, String productRevision, String serialNumber, SlotMoInternal slot)", "create completed for slot: " + slotMoInternal);
    }

    public ManagedObject findSwAllocationWithPiuType(ManagedObject managedObject, ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        ManagedObject managedObject2 = null;
        try {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                bl = this.checkPiuTypeInSWA(managedObject, (SwAllocationMo)managedObjectArray[i], coordinator);
                if (!bl) continue;
                managedObject2 = managedObjectArray[i];
                this.debugTrace(72, "findSwAllocationWithPiuType(ManagedObject piuTypeMo,  ManagedObject[] swAllocations, Coordinator c)", "SwAllocation found: " + managedObjectArray[i] + " includes PiuType " + managedObject);
                break;
            }
            if (!bl) {
                this.debugTrace(72, "findSwAllocationWithPiuType(ManagedObject piuTypeMo,  ManagedObject[] swAllocations, Coordinator c)", "No SwAllocation with matching piuType was found");
            }
        }
        catch (ClassCastException classCastException) {
            MessageLog.traceError(this.getClass(), (String)"findSwAllocationWithPiuType(ManagedObject piuTypeMo,  ManagedObject[] swAllocations, Coordinator c), faulty input type", (Throwable)classCastException);
        }
        return managedObject2;
    }

    private void reconfigurePiu(SlotMoInternal slotMoInternal, PiuTypeAccess piuTypeAccess, PlugInUnitMoInternal plugInUnitMoInternal, String string) throws Exception {
        if (plugInUnitMoInternal.getPiuType(null) == null) {
            if (!this.getAutoConfigAllowed()) {
                this.debugTrace(72, "reconfigurePiu(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu, String serialNo)", "PiuType for the configured PlugInUnit Mo is null, PlugInUnit:" + plugInUnitMoInternal);
                return;
            }
            this.debugTrace(72, "reconfigurePiu(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu, String serialNo)", "ERROR, PiuType for the configured PlugInUnit Mo is null, PlugInUnit:" + plugInUnitMoInternal);
            throw new ValueOutOfRangeException("The PiuType for configured PIU is null", "PlugInUnit");
        }
        if (this.getConfigState(piuTypeAccess, plugInUnitMoInternal) == 4) {
            if (this.isRunningOnAStandAloneCV()) {
                this.createCVAndRestartNode(plugInUnitMoInternal);
            } else {
                this.piuMatchConfiguration(slotMoInternal, string);
            }
        } else if (this.getConfigState(piuTypeAccess, plugInUnitMoInternal) == -1) {
            if (this.getAutoConfigAllowed()) {
                this.debugTrace(72, "reconfigurePiu(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu, String serialNo)", "The PIU is in initial state, configuration check will be executed.");
                this.updatePiuConfiguration(slotMoInternal, piuTypeAccess, plugInUnitMoInternal);
            }
        } else if (!this.getAutoConfigAllowed()) {
            if (!this.configFileExists()) {
                this.debugTrace(72, "reconfigurePiu(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu, String serialNo)", "autoConfigAllowed is set to: " + this.getAutoConfigAllowed() + " and the configured PlugInUnit doesn't match the new piu in slot: " + slotMoInternal + ". Alarm will be raised and function will return.");
                this.theAddInfo = new AdditionalInfo[3];
                this.theAddInfo[0] = new AdditionalInfo("Alarm Cause", "Auto-configuration disabled, the configuration doesn't match the inserted board.");
                this.theAddInfo[1] = new AdditionalInfo("PiuType product number:", piuTypeAccess.getProductNumber(null));
                this.theAddInfo[2] = new AdditionalInfo("PiuType product revision:", piuTypeAccess.getProductRevision(null));
                slotMoInternal.raiseAutoConfigurationAlarm(this.theAddInfo);
                return;
            }
        } else {
            this.debugTrace(72, "reconfigurePiu(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu, String serialNo)", "The configuration is not complete for the PlugInUnit in slot: " + slotMoInternal + ", configState: " + this.state2String(plugInUnitMoInternal.getInterruptState(null)));
            if (this.checkSwAllocations(slotMoInternal, piuTypeAccess) && this.isLmInstalled(piuTypeAccess, slotMoInternal)) {
                this.updatePiu(slotMoInternal, piuTypeAccess, plugInUnitMoInternal);
            }
        }
    }

    private void createPiu(SlotMoInternal slotMoInternal, PiuTypeAccess piuTypeAccess) throws Exception {
        if (!this.getAutoConfigAllowed()) {
            if (!this.configFileExists()) {
                this.debugTrace(72, "createPiu(SlotMoInternal slot, PiuTypeAccess piuType)", "autoConfigAllowed is set to: " + this.getAutoConfigAllowed() + " and no PlugInUnit is configured in slot: " + slotMoInternal + ". An alarm will be raised and function will return.");
                this.theAddInfo = new AdditionalInfo[3];
                this.theAddInfo[0] = new AdditionalInfo("Alarm Cause", "Auto-configuration disabled, the configuration doesn't match the inserted board.");
                this.theAddInfo[1] = new AdditionalInfo("PiuType product number:", piuTypeAccess.getProductNumber(null));
                this.theAddInfo[2] = new AdditionalInfo("PiuType product revision:", piuTypeAccess.getProductRevision(null));
                slotMoInternal.raiseAutoConfigurationAlarm(this.theAddInfo);
                return;
            }
        } else {
            this.debugTrace(72, "createPiu(SlotMoInternal slot, PiuTypeAccess piuType)", "No PlugInUnit configured in slot: " + slotMoInternal);
            if (this.checkSwAllocations(slotMoInternal, piuTypeAccess) && this.isLmInstalled(piuTypeAccess, slotMoInternal)) {
                PlugInUnitMoInternal plugInUnitMoInternal = this.createPlugInUnit(slotMoInternal, piuTypeAccess);
                this.theJavaHeapHandler.setJavaheap(piuTypeAccess, slotMoInternal, null);
                try {
                    this.restartPlugInUnit(plugInUnitMoInternal, 3, 30);
                }
                catch (RestartRejectedException restartRejectedException) {
                    if (this.isRunningOnAStandAloneCV()) {
                        this.createCVAndRestartNode(plugInUnitMoInternal);
                        return;
                    }
                    throw restartRejectedException;
                }
                this.clearIssuedSlotAlarm(slotMoInternal);
                this.sendPiuDetecteEvent(slotMoInternal, true);
                this.setConfigState(plugInUnitMoInternal, 4);
            }
        }
    }

    private void updatePiuConfiguration(SlotMoInternal slotMoInternal, PiuTypeAccess piuTypeAccess, PlugInUnitMoInternal plugInUnitMoInternal) {
        block15: {
            Control control = null;
            try {
                control = this.createTransaction();
                plugInUnitMoInternal.updateMoConfiguration(control.getCoordinator());
                if (this.checkSwAllocations(slotMoInternal, piuTypeAccess)) {
                    this.debugTrace(72, "updatePiuConfiguration(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu)", "SwAllocation exist and correct PiuType found within the connected Repertoires, slot: " + slotMoInternal);
                    if (this.isLmInstalled(piuTypeAccess, slotMoInternal)) {
                        int n = this.getNrOfPgm((ManagedObject)plugInUnitMoInternal);
                        ((GenericUpgradeablePlugInUnit)plugInUnitMoInternal).actionReconfigureProgramPrepare(control.getCoordinator());
                        boolean bl = this.theJavaHeapHandler.setJavaheap(piuTypeAccess, slotMoInternal, plugInUnitMoInternal);
                        if (this.isRestartNeeded((ManagedObject)plugInUnitMoInternal, n, control.getCoordinator()) || bl) {
                            this.debugTrace(72, "updatePiuConfiguration(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu)", "set piu state to PIUTYPE_UPDATED");
                            this.setPiuInterruptState(plugInUnitMoInternal, 1, control.getCoordinator());
                            control.getTerminator().commit();
                            try {
                                this.restartPlugInUnit(plugInUnitMoInternal, 1, 30);
                            }
                            catch (RestartRejectedException restartRejectedException) {
                                this.nodeRestartRequested = this.handleRestartReject(plugInUnitMoInternal, n, bl);
                            }
                            control = null;
                        }
                        if (!this.nodeRestartRequested) {
                            if (this.getConfigState(piuTypeAccess, plugInUnitMoInternal) == 2) {
                                this.deleteOldPrograms(plugInUnitMoInternal, piuTypeAccess);
                            }
                            this.clearIssuedSlotAlarm(slotMoInternal);
                            this.sendPiuDetecteEvent(slotMoInternal, true);
                            if (control == null) {
                                control = this.createTransaction();
                            }
                            this.debugTrace(72, "updatePiuConfiguration(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu)", "state set to COMPLETED.");
                            this.setPiuInterruptState(plugInUnitMoInternal, 4, control.getCoordinator());
                        }
                    } else {
                        this.debugTrace(72, "updatePiuConfiguration(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu)", "Install started. P&P will be started again when all lm's for this PiuType is installed");
                    }
                } else {
                    UpgradeTrace.warning(this.getClass(), (String)"updatePiuConfiguration(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu)", (String)("Failed to verify/update the configuration for the PIU in slot: " + slotMoInternal + ". Matching PiuType could not be found in any preconfigured SwAllocation."));
                }
                if (control != null) {
                    control.getTerminator().commit();
                }
            }
            catch (Exception exception) {
                UpgradeTrace.error(this.getClass(), (String)"updatePiuConfiguration(SlotMoInternal slot, PiuTypeAccess piuType, PlugInUnitMoInternal piu)", (String)("Failed to update the configuration for the PlugInUnit in slot: " + slotMoInternal), (Throwable)exception);
                if (control == null) break block15;
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    this.debugTrace(72, "updatePiuConfiguration()", "Caught InactiveTransactionException at rollback, ignore");
                }
            }
        }
        this.debugTrace(72, "updatePiuConfiguration()", "return");
    }

    private void updatePiu(SlotMoInternal slotMoInternal, PiuTypeAccess piuTypeAccess, PlugInUnitMoInternal plugInUnitMoInternal) throws Exception {
        block21: {
            this.debugTrace(70, "updatePiu(SlotMoInternal slot, PiuTypeMo piuType, PlugInUnitMoInternal piu)", "Update PlugInUnit in slot: " + slotMoInternal);
            Control control = null;
            try {
                control = this.createTransaction();
                Coordinator coordinator = control.getCoordinator();
                SwAllocationMo swAllocationMo = (SwAllocationMo)slotMoInternal.getCalculatedSwAllocation(coordinator);
                if (swAllocationMo == null) {
                    this.debugTrace(72, "updatePiu()", "No active SwAllocation found.");
                    if (control != null) {
                        control.getTerminator().commit();
                    }
                    break block21;
                }
                this.debugTrace(72, "updatePiu()", "Active SwAllocation found: " + swAllocationMo.getLocalDistinguishedName());
                if (this.checkPiuTypeInSWA((ManagedObject)piuTypeAccess, swAllocationMo, coordinator)) {
                    this.debugTrace(72, "updatePiu()", "Reconfiguration within same SwAllocation.");
                    if (control != null) {
                        control.getTerminator().commit();
                    }
                    break block21;
                }
                this.debugTrace(72, "updatePiu()", "Reconfiguration will require a role change, i.e. a change of active SwAllocation.");
                try {
                    plugInUnitMoInternal.checkPiuTypeCompliance(coordinator);
                    this.debugTrace(72, "updatePiu()", "Existing MO configuration is covered by the old piuType,  ok to proceed.");
                    if (control != null) {
                        control.getTerminator().commit();
                    }
                }
                catch (MoNotInPiuTypeException moNotInPiuTypeException) {
                    String string = moNotInPiuTypeException.getVariablesAsString();
                    int n = string.indexOf("=");
                    String string2 = string.substring(n + 1);
                    AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("Alarm Cause", "User defined MO not compliant with existing piuType, illegal at role change."), new AdditionalInfo("The user defined MO: ", string2)};
                    slotMoInternal.raiseAutoConfigurationAlarm(additionalInfoArray);
                    this.debugTrace(72, "updatePiu()", "User defined MO not compliant with existing piuType, illegal at role change. Exception: " + (Object)((Object)moNotInPiuTypeException) + " Alarm sent. The user defined MO: " + string2);
                    if (control != null) {
                        try {
                            control.getTerminator().rollback();
                        }
                        catch (InactiveTransactionException inactiveTransactionException) {
                            this.debugTrace(72, "updatePiu()", "Caught InactiveTransactionException at rollback, ignore");
                        }
                    }
                    return;
                }
            }
            catch (Exception exception) {
                UpgradeTrace.error(this.getClass(), (String)"updatePiu()", (String)("Error occurred during check of role change for PlugInUnit in slot: " + slotMoInternal), (Throwable)exception);
                if (control != null) {
                    try {
                        control.getTerminator().rollback();
                    }
                    catch (InactiveTransactionException inactiveTransactionException) {
                        this.debugTrace(72, "updatePiu()", "Caught InactiveTransactionException at rollback, ignore");
                    }
                }
                throw exception;
            }
        }
        int n = this.getNrOfPgm((ManagedObject)plugInUnitMoInternal);
        boolean bl = this.theJavaHeapHandler.setJavaheap(piuTypeAccess, slotMoInternal, plugInUnitMoInternal);
        if (this.getConfigState(piuTypeAccess, plugInUnitMoInternal) < 1) {
            this.updatePlugInUnit(plugInUnitMoInternal, piuTypeAccess);
        }
        try {
            if (this.getConfigState(piuTypeAccess, plugInUnitMoInternal) == 1) {
                this.restartPlugInUnit(plugInUnitMoInternal, 3, 30);
            }
        }
        catch (RestartRejectedException restartRejectedException) {
            this.nodeRestartRequested = this.handleRestartReject(plugInUnitMoInternal, n, bl);
        }
        if (!this.nodeRestartRequested) {
            if (this.getConfigState(piuTypeAccess, plugInUnitMoInternal) == 2) {
                this.deleteOldPrograms(plugInUnitMoInternal, piuTypeAccess);
            }
            this.clearIssuedSlotAlarm(slotMoInternal);
            this.sendPiuDetecteEvent(slotMoInternal, true);
            this.setConfigState(plugInUnitMoInternal, 4);
        }
    }

    private void piuMatchConfiguration(SlotMoInternal slotMoInternal, String string) throws Exception {
        this.debugTrace(70, "piuMatchConfiguration(SlotMoInternal slot,  String serialNo)", "The PlugInUnit in slot: " + slotMoInternal + " already match the configuration, previous SerialNo: " + slotMoInternal.getPreviousSerialNo() + " serialNo: " + string);
        if (!string.trim().equals(slotMoInternal.getPreviousSerialNo().trim())) {
            this.sendPiuDetecteEvent(slotMoInternal, true);
        }
        this.clearIssuedSlotAlarm(slotMoInternal);
    }

    private PlugInUnitMoInternal createPlugInUnit(SlotMoInternal slotMoInternal, PiuTypeAccess piuTypeAccess) throws Exception {
        this.debugTrace(70, "createPlugInUnit(SlotMoInternal slot, PiuTypeAccess piuType)", "Create a PlugInUnit");
        Control control = null;
        PlugInUnitMoInternal plugInUnitMoInternal = null;
        try {
            control = this.createTransaction();
            AttrListImpl attrListImpl = new AttrListImpl(3);
            attrListImpl.addElement("piuType", (Object)piuTypeAccess);
            attrListImpl.addElement("administrativeState", (Object)new Integer(0));
            attrListImpl.addElement("piuGroupNumber", (Object)new Integer(0));
            MoFactory moFactory = MoFactoryMgr.instance().lookup("PlugInUnit");
            plugInUnitMoInternal = (PlugInUnitMoInternal)moFactory.createMo((ManagedObject)slotMoInternal, (AttrList)attrListImpl, "1", null, control.getCoordinator());
            this.debugTrace(72, "createPlugInUnit(SlotMoInternal slot, PiuTypeAccess piuType)", "set piu state to PIUTYPE_UPDATED");
            this.setPiuInterruptState(plugInUnitMoInternal, 1, control.getCoordinator());
            control.getTerminator().commit();
            this.debugTrace(72, "createPlugInUnit(SlotMoInternal slot, PiuTypeAccess piuType)", "commit()");
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"createPlugInUnit()", (String)("Create of PlugInUnit failed in slot: " + slotMoInternal), (Throwable)exception);
            if (control != null) {
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    this.debugTrace(72, "createPlugInUnit()", "Caught InactiveTransactionException at rollback, ignore");
                }
            }
            throw exception;
        }
        return plugInUnitMoInternal;
    }

    private void restartPlugInUnit(PlugInUnitMoInternal plugInUnitMoInternal, int n, int n2) throws Exception {
        this.debugTrace(72, "restartPlugInUnit(PlugInUnitMoInternal piu, int restartRank, int restartReason)", "restarting the pluginunit " + plugInUnitMoInternal);
        ((PlugInUnitMoSU_Access)plugInUnitMoInternal).subscribeForOperStateAVCs((PIU_OperStateListenerAccessInterface)this);
        this.debugTrace(70, "restartPlugInUnit(PlugInUnitMoInternal piu, int restartRank, int restartReason)", "Restart PlugInUnit: " + plugInUnitMoInternal + " restartRank: " + n + " restartReason: " + n2);
        Control control = null;
        try {
            control = this.createTransaction();
            this.debugTrace(72, "restartPlugInUnit(PlugInUnitMoInternal piu, int restartRank, int restartReason)", "set piu state to RESTARTED");
            this.setPiuInterruptState(plugInUnitMoInternal, 2, control.getCoordinator());
            if (this.jvmActive(plugInUnitMoInternal)) {
                control.getTerminator().commit();
                this.debugTrace(72, "restartPlugInUnit(PlugInUnitMoInternal piu, int restartRank, int restartReason)", "commit() set interrupt state");
                control = this.createTransaction();
            }
            if (this.isRunningOnAStandAloneCV()) {
                this.debugTrace(72, "restartPlugInUnit(PlugInUnitMoInternal piu, int restartRank, int restartReason)", "PIU restart is rejected since we are running on a standalone CV.");
                throw new RestartRejectedException("PIU Restart is not allowed while running a standalone CV");
            }
            plugInUnitMoInternal.systemInitiatedRestart(n, n2, "PIU restart ordered by AutoConfiguration.", control.getCoordinator());
            control.getTerminator().commit();
            this.debugTrace(72, "restartPlugInUnit(PlugInUnitMoInternal piu, int restartRank, int restartReason)", "commit()");
        }
        catch (RestartRejectedException restartRejectedException) {
            if (control != null) {
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    this.debugTrace(72, "restartPlugInUnit()", "Caught InactiveTransactionException at rollback, ignore");
                }
                this.debugTrace(72, "restartPlugInUnit(PlugInUnitMoInternal piu, int restartRank, int restartReason)", "restartRejected, rollback()");
            }
            throw restartRejectedException;
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"restartPlugInUnit(PlugInUnitMoInternal piu, int restartRank, int restartReason)", (String)("Restart of PlugInUnit failed. PlugInUnit: " + plugInUnitMoInternal), (Throwable)exception);
            if (control != null) {
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    this.debugTrace(72, "restartPlugInUnit()", "Caught InactiveTransactionException at rollback, ignore");
                }
            }
            throw exception;
        }
    }

    private boolean jvmActive(PlugInUnitMoInternal plugInUnitMoInternal) throws MoAccessException {
        ManagedObject managedObject = ((SingletonMoFactory)MoFactoryMgr.instance().lookup("Jvm")).getMo();
        ManagedObject managedObject2 = ((JvmMo)managedObject).getActivePiuId(null);
        if (managedObject2 == null) {
            this.debugTrace(72, "jvmActive(PlugInUnitMoInternal piu)", "jvmPiu is null");
            return true;
        }
        if (managedObject2.getFullDistinguishedName().equals(plugInUnitMoInternal.getFullDistinguishedName())) {
            this.debugTrace(72, "jvmActive(PlugInUnitMoInternal piu)", "Active JVM is running on this PlugInUnit");
            return true;
        }
        return false;
    }

    private void updatePlugInUnit(PlugInUnitMoInternal plugInUnitMoInternal, PiuTypeAccess piuTypeAccess) throws Exception {
        this.debugTrace(70, "updatePlugInUnit(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", "changePiuType and reconfigure Program");
        Control control = null;
        try {
            control = this.createTransaction();
            plugInUnitMoInternal.changePiuType((ManagedObject)piuTypeAccess, control.getCoordinator());
            ((GenericUpgradeablePlugInUnit)plugInUnitMoInternal).actionReconfigureProgramPrepare(control.getCoordinator());
            this.debugTrace(72, "updatePlugInUnit(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", "set piu state to PIUTYPE_UPDATED");
            this.setPiuInterruptState(plugInUnitMoInternal, 1, control.getCoordinator());
            control.getTerminator().commit();
            this.debugTrace(72, "updatePlugInUnit(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", "commit()");
        }
        catch (MoAccessException moAccessException) {
            if (moAccessException instanceof MoHasChildrenException || moAccessException instanceof MoReservedNotDeletableException) {
                String string = moAccessException.getVariablesAsString();
                int n = string.indexOf("=");
                String string2 = string.substring(n + 1);
                AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("Alarm Cause", "Existing MO configuration not covered by the piuType is blocking reconfiguration."), new AdditionalInfo("The MO that could not be deleted: ", string2)};
                ((SlotMoInternal)plugInUnitMoInternal.getParent()).raiseAutoConfigurationAlarm(additionalInfoArray);
                this.debugTrace(72, "updatePlugInUnit(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", "Existing MO configuration not covered by the piuType is blocking reconfiguration. Exception: " + (Object)((Object)moAccessException) + " Alarm sent. The MO that could not be deleted:" + string2);
                if (control != null) {
                    try {
                        control.getTerminator().rollback();
                    }
                    catch (InactiveTransactionException inactiveTransactionException) {
                        this.debugTrace(72, "updatePlugInUnit()", "Caught InactiveTransactionException at rollback, ignore");
                    }
                }
                throw moAccessException;
            }
            UpgradeTrace.error(this.getClass(), (String)"updatePlugInUnit(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", (String)("Update of PlugInUnit failed " + plugInUnitMoInternal), (Throwable)moAccessException);
            if (control != null) {
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    this.debugTrace(72, "updatePlugInUnit()", "Caught InactiveTransactionException at rollback, ignore");
                }
            }
            throw moAccessException;
        }
    }

    private PiuTypeAccess findPiuType(String string, String string2, SlotMoInternal slotMoInternal) throws MoAccessException {
        this.debugTrace(70, "findPiuType(String prodNo, String prodRev, SlotMoInternal slot)", "productNumber: " + string + ", and productRevision: " + string2);
        PiuTypeAccess piuTypeAccess = null;
        MoFactory moFactory = MoFactoryMgr.instance().lookup("PiuType");
        piuTypeAccess = ((PiuTypeMoFactorySU_Access)moFactory).lookupPiuType(null, true, string, string2);
        if (piuTypeAccess == null) {
            piuTypeAccess = ((PiuTypeMoFactorySU_Access)moFactory).lookupPiuType(null, false, string, string2);
        }
        if (piuTypeAccess == null && this.getAutoConfigAllowed()) {
            this.theAddInfo = new AdditionalInfo[3];
            this.theAddInfo[0] = new AdditionalInfo("Alarm Cause", "Matching PiuType missing in configuration.");
            this.theAddInfo[1] = new AdditionalInfo("Product number:", string);
            this.theAddInfo[2] = new AdditionalInfo("Product revision:", string2);
            slotMoInternal.raiseAutoConfigurationAlarm(this.theAddInfo);
        }
        return piuTypeAccess;
    }

    private boolean checkPiuTypeInSWA(ManagedObject managedObject, SwAllocationMo swAllocationMo, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = swAllocationMo.getRepertoireList(null);
        boolean bl = false;
        if (managedObjectArray != null && managedObjectArray.length > 0) {
            block0: for (int i = 0; i < managedObjectArray.length; ++i) {
                ManagedObject[] managedObjectArray2 = ((RepertoireMo)managedObjectArray[i]).getPiuTypeList(coordinator);
                if (managedObjectArray2 == null || managedObjectArray2.length <= 0) continue;
                for (int j = 0; j < managedObjectArray2.length; ++j) {
                    if (!managedObjectArray2[j].equals(managedObject)) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        return bl;
    }

    private Control createTransaction() throws Exception {
        Control control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
        Coordinator coordinator = control.getCoordinator();
        this.debugTrace(72, "createTransaction()", "TransactionId: " + coordinator.getTransactionID());
        MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
        return control;
    }

    private void sendPiuDetecteEvent(SlotMoInternal slotMoInternal, boolean bl) {
        int n = bl ? 45 : 46;
        AlarmManager.getReporter().reportEvent(n, (ManagedObject)slotMoInternal, null, null, null);
    }

    private boolean isRestartNeeded(ManagedObject managedObject, int n) throws MoAccessException {
        return this.isRestartNeeded(managedObject, n, null);
    }

    private boolean isRestartNeeded(ManagedObject managedObject, int n, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        int n2 = 0;
        if (this.isRunningOnAStandAloneCV()) {
            this.debugTrace(72, "isRestartNeeded(ManagedObject piu, int nrOfPgmsBeforeReconfigure, Coordinator context)", "Running on a standalone CV, restart required");
            return true;
        }
        MoIterator moIterator = MoRepository.instance().select(managedObject, -1, (MoFilter)new DisabledGenericProgramBaseFilter(coordinator));
        if (moIterator != null && moIterator.size() > 0) {
            bl = true;
        }
        if ((n2 = this.getNrOfPgm(managedObject)) != n) {
            bl = true;
        }
        this.debugTrace(72, "isRestartNeeded(ManagedObject piu, int nrOfPgmsBeforeReconfigure, Coordinator context)", "Restart required: " + bl + " for PIU: " + managedObject + ". Disabled pgms: " + moIterator.size() + ", before reconfig: " + n + ", after reconfig: " + n2);
        return bl;
    }

    private void createCv() throws MoAccessException {
        MO_HandlerFactoryAccess mO_HandlerFactoryAccess = (MO_HandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccess.class);
        ConfigurationVersionMO_HandlerAccess configurationVersionMO_HandlerAccess = mO_HandlerFactoryAccess.getConfigurationVersionMO_HandlerAccess();
        configurationVersionMO_HandlerAccess.createPlugAndPlayCV_AndSetStartable("PnP CV autocreated at update of Core MP.");
    }

    private int getNrOfPgm(ManagedObject managedObject) {
        MoIterator moIterator = MoRepository.instance().select(managedObject, -1, (MoFilter)new GenericProgramBaseFilter());
        int n = 0;
        if (moIterator != null) {
            n = moIterator.size();
            this.debugTrace(72, "getNrOfPgm(ManagedObject piu)", "nrOf GenericProgramBase: " + n);
        }
        return n;
    }

    private PlugInUnitMoInternal getPlugInUnit(SlotMoInternal slotMoInternal) {
        MoIterator moIterator = slotMoInternal.getChildren();
        PlugInUnitMoInternal plugInUnitMoInternal = null;
        ManagedObject managedObject = null;
        if (moIterator != null && moIterator.hasMoreElements() && (managedObject = moIterator.nextMo()) instanceof PlugInUnitMoInternal) {
            plugInUnitMoInternal = (PlugInUnitMoInternal)managedObject;
        }
        return plugInUnitMoInternal;
    }

    private boolean getAutoConfigAllowed() throws MoAccessException {
        if (this.configFileExists()) {
            this.debugTrace(72, "getAutoConfigAllowed()", "Either emergency restore or restore is ongoing.\n\tThe value of attribute AutoConfigurationAllowed is treated as false.");
            return false;
        }
        ManagedObject managedObject = ((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElementData")).getMo();
        return ((ManagedElementDataMoSU_Access)managedObject).getAutoConfigurationAllowedForSU(null);
    }

    private boolean configFileExists() throws MoAccessException {
        ServiceDeciderAccess serviceDeciderAccess = (ServiceDeciderAccess)ServiceLocatorFacade.getRepository().getService(ServiceDeciderAccess.class);
        return serviceDeciderAccess.isRestoreAndPnP_ConfigOngoing();
    }

    private boolean handleRestartReject(PlugInUnitMoInternal plugInUnitMoInternal, int n, boolean bl) throws Exception {
        this.debugTrace(70, "handleRestartReject(PlugInUnitMoInternal piu, int nrOfPiuPgm)", "Restart is rejected");
        boolean bl2 = this.isRestartNeeded((ManagedObject)plugInUnitMoInternal, n);
        if (bl2 || bl) {
            this.debugTrace(72, "handleRestartReject(PlugInUnitMoInternal piu, int nrOfPiuPgm)", "Restart needed, saving configuration, creating new CV");
            this.createCVAndRestartNode(plugInUnitMoInternal);
            return true;
        }
        this.debugTrace(72, "handleRestartReject(PlugInUnitMoInternal piu, int nrOfPiuPgm)", "Node restart is not required, no programs added or deleted");
        return false;
    }

    private void createCVAndRestartNode(PlugInUnitMoInternal plugInUnitMoInternal) throws Exception {
        this.debugTrace(72, "createCVAndRestartNode()", "Node Restart will be executed, creating new CV");
        this.setConfigState(plugInUnitMoInternal, 2);
        MO_HandlerFactoryAccess mO_HandlerFactoryAccess = (MO_HandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccess.class);
        ConfigurationVersionMO_HandlerAccess configurationVersionMO_HandlerAccess = mO_HandlerFactoryAccess.getConfigurationVersionMO_HandlerAccess();
        if (configurationVersionMO_HandlerAccess.getRollbackOn(null)) {
            this.debugTrace(72, "createCVAndRestartNode()", "Rollback is on");
            try {
                int n = configurationVersionMO_HandlerAccess.getRollbackCounter(null);
                configurationVersionMO_HandlerAccess.setRollbackCounterForSU(n + 1, null);
                this.debugTrace(72, "createCVAndRestartNode()", "RollbackCounter is set to: " + n + 1);
            }
            catch (MoAccessException moAccessException) {
                UpgradeTrace.log1(this.getClass(), (String)"createCVAndRestartNode()", (String)("Failed to set rollbackCounter due to: " + (Object)((Object)moAccessException)));
            }
        } else {
            this.debugTrace(72, "createCVAndRestartNode()", "Rollback is disabled");
        }
        this.createCv();
        this.debugTrace(72, "createCVAndRestartNode()", "Node restart will be requested");
        ManagedObject managedObject = ((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElement")).getMo();
        ((ManagedElementMo)managedObject).systemInitiatedRestart(3, 20, "Node restart ordered by AutoConfiguration.", null);
    }

    public void operStateHasBeenSet(PlugInUnitMoSU_Access plugInUnitMoSU_Access, int n) {
        this.debugTrace(70, "operStateHasBeenSet(PlugInUnitMoSU_Access aPiu, int anOperState)", "aPiu: " + plugInUnitMoSU_Access + "\n\tanOperState: " + n);
        if (n == 1) {
            this.debugTrace(72, "operStateHasBeenSet(PlugInUnitMoSU_Access a Piu, int anOperState)", "Subscribing for operState enabled: " + plugInUnitMoSU_Access.toString());
            plugInUnitMoSU_Access.unSubscribeForOperStateAVCs((PIU_OperStateListenerAccessInterface)this);
            this.waitForOperState = false;
        }
    }

    private void deleteOldPrograms(PlugInUnitMoInternal plugInUnitMoInternal, PiuTypeAccess piuTypeAccess) throws Exception {
        int n = 0;
        UpgradeTrace.info(this.getClass(), (String)"deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", (String)"Remove disabled Programs");
        try {
            do {
                if (!this.waitForOperState) {
                    UpgradeTrace.info(this.getClass(), (String)"deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", (String)"operationalState of active core MP is enabled.");
                    this.waitForOperState = true;
                    break;
                }
                Thread.sleep(200L);
                UpgradeTrace.info(this.getClass(), (String)"deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", (String)"Waiting till the operationalState of active core MP becomes enabled.");
            } while ((n += 200) <= 2000);
        }
        catch (InterruptedException interruptedException) {
            this.debugTrace(72, "deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", "sleep failed");
        }
        Control control = null;
        ((PlugInUnitMoSU_Access)plugInUnitMoInternal).unSubscribeForOperStateAVCs((PIU_OperStateListenerAccessInterface)this);
        try {
            control = this.createTransaction();
            plugInUnitMoInternal.deleteOldPrograms(control.getCoordinator(), (ManagedObject)piuTypeAccess);
            this.debugTrace(72, "deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", "set piu state to PGM_DELETED");
            this.setPiuInterruptState(plugInUnitMoInternal, 3, control.getCoordinator());
            control.getTerminator().commit();
            this.debugTrace(72, "deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", "commit()");
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            this.debugTrace(72, "deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", "Transaction Server is down.");
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", (String)("Removal of disabled program's failed for PlugInUnit: " + plugInUnitMoInternal + exception));
            if (control != null) {
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    this.debugTrace(72, "deleteOldPrograms()", "Caught InactiveTransactionException at rollback, ignore");
                }
            }
            throw exception;
        }
        UpgradeTrace.info(this.getClass(), (String)"deleteOldPrograms(PlugInUnitMoInternal piu, PiuTypeAccess piuType)", (String)"RETURN");
    }

    private boolean checkSwAllocations(SlotMoInternal slotMoInternal, PiuTypeAccess piuTypeAccess) throws MoAccessException {
        ManagedObject[] managedObjectArray = slotMoInternal.getSwAllocations(null);
        if (managedObjectArray.length == 0) {
            UpgradeTrace.info(this.getClass(), (String)"checkSwAllocations(SlotMoInternal slot, PiuTypeAccess piuType)", (String)("No SwAllocation is reserving this slot: " + slotMoInternal + ". This should have been discovered already in an earlier stage."));
            return false;
        }
        ManagedObject managedObject = this.findSwAllocationWithPiuType((ManagedObject)piuTypeAccess, managedObjectArray, null);
        if (managedObject == null) {
            if (this.getAutoConfigAllowed()) {
                this.theAddInfo = new AdditionalInfo[3];
                this.theAddInfo[0] = new AdditionalInfo("Alarm Cause", "Matching PiuType missing in SwAllocation RepertoireList.");
                this.theAddInfo[1] = new AdditionalInfo("PiuType product number:", piuTypeAccess.getProductNumber(null));
                this.theAddInfo[2] = new AdditionalInfo("PiuType product revision:", piuTypeAccess.getProductRevision(null));
                slotMoInternal.raiseAutoConfigurationAlarm(this.theAddInfo);
                this.debugTrace(72, "checkSwAllocations(SlotMoInternal slot, PiuTypeAccess piuType)", "Alarm raised, the PiuType could not be found in the repertoire list  of any SwAllocation for slot: " + slotMoInternal);
            }
            return false;
        }
        return true;
    }

    private void clearIssuedSlotAlarm(SlotMoInternal slotMoInternal) throws MoAccessException {
        this.debugTrace(70, "clearIssuedSlotAlarm(SlotMoInternal slot)", "PlugInUnit successful created/updated, any previous issued alarm will be cleared for slot: " + slotMoInternal);
        slotMoInternal.clearAutoConfigurationAlarm();
    }

    private void debugTrace(int n, String string, String string2) {
        UpgradeTrace.debug(this.getClass(), (int)n, (String)string, (String)string2);
    }

    private void setPiuInterruptState(PlugInUnitMoInternal plugInUnitMoInternal, int n, Coordinator coordinator) throws MoAccessException {
        plugInUnitMoInternal.setInterruptState(n, coordinator);
        if (n == 4) {
            SlotMoInternal slotMoInternal = (SlotMoInternal)plugInUnitMoInternal.getParent();
            ManagedObject managedObject = this.findSwAllocationWithPiuType(plugInUnitMoInternal.getPiuType(coordinator), slotMoInternal.getSwAllocations(coordinator), coordinator);
            slotMoInternal.updateActiveSwAllocation(managedObject, coordinator);
        }
    }

    private void setConfigState(PlugInUnitMoInternal plugInUnitMoInternal, int n) throws Exception {
        Control control = null;
        try {
            control = this.createTransaction();
            this.setPiuInterruptState(plugInUnitMoInternal, n, control.getCoordinator());
            this.debugTrace(72, "setConfigState(PlugInUnitMoInternal piu, int state)", "set piu state " + this.state2String(n) + " piu: " + plugInUnitMoInternal);
            control.getTerminator().commit();
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"setConfigState(PlugInUnitMoInternal piu, int state)", (String)("Update of configuration state failed for PlugInUnit: " + plugInUnitMoInternal), (Throwable)exception);
            if (control != null) {
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    this.debugTrace(72, "setConfigState()", "Caught InactiveTransactionException at rollback, ignore");
                }
            }
            throw exception;
        }
    }

    private int getConfigState(PiuTypeAccess piuTypeAccess, PlugInUnitMoInternal plugInUnitMoInternal) throws MoAccessException {
        int n;
        try {
            ManagedObject managedObject = plugInUnitMoInternal.getPiuType(null);
            n = !managedObject.getFullDistinguishedName().equals(piuTypeAccess.getFullDistinguishedName()) ? 0 : (plugInUnitMoInternal.getInterruptState(null) == 0 ? -1 : plugInUnitMoInternal.getInterruptState(null));
        }
        catch (NullPointerException nullPointerException) {
            UpgradeTrace.log1(this.getClass(), (String)"getConfigState(PiuTypeAccess newPiuType, PlugInUnitMoInternal piu)", (String)("Failed to read attributes for PlugInUnit: " + plugInUnitMoInternal + ", exception: " + nullPointerException + ", stack trace: " + Util.stack2string((Throwable)nullPointerException)));
            throw new InvalidReferenceException("PlugInUnit: " + plugInUnitMoInternal, (Object)("Failed to access PiuType reference, " + nullPointerException));
        }
        this.debugTrace(71, "getConfigState(PiuTypeAccess newPiuType, PlugInUnitMoInternal piu)", "Returning state = " + this.state2String(n));
        return n;
    }

    private String state2String(int n) {
        String string;
        switch (n) {
            case -1: {
                string = "INITIAL_CONFIGURED";
                break;
            }
            case 0: {
                string = "CONFIGURATION_MISMATCH";
                break;
            }
            case 1: {
                string = "PIUTYPE_UPDATED";
                break;
            }
            case 2: {
                string = "RESTARTED";
                break;
            }
            case 3: {
                string = "PGM_DELETED";
                break;
            }
            case 4: {
                string = "COMPLETED";
                break;
            }
            default: {
                string = "INVALID_STATE";
            }
        }
        return string;
    }

    private boolean isLmInstalled(PiuTypeAccess piuTypeAccess, SlotMoInternal slotMoInternal) throws MoAccessException {
        if (piuTypeAccess.getLmFilesInstallState(null) != 2) {
            this.debugTrace(72, "isLmInstalled(PiuTypeAccess piuType, SlotMoInternal slot)", "The PiuType MO must be installed to be able to proceed with P&P.\n\tPiuTypeAccess: " + piuTypeAccess + "\n\tslot: " + slotMoInternal + "\n\tLmFilesInstallState: " + piuTypeAccess.getLmFilesInstallState(null));
            PlugNPlayHelperAccess plugNPlayHelperAccess = (PlugNPlayHelperAccess)ServiceLocatorFacade.getRepository().getService(PlugNPlayHelperAccess.class);
            plugNPlayHelperAccess.supervisePiuType(piuTypeAccess, (PlugNPlayListener)slotMoInternal);
            return false;
        }
        this.debugTrace(72, "isLmInstalled(PiuTypeAccess piuType, SlotMoInternal slot)", "The PiuType is installed. LmFilesInstallState: " + piuTypeAccess.getLmFilesInstallState(null));
        return true;
    }

    public void prepareStandAloneConfiguration(SlotMoInternal slotMoInternal) throws Exception {
        MoIterator moIterator = MoRepository.instance().lookupType("PlugInUnit");
        if (moIterator.size() != 1) {
            throw new ConfigurationMismatchException("The correct number fo PlugInUnit's is not configured in the executing standalone CV, PIUs: " + moIterator.size());
        }
        while (moIterator != null && moIterator.hasMoreElements()) {
            PlugInUnitMo plugInUnitMo = (PlugInUnitMo)moIterator.nextMo();
            SlotMoInternal slotMoInternal2 = (SlotMoInternal)plugInUnitMo.getParent();
            if (slotMoInternal2.getFullDistinguishedName().equals(slotMoInternal.getFullDistinguishedName())) {
                this.debugTrace(72, "prepareStandAloneConfiguration()", "The PIU is configured in the same slot as the board is located, no need to move SWA.");
                continue;
            }
            this.reconfigureSwAllocations(slotMoInternal, slotMoInternal2);
            Control control = null;
            try {
                this.debugTrace(72, "prepareStandAloneConfiguration()", "Delete the existing PIU in wrong slot position, PIU: " + plugInUnitMo);
                control = this.createTransaction();
                plugInUnitMo.delete(control.getCoordinator());
                control.getTerminator().commit();
            }
            catch (Exception exception) {
                UpgradeTrace.log1(this.getClass(), (String)"prepareStandAloneConfiguration()", (String)("Failed to delete the existing PlugInUnit configured in slot position, PIU: " + plugInUnitMo + ", due to e: " + exception));
                if (control == null) continue;
                try {
                    control.getTerminator().rollback();
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    this.debugTrace(72, "prepareStandAloneConfiguration()", "Caught InactiveTransactionException at rollback, ignore");
                }
            }
        }
    }

    private void reconfigureSwAllocations(SlotMoInternal slotMoInternal, SlotMoInternal slotMoInternal2) throws Exception {
        Control control = null;
        ManagedObject[] managedObjectArray = slotMoInternal.getSwAllocations(null);
        if (managedObjectArray.length == 0) {
            this.debugTrace(72, "reconfigureSwAllocations()", "The slot: " + slotMoInternal + " is currently not configured with any SWAs");
            try {
                control = this.createTransaction();
                ManagedObject[] managedObjectArray2 = slotMoInternal2.getSwAllocations(control.getCoordinator());
                this.debugTrace(72, "reconfigureSwAllocations()", "Copy SWA: " + Lib.toString((ManagedObject[])managedObjectArray2) + " from slot: " + slotMoInternal2);
                for (int i = 0; i < managedObjectArray2.length; ++i) {
                    ((SwAllocationMo)managedObjectArray2[i]).actionAddSlot((ManagedObject)slotMoInternal, control.getCoordinator());
                    this.debugTrace(72, "reconfigureSwAllocations()", "SWA: " + managedObjectArray2[i] + " added to slot: " + slotMoInternal);
                }
                control.getTerminator().commit();
            }
            catch (Exception exception) {
                UpgradeTrace.error(this.getClass(), (String)"reconfigureSwAllocations()", (String)("Running on a standalone CV. Failed to move SwAllocation from existing PIU configuration: " + slotMoInternal2 + " to new slot location : " + slotMoInternal + ", due to: " + exception));
                if (control != null) {
                    try {
                        control.getTerminator().rollback();
                    }
                    catch (InactiveTransactionException inactiveTransactionException) {
                        this.debugTrace(72, "reconfigureSwAllocations()", "Caught InactiveTransactionException at rollback, ignore");
                    }
                }
                throw exception;
            }
        }
        this.debugTrace(72, "reconfigureSwAllocations()", "The slot where the HW is located already have SWAs configured, slot: " + slotMoInternal + ", SWAs: " + Lib.toString((ManagedObject[])managedObjectArray));
    }

    private boolean isRunningOnAStandAloneCV() throws MoAccessException {
        MO_HandlerFactoryAccess mO_HandlerFactoryAccess = (MO_HandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccess.class);
        ConfigurationVersionMO_HandlerAccess configurationVersionMO_HandlerAccess = mO_HandlerFactoryAccess.getConfigurationVersionMO_HandlerAccess();
        this.debugTrace(72, "isRunningOnAStandAloneCV()", "returns: " + configurationVersionMO_HandlerAccess.isRunningOnAStandAloneCV());
        return configurationVersionMO_HandlerAccess.isRunningOnAStandAloneCV();
    }

    public static synchronized AutoCreateMos instance() {
        if (instance == null) {
            instance = new AutoCreateMos();
        }
        return instance;
    }

    private AutoCreateMos() {
    }
}

