/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement.plugandplay;

import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.equipment.JvmMoAccess;
import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.equipment.SlotMoInternal;
import se.ericsson.cello.equipment.eqaccess.JavaHeapAccess;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class JavaHeapPnpHelper {
    private static final String KILO_BYTE_SMALL = "k";
    private static final String KILO_BYTE_CAPS = "K";
    private static final String MEGA_BYTE_SMALL = "m";
    private static final String MEGA_BYTE_CAPS = "M";
    private static final String GIGA_BYTE_SMALL = "g";
    private static final String GIGA_BYTE_CAPS = "G";
    public static final int WRONG_FORMAT = -1;
    public static final int OPTION_UNDEFINED = -2;
    public static final int KILO_BYTE = 1024;

    protected JavaHeapPnpHelper() {
    }

    protected boolean setJavaheap(PiuTypeAccess piuTypeAccess, SlotMoInternal slotMoInternal, PlugInUnitMoInternal plugInUnitMoInternal) throws MoAccessException {
        boolean bl = false;
        JavaHeapAccess javaHeapAccess = (JavaHeapAccess)ServiceLocatorFacade.getRepository().getService(JavaHeapAccess.class);
        Integer n = null;
        n = javaHeapAccess.selectJavaHeap((ManagedObject)((PiuTypeMoSU_Access)piuTypeAccess), (SlotMoSU_Access)slotMoInternal);
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"setJavaheap(PiuTypeAccess piuType, SlotMoInternal slot)", (String)("The Java heap size of piuType " + piuTypeAccess + " provided by SU interface is : " + n));
        long l = this.getJavaHeapSizeInBytes();
        if (n != null) {
            this.setJavaHeapSize(n);
            if (l != -2L) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"setJavaheap(PiuTypeAccess piuType, SlotMoInternal slot)", (String)("Current Java heap size  : " + l / 1024L + "KB"));
                if ((long)(n * 1024) < l) {
                    if (plugInUnitMoInternal != null) {
                        ManagedObject managedObject = plugInUnitMoInternal.getPiuType(null);
                        UpgradeTrace.warning(this.getClass(), (String)"setJavaheap(PiuTypeAccess piuType, SlotMoInternal slot)", (String)("The Java heap size has been degraded for piuType " + managedObject.getNamingAttributeValue() + " with value " + l / 1024L + "KB to " + n + "KB for new piuType " + piuTypeAccess.getNamingAttributeValue()));
                    } else {
                        UpgradeTrace.warning(this.getClass(), (String)"setJavaheap(PiuTypeAccess piuType, SlotMoInternal slot)", (String)("The Java heap size has been degraded from  " + l / 1024L + "KB to " + n + "KB for new piuType " + piuTypeAccess.getNamingAttributeValue()));
                    }
                }
            }
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setJavaheap(PiuTypeAccess piuType, SlotMoInternal slot)", (String)("The Java heap size has been changed to  : " + n + "KB"));
            if ((long)(n * 1024) != l) {
                bl = true;
            }
        }
        return bl;
    }

    private long getJavaHeapSizeInBytes() {
        String string = null;
        String string2 = null;
        String string3 = "-Xms";
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoAccess jvmMoAccess = (JvmMoAccess)((SingletonMoFactory)moFactory).getMo();
            String string4 = jvmMoAccess.getOptions(null);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.startsWith(string3)) continue;
                if (string2.endsWith(KILO_BYTE_SMALL) || string2.endsWith(KILO_BYTE_CAPS)) {
                    string = string2.substring(string3.length(), string2.length() - 1);
                    long l = new Long(string);
                    return l * 1024L;
                }
                if (string2.endsWith(MEGA_BYTE_SMALL) || string2.endsWith(MEGA_BYTE_CAPS)) {
                    string = string2.substring(string3.length(), string2.length() - 1);
                    long l = new Long(string);
                    return l * 1024L * 1024L;
                }
                if (string2.endsWith(GIGA_BYTE_SMALL) || string2.endsWith(GIGA_BYTE_CAPS)) {
                    string = string2.substring(string3.length(), string2.length() - 1);
                    long l = new Long(string);
                    return l * 1024L * 1024L * 1024L;
                }
                string = string2.substring(string3.length(), string2.length());
                return new Long(string);
            }
            return -2L;
        }
        catch (NumberFormatException numberFormatException) {
            UpgradeTrace.log1(this.getClass(), (String)"getJavaHeapSizeInBytes()", (String)("\n\tNumberFormatException caught when trying to get Java Heapsize in attribute 'options' in the Jvm MO (returns -1)\n\ttheJavaHeapSizeString: " + string));
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"getJavaHeapSizeInBytes()", (String)"Throwable caught when trying to get Java Heapsize in attribute 'options' in the Jvm MO.", (Throwable)throwable);
        }
        return -2L;
    }

    private void setJavaHeapSize(Integer n) {
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"setJavaHeapSize(Integer aJavaHeapSize)", (String)("aJavaHeapSize: " + n));
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
            coordinator = control.getCoordinator();
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoAccess jvmMoAccess = (JvmMoAccess)((SingletonMoFactory)moFactory).getMo();
            String string = jvmMoAccess.getOptions(coordinator);
            Vector<String> vector = new Vector<String>(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = null;
            boolean bl = false;
            if (n != -1 && n != -2) {
                vector.addElement("-Xms" + n + KILO_BYTE_SMALL);
                bl = true;
            } else if (n == -1) {
                UpgradeTrace.warning(this.getClass(), (String)"setJavaHeapSize(Integer aJavaHeapSize)", (String)("Problem while getting Java Heap Size\n\taJavaHeapSize: " + n));
            }
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.startsWith("-Xms")) {
                    vector.addElement(string2);
                    continue;
                }
                if (bl || n == -2) continue;
                vector.addElement(string2);
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            jvmMoAccess.setAdmOptions((String[])objectArray, coordinator);
            control.getTerminator().commit();
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"setJavaHeapSize(Integer aJavaHeapSize)", (String)("Exception caught when trying to set Java Heapsize in attribute 'admOptions' in the Jvm MO.\n\tRequested Java Heapsize: " + n), (Throwable)exception);
            this.rollbackTransactionIfNeeded(control);
        }
    }

    private void rollbackTransactionIfNeeded(Control control) {
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"rollbackTransactionIfNeeded(Control aControl)", (String)("aControl: " + control));
        try {
            if (control != null && control.getCoordinator().getStatus() == Status.ACTIVE) {
                control.getTerminator().rollback();
            }
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"rollbackTransactionIfNeeded(Control aControl)", (String)"Rollback failed even though the transaction was active.", (Throwable)exception);
        }
    }
}

