/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.util;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.imrutility.imr.RepositoryHelper;
import org.jacorb.imrutility.imr.util.MulticastClient;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

public class IMRLocator {
    private final int udpPort;
    private final List iors;
    private final List imrs = new ArrayList();
    private final ORB orb;
    private final Logger logger;
    private final Configuration configuration;
    private final int udpTimeout;

    public IMRLocator(ORB orb_) {
        this.orb = orb_;
        this.configuration = this.orb.getConfiguration();
        this.logger = this.configuration.getNamedLogger("jacorb.imr.locator");
        this.udpPort = this.configuration.getAttributeAsInteger("jacorb.imr.udp_port", 0);
        this.udpTimeout = this.configuration.getAttributeAsInteger("jacorb.imr.udp.timeout", 3000);
        this.iors = this.configuration.getAttributeList("jacorb.imr.other_imrs");
    }

    public static void main(String[] args) {
        IMRLocator locator = null;
        Properties props = new Properties();
        props.put("jacorb.use_imr", "off");
        ORB mainorb = (ORB)org.omg.CORBA.ORB.init(args, props);
        if (args.length > 0) {
            if (args[0].equals("-h") || args[0].equals("--help")) {
                IMRLocator.usage();
            } else if (args.length == 2) {
                try {
                    Integer.parseInt(args[1]);
                    mainorb.getConfiguration().setAttribute("jacorb.imr.udp_port", args[1]);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("The UDP Port " + args[1] + " is not valid \n");
                    IMRLocator.usage();
                }
            }
        }
        try {
            locator = new IMRLocator(mainorb);
            locator.findIMRs();
            if (locator.getIMRs().size() > 0) {
                locator.printIMRs();
            } else {
                System.out.println("No IMRs found");
            }
        }
        catch (Exception ie) {
            System.err.println("Failed to find IMRs\n");
            ie.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void findIMRs() throws SocketException, UnknownHostException, IOException {
        this.logger.debug("trying to locate ImRs");
        this.imrs.clear();
        if (this.iors.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("adding configured ImRs: " + this.iors);
            }
            for (int i2 = 0; i2 < this.iors.size(); ++i2) {
                String iorRef = (String)this.iors.get(i2);
                if (!iorRef.startsWith("IOR")) {
                    this.imrs.add(this.orb.string_to_object(ObjectUtil.readURL(iorRef)));
                    continue;
                }
                this.imrs.add(this.orb.string_to_object(iorRef));
            }
        }
        if (this.udpPort != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("trying to locate ImR via UDP port: " + this.udpPort);
            }
            MulticastClient mcClient = new MulticastClient(this.configuration, this.udpPort);
            try {
                byte[] inputPacket;
                CDROutputStream clientRequest = new CDROutputStream(this.orb);
                try {
                    clientRequest.beginEncapsulatedArray();
                    clientRequest.write_string("ImplementationRepository");
                    inputPacket = clientRequest.getBufferCopy();
                }
                finally {
                    clientRequest.close();
                }
                mcClient.multicastSend(inputPacket, this.udpTimeout);
                byte[][] returnedData = mcClient.getReturnedData();
                if (returnedData != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("located " + returnedData.length + " ImRs via UDP");
                    }
                    for (int i3 = 0; i3 < returnedData.length; ++i3) {
                        byte[] imrData = returnedData[i3];
                        CDRInputStream serverResponse = new CDRInputStream(this.orb, imrData);
                        try {
                            serverResponse.openEncapsulatedArray();
                            serverResponse.read_string();
                            Repository imr = RepositoryHelper.read(serverResponse);
                            this.imrs.add(imr);
                            if (!this.logger.isDebugEnabled()) continue;
                            this.logger.debug("adding ImR: " + imr);
                            continue;
                        }
                        finally {
                            serverResponse.close();
                        }
                    }
                } else {
                    this.logger.debug("No Response via UDP within " + this.udpTimeout);
                }
            }
            finally {
                mcClient.close();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found imrs: " + this.imrs);
        }
    }

    public synchronized List getIMRs() {
        return this.imrs;
    }

    private void printIMRs() {
        Iterator iter = this.imrs.iterator();
        System.out.println("Found " + this.imrs.size() + " IMRs on:");
        while (iter.hasNext()) {
            try {
                Object obj = (Object)iter.next();
                Repository rep = RepositoryHelper.narrow(obj);
                ParsedIOR imrIOR = ((Delegate)((ObjectImpl)((java.lang.Object)rep))._get_delegate()).getParsedIOR();
                System.out.println("Running at address - " + imrIOR.getEffectiveProfile().toString() + "\n");
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.error("Exception getting host name for ImR", ex);
            }
        }
    }

    private static void usage() {
        System.out.println(" Usage : To locate any ImRs running the UDP port number must be");
        System.out.println("         provided either using the command line option below or");
        System.out.println("         setting the jacorb.imr.udp_port property              ");
        System.out.println("                                                               ");
        System.out.println("[ -u | --udp_port ] <port number>: The port number on which the");
        System.out.println("                                   MultiCast server for the ImR");
        System.out.println("                                   is running                  ");
        System.out.println("---------------------------------------------------------------");
        System.out.println("[ -h | --help ]                    displays this help          ");
        System.out.println("---------------------------------------------------------------");
        System.exit(0);
    }
}

