/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.ft;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.ft.IOGRValidator;
import org.jacorb.orb.iiop.IIOPFactories;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class DefaultIOGRValidator
implements IOGRValidator,
Configurable {
    private IIOPFactories iiopFactories;
    private Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.iiopFactories = new IIOPFactories();
        this.iiopFactories.configure(configuration);
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.ft.iogr_validator");
    }

    public boolean isIOGR(IOR ior) {
        if (ior == null) {
            throw new BAD_PARAM("IOR is null");
        }
        if (ior.profiles == null) {
            throw new BAD_PARAM("IOR.profiles is null");
        }
        if (ior.profiles.length == 0) {
            return false;
        }
        ProfileVisitor validator = new ProfileVisitor();
        block4: for (int x = 0; x < ior.profiles.length; ++x) {
            TaggedProfile taggedProfile = ior.profiles[x];
            boolean shouldContinue = validator.validateProfileTag(taggedProfile.tag);
            if (!shouldContinue) {
                return false;
            }
            shouldContinue = validator.beginProfile(taggedProfile);
            if (!shouldContinue) {
                return false;
            }
            switch (taggedProfile.tag) {
                case 0: {
                    TaggedComponentSeqHolder tcs = new TaggedComponentSeqHolder();
                    this.iiopFactories.demarshal_profile(new TaggedProfileHolder(ior.profiles[x]), tcs);
                    for (int y = 0; y < tcs.value.length; ++y) {
                        TaggedComponent tc = tcs.value[y];
                        validator.validateTaggedComponent(tc);
                    }
                    continue block4;
                }
                case 1: {
                    validator.validateTaggedComponentList(new TaggedComponentList(taggedProfile.profile_data));
                    continue block4;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block4;
                }
            }
        }
        return validator.endProfiles();
    }

    static {
        $assertionsDisabled = !DefaultIOGRValidator.class.desiredAssertionStatus();
    }

    private class ProfileVisitor {
        private TaggedProfile currentProfile;
        private boolean isTagGroupSet;
        private boolean isPrimarySet;

        private ProfileVisitor() {
        }

        boolean validateProfileTag(int tag) {
            return tag == 0 || tag == 1;
        }

        boolean beginProfile(TaggedProfile profile) {
            if (this.currentProfile != null && !this.isTagGroupSet) {
                return false;
            }
            this.currentProfile = profile;
            this.isTagGroupSet = false;
            return true;
        }

        void validateTaggedComponent(TaggedComponent tc) {
            if (tc.tag == 27) {
                if (this.isTagGroupSet) {
                    throw new BAD_PARAM("TAG_GROUP component must be specified exactly once per profile");
                }
                this.isTagGroupSet = true;
            } else if (tc.tag == 28) {
                if (this.isPrimarySet) {
                    throw new BAD_PARAM("TAG_FT_PRIMARY component may be specified once only per IOGR");
                }
                this.isPrimarySet = true;
            }
        }

        boolean endProfiles() {
            if (this.currentProfile == null) {
                return false;
            }
            return this.isTagGroupSet;
        }

        public void validateTaggedComponentList(TaggedComponentList list) {
            DefaultIOGRValidator.this.logger.warn("Found TAG_MULTIPLE_COMPONENTS profile within possible IOGR. Ignoring it.");
        }
    }
}

