/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.portable.InputStream;

public class IIOPAddress
extends ProtocolAddressBase {
    private String source_name = null;
    private InetAddress host = null;
    private int port = -1;
    private boolean unresolvable = false;
    private boolean dnsEnabled = false;
    private boolean hideZoneID = true;
    private Logger logger;
    private boolean doEagerResolve;
    private boolean forceDNSLookup = true;

    public IIOPAddress() {
    }

    public IIOPAddress(String hoststr, int port) {
        this();
        this.source_name = hoststr;
        this.init_port(port);
    }

    private void init_port(int port) {
        this.port = port < 0 ? port + 65536 : port;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.address");
        this.dnsEnabled = configuration.getAttributeAsBoolean("jacorb.dns.enable", false);
        this.hideZoneID = configuration.getAttributeAsBoolean("jacorb.ipv6.hide_zoneid", true);
        this.doEagerResolve = configuration.getAttributeAsBoolean("jacorb.dns.eager_resolve", true);
        if (this.doEagerResolve) {
            this.init_host();
        }
        this.forceDNSLookup = configuration.getAttributeAsBoolean("jacorb.dns.force_lookup", true);
    }

    private void init_host() {
        InetAddress localhost = null;
        boolean hasZoneId = false;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            try {
                localhost = InetAddress.getByName(null);
            }
            catch (UnknownHostException ex2) {
                // empty catch block
            }
        }
        if (this.source_name == null || this.source_name.length() == 0) {
            this.host = localhost;
        } else {
            int zone;
            int slash = this.source_name.indexOf(47);
            if (slash > 0) {
                this.source_name = this.source_name.substring(0, slash);
            }
            if ((zone = this.source_name.indexOf(37)) != -1) {
                hasZoneId = true;
            }
            if (!hasZoneId) {
                try {
                    this.host = InetAddress.getByName(this.source_name);
                }
                catch (UnknownHostException ex) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("init_host, " + this.source_name + " unresolvable");
                    }
                    this.unresolvable = true;
                    try {
                        this.host = InetAddress.getByName(null);
                    }
                    catch (UnknownHostException ex2) {}
                }
            } else {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("init_host, " + this.source_name + " is local-link address");
                }
                this.unresolvable = true;
                this.host = null;
            }
        }
    }

    public static IIOPAddress read(InputStream in) {
        String host = in.read_string();
        short port = in.read_ushort();
        return new IIOPAddress(host, port);
    }

    public String getIP() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.host.getHostAddress();
    }

    public String getHostname() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        if (!this.dnsEnabled) {
            return this.host.getHostAddress();
        }
        return this.forceDNSLookup ? this.host.getCanonicalHostName() : this.host.getHostName();
    }

    public void setHostname(String hn) {
        this.host = null;
        this.source_name = hn;
        if (this.doEagerResolve) {
            this.init_host();
        }
    }

    public InetAddress getConfiguredHost() {
        if (this.source_name == null || this.source_name.length() == 0) {
            return null;
        }
        if (this.host == null) {
            this.init_host();
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p2) {
        this.port = p2;
    }

    public boolean equals(Object other) {
        if (other instanceof IIOPAddress) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getHostname() + ":" + this.port;
    }

    public boolean fromString(String s2) {
        if (s2.charAt(0) == '[') {
            return this.fromStringIPv6(s2);
        }
        return this.fromStringIPv4(s2);
    }

    private boolean fromStringIPv6(String s2) {
        int end_bracket = s2.indexOf(93);
        if (end_bracket < 0) {
            return false;
        }
        this.source_name = s2.substring(1, end_bracket);
        int port_colon = s2.indexOf(58, end_bracket);
        if (port_colon < 0) {
            return false;
        }
        int _port = Integer.parseInt(s2.substring(port_colon + 1));
        this.init_host();
        this.init_port(_port);
        return true;
    }

    private boolean fromStringIPv4(String s2) {
        int colon = s2.indexOf(58);
        if (colon == -1) {
            return false;
        }
        this.source_name = colon > 0 ? s2.substring(0, colon) : "";
        int _port = 0;
        if (colon < s2.length() - 1) {
            _port = Integer.parseInt(s2.substring(colon + 1));
        }
        this.init_host();
        this.init_port(_port);
        return true;
    }

    public void write(CDROutputStream cdr) {
        int zoneIndex;
        String hostname = this.getHostname();
        if (this.hideZoneID && (zoneIndex = hostname.indexOf(37)) != -1) {
            hostname = hostname.substring(0, zoneIndex);
        }
        cdr.write_string(hostname);
        cdr.write_ushort((short)this.port);
    }

    public String getOriginalHost() {
        if (this.source_name == null) {
            if (!this.dnsEnabled) {
                return this.getIP();
            }
            return this.getHostname() + " / " + this.getIP();
        }
        return this.source_name;
    }

    void replaceFrom(IIOPAddress other) {
        if (other.source_name != null) {
            this.setHostname(other.source_name);
        }
        if (other.port != -1) {
            this.setPort(other.port);
        }
    }
}

