/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.licensing.LicensingLogger;
import se.ericsson.cello.licensing.model.DefaultTableEntry;
import se.ericsson.cello.licensing.model.LicenseAttributeRecord;
import se.ericsson.cello.licensing.model.LicenseType;
import se.ericsson.cello.licensing.model.LicensingNameValue;
import se.ericsson.cello.licensing.model.RecordCollector;
import se.ericsson.cello.licensing.model.TableEntry;

public class LicensingTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String MO = "MO";
    private static final String CAPACITY = "Capacity";
    private static final String FEATURE = "Feature";
    private RecordCollector myCollector;
    private String[] licenseAttributes;
    private String name;

    public LicensingTableModel(NodeServices nodeServices, LicenseType type) {
        LicensingLogger.logger().info("LicensingTableModel: Creating model for " + (Object)((Object)type));
        this.myCollector = new RecordCollector(nodeServices, type);
        if (type == LicenseType.CAPACITY) {
            this.name = CAPACITY;
            this.licenseAttributes = new String[]{"keyId", "licenseState", "licenseCapacity", "capacityUnit"};
        } else {
            this.name = FEATURE;
            this.licenseAttributes = new String[]{"keyId", "licenseState", "featureState", "serviceState"};
        }
        this.createColumnIdentifiers();
        this.populateRows();
    }

    private void createColumnIdentifiers() {
        ArrayList<String> header = new ArrayList<String>();
        header.add(this.name);
        for (int i = 0; i < this.licenseAttributes.length; ++i) {
            header.add(this.licenseAttributes[i]);
        }
        header.add(MO);
        super.setColumnIdentifiers(header.toArray(new String[0]));
    }

    private void populateRows() {
        LicensingLogger.logger().fine("LicensingTableModel: Collecting license records");
        List<LicenseAttributeRecord> records = this.myCollector.collectLicenseRecords();
        Collections.sort(records);
        LicensingLogger.logger().fine("LicensingTableModel: Collected " + records.size() + " records");
        for (LicenseAttributeRecord record : records) {
            Vector<TableEntry> rowData = new Vector<TableEntry>();
            rowData.add(new DefaultTableEntry(record.getName()));
            for (int i = 0; i < this.licenseAttributes.length; ++i) {
                LicensingNameValue nameValue = record.getAttribute(this.licenseAttributes[i]);
                if (nameValue == null) {
                    rowData.add(new DefaultTableEntry(""));
                    continue;
                }
                rowData.add(nameValue);
            }
            rowData.add(new DefaultTableEntry(record.getLdn()));
            super.addRow(rowData);
        }
    }
}

