/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogImpl;
import se.ericsson.cello.emt.utils.launchhandler.LaunchHandler;
import se.ericsson.cello.licensing.LicensingLogger;
import se.ericsson.cello.licensing.view.ViewData;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperToolListener
implements ActionListener {
    private Map<String, String> hyperTools;
    private LauncherInterface launcher;
    private Properties properties;
    private Launchable parent;
    private ViewData data;

    public HyperToolListener(LauncherInterface launcher, Launchable parent, Properties properties, ViewData data, Map<String, String> hyperTools) {
        this.launcher = launcher;
        this.properties = properties;
        this.parent = parent;
        this.data = data;
        this.hyperTools = hyperTools;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LicensingLogger.logger().fine("Command is " + e.getActionCommand());
        String configToLaunch = this.hyperTools.get(e.getActionCommand());
        if (configToLaunch != null) {
            this.launchTool(e.getActionCommand(), configToLaunch);
        }
    }

    private void launchTool(final String name, final String config) {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    HyperToolListener.this.launchTool(name, config);
                }
            };
            new Thread(runner).start();
        } else {
            String host = this.properties.getProperty("HOST", "Host is not defined");
            LicensingLogger.logger().info("Launching " + name + " with config " + config);
            if (null == this.launcher) {
                LicensingLogger.logger().warning("No EM Launcher available. Not able to launch " + name);
                MessageDialogImpl msgDia = new MessageDialogImpl("Failed starting " + name, "No EM Launcher available.", false, null);
                msgDia.setVisible(true);
            } else {
                for (String ldn : this.data.getSelectedLdns()) {
                    LicensingLogger.logger().info("Launching " + name + " with LDN " + ldn);
                    Properties props = new Properties();
                    props.setProperty("LDNs", ldn);
                    LaunchHandler.launchTool((LauncherInterface)this.launcher, (String)config, (String)host, (Properties)props, (Launchable)this.parent);
                }
            }
        }
    }
}

