/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em;

import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.AbstractDataPage;

public class ImageHelper {
    private static ImageHelper instance = new ImageHelper();
    public static final transient Icon HELP_ICON;
    public static final transient Icon CORRECT_ICON;
    public static final transient Icon INACTIVE_ICON;
    public static final transient Icon INCORRECT_ICON;
    public static final transient Icon WARNING_ICON;

    private ImageHelper() {
    }

    public static URL getImage(String name) throws ResourceException {
        URL imageUrl = instance.getClass().getResource("resources/images/" + name);
        if (imageUrl == null) {
            ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
            throw new ResourceException(irbsBundle.getString("variousImage") + ", \"" + name + "\", " + irbsBundle.getString("variousNotFound"));
        }
        return imageUrl;
    }

    static {
        String iconHelp = "icon_lte_help.gif";
        ImageIcon tmpIcon = null;
        try {
            tmpIcon = new ImageIcon(ImageHelper.getImage("icon_lte_help.gif"));
        }
        catch (ResourceException re) {
            IrbsLogger.logError(AbstractDataPage.class, "Could not resolve: " + IrbsHelper.doubleQuote("icon_lte_help.gif"));
            tmpIcon = new ImageIcon();
        }
        HELP_ICON = tmpIcon;
        String iconLedCorrect = "icon_led_correct.gif";
        try {
            tmpIcon = new ImageIcon(ImageHelper.getImage("icon_led_correct.gif"));
        }
        catch (ResourceException re) {
            IrbsLogger.logError(AbstractDataPage.class, "Could not resolve: " + IrbsHelper.doubleQuote("icon_led_correct.gif"));
            tmpIcon = new ImageIcon();
        }
        CORRECT_ICON = tmpIcon;
        String iconLedInActive = "icon_led_inactive.gif";
        try {
            tmpIcon = new ImageIcon(ImageHelper.getImage("icon_led_inactive.gif"));
        }
        catch (ResourceException re) {
            IrbsLogger.logError(AbstractDataPage.class, "Could not resolve: " + IrbsHelper.doubleQuote("icon_led_inactive.gif"));
            tmpIcon = new ImageIcon();
        }
        INACTIVE_ICON = tmpIcon;
        String iconLedInCorrect = "icon_led_incorrect.gif";
        try {
            tmpIcon = new ImageIcon(ImageHelper.getImage("icon_led_incorrect.gif"));
        }
        catch (ResourceException re) {
            IrbsLogger.logError(AbstractDataPage.class, "Could not resolve: " + IrbsHelper.doubleQuote("icon_led_incorrect.gif"));
            tmpIcon = new ImageIcon();
        }
        INCORRECT_ICON = tmpIcon;
        String iconLedWarning = "icon_led_warning.gif";
        try {
            tmpIcon = new ImageIcon(ImageHelper.getImage("icon_led_warning.gif"));
        }
        catch (ResourceException re) {
            IrbsLogger.logError(AbstractDataPage.class, "Could not resolve: " + IrbsHelper.doubleQuote("icon_led_warning.gif"));
            tmpIcon = new ImageIcon();
        }
        WARNING_ICON = tmpIcon;
    }

    public static class ResourceException
    extends Exception {
        protected ResourceException(String message) {
            super(message);
        }
    }
}

