/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.component.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.util.LteColor;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;
import se.ericsson.lte.rbs.omf.em.validator.Validator;
import se.ericsson.lte.rbs.omf.em.validator.ValidityInformer;

public class ValidatedFieldBrowsePanel
extends JPanel
implements ActionListener,
KeyListener,
ValidityInformer {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private static final Border invalidBorder = new EtchedBorder(LteColor.INVALID_FG, LteColor.INVALID_BG);
    private static final Border correctBorder = new EtchedBorder(LteColor.CORRECT_FG, LteColor.CORRECT_BG);
    private static final Border defaultBorder = new EtchedBorder(Color.LIGHT_GRAY, Color.LIGHT_GRAY);
    private final transient List<ValidListener> validListeners = new ArrayList<ValidListener>();
    private static transient File currentFile = new File(System.getProperty("user.home", "C:\\"));
    private final transient LteButton browseButton;
    private final transient JTextField textField;
    private final transient Validator validator;
    private final String fileFilterDescription;
    private final String fileExtension;

    public ValidatedFieldBrowsePanel(Validator inputValidator, String inputFileExtension, String inputFileFilterDescription) throws InputDataException {
        super(new GridBagLayout());
        this.fileFilterDescription = inputFileFilterDescription;
        this.fileExtension = inputFileExtension.toLowerCase(Locale.getDefault());
        IrbsLogger.logEntering(this.getClass());
        if (inputValidator == null) {
            throw new InputDataException("The Validator must NOT be null.");
        }
        this.validator = inputValidator;
        ToolTipManager.sharedInstance().setInitialDelay(300);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        this.textField = new JTextField(10);
        this.textField.setToolTipText(inputValidator.getHint());
        this.textField.addActionListener(this);
        this.textField.addKeyListener(this);
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.textField, constraints);
        String browseButtonText = irbsBundle.getString("variousBrowseButton");
        this.browseButton = new LteButton(browseButtonText);
        this.browseButton.setMnemonic(browseButtonText.charAt(1));
        this.browseButton.addActionListener(this.createBrowseButtonListener());
        constraints.insets = new Insets(5, 15, 5, 5);
        constraints.weightx = 0.0;
        this.add((Component)this.browseButton, constraints);
        this.check(false);
        IrbsLogger.logExiting(this.getClass());
    }

    public LteButton getBrowseButton() {
        return this.browseButton;
    }

    private ActionListener createBrowseButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                File tmpFile;
                String currentlyEnteredText = ValidatedFieldBrowsePanel.this.getText();
                if (!currentlyEnteredText.equalsIgnoreCase("") && (tmpFile = new File(currentlyEnteredText)).exists()) {
                    currentFile = tmpFile;
                }
                JFileChooser fileChooser = new JFileChooser(currentFile);
                fileChooser.setFileFilter(ValidatedFieldBrowsePanel.this.createBrowseButtonFilter());
                int returnVal = fileChooser.showOpenDialog(ValidatedFieldBrowsePanel.this.getParent());
                if (returnVal == 0) {
                    currentFile = fileChooser.getSelectedFile();
                    ValidatedFieldBrowsePanel.this.textField.setText(currentFile.getAbsolutePath());
                    ValidatedFieldBrowsePanel.this.check(true);
                }
            }
        };
    }

    private FileFilter createBrowseButtonFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                boolean fileFound = file.getAbsolutePath().toLowerCase(Locale.getDefault()).endsWith(ValidatedFieldBrowsePanel.this.fileExtension);
                if (ValidatedFieldBrowsePanel.this.fileExtension.equals("*.*")) {
                    fileFound = true;
                }
                return fileFound;
            }

            public String getDescription() {
                return ValidatedFieldBrowsePanel.this.fileFilterDescription;
            }
        };
    }

    public final JTextField getTextField() {
        return this.textField;
    }

    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.check(false);
    }

    public final String getText() {
        return this.textField.getText();
    }

    public final void setText(String text) {
        IrbsLogger.logEntering(this.getClass());
        this.textField.setText(text);
        this.check(true);
        IrbsLogger.logExiting(this.getClass());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        IrbsLogger.logEntering(this.getClass());
        this.check(true);
        IrbsLogger.logExiting(this.getClass());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.check(true);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public boolean validValue() {
        boolean localCheck = false;
        if (this.validator.allowEmpty() && this.textField.getText().length() < 1) {
            localCheck = true;
        } else if (this.validator.valid(this.textField.getText())) {
            localCheck = true;
        }
        return localCheck || !this.textField.isEnabled();
    }

    public void addValidityListener(ValidListener validListener) {
        IrbsLogger.logEntering(this.getClass());
        if (validListener != null) {
            this.validListeners.add(validListener);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    public void removeValidityListener(ValidListener validListener) {
        IrbsLogger.logEntering(this.getClass());
        if (validListener != null) {
            this.validListeners.remove(validListener);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void check(boolean inform) {
        if (!this.textField.isEnabled() || this.validator == null) {
            this.textField.setBorder(defaultBorder);
        } else if (this.validator.valid(this.textField.getText()) && this.textField.getText().length() > 0) {
            this.textField.setBorder(correctBorder);
        } else if (this.validator.valid(this.textField.getText())) {
            this.textField.setBorder(defaultBorder);
        } else {
            this.textField.setBorder(invalidBorder);
        }
        this.informListeners(inform);
    }

    private void informListeners(boolean inform) {
        if (inform) {
            for (ValidListener validListener : this.validListeners) {
                try {
                    if (validListener == null) continue;
                    validListener.validityChanged(this, this.validator);
                }
                catch (Exception e) {
                    IrbsLogger.logError(this.getClass(), "Failed to inform valid listener", e);
                }
            }
        }
    }
}

