/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

public class IrbsQueue
extends EventQueue {
    private final String name;
    private final List<KeyListener> keyListeners = new ArrayList<KeyListener>();

    protected IrbsQueue(String inputName) {
        this.name = inputName;
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalKeyListener(KeyListener keyListener) {
        List<KeyListener> list = this.keyListeners;
        synchronized (list) {
            this.keyListeners.remove(keyListener);
            this.keyListeners.add(keyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGlobalKeyListener(KeyListener keyListener) {
        List<KeyListener> list = this.keyListeners;
        synchronized (list) {
            this.keyListeners.remove(keyListener);
        }
    }

    protected void dispatchEvent(AWTEvent event) {
        try {
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                for (int i = 0; i < this.keyListeners.size(); ++i) {
                    KeyListener keyListener = this.keyListeners.get(i);
                    if (keyEvent.getID() == 401) {
                        keyListener.keyPressed(keyEvent);
                        continue;
                    }
                    if (keyEvent.getID() == 402) {
                        keyListener.keyReleased(keyEvent);
                        continue;
                    }
                    if (keyEvent.getID() != 400) continue;
                    keyListener.keyTyped(keyEvent);
                }
            }
            super.dispatchEvent(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.name;
    }
}

