/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import se.ericsson.lte.rbs.omf.em.irbs.StatusBar;
import se.ericsson.lte.rbs.omf.em.util.LteColor;

public class LabelStatusBar
extends JLabel
implements StatusBar {
    private long blinkingInterval = 1000L;
    private boolean continueBlinking = false;
    private final transient Timer statusTimer;
    private Color currentStaticColor;
    private final Color originalStatusColor;
    private String currentStaticStatusMessage = "";

    public LabelStatusBar() {
        this.setBorder(new BevelBorder(1));
        this.setText("  ");
        this.currentStaticColor = this.originalStatusColor = this.getForeground();
        this.statusTimer = new Timer(10000, new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                LabelStatusBar.this.clearStatusMessage();
            }
        });
        this.statusTimer.setRepeats(false);
    }

    public Component getComponent() {
        return this;
    }

    public void setProgressValue(int value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LabelStatusBar labelStatusBar = this;
        synchronized (labelStatusBar) {
            while (this.continueBlinking) {
                try {
                    this.wait(this.blinkingInterval);
                    if (!this.continueBlinking) break;
                    this.setForeground(Color.WHITE);
                    this.wait(this.blinkingInterval);
                    if (!this.continueBlinking) break;
                    this.setForeground(this.originalStatusColor);
                }
                catch (Exception exception) {}
            }
            this.setForeground(this.originalStatusColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStatusMessage() {
        String string = "  ";
        synchronized ("  ") {
            this.setForeground(this.currentStaticColor);
            this.setText("  " + this.currentStaticStatusMessage);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStaticStatusMessage() {
        String string = "  ";
        synchronized ("  ") {
            this.currentStaticColor = this.originalStatusColor;
            this.setForeground(this.currentStaticColor);
            this.currentStaticStatusMessage = "";
            this.setText("  " + this.currentStaticStatusMessage);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentMessage() {
        String string = "  ";
        synchronized ("  ") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentStaticMessage() {
        String string = "  ";
        synchronized ("  ") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentStaticStatusMessage;
        }
    }

    public void setIndeterminate(boolean indeterminate) {
        if (indeterminate) {
            this.startBlinking(1000L);
        } else {
            this.stopBlinking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusMessage(String message, int messageType) {
        String string = "  ";
        synchronized ("  ") {
            switch (messageType) {
                case 1: {
                    this.setForeground(LteColor.ERROR_COLOR);
                    break;
                }
                case 0: {
                    this.setForeground(LteColor.WARNING_COLOR);
                    break;
                }
                default: {
                    this.setForeground(this.originalStatusColor);
                }
            }
            this.setText("  " + message);
            this.statusTimer.restart();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStaticStatusMessage(String message, int messageType) {
        String string = "  ";
        synchronized ("  ") {
            switch (messageType) {
                case 1: {
                    this.currentStaticColor = LteColor.ERROR_COLOR;
                    break;
                }
                case 0: {
                    this.currentStaticColor = LteColor.WARNING_COLOR;
                    break;
                }
                default: {
                    this.currentStaticColor = this.originalStatusColor;
                }
            }
            this.setForeground(this.currentStaticColor);
            this.currentStaticStatusMessage = message;
            this.statusTimer.stop();
            this.setText("  " + this.currentStaticStatusMessage);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBlinking(long inputBlinkingInterval) {
        LabelStatusBar labelStatusBar = this;
        synchronized (labelStatusBar) {
            this.blinkingInterval = inputBlinkingInterval;
            this.continueBlinking = true;
            Thread blinkingThread = new Thread((Runnable)this, "Status Blinking Thread");
            blinkingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBlinking() {
        LabelStatusBar labelStatusBar = this;
        synchronized (labelStatusBar) {
            this.continueBlinking = false;
        }
    }
}

