/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import se.ericsson.lte.rbs.omf.em.irbs.StatusBar;
import se.ericsson.lte.rbs.omf.em.util.LteColor;

public class ProgressStatusBar
extends JProgressBar
implements StatusBar {
    private long blinkingInterval = 1000L;
    private boolean continueBlinking = false;
    private int currentValue = 0;
    private final transient Timer statusTimer;
    private String currentStaticStatusMessage = "";
    private Color currentStaticColor;
    private final Color originalStatusColor;

    public ProgressStatusBar(int minValue, int maxValue) {
        super(minValue, maxValue);
        this.setForeground(LteColor.PROGRESS_COLOR);
        this.setProgressValue(0);
        this.setStringPainted(true);
        this.setBorderPainted(true);
        this.setBorder(new BevelBorder(1));
        this.setString("  ");
        this.currentStaticColor = this.originalStatusColor = this.getBackground();
        this.statusTimer = new Timer(10000, new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ProgressStatusBar.this.clearStatusMessage();
            }
        });
        this.statusTimer.setRepeats(false);
    }

    public Component getComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStatusMessage() {
        String string = "  ";
        synchronized ("  ") {
            this.setBackground(this.currentStaticColor);
            this.setString("  " + this.currentStaticStatusMessage);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStaticStatusMessage() {
        String string = "  ";
        synchronized ("  ") {
            this.currentStaticColor = this.originalStatusColor;
            this.setBackground(this.currentStaticColor);
            this.currentStaticStatusMessage = "";
            this.setString(this.currentStaticStatusMessage);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentMessage() {
        String string = "  ";
        synchronized ("  ") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentStaticMessage() {
        String string = "  ";
        synchronized ("  ") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentStaticStatusMessage;
        }
    }

    public void setIndeterminate(boolean indeterminate) {
        if (indeterminate) {
            this.startBlinking(1000L);
        } else {
            this.stopBlinking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusMessage(String message, int messageType) {
        String string = "  ";
        synchronized ("  ") {
            switch (messageType) {
                case 1: {
                    this.setBackground(LteColor.ERROR_COLOR);
                    break;
                }
                case 0: {
                    this.setBackground(LteColor.WARNING_COLOR);
                    break;
                }
                default: {
                    this.setBackground(this.originalStatusColor);
                }
            }
            this.setString("  " + message);
            this.statusTimer.restart();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStaticStatusMessage(String message, int messageType) {
        String string = "  ";
        synchronized ("  ") {
            switch (messageType) {
                case 1: {
                    this.currentStaticColor = LteColor.ERROR_COLOR;
                    break;
                }
                case 0: {
                    this.currentStaticColor = LteColor.WARNING_COLOR;
                    break;
                }
                default: {
                    this.currentStaticColor = this.originalStatusColor;
                }
            }
            this.setBackground(this.currentStaticColor);
            this.currentStaticStatusMessage = message;
            this.statusTimer.stop();
            this.setString("  " + this.currentStaticStatusMessage);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setProgressValue(int value) {
        ProgressStatusBar progressStatusBar = this;
        synchronized (progressStatusBar) {
            this.currentValue = value;
            if (!this.continueBlinking) {
                super.setValue(this.currentValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ProgressStatusBar progressStatusBar = this;
        synchronized (progressStatusBar) {
            while (this.continueBlinking) {
                try {
                    this.wait(this.blinkingInterval);
                    if (!this.continueBlinking) break;
                    super.setValue(this.currentValue);
                    this.wait(this.blinkingInterval);
                    if (!this.continueBlinking) break;
                    super.setValue(0);
                }
                catch (Exception exception) {}
            }
            super.setValue(this.currentValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBlinking(long inputBlinkingInterval) {
        ProgressStatusBar progressStatusBar = this;
        synchronized (progressStatusBar) {
            this.blinkingInterval = inputBlinkingInterval;
            this.continueBlinking = true;
            Thread blinkingThread = new Thread((Runnable)this, "Status Blinking Thread");
            blinkingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBlinking() {
        ProgressStatusBar progressStatusBar = this;
        synchronized (progressStatusBar) {
            this.continueBlinking = false;
        }
    }
}

