/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JCheckBox;
import se.ericsson.lte.rbs.omf.em.component.panel.TitledFileBrowsePanel;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldBrowsePanel;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.RbsIpAddressHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartRbsIntegrationParameters {
    private static final String UTC_TIME_ZONE = "GMT";
    private static final String UTC_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String HIDDEN_PARAMETER = "***********";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    private static final String XML_TOP_TAG = "StartAutoIntegration";
    private static final String INDENTATION = "  ";
    private static final String VALUE_ATTR = " value=\"";
    private static final String OPENING_XML_START_TAG = "<";
    private static final String OPENING_XML_END_TAG = "</";
    private static final String CLOSING_XML_START_TAG = "/>";
    private static final String CLOSING_XML_END_TAG = ">";
    private static final String XML_SECONDARY_TAG = "TemporaryIpsecTunnel";
    private static final String NEW_LINE = "\n";
    private static final String EMPTY_STRING = "";
    private static final String DOUBLE_QUOTE_STRING = "\"";
    private static final String CABINET = "Cabinet";
    private static final String CABINET_PRODUCTION_DATE = "productionDate";
    private static final String CABINET_PRODUCT_NAME = "productName";
    private static final String CABINET_PRODUCT_NUMBER = "productNumber";
    private static final String CABINET_PRODUCT_REVISION = "productRevision";
    private static final String CABINET_SERIAL_NUMBER = "serialNumber";
    private int vLanId = -1;
    private String dhcpClientIdentifier = "";
    private String smrsUserName = "";
    private String smrsPassword = "";
    private String smrsServer = "";
    private String smrsFilePath = "";
    private String rbsIpAddress = "";
    private String subnetMask = "";
    private String networkPrefixLength = "";
    private String domainName = "";
    private String dnsServer = "";
    private String defaultRouter = "";
    private String siteBasicFile = "";
    private String siteEquipmentFile = "";
    private String licenseKeyFile = "";
    private String upgradePackage = "";
    private String integrationCode = "";
    private String activateSecurity = "true";
    private String activateIpSecurity = "true";
    private String logicalName = "";
    private String uniqueLogicalName = "";
    private final long currentTime;
    private final Map<String, String> ped = new HashMap<String, String>();
    private String productionDate = "20130101";
    private String productName = "1";
    private String productNumber = "1";
    private String productRevision = "1";
    private String serialNumber = "1";

    public StartRbsIntegrationParameters() {
        this.currentTime = System.currentTimeMillis();
    }

    public void setPublicInternetParam(String param, String value) {
        this.ped.put(param, value);
    }

    public int getVLanId() {
        return this.vLanId;
    }

    public void setVLanId(int lanId) {
        this.vLanId = lanId;
    }

    public String getDhcpClientIdentifier() {
        return this.dhcpClientIdentifier;
    }

    public void setDhcpClientIdentifier(String inputDhcpClientIdentifier) {
        this.dhcpClientIdentifier = inputDhcpClientIdentifier;
    }

    public String getSmrsUserName() {
        return this.smrsUserName;
    }

    public void setSmrsUserName(ValidatedFieldPanel smrsUserNamePanel) {
        this.smrsUserName = smrsUserNamePanel.isEnabled() ? smrsUserNamePanel.getText() : EMPTY_STRING;
    }

    public String getSmrsPassword() {
        return this.smrsPassword;
    }

    public void setSmrsPassword(ValidatedFieldPanel smrsPasswordPanel) {
        this.smrsPassword = smrsPasswordPanel.isEnabled() ? smrsPasswordPanel.getText() : EMPTY_STRING;
    }

    public String getSmrsServer() {
        return this.smrsServer;
    }

    public void setSmrsServer(ValidatedFieldPanel smrsServerPanel) {
        this.smrsServer = smrsServerPanel.isEnabled() ? smrsServerPanel.getText() : EMPTY_STRING;
    }

    public String getSmrsFilePath() {
        return this.smrsFilePath;
    }

    public void setSmrsFilePath(ValidatedFieldPanel smrsFilePathPanel) {
        this.smrsFilePath = smrsFilePathPanel.isEnabled() ? smrsFilePathPanel.getText() : EMPTY_STRING;
    }

    public String getRbsIpAddress() {
        return this.rbsIpAddress;
    }

    public void setRbsIpAddress(RbsIpAddressHolder rbsIpAddressHolder) throws UnknownHostException {
        if (rbsIpAddressHolder.getRbsIpPanel().isEnabled()) {
            this.rbsIpAddress = rbsIpAddressHolder.convertToNormalIpFormat(rbsIpAddressHolder.getRbsIpPanel().getText());
        }
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public String getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    public void setSubnetMask(ValidatedFieldPanel subnetMaskPanel) {
        this.subnetMask = subnetMaskPanel.isEnabled() ? subnetMaskPanel.getText() : EMPTY_STRING;
    }

    public void setNetworkPrefixLength(ValidatedFieldPanel networkPrefixLengthPanel) {
        this.networkPrefixLength = networkPrefixLengthPanel.isEnabled() ? networkPrefixLengthPanel.getText() : EMPTY_STRING;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(ValidatedFieldPanel domainNamePanel) {
        this.domainName = domainNamePanel.isEnabled() ? domainNamePanel.getText() : EMPTY_STRING;
    }

    public String getDnsServer() {
        return this.dnsServer;
    }

    public void setDnsServer(ValidatedFieldPanel dnsServerPanel) {
        this.dnsServer = dnsServerPanel.isEnabled() ? dnsServerPanel.getText() : EMPTY_STRING;
    }

    public String getDefaultRouter() {
        return this.defaultRouter;
    }

    public void setDefaultRouter(ValidatedFieldPanel defaultRouterPanel) {
        this.defaultRouter = defaultRouterPanel.isEnabled() ? defaultRouterPanel.getText() : EMPTY_STRING;
    }

    public String getSiteBasicFile() {
        return this.siteBasicFile;
    }

    public void setSiteBasicFile(ValidatedFieldBrowsePanel siteBasicFilePanel) {
        this.siteBasicFile = siteBasicFilePanel.isEnabled() ? siteBasicFilePanel.getText() : EMPTY_STRING;
    }

    public final void setSiteBasicFile(String inputSiteBasicFile) {
        this.siteBasicFile = inputSiteBasicFile;
    }

    public String getSiteEquipmentFile() {
        return this.siteEquipmentFile;
    }

    public void setSiteEquipmentFile(ValidatedFieldBrowsePanel siteEquipmentFilePanel) {
        this.siteEquipmentFile = siteEquipmentFilePanel.isEnabled() ? siteEquipmentFilePanel.getText() : EMPTY_STRING;
    }

    public void setSiteEquipmentFile(String inputSiteEquipmentFile) {
        this.siteEquipmentFile = inputSiteEquipmentFile;
    }

    public String getLicenseKeyFile() {
        return this.licenseKeyFile;
    }

    public void setLicenseKeyFile(TitledFileBrowsePanel licenseKeyFilePanel) {
        this.licenseKeyFile = licenseKeyFilePanel.getCheckBox().isSelected() ? "DoNoTuSeVaLuEfRoMsUmMaRy" : licenseKeyFilePanel.getFieldBrowsePanel().getText();
    }

    public final void setLicenseKeyFile(String inputLicenseKeyFile) {
        this.licenseKeyFile = inputLicenseKeyFile;
    }

    public String getUpgradePackage() {
        return this.upgradePackage;
    }

    public void setUpgradePackage(TitledFileBrowsePanel upgradePackagePanel) {
        this.upgradePackage = upgradePackagePanel.getCheckBox().isSelected() ? "DoNoTuSeVaLuEfRoMsUmMaRy" : upgradePackagePanel.getFieldBrowsePanel().getText();
    }

    public void setUpgradePackage(String inputUpgradePackage) {
        this.upgradePackage = inputUpgradePackage;
    }

    public String getUniqueLogicalName() {
        return this.uniqueLogicalName;
    }

    public void setUniqueLogicalName(String inputUniqueLogicalName) {
        this.uniqueLogicalName = inputUniqueLogicalName;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public void setLogicalName(ValidatedFieldPanel logicalNamePanel) {
        this.logicalName = logicalNamePanel.isEnabled() ? logicalNamePanel.getText() : EMPTY_STRING;
    }

    public String getActivateSecurity() {
        return this.activateSecurity;
    }

    public void setActivateSecurity(JCheckBox skipSecurityActivation) {
        this.activateSecurity = skipSecurityActivation.isSelected() ? "false" : "true";
    }

    public String getActivateIpSecurity() {
        return this.activateIpSecurity;
    }

    public void setActivateIpSecurity(JCheckBox skipIpSecurityActivation) {
        this.activateIpSecurity = skipIpSecurityActivation.isSelected() ? "false" : "true";
    }

    public String getIntegrationCode() {
        return this.integrationCode;
    }

    public void setIntegrationCode(ValidatedFieldPanel integrationCodePanel) {
        this.integrationCode = integrationCodePanel.isEnabled() ? integrationCodePanel.getText() : EMPTY_STRING;
    }

    private String getIndentation(int indentLevel) {
        StringBuffer indentation = new StringBuffer();
        for (int i = 0; i < indentLevel; ++i) {
            indentation.append(INDENTATION);
        }
        return indentation.toString();
    }

    public String getAsXml() {
        StringBuffer xmlBuf = new StringBuffer();
        xmlBuf.append(XML_HEADER);
        xmlBuf.append(OPENING_XML_START_TAG);
        xmlBuf.append(XML_TOP_TAG);
        xmlBuf.append(CLOSING_XML_END_TAG);
        xmlBuf.append(NEW_LINE);
        xmlBuf.append(this.getXmlTag("VlanId", this.vLanId));
        xmlBuf.append(this.getXmlTag("DhcpClientIdentifier", this.dhcpClientIdentifier));
        xmlBuf.append(this.getXmlTag("SmrsUserId", this.smrsUserName));
        xmlBuf.append(this.getXmlTag("SmrsPassword", this.smrsPassword));
        xmlBuf.append(this.getXmlTag("SmrsAddress", this.smrsServer));
        xmlBuf.append(this.getXmlTag("SmrsSummaryFilePath", this.smrsFilePath));
        xmlBuf.append(this.getXmlTag("DnsServerAddress", this.dnsServer));
        xmlBuf.append(this.getXmlTag("DefDomainName", this.domainName));
        xmlBuf.append(this.getXmlTag("OamHostIpAddress", this.rbsIpAddress));
        xmlBuf.append(this.getXmlTag("OamSubnetmask", this.subnetMask));
        xmlBuf.append(this.getXmlTag("OamNetworkPrefixLength", this.networkPrefixLength));
        xmlBuf.append(this.getXmlTag("DefaultRouter0", this.defaultRouter));
        if (this.ped.get("UntrustedNetworkTemporaryConfigurationData") == Boolean.TRUE.toString()) {
            xmlBuf.append(OPENING_XML_START_TAG);
            xmlBuf.append(XML_SECONDARY_TAG);
            xmlBuf.append(CLOSING_XML_END_TAG);
            xmlBuf.append(this.getXmlTag("outerDnsServer", this.ped.get("OuterDnsServeripAddress")));
            xmlBuf.append(this.getXmlTag("SecGwIpAdd", this.ped.get("SecGWipAddress")));
            xmlBuf.append(this.getXmlTag("SecGwFqdn", this.ped.get("SecGWFQDN")));
            xmlBuf.append(this.getXmlTag("outerIpAddress", this.ped.get("OuterIpConfigurationDataipAddress")));
            xmlBuf.append(this.getXmlTag("outerSubnetMask", this.ped.get("OuterIpConfigurationDatasubnetMask")));
            xmlBuf.append(this.getXmlTag("outerDefaultRouter0", this.ped.get("OuterIpConfigurationDatadefaultRouter0")));
            xmlBuf.append(this.getXmlTag("DefDomainName", this.domainName));
            xmlBuf.append(this.getXmlTag("ipAddress", this.ped.get("InnerIpConfigurationDataipAddress")));
            xmlBuf.append(this.getXmlTag("InnerDnsServer", this.ped.get("InnerDnsServeripAddress")));
            xmlBuf.append(OPENING_XML_END_TAG);
            xmlBuf.append(XML_SECONDARY_TAG);
            xmlBuf.append(CLOSING_XML_END_TAG);
        }
        xmlBuf.append(this.getXmlTag("SiteBasicFilePath", this.siteBasicFile));
        xmlBuf.append(this.getXmlTag("SiteEquipmentFilePath", this.siteEquipmentFile));
        xmlBuf.append(this.getXmlTag("LicenseKeyFilePath", this.licenseKeyFile));
        xmlBuf.append(this.getXmlTag("UpgradePackageFilePath", this.upgradePackage));
        xmlBuf.append(this.getXmlTag("RbsIntegrationCode", this.integrationCode));
        xmlBuf.append(this.getXmlTag("ActivateSecurity", this.activateSecurity));
        xmlBuf.append(this.getXmlTag("ActivateIpSecurity", this.activateIpSecurity));
        xmlBuf.append(this.getXmlTag("LogicalName", this.logicalName));
        xmlBuf.append(this.getXmlTag("UniqueLogicalName", this.uniqueLogicalName));
        xmlBuf.append(this.getCabinetXmlTag());
        xmlBuf.append(this.getXmlTag("ClientUtcTime", Long.toString(this.currentTime)));
        xmlBuf.append(OPENING_XML_END_TAG);
        xmlBuf.append(XML_TOP_TAG);
        xmlBuf.append(CLOSING_XML_END_TAG);
        return xmlBuf.toString();
    }

    private String getUtcTime() {
        SimpleDateFormat dateFormatUtc = new SimpleDateFormat(UTC_TIME_FORMAT);
        dateFormatUtc.setTimeZone(TimeZone.getTimeZone(UTC_TIME_ZONE));
        return dateFormatUtc.format(new Date(this.currentTime)).toString();
    }

    public final void logParameters(Class<?> loggingClass) {
        IrbsLogger.logInfo(loggingClass, "VLAN id:                   " + IrbsHelper.doubleQuote(Integer.toString(this.vLanId)));
        IrbsLogger.logInfo(loggingClass, "DHCP client identifier:    " + IrbsHelper.doubleQuote(this.dhcpClientIdentifier));
        IrbsLogger.logInfo(loggingClass, "SMRS user:                 " + IrbsHelper.doubleQuote(this.smrsUserName));
        IrbsLogger.logInfo(loggingClass, "SMRS password:             " + IrbsHelper.doubleQuote(HIDDEN_PARAMETER));
        IrbsLogger.logInfo(loggingClass, "SMRS server:               " + IrbsHelper.doubleQuote(this.smrsServer));
        IrbsLogger.logInfo(loggingClass, "Summary file path:         " + IrbsHelper.doubleQuote(this.smrsFilePath));
        IrbsLogger.logInfo(loggingClass, "DNS server:                " + IrbsHelper.doubleQuote(this.dnsServer));
        IrbsLogger.logInfo(loggingClass, "Default domain name:       " + IrbsHelper.doubleQuote(this.domainName));
        IrbsLogger.logInfo(loggingClass, "RBS IP address:            " + IrbsHelper.doubleQuote(this.rbsIpAddress));
        IrbsLogger.logInfo(loggingClass, "RBS subnet mask:           " + IrbsHelper.doubleQuote(this.subnetMask));
        IrbsLogger.logInfo(loggingClass, "RBS network prefix length: " + IrbsHelper.doubleQuote(this.networkPrefixLength));
        IrbsLogger.logInfo(loggingClass, "Default router 0:          " + IrbsHelper.doubleQuote(this.defaultRouter));
        IrbsLogger.logInfo(loggingClass, "Site Basic file path:      " + IrbsHelper.doubleQuote(this.siteBasicFile));
        IrbsLogger.logInfo(loggingClass, "Site Equipment file path:  " + IrbsHelper.doubleQuote(this.siteEquipmentFile));
        IrbsLogger.logInfo(loggingClass, "License key file path:     " + IrbsHelper.doubleQuote(this.licenseKeyFile));
        IrbsLogger.logInfo(loggingClass, "Upgrade package file path: " + IrbsHelper.doubleQuote(this.upgradePackage));
        IrbsLogger.logInfo(loggingClass, "RBS integration code:      " + IrbsHelper.doubleQuote(HIDDEN_PARAMETER));
        IrbsLogger.logInfo(loggingClass, "Activate security:         " + IrbsHelper.doubleQuote(this.activateSecurity));
        IrbsLogger.logInfo(loggingClass, "Activate IP security:      " + IrbsHelper.doubleQuote(this.activateIpSecurity));
        IrbsLogger.logInfo(loggingClass, "RBS logical name:          " + IrbsHelper.doubleQuote(this.logicalName));
        IrbsLogger.logInfo(loggingClass, "Unique logical name:       " + IrbsHelper.doubleQuote(this.uniqueLogicalName));
        IrbsLogger.logInfo(loggingClass, "Cabinet production date:   " + IrbsHelper.doubleQuote(this.productionDate));
        IrbsLogger.logInfo(loggingClass, "Cabinet product name:      " + IrbsHelper.doubleQuote(this.productName));
        IrbsLogger.logInfo(loggingClass, "Cabinet product number:    " + IrbsHelper.doubleQuote(this.productNumber));
        IrbsLogger.logInfo(loggingClass, "Cabinet product revision:  " + IrbsHelper.doubleQuote(this.productRevision));
        IrbsLogger.logInfo(loggingClass, "Cabinet serial number:     " + IrbsHelper.doubleQuote(this.serialNumber));
        IrbsLogger.logInfo(loggingClass, "Client UTC time:           " + IrbsHelper.doubleQuote(this.getUtcTime() + " (" + Long.toString(this.currentTime) + ")"));
    }

    private String getXmlTag(String tagName, String tagValue) {
        StringBuffer xmlTag = new StringBuffer();
        if (!tagValue.equalsIgnoreCase(EMPTY_STRING)) {
            xmlTag.append(this.getIndentation(1)).append(OPENING_XML_START_TAG).append(tagName).append(VALUE_ATTR).append(tagValue).append(DOUBLE_QUOTE_STRING).append(CLOSING_XML_START_TAG).append(NEW_LINE);
        }
        return xmlTag.toString();
    }

    private String getXmlTag(String tagName, int tagValue) {
        StringBuffer xmlTag = new StringBuffer();
        if (tagValue != -1) {
            xmlTag.append(this.getIndentation(1)).append(OPENING_XML_START_TAG).append(tagName).append(VALUE_ATTR).append(tagValue).append(DOUBLE_QUOTE_STRING).append(CLOSING_XML_START_TAG).append(NEW_LINE);
        }
        return xmlTag.toString();
    }

    private String getCabinetXmlTag() {
        StringBuffer xmlTag = new StringBuffer();
        xmlTag.append(this.getIndentation(1)).append(OPENING_XML_START_TAG).append(CABINET).append(" ").append(CABINET_PRODUCTION_DATE).append("=").append(IrbsHelper.doubleQuote(this.productionDate)).append(" ").append(CABINET_PRODUCT_NAME).append("=").append(IrbsHelper.doubleQuote(this.productName)).append(" ").append(CABINET_PRODUCT_NUMBER).append("=").append(IrbsHelper.doubleQuote(this.productNumber)).append(" ").append(CABINET_PRODUCT_REVISION).append("=").append(IrbsHelper.doubleQuote(this.productRevision)).append(" ").append(CABINET_SERIAL_NUMBER).append("=").append(IrbsHelper.doubleQuote(this.serialNumber)).append(CLOSING_XML_START_TAG).append(NEW_LINE);
        return xmlTag.toString();
    }
}

