/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.menu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import se.ericsson.lte.rbs.omf.em.irbs.Definitions;
import se.ericsson.lte.rbs.omf.em.irbs.Exitable;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.ProgressDialogHolder;
import se.ericsson.lte.rbs.omf.em.irbs.SmrsFtpInfoProvider;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.AboutDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ErrorDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ProgressDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ReportAndLogDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ViewFileDialog;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationHandler;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportAndLogHandler;

public class MenuBar
extends JMenuBar {
    private static final ResourceBundle MENU_BUNDLE = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.IrbsMenu", Locale.getDefault());
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private static final String REASON_LABEL = MENU_BUNDLE.getString("reasonLabel");
    public static transient File CURRENT_FILE = new File(System.getProperty("user.home", "C:\\"));
    private final transient JMenu fileMenu;
    private final transient JMenu viewMenu;
    private final transient JMenu traceErrorMenu;
    private final transient JMenu helpMenu;
    private transient String cxcNumber = MENU_BUNDLE.getString("notAvailable");
    private transient String cxcRevision = MENU_BUNDLE.getString("notAvailable");
    private final transient JMenuItem traceErrorStartStopMenu;
    private final transient JMenuItem viewReportMenu;
    private final transient JMenuItem viewProgressMenu;
    private transient boolean traceAndErrorRunning = true;
    private final ProgressDialogHolder progressDialogHolder;
    private ReportAndLogDialog logDialog = null;
    private ReportAndLogDialog reportDialog = null;
    private ViewFileDialog viewFileDialog = null;

    public MenuBar(Exitable exitable, ProgressDialogHolder inputProgressDialogHolder, SmrsFtpInfoProvider smrsFtpInfoProvider, ReportAndLogHandler reportAndLogHandler, IrbsNotificationHandler irbsNotificationHandler) {
        IrbsLogger.logEntering(this.getClass());
        this.progressDialogHolder = inputProgressDialogHolder;
        this.fileMenu = new JMenu(MENU_BUNDLE.getString("fileMenuLabel"));
        this.fileMenu.setMnemonic(MENU_BUNDLE.getString("fileMenuMnemonic").charAt(0));
        JMenuItem fileExitMenu = new JMenuItem(MENU_BUNDLE.getString("exitLabel"));
        fileExitMenu.setMnemonic(MENU_BUNDLE.getString("exitMnemonic").charAt(0));
        fileExitMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("exitAccelerator")));
        fileExitMenu.addActionListener(this.createExitListener(exitable));
        this.fileMenu.add(fileExitMenu);
        this.add(this.fileMenu);
        this.viewMenu = new JMenu(MENU_BUNDLE.getString("viewMenuLabel"));
        this.viewMenu.setMnemonic(MENU_BUNDLE.getString("viewMenuMnemonic").charAt(0));
        this.viewProgressMenu = new JMenuItem(MENU_BUNDLE.getString("progressLabel"));
        this.viewProgressMenu.setMnemonic(MENU_BUNDLE.getString("progressMnemonic").charAt(0));
        this.viewProgressMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("progressAccelerator")));
        this.viewProgressMenu.addActionListener(this.createProgressListener(exitable.getFrame(), irbsNotificationHandler));
        this.viewMenu.add(this.viewProgressMenu);
        this.viewReportMenu = new JMenuItem(MENU_BUNDLE.getString("reportLabel"));
        this.viewReportMenu.setMnemonic(MENU_BUNDLE.getString("reportMnemonic").charAt(0));
        this.viewReportMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("reportAccelerator")));
        this.viewReportMenu.addActionListener(this.createReportListener(exitable.getFrame(), smrsFtpInfoProvider, reportAndLogHandler));
        this.viewMenu.add(this.viewReportMenu);
        JMenuItem viewLogMenu = new JMenuItem(MENU_BUNDLE.getString("logLabel"));
        viewLogMenu.setMnemonic(MENU_BUNDLE.getString("logMnemonic").charAt(0));
        viewLogMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("logAccelerator")));
        viewLogMenu.addActionListener(this.createLogListener(exitable.getFrame(), smrsFtpInfoProvider, reportAndLogHandler));
        this.viewMenu.add(viewLogMenu);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.createViewFileMenu(exitable));
        this.add(this.viewMenu);
        this.traceErrorMenu = new JMenu(MENU_BUNDLE.getString("logMenuLabel"));
        this.traceErrorMenu.setMnemonic(MENU_BUNDLE.getString("logMenuMnemonic").charAt(0));
        this.traceErrorStartStopMenu = new JMenuItem(MENU_BUNDLE.getString("stopLogLabel"));
        this.traceErrorStartStopMenu.setMnemonic(MENU_BUNDLE.getString("startStopMnemonic").charAt(0));
        this.traceErrorStartStopMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("startStopAccelerator")));
        this.traceErrorStartStopMenu.addActionListener(this.createTraceErrorStartStopListener());
        this.traceErrorMenu.add(this.traceErrorStartStopMenu);
        this.traceErrorMenu.add(this.createTraceErrorViewMenu(exitable));
        this.traceErrorMenu.add(this.createTraceErrorClearMenu());
        this.traceErrorMenu.addSeparator();
        this.traceErrorMenu.add(this.createTraceErrorSaveMenu());
        this.add(this.traceErrorMenu);
        this.helpMenu = new JMenu(MENU_BUNDLE.getString("helpMenuLabel"));
        this.helpMenu.setMnemonic(MENU_BUNDLE.getString("helpMnemonic").charAt(0));
        JMenuItem helpAboutMenu = new JMenuItem(MENU_BUNDLE.getString("aboutLabel"));
        helpAboutMenu.setMnemonic(MENU_BUNDLE.getString("aboutMnemonic").charAt(0));
        helpAboutMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("aboutAccelerator")));
        helpAboutMenu.addActionListener(this.createAboutListener(exitable.getFrame()));
        this.helpMenu.add(helpAboutMenu);
        this.add(this.helpMenu);
        IrbsLogger.logExiting(this.getClass());
    }

    private JMenuItem createViewFileMenu(Exitable exitable) {
        JMenuItem viewFileMenu = new JMenuItem(MENU_BUNDLE.getString("allFilesLabel"));
        viewFileMenu.setMnemonic(MENU_BUNDLE.getString("allFileMnemonic").charAt(0));
        viewFileMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("allFileAccelerator")));
        viewFileMenu.addActionListener(this.createFileListener(exitable.getFrame()));
        return viewFileMenu;
    }

    private JMenuItem createTraceErrorViewMenu(Exitable exitable) {
        JMenuItem traceErrorViewMenu = new JMenuItem(MENU_BUNDLE.getString("viewLogLabel"));
        traceErrorViewMenu.setMnemonic(MENU_BUNDLE.getString("viewLogMnemonic").charAt(0));
        traceErrorViewMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("viewLogAccelerator")));
        traceErrorViewMenu.addActionListener(this.createViewTraceErrorLogListener(exitable.getFrame()));
        return traceErrorViewMenu;
    }

    private JMenuItem createTraceErrorClearMenu() {
        JMenuItem traceErrorClearMenu = new JMenuItem(MENU_BUNDLE.getString("clearLogLabel"));
        traceErrorClearMenu.setMnemonic(MENU_BUNDLE.getString("clearLogMnemonic").charAt(0));
        traceErrorClearMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("clearLogAccelerator")));
        traceErrorClearMenu.addActionListener(this.createClearTraceErrorLogListener());
        return traceErrorClearMenu;
    }

    private JMenuItem createTraceErrorSaveMenu() {
        JMenuItem traceErrorSaveMenu = new JMenuItem(MENU_BUNDLE.getString("saveLogLabel"));
        traceErrorSaveMenu.setMnemonic(MENU_BUNDLE.getString("saveLogMnemonic").charAt(0));
        traceErrorSaveMenu.setAccelerator(KeyStroke.getKeyStroke(MENU_BUNDLE.getString("saveLogAccelerator")));
        traceErrorSaveMenu.addActionListener(this.createSaveTraceErrorLogListener());
        return traceErrorSaveMenu;
    }

    public void setCxcNumber(String inputCxcNumber) {
        this.cxcNumber = inputCxcNumber;
    }

    public void setRevision(String inputCxcRevision) {
        this.cxcRevision = inputCxcRevision;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    public JMenu getTraceErrorMenu() {
        return this.traceErrorMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public void setConnected(boolean connected) {
        this.viewReportMenu.setEnabled(connected);
        this.viewProgressMenu.setEnabled(connected);
    }

    private ActionListener createExitListener(final Exitable exitable) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                String warningMessage = MENU_BUNDLE.getString("exitConfirmMessageLabel");
                IrbsLogger.logWarning(this.getClass(), warningMessage);
                int result = IrbsHelper.displayWarningMessage(MENU_BUNDLE.getString("exitConfirmHeaderLabel"), warningMessage, 0);
                if (result == 0) {
                    exitable.exit(0);
                }
            }
        };
    }

    private ActionListener createProgressListener(final Frame parent, final IrbsNotificationHandler irbsNotificationHandler) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                try {
                    if (MenuBar.this.progressDialogHolder.getProgressDialog() != null && MenuBar.this.progressDialogHolder.getProgressDialog().isShowing()) {
                        MenuBar.this.progressDialogHolder.getProgressDialog().update();
                    } else {
                        ProgressDialog progressDialog = new ProgressDialog(parent, irbsNotificationHandler);
                        MenuBar.this.progressDialogHolder.setProgressDialog(progressDialog);
                    }
                    MenuBar.this.progressDialogHolder.getProgressDialog().setExtendedState(0);
                    MenuBar.this.progressDialogHolder.getProgressDialog().requestFocus();
                    MenuBar.this.progressDialogHolder.getProgressDialog().setVisible(true);
                }
                catch (Exception e) {
                    String errorMessage = MENU_BUNDLE.getString("progressErrorMessageLabel") + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                    IrbsLogger.logError(this.getClass(), errorMessage, e);
                    ErrorDialog.displayError(parent, MENU_BUNDLE.getString("progressErrorHeaderLabel"), errorMessage, IrbsHelper.convertToString(e));
                }
            }
        };
    }

    private ActionListener createReportListener(final Frame parent, final SmrsFtpInfoProvider smrsFtpInfoProvider, final ReportAndLogHandler reportAndLogHandler) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                try {
                    if (MenuBar.this.reportDialog == null || !MenuBar.this.reportDialog.isShowing()) {
                        MenuBar.this.reportDialog = new ReportAndLogDialog(parent, smrsFtpInfoProvider, reportAndLogHandler, false);
                    }
                    MenuBar.this.reportDialog.setExtendedState(0);
                    MenuBar.this.reportDialog.requestFocus();
                    MenuBar.this.reportDialog.setVisible(true);
                }
                catch (Exception e) {
                    String errorMessage = MENU_BUNDLE.getString("reportErrorMessageLabel") + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                    IrbsLogger.logError(this.getClass(), errorMessage, e);
                    ErrorDialog.displayError(parent, MENU_BUNDLE.getString("reportErrorHeaderLabel"), errorMessage, IrbsHelper.convertToString(e));
                }
            }
        };
    }

    private ActionListener createLogListener(final Frame parent, final SmrsFtpInfoProvider smrsFtpInfoProvider, final ReportAndLogHandler reportAndLogHandler) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                try {
                    if (MenuBar.this.logDialog == null || !MenuBar.this.logDialog.isShowing()) {
                        MenuBar.this.logDialog = new ReportAndLogDialog(parent, smrsFtpInfoProvider, reportAndLogHandler, true);
                    }
                    MenuBar.this.logDialog.setExtendedState(0);
                    MenuBar.this.logDialog.requestFocus();
                    MenuBar.this.logDialog.setVisible(true);
                }
                catch (Exception e) {
                    String errorMessage = MENU_BUNDLE.getString("logErrorMessageLabel") + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                    IrbsLogger.logError(this.getClass(), errorMessage, e);
                    ErrorDialog.displayError(parent, MENU_BUNDLE.getString("logErrorHeaderLabel"), errorMessage, IrbsHelper.convertToString(e));
                }
            }
        };
    }

    private ActionListener createFileListener(final Frame parent) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                try {
                    JFileChooser fileChooser = new JFileChooser(CURRENT_FILE);
                    fileChooser.setFileFilter(MenuBar.this.createFileFilter());
                    if (IrbsHelper.testMode || 0 == fileChooser.showOpenDialog(MenuBar.this.getParent())) {
                        File selectedFile = fileChooser.getSelectedFile();
                        ViewFileDialog allFilesViewFileDialog = new ViewFileDialog(parent, MENU_BUNDLE.getString("allFilesTitle"), MENU_BUNDLE.getString("allFilesHeader") + " " + selectedFile.getName(), selectedFile.getAbsolutePath());
                        allFilesViewFileDialog.setVisible(true);
                    }
                }
                catch (Exception e) {
                    String errorMessage = MENU_BUNDLE.getString("allFilesErrorMessageLabel") + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                    IrbsLogger.logError(this.getClass(), errorMessage, e);
                    ErrorDialog.displayError(parent, MENU_BUNDLE.getString("allFilesErrorHeaderLabel"), errorMessage, IrbsHelper.convertToString(e));
                }
            }
        };
    }

    private FileFilter createFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    CURRENT_FILE = file;
                    return true;
                }
                CURRENT_FILE = file.getParentFile();
                return file.isFile();
            }

            public String getDescription() {
                return MENU_BUNDLE.getString("allFilesFilter");
            }
        };
    }

    private ActionListener createTraceErrorStartStopListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                if (MenuBar.this.traceErrorStartStopMenu.getText().equals(MENU_BUNDLE.getString("stopLogLabel"))) {
                    MenuBar.this.traceErrorStartStopMenu.setText(MENU_BUNDLE.getString("startLogLabel"));
                    IrbsLogger.stopTraceErrorLogging();
                    MenuBar.this.traceAndErrorRunning = false;
                } else {
                    MenuBar.this.traceErrorStartStopMenu.setText(MENU_BUNDLE.getString("stopLogLabel"));
                    IrbsLogger.startTraceErrorLogging();
                    MenuBar.this.traceAndErrorRunning = true;
                }
            }
        };
    }

    private ActionListener createViewTraceErrorLogListener(final Frame parent) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                try {
                    if (MenuBar.this.viewFileDialog == null || !MenuBar.this.viewFileDialog.isShowing()) {
                        MenuBar.this.viewFileDialog = new ViewFileDialog(parent, MENU_BUNDLE.getString("traceErrorTitle"), MENU_BUNDLE.getString("traceErrorHeader"), Definitions.TRACE_FILE_LOCATION);
                    }
                    MenuBar.this.viewFileDialog.setExtendedState(0);
                    MenuBar.this.viewFileDialog.requestFocus();
                    MenuBar.this.viewFileDialog.setVisible(true);
                }
                catch (Exception e) {
                    String errorMessage = "Could not launch trace & error viwer. Reason: ";
                    IrbsHelper.getExceptionMessage(e);
                    IrbsLogger.logError(this.getClass(), "Could not launch trace & error viwer. Reason: ", e);
                }
            }
        };
    }

    private ActionListener createClearTraceErrorLogListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                IrbsLogger.stopTraceErrorLogging();
                IrbsLogger.clearTraceErrorLog();
                if (MenuBar.this.traceAndErrorRunning) {
                    IrbsLogger.startTraceErrorLogging();
                }
            }
        };
    }

    private ActionListener createSaveTraceErrorLogListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                JFileChooser fileChooser = new JFileChooser(CURRENT_FILE);
                fileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return false;
                        }
                        CURRENT_FILE = file.getParentFile();
                        return file.isFile();
                    }

                    public String getDescription() {
                        return MENU_BUNDLE.getString("allFilesFilter");
                    }
                });
                MenuBar.this.saveTraceErrorLogFile(fileChooser);
            }
        };
    }

    private void saveTraceErrorLogFile(JFileChooser fileChooser) {
        if (!(IrbsHelper.testMode || 0 != fileChooser.showSaveDialog(this.getParent()) || new File(fileChooser.getSelectedFile().getAbsolutePath()).exists() && 0 != IrbsHelper.displayConfirmationMessage(irbsBundle.getString("irbsOverwriteFileConfirmHeaderLabel"), fileChooser.getSelectedFile().getAbsolutePath() + " " + irbsBundle.getString("irbsOverwriteFileMessageLabel"), 0))) {
            IrbsLogger.saveTraceErrorLogFile(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private ActionListener createAboutListener(final Frame parent) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                try {
                    AboutDialog aboutDialog = new AboutDialog(MENU_BUNDLE.getString("irbsRbsIntegration"), MenuBar.this.cxcNumber, MenuBar.this.cxcRevision, parent);
                    aboutDialog.setVisible(true);
                }
                catch (Exception e) {
                    String errorMessage = MENU_BUNDLE.getString("aboutErrorMessageLabel") + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                    IrbsLogger.logError(this.getClass(), errorMessage, e);
                    ErrorDialog.displayError(parent, MENU_BUNDLE.getString("aboutErrorHeaderLabel"), errorMessage, IrbsHelper.convertToString(e));
                }
            }
        };
    }
}

