/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.TitledFileBrowsePanel;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.validator.LocalFilePathValidator;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;

public class ConfigurationFilesPanel
extends JPanel {
    private final transient TitledFileBrowsePanel siteBasicGroupBox;
    private final transient TitledFileBrowsePanel siteEquipmentGroupBox;
    private final transient TitledFileBrowsePanel licenseKeyGroupBox;
    private final transient TitledFileBrowsePanel upgradePackageGroupBox;

    public ConfigurationFilesPanel(ValidListener validListener) throws InputDataException {
        super(new GridBagLayout());
        IrbsLogger.logEntering(this.getClass());
        ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
        String filePath = irbsBundle.getString("irbsConfigFilePath");
        this.siteBasicGroupBox = new TitledFileBrowsePanel(irbsBundle.getString("irbsConfigSiteBasic"), filePath, ".xml", irbsBundle.getString("variousXmlFiles"), new LocalFilePathValidator(true, ".xml"));
        this.siteBasicGroupBox.addValidityListener(validListener);
        this.siteEquipmentGroupBox = new TitledFileBrowsePanel(irbsBundle.getString("irbsConfigSiteConfigEquipment"), filePath, ".xml", irbsBundle.getString("variousXmlFiles"), new LocalFilePathValidator(true, ".xml"));
        this.siteEquipmentGroupBox.addValidityListener(validListener);
        this.licenseKeyGroupBox = new TitledFileBrowsePanel(irbsBundle.getString("irbsConfigLicenseKey"), filePath, ".lkf", irbsBundle.getString("variousLkfFiles"), new LocalFilePathValidator(true, ".lkf"), irbsBundle.getString("irbsConfigIgnoreLicenseKey"));
        this.licenseKeyGroupBox.addValidityListener(validListener);
        this.upgradePackageGroupBox = new TitledFileBrowsePanel(irbsBundle.getString("irbsConfigUpgradePackage"), filePath, ".zip", irbsBundle.getString("variousZipFiles"), new LocalFilePathValidator(true, ".zip"), irbsBundle.getString("irbsConfigIgnoreUpgradePackage"));
        this.upgradePackageGroupBox.addValidityListener(validListener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.siteBasicGroupBox, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.siteEquipmentGroupBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.licenseKeyGroupBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.upgradePackageGroupBox, constraints);
        IrbsLogger.logExiting(this.getClass());
    }

    public void clearAllData() {
        this.siteBasicGroupBox.getFieldBrowsePanel().setText("");
        this.siteEquipmentGroupBox.getFieldBrowsePanel().setText("");
        this.licenseKeyGroupBox.getCheckBox().setSelected(false);
        this.licenseKeyGroupBox.getFieldBrowsePanel().setText("");
        this.upgradePackageGroupBox.getCheckBox().setSelected(false);
        this.upgradePackageGroupBox.getFieldBrowsePanel().setText("");
    }

    public boolean holdsData() {
        return !this.siteBasicGroupBox.getFieldBrowsePanel().getText().equals("") || !this.siteEquipmentGroupBox.getFieldBrowsePanel().getText().equals("") || this.licenseKeyGroupBox.getCheckBox().isSelected() || !this.licenseKeyGroupBox.getFieldBrowsePanel().getText().equals("") || this.upgradePackageGroupBox.getCheckBox().isSelected() || !this.upgradePackageGroupBox.getFieldBrowsePanel().getText().equals("");
    }

    public final void setEnabled(boolean enabled) {
        this.siteBasicGroupBox.setEnabled(enabled);
        this.siteEquipmentGroupBox.setEnabled(enabled);
        this.licenseKeyGroupBox.setEnabled(enabled);
        this.upgradePackageGroupBox.setEnabled(enabled);
    }

    public final TitledFileBrowsePanel getSiteBasicPanel() {
        return this.siteBasicGroupBox;
    }

    public final TitledFileBrowsePanel getSiteEquipmentPanel() {
        return this.siteEquipmentGroupBox;
    }

    public final TitledFileBrowsePanel getLicenseKeyFilePanel() {
        return this.licenseKeyGroupBox;
    }

    public final TitledFileBrowsePanel getUpgradePackagePanel() {
        return this.upgradePackageGroupBox;
    }
}

