/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.DhcpInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpRegExpValidator;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;

public class DefaultRouterHolder {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient JLabel defaultRouterLabel = new JLabel(irbsBundle.getString("irbsOptionDefaultRouter"));
    private final transient ValidatedFieldPanel defaultRouterPanel;

    public DefaultRouterHolder(DhcpInformer dhcpInformer) throws InputDataException {
        this.defaultRouterPanel = new ValidatedFieldPanel(new DhcpRegExpValidator(RegExpValidator.NON_EMPTY_IP_ADDRESS_PATTERN, dhcpInformer));
    }

    public JLabel getDefaultRouterLabel() {
        return this.defaultRouterLabel;
    }

    public ValidatedFieldPanel getDefaultRouterPanel() {
        return this.defaultRouterPanel;
    }

    public boolean correctDefaultRouter() {
        return !this.defaultRouterPanel.getText().equals("") && this.defaultRouterPanel.validValue();
    }

    public void setEnabled(boolean enabled) {
        this.defaultRouterLabel.setEnabled(enabled);
        this.defaultRouterPanel.setEnabled(enabled);
    }

    public boolean validValue() {
        return this.defaultRouterPanel.validValue();
    }

    public boolean defaultRouterValid() {
        return this.defaultRouterPanel.getTextField().isEnabled() && !this.defaultRouterPanel.getText().equals("") && this.defaultRouterPanel.validValue();
    }
}

