/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.DhcpInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpRegExpValidator;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;

public class DomainNameHolder {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient JLabel domainNameLabel = new JLabel(irbsBundle.getString("irbsOptionDomainName"));
    private final transient ValidatedFieldPanel domainNamePanel;

    public DomainNameHolder(DhcpInformer dhcpInformer) throws InputDataException {
        this.domainNamePanel = new ValidatedFieldPanel(new DhcpRegExpValidator(RegExpValidator.EMPTY_HOST_NAME_PATTERN, dhcpInformer));
    }

    public JLabel getDomainNameLabel() {
        return this.domainNameLabel;
    }

    public ValidatedFieldPanel getDomainNamePanel() {
        return this.domainNamePanel;
    }

    public boolean correctDomainName() {
        return this.domainNamePanel.validValue();
    }

    public void setEnabled(boolean enabled) {
        this.domainNameLabel.setEnabled(enabled);
        this.domainNamePanel.setEnabled(enabled);
    }

    public boolean validValue() {
        return this.domainNamePanel.validValue();
    }

    public boolean domainNameValid() {
        return this.domainNamePanel.getTextField().isEnabled() && this.domainNamePanel.validValue();
    }
}

