/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.DhcpInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpRegExpValidator;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpRelativeAndAbsolutePathValidator;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;

public class SmrsHolder {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient JLabel smrsServerLabel = new JLabel(irbsBundle.getString("smrsParamSmrsServer"));
    private final transient ValidatedFieldPanel smrsServerPanel;
    private final transient JLabel smrsFilePathLabel;
    private final transient ValidatedFieldPanel smrsFilePathPanel;

    public SmrsHolder(DhcpInformer dhcpInformer) throws InputDataException {
        this.smrsServerPanel = new ValidatedFieldPanel(new DhcpRegExpValidator(RegExpValidator.NON_EMPTY_IP_AND_HOST_PATTERN, dhcpInformer));
        this.smrsFilePathLabel = new JLabel(irbsBundle.getString("smrsParamSummaryFilePath"));
        this.smrsFilePathPanel = new ValidatedFieldPanel(new DhcpRelativeAndAbsolutePathValidator(false, dhcpInformer));
    }

    public JLabel getSmrsServerLabel() {
        return this.smrsServerLabel;
    }

    public ValidatedFieldPanel getSmrsServerPanel() {
        return this.smrsServerPanel;
    }

    public JLabel getSmrsFilePathLabel() {
        return this.smrsFilePathLabel;
    }

    public ValidatedFieldPanel getSmrsFilePathPanel() {
        return this.smrsFilePathPanel;
    }

    public boolean correctSmrsServer() {
        boolean result = true;
        if (this.smrsServerPanel.isEnabled()) {
            result = !this.smrsServerPanel.getText().equals("") && this.smrsServerPanel.validValue();
        }
        return result;
    }

    public boolean correctSmrsFilePath() {
        boolean result = true;
        if (this.smrsFilePathPanel.isEnabled()) {
            result = !this.smrsFilePathPanel.getText().equals("") && this.smrsFilePathPanel.validValue();
        }
        return result;
    }

    public void setEnabled(boolean enabled) {
        this.smrsServerLabel.setEnabled(enabled);
        this.smrsServerPanel.setEnabled(enabled);
        this.smrsFilePathLabel.setEnabled(enabled);
        this.smrsFilePathPanel.setEnabled(enabled);
    }

    public boolean validValue() {
        return this.smrsServerPanel.validValue() && this.smrsFilePathPanel.validValue();
    }

    public boolean smrsServerValid() {
        return this.smrsServerPanel.getTextField().isEnabled() && !this.smrsServerPanel.getText().equals("") && this.smrsServerPanel.validValue();
    }

    public boolean smrsFilePathValid() {
        return this.smrsFilePathPanel.getTextField().isEnabled() && !this.smrsFilePathPanel.getText().equals("") && this.smrsFilePathPanel.validValue();
    }

    public String getSmrsAddress() {
        return this.smrsServerPanel.getText();
    }

    public String getSmrsPath() {
        return this.smrsFilePathPanel.getText();
    }
}

