/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.DhcpInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpRegExpValidator;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;

public class SubnetMaskHolder {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient JLabel subnetMaskLabel = new JLabel(irbsBundle.getString("irbsOptionSubnetMask"));
    private final transient ValidatedFieldPanel subnetMaskPanel;

    public SubnetMaskHolder(DhcpInformer dhcpInformer) throws InputDataException {
        this.subnetMaskPanel = new ValidatedFieldPanel(new DhcpRegExpValidator(RegExpValidator.NON_EMPTY_IP_ADDRESS_PATTERN, dhcpInformer));
    }

    public JLabel getSubnetMaskLabel() {
        return this.subnetMaskLabel;
    }

    public ValidatedFieldPanel getSubnetMaskPanel() {
        return this.subnetMaskPanel;
    }

    public boolean correctSubnetMask() {
        return !this.subnetMaskPanel.getText().equals("") && this.subnetMaskPanel.validValue();
    }

    public void setEnabled(boolean enabled) {
        this.subnetMaskLabel.setEnabled(enabled);
        this.subnetMaskPanel.setEnabled(enabled);
    }

    public boolean validValue() {
        return this.subnetMaskPanel.validValue();
    }

    public boolean subnetMaskValid() {
        return this.subnetMaskPanel.getTextField().isEnabled() && !this.subnetMaskPanel.getText().equals("") && this.subnetMaskPanel.validValue();
    }
}

