/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteDialog;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;

public class AboutDialog
extends AbstractLteDialog {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient LteButton closeButton;

    public AboutDialog(String applicationName, String cxcNumber, String revisionNumber, Frame parent) throws ImageHelper.ResourceException {
        super(irbsBundle.getString("aboutTitle"), parent, true);
        IrbsLogger.logEntering(this.getClass());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 10, 5, 10);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel headerPanel = this.createHeaderPanel(applicationName, constraints);
        Font labelTitleFont = new Font("*Helvetica*", 1, 14);
        Font labelInfoFont = new Font("*Helvetica*", 2, 14);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        JPanel versionInformationPanel = this.createVersionPanel(cxcNumber, revisionNumber, constraints, labelTitleFont, labelInfoFont);
        String closeButtonText = irbsBundle.getString("aboutClose");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        JPanel buttonPanel = this.createButtonPanel(this.closeButton, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)headerPanel, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)versionInformationPanel, constraints);
        ++constraints.gridy;
        mainPanel.add((Component)buttonPanel, constraints);
        this.setLocationRelativeTo(parent);
        this.pack();
        IrbsLogger.logExiting(this.getClass());
    }

    private JPanel createButtonPanel(LteButton theCloseButton, GridBagConstraints constraints) {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        buttonPanel.add((Component)new JLabel(), constraints);
        theCloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                AboutDialog.this.close();
            }
        });
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 10, 7, 10);
        buttonPanel.add((Component)theCloseButton, constraints);
        return buttonPanel;
    }

    private JPanel createVersionPanel(String cxcNumber, String revisionNumber, GridBagConstraints constraints, Font labelTitleFont, Font labelInfoFont) {
        JPanel versionInformationPanel = new JPanel(new GridBagLayout());
        versionInformationPanel.setBorder(new TitledBorder(new EtchedBorder(), irbsBundle.getString("aboutVersionInformation")));
        JLabel cxcTitleLabel = new JLabel(irbsBundle.getString("aboutCxcNumber"));
        cxcTitleLabel.setFont(labelTitleFont);
        versionInformationPanel.add((Component)cxcTitleLabel, constraints);
        JLabel cxcLabel = new JLabel(cxcNumber);
        cxcLabel.setFont(labelInfoFont);
        constraints.gridx = 1;
        versionInformationPanel.add((Component)cxcLabel, constraints);
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        versionInformationPanel.add((Component)new JLabel(), constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.insets = new Insets(5, 10, 10, 10);
        constraints.weightx = 0.0;
        JLabel revisionTitleLabel = new JLabel(irbsBundle.getString("aboutRevision"));
        revisionTitleLabel.setFont(labelTitleFont);
        versionInformationPanel.add((Component)revisionTitleLabel, constraints);
        JLabel revisionLabel = new JLabel(revisionNumber);
        revisionLabel.setFont(labelInfoFont);
        constraints.gridx = 1;
        versionInformationPanel.add((Component)revisionLabel, constraints);
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        versionInformationPanel.add((Component)new JLabel(), constraints);
        return versionInformationPanel;
    }

    private JPanel createHeaderPanel(String applicationName, GridBagConstraints constraints) throws ImageHelper.ResourceException {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabelUpper = new JLabel(irbsBundle.getString("aboutVersionInformationFor"));
        JLabel headerLabelLower = new JLabel("\"" + applicationName + "\"");
        headerLabelUpper.setFont(new Font("*Helvetica*", 1, 18));
        headerLabelLower.setFont(new Font("*Helvetica*", 2, 18));
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabelUpper, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 10, 5, 10);
        headerPanel.add((Component)headerLabelLower, constraints);
        constraints.anchor = 17;
        return headerPanel;
    }

    public final void close() {
        this.dispose();
    }

    protected LteButton getCloseButton() {
        return this.closeButton;
    }
}

