/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteDialog;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldBrowsePanel;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.FileHandler;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.SmrsFtpInfoProvider;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ErrorDialog;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportAndLogHandler;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportFileException;
import se.ericsson.lte.rbs.omf.em.util.FtpClient;
import se.ericsson.lte.rbs.omf.em.util.FtpClientFactory;
import se.ericsson.lte.rbs.omf.em.util.LteColor;
import se.ericsson.lte.rbs.omf.em.validator.EmptyValidator;
import se.ericsson.lte.rbs.omf.em.validator.LocalFilePathValidator;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;
import se.ericsson.lte.rbs.omf.em.validator.RemoteFilePathValidator;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class FtpUploadDialog
extends AbstractLteDialog {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private static final String UNIX_DELIMITER = "/";
    private final transient Object mutexObj = new Object();
    private final transient ValidatedFieldBrowsePanel logFileBrowsePanel;
    private final transient ValidatedFieldPanel ftpServerPanel;
    private final transient ValidatedFieldPanel ftpUserPanel;
    private final transient ValidatedFieldPanel ftpPasswordPanel;
    private final transient ValidatedFieldPanel targetDirPathPanel;
    private final transient LteButton okButton;
    private final transient LteButton closeButton;
    private final transient FileHandler fileHandler;
    private final transient ReportAndLogHandler reportAndLogHandler;
    private final transient boolean isLogFile;
    private final transient ValidListener okButtonListener;
    private transient boolean uploadIsExecuting = false;
    protected transient Thread uploadSupervisingThread = null;

    public FtpUploadDialog(Frame parent, SmrsFtpInfoProvider smrsFtpInfoProvider, FileHandler inputFileHandler, ReportAndLogHandler inputReportAndLogHandler, boolean inputIsLogFile) throws ImageHelper.ResourceException, InputDataException, ReportFileException {
        super(inputIsLogFile ? irbsBundle.getString("ftpFtpTitle") : irbsBundle.getString("ftpSmrsTitle"), parent, false);
        IrbsLogger.logEntering(this.getClass());
        this.fileHandler = inputFileHandler;
        this.reportAndLogHandler = inputReportAndLogHandler;
        this.isLogFile = inputIsLogFile;
        String okButtonText = irbsBundle.getString("ftpOkButton");
        this.okButton = new LteButton(okButtonText);
        this.okButton.setMnemonic(okButtonText.charAt(0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = inputIsLogFile ? new JLabel(irbsBundle.getString("ftpUploadToFtpServer")) : new JLabel(irbsBundle.getString("ftpUploadToSmrsServer"));
        Font headerFont = new Font("*Helvetica*", 3, 16);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        constraints.anchor = 17;
        JPanel ftpPanel = new JPanel(new GridBagLayout());
        ftpPanel.setBorder(new TitledBorder(new EtchedBorder(), irbsBundle.getString("ftpFtpSettings")));
        this.logFileBrowsePanel = new ValidatedFieldBrowsePanel(new LocalFilePathValidator(false, null), "*.*", irbsBundle.getString("variousAllFiles"));
        if (inputIsLogFile) {
            this.logFileBrowsePanel.setText(inputReportAndLogHandler.getLogFile().getAbsolutePath());
        } else {
            this.logFileBrowsePanel.setText(inputReportAndLogHandler.getReportFile().getAbsolutePath());
        }
        this.ftpServerPanel = new ValidatedFieldPanel(new RegExpValidator(RegExpValidator.NON_EMPTY_IP_AND_HOST_PATTERN));
        this.ftpServerPanel.setText(smrsFtpInfoProvider.getAddress());
        this.ftpUserPanel = new ValidatedFieldPanel(new EmptyValidator(false));
        this.ftpUserPanel.setText(smrsFtpInfoProvider.getUserName());
        this.ftpPasswordPanel = new ValidatedFieldPanel(new EmptyValidator(false), true);
        this.ftpPasswordPanel.setText(smrsFtpInfoProvider.getPassword());
        this.targetDirPathPanel = new ValidatedFieldPanel(new RemoteFilePathValidator(false, true, true));
        this.okButtonListener = new ValidListener(){

            public void validityChanged(Component notUsed, Validator validator) {
                FtpUploadDialog.this.enableOkButton();
            }
        };
        this.logFileBrowsePanel.addValidityListener(this.okButtonListener);
        this.ftpServerPanel.addValidityListener(this.okButtonListener);
        this.ftpUserPanel.addValidityListener(this.okButtonListener);
        this.ftpPasswordPanel.addValidityListener(this.okButtonListener);
        this.targetDirPathPanel.addValidityListener(this.okButtonListener);
        JPanel wrappingPanel = new JPanel(new GridBagLayout());
        constraints.insets = new Insets(2, 10, 2, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        if (inputIsLogFile) {
            ftpPanel.add((Component)new JLabel(irbsBundle.getString("ftpLogFile")), constraints);
        } else {
            ftpPanel.add((Component)new JLabel(irbsBundle.getString("ftpReportFile")), constraints);
        }
        constraints.gridx = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        ftpPanel.add((Component)this.logFileBrowsePanel, constraints);
        constraints.gridx = 0;
        constraints.insets = new Insets(2, 5, 2, 2);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        wrappingPanel.add((Component)new JLabel(irbsBundle.getString("ftpFtpServer")), constraints);
        constraints.gridx = 1;
        constraints.weightx = 0.25;
        wrappingPanel.add((Component)this.ftpServerPanel, constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.75;
        constraints.gridwidth = 0;
        wrappingPanel.add((Component)new JPanel(), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        wrappingPanel.add((Component)new JLabel(irbsBundle.getString("ftpFtpUser")), constraints);
        constraints.gridx = 1;
        constraints.weightx = 0.25;
        wrappingPanel.add((Component)this.ftpUserPanel, constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.75;
        constraints.gridwidth = 0;
        wrappingPanel.add((Component)new JPanel(), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        wrappingPanel.add((Component)new JLabel(irbsBundle.getString("ftpFtpPassword")), constraints);
        constraints.gridx = 1;
        constraints.weightx = 0.25;
        wrappingPanel.add((Component)this.ftpPasswordPanel, constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.75;
        constraints.gridwidth = 0;
        wrappingPanel.add((Component)new JPanel(), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        wrappingPanel.add((Component)new JLabel(irbsBundle.getString("ftpPathToTargetDirectory")), constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        wrappingPanel.add((Component)this.targetDirPathPanel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        ftpPanel.add((Component)wrappingPanel, constraints);
        JScrollPane scrollPane = new JScrollPane(ftpPanel);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 10, 5, 20);
        buttonPanel.add((Component)new JLabel(), constraints);
        this.okButton.addActionListener(this.createOkButtonListener(inputFileHandler, inputIsLogFile));
        String closeButtonText = irbsBundle.getString("ftpCloseButton");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        this.closeButton.addActionListener(this.createCloseButtonListener());
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        buttonPanel.add((Component)this.okButton, constraints);
        constraints.gridx = 2;
        buttonPanel.add((Component)this.closeButton, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)headerPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        mainPanel.add((Component)scrollPane, constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        mainPanel.add((Component)buttonPanel, constraints);
        this.setLocationRelativeTo(parent);
        this.enableOkButton();
        this.pack();
        Dimension currentDim = this.getSize();
        Dimension newDimension = new Dimension((int)((double)currentDim.width * 1.3), currentDim.height);
        this.setSize(newDimension);
        IrbsLogger.logExiting(this.getClass());
    }

    public final void close() {
        this.logFileBrowsePanel.removeValidityListener(this.okButtonListener);
        this.ftpServerPanel.removeValidityListener(this.okButtonListener);
        this.ftpUserPanel.removeValidityListener(this.okButtonListener);
        this.ftpPasswordPanel.removeValidityListener(this.okButtonListener);
        this.targetDirPathPanel.removeValidityListener(this.okButtonListener);
        this.dispose();
    }

    protected ValidatedFieldBrowsePanel getLogFileBrowsePanel() {
        return this.logFileBrowsePanel;
    }

    protected ValidatedFieldPanel getFtpServerPanel() {
        return this.ftpServerPanel;
    }

    protected ValidatedFieldPanel getFtpUserPanel() {
        return this.ftpUserPanel;
    }

    protected ValidatedFieldPanel getFtpPasswordPanel() {
        return this.ftpPasswordPanel;
    }

    protected ValidatedFieldPanel getTargetDirPathPanel() {
        return this.targetDirPathPanel;
    }

    protected LteButton getOkButton() {
        return this.okButton;
    }

    protected LteButton getCloseButton() {
        return this.closeButton;
    }

    private ActionListener createCloseButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                FtpUploadDialog.this.close();
            }
        };
    }

    private ActionListener createOkButtonListener(final FileHandler fileSaveChecker, final boolean localIsLogFile) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                FtpUploadDialog.this.uploadIsExecuting = true;
                FtpUploadDialog.this.enableOkButton();
                fileSaveChecker.checkFileForChangesAndSave();
                final UploadThread uploadThread = new UploadThread(localIsLogFile);
                Runnable uploadSupervisor = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = FtpUploadDialog.this.mutexObj;
                        synchronized (object) {
                            try {
                                FtpUploadDialog.this.mutexObj.wait(60000L);
                                if (FtpUploadDialog.this.uploadIsExecuting) {
                                    FtpUploadDialog.this.setStatusMessage(irbsBundle.getString("ftpTimedOut"), LteColor.WARNING_COLOR);
                                    FtpUploadDialog.this.uploadIsExecuting = false;
                                    String errorMessage = irbsBundle.getString("ftpTimedOut");
                                    IrbsLogger.logError(this.getClass(), errorMessage);
                                    ErrorDialog.displayError(null, irbsBundle.getString("ftpUploadReportFileErrorTitle"), errorMessage, irbsBundle.getString("ftpTimedOutDetailed"));
                                    FtpUploadDialog.this.enableOkButton();
                                }
                                uploadThread.interrupt();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                FtpUploadDialog.this.uploadSupervisingThread = new Thread(uploadSupervisor, "Upload Supervising Thread");
                FtpUploadDialog.this.uploadSupervisingThread.start();
                uploadThread.start();
            }
        };
    }

    private void enableOkButton() {
        boolean enable;
        boolean bl = enable = this.logFileBrowsePanel.validValue() && this.ftpUserPanel.validValue() && this.ftpPasswordPanel.validValue() && this.targetDirPathPanel.validValue();
        if (this.isLogFile) {
            enable = enable && this.ftpServerPanel.validValue();
        }
        this.okButton.setEnabled(enable && !this.uploadIsExecuting);
    }

    private class UploadThread
    extends Thread {
        private transient boolean threadStopped;
        private final transient boolean localIsLogFile;

        public UploadThread(boolean inputIsLogFile) {
            super("FTP Uploading Thread");
            this.threadStopped = false;
            this.localIsLogFile = inputIsLogFile;
        }

        public void interrupt() {
            this.threadStopped = true;
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.localIsLogFile) {
                try {
                    this.uploadLocalFile();
                }
                catch (IOException ioe) {
                    if (this.threadStopped) {
                        return;
                    }
                    FtpUploadDialog.this.setStatusMessage(irbsBundle.getString("ftpUploadLogFileErrorMessage"), LteColor.WARNING_COLOR);
                    String errorMessage = irbsBundle.getString("ftpUploadLogFileErrorMessage") + irbsBundle.getString("reasonLabel") + ": " + IrbsHelper.getExceptionMessage(ioe);
                    IrbsLogger.logError(this.getClass(), errorMessage, ioe);
                    ErrorDialog.displayError(null, irbsBundle.getString("ftpUploadLogFileErrorTitle"), errorMessage, IrbsHelper.convertToString(ioe));
                }
                finally {
                    FtpUploadDialog.this.uploadIsExecuting = false;
                    FtpUploadDialog.this.enableOkButton();
                    this.informSupervisor();
                }
            } else {
                FtpUploadDialog.this.setStatusMessage(irbsBundle.getString("ftpSavingReportFile"));
                try {
                    FtpUploadDialog.this.reportAndLogHandler.saveReportFile(FtpUploadDialog.this.fileHandler.getFileContents());
                    FtpUploadDialog.this.reportAndLogHandler.uploadReportFile(FtpUploadDialog.this.ftpServerPanel.getText(), FtpUploadDialog.this.ftpUserPanel.getText(), FtpUploadDialog.this.ftpPasswordPanel.getText(), FtpUploadDialog.this.targetDirPathPanel.getText());
                    if (this.threadStopped) {
                        return;
                    }
                    IrbsLogger.logInfo(this.getClass(), "Uploaded Report file, " + FtpUploadDialog.this.targetDirPathPanel.getText());
                    FtpUploadDialog.this.setStatusMessage(irbsBundle.getString("ftpSavedReportFile"));
                }
                catch (ReportFileException rfe) {
                    if (this.threadStopped) {
                        return;
                    }
                    FtpUploadDialog.this.setStatusMessage(irbsBundle.getString("ftpUploadReportFileErrorMessage"), LteColor.WARNING_COLOR);
                    String errorMessage = irbsBundle.getString("ftpUploadReportFileErrorMessage") + irbsBundle.getString("reasonLabel") + ": " + IrbsHelper.getExceptionMessage(rfe);
                    IrbsLogger.logError(this.getClass(), errorMessage, rfe);
                    ErrorDialog.displayError(null, irbsBundle.getString("ftpUploadReportFileErrorTitle"), errorMessage, IrbsHelper.convertToString(rfe));
                }
                finally {
                    FtpUploadDialog.this.uploadIsExecuting = false;
                    FtpUploadDialog.this.enableOkButton();
                    this.informSupervisor();
                }
            }
        }

        private void uploadLocalFile() throws IOException {
            FtpUploadDialog.this.setStatusMessage(irbsBundle.getString("ftpSavingLogFile"));
            FtpClient ftpClient = FtpClientFactory.getFtpClient(FtpUploadDialog.this.ftpServerPanel.getText(), FtpUploadDialog.this.ftpUserPanel.getText(), FtpUploadDialog.this.ftpPasswordPanel.getText());
            ftpClient.connect();
            ftpClient.bin();
            String parent = IrbsHelper.getParent(FtpUploadDialog.this.targetDirPathPanel.getText());
            if (parent.equals("")) {
                String currentDirectory;
                parent = currentDirectory = ftpClient.pwd();
            } else if (!parent.startsWith(FtpUploadDialog.UNIX_DELIMITER)) {
                String currentDirectory = ftpClient.pwd();
                parent = currentDirectory + FtpUploadDialog.UNIX_DELIMITER + parent;
            }
            ftpClient.mkdirs(parent);
            ftpClient.cwd(parent);
            if (this.threadStopped) {
                return;
            }
            ftpClient.upload(FtpUploadDialog.this.logFileBrowsePanel.getText(), FtpUploadDialog.this.targetDirPathPanel.getText());
            if (this.threadStopped) {
                return;
            }
            IrbsLogger.logInfo(this.getClass(), "Uploaded Log file, " + FtpUploadDialog.this.logFileBrowsePanel.getText() + ", to, " + FtpUploadDialog.this.targetDirPathPanel.getText());
            FtpUploadDialog.this.setStatusMessage(irbsBundle.getString("ftpSavedLogFile"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void informSupervisor() {
            Object object = FtpUploadDialog.this.mutexObj;
            synchronized (object) {
                try {
                    FtpUploadDialog.this.mutexObj.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

