/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteFrame;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.CustomIconRenderer;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.DetailedInformationDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.IntegrationProcess;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ProgressTreeModel;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationEvent;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationHandler;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationListener;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportData;

public class ProgressDialog
extends AbstractLteFrame
implements IrbsNotificationListener,
TreeSelectionListener {
    private static final int HEADER_FONT_SIZE = 16;
    private static final int FONT_SIZE = 12;
    private static final int DETAILED_INFO_MAX_LENGTH = 55;
    private static final ResourceBundle IRBS_BUNDLE = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private ProgressTreeModel model;
    private final transient JLabel configLabel;
    private final transient JLabel configMessageLabel;
    private final transient JLabel progressMessageLabel;
    private final transient JLabel progressLevelLabel;
    private final transient LteButton closeButton;
    private final transient LteButton detailedButton;
    private final transient JTree detailedProgressTree;
    private final transient Frame parent;
    private String selectedNodeName;
    private ProgressReportData currentProgressReportData;
    private int progressLevel = 0;
    private final transient IrbsNotificationHandler irbsNotificationHandler;

    public ProgressDialog(Frame inputParent, IrbsNotificationHandler inputIrbsNotificationHandler) throws ImageHelper.ResourceException, IrbsException {
        super(IRBS_BUNDLE.getString("progressTitle"), true);
        this.parent = inputParent;
        IrbsLogger.logEntering(this.getClass());
        this.irbsNotificationHandler = inputIrbsNotificationHandler;
        this.irbsNotificationHandler.addNotificationListener(this);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = new JLabel(IRBS_BUNDLE.getString("progressProgressInfo"));
        Font headerFont = new Font("*Helvetica*", 3, 16);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        constraints.anchor = 17;
        this.configLabel = new JLabel();
        this.configMessageLabel = new JLabel();
        this.progressLevelLabel = new JLabel();
        this.progressMessageLabel = new JLabel();
        this.detailedProgressTree = this.createProgressInformationTree();
        String detailedButtonText = IRBS_BUNDLE.getString("progressDetailedButton");
        this.detailedButton = new LteButton(detailedButtonText);
        this.detailedButton.setPreferredSize(new Dimension(170, 26));
        this.detailedButton.setMnemonic(detailedButtonText.charAt(0));
        this.detailedButton.addActionListener(this.createDetailedButtonListener());
        this.detailedButton.setEnabled(false);
        JPanel progressTreePanel = this.createProgressInformationTreePanel(this.detailedProgressTree);
        JPanel configurationLevelPanel = this.createConfigurationLevelPanel(this.configLabel, this.configMessageLabel);
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 10, 10, 10);
        JPanel progressPanel = this.createProgressPanel(this.progressLevelLabel, this.progressMessageLabel);
        JPanel commonPanel = new JPanel(new GridBagLayout());
        constraints.weighty = 0.0;
        commonPanel.setBorder(new EtchedBorder());
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 5, 2, 5);
        commonPanel.add((Component)configurationLevelPanel, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(2, 5, 2, 5);
        commonPanel.add((Component)progressPanel, constraints);
        ++constraints.gridy;
        int commonPanelGridY = constraints.gridy;
        constraints.weighty = 1.0;
        commonPanel.add((Component)new JLabel(), constraints);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        String closeButtonText = IRBS_BUNDLE.getString("progressCloseButton");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        buttonPanel.add((Component)new JLabel(), constraints);
        this.closeButton.addActionListener(this.createCloseButtonListener());
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.insets = new Insets(2, 10, 5, 10);
        buttonPanel.add((Component)this.closeButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = commonPanelGridY + 1;
        buttonPanel.add((Component)new JLabel(), constraints);
        constraints.weighty = 0.0;
        ++constraints.gridy;
        commonPanel.add((Component)buttonPanel, constraints);
        constraints.gridheight = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)progressTreePanel, constraints);
        constraints.weightx = 0.5;
        constraints.gridheight = 1;
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets = new Insets(9, 2, 0, 2);
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.weighty = 0.0;
        mainPanel.add((Component)headerPanel, constraints);
        constraints.anchor = 10;
        constraints.fill = 1;
        ++constraints.gridy;
        constraints.insets = new Insets(2, 2, 3, 2);
        constraints.weighty = 1.0;
        mainPanel.add((Component)commonPanel, constraints);
        this.statusBar.setStaticStatusMessage("0 %", 2);
        this.update();
        this.pack();
        Dimension dim = this.getSize();
        this.setSize(new Dimension((int)((double)dim.width * 1.2), (int)((double)dim.height * 1.1)));
        this.setLocationRelativeTo(inputParent);
        IrbsLogger.logExiting(this.getClass());
    }

    public final void update() {
        this.irbsNotificationHandler.update();
    }

    private void checkAndHandleNewRevision(ProgressReportData progressReportData) {
        if ((((TreeNode)this.model.getRoot()).getChildCount() == 0 || !this.model.getRevision().equals(progressReportData.getRevision()) && !"".equals(progressReportData.getRevision())) && progressReportData.getProgressTreeNodes() != null) {
            this.model.setNewTree(progressReportData.getProgressTreeNodes());
            this.model.expandAll(true, this.detailedProgressTree);
            this.model.setRevision(progressReportData.getRevision());
        }
    }

    private JPanel createConfigurationLevelPanel(JLabel localConfigLabel, JLabel localConfigMessageLabel) {
        JPanel configurationLevelPanel = new JPanel(new GridBagLayout());
        Font labelFont = new Font("*Helvetica*", 1, 12);
        Font progressFont = new Font("*Helvetica*", 2, 12);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        configurationLevelPanel.setBorder(new TitledBorder(new EtchedBorder(), IRBS_BUNDLE.getString("progressConfigLevel")));
        JLabel levelLabel = new JLabel(IRBS_BUNDLE.getString("progressLabel"));
        levelLabel.setFont(labelFont);
        configurationLevelPanel.add((Component)levelLabel, constraints);
        localConfigLabel.setFont(progressFont);
        configurationLevelPanel.add((Component)localConfigLabel, constraints);
        constraints.weightx = 1.0;
        configurationLevelPanel.add((Component)new JLabel(), constraints);
        JLabel levelMessageLabel = new JLabel(IRBS_BUNDLE.getString("progressMessageLabel"));
        constraints.weightx = 0.0;
        ++constraints.gridy;
        levelMessageLabel.setFont(labelFont);
        configurationLevelPanel.add((Component)levelMessageLabel, constraints);
        localConfigMessageLabel.setFont(progressFont);
        configurationLevelPanel.add((Component)localConfigMessageLabel, constraints);
        constraints.weightx = 1.0;
        configurationLevelPanel.add((Component)new JLabel(), constraints);
        return configurationLevelPanel;
    }

    private JTree createProgressInformationTree() {
        CustomIconRenderer cellRenderer = new CustomIconRenderer(this.getBackground());
        cellRenderer.setBackground(this.getBackground());
        IntegrationProcess rootNode = new IntegrationProcess("IntegrationProcess", IntegrationProcess.State.TOP_NODE_NOT_EXECUTING);
        JTree progressTree = new JTree(){

            public String getToolTipText(MouseEvent evt) {
                if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
                    return null;
                }
                TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
                return ((IntegrationProcess)curPath.getLastPathComponent()).getToolTipText();
            }
        };
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (ProgressDialog.this.currentProgressReportData != null && e.getClickCount() == 2 && ProgressDialog.this.currentProgressReportData.isLeaf(ProgressDialog.this.selectedNodeName)) {
                    ProgressDialog.this.showDetailedInformationDialog();
                }
            }
        };
        progressTree.addMouseListener(ml);
        ToolTipManager.sharedInstance().registerComponent(progressTree);
        progressTree.addTreeSelectionListener(this);
        this.model = new ProgressTreeModel();
        this.model.setNewTree(rootNode);
        progressTree.setModel(this.model);
        progressTree.setCellRenderer(cellRenderer);
        progressTree.setShowsRootHandles(false);
        progressTree.setRootVisible(true);
        this.model.expandAll(true, progressTree);
        progressTree.setBackground(this.getBackground());
        return progressTree;
    }

    private JPanel createProgressInformationTreePanel(JTree progressTree) {
        JPanel progressTreePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 1, 1, 1);
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        progressTreePanel.setBorder(new TitledBorder(new EtchedBorder(), IRBS_BUNDLE.getString("progressDetailedProgress")));
        JScrollPane progresstreeView = new JScrollPane(progressTree);
        progressTreePanel.add((Component)progresstreeView, constraints);
        progresstreeView.setPreferredSize(new Dimension(250, 600));
        constraints.fill = 0;
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        progressTreePanel.add((Component)this.detailedButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.8;
        progressTreePanel.add((Component)new JLabel(), constraints);
        return progressTreePanel;
    }

    private JPanel createProgressPanel(JLabel localProgressLevelLabel, JLabel localProgressMessageLabel) {
        JPanel progressLevelPanel = new JPanel(new GridBagLayout());
        Font labelFont = new Font("*Helvetica*", 1, 12);
        Font progressFont = new Font("*Helvetica*", 2, 12);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        progressLevelPanel.setBorder(new TitledBorder(new EtchedBorder(), IRBS_BUNDLE.getString("progressTitle")));
        JLabel levelLabel = new JLabel(IRBS_BUNDLE.getString("progressLabel"));
        levelLabel.setFont(labelFont);
        progressLevelPanel.add((Component)levelLabel, constraints);
        localProgressLevelLabel.setFont(progressFont);
        progressLevelPanel.add((Component)localProgressLevelLabel, constraints);
        constraints.weightx = 1.0;
        progressLevelPanel.add((Component)new JLabel(), constraints);
        JLabel levelMessageLabel = new JLabel(IRBS_BUNDLE.getString("progressMessageLabel"));
        constraints.weightx = 0.0;
        ++constraints.gridy;
        levelMessageLabel.setFont(labelFont);
        progressLevelPanel.add((Component)levelMessageLabel, constraints);
        localProgressMessageLabel.setFont(progressFont);
        progressLevelPanel.add((Component)localProgressMessageLabel, constraints);
        constraints.weightx = 1.0;
        progressLevelPanel.add((Component)new JLabel(), constraints);
        return progressLevelPanel;
    }

    private ActionListener createCloseButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ProgressDialog.this.close();
            }
        };
    }

    private ActionListener createDetailedButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ProgressDialog.this.showDetailedInformationDialog();
            }
        };
    }

    protected LteButton getCloseButton() {
        return this.closeButton;
    }

    protected LteButton getDetailedButton() {
        return this.detailedButton;
    }

    protected JTree getDetailedProgressTree() {
        return this.detailedProgressTree;
    }

    protected JLabel getConfigLabel() {
        return this.configLabel;
    }

    protected JLabel getConfigMessageLabel() {
        return this.configMessageLabel;
    }

    protected JLabel getProgressLevelLabel() {
        return this.progressLevelLabel;
    }

    protected JProgressBar getProgressBar() {
        return (JProgressBar)this.statusBar.getComponent();
    }

    public void notificationReceived(final IrbsNotificationEvent notificationEvent) {
        if (notificationEvent.progressReportData.getProgressLevel() != -1) {
            Runnable notificationUpdater = new Runnable(){

                public void run() {
                    IrbsLogger.logEntering(this.getClass());
                    if (!notificationEvent.progressReportData.getIntegrationStep().isEmpty()) {
                        ProgressDialog.this.currentProgressReportData = notificationEvent.progressReportData;
                        ProgressDialog.this.checkAndHandleNewRevision(ProgressDialog.this.currentProgressReportData);
                        ProgressDialog.this.model.updateTree(ProgressDialog.this.currentProgressReportData.getIntegrationStep());
                    }
                    if (!notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupName().equals("")) {
                        ProgressDialog.this.configLabel.setText(notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupName());
                        ProgressDialog.this.configMessageLabel.setText(notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupMessage());
                    }
                    ProgressDialog.this.setProgressMessages(notificationEvent);
                    ProgressDialog.this.setProgressLevel(notificationEvent);
                    IrbsLogger.logExiting(this.getClass());
                }
            };
            IrbsHelper.invokeLater(notificationUpdater);
        }
    }

    private void setProgressLevel(IrbsNotificationEvent notificationEvent) {
        int newProgressLevel = notificationEvent.progressReportData.getProgressLevel();
        if (newProgressLevel == 0 || newProgressLevel != -1 && newProgressLevel >= this.progressLevel) {
            this.setProgress(newProgressLevel);
            this.statusBar.setStaticStatusMessage(Integer.toString(this.progressLevel) + " %", 2);
        }
    }

    private void setProgressMessages(IrbsNotificationEvent notificationEvent) {
        if (!notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentStepName().equals("")) {
            this.progressLevelLabel.setText(notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentStepName());
            String stepMessage = notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentStepMessage();
            if (stepMessage.length() > 55) {
                this.progressMessageLabel.setText(stepMessage.substring(0, 55) + "...");
            } else {
                this.progressMessageLabel.setText(stepMessage);
            }
        }
    }

    public void resetProgressInformation() {
        this.configLabel.setText("");
        this.configMessageLabel.setText("");
        this.progressLevelLabel.setText("");
        this.progressMessageLabel.setText("");
    }

    public void setProgress(int inputProgressLevel) {
        this.progressLevel = inputProgressLevel;
        this.statusBar.setProgressValue(inputProgressLevel);
    }

    private void showDetailedInformationDialog() {
        String detailedInformationText = "";
        if (this.currentProgressReportData != null) {
            detailedInformationText = this.currentProgressReportData.getDetailedInformationText(this.selectedNodeName);
        }
        IrbsLogger.logEntering(this.getClass());
        try {
            DetailedInformationDialog detailedInformationDialog = new DetailedInformationDialog(this.parent, IRBS_BUNDLE.getString("detailedInformationTitle"), IRBS_BUNDLE.getString("detailedInformationHeaderIntro") + " " + this.selectedNodeName, detailedInformationText);
            detailedInformationDialog.setVisible(true);
        }
        catch (Exception e) {
            IrbsLogger.logError(this.getClass(), "Could not create the detailed information dialog. Reason: " + e.toString());
        }
        IrbsLogger.logExiting(this.getClass());
    }

    public final void close() {
        IrbsLogger.logEntering(this.getClass());
        this.irbsNotificationHandler.removeNotificationListener(this);
        this.dispose();
        IrbsLogger.logExiting(this.getClass());
    }

    public void valueChanged(TreeSelectionEvent event) {
        if (this.detailedProgressTree.getLastSelectedPathComponent() == null) {
            this.detailedButton.setEnabled(false);
            this.selectedNodeName = "";
        } else {
            this.detailedButton.setEnabled(true);
            this.selectedNodeName = this.detailedProgressTree.getLastSelectedPathComponent().toString();
        }
    }
}

