/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.IntegrationProcess;
import se.ericsson.lte.rbs.omf.em.irbs.parser.IntegrationStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressTreeModel
implements TreeModel {
    private String revision = "";
    private DefaultMutableTreeNode theTree;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void expandAll(boolean expand, JTree tree) {
        TreeNode root = this.theTree.getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public String getRevision() {
        return this.revision;
    }

    @Override
    public Object getRoot() {
        return this.theTree.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean isLeaf = true;
        TreeNode treeNode = (TreeNode)node;
        if (treeNode.getChildCount() > 0) {
            isLeaf = false;
        }
        return isLeaf;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    public void setNewTree(DefaultMutableTreeNode progressTreeNodes) {
        this.theTree = progressTreeNodes;
        TreeModelEvent evt = new TreeModelEvent((Object)this, new TreePath(this.getRoot()));
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(evt);
        }
    }

    public void setRevision(String newRevision) {
        this.revision = newRevision;
    }

    public void updateTree(Map<String, IntegrationStep> progressReportData) {
        TreeNode root = this.theTree.getRoot();
        this.updateLeaf(new TreePath(root), progressReportData);
        TreeModelEvent evt = new TreeModelEvent((Object)this, new TreePath(this.getRoot()));
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(evt);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException();
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void updateLeaf(TreePath parent, Map<String, IntegrationStep> progressReportData) {
        String keyName;
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.updateLeaf(path, progressReportData);
            }
        }
        if (progressReportData.containsKey(keyName = ((IntegrationProcess)node).toString())) {
            IntegrationProcess.State value = progressReportData.get(keyName).getStatus();
            ((IntegrationProcess)node).setStatus(value);
        }
    }
}

